/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MWindow;

public class GCalendar
extends GWidget {
    static final int LEFT_GAP = 5;
    static final int RIGHT_GAP = 5;
    static final int TOP_GAP = 20;
    static final byte BG = 0;
    static final byte WEEKEND_BG = 0;
    static final byte NEIGHBOR_MONTH_DATE = 2;
    static final byte HIGHLIGHT = 3;
    static final byte UNSELECTABLE = 4;
    static final byte MAX_COLORS = 5;
    static final byte MAX_CAL_CELLS = 42;
    private int iCellWidth = 0;
    private int iCellHeight = 0;
    private int iCalendarWidth = 0;
    private int iCalendarHeight = 0;
    private int iWeekStart = 0;
    private int iTopSpace = 0;
    private int iBottomMargin = 0;
    private int userWidth = 0;
    private int userHeight = 0;
    private byte cbHighlightedCell = (byte)-1;
    private Date dMin = null;
    private Date dMax = null;
    private Date dInitial = null;
    private String sWeekNames = null;
    private Choice months = null;
    private Choice years = null;
    private Color[] cCalendar = new Color[5];
    private calendarCell[] Cell = new calendarCell[42];

    public GCalendar(Object parent, String name, int flags, MessageHandler mh) {
        super("GCalendar", parent, name, flags, mh);
        this.open(name);
        this.addTo(parent);
    }

    public void open(String name) {
        super.open();
        Calendar calInitial = Calendar.getInstance();
        this.months = new Choice();
        this.years = new Choice();
        this.cCalendar[0] = new Color(Color.lightGray.getRGB());
        this.cCalendar[0] = new Color(this.cCalendar[0].getRGB());
        this.cCalendar[2] = new Color(Color.gray.getRGB());
        this.cCalendar[3] = new Color(Color.red.getRGB());
        this.cCalendar[4] = new Color(Color.white.getRGB());
        this.sWeekNames = new String("S M T W T F S");
        this.iWeekStart = 1;
        int iMinYear = 2000;
        int iMaxYear = 2100;
        for (int i = iMinYear; i <= iMaxYear; ++i) {
            this.years.addItem(String.valueOf(i));
        }
        this.dMin = new Date();
        this.dMin = this.assignDateOf(2000, 0, 1);
        if (iMinYear > this.GetDateEntity(this.dMin, 1)) {
            this.dMin = this.assignDateOf(iMinYear, 0, 1);
        }
        this.dMax = new Date();
        this.dMax = this.assignDateOf(2100, 11, 31);
        if (iMaxYear < this.GetDateEntity(this.dMax, 1)) {
            this.dMax = this.assignDateOf(iMaxYear, 11, 31);
        }
        this.dInitial = new Date();
        Calendar calToday = Calendar.getInstance();
        this.dInitial = calToday.getTime();
        String sBuffer = new String("January February March April May June July August September October November December");
        StringTokenizer stMonths = new StringTokenizer(sBuffer, " ");
        while (stMonths.hasMoreTokens()) {
            this.months.addItem(stMonths.nextToken());
        }
        this.iTopSpace = 30;
        this.iBottomMargin = 5;
        calInitial.setTime(this.dInitial);
        this.years.select(String.valueOf(calInitial.get(1)));
        this.months.select(calInitial.get(2));
        for (int i = 0; i < 42; ++i) {
            this.Cell[i] = new calendarCell();
            this.Cell[i].date = new Date();
            if (i % 7 != (7 - this.iWeekStart) % 7 && i % 7 != (8 - this.iWeekStart) % 7) continue;
            this.Cell[i].bWeekend = true;
        }
        this.userHeight = 120;
        this.userWidth = 120;
        this.SetCellDates();
        this.setup();
    }

    @Override
    public void setup() {
        if (this.userWidth != 0 && this.userHeight != 0) {
            this.pos.w = this.userWidth;
            this.pos.h = this.userHeight;
        }
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        int iOffset;
        String sBuffer;
        super.paintComponent(g);
        if (g == null) {
            return;
        }
        MBox d = this.pos;
        if (this.parent instanceof MWindow) {
            if (this.userWidth == 0) {
                d.h = d.w = this.pos.w - 5;
            } else {
                d.w = this.userWidth;
                d.h = this.userHeight;
            }
        } else if (this.parent instanceof Container && this.userWidth != 0) {
            d.w = this.userWidth;
            d.h = this.userHeight;
        }
        this.iCellWidth = (d.w - 5 - 5) / 7;
        this.iCellHeight = (d.h - this.iTopSpace - this.iBottomMargin) / 6;
        this.iCalendarWidth = this.iCellWidth * 7;
        this.iCalendarHeight = this.iCellHeight * 6;
        g.setColor(Color.white);
        g.drawLine(0, 0, d.w, 0);
        g.drawLine(0, 1, d.w, 1);
        g.drawLine(0, 2, d.w, 2);
        g.drawLine(0, 0, 0, d.h);
        g.drawLine(1, 0, 1, d.h);
        g.drawLine(2, 0, 2, d.h);
        g.setColor(this.cCalendar[0].darker());
        g.drawLine(2, d.h - 3, d.w, d.h - 3);
        g.drawLine(1, d.h - 2, d.w, d.h - 2);
        g.drawLine(0, d.h - 1, d.w, d.h - 1);
        g.drawLine(d.w - 1, 0, d.w - 1, d.h);
        g.drawLine(d.w - 2, 1, d.w - 2, d.h);
        g.drawLine(d.w - 3, 2, d.w - 3, d.h);
        g.setColor(this.cCalendar[0]);
        g.fillRect(3, 3, d.w - 6, d.h - 6);
        g.setColor(this.cCalendar[0]);
        g.fillRect(5 + this.iCellWidth * ((7 - this.iWeekStart) % 7), this.iTopSpace, this.iCellWidth, this.iCalendarHeight);
        g.fillRect(5 + this.iCellWidth * ((8 - this.iWeekStart) % 7), this.iTopSpace, this.iCellWidth, this.iCalendarHeight);
        Font fontWeeknames = new Font("Helvetica", 0, 12);
        g.setFont(fontWeeknames);
        FontMetrics fm = g.getFontMetrics();
        StringTokenizer stWeekNames = new StringTokenizer(this.sWeekNames, " ");
        int i = 0;
        while (stWeekNames.hasMoreTokens()) {
            sBuffer = stWeekNames.nextToken();
            iOffset = fm.stringWidth(sBuffer) / 2;
            g.setColor(Color.white);
            g.drawString(sBuffer, 5 + i * this.iCellWidth + this.iCellWidth / 2 - iOffset, this.iTopSpace - 2 - 1);
            g.setColor(this.cCalendar[0].darker());
            g.drawString(sBuffer, 5 + i * this.iCellWidth + this.iCellWidth / 2 + 1 - iOffset, this.iTopSpace - 2);
            ++i;
        }
        sBuffer = this.months.getSelectedItem() + " " + this.years.getSelectedItem();
        iOffset = fm.stringWidth(sBuffer) / 2;
        g.setColor(this.cCalendar[2]);
        g.drawString(sBuffer, 5, this.iTopSpace / 2);
        g.setColor(this.cCalendar[2].darker());
        g.drawString(sBuffer, 6, this.iTopSpace / 2 + 1);
        g.setColor(Color.white);
        for (i = 1; i < 7; ++i) {
            g.drawLine(5, this.iTopSpace + i * this.iCellHeight - 1, 5 + this.iCalendarWidth - 1, this.iTopSpace + i * this.iCellHeight - 1);
        }
        for (i = 1; i < 8; ++i) {
            g.drawLine(5 + i * this.iCellWidth - 1, this.iTopSpace, 5 + i * this.iCellWidth - 1, this.iTopSpace + this.iCalendarHeight - 1);
        }
        g.setColor(this.cCalendar[0].darker());
        for (i = 0; i < 6; ++i) {
            g.drawLine(5, this.iTopSpace + i * this.iCellHeight, 5 + this.iCalendarWidth - 1, this.iTopSpace + i * this.iCellHeight);
        }
        for (i = 0; i < 7; ++i) {
            g.drawLine(5 + i * this.iCellWidth, this.iTopSpace, 5 + i * this.iCellWidth, this.iTopSpace + this.iCalendarHeight - 1);
        }
        Font fontDates = new Font("Helvetica", 1, (int)((double)this.iCellHeight * 0.7));
        g.setFont(fontDates);
        this.DrawDates(g);
        if (this.cbHighlightedCell == -1) {
            Calendar calInital = Calendar.getInstance();
            calInital.setTime(this.dInitial);
            Calendar calCurrent = Calendar.getInstance();
            for (i = 0; i < 42; ++i) {
                calCurrent.setTime(this.Cell[i].date);
                if (calInital.get(2) == calCurrent.get(2) && calInital.get(5) == calCurrent.get(5)) break;
            }
            this.cbHighlightedCell = (byte)i;
        }
        if (this.Cell[this.cbHighlightedCell].bSelectable) {
            this.highlightCell(g, this.cbHighlightedCell, this.cCalendar[3]);
        }
    }

    @Override
    public int processEventMessage(String name, int info, Object data) {
        block7: {
            block8: {
                if (!name.equals("BUTTON")) {
                    return -1;
                }
                if (info != 1) break block8;
                int x = this.px;
                int y = this.py;
                byte iClickedCell = this.getCellNumber(x, y);
                if (iClickedCell < 0) {
                    return -1;
                }
                Date dBuffer = this.Cell[iClickedCell].date;
                long iTotalDaysUntildBuffer = this.GetTotalDaysUntil(dBuffer);
                try {
                    block10: {
                        block9: {
                            if (x <= 5 || x >= 5 + this.iCalendarWidth || y <= this.iTopSpace || y >= this.iTopSpace + this.iCalendarHeight || !this.Cell[iClickedCell].bSelectable) break block7;
                            if (this.months.getSelectedIndex() != this.GetDateEntity(dBuffer, 2)) break block9;
                            this.cbHighlightedCell = this.getCellNumber(x, y);
                            if (!this.Cell[this.cbHighlightedCell].bSelectable) break block10;
                            DecimalFormat decFormat = new DecimalFormat();
                            decFormat.setMinimumIntegerDigits(2);
                            String tstr = this.GetDateEntity(this.Cell[this.cbHighlightedCell].date, 1) + ":" + decFormat.format(this.GetDateEntity(this.Cell[this.cbHighlightedCell].date, 2) + 1) + ":" + decFormat.format(this.GetDateEntity(this.Cell[this.cbHighlightedCell].date, 5));
                            this.sendWidgetMessage(this.label, 0, tstr);
                            if (!this.is(1)) {
                                this.close();
                            }
                            break block10;
                        }
                        this.years.select(String.valueOf(this.GetDateEntity(dBuffer, 1)));
                        this.months.select(this.GetDateEntity(dBuffer, 2));
                        this.SetCellDates();
                        for (int i = 0; i < 42; i = (int)((byte)(i + 1))) {
                            if (this.GetTotalDaysUntil(this.Cell[i].date) != iTotalDaysUntildBuffer) continue;
                            this.cbHighlightedCell = (byte)i;
                            break;
                        }
                    }
                    this.refresh();
                }
                catch (Exception ex) {
                    this.M.warning("Exception " + ex + " in GCalendar");
                }
                break block7;
            }
            if (info == 3 && !this.is(1)) {
                this.close();
            }
        }
        return 1;
    }

    @Override
    public Object setKey(String key, Object value) {
        return value;
    }

    @Override
    public Object getKey(String key) {
        String value = null;
        if (key.equals("DATE")) {
            value = this.getDate();
        } else if (key.equals("MONTH")) {
            DecimalFormat decFormat = new DecimalFormat();
            decFormat.setMinimumIntegerDigits(2);
            value = decFormat.format(this.GetDateEntity(this.Cell[this.cbHighlightedCell].date, 2) + 1);
        } else if (key.equals("YEAR")) {
            value = Integer.toString(this.GetDateEntity(this.Cell[this.cbHighlightedCell].date, 1));
        } else if (key.equals("DAY")) {
            DecimalFormat decFormat = new DecimalFormat();
            decFormat.setMinimumIntegerDigits(2);
            value = decFormat.format(this.GetDateEntity(this.Cell[this.cbHighlightedCell].date, 5));
        }
        return value;
    }

    private Date assignDateOf(int iYear, int iMonth, int iDate) {
        Calendar calBuf = Calendar.getInstance();
        calBuf.set(iYear, iMonth, iDate);
        return calBuf.getTime();
    }

    public int GetDateEntity(Date dBuffer, int iEntity) {
        Calendar calBuf = Calendar.getInstance();
        calBuf.setTime(dBuffer);
        return calBuf.get(iEntity);
    }

    private void SetCellDates() {
        long lTotalDaysUptoDate;
        int i;
        Date dBuffer = new Date();
        Calendar calBuffer = Calendar.getInstance();
        int iCounter = 0;
        long lTotalDaysUpto_dMin = this.GetTotalDaysUntil(this.dMin);
        long lTotalDaysUpto_dMax = this.GetTotalDaysUntil(this.dMax);
        int iSelectedYear = Integer.parseInt(this.years.getSelectedItem());
        int iSelectedMonth = this.months.getSelectedIndex();
        dBuffer = this.assignDateOf(iSelectedYear, iSelectedMonth, 1);
        dBuffer = this.GetWeekBeginDate(dBuffer);
        calBuffer.setTime(dBuffer);
        int iNumDaysInMonth = this.GetMonthDays(calBuffer.get(1), calBuffer.get(2));
        if (calBuffer.get(5) != 1) {
            for (i = calBuffer.get(5); i <= iNumDaysInMonth; ++i) {
                this.Cell[iCounter].date = this.assignDateOf(calBuffer.get(1), calBuffer.get(2), i);
                lTotalDaysUptoDate = this.GetTotalDaysUntil(calBuffer.get(1), calBuffer.get(2), i);
                this.Cell[iCounter].bSelectable = lTotalDaysUptoDate >= lTotalDaysUpto_dMin && lTotalDaysUptoDate <= lTotalDaysUpto_dMax;
                ++iCounter;
            }
        }
        dBuffer = this.assignDateOf(iSelectedYear, iSelectedMonth, 1);
        calBuffer.setTime(dBuffer);
        iNumDaysInMonth = this.GetMonthDays(iSelectedYear, iSelectedMonth);
        for (i = 1; i <= iNumDaysInMonth; ++i) {
            this.Cell[iCounter].date = this.assignDateOf(iSelectedYear, iSelectedMonth, i);
            lTotalDaysUptoDate = this.GetTotalDaysUntil(iSelectedYear, iSelectedMonth, i);
            this.Cell[iCounter].bSelectable = lTotalDaysUptoDate >= lTotalDaysUpto_dMin && lTotalDaysUptoDate <= lTotalDaysUpto_dMax;
            ++iCounter;
        }
        calBuffer.set(iSelectedYear, iSelectedMonth + 1, 1);
        i = 1;
        while (iCounter < 42) {
            this.Cell[iCounter].date = this.assignDateOf(calBuffer.get(1), calBuffer.get(2), i);
            lTotalDaysUptoDate = this.GetTotalDaysUntil(calBuffer.get(1), calBuffer.get(2), i);
            this.Cell[iCounter].bSelectable = lTotalDaysUptoDate >= lTotalDaysUpto_dMin && lTotalDaysUptoDate <= lTotalDaysUpto_dMax;
            ++iCounter;
            ++i;
        }
    }

    private void DrawDates(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int iVertOffset = fm.getHeight() / 2 - fm.getMaxDescent() + 1;
        for (int i = 0; i < 42; ++i) {
            String sBuffer = String.valueOf(this.GetDateEntity(this.Cell[i].date, 5));
            int iHorizOffset = fm.stringWidth(sBuffer) / 2;
            if (!this.Cell[i].bSelectable) {
                g.setColor(this.cCalendar[4]);
            } else if (this.GetDateEntity(this.Cell[i].date, 2) != this.months.getSelectedIndex()) {
                g.setColor(this.cCalendar[2]);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(sBuffer, 5 + i % 7 * this.iCellWidth + this.iCellWidth / 2 - iHorizOffset, this.iTopSpace + i / 7 * this.iCellHeight + this.iCellHeight / 2 + iVertOffset);
        }
    }

    public int GetDayFromDate(int iYear, int iMonth, int iDate) {
        return ((int)(this.GetTotalDaysUntil(iYear, iMonth, iDate) % 7L) + (7 - this.iWeekStart)) % 7;
    }

    public long GetTotalDaysUntil(Date dBuffer) {
        Calendar calBuffer = Calendar.getInstance();
        calBuffer.setTime(dBuffer);
        return this.GetTotalDaysUntil(calBuffer);
    }

    public long GetTotalDaysUntil(Calendar calBuffer) {
        return this.GetTotalDaysUntil(calBuffer.get(1), calBuffer.get(2), calBuffer.get(5));
    }

    public long GetTotalDaysUntil(int iYear, int iMonth, int iDate) {
        long lTotal = 0L;
        int[] iDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (iYear < 1 || iYear > 9999 || ++iMonth < 1 || iMonth > 12) {
            return -1L;
        }
        lTotal = (long)(iYear - 1) * 365L + (long)(iYear - 1) / 4L;
        if (iYear > 1752) {
            lTotal -= 11L;
            lTotal -= (long)((iYear - 1) / 100 - 17);
            lTotal += (long)((iYear - 1) / 400 - 4);
        }
        for (int i = 1; i < iMonth; ++i) {
            lTotal += this.IsLeapYear(iYear) && i == 2 ? 29L : (long)iDays[i - 1];
        }
        return lTotal += (long)(iDate - 1);
    }

    public boolean IsLeapYear(int iYear) {
        if (iYear % 4 > 0) {
            return false;
        }
        if (iYear > 1752 && iYear % 100 == 0) {
            return iYear % 400 == 0;
        }
        return true;
    }

    public int GetMonthDays(int iYear, int iMonth) {
        int[] iDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        return iMonth == 1 && this.IsLeapYear(iYear) ? 29 : iDays[iMonth];
    }

    public Date GetWeekBeginDate(Date d) {
        Calendar calBuffer = Calendar.getInstance();
        boolean bReturn = true;
        calBuffer.setTime(d);
        int iNewDate = calBuffer.get(5);
        int iNewMonth = calBuffer.get(2);
        int iNewYear = calBuffer.get(1);
        long lTotalDays = this.GetTotalDaysUntil(iNewYear, iNewMonth, iNewDate);
        int iDay = this.GetDayFromDate(iNewYear, iNewMonth, iNewDate);
        long lTotalDaysUntilWeekBeginDate = lTotalDays - (long)iDay;
        if ((iNewDate -= iDay) < 1) {
            iNewDate = 21;
            --iNewMonth;
        }
        if (iNewMonth < 0) {
            iNewMonth = 11;
            --iNewYear;
        }
        while (lTotalDaysUntilWeekBeginDate != this.GetTotalDaysUntil(iNewYear, iNewMonth, iNewDate)) {
            if (++iNewDate <= 31) continue;
            bReturn = false;
            break;
        }
        if (bReturn) {
            calBuffer.set(iNewYear, iNewMonth, iNewDate);
            d = calBuffer.getTime();
        }
        return d;
    }

    public Date getSelection() {
        if (this.Cell[this.cbHighlightedCell].bSelectable) {
            return this.Cell[this.cbHighlightedCell].date;
        }
        return null;
    }

    public void getSelection(int iYear, int iMonth, int iDate) {
        Calendar calBuffer = Calendar.getInstance();
        calBuffer.setTime(this.getSelection());
        iYear = calBuffer.get(1);
        iMonth = calBuffer.get(2);
        iDate = calBuffer.get(5);
    }

    public void getSelection(String sYear, String sMonth, String sDate) {
        int iYear = 0;
        int iMonth = 0;
        int iDate = 0;
        this.getSelection(iYear, iMonth, iDate);
        sYear = String.valueOf(iYear);
        sMonth = String.valueOf(iMonth);
        sDate = String.valueOf(iDate);
    }

    public int getSelectedYear() {
        return this.GetDateEntity(this.getSelection(), 1);
    }

    public int getSelectedMonth() {
        return this.GetDateEntity(this.getSelection(), 2) + 1;
    }

    public int getSelectedDate() {
        return this.GetDateEntity(this.getSelection(), 5);
    }

    public void setDate(int iYear, int iMonth, int iDOM) {
        int i;
        Calendar calInitial = Calendar.getInstance();
        this.dInitial = this.assignDateOf(iYear, --iMonth, iDOM);
        calInitial.setTime(this.dInitial);
        this.years.select(String.valueOf(calInitial.get(1)));
        this.months.select(calInitial.get(2));
        this.SetCellDates();
        calInitial.setTime(this.dInitial);
        Calendar calCurrent = Calendar.getInstance();
        for (i = 0; i < 42; ++i) {
            calCurrent.setTime(this.Cell[i].date);
            if (calInitial.get(2) == calCurrent.get(2) && calInitial.get(5) == calCurrent.get(5)) break;
        }
        this.cbHighlightedCell = (byte)i;
        this.refresh();
    }

    public String getDate() {
        return this.Cell[this.cbHighlightedCell].date.toString();
    }

    @Override
    public Object getValue() {
        return this.getDate();
    }

    public void setValue(int iYear, int iMonth, int iDOM) {
        this.setDate(iYear, iMonth, iDOM);
    }

    private void highlightCell(Graphics g, int iCellNumber, Color cHighlight) {
        int iRow = iCellNumber / 7;
        int iColumn = iCellNumber % 7;
        int x = iColumn * this.iCellWidth + 2 + 5;
        int y = iRow * this.iCellHeight + 2 + this.iTopSpace;
        g.setColor(cHighlight);
        g.drawLine(x, y, x + this.iCellWidth - 4, y);
        g.drawLine(x + this.iCellWidth - 4, y, x + this.iCellWidth - 4, y + this.iCellHeight - 4);
        g.drawLine(x + this.iCellWidth - 4, y + this.iCellHeight - 4, x, y + this.iCellHeight - 4);
        g.drawLine(x, y + this.iCellHeight - 4, x, y);
    }

    private byte getCellNumber(int x, int y) {
        int x1 = x - 5;
        int y1 = y - this.iTopSpace;
        if (x1 < 0 || y1 < 0) {
            return -1;
        }
        int iColumn = x1 / this.iCellWidth;
        int iRow = y1 / this.iCellHeight;
        if (iColumn > 6 || iRow > 5) {
            return -1;
        }
        return (byte)(iRow * 7 + iColumn);
    }

    private class calendarCell {
        Date date;
        boolean bSelectable;
        boolean bWeekend;

        private calendarCell() {
        }
    }
}

