/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

public class ExportImage
extends Image {
    private static final String[] SUGGESTED_TYPES = new String[]{"png", "jpeg", "jpg", "gif"};
    private static final String DEFAULT_TYPE = SUGGESTED_TYPES[0];
    protected BufferedImage image;

    public ExportImage(int width, int height) {
        this(width, height, 1);
    }

    public ExportImage(int width, int height, int imageType) {
        this.image = new BufferedImage(width, height, imageType);
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public static String[] getFileTypes() {
        return ExportImage.getFileTypes(false);
    }

    public static String[] getFileTypes(boolean lowercaseOnly) {
        String[] types = ImageIO.getWriterFormatNames();
        if (lowercaseOnly) {
            ArrayList<String> lower = new ArrayList<String>();
            for (String ty : types) {
                String lc = ty.toLowerCase();
                if (!ty.equals(lc)) continue;
                lower.add(ty);
            }
            types = lower.toArray(StringUtil.EMPTY_STRING_ARRAY);
        }
        return types;
    }

    public static String getSuggestedType() {
        Object[] types = ExportImage.getFileTypes();
        Arrays.sort(types);
        for (String suggestedType : SUGGESTED_TYPES) {
            if (Arrays.binarySearch(types, suggestedType) < 0) continue;
            return suggestedType;
        }
        return types.length == 0 ? null : types[0];
    }

    public void writeToFile(String fileName) throws IOException {
        if (fileName.indexOf(".") < 0) {
            Shell.warning("ExportImage: No file type or extension provided, assuming default of " + DEFAULT_TYPE);
        }
        this.writeToFile(fileName, DEFAULT_TYPE);
    }

    public void writeToFile(String fileName, String fileType) throws IOException {
        String ext;
        if (fileName.indexOf(".") >= 0 && !(ext = fileName.substring(fileName.indexOf("."))).substring(1).equalsIgnoreCase(fileType)) {
            Shell.warning("Extension in file name (" + ext + ") does not match given file type (" + fileType + "). Using " + fileType);
        }
        if (!ImageIO.write((RenderedImage)this.image, fileType, new File(fileName))) {
            throw new MidasException("Could not find image writer for file type (" + fileType + ").");
        }
    }

    public static void exportToFile(Component src, String fileName, String fileType) throws IOException {
        ExportImage.export(src).writeToFile(fileName, fileType);
    }

    public static ExportImage export(Component src) {
        ExportImage compImgr = new ExportImage(src.getWidth(), src.getHeight());
        src.print(compImgr.getGraphics());
        return compImgr;
    }

    @Override
    public void flush() {
        this.image.flush();
    }

    @Override
    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.image.getHeight(observer);
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.image.getProperty(name, observer);
    }

    @Override
    public ImageProducer getSource() {
        return this.image.getSource();
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.image.getWidth(observer);
    }
}

