/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.Indexable;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class DragBox
implements Indexable,
Tablizable {
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double tmin;
    private double tmax;
    private double[] geov;
    private double t1;
    private double t2;

    public DragBox(double[] values) {
        this(values[0], values[1], values[2], values[3]);
    }

    public DragBox(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = Math.min(xmin, xmax);
        this.xmax = Math.max(xmin, xmax);
        this.ymin = Math.min(ymin, ymax);
        this.ymax = Math.max(ymin, ymax);
        this.tmin = Double.NaN;
        this.tmax = Double.NaN;
        this.t1 = Double.NaN;
        this.t2 = Double.NaN;
    }

    DragBox(double xmin, double xmax, double ymin, double ymax, double[] geov) {
        this(xmin, xmax, ymin, ymax);
        this.geov = geov;
    }

    public void setXMin(double in) {
        this.xmin = in;
    }

    public double getXMin() {
        return this.xmin;
    }

    public void setXMax(double in) {
        this.xmax = in;
    }

    public double getXMax() {
        return this.xmax;
    }

    public void setYMin(double in) {
        this.ymin = in;
    }

    public double getYMin() {
        return this.ymin;
    }

    public void setYMax(double in) {
        this.ymax = in;
    }

    public double getYMax() {
        return this.ymax;
    }

    public void setTMin(double in) {
        this.tmin = in;
    }

    public double getTMin() {
        return this.tmin;
    }

    public void setTMax(double in) {
        this.tmax = in;
    }

    public double getTMax() {
        return this.tmax;
    }

    public void setT1(double in) {
        this.t1 = in;
    }

    public double getT1() {
        return this.t1;
    }

    public void setT2(double in) {
        this.t2 = in;
    }

    public double getT2() {
        return this.t2;
    }

    boolean isGeoView() {
        return this.geov != null;
    }

    double getGeoXMin() {
        return this.isGeoView() ? this.geov[0] : Double.NaN;
    }

    double getGeoXMax() {
        return this.isGeoView() ? this.geov[1] : Double.NaN;
    }

    double getGeoYMin() {
        return this.isGeoView() ? this.geov[2] : Double.NaN;
    }

    double getGeoYMax() {
        return this.isGeoView() ? this.geov[3] : Double.NaN;
    }

    void setGeoXMin(double in) {
        if (this.isGeoView()) {
            this.geov[0] = in;
        }
    }

    void setGeoXMax(double in) {
        if (this.isGeoView()) {
            this.geov[1] = in;
        }
    }

    void setGeoYMin(double in) {
        if (this.isGeoView()) {
            this.geov[2] = in;
        }
    }

    void setGeoYMax(double in) {
        if (this.isGeoView()) {
            this.geov[3] = in;
        }
    }

    @Override
    public Table toTable() {
        Table tbl = new Table();
        tbl.put("XMIN", this.getXMin());
        tbl.put("XMAX", this.getXMax());
        tbl.put("YMIN", this.getYMin());
        tbl.put("YMAX", this.getYMax());
        if (!Double.isNaN(this.getTMin())) {
            tbl.put("TMIN", this.getTMin());
        }
        if (!Double.isNaN(this.getTMax())) {
            tbl.put("TMAX", this.getTMax());
        }
        if (!Double.isNaN(this.getT1())) {
            tbl.put("T1", this.getT1());
        }
        if (!Double.isNaN(this.getT2())) {
            tbl.put("T2", this.getT2());
        }
        return tbl;
    }

    public String toString() {
        return "DragBox:" + this.toTable();
    }

    private static final void deprecate(String msg) {
        Shell.getSharedMidasContext().deprecate("DragBox: " + msg);
    }

    @Override
    @Deprecated
    public Object getIndex(int index) {
        String str;
        double val;
        block21: {
            block20: {
                val = 0.0;
                str = null;
                if (!this.isGeoView()) break block20;
                switch (index) {
                    case 0: {
                        val = this.getGeoXMin();
                        str = "XMIN";
                        break block21;
                    }
                    case 1: {
                        val = this.getGeoXMax();
                        str = "XMAX";
                        break block21;
                    }
                    case 2: {
                        val = this.getGeoYMin();
                        str = "YMIN";
                        break block21;
                    }
                    case 3: {
                        val = this.getGeoYMax();
                        str = "YMAX";
                        break block21;
                    }
                    case 4: {
                        val = this.getXMin();
                        str = "XMIN";
                        break block21;
                    }
                    case 5: {
                        val = this.getXMax();
                        str = "XMAX";
                        break block21;
                    }
                    case 6: {
                        val = this.getYMax();
                        str = "YMAX";
                        break block21;
                    }
                    case 7: {
                        val = this.getYMin();
                        str = "YMIN";
                        break block21;
                    }
                    default: {
                        throw new MidasException("DragBox: Invalid index " + index);
                    }
                }
            }
            switch (index) {
                case 0: {
                    val = this.getXMin();
                    str = "XMIN";
                    break;
                }
                case 1: {
                    val = this.getXMax();
                    str = "XMAX";
                    break;
                }
                case 2: {
                    val = this.getYMin();
                    str = "YMIN";
                    break;
                }
                case 3: {
                    val = this.getYMax();
                    str = "YMAX";
                    break;
                }
                case 4: {
                    val = this.getTMin();
                    str = "TMIN";
                    break;
                }
                case 5: {
                    val = this.getTMax();
                    str = "TMAX";
                    break;
                }
                default: {
                    throw new MidasException("DragBox: Invalid index " + index);
                }
            }
        }
        if (this.isGeoView() && index <= 3) {
            DragBox.deprecate("Getting Geodetic Viewer values is deprecated, use " + str + ".");
        } else {
            DragBox.deprecate("Getting DRAGBOX/ZOOM value using " + index + " is deprecated, use " + str + ".");
        }
        return val;
    }

    @Override
    @Deprecated
    public void setIndex(int index, Object value) {
        String str;
        block21: {
            double val;
            block20: {
                val = Convert.o2d(value);
                str = null;
                if (!this.isGeoView()) break block20;
                switch (index) {
                    case 0: {
                        this.setGeoXMin(val);
                        str = "XMIN";
                        break block21;
                    }
                    case 1: {
                        this.setGeoXMax(val);
                        str = "XMAX";
                        break block21;
                    }
                    case 2: {
                        this.setGeoYMin(val);
                        str = "YMIN";
                        break block21;
                    }
                    case 3: {
                        this.setGeoYMax(val);
                        str = "YMAX";
                        break block21;
                    }
                    case 4: {
                        this.setXMin(val);
                        str = "XMIN";
                        break block21;
                    }
                    case 5: {
                        this.setXMax(val);
                        str = "XMAX";
                        break block21;
                    }
                    case 6: {
                        this.setYMax(val);
                        str = "YMAX";
                        break block21;
                    }
                    case 7: {
                        this.setYMin(val);
                        str = "YMIN";
                        break block21;
                    }
                    default: {
                        throw new MidasException("DragBox: Invalid index " + index);
                    }
                }
            }
            switch (index) {
                case 0: {
                    this.setXMin(val);
                    str = "XMIN";
                    break;
                }
                case 1: {
                    this.setXMax(val);
                    str = "XMAX";
                    break;
                }
                case 2: {
                    this.setYMin(val);
                    str = "YMIN";
                    break;
                }
                case 3: {
                    this.setYMax(val);
                    str = "YMAX";
                    break;
                }
                case 4: {
                    this.setTMin(val);
                    str = "TMIN";
                    break;
                }
                case 5: {
                    this.setTMax(val);
                    str = "TMAX";
                    break;
                }
                default: {
                    throw new MidasException("DragBox: Invalid index " + index);
                }
            }
        }
        if (this.isGeoView() && index <= 3) {
            DragBox.deprecate("Setting Geodetic Viewer values is deprecated, use " + str + ".");
        } else {
            DragBox.deprecate("Setting DRAGBOX/ZOOM value using " + index + " is deprecated, use " + str + ".");
        }
    }

    @Override
    @Deprecated
    public int getSize() {
        return this.isGeoView() ? 8 : 6;
    }
}

