/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MapKBT;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MaskValue;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class XmlFile
extends BaseFile {
    private static final Pattern XML_LT = Pattern.compile("&lt;");
    private static final Pattern XML_GT = Pattern.compile("&gt;");
    private static final Pattern XML_AMP = Pattern.compile("&amp;");
    public static final String KEY_ROOTNAME = "ROOTNAME";
    private static final MaskValue<Xml2TblConversionOptions> DEF_XML2TBL_CONVERSION_OPTIONS = MaskValue.constant(Xml2TblConversionOptions.class, (Enum[])new Xml2TblConversionOptions[0]);
    public static final String MIDAS_XML_CONTENT_TYPE = "application/x-midas-xml";
    public static final String[] MIDAS_XML_VERSIONS_SUPPORTED = new String[]{"1.0"};
    public static final String DEFAULT_XML_VERSION = "1.0";
    public static final String DEFAULT_OUTER_TAG = "MidasXML";
    public static final boolean DEFAULT_BLOCKDATA = true;
    public static final boolean DEFAULT_NEWLINES = true;
    private static final String XML2FILE_CNAME = "CDATA";
    private static final String XML2FILE_DUP_TAGS_DELIM = "_";
    private static final String XML2FILE_DELIMITERS = " ,;";
    private static final String DEF_DUPKEY_DELIM_TBL2XML = "__";
    private static boolean dotKeyFixEnabled = true;

    @Deprecated
    public static Table fastXmlFileToTable(Object ref, String url) {
        return XmlFile.fastXmlFileToTable(new TextFile(Convert.ref2Midas(ref), (Object)url), null, null, 1, true);
    }

    public static Table fastXmlFileToTable(MidasReference ref, String url) {
        return XmlFile.fastXmlFileToTable(new TextFile(ref, (Object)url), null, null, 1, true);
    }

    public static Table fastXmlFileToTable(TextFile tf) {
        return XmlFile.fastXmlFileToTable(tf, null, null, 1, true);
    }

    public static Table fastXmlFileToTable(TextFile tf, String delim, String cname, int start, boolean comp) {
        MaskValue<Xml2TblConversionOptions> convOptions = DEF_XML2TBL_CONVERSION_OPTIONS.copy();
        if (comp) {
            convOptions.set(Xml2TblConversionOptions.Compression);
        }
        return XmlFile.fastXmlFileToTable(tf, delim, cname, start, convOptions);
    }

    public static Table fastXmlToTable(String xml, String delim, String cname, int start, boolean comp) {
        MaskValue<Xml2TblConversionOptions> convOptions = DEF_XML2TBL_CONVERSION_OPTIONS.copy();
        if (comp) {
            convOptions.set(Xml2TblConversionOptions.Compression);
        }
        return XmlFile.fastXmlToTable(xml, delim, cname, start, convOptions);
    }

    @Deprecated
    public static Table fastXmlFileToTable(Object ref, String url, MaskValue<Xml2TblConversionOptions> xml2TblConversionOptions) {
        return XmlFile.fastXmlFileToTable(new TextFile(Convert.ref2Midas(ref), (Object)url), xml2TblConversionOptions);
    }

    public static Table fastXmlFileToTable(MidasReference ref, String url, MaskValue<Xml2TblConversionOptions> xml2TblConversionOptions) {
        return XmlFile.fastXmlFileToTable(new TextFile(ref, (Object)url), xml2TblConversionOptions);
    }

    public static Table fastXmlFileToTable(TextFile tf, MaskValue<Xml2TblConversionOptions> xml2TblConversionOptions) {
        return XmlFile.fastXmlFileToTable(tf, null, null, 1, xml2TblConversionOptions);
    }

    public static Table fastXmlFileToTable(TextFile tf, String delim, String cname, int start, MaskValue<Xml2TblConversionOptions> xml2TblConversionOptions) {
        tf.open(8193);
        String xml = tf.readAll();
        tf.close();
        return XmlFile.fastXmlToTable(xml, delim, cname, start, xml2TblConversionOptions);
    }

    public static Table fastXmlToTable(String xml, String delim, String cname, int start, MaskValue<Xml2TblConversionOptions> xml2TblConversionOptions) {
        boolean comp = xml2TblConversionOptions.isSet(Xml2TblConversionOptions.Compression);
        XmlToTableHandler handler = new XmlToTableHandler(delim, cname, start, comp);
        XmlFile.parseXmlFast(xml, handler);
        Table tbl = handler.getTable();
        if (xml2TblConversionOptions.isSet(Xml2TblConversionOptions.IncludeRootName)) {
            tbl.put(KEY_ROOTNAME, (Object)handler.getRootName());
        }
        return tbl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseXmlFast(String xml, SimpleXmlHandler handler) {
        int cdataStart = 0;
        boolean upcaseTags = false;
        boolean upcaseKeys = false;
        char[] chars = xml.toCharArray();
        int tableMode = 2;
        if (handler instanceof NotSoSimpleXmlHandler) {
            upcaseTags = ((NotSoSimpleXmlHandler)handler).getUpcaseAllTags();
            upcaseKeys = ((NotSoSimpleXmlHandler)handler).getUpcaseAllKeys();
            tableMode = ((NotSoSimpleXmlHandler)handler).getTableMode();
        }
        try {
            for (int i = 0; i < xml.length(); ++i) {
                char thisChar = chars[i];
                if (thisChar == '<') {
                    String tag;
                    String cdata;
                    char nextChar = chars[i + 1];
                    if (cdataStart != i && (cdata = xml.substring(cdataStart, i).trim()).length() > 0) {
                        handler.gotCharData(XmlFile.removeEscapeChars(cdata));
                    }
                    if (nextChar == '/') {
                        i += 2;
                        int tagStart = i++;
                        while (chars[i] != '>') {
                            ++i;
                        }
                        tag = xml.substring(tagStart, i);
                        if (upcaseTags) {
                            tag = XmlFile.toUpper(tag);
                        }
                        handler.gotCloseTag(tag);
                    } else if (nextChar == '!') {
                        if (i + 6 < xml.length() && chars[i + 2] == '-' && chars[i + 3] == '-') {
                            i += 3;
                            while (chars[i] != '-' || chars[i + 1] != '-' || chars[i + 2] != '>') {
                                ++i;
                            }
                            i += 2;
                        } else if (i + 9 < xml.length() && xml.substring(i, i + 9).equals("<![CDATA[")) {
                            cdataStart = i += 9;
                            while (chars[i] != ']' || chars[i + 1] != ']' || chars[i + 2] != '>') {
                                ++i;
                            }
                            handler.gotCharData(xml.substring(cdataStart, i));
                            i += 2;
                        } else {
                            if (i + 9 >= xml.length() || !xml.substring(i, i + 9).equals("<!DOCTYPE")) throw new RuntimeException("Error unknown tag beginning with '<!'.");
                            while (chars[i] != '>') {
                                if (chars[i] == '[') {
                                    while (chars[i] != ']') {
                                        ++i;
                                    }
                                }
                                ++i;
                            }
                        }
                    } else if (nextChar == '?') {
                        i += 2;
                        while (chars[i] != '?' || chars[i + 1] != '>') {
                            ++i;
                        }
                        ++i;
                    } else {
                        int tagStart = ++i;
                        while (XmlFile.isTag(chars[i])) {
                            ++i;
                        }
                        tag = xml.substring(tagStart, i);
                        boolean end = false;
                        boolean done = false;
                        Table args = new Table(tableMode, 4);
                        boolean argsNoDotsInKeys = true;
                        while (!end && !done) {
                            while (XmlFile.isWhiteSpace(chars[i])) {
                                ++i;
                            }
                            int keyStart = i;
                            if (chars[i] == '/') {
                                end = true;
                                ++i;
                                continue;
                            }
                            if (chars[i] == '>') {
                                done = true;
                                continue;
                            }
                            while (chars[i] != '=') {
                                ++i;
                            }
                            String key = xml.substring(keyStart, i);
                            char tic = chars[++i];
                            int valStart = ++i;
                            while (chars[i] != tic) {
                                ++i;
                            }
                            String val = xml.substring(valStart, i);
                            ++i;
                            if (upcaseKeys) {
                                key = XmlFile.toUpper(key);
                            }
                            if (dotKeyFixEnabled && argsNoDotsInKeys && key.contains(".")) {
                                argsNoDotsInKeys = false;
                                args.setFlags("+AllowDotsInKeys");
                            }
                            args.putx(key, val, 0);
                        }
                        args.setFlags("-Add");
                        if (upcaseTags) {
                            tag = XmlFile.toUpper(tag);
                        }
                        handler.gotOpenTag(tag, args);
                        if (end) {
                            handler.gotCloseTag(tag);
                        }
                    }
                    cdataStart = i + 1;
                    continue;
                }
                if (cdataStart != i || !XmlFile.isWhiteSpace(thisChar)) continue;
                cdataStart = i + 1;
            }
            return;
        }
        catch (EmptyStackException e) {
            throw new MidasException("Malformed input XML file.", e);
        }
    }

    private static String toUpper(String str) {
        char[] chars = str.toCharArray();
        boolean mod = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < 'a' || c > 'z') continue;
            chars[i] = (char)(c - 97 + 65);
            mod = true;
        }
        return mod ? new String(chars) : str;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    private static boolean isTag(char c) {
        return !XmlFile.isWhiteSpace(c) && c != '/' && c != '>';
    }

    private static String removeEscapeChars(String text) {
        text = XML_LT.matcher(text).replaceAll("<");
        text = XML_GT.matcher(text).replaceAll(">");
        text = XML_AMP.matcher(text).replaceAll("&");
        return text;
    }

    public static String fastTableToXml(Keyable tab, boolean newlines) {
        return XmlFile.fastTableToXml(tab, null, null, null, false, newlines);
    }

    public static String fastTableToXml(Keyable tab, String outerTag, String delim, String cname, boolean compress, boolean newlines) {
        if (outerTag == null) {
            outerTag = "XML";
        }
        TableToXml tableToXml = new TableToXml(delim, cname, compress, newlines);
        return tableToXml.toXml(outerTag, tab);
    }

    public static void fastTableToXmlFile(Object ref, String url, Keyable tab, boolean newlines) {
        XmlFile.fastTableToXmlFile(new TextFile(Convert.ref2Midas(ref), (Object)url), tab, newlines);
    }

    public static void fastTableToXmlFile(TextFile tf, Keyable tab, boolean newlines) {
        XmlFile.fastTableToXmlFile(tf, tab, null, null, null, false, newlines);
    }

    public static void fastTableToXmlFile(TextFile tf, Keyable tab, String outerTag, String delim, String cname, boolean compress, boolean newlines) {
        tf.open(8194);
        tf.write(XmlFile.fastTableToXml(tab, outerTag, delim, cname, compress, newlines));
        tf.close();
    }

    public static CharSequence fileToXml(BaseFile file, Table options) {
        ListFile lf;
        if (options == null) {
            options = new Table();
        }
        String version = options.getS("VERSION", DEFAULT_XML_VERSION);
        String ver = null;
        StringBuilder xml = new StringBuilder(65536);
        for (String v : MIDAS_XML_VERSIONS_SUPPORTED) {
            if (v.equals(version)) {
                ver = v;
                break;
            }
            if (StringUtil.compareVersions(version, v) >= 0) continue;
            ver = v;
            Shell.warning("XML version '" + version + "' not supported, using version '" + ver + "'");
            break;
        }
        if (ver == null) {
            ver = MIDAS_XML_VERSIONS_SUPPORTED[MIDAS_XML_VERSIONS_SUPPORTED.length - 1];
            Shell.warning("XML version '" + version + "' not supported, using version '" + ver + "'");
        }
        String outerTag = options.getString("OUTER_TAG", DEFAULT_OUTER_TAG);
        boolean newlines = options.getState("NEWLINES", true);
        boolean blockData = options.getState("BLOCKDATA", true);
        String newline = newlines ? "\n" : "";
        String nlOneIndent = newlines ? "\n  " : "";
        String nlTwoIndent = newlines ? "\n    " : "";
        DataFile df = file instanceof DataFile ? (DataFile)file : null;
        PlotFile pf = file instanceof PlotFile ? (PlotFile)((Object)file) : null;
        ListFile listFile = lf = file instanceof ListFile ? (ListFile)((Object)file) : null;
        if (lf == null) {
            lf = FileUtil.asListFile(FileUtil.asPlotFileNH(file));
        }
        if (lf == null) {
            throw new MidasException("Could not convert " + file + " to XML since it is not a ListFile or PlotFile");
        }
        BaseFile bf = file;
        if (ver.equals(DEFAULT_XML_VERSION)) {
            String sourceType = df != null ? "application/x-midas-blue" : bf.getMimeType();
            String creator = "NXM4.1.4";
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xml.append(newline);
            xml.append('<').append(outerTag).append(' ').append("ContentType='").append(MIDAS_XML_CONTENT_TYPE).append("' ").append("Version='").append(ver).append("' ").append("SourceType='").append(sourceType).append("' ").append("Creator='").append(creator).append("'>");
        }
        if (df != null) {
            int typeClass = df.getTypeCodeClass();
            boolean isAscii = Data.isString(df.getFormatType());
            XmlFile.appendHeadXML(xml, df, version, nlOneIndent, nlTwoIndent);
            XmlFile.appendKeysXML(xml, df, version, nlOneIndent, nlTwoIndent);
            if (blockData && !isAscii && (typeClass == 1 || typeClass == 2)) {
                XmlFile.appendBlockDataXML(xml, df, version, nlOneIndent, nlTwoIndent);
            } else {
                XmlFile.appendRowDataXML(xml, df, version, nlOneIndent, nlTwoIndent);
            }
        } else if (pf != null) {
            int typeClass = pf instanceof ListFile ? -1 : pf.getType() / 1000;
            String format = pf.getFormat();
            boolean isAscii = format.length() == 2 && Data.isString((byte)format.charAt(1));
            XmlFile.appendHeadXML(xml, pf, version, nlOneIndent, nlTwoIndent);
            XmlFile.appendKeysXML(xml, bf, version, nlOneIndent, nlTwoIndent);
            if (blockData && !isAscii && (typeClass == 1 || typeClass == 2)) {
                XmlFile.appendBlockDataXML(xml, pf, version, nlOneIndent, nlTwoIndent);
            } else {
                XmlFile.appendRowDataXML(xml, lf, version, nlOneIndent, nlTwoIndent);
            }
        } else {
            XmlFile.appendHeadXML(xml, lf, version, nlOneIndent, nlTwoIndent);
            XmlFile.appendKeysXML(xml, bf, version, nlOneIndent, nlTwoIndent);
            XmlFile.appendRowDataXML(xml, lf, version, nlOneIndent, nlTwoIndent);
        }
        xml.append(newline);
        xml.append("</").append(outerTag).append('>').append(newline);
        return xml;
    }

    private static void appendHeadXML(StringBuilder xml, DataFile df, String version, String nlOneIndent, String nlTwoIdent) {
        int typeClass = df.getTypeCodeClass();
        Time time = df.getTime();
        String timeStr = time.toString(10, 12);
        xml.append(nlOneIndent).append("<FileHeader>");
        xml.append(nlTwoIdent).append("<Time>").append(timeStr).append("</Time>");
        xml.append(nlTwoIdent).append("<Size>").append(df.getSize()).append("</Size>");
        XmlFile.appendHeadXML(xml, (PlotFile)df, "-" + version, nlOneIndent, nlTwoIdent);
        if (typeClass == 5) {
            String rf = df.getReferenceFrame();
            xml.append(nlTwoIdent).append("<ReferenceFrame Name='").append(rf).append("' ");
            if (rf.startsWith("TOP")) {
                xml.append("Altitude='").append(df.getQuadword(1)).append("' ");
                xml.append("Latitude='").append(df.getQuadword(2)).append("' ");
                xml.append("Longitude='").append(df.getQuadword(3)).append("' ");
            }
            if (rf.equals("TOP")) {
                xml.append("Azimuth='").append(df.getQuadword(4)).append("' ");
                xml.append("Elevation='").append(df.getQuadword(5)).append("' ");
                xml.append("Roll='").append(df.getQuadword(6)).append("' ");
            }
            if (rf.equals("ECI") || df.getQuadword(9) != 0.0) {
                xml.append("EpochYear='").append(df.getQuadword(9)).append("' ");
                xml.append("EpochSeconds='").append(df.getQuadword(10)).append("' ");
                xml.append("EpochGHA='").append(df.getQuadword(11)).append("' ");
            }
            xml.append("/>");
        }
        if (typeClass == 3 || typeClass == 5 || typeClass == 6) {
            xml.append(nlTwoIdent).append("<RecLength>").append(df.getRecLength()).append("</RecLength>");
            XmlFile.appendHeadXML(xml, (ListFile)df, "-" + version, nlOneIndent, nlTwoIdent);
        }
        xml.append(nlOneIndent).append("</FileHeader>");
    }

    private static void appendHeadXML(StringBuilder xml, PlotFile pf, String version, String nlOneIndent, String nlTwoIndent) {
        String xUnits = DataFile.getUnitsVarName(pf.getXUnits());
        String yUnits = DataFile.getUnitsVarName(pf.getYUnits());
        if (!version.startsWith("-")) {
            Time time = new Time(pf.getTimeAt(0.0));
            String timeStr = time.toString(10, 12);
            xml.append(nlOneIndent).append("<FileHeader>");
            xml.append(nlTwoIndent).append("<Time>").append(timeStr).append("</Time>");
            xml.append(nlTwoIndent).append("<Size>").append(pf.getSize()).append("</Size>");
        }
        xml.append(nlTwoIndent).append("<Type>").append(pf.getType()).append("</Type>");
        xml.append(nlTwoIndent).append("<Format>").append(pf.getFormat()).append("</Format>");
        xml.append(nlTwoIndent).append("<XUnits>").append(xUnits).append("</XUnits>");
        xml.append(nlTwoIndent).append("<XStart>").append(pf.getXStart()).append("</XStart>");
        xml.append(nlTwoIndent).append("<XDelta>").append(pf.getXDelta()).append("</XDelta>");
        xml.append(nlTwoIndent).append("<SubSize>").append(pf.getXFrame()).append("</SubSize>");
        xml.append(nlTwoIndent).append("<YUnits>").append(yUnits).append("</YUnits>");
        xml.append(nlTwoIndent).append("<YStart>").append(pf.getYStart()).append("</YStart>");
        xml.append(nlTwoIndent).append("<YDelta>").append(pf.getYDelta()).append("</YDelta>");
        if (!version.startsWith("-")) {
            xml.append(nlOneIndent).append("</FileHeader>");
        }
    }

    private static void appendHeadXML(StringBuilder xml, ListFile lf, String version, String nlOneIndent, String nlTwoIndent) {
        int recordDefintionCount;
        if (!version.startsWith("-")) {
            xml.append(nlOneIndent).append("<FileHeader>");
            xml.append(nlTwoIndent).append("<Size>").append(lf.getNumberOfRows()).append("</Size>");
        }
        if ((recordDefintionCount = lf.getRecordDefCount()) > 0) {
            xml.append(nlTwoIndent).append("<SubRecords>");
        }
        for (int i = 0; i < recordDefintionCount; ++i) {
            Table def = lf.getRecordDef(i);
            xml.append(nlTwoIndent).append("  <SubRecord ");
            for (String key : def.getKeys()) {
                xml.append(key).append("='").append(def.get(key)).append("' ");
            }
            xml.append("/>");
        }
        if (recordDefintionCount > 0) {
            xml.append(nlTwoIndent).append("</SubRecords>");
        }
        if (!version.startsWith("-")) {
            xml.append(nlOneIndent).append("</FileHeader>");
        }
    }

    private static void appendKeysXML(StringBuilder xml, DataFile df, String version, String nlOneIndent, String nlTwoIndent) {
        Keywords keywords = df.getKeywordsObject();
        xml.append(nlOneIndent).append("<FileKeywords>");
        for (Map.Entry<String, Object> kwd : keywords.getAll("MAIN", false)) {
            XmlFile.appendKeyword(xml, "MAIN", 'S', kwd.getKey(), kwd.getValue(), nlOneIndent, nlTwoIndent);
        }
        for (Map.Entry<String, Object> kwd : keywords.getAll("EXT", false)) {
            XmlFile.appendKeyword(xml, "EXT", '?', kwd.getKey(), kwd.getValue(), nlOneIndent, nlTwoIndent);
        }
        xml.append(nlOneIndent).append("</FileKeywords>");
    }

    private static void appendKeysXML(StringBuilder xml, BaseFile bf, String version, String nlOneIndent, String nlTwoIndent) {
        xml.append(nlOneIndent).append("<FileKeywords>");
        XmlFile.appendKeyword(xml, null, 'S', "COMMENT", bf.getComment(), nlOneIndent, nlTwoIndent);
        xml.append(nlOneIndent).append("</FileKeywords>");
    }

    private static void appendKeyword(StringBuilder xml, String scope, char type, String key, Object val, String nlOneIndent, String nlTwoIndent) {
        if (val == null) {
            val = "";
        }
        if (type == '?') {
            type = (char)(val instanceof Data ? (int)((Data)val).getFormatTypeChar() : 83);
        }
        String str = StringUtil.toHTML(val.toString());
        xml.append(nlTwoIndent);
        xml.append("<KEY ");
        if (scope != null) {
            xml.append("SCOPE=\"").append(scope).append("\" ");
        }
        xml.append("TYPE=\"").append(type).append("\" ");
        xml.append("NAME=\"").append(key).append("\" ");
        xml.append("VALUE=\"").append(str).append("\"/>");
    }

    private static void appendRowDataXML(StringBuilder xml, ListFile lf, String version, String nlOneIndent, String nlTwoIndent) {
        xml.append(nlOneIndent).append("<FileData Type='ROW'>");
        int i = 0;
        while ((double)i < lf.getNumberOfRows()) {
            Table row = lf.getDataTable(i);
            xml.append(nlTwoIndent);
            xml.append("<!-- ").append(i).append(" --> ");
            xml.append("<ROW");
            for (String key : row.getKeys()) {
                String val = StringUtil.toHTML(row.getS(key));
                xml.append(" ").append(key).append("=\"").append(val).append('\"');
            }
            xml.append("/>");
            ++i;
        }
        xml.append(nlOneIndent).append("</FileData>");
    }

    private static void appendBlockDataXML(StringBuilder xml, PlotFile pf, String version, String nlOneIndent, String nlTwoIndent) {
        int numRead;
        int xf = pf.getXFrame();
        int tl = xf > 1 ? 1 : 32;
        Data data = pf.getDataBuffer(tl);
        xml.append(nlOneIndent).append("<FileData Type='BLOCK'>");
        int totRead = 0;
        String scalarSeparator = " ";
        String elementSeparator = ", ";
        String frameSeparator = ";";
        while ((numRead = pf.read(data, data.size)) >= 0) {
            xml.append(nlTwoIndent).append("<!-- ").append(totRead).append(" --> ");
            data.toString(xml, 0, numRead, 10, false, " ", ", ", true);
            if (xf > 1) {
                xml.append(";");
            }
            totRead += numRead;
        }
        xml.append(nlOneIndent).append("</FileData>");
    }

    public static void xmlToFile(TextFile inTextFile, DataFile outDataFile, Table options) {
        inTextFile.open(8193);
        String xml = inTextFile.readAll();
        inTextFile.close();
        XmlFile.xmlToFile(xml, outDataFile, options);
    }

    public static void xmlToFile(String xml, DataFile outDataFile, Table options) {
        if (options == null) {
            options = new Table();
        }
        options.addIfNotPresent("WARN", true);
        boolean showWarnings = options.getState("WARN");
        MaskValue xml2TblConversionOptions = MaskValue.with((Enum[])new Xml2TblConversionOptions[]{Xml2TblConversionOptions.IncludeRootName, Xml2TblConversionOptions.Compression});
        Table tab = XmlFile.fastXmlToTable(xml, XML2FILE_DUP_TAGS_DELIM, XML2FILE_CNAME, 1, xml2TblConversionOptions);
        XmlFile.checkContentTypeVersionSupported(tab, showWarnings);
        XmlFile.createFileHeader(outDataFile, tab, options);
        XmlFile.writeFileData(outDataFile, tab, options);
        XmlFile.writeFileKeywords(outDataFile, tab, options);
        outDataFile.close();
    }

    private static boolean checkContentTypeVersionSupported(Table tab, boolean warn) {
        if (tab == null) {
            return false;
        }
        String contentType = tab.getS("CONTENTTYPE");
        boolean contentTypeCheck = MIDAS_XML_CONTENT_TYPE.equals(contentType);
        if (warn && !contentTypeCheck) {
            Shell.warning("checkContentTypeVersionSupported: Unsupported MidasXML: ContentType attribute [" + contentType + "]");
        }
        boolean versionCheck = false;
        String version = tab.getS("VERSION");
        for (String supportedVersion : MIDAS_XML_VERSIONS_SUPPORTED) {
            if (!supportedVersion.equals(version)) continue;
            versionCheck = true;
            break;
        }
        if (warn && !versionCheck) {
            Shell.warning("checkContentTypeVersionSupported: Unsupported MidasXML: Version attribute [" + version + "]");
        }
        String rootTagName = tab.getS(KEY_ROOTNAME);
        boolean rootTagNameCheck = DEFAULT_OUTER_TAG.equalsIgnoreCase(rootTagName);
        if (warn && !rootTagNameCheck) {
            Shell.warning("checkContentTypeVersionSupported: Unsupported MidasXML: root tag name [" + rootTagName + "]");
        }
        return contentTypeCheck && versionCheck && rootTagNameCheck;
    }

    private static void createFileHeader(DataFile df, Table tab, Table options) {
        Table header = tab.getTable("FILEHEADER", null);
        if (header != null) {
            String tmpstr = header.getS("TIME", null);
            if (tmpstr != null) {
                df.setTime(new Time(tmpstr), false);
            }
            df.setSize(header.getD("SIZE"));
            df.setType(header.getL("TYPE", 1000));
            df.setFormat(header.getS("FORMAT"));
            df.setXUnits(header.getS("XUNITS"));
            df.setXStart(header.getD("XSTART"));
            df.setXDelta(header.getD("XDELTA"));
            df.setSubSize(header.getL("SUBSIZE"));
            df.setYUnits(header.getS("YUNITS"));
            df.setYStart(header.getD("YSTART"));
            df.setYDelta(header.getD("YDELTA"));
            int typeClass = df.getTypeCodeClass();
            if (typeClass == 5 && (tab = header.getTable("REFERENCEFRAME")) != null) {
                String rf = tab.getS("NAME");
                df.setReferenceFrame(rf);
                if (rf.startsWith("TOP")) {
                    df.setQuadword(1, tab.getD("ALTITUDE"));
                    df.setQuadword(2, tab.getD("LATITUDE"));
                    df.setQuadword(3, tab.getD("LONGITUDE"));
                }
                if (rf.equals("TOP")) {
                    df.setQuadword(4, tab.getD("AZIMUTH"));
                    df.setQuadword(5, tab.getD("ELEVATION"));
                    df.setQuadword(6, tab.getD("ROLL"));
                }
                if (rf.equals("ECI") || tab.getD("EPOCHYEAR") != 0.0) {
                    df.setQuadword(9, tab.getD("EPOCHYEAR"));
                    df.setQuadword(10, tab.getD("EPOCHSECONDS"));
                    df.setQuadword(11, tab.getD("EPOCHGHA"));
                }
            }
            if (typeClass == 3 || typeClass == 5 || typeClass == 6) {
                df.setRecLength(header.getL("RECLENGTH"));
                Table recDefsTable = header.getTable("SUBRECORDS");
                if (recDefsTable != null) {
                    df.setRecordDefs(recDefsTable);
                }
            }
        } else if (options.getState("WARN")) {
            Shell.warning("createFileHeader: MidasXML missing <FileHeader> tag.");
        }
        df.open(2);
    }

    private static void writeFileData(DataFile df, Table tab, Table options) {
        Table filedata = tab.getTable("FILEDATA", null);
        boolean warn = options.getState("WARN");
        if (filedata != null) {
            String type = filedata.getS("TYPE", null);
            filedata.remove("TYPE");
            if ("ROW".equals(type)) {
                for (Object value : filedata.values()) {
                    if (!(value instanceof Table)) continue;
                    df.writeDataTable((Table)value);
                }
            } else if ("BLOCK".equals(type)) {
                int subsize = df.getSubSize();
                int xferlen = subsize > 1 ? 1 : 32;
                Data data = df.getDataBuffer(xferlen);
                for (Object value : filedata.values()) {
                    if (value instanceof String) {
                        String datastr = (String)value;
                        data.fromString(datastr, XML2FILE_DELIMITERS);
                        df.write(data);
                        continue;
                    }
                    if (!warn) continue;
                    Shell.warning("writeFileData: MidasXML <FileData Type='BLOCK'> with unsupported data value of class: " + value.getClass());
                }
            } else if (warn) {
                Shell.warning("writeFileData: MidasXML's <FileData> tag has unsupported Type attribute: " + type);
            }
            if (type != null) {
                filedata.put("TYPE", (Object)type);
            }
        } else if (warn) {
            Shell.warning("writeFileData: MidasXML missing <FileData> tag.");
        }
    }

    private static void writeFileKeywords(DataFile df, Table tab, Table options) {
        Table filekeywords = tab.getTable("FILEKEYWORDS", null);
        if (filekeywords != null) {
            Keywords keywords = df.getKeywordsObject();
            for (Object keyword : filekeywords.values()) {
                if (!(keyword instanceof Table)) continue;
                Table kwtbl = (Table)keyword;
                String scope = kwtbl.getS("SCOPE");
                String type = kwtbl.getS("TYPE");
                String name = kwtbl.getS("NAME");
                Object value = kwtbl.get("VALUE");
                if (value instanceof String) {
                    value = StringUtil.fromHTML((String)value);
                }
                if ("MAIN".equals(scope)) {
                    keywords.putMain(name, value.toString());
                    continue;
                }
                name = type + ":" + name;
                keywords.add(name, value);
            }
        } else if (options.getState("WARN")) {
            Shell.warning("writeFileKeywords: MidasXML missing <FileKeywords> tag.");
        }
    }

    public static void fromXML(String bufferString, Table output, String duplicateKeyDelim) throws NoSuchElementException {
        Table tagCounts = new Table();
        StringTokenizer mainST = new StringTokenizer(bufferString, "<>", false);
        while (mainST.hasMoreTokens()) {
            String newName;
            String tableName;
            StringTokenizer lineST;
            String line = mainST.nextToken().trim();
            if (line.endsWith("/")) {
                line = line.substring(0, line.length() - 1);
                lineST = new StringTokenizer(line);
                tableName = lineST.nextToken();
                newName = XmlFile.getUniqueKey(tagCounts, tableName, duplicateKeyDelim);
                output.put(newName, (Object)XmlFile.makeXMLTableFromLine(lineST));
                continue;
            }
            if (line.length() <= 0) continue;
            lineST = new StringTokenizer(line);
            if (lineST.countTokens() > 1) {
                tableName = lineST.nextToken();
                newName = XmlFile.getUniqueKey(tagCounts, tableName, duplicateKeyDelim);
                output.put(newName, (Object)XmlFile.makeXMLTableFromLine(lineST));
            } else {
                tableName = lineST.nextToken();
                newName = output.getUniqueKey(tableName);
                if (!tableName.equals("/XML")) {
                    output.addTable(newName);
                }
            }
            String endtable = "/" + tableName;
            boolean foundEnd = false;
            StringBuilder innerTable = new StringBuilder();
            while (mainST.hasMoreTokens() && !foundEnd) {
                line = mainST.nextToken();
                if (line.equals(endtable)) {
                    foundEnd = true;
                    continue;
                }
                innerTable.append(line).append("<");
            }
            if (innerTable.length() <= 0 || !foundEnd) continue;
            XmlFile.fromXML(innerTable.toString(), output.getTable(newName));
        }
    }

    public static Table makeXMLTableFromLine(StringTokenizer st) {
        String nt;
        String ss = "{";
        if (st.hasMoreTokens()) {
            nt = st.nextToken();
            nt = nt.replace('\'', '\"');
            ss = ss.concat(nt);
        }
        while (st.hasMoreTokens()) {
            nt = st.nextToken();
            ss = nt.indexOf(61) > 0 ? ss.concat(",") : ss.concat(" ");
            nt = nt.replace('\'', '\"');
            ss = ss.concat(nt);
        }
        ss = ss.concat("}");
        Table newTable = new Table(ss);
        return newTable;
    }

    public static void fromXML(String bufferString, Table output) throws NoSuchElementException {
        XmlFile.fromXML(bufferString, output, DEF_DUPKEY_DELIM_TBL2XML);
    }

    private static String getUniqueKey(Table tagCounts, String key, String delim) {
        String str = key;
        int count = tagCounts.getL(key);
        if (count > 0) {
            str = key + delim + count;
        }
        tagCounts.put(key, count + 1);
        return str;
    }

    public static MapKBT fromXML(String xml) {
        return XmlFile.fromXML(xml, false, null);
    }

    public static MapKBT fromXML(String xml, boolean upcase, String cdataTagName) {
        FastXmlHandler handler = new FastXmlHandler(upcase, cdataTagName);
        XmlFile.parseXmlFast(xml, handler);
        return handler.getValue();
    }

    @InternalUseOnly
    public static void setDotKeyFix(boolean fixEnabled) {
        dotKeyFixEnabled = fixEnabled;
    }

    @InternalUseOnly
    public static boolean getDotKeyFixEnabled() {
        return dotKeyFixEnabled;
    }

    private static class XmlToken {
        final TokenType type;
        final String value;
        final Table args;

        XmlToken(TokenType type, String value, Table args) {
            this.type = type;
            this.value = value;
            this.args = args;
        }

        public String toString() {
            return "XmlToken type:" + (Object)((Object)this.type) + " value:" + this.value + " args:" + this.args;
        }
    }

    private static enum TokenType {
        OPEN,
        CLOSE,
        CDATA,
        DONE;

    }

    private static class FastXmlHandler
    extends NotSoSimpleXmlHandler {
        private final LinkedList<XmlToken> tokens = new LinkedList();
        private final boolean upcase;
        private final String cdataTagName;
        private final String valueTagName;

        FastXmlHandler(boolean upcase, String cdataTagName) {
            this.upcase = upcase;
            this.cdataTagName = cdataTagName;
            this.valueTagName = upcase ? "VALUE" : "value";
        }

        @Override
        public boolean getUpcaseAllKeys() {
            return this.upcase;
        }

        @Override
        public boolean getUpcaseAllTags() {
            return this.upcase;
        }

        @Override
        public void gotOpenTag(String tag, Table args) {
            this.tokens.push(new XmlToken(TokenType.OPEN, tag, args));
        }

        @Override
        public void gotCloseTag(String tag) {
            this.tokens.push(new XmlToken(TokenType.CLOSE, tag, null));
        }

        @Override
        public void gotCharData(String value) {
            this.tokens.push(new XmlToken(TokenType.CDATA, value, null));
        }

        public MapKBT getValue() {
            this.tokens.push(new XmlToken(TokenType.DONE, null, null));
            Object val = this.getValue(null, null);
            return val instanceof MapKBT ? (MapKBT)val : MapKBT.wrapMap(Collections.singletonMap(this.cdataTagName, val));
        }

        private Object getValue(String tagName, Table args) {
            XmlToken token;
            if (this.tokens.isEmpty()) {
                return null;
            }
            MapKBT values = MapKBT.newMap();
            String cdata = null;
            if (args != null) {
                values.putAll(args);
            }
            while ((token = this.tokens.removeLast()) != null) {
                switch (token.type) {
                    case OPEN: {
                        Object val = this.getValue(token.value, token.args);
                        Object old = values.get(token.value);
                        if (old == null) {
                            values.put(token.value, val);
                            break;
                        }
                        if (old instanceof Collection) {
                            ((Collection)old).add(val);
                            break;
                        }
                        ArrayList<Object> all = new ArrayList<Object>(8);
                        all.add(old);
                        all.add(val);
                        values.put(token.value, all);
                        break;
                    }
                    case CLOSE: {
                        if (tagName != null && !tagName.equals(token.value)) {
                            throw new RuntimeException("Mismatched <" + tagName + "> and </" + token.value + ">");
                        }
                    }
                    case DONE: {
                        if (cdata == null) {
                            return values;
                        }
                        if (values.isEmpty()) {
                            return cdata;
                        }
                        if (this.cdataTagName != null) {
                            values.put(this.cdataTagName, cdata);
                            return values;
                        }
                        if (!values.containsKey(this.valueTagName)) {
                            values.put(this.valueTagName, cdata);
                            return values;
                        }
                        values.put(XmlFile.XML2FILE_CNAME, cdata);
                        return values;
                    }
                    case CDATA: {
                        cdata = cdata == null ? token.value : cdata + " " + token.value;
                    }
                }
            }
            throw new RuntimeException("Missing </" + tagName + ">");
        }
    }

    public static class XmlToTableHandler
    extends NotSoSimpleXmlHandler {
        private final Stack<Table> tables = new Stack();
        private final Stack<Table> counts = new Stack();
        private final Stack<String> names = new Stack();
        private final String delim;
        private final String cname;
        private final int start;
        private final boolean compress;
        private final int mode;
        private String cdata = null;
        private Table root = null;
        private String rootName = null;
        private boolean noKeysWithDots = true;

        public XmlToTableHandler() {
            this(null, null, 1, false, 2);
        }

        public XmlToTableHandler(String delim, String cname, int start) {
            this(delim, cname, start, false, 2);
        }

        public XmlToTableHandler(String delim, String cname, int start, boolean compress) {
            this(delim, cname, start, compress, 2);
        }

        public XmlToTableHandler(String delim, String cname, int start, boolean compress, int mode) {
            this.delim = delim == null ? XmlFile.XML2FILE_DUP_TAGS_DELIM : delim;
            this.cname = cname == null ? XmlFile.XML2FILE_CNAME : cname.toUpperCase();
            this.start = start;
            this.compress = compress;
            this.mode = mode;
        }

        @Override
        public boolean getUpcaseAllKeys() {
            return true;
        }

        @Override
        public boolean getUpcaseAllTags() {
            return true;
        }

        @Override
        public int getTableMode() {
            return this.mode;
        }

        public void clear() {
            this.tables.clear();
            this.counts.clear();
            this.names.clear();
            this.cdata = null;
            this.root = null;
            this.rootName = null;
        }

        @Override
        public void gotOpenTag(String tag, Table args) {
            if (!this.tables.empty()) {
                tag = this.addUnique(tag, args);
            }
            this.tables.push(args);
            this.counts.push(new Table(3));
            this.names.push(tag);
        }

        @Override
        public void gotCloseTag(String tag) {
            Table top = this.tables.pop();
            Table cnt = this.counts.pop();
            String name = this.names.pop();
            if (this.compress && top.size() == 1) {
                String key = top.getKeys()[0];
                Object val = top.get(key);
                if (key.equals(this.cname)) {
                    if (!this.tables.empty()) {
                        Table prev = this.tables.peek();
                        prev.remove(name);
                        prev.put(name, val);
                    } else {
                        top.rename(top.getKeys()[0], name);
                    }
                }
            }
            if (this.tables.empty()) {
                this.root = top;
                this.rootName = name;
            }
        }

        @Override
        public void gotCharData(String cdata) {
            this.addUnique(this.cname, cdata);
        }

        public Table getTable() {
            return this.root;
        }

        public String getRootName() {
            return this.rootName;
        }

        private String addUnique(String key, Object val) {
            Table table = new Table();
            table = this.tables.peek();
            Table count = this.counts.peek();
            int index = count.getL(key, this.start);
            String ukey = key + this.delim + index;
            if (index == -1) {
                ukey = key;
                index = 0;
            } else if (index == -2) {
                ukey = key + this.delim + 0;
                index = 0;
            } else if (index == this.start) {
                ukey = key;
            } else if (index == this.start + 1) {
                table.rename(key, key + this.delim + this.start);
            }
            if (dotKeyFixEnabled && this.noKeysWithDots && key.contains(".")) {
                this.noKeysWithDots = false;
                table.setFlags("+AllowDotsInKeys");
                count.setFlags("+AllowDotsInKeys");
            }
            if (dotKeyFixEnabled) {
                count.putx(key, index + 1);
                table.putx(ukey, val);
            } else {
                count.put(key, index + 1);
                table.put(ukey, val);
            }
            return ukey;
        }
    }

    public static abstract class NotSoSimpleXmlHandler
    implements SimpleXmlHandler {
        public boolean getUpcaseAllKeys() {
            return false;
        }

        public boolean getUpcaseAllTags() {
            return false;
        }

        public int getTableMode() {
            return 2;
        }
    }

    public static interface SimpleXmlHandler {
        public void gotOpenTag(String var1, Table var2);

        public void gotCloseTag(String var1);

        public void gotCharData(String var1);
    }

    private static final class TableToXml {
        private final String INDENT = "  ";
        private StringBuffer xml = new StringBuffer();
        private String delim;
        private String cname;
        private boolean compress;
        private String newline;

        public TableToXml(String delim, String cname, boolean compress, boolean newlines) {
            this.delim = delim != null ? delim : XmlFile.XML2FILE_DUP_TAGS_DELIM;
            this.cname = cname != null ? cname : XmlFile.XML2FILE_CNAME;
            this.compress = compress;
            this.newline = newlines ? "\n" : "";
        }

        public String toXml(String outerTag, Keyable tab) {
            return this.toXml(outerTag, tab, "").toString();
        }

        private StringBuffer toXml(String topLevel, Keyable tab, String indent) {
            StringBuffer xml = new StringBuffer();
            StringBuffer attr = new StringBuffer();
            String[] keys = tab.getKeys();
            String indt1 = "";
            String indt2 = "";
            boolean hasNested = false;
            if (this.newline.length() > 0) {
                indt1 = this.newline + indent;
                indt2 = indt1 + "  ";
            }
            attr.append(indt1).append("<").append(topLevel);
            int lenDelim = this.delim.length();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                Object value = tab.getKey(key);
                int idelim = key.lastIndexOf(this.delim);
                if (idelim > 0) {
                    String count = key.substring(idelim + lenDelim);
                    if (StringUtil.isInteger(count)) {
                        key = key.substring(0, idelim);
                    } else {
                        throw new MidasException("XmlFile: Error converting table key '" + keys[i] + "' to XML, when using delim='" + this.delim + "', invalid count=" + count);
                    }
                }
                if (value == null) continue;
                if (key.equals(this.cname) && !this.compress) {
                    value = StringUtil.toHTML(value.toString());
                    xml.append(indt2).append(value);
                    continue;
                }
                if (value instanceof Keyable) {
                    xml.append(this.toXml(key, (Keyable)value, indent + "  "));
                    hasNested = true;
                    continue;
                }
                attr.append(" ").append(key).append("=\"").append(value).append("\"");
            }
            if (xml.length() == 0) {
                attr.append("/>");
            } else if (!hasNested && xml.length() < 40) {
                attr.append(">");
                attr.append(xml.substring(indt2.length()));
                attr.append("</").append(topLevel).append(">");
            } else {
                attr.append(">");
                attr.append(xml);
                attr.append(indt1).append("</").append(topLevel).append(">");
            }
            return attr;
        }
    }

    public static enum Xml2TblConversionOptions {
        Compression,
        IncludeRootName;

    }
}

