/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Map;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Table;
import nxm.sys.lib.XMValueJava;

public final class XMValue {
    public static final char NONE = ' ';
    public static final char ASCII = 'A';
    public static final char ASCII256 = 'Z';
    public static final char INT_1 = 'B';
    public static final char INT_U1 = 'O';
    public static final char INT_2 = 'I';
    public static final char INT_4 = 'L';
    public static final char INT_8 = 'X';
    public static final char REAL_4 = 'F';
    public static final char REAL_8 = 'D';
    public static final char LIST = 'C';
    public static final char KVLIST = 'K';
    public static final char TABLE = 'H';
    public static final char XMVALUE = 'V';
    @InternalUseOnly
    private static final String legalTypes = " ABOILXFDCKHZ";
    private static Class<? extends Backend> defaultBackend = XMValueJava.class;
    private Backend backend;

    public XMValue(Class<? extends Backend> clazz) {
        try {
            this.backend = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not instantiate " + this.backend, e);
        }
    }

    public XMValue(Backend backend) {
        this.backend = backend;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void setBackend(Backend b) {
        if (b == null) {
            throw new NullPointerException("Illegal XMValue.setBackend(null)");
        }
        this.backend = b;
    }

    public static void setDefaultBackend(Class<? extends Backend> clazz) {
        defaultBackend = clazz;
    }

    public static Class<? extends Backend> getDefaultBackend() {
        return defaultBackend;
    }

    public static XMValue toXMValue(Object obj) {
        return XMValue.toXMValue(obj, ' ', '_', null);
    }

    public static XMValue toXMValue(Object obj, Object ref) {
        return XMValue.toXMValue(obj, ' ', '_', ref);
    }

    public static XMValue toXMValue(Object obj, char mode, char type, Object ref) {
        XMValue v;
        char givenType = type;
        if (obj instanceof XMValue) {
            v = (XMValue)obj;
            if (type == '_' || type == 'V' || v.getFormatType() == type) {
                return v;
            }
        }
        if (type == '_' || type == 'V') {
            if (obj == null || obj.toString().equalsIgnoreCase("None")) {
                type = (char)32;
            } else {
                type = Convert.guessType(obj, '_', 'S');
                if (type == '_') {
                    obj = Convert.o2o(obj, '_', ref);
                    type = Convert.guessType(obj, 'S', 'S');
                }
            }
        }
        if (XMValue.isNumericType(type) || type == 'N') {
            if (obj == null) {
                return new XMValue(0);
            }
            Data val = (Data)Convert.o2o(obj, type, ref);
            return new XMValue(val);
        }
        if (type == ' ') {
            return new XMValue();
        }
        if (Data.isString((byte)type) || type == 'S') {
            return new XMValue(obj.toString());
        }
        if (type == 'C') {
            throw new MidasException("Converstion from Object->XMValue for TYPE=" + type + " not supported yet.");
        }
        if (type == 'K') {
            throw new MidasException("Converstion from Object->XMValue for TYPE=" + type + " not supported yet.");
        }
        if (type == 'H' || type == 'T') {
            v = new XMValue('H');
            Backend b = v.getBackend();
            Table t = Convert.o2t(obj, ref);
            for (String key : t.getKeys()) {
                XMValue val = XMValue.toXMValue(t.get(key));
                b.add(key, val);
            }
            return v;
        }
        if (givenType == '_') {
            return new XMValue(obj.toString());
        }
        throw new IllegalArgumentException("Invalid type '" + type + "' expected one of '" + legalTypes + "'.");
    }

    public XMValue() {
        this(defaultBackend);
    }

    public XMValue(char type) {
        this();
        this.setFormatType(type);
    }

    public XMValue(Data v) {
        this();
        this.setValue(v);
    }

    public XMValue(String v) {
        this();
        this.setValue(v);
    }

    public XMValue(byte v) {
        this();
        this.setValue(v);
    }

    public XMValue(short v) {
        this();
        this.setValue(v);
    }

    public XMValue(int v) {
        this();
        this.setValue(v);
    }

    public XMValue(long v) {
        this();
        this.setValue(v);
    }

    public XMValue(float v) {
        this();
        this.setValue(v);
    }

    public XMValue(double v) {
        this();
        this.setValue(v);
    }

    public XMValue(byte[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(short[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(int[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(long[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(float[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(double[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(XMValue[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(KVPair[] v) {
        this();
        this.setValue(v);
    }

    public XMValue(Map<String, XMValue> v) {
        this();
        this.setValue(v);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof XMValue)) {
            return false;
        }
        XMValue v = (XMValue)obj;
        char t = this.getFormatType();
        int s = this.getSize();
        if (t != v.getFormatType()) {
            return false;
        }
        if (s != v.getSize()) {
            return false;
        }
        if (s == 0) {
            return true;
        }
        if (t == ' ') {
            return true;
        }
        if (t == 'A') {
            return this.toA().equals(v.toA());
        }
        if (XMValue.isNumericType(t) && this.backend.isScalar() != v.backend.isScalar()) {
            return false;
        }
        if (s == 1 && XMValue.isNumericType(t)) {
            switch (t) {
                case 'B': {
                    return this.toB() == v.toB();
                }
                case 'O': {
                    return this.toL() == v.toL();
                }
                case 'I': {
                    return this.toI() == v.toI();
                }
                case 'L': {
                    return this.toL() == v.toL();
                }
                case 'X': {
                    return this.toX() == v.toX();
                }
                case 'F': {
                    return Float.valueOf(this.toF()).equals(Float.valueOf(v.toF()));
                }
                case 'D': {
                    return Double.valueOf(this.toD()).equals(v.toD());
                }
            }
            throw new AssertionError((Object)("Invalid XMValue type '" + t + "'."));
        }
        if (t == 'C') {
            for (int i = 1; i <= s; ++i) {
                if (this.get(i).equals(v.get(i))) continue;
                return false;
            }
            return true;
        }
        if (t == 'K' || t == 'H') {
            XMValue v1 = t == 'H' ? this.items() : this;
            XMValue v2 = t == 'H' ? v.items() : v;
            for (int i = 1; i <= s; ++i) {
                KVPair e1 = v1.backend.getPair(i);
                KVPair e2 = v2.backend.getPair(i);
                if (e1.getKey().equals(e2.getKey()) && e1.getValue().equals(e2.getValue())) continue;
                if (t == 'H') {
                    XMValue.delete(v1, v2);
                }
                return false;
            }
            if (t == 'H') {
                XMValue.delete(v1, v2);
            }
            return true;
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + t + "'."));
    }

    public final int hashCode() {
        int t = this.getFormatType();
        int s = this.getSize();
        if (t == 65) {
            return this.toA().hashCode();
        }
        if (s == 0) {
            return t;
        }
        if (s == 1) {
            if (t == 88) {
                long bits = this.toX();
                return (int)(bits ^ bits >>> 32);
            }
            if (t == 68) {
                long bits = Double.doubleToLongBits(this.toD());
                return (int)(bits ^ bits >>> 32);
            }
            if (XMValue.isNumericType((char)t)) {
                switch (t) {
                    case 66: {
                        return 0x42 ^ this.toB();
                    }
                    case 79: {
                        return 0x4F ^ this.toL();
                    }
                    case 73: {
                        return 0x49 ^ this.toI();
                    }
                    case 76: {
                        return 0x4C ^ this.toL();
                    }
                    case 70: {
                        return Float.floatToIntBits(this.toF());
                    }
                }
                throw new AssertionError((Object)("Invalid XMValue type '" + (char)t + "'."));
            }
        }
        if (t == 67) {
            int hash = 67;
            for (int i = 1; i <= s && i <= 8; ++i) {
                hash ^= this.get(i).hashCode() << 4 * (i - 1);
            }
            return hash;
        }
        if (t == 75 || t == 72) {
            XMValue v = t == 72 ? this.items() : this;
            int hash = t;
            for (int i = 1; i <= s && i <= 8; ++i) {
                KVPair e = v.backend.getPair(i);
                hash = hash ^ e.getKey().hashCode() << 4 * (i - 1) ^ e.getValue().hashCode() << 4 * (i - 1);
            }
            if (t == 72) {
                XMValue.delete(v);
            }
            return hash;
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + (char)t + "'."));
    }

    public String toString() {
        char type = this.getFormatType();
        int size = this.getSize();
        if (type == ' ') {
            return "None";
        }
        if (type == 'A') {
            return this.toA();
        }
        if (type == 'Z') {
            return this.toZ();
        }
        if (size == 1 && XMValue.isNumericType(type)) {
            switch (type) {
                case 'B': {
                    return Byte.toString(this.toB());
                }
                case 'O': {
                    return Integer.toString(this.toL());
                }
                case 'I': {
                    return Short.toString(this.toI());
                }
                case 'L': {
                    return Integer.toString(this.toL());
                }
                case 'X': {
                    return Long.toString(this.toX());
                }
                case 'F': {
                    return Float.toString(this.toF());
                }
                case 'D': {
                    return Double.toString(this.toD());
                }
            }
            throw new AssertionError((Object)("Invalid XMValue type '" + type + "'."));
        }
        if (XMValue.isNumericType(type) || type == 'C') {
            char open = type == 'C' ? (char)'[' : '(';
            char close = type == 'C' ? (char)']' : ')';
            boolean showType = type == 'C';
            StringBuilder str = new StringBuilder();
            str.append(open);
            for (int i = 1; i <= size; ++i) {
                XMValue val = this.get(i);
                if (i != 1) {
                    str.append(',');
                }
                if (showType) {
                    str.append(val.getFormatType()).append(':');
                }
                str.append(val);
            }
            str.append(close);
            return str.toString();
        }
        if (type == 'K' || type == 'H') {
            XMValue items = type == 'K' ? this : this.items();
            StringBuilder str = new StringBuilder();
            str.append('{');
            for (int i = 1; i <= size; ++i) {
                KVPair pair = items.backend.getPair(i);
                String key = pair.getKey();
                XMValue val = pair.getValue();
                if (i != 1) {
                    str.append(',');
                }
                str.append(val.getFormatType()).append(':');
                str.append(key).append('=');
                str.append(val);
            }
            str.append('}');
            if (type != 'K') {
                XMValue.delete(items);
            }
            return str.toString();
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + type + "'."));
    }

    public void setValue(XMValue v) {
        this.backend.setValue(v);
    }

    public void setValue(Data v) {
        this.backend.setValue(v);
    }

    public void setValue(String v) {
        this.backend.setValue(v);
    }

    public void setValue(byte v) {
        this.backend.setValue(v);
    }

    public void setValue(short v) {
        this.backend.setValue(v);
    }

    public void setValue(int v) {
        this.backend.setValue(v);
    }

    public void setValue(long v) {
        this.backend.setValue(v);
    }

    public void setValue(float v) {
        this.backend.setValue(v);
    }

    public void setValue(double v) {
        this.backend.setValue(v);
    }

    public void setValue(byte[] v) {
        this.backend.setValue(v);
    }

    public void setValue(short[] v) {
        this.backend.setValue(v);
    }

    public void setValue(int[] v) {
        this.backend.setValue(v);
    }

    public void setValue(long[] v) {
        this.backend.setValue(v);
    }

    public void setValue(float[] v) {
        this.backend.setValue(v);
    }

    public void setValue(double[] v) {
        this.backend.setValue(v);
    }

    public final void setValue(XMValue[] v) {
        this.backend.setValue('C');
        for (XMValue e : v) {
            this.backend.add(e);
        }
    }

    public final void setValue(KVPair[] v) {
        this.backend.setValue('K');
        for (KVPair e : v) {
            this.backend.add(e.getKey(), e.getValue());
        }
    }

    public void setValue(Map<String, XMValue> v) {
        this.backend.setValue('H');
        for (Map.Entry<String, XMValue> e : v.entrySet()) {
            this.backend.add(e.getKey(), e.getValue());
        }
    }

    public final void setFormatType(char type) {
        if (!XMValue.isLegalType(type)) {
            throw new IllegalArgumentException("Invalid type '" + type + "' expected one of '" + legalTypes + "'.");
        }
        this.backend.setValue(type);
    }

    XMValue convertTo(int newSize, int newSPA, char newMode, char newType) {
        char type = this.getFormatType();
        int size = this.getSize();
        if (newSize == -1) {
            newSize = size;
        }
        if (newSPA == -1) {
            newSPA = 1;
            newMode = (char)83;
        }
        if (newType == '_') {
            newType = type;
        }
        if (type == newType) {
            return this;
        }
        XMValue val = this.copy();
        val.setFormatType(newType);
        return val;
    }

    public final void setValue(char type, double value) throws UnsupportedOperationException {
        this.setValue(type, 1, value);
    }

    public final void setValue(char type, int size, double value) throws UnsupportedOperationException {
        if (!XMValue.isLegalType(type)) {
            throw new IllegalArgumentException("Invalid type '" + type + "' expected one of '" + legalTypes + "'.");
        }
        if (this.isStringKeyed()) {
            throw new UnsupportedOperationException("Can not use XMValue.get(int) with type " + this.getTypeName() + ".");
        }
        this.backend.setValue(type, size, value);
    }

    public char getFormatType() {
        return this.backend.getFormatType();
    }

    public final String getTypeName() {
        return XMValue.getTypeName(this.getFormatType());
    }

    public final boolean isNumericType() {
        return XMValue.isNumericType(this.getFormatType());
    }

    public final boolean isBasicType() {
        return XMValue.isBasicType(this.getFormatType());
    }

    public final boolean isContainer() {
        return XMValue.isContainer(this.getFormatType());
    }

    public final boolean isStringKeyed() {
        return XMValue.isStringKeyed(this.getFormatType());
    }

    private final boolean isVectorOrList() {
        char type = this.getFormatType();
        return XMValue.isNumericType(this.getFormatType()) && !this.backend.isScalar() || type == 'C' || type == 'K';
    }

    public final XMValue copy() {
        XMValue v = new XMValue(this.backend.getClass());
        v.setValue(this);
        return v;
    }

    public int size() {
        return this.backend.size();
    }

    public final int getSize() {
        return this.backend.size();
    }

    public final boolean isEmpty() {
        return this.backend.size() == 0;
    }

    public final XMValue get(int i) throws UnsupportedOperationException, ArrayIndexOutOfBoundsException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.get(int) with a TABLE.");
        }
        if (i < 1 || i > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Can not get element " + i + " in XMValue with only " + this.size() + " elements.");
        }
        return this.backend.get(i);
    }

    public final XMValue get(String key) {
        if (this.isStringKeyed()) {
            return this.backend.get(key);
        }
        return this.get(Convert.s2l(key));
    }

    public final void set(int i, XMValue val) {
        char type = this.getFormatType();
        if (type == 'K') {
            if (!val.isStringKeyed() && val.size() != 1) {
                throw new UnsupportedOperationException("Can only use XMValue.set(int,XMValue) on a KVLIST if the value passed in is a TABLE or KVLIST os size 1; given " + val.getTypeName() + " of size " + val.size() + ".");
            }
            KVPair pair = val.backend.getPair(0);
            this.backend.set(i, pair.getKey(), pair.getValue());
            return;
        }
        if (i == 1 && type == 'A') {
            this.backend.setValue(val.toA());
            return;
        }
        if (i < 1 || i > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Can not set element " + i + " in XMValue with only " + this.size() + "elements.");
        }
        if (!this.isVectorOrList()) {
            throw new UnsupportedOperationException("Can not use XMValue.set(int,XMValue) with type " + this.getTypeName() + ".");
        }
        this.backend.set(i, val);
    }

    public final void set(String key, XMValue val) {
        if (this.isStringKeyed()) {
            this.backend.put(key, val);
        } else {
            this.set(Convert.s2l(key), val);
        }
    }

    public final void put(String key, XMValue val) {
        this.set(key, val);
    }

    public final XMValue set(int i, Object val) {
        XMValue v = XMValue.toXMValue(val);
        this.set(i, v);
        return v;
    }

    public final XMValue set(String key, Object val) {
        XMValue v = XMValue.toXMValue(val);
        this.set(key, v);
        return v;
    }

    public final boolean containsKey(String key) throws UnsupportedOperationException {
        if (!this.isStringKeyed()) {
            throw new UnsupportedOperationException("Can not use XMValue.containsKey(String) with type " + this.getTypeName() + ".");
        }
        return this.backend.containsKey(key);
    }

    public final void append(XMValue v) throws UnsupportedOperationException {
        if (!this.isVectorOrList()) {
            throw new UnsupportedOperationException("Can not use XMValue.append(XMValue) with type " + this.getTypeName() + ".");
        }
        this.backend.add(v);
    }

    public final void append(KVPair v) throws UnsupportedOperationException {
        if (!this.isStringKeyed()) {
            throw new UnsupportedOperationException("Can not use XMValue.append(KVPair) with type " + this.getTypeName() + ".");
        }
        this.backend.add(v.getKey(), v.getValue());
    }

    public final void merge(XMValue v) throws UnsupportedOperationException {
        char tt = this.getFormatType();
        char vt = v.getFormatType();
        if (!XMValue.isStringKeyed(tt) || !XMValue.isStringKeyed(vt)) {
            throw new UnsupportedOperationException("Incompatible types for XMValue.merge(XMValue) " + XMValue.getTypeName(tt) + " and " + XMValue.getTypeName(vt) + ".");
        }
        XMValue prevVal = v;
        if (v.getFormatType() != 'K') {
            v = v.items();
        }
        Backend b = v.backend;
        for (int i = 0; i < v.size(); ++i) {
            KVPair pair = b.getPair(i);
            this.backend.add(pair.getKey(), pair.getValue());
        }
        if (prevVal != v) {
            XMValue.delete(prevVal);
        }
        XMValue.delete(v);
    }

    public final void update(XMValue v) throws UnsupportedOperationException {
        char tt = this.getFormatType();
        char vt = v.getFormatType();
        if (!XMValue.isStringKeyed(tt) || !XMValue.isStringKeyed(vt)) {
            throw new UnsupportedOperationException("Incompatible types for XMValue.update(XMValue) " + XMValue.getTypeName(tt) + " and " + XMValue.getTypeName(vt) + ".");
        }
        XMValue prevVal = v;
        if (v.getFormatType() != 'K') {
            v = v.items();
        }
        Backend b = v.backend;
        for (int i = 0; i < v.size(); ++i) {
            KVPair pair = b.getPair(i);
            this.backend.put(pair.getKey(), pair.getValue());
        }
        if (prevVal != v) {
            XMValue.delete(prevVal);
        }
        XMValue.delete(v);
    }

    public void clear() {
        this.backend.clear();
    }

    public final XMValue vectorize() throws UnsupportedOperationException {
        char t = this.getFormatType();
        if (t == 'C') {
            return this.copy();
        }
        if (t == 'K') {
            return this.copy();
        }
        if (!XMValue.isNumericType(t)) {
            throw new UnsupportedOperationException("Can not use XMValue.vectorize() with type " + this.getTypeName() + ".");
        }
        return this.backend.isScalar() ? this.backend.vectorize() : this.copy();
    }

    public final XMValue tablize() throws UnsupportedOperationException {
        if (!this.isStringKeyed()) {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.tablize();
    }

    public final XMValue keys() throws UnsupportedOperationException {
        if (!this.isStringKeyed()) {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.keys();
    }

    public final XMValue items() throws UnsupportedOperationException {
        if (!this.isStringKeyed()) {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.items();
    }

    public final double toD() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toD();
    }

    public final float toF() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toF();
    }

    public final long toX() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toX();
    }

    public final int toL() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toL();
    }

    public final short toI() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toI();
    }

    public final byte toB() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toB();
    }

    public final String toA() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toA();
    }

    public final String toZ() throws UnsupportedOperationException {
        if (this.getFormatType() == 'H') {
            throw new UnsupportedOperationException("Can not use XMValue.tablize() with type " + this.getTypeName() + ".");
        }
        return this.backend.toZ();
    }

    public Number toNumber() {
        switch (this.getFormatType()) {
            case 'B': {
                return this.toB();
            }
            case 'I': {
                return this.toI();
            }
            case 'L': {
                return this.toL();
            }
            case 'X': {
                return this.toX();
            }
            case 'F': {
                return Float.valueOf(this.toF());
            }
            case 'D': {
                return this.toD();
            }
        }
        return this.toD();
    }

    public static String getTypeName(char type) {
        switch (type) {
            case ' ': {
                return "None";
            }
            case 'A': {
                return "ASCII";
            }
            case 'Z': {
                return "ASCII256";
            }
            case 'B': {
                return "int_1";
            }
            case 'O': {
                return "int_u1";
            }
            case 'I': {
                return "int_2";
            }
            case 'L': {
                return "int_4";
            }
            case 'X': {
                return "int_8";
            }
            case 'F': {
                return "real_4";
            }
            case 'D': {
                return "real_8";
            }
            case 'C': {
                return "List";
            }
            case 'K': {
                return "KVList";
            }
            case 'H': {
                return "Table";
            }
        }
        return "Unknown";
    }

    public static boolean isNumericType(char type) {
        switch (type) {
            case 'B': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'D': {
                return true;
            }
        }
        return false;
    }

    public static boolean isBasicType(char type) {
        return type == 'A' || type == 'Z' || XMValue.isNumericType(type);
    }

    public static boolean isContainer(char type) {
        return type == 'C' || type == 'K' || type == 'H';
    }

    public static boolean isStringKeyed(char type) {
        return type == 'K' || type == 'H';
    }

    public static boolean isLegalType(char type) {
        return legalTypes.indexOf(type) >= 0;
    }

    public static void delete(XMValue ... xmValues) {
        for (XMValue xmVal : xmValues) {
            xmVal.delete();
        }
    }

    public void delete() {
        this.backend.delete();
    }

    public static interface Backend {
        public void setValue(String var1);

        public void setValue(byte var1);

        public void setValue(short var1);

        public void setValue(int var1);

        public void setValue(long var1);

        public void setValue(float var1);

        public void setValue(double var1);

        public void setValue(byte[] var1);

        public void setValue(short[] var1);

        public void setValue(int[] var1);

        public void setValue(long[] var1);

        public void setValue(float[] var1);

        public void setValue(double[] var1);

        public void setValue(XMValue var1);

        public void setValue(Data var1);

        public void clear();

        public void add(XMValue var1);

        public void add(String var1, XMValue var2);

        public void put(String var1, XMValue var2);

        public void set(int var1, XMValue var2);

        public void set(int var1, String var2, XMValue var3);

        public void setValue(char var1);

        public void setValue(char var1, int var2, double var3);

        public char getFormatType();

        public int size();

        public boolean isScalar();

        public boolean containsKey(String var1);

        public KVPair getPair(int var1);

        public XMValue get(int var1);

        public XMValue get(String var1);

        public XMValue vectorize();

        public XMValue tablize();

        public XMValue keys();

        public XMValue items();

        public double toD();

        public float toF();

        public long toX();

        public int toL();

        public short toI();

        public byte toB();

        public String toA();

        public String toZ();

        default public void delete() {
        }
    }

    public static final class KVPair
    implements Map.Entry<String, XMValue> {
        private String key;
        private XMValue val;

        public KVPair(Map.Entry<String, XMValue> entry) {
            this.key = entry.getKey();
            this.val = entry.getValue();
        }

        public KVPair(String key, XMValue val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public XMValue getValue() {
            return this.val;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            KVPair e1 = this;
            Map.Entry e2 = (Map.Entry)o;
            return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public XMValue setValue(XMValue v) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("setValue(XMValue) not supported");
        }
    }
}

