/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.SpecialLoggingRequired;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

@SpecialLoggingRequired
public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    public static final int NS_FACTOR = 1000000;
    private static final AtomicLong nsOffset;
    private static final Map<String, List<String>> OS_LIST;
    private static final Map<String, List<String>> ARCH_LIST;

    private Util() {
    }

    private static long getNsOffset() {
        long lastMS = System.currentTimeMillis();
        int i = 0;
        while (true) {
            long ms = System.currentTimeMillis();
            long ns = System.nanoTime();
            if (ms == lastMS + 1L && i >= 100000) {
                return ms * 1000000L - ns;
            }
            lastMS = ms;
            ++i;
        }
    }

    public static long currentTimeNano() {
        long nano;
        if (nsOffset == null) {
            return System.currentTimeMillis() * 1000000L;
        }
        while (true) {
            long error;
            long ms;
            long nsOff = nsOffset.get();
            long ns = System.nanoTime() + nsOff;
            long ns2ms = ns / 1000000L;
            if (ns2ms == (ms = System.currentTimeMillis())) {
                if (nsOffset.get() != nsOff) continue;
                return ns;
            }
            if (ns2ms > ms) {
                error = ns - ms * 1000000L;
                nano = ms * 1000000L + 999999L;
                if (!nsOffset.compareAndSet(nsOff, nsOff - error / 2L)) continue;
                return nano;
            }
            error = ms * 1000000L - ns;
            nano = ms * 1000000L;
            if (nsOffset.compareAndSet(nsOff, nsOff - error / 2L)) break;
        }
        return nano;
    }

    private static Object doCombineArrays(Class<?> clazz, Object dest, Object first, Object second) {
        int firstLength = Array.getLength(first);
        int secondLength = Array.getLength(second);
        if (dest == null) {
            dest = Array.newInstance(clazz, firstLength + secondLength);
        }
        System.arraycopy(first, 0, dest, 0, firstLength);
        System.arraycopy(second, 0, dest, firstLength, secondLength);
        return dest;
    }

    public static Object combineArrays(Object dest, Object first, Object second) {
        Class<Object> clazz = null;
        if (dest == null) {
            Class<?> secondClass;
            Class<?> firstClass = first.getClass().getComponentType();
            clazz = firstClass.equals(secondClass = second.getClass().getComponentType()) || firstClass.isPrimitive() ? firstClass : Object.class;
        }
        return Util.doCombineArrays(clazz, dest, first, second);
    }

    public static Object combineArrays(Object first, Object second) {
        return Util.combineArrays(null, first, second);
    }

    public static Object combineArraysAs(Class<?> clazz, Object first, Object second) {
        return Util.doCombineArrays(clazz, null, first, second);
    }

    public static <T> T[] reverseArray(T[] array, int startIndex) {
        if (array == null) {
            return array;
        }
        int right = array.length - 1;
        for (int left = startIndex; left < right; ++left, --right) {
            T tmp = array[left];
            array[left] = array[right];
            array[right] = tmp;
        }
        return array;
    }

    public static boolean removeListElements(List<?> list3, int start, int count) {
        boolean anyRemoved = false;
        if (start >= 0 && start < list3.size() && count != 0 && !list3.isEmpty()) {
            if (count < 0) {
                if (start == 0) {
                    list3.clear();
                } else {
                    while (start < list3.size()) {
                        list3.remove(start);
                    }
                }
            } else {
                for (int i = 0; i < count && start < list3.size(); ++i) {
                    list3.remove(start);
                }
            }
            anyRemoved = true;
        }
        return anyRemoved;
    }

    public static <E extends Enum<E>> E valueOf(Class<E> enumType, String name) {
        if (enumType == null) {
            throw new NullPointerException("Expected an enumerated type, given null");
        }
        if (name == null) {
            throw new NullPointerException("Cannot convert NULL to instance of " + enumType);
        }
        Object[] enums = (Enum[])enumType.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException("Expected an enumerated type, given " + enumType);
        }
        for (Enum enum_ : enums) {
            if (!enum_.toString().equals(name)) continue;
            return (E)enum_;
        }
        for (Enum enum_ : enums) {
            if (!enum_.toString().equalsIgnoreCase(name)) continue;
            return (E)enum_;
        }
        throw new IllegalArgumentException("Selection '" + name + "' not found in " + StringUtil.join(enums));
    }

    public static boolean equals(Object val1, Object val2) {
        boolean equal = true;
        if (val1 != val2) {
            if (val1 == null || val2 == null) {
                equal = false;
            } else {
                Number num1 = Convert.o2n(val1);
                Number num2 = Convert.o2n(val2);
                equal = num1 != null && num2 != null ? num1.doubleValue() == num2.doubleValue() : val1.toString().equals(val2.toString());
            }
        }
        return equal;
    }

    public static int compare(Object val1, Object val2) {
        int comp;
        if (val1 == val2) {
            comp = 0;
        } else {
            Number num1 = Convert.o2n(val1);
            Number num2 = Convert.o2n(val2);
            comp = num1 != null && num2 != null ? Double.compare(num1.doubleValue(), num2.doubleValue()) : val1.toString().compareTo(val2.toString());
        }
        return comp;
    }

    public static String getClassName(Object obj) {
        return obj == null ? null : Util.getClassName(obj.getClass());
    }

    public static String getClassName(Class<?> clazz) {
        String name = clazz.getName();
        if (!Proxy.isProxyClass(clazz)) {
            String tmp;
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(i + 1);
            }
            if ((i = name.indexOf(36)) > 0 && !StringUtil.isInteger(tmp = name.substring(i + 1))) {
                name = tmp;
            }
        }
        return name;
    }

    public static Constructor<?> getConstructor(String signature, boolean except) {
        Constructor<?> constructor;
        try {
            int open = signature.indexOf(40);
            int close = signature.indexOf(41);
            String className = signature.substring(0, open).trim();
            String typeNames = signature.substring(open + 1, close).trim();
            Class<?> clazz = Class.forName(className);
            Class<?>[] types = Util.getTypes(typeNames);
            constructor = clazz.getConstructor(types);
        }
        catch (Exception e) {
            if (except) {
                throw new MidasException("Unable to load method " + signature, e);
            }
            constructor = null;
        }
        return constructor;
    }

    public static Method getMethod(String signature, boolean except) {
        Method method;
        try {
            int open = signature.indexOf(40);
            int close = signature.indexOf(41);
            int dot = signature.lastIndexOf(46, open);
            String className = signature.substring(0, dot).trim();
            String methodName = signature.substring(dot + 1, open).trim();
            String typeNames = signature.substring(open + 1, close).trim();
            Class<?> clazz = Class.forName(className);
            Class<?>[] types = Util.getTypes(typeNames);
            method = clazz.getMethod(methodName, types);
        }
        catch (Exception e) {
            if (except) {
                throw new MidasException("Unable to load method " + signature, e);
            }
            method = null;
        }
        return method;
    }

    public static Field getField(String signature, boolean except) {
        Field field;
        try {
            int dot = signature.lastIndexOf(46);
            String className = signature.substring(0, dot).trim();
            String fieldName = signature.substring(dot + 1).trim();
            Class<?> clazz = Class.forName(className);
            field = clazz.getField(fieldName);
        }
        catch (Exception e) {
            if (except) {
                throw new MidasException("Unable to load field " + signature, e);
            }
            field = null;
        }
        return field;
    }

    private static Class<?>[] getTypes(String typeNames) throws ClassNotFoundException {
        String[] args = typeNames.length() == 0 ? new String[]{} : typeNames.split("\\s*[,]\\s*");
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Util.getClass(args[i]);
        }
        return types;
    }

    public static Class<?> getClass(String name) throws ClassNotFoundException {
        int arrayCount = 0;
        char symbol = 'L';
        Class<Comparable<Byte>> clazz = null;
        while (name.endsWith("[]")) {
            ++arrayCount;
            name = name.substring(0, name.length() - 2).trim();
        }
        if (name.equals("byte")) {
            clazz = Byte.TYPE;
            symbol = 'B';
        }
        if (name.equals("short")) {
            clazz = Short.TYPE;
            symbol = 'S';
        }
        if (name.equals("int")) {
            clazz = Integer.TYPE;
            symbol = 'I';
        }
        if (name.equals("long")) {
            clazz = Long.TYPE;
            symbol = 'J';
        }
        if (name.equals("float")) {
            clazz = Float.TYPE;
            symbol = 'F';
        }
        if (name.equals("double")) {
            clazz = Double.TYPE;
            symbol = 'D';
        }
        if (name.equals("boolean")) {
            clazz = Boolean.TYPE;
            symbol = 'Z';
        }
        if (name.equals("char")) {
            clazz = Character.TYPE;
            symbol = 'C';
        }
        if (arrayCount > 0) {
            String arraySpec = StringUtil.padRight("", arrayCount, '[');
            clazz = symbol == 'L' ? Class.forName(arraySpec + "L" + name + ";") : Class.forName(arraySpec + symbol);
        }
        return clazz != null ? clazz : Class.forName(name);
    }

    private static void addOsArchEntries(Map<String, List<String>> map, String ... entries) {
        List<String> list3 = Arrays.asList(entries);
        for (String e : list3) {
            map.put(e, list3);
            map.put(e.toLowerCase(), list3);
            map.put(e.toUpperCase(), list3);
            if (!e.contains(" ")) continue;
            e = e.replace(' ', '_');
            map.put(e, list3);
            map.put(e.toLowerCase(), list3);
            map.put(e.toUpperCase(), list3);
        }
    }

    public static String getOSName(String os) {
        if (os == null || os.isEmpty()) {
            os = Shell.getProperty("os.name");
        }
        return Util.getOSList(os).get(0).toLowerCase().replace(' ', '_');
    }

    public static String getArchName(String arch) {
        if (arch == null || arch.isEmpty()) {
            arch = Shell.getProperty("os.arch");
        }
        return Util.getArchList(arch).get(0).toLowerCase().replace(' ', '_');
    }

    public static List<String> getOSList(String os) {
        os = os.trim();
        return Util.getOSList(os, os);
    }

    private static List<String> getOSList(String os, String def) {
        List<String> list3 = OS_LIST.get(os.trim());
        if (list3 != null) {
            return list3;
        }
        int i = os.lastIndexOf(32);
        if (i > 0) {
            return Util.getOSList(os.substring(0, i), def);
        }
        i = os.lastIndexOf(95);
        if (i > 0) {
            return Util.getOSList(os.substring(0, i), def);
        }
        return Arrays.asList(def);
    }

    public static List<String> getArchList(String arch) {
        List<String> list3 = ARCH_LIST.get(arch.trim());
        return list3 != null ? list3 : Arrays.asList(arch);
    }

    public static String getNativeJarName(String opt, String os, String arch) {
        if (StringUtil.isNull(os) || os.isEmpty()) {
            os = Util.getOSName(null);
        }
        if (StringUtil.isNull(arch) || arch.isEmpty()) {
            arch = Util.getArchName(null);
        }
        return "nxm-" + opt.toLowerCase() + "-native-" + os + "-" + arch + ".jar";
    }

    public static <T> String getShortClassName(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        String className = clazz.getCanonicalName();
        Package pkg = clazz.getPackage();
        return pkg == null ? className : className.substring(pkg.getName().length() + 1);
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static <T> T first(Collection<T> c) {
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        if (c instanceof Deque) {
            return (T)((Deque)c).getFirst();
        }
        if (c instanceof List) {
            return (T)((List)c).get(0);
        }
        if (c instanceof SortedSet) {
            return (T)((SortedSet)c).first();
        }
        return c.iterator().next();
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static <T> T last(Collection<T> c) {
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        if (c instanceof Deque) {
            return (T)((Deque)c).getLast();
        }
        if (c instanceof List) {
            return (T)((List)c).get(c.size() - 1);
        }
        if (c instanceof SortedSet) {
            return (T)((SortedSet)c).last();
        }
        Iterator<T> i = c.iterator();
        T v = i.next();
        while (i.hasNext()) {
            v = i.next();
        }
        return v;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... vals) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(vals)));
    }

    @SafeVarargs
    public static <T> SortedSet<T> asSortedSet(T ... vals) {
        return Collections.unmodifiableSortedSet(new TreeSet<T>(Arrays.asList(vals)));
    }

    public static ThreadFactory newThreadFactory(String name) {
        Objects.requireNonNull(name);
        ThreadGroup threadGroup = new ThreadGroup(name);
        return r -> {
            Thread thread = new Thread(threadGroup, r);
            thread.setUncaughtExceptionHandler((t, e) -> LOG.log(Level.SEVERE, "Uncaught exception in " + t.getName(), e));
            return thread;
        };
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static RejectedExecutionHandler newRejectedExecutionHandler(String name) {
        Objects.requireNonNull(name);
        return (r, ex) -> LOG.log(Level.SEVERE, "{0}: Rejected execution of {1} by {2}", new Object[]{name, r, ex});
    }

    public static Number scale(Number val, int scale) {
        return Util.round(val, scale);
    }

    public static Number round(Number val, int scale) {
        return Util.round(val, scale, RoundingMode.HALF_EVEN, false, 1);
    }

    public static Number round(Number val, int scale, RoundingMode mode, boolean keepSign, int fast) {
        BigDecimal num;
        if (val == null) {
            return null;
        }
        if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long || val instanceof AtomicInteger || val instanceof AtomicLong) {
            if (fast >= 1 && scale >= 0) {
                return val;
            }
            num = BigDecimal.valueOf(val.longValue());
        } else if (val instanceof Double || val instanceof Float) {
            double v = val.doubleValue();
            if (Double.isInfinite(v)) {
                return v;
            }
            if (Double.isNaN(v)) {
                return v;
            }
            if (v == 0.0 && fast >= 1) {
                return v;
            }
            num = BigDecimal.valueOf(v);
        } else if (val instanceof BigDecimal) {
            num = (BigDecimal)val;
        } else if (val instanceof BigInteger) {
            num = new BigDecimal(val.toString());
        } else {
            try {
                num = new BigDecimal(val.toString());
            }
            catch (NumberFormatException e) {
                try {
                    double v = val.doubleValue();
                    if (Double.isInfinite(v)) {
                        return v;
                    }
                    if (Double.isNaN(v)) {
                        return v;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                throw e;
            }
        }
        BigDecimal dec = num.setScale(scale, mode);
        if (keepSign && dec.signum() != num.signum()) {
            dec = BigDecimal.valueOf(num.signum(), scale);
        }
        if (fast >= 2 || scale >= 0) {
            return dec;
        }
        return dec.setScale(0, mode);
    }

    static {
        int skip = 5;
        int loops = 20;
        long[] offsets = new long[loops + skip];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = Util.getNsOffset();
        }
        BigInteger sum = BigInteger.ZERO;
        for (int i = skip; i < offsets.length; ++i) {
            sum = sum.add(BigInteger.valueOf(offsets[i]));
        }
        nsOffset = new AtomicLong(sum.divide(BigInteger.valueOf(loops)).longValueExact());
        LinkedHashMap<String, List<String>> osList = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> archList = new LinkedHashMap<String, List<String>>();
        Util.addOsArchEntries(osList, "FreeBSD", "freebsd");
        Util.addOsArchEntries(osList, "Linux", "linux");
        Util.addOsArchEntries(osList, "Mac OS X", "mac os x", "Mac_OS_X", "mac_os_x");
        Util.addOsArchEntries(osList, "SunOS", "sunos");
        Util.addOsArchEntries(osList, "Windows", "windows");
        Util.addOsArchEntries(archList, "ppc");
        Util.addOsArchEntries(archList, "sparc");
        Util.addOsArchEntries(archList, "sparcv9");
        Util.addOsArchEntries(archList, "x86", "i386", "i686");
        Util.addOsArchEntries(archList, "x86_64", "amd64");
        archList.put("universal", Arrays.asList("universal", "i386", "x86", "x86_64"));
        archList.put("UNIVERSAL", Arrays.asList("universal", "i386", "x86", "x86_64"));
        OS_LIST = Collections.unmodifiableMap(osList);
        ARCH_LIST = Collections.unmodifiableMap(archList);
    }
}

