/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.net.MalformedURLException;
import java.util.Vector;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Terminal;
import nxm.sys.lib.Util;

public class TextFile
extends BaseFile
implements ListFile {
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private int bufin = 0;
    private int bufout = 0;
    private int lineOffset = 0;
    private String inclStr = null;
    private TextFile inclFile = null;
    private int readProperCount = 0;
    private boolean allowMultiLineComments = true;
    private boolean midQuote = false;
    private Vector<String> lines = null;

    public TextFile() {
    }

    public TextFile(String filename) {
        this.init(null, (Object)filename);
    }

    public TextFile(FileName fn) {
        this.init(null, (Object)fn);
    }

    @Deprecated
    public TextFile(Object ref, Object filename) {
        this.init(Convert.ref2MidasReference(ref), filename);
    }

    public TextFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public synchronized boolean open(int flag) {
        return super.open(flag);
    }

    @Override
    public synchronized boolean open() {
        if ((this.flags & 0x2020) == 0) {
            try {
                if ((this.flags & 3) == 3 && !this.exists()) {
                    this.M.warning("TextFile: " + this.getName() + " does not exist (flags=" + this.getFlagsString() + ") opening file for OUTPUT only. -- This behavior is deprecated and will be disabled in future releases.");
                    this.flags &= 0xFFFFFFFE;
                }
                return super.open();
            }
            catch (MidasException e) {
                if (e.getCause() instanceof BaseFile.CouldNotFindException) {
                    this.M.warning("Could not find URL=" + this.getURL() + " -- This will be an ERROR rather than a WARNING in future releases (see TextFile.open(int) for more details).");
                    return false;
                }
                throw e;
            }
        }
        return super.open();
    }

    @Override
    public synchronized void close() {
        int bytesWritten;
        if ((this.M.debug & 1) != 0) {
            this.M.info("CloseTF Path=" + this.getURL());
        }
        if (!this.isOpen) {
            return;
        }
        if (this.isOutput && this.bufin > 0 && (bytesWritten = this.io.write(this.buffer, 0, this.bufin)) > 0) {
            this.bufin = -bytesWritten;
        }
        this.io.close();
        this.isOpen = false;
    }

    @Override
    public double getSize() {
        this.size = this.io.getLength();
        return this.size;
    }

    @Override
    public String getMimeType() {
        String ext = this.getName().getExt();
        if (ext != null) {
            if ((ext = ext.toLowerCase()).equals("xhtml")) {
                return "text/html";
            }
            if (ext.equals("html")) {
                return "text/html";
            }
            if (ext.equals("htm")) {
                return "text/html";
            }
            if (ext.equals("jnlp")) {
                return "application/x-java-jnlp-file";
            }
            if (ext.equals("xml")) {
                return "text/xml";
            }
            if (ext.equals("css")) {
                return "text/css";
            }
            if (ext.equals("js")) {
                return "application/x-javascript";
            }
        }
        return "text/plain";
    }

    @Override
    public synchronized void flush() {
        if (this.isOutput && this.bufin > 0) {
            this.io.write(this.buffer, 0, this.bufin);
            this.bufin = 0;
        }
    }

    public synchronized void write(String text) {
        this.write(text, false);
    }

    private synchronized void write(String text, boolean holdflush) {
        boolean doflush;
        int i;
        int lenText;
        if (!this.isOpen) {
            return;
        }
        int bytes = 4096 - this.bufin;
        int bytesToWrite = lenText = text.length();
        int bytesWritten = 0;
        while (bytesToWrite >= bytes) {
            for (i = 0; i < bytes; ++i) {
                this.buffer[this.bufin++] = (byte)text.charAt(i + bytesWritten);
            }
            this.io.write(this.buffer, 0, this.bufin);
            this.bufin = 0;
            bytesToWrite -= bytes;
            bytesWritten += bytes;
        }
        for (i = bytesWritten; i < lenText; ++i) {
            this.buffer[this.bufin++] = (byte)text.charAt(i);
        }
        boolean bl = doflush = !holdflush && this.bufin > 0 && (this.flags & 0x10) != 0;
        if (doflush || this.bufin == 4096) {
            this.io.write(this.buffer, 0, this.bufin);
            this.bufin = 0;
        }
    }

    public synchronized void writeln(String text) {
        boolean doflush;
        if (!this.isOpen) {
            return;
        }
        this.write(text, true);
        this.buffer[this.bufin++] = 10;
        boolean bl = doflush = this.bufin > 0 && (this.flags & 0x10) != 0;
        if (doflush || this.bufin == 4096) {
            this.io.write(this.buffer, 0, this.bufin);
            this.bufin = 0;
        }
    }

    public synchronized String read() {
        FileName path;
        int i;
        if (!this.isOpen) {
            return null;
        }
        if (this.inclFile != null) {
            String line = this.inclFile.read();
            if (line != null) {
                return line;
            }
            this.inclFile.close();
            this.inclFile = null;
        }
        String string = null;
        if (this.bufout >= this.bufin) {
            this.bufin = this.io.read(this.buffer, 0, 4096);
            this.bufout = 0;
        }
        for (i = this.bufout; i < this.bufin && this.buffer[i] != 10; ++i) {
        }
        while (i == this.bufin && this.bufin == 4096) {
            string = string == null ? new String(this.buffer, this.bufout, this.bufin - this.bufout) : string + new String(this.buffer, this.bufout, this.bufin - this.bufout);
            this.bufin = this.io.read(this.buffer, 0, 4096);
            this.bufout = 0;
            for (i = 0; i < this.bufin && this.buffer[i] != 10; ++i) {
            }
        }
        if (i != this.bufout || this.bufin > 0) {
            string = string == null ? new String(this.buffer, this.bufout, i - this.bufout) : string + new String(this.buffer, this.bufout, i - this.bufout);
        }
        this.bufout = i + 1;
        if (this.inclStr != null && string != null && !this.midQuote && (path = this.isIncludeLine(string)) != null) {
            this.inclFile = new TextFile(path);
            this.inclFile.setIncludeString(this.inclStr);
            this.inclFile.open(8192);
            string = this.inclFile.readProper();
        }
        this.midQuote = string != null && !string.equals("") && string.endsWith("&");
        return string;
    }

    public void setIncludeString(String str) {
        this.inclStr = str;
    }

    public final FileName isIncludeLine(String line) {
        if (this.inclStr == null || line == null) {
            return null;
        }
        try {
            String ucLine = line.toUpperCase();
            String ucIncl = this.inclStr.toUpperCase();
            if (ucLine.trim().startsWith(ucIncl)) {
                String[] temp;
                String mdelimiter;
                int pos = ucLine.indexOf(ucIncl);
                if (pos > -1) {
                    line = line.substring(pos + this.inclStr.length());
                }
                if ((line = StringUtil.stripQuotes(line.trim())).contains(mdelimiter = ";") && (temp = StringUtil.split(line, mdelimiter)).length > 1) {
                    String fname = temp[0];
                    String optname = temp[1];
                    String area = "MCR";
                    String patharea = OptionTree.getOptPath(optname, area);
                    if (patharea != null) {
                        patharea = patharea + fname;
                        return this.getFileName().relativeTo(patharea.trim());
                    }
                    this.M.warning("Could not find corrected path to option tree: " + optname + " area: " + area);
                }
                return this.getFileName().relativeTo(line.trim());
            }
        }
        catch (MalformedURLException excep) {
            this.M.warning("Poorly formed url for " + line);
        }
        return null;
    }

    public String readProper() {
        String next;
        String full = null;
        int iSlashStar = -1;
        int iStarSlash = -1;
        int multiCount = 0;
        boolean isQuoted = false;
        while ((next = this.read()) != null) {
            int iq;
            ++this.readProperCount;
            int ib = (next = next.trim()).indexOf(33);
            if (ib == 0) continue;
            if (ib > 0) {
                iq = isQuoted ? 1 : 0;
                for (int i = 0; i < ib; ++i) {
                    if (next.charAt(i) != '\"') continue;
                    iq = 1 - iq;
                }
                if (iq != 0) {
                    ib = -1;
                }
            }
            if (ib > 0) {
                next = next.substring(0, ib);
            }
            if (this.allowMultiLineComments) {
                iSlashStar = this.checkForQuotes(next, "/*", isQuoted);
                if (iSlashStar >= 0) {
                    ++multiCount;
                }
                if ((iStarSlash = this.checkForQuotes(next, "*/", isQuoted)) >= 0) {
                    --multiCount;
                }
                if (iSlashStar == 0 && iStarSlash > 0 || multiCount > 0 || multiCount == 0 && iStarSlash == 0) continue;
                if (iSlashStar > 0 && next.endsWith("*/")) {
                    next = next.substring(0, iSlashStar);
                }
            }
            if (next.length() == 0) continue;
            next = next.trim();
            if (!(full = full == null || full.length() == 0 ? next : full + next).endsWith("&")) {
                isQuoted = false;
                break;
            }
            iq = isQuoted ? 1 : 0;
            for (int ii = 0; ii < full.length(); ++ii) {
                if (full.charAt(ii) != '\"') continue;
                iq = 1 - iq;
            }
            if (iq != 0) {
                isQuoted = true;
            }
            if (!(full = full.substring(0, full.length() - 1)).endsWith("&")) continue;
            break;
        }
        return full;
    }

    private int checkForQuotes(String text, String searchStr, boolean startsQuoted) {
        int iq = startsQuoted ? 1 : 0;
        int index = text.indexOf(searchStr);
        if (index < 0) {
            return -1;
        }
        for (int i = 0; i < index; ++i) {
            if (text.charAt(i) != '\"') continue;
            iq = 1 - iq;
        }
        return iq != 0 ? -1 : index;
    }

    int getReadProperCount() {
        return this.readProperCount;
    }

    public String readAll() {
        return StringUtil.join(this.readAllLines(), "\n");
    }

    public String[] readAllLines() {
        if (this.lines == null) {
            this.readFile();
        }
        return this.lines.toArray(StringUtil.EMPTY_STRING_ARRAY);
    }

    public static String[] readAllLines(MidasReference ref, Object filename) {
        TextFile inFile = new TextFile(ref, filename);
        inFile.open(8192);
        String[] allLines = inFile.readAllLines();
        inFile.close();
        return allLines;
    }

    @Override
    public String toString() {
        return "TextFile : " + this.getURL();
    }

    @Override
    public String listHeader() {
        String list3 = "TextFile : " + this.getURL() + "\nSize     : " + this.getSize() + " bytes\n";
        return list3;
    }

    public int copy(TextFile out) {
        if (out == null) {
            throw new IllegalArgumentException("out file cannot be null");
        }
        boolean closeIn = false;
        if (!this.isOpen()) {
            if (!this.open(33)) {
                this.M.warning("Unable to open URL=" + this.getURL() + " for input");
            }
            closeIn = true;
        }
        boolean closeOut = false;
        if (!out.isOpen()) {
            if (!out.open(34)) {
                this.M.warning("Unable to open URL=" + out.getURL() + " for output");
            }
            closeOut = true;
        }
        int nlines = 0;
        String line = null;
        while ((line = this.read()) != null) {
            out.write(line + "\n");
            ++nlines;
        }
        if (closeIn) {
            this.close();
        }
        if (closeOut) {
            out.close();
        }
        return nlines;
    }

    public int list(Terminal terminal, long lineOffset, long linesToShow, boolean showNumbers) {
        long lastLineNum = linesToShow + lineOffset;
        boolean done = false;
        int linesRead = 0;
        String line = null;
        while (!done && (long)linesRead < lastLineNum) {
            line = this.read();
            ++linesRead;
            if (line == null) {
                done = true;
                continue;
            }
            if ((long)linesRead <= lineOffset) continue;
            if (showNumbers) {
                this.M.println("" + linesRead + ": " + line);
                continue;
            }
            this.M.println(line);
        }
        return linesRead;
    }

    @Override
    public String listElements(double start, int elem, String format, int flags) {
        String line = "";
        while ((double)this.lineOffset <= start) {
            line = this.read();
            if (line == null) {
                return null;
            }
            ++this.lineOffset;
        }
        return line + "\n";
    }

    @Override
    public int listElementsPerLine(int lineWidth, String format, int flags) {
        return 1;
    }

    private void readFile() {
        this.lines = new Vector();
        String line = null;
        while ((line = this.read()) != null) {
            this.lines.add(line);
        }
    }

    @Override
    public double getNumberOfRows() {
        if (this.lines == null) {
            this.readFile();
        }
        return this.lines.size();
    }

    @Override
    public boolean getProtected() {
        return true;
    }

    @Override
    public Table getDataTable(double offset) {
        if (offset < 0.0) {
            return null;
        }
        if (this.lines == null) {
            this.readFile();
        }
        Table tbl = null;
        if (offset < (double)this.lines.size() && offset >= 0.0) {
            tbl = new Table();
            tbl.setKey("TEXT", this.lines.get((int)offset));
        }
        return tbl;
    }

    @Override
    public int setData(double offset, Table table) {
        this.setData(offset, "TEXT", table.getS("TEXT", ""));
        return 1;
    }

    @Override
    public void setData(double element, String fieldName, Object obj) {
        if (this.lines == null) {
            this.readFile();
        }
        if (fieldName.equals("TEXT")) {
            this.lines.set((int)this.offset, obj.toString());
        }
    }

    @Override
    public void insertData(double offset, Object obj) {
        if (this.lines == null) {
            this.readFile();
        }
        if (obj instanceof Table) {
            obj = ((Table)obj).getKey("TEXT");
        }
        if (offset >= 0.0 && offset < (double)this.lines.size()) {
            this.lines.insertElementAt(obj.toString(), (int)offset);
        } else if (offset >= 0.0) {
            while (offset > (double)(this.lines.size() - 1)) {
                this.lines.add("");
            }
            this.lines.add(obj.toString());
        }
    }

    @Override
    public final void removeData(double offset) {
        this.removeData(offset, 1L);
    }

    @Override
    public void removeData(double offset, long count) {
        if (this.lines == null) {
            this.readFile();
        }
        Util.removeListElements(this.lines, (int)offset, (int)count);
    }

    @Override
    public int getRecordDefCount() {
        return 1;
    }

    @Override
    public void setRecordDefs(Table defs) {
        if (defs.size() != 1 || !defs.getKeys()[0].equals("TEXT")) {
            throw new MidasException("TextFile: Can not alter record definitions in a TextFile.");
        }
    }

    @Override
    public Table getRecordDefs() {
        Table tbl = new Table();
        tbl.setKey("TEXT", this.getRecordDef(0));
        return tbl;
    }

    @Override
    public Table getRecordDef(int i) {
        Table tbl = new Table();
        tbl.setKey("NAME", "TEXT");
        return tbl;
    }
}

