/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

public class Sorter {
    public int size;
    private float[] key_vector;
    private float[] val_vector;
    private static final float invalid = -1.0E20f;

    public Sorter(int size) {
        this.size = size;
        this.key_vector = new float[size];
        this.val_vector = new float[size];
    }

    public void init() {
        for (int i = 0; i < this.size; ++i) {
            this.key_vector[i] = -1.0E20f;
            this.val_vector[i] = -1.0E20f;
        }
    }

    public void add(float key, float val) {
        int i = 0;
        while (this.key_vector[i] != -1.0E20f && key < this.key_vector[i]) {
            if (++i < this.size) continue;
            return;
        }
        for (int j = this.size - 1; j > i; --j) {
            this.key_vector[j] = this.key_vector[j - 1];
            this.val_vector[j] = this.val_vector[j - 1];
        }
        this.key_vector[i] = key;
        this.val_vector[i] = val;
    }

    public float getKey(int index, float defVal) {
        if (this.key_vector[index] != -1.0E20f) {
            return this.key_vector[index];
        }
        return defVal;
    }

    public float getVal(int index, float defVal) {
        if (this.val_vector[index] != -1.0E20f) {
            return this.val_vector[index];
        }
        return defVal;
    }
}

