/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

@InternalUseOnly
public class PredicateType {
    private Type type;
    private Class<?> typeClass;
    private Predicate<?> predicate;
    private String lambdaString = "";
    private static boolean debug = false;
    private static boolean extendedDebug = debug;

    @InternalUseOnly
    public PredicateType(Predicate<?> predicate, Type type) {
        this.predicate = predicate;
        this.type = type;
        try {
            this.typeClass = (Class)type;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @InternalUseOnly
    public PredicateType(Predicate<?> predicate, Type type, String lambdaExpression) {
        this(predicate, type);
        this.lambdaString = lambdaExpression;
    }

    @InternalUseOnly
    public Type getType() {
        return this.type;
    }

    @InternalUseOnly
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @InternalUseOnly
    public Predicate<?> getPredicate() {
        return this.predicate;
    }

    @InternalUseOnly
    public String getLambdaString() {
        return this.lambdaString;
    }

    @InternalUseOnly
    public static void addKeyFunction(Map<String, PredicateType> map, String key, Predicate<?> pred, Type type) {
        PredicateType pt = new PredicateType(pred, type);
        map.put(key, pt);
    }

    @InternalUseOnly
    public static void addKeyFunction(Map<String, PredicateType> map, String key, Predicate<?> pred, Type type, String description) {
        if (extendedDebug) {
            System.out.println("addKeyFunction key:" + key + " type:" + type);
        }
        PredicateType pt = new PredicateType(pred, type, description);
        map.put(key, pt);
    }

    @InternalUseOnly
    public static void addKeyFunction(Map<String, PredicateType> map, String key, String predTest, String predExpected) {
        PredicateType pt = PredicateType.predicateTypeCreator(predTest, predExpected);
        if (pt != null) {
            map.put(key, pt);
        } else {
            LogUtilities.warning("NO entry was added to the filter map for key " + key + " , as PredicateType.predicateTypeCreator did not find :" + predTest);
        }
    }

    @InternalUseOnly
    public static void addKeyFunction(Map<String, PredicateType> map, String key, String predString) {
        PredicateType pt;
        int spaceIdx = (predString = predString.trim()).indexOf(" ");
        boolean hasExpected = spaceIdx > 1;
        String predTest = hasExpected ? predString.substring(0, spaceIdx) : predString;
        String predExpected = hasExpected ? predString.substring(spaceIdx + 1).trim() : "";
        PredicateType predicateType = pt = hasExpected ? PredicateType.predicateTypeCreator(predTest, predExpected) : PredicateType.predicateTypeCreator(predTest);
        if (pt != null) {
            map.put(key, pt);
        } else {
            LogUtilities.warning("NO entry was added to the filter map for key " + key + " , as PredicateType.predicateTypeCreator did not find :" + predTest);
        }
    }

    @InternalUseOnly
    public static void addKeyFunction(Map<String, PredicateType> map, String key, double min, double max) {
        PredicateType pt = PredicateType.predicateTypeCreator(min, max);
        if (pt != null) {
            map.put(key, pt);
        } else {
            LogUtilities.warning("NO entry was added to the filter map for key " + key);
        }
    }

    public static Predicate<?> predicateCreator(String predTest, String predExpected) {
        PredicateType pt;
        PredicateType predicateType = pt = predExpected == null || predExpected.isEmpty() ? PredicateType.predicateTypeCreator(predTest) : PredicateType.predicateTypeCreator(predTest, predExpected);
        if (pt != null) {
            return pt.getPredicate();
        }
        return null;
    }

    private static PredicateType predicateTypeCreator(String predTest) {
        switch (predTest) {
            case "ISNULL": {
                Predicate<Optional> isNull = o -> !o.isPresent();
                return new PredicateType(isNull, (Type)((Object)Optional.class), predTest);
            }
            case "NISNULL": {
                Predicate<Optional> nIsNull = o -> o.isPresent();
                return new PredicateType(nIsNull, (Type)((Object)Optional.class), predTest);
            }
        }
        LogUtilities.warning("PredicateType predicate creator without expected value did not find :" + predTest);
        return null;
    }

    private static PredicateType predicateTypeCreator(String predTest, String predExpected) {
        String defaultDescription = predTest + " " + predExpected;
        switch (predTest) {
            case "EQ": 
            case "==": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> eq = d -> d.equals(expected);
                return new PredicateType(eq, Double.TYPE, defaultDescription);
            }
            case "NE": 
            case "!=": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> neq = d -> !d.equals(expected);
                return new PredicateType(neq, Double.TYPE, defaultDescription);
            }
            case "GT": 
            case ">": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> gt = d -> d > expected;
                return new PredicateType(gt, Double.TYPE, defaultDescription);
            }
            case "LT": 
            case "<": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> lt = d -> d < expected;
                return new PredicateType(lt, Double.TYPE, defaultDescription);
            }
            case "GE": 
            case ">=": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> ge = d -> d >= expected;
                return new PredicateType(ge, Double.TYPE, defaultDescription);
            }
            case "LE": 
            case "<=": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> le = d -> d <= expected;
                return new PredicateType(le, Double.TYPE, predTest + " " + predExpected);
            }
            case "EQ/T": 
            case "EQT": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> eqt = d -> Math.abs(d - expected) < 1.0E-6;
                return new PredicateType(eqt, Double.TYPE, predTest + " " + predExpected);
            }
            case "NEQ/T": 
            case "NEQT": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> nEqt = d -> !(Math.abs(d - expected) < 1.0E-6);
                return new PredicateType(nEqt, Double.TYPE, predTest + " " + predExpected);
            }
            case "EQS": 
            case "SEQS": {
                String expected = predExpected;
                Predicate<String> eqs = s -> s.equals(expected);
                return new PredicateType(eqs, (Type)((Object)String.class), defaultDescription);
            }
            case "NSEQS": 
            case "NEQS": {
                String expected = predExpected;
                Predicate<String> nEqs = s -> !s.equals(expected);
                return new PredicateType(nEqs, (Type)((Object)String.class), defaultDescription);
            }
            case "STARTS": {
                String expected = predExpected;
                Predicate<String> starts = s -> s.startsWith(expected);
                return new PredicateType(starts, (Type)((Object)String.class), defaultDescription);
            }
            case "NSTARTS": {
                String expected = predExpected;
                Predicate<String> nStarts = s -> !s.startsWith(expected);
                return new PredicateType(nStarts, (Type)((Object)String.class), defaultDescription);
            }
            case "ENDS": {
                String expected = predExpected;
                Predicate<String> ends = s -> s.endsWith(expected);
                return new PredicateType(ends, (Type)((Object)String.class), defaultDescription);
            }
            case "NENDS": {
                String expected = predExpected;
                Predicate<String> nEnds = s -> !s.endsWith(expected);
                return new PredicateType(nEnds, (Type)((Object)String.class), defaultDescription);
            }
            case "SUBS": {
                String expected = predExpected;
                Predicate<String> subs = s -> expected.contains((CharSequence)s);
                return new PredicateType(subs, (Type)((Object)String.class), defaultDescription);
            }
            case "NSUBS": {
                String expected = predExpected;
                Predicate<String> nSubs = s -> !expected.contains((CharSequence)s);
                return new PredicateType(nSubs, (Type)((Object)String.class), defaultDescription);
            }
            case "CONTAINS/S": {
                String expected = predExpected;
                Predicate<String> containsS = s -> s.contains(expected);
                return new PredicateType(containsS, (Type)((Object)String.class), defaultDescription);
            }
            case "NCONTAINS/S": {
                String expected = predExpected;
                Predicate<String> nContainsS = s -> !s.contains(expected);
                return new PredicateType(nContainsS, (Type)((Object)String.class), defaultDescription);
            }
            case "CONTAINS/K": 
            case "CONTAINS": {
                String expected = predExpected;
                Predicate<Table> contains = t -> t.containsKey(expected);
                return new PredicateType(contains, (Type)((Object)Table.class), defaultDescription);
            }
            case "NCONTAINS/K": 
            case "NCONTAINS": {
                String expected = predExpected;
                Predicate<Table> nContains = t -> !t.containsKey(expected);
                return new PredicateType(nContains, (Type)((Object)Table.class), defaultDescription);
            }
            case "MAXDTIME2CUR": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Double> time2Cur = d -> Time.currentTime().diff(new Time((double)d)) < expected;
                return new PredicateType(time2Cur, Double.TYPE, "d -> Time.currentTime().diff(new Time(d)) < expected");
            }
            case "MAXTIME2CUR": {
                Double expected = Double.valueOf(predExpected);
                Predicate<Time> time2Cur = t -> Time.currentTime().diff((Time)t) < expected;
                return new PredicateType(time2Cur, (Type)((Object)Time.class), "t -> Time.currentTime().diff(t) < expected");
            }
            case "MAXSTDTIME2CUR": {
                Double expected = Double.valueOf(predExpected);
                Predicate<String> time2Cur = s -> Time.currentTime().diff(new Time((String)s, 1)) < expected;
                return new PredicateType(time2Cur, (Type)((Object)String.class), "s -> Time.currentTime().diff(new Time(s,Time.STD)) < expected");
            }
            case "MAXISOTIME2CUR": {
                Double expected = Double.valueOf(predExpected);
                Predicate<String> time2Cur = s -> Time.currentTime().diff(new Time((String)s, 10)) < expected;
                return new PredicateType(time2Cur, (Type)((Object)String.class), "s -> Time.currentTime().diff(new Time(s,Time.ISO8601)) < expected");
            }
        }
        LogUtilities.warning("PredicateType predicate creator with expected value did not find :" + predTest);
        return null;
    }

    private static PredicateType predicateTypeCreator(Double min, Double max) {
        Predicate<Double> pred = d -> d < max && d > min;
        return new PredicateType(pred, Double.TYPE, "d -> (d.doubleValue() < max) && (d.doubleValue() > min");
    }

    @InternalUseOnly
    public static boolean passesFilter(Map<String, PredicateType> mapPT, String key, Object testVal) {
        PredicateType pt = mapPT.get(key);
        return PredicateType.passesFilter(pt, testVal);
    }

    public static boolean passesFilter(PredicateType pt, Object testVal) {
        if (extendedDebug) {
            System.out.println("passesFilter Predicate:" + pt + " testVal:" + testVal);
        }
        Type predType = pt.getType();
        Class<?> predClass = pt.getTypeClass();
        try {
            if (!(testVal instanceof Double || predType != Double.TYPE && predType != Double.class)) {
                Double testValDouble = null;
                try {
                    testValDouble = Convert.o2d(testVal, null, Double.NaN);
                }
                catch (MidasException e) {
                    return false;
                }
                return PredicateType.passesFilter(pt, predType, testValDouble);
            }
            if (!(testVal instanceof String) && predType == String.class) {
                String testValString = Convert.o2s(testVal, null, null);
                if (extendedDebug) {
                    System.out.println("converting testVal:" + testVal + " to:" + testValString);
                }
                if (testValString == null) {
                    return false;
                }
                return PredicateType.passesFilter(pt, predType, testValString);
            }
            if (!(testVal instanceof Table) && predType == Table.class) {
                Table testValTable = null;
                try {
                    testValTable = Convert.o2tStrict(testVal);
                }
                catch (MidasException e) {
                    return false;
                }
                if (testValTable == null) {
                    return false;
                }
                return PredicateType.passesFilter(pt, predType, testValTable);
            }
            if (testVal instanceof Number && predType == Time.class) {
                Time testTime = new Time(Double.valueOf(testVal.toString()));
                return PredicateType.passesFilter(pt, predType, testTime);
            }
            if (testVal == null) {
                if (predType == Optional.class) {
                    Optional nullOptional = Optional.empty();
                    return PredicateType.passesFilter(pt, predType, nullOptional);
                }
                return false;
            }
            if (!(testVal.getClass() != predClass || predClass != null && predClass.isAssignableFrom(testVal.getClass()))) {
                if (debug) {
                    System.out.println("CLASS_NOT_MATCH: classes not match testVal:" + testVal + " testVal.class:" + testVal.getClass() + " predType" + predType + " predClass:" + predClass + " pred:" + pt);
                }
                return false;
            }
            return PredicateType.passesFilter(pt, predType, testVal);
        }
        catch (Exception e) {
            Shell.warning("PredicateType Filter Check threw exception for testVal:" + testVal + " with PredicateType:" + pt + " exception:" + e);
            return false;
        }
    }

    private static <T> boolean passesFilter(PredicateType pt, T type, T testVal) {
        Predicate<?> pred = pt.getPredicate();
        if (debug) {
            System.out.println("testVal class:" + (testVal != null ? testVal.getClass() : null) + " type:" + type + " pred:" + pred);
        }
        return pred.test(testVal);
    }

    @InternalUseOnly
    public static Map<String, PredicateType> getNewPredicateTypeMap() {
        return new HashMap<String, PredicateType>();
    }

    public String toString() {
        if (this.lambdaString.isEmpty()) {
            return "PredicateType={Type=" + this.type + ",Predicate=" + this.predicate + "}";
        }
        return "PredicateType={Type=" + this.type + ", lambdaString=\"" + this.lambdaString + "\"}";
    }
}

