/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Pattern;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class Parser
implements AsciiMap,
Serializable {
    private static final long serialVersionUID = 2011101400310L;
    public static final int MASK_NONE = 0;
    public static final int MASK_ALL = -1;
    public static final int E_NONE = 0;
    public static final int E_WARNING = 1;
    public static final int E_ERROR = 2;
    public static final int E_DEFAULT = 0;
    static Pattern COMMA_PIPE_REGEX = Pattern.compile("[,|]");
    public char[] buffer;
    public int length;
    public int curindex = 0;
    public int curoffset;
    public int curlength;
    public int switchlen = 0;
    public char delimiter = (char)44;
    private boolean useSpaceDelimiter = true;
    private boolean treatBSlashAsEscape = false;

    public Parser(String input) {
        this.length = input.length();
        this.buffer = new char[this.length + 1];
        input.getChars(0, this.length, this.buffer, 0);
        this.buffer[this.length] = 32;
    }

    public Parser(String input, boolean doClean) {
        this(input, doClean, true);
    }

    public Parser(String input, boolean doClean, boolean upCase) {
        this(input);
        if (doClean) {
            this.clean(upCase);
        }
    }

    public Parser(String input, char delimiter) {
        this(input);
        this.setDelimiter(delimiter);
    }

    public Parser(String input, char delimiter, boolean doClean) {
        this(input, delimiter);
        if (doClean) {
            this.clean(true);
        }
    }

    public Parser(char[] input) {
        this.buffer = input;
        this.length = input.length;
    }

    public Parser(char[] input, int inputlength) {
        this.buffer = input;
        this.length = inputlength;
    }

    public void setUseSpaceDelimiter(boolean flag) {
        this.useSpaceDelimiter = flag;
    }

    public boolean getUseSpaceDelimiter() {
        return this.useSpaceDelimiter;
    }

    public void setDelimiter(char ch) {
        this.delimiter = ch;
    }

    public void clean() {
        this.clean(true);
    }

    public void clean(boolean upcase) {
        char clast = ' ';
        int paren = 0;
        int curly = 0;
        boolean tableWillCleanWhiteSpace = false;
        int j = 0;
        for (int i = 0; i < this.length; ++i) {
            char c = this.buffer[i];
            if (curly > 0 && c == '=') {
                boolean bl = tableWillCleanWhiteSpace = (Table.getDefaultFlagsInt() & 0x40000) == 0;
            }
            if (c <= ' ' && paren == 0) {
                if (clast == 32 || clast == this.delimiter) continue;
                this.buffer[j++] = this.delimiter;
                clast = ' ';
                continue;
            }
            if (c == this.delimiter) {
                if (tableWillCleanWhiteSpace || clast != ' ') {
                    this.buffer[j++] = c;
                }
                clast = c;
                continue;
            }
            if (!(c != '\"' && c != '`' || tableWillCleanWhiteSpace)) {
                char cqt = c;
                this.buffer[j++] = cqt;
                boolean escaped = false;
                while (i < this.length) {
                    c = this.buffer[++i];
                    this.buffer[j++] = c;
                    if (escaped) {
                        escaped = false;
                        if (c == '\"') {
                            continue;
                        }
                    } else if (c == '\\' && this.treatBSlashAsEscape) {
                        escaped = true;
                    }
                    if (c != cqt) continue;
                }
                clast = cqt;
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                if (upcase) {
                    c = Character.toUpperCase(c);
                }
            } else if (c == '(' || c == '[' || c == '{') {
                ++paren;
                if (c == '{') {
                    ++curly;
                }
            } else if (c == ')' || c == ']' || c == '}') {
                if (paren > 0) {
                    --paren;
                }
                if (c == '}') {
                    --curly;
                }
            }
            if (curly == 0) {
                tableWillCleanWhiteSpace = false;
            }
            this.buffer[j++] = c;
            clast = c;
        }
        if (j > 0 && this.buffer[j - 1] == this.delimiter && clast == ' ') {
            --j;
        }
        this.length = j;
    }

    public int lengthd(int index) {
        int i;
        int tic = 0;
        int quote = 0;
        int paren = 0;
        boolean inswitch = false;
        boolean escaped = false;
        block8: for (i = index; i < this.length; ++i) {
            char c = this.buffer[i];
            int len = i - index;
            if (c == '\\' && this.treatBSlashAsEscape) {
                escaped = !escaped;
                continue;
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') continue;
            if (tic == 1) {
                if (c != '`') continue;
                tic = 0;
                continue;
            }
            if (quote == 1) {
                if (c != '\"') continue;
                quote = 0;
                continue;
            }
            if (c == this.delimiter && paren == 0) {
                return len;
            }
            switch (c) {
                case ' ': {
                    if (!this.useSpaceDelimiter || paren != 0) continue block8;
                    return len;
                }
                case '`': {
                    tic = 1 - tic;
                    continue block8;
                }
                case '\"': {
                    quote = 1 - quote;
                    continue block8;
                }
                case '(': 
                case '[': 
                case '{': {
                    ++paren;
                    continue block8;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (paren <= 0) continue block8;
                    --paren;
                    continue block8;
                }
                case '/': {
                    if (inswitch && quote == 0 && paren == 0) {
                        return len;
                    }
                    if (i != index || i >= this.switchlen) continue block8;
                    inswitch = true;
                    continue block8;
                }
                default: {
                    if (!this.useSpaceDelimiter || c > ' ' || paren != 0) continue block8;
                    return len;
                }
            }
        }
        if (paren == 0) {
            return this.length - index;
        }
        for (i = this.length - 1; i >= 0 && this.buffer[i] <= ' '; --i) {
        }
        return i - index + 1;
    }

    public void setTreatBSlashAsEscape(boolean val) {
        this.treatBSlashAsEscape = val;
    }

    public boolean isTreatBSlashAsEscape() {
        return this.treatBSlashAsEscape;
    }

    public String getAll() {
        return new String(this.buffer, 0, this.length);
    }

    public String get(int element) {
        return this.get(element, false);
    }

    @InternalUseOnly
    synchronized String get(int element, boolean addLeadingChar) {
        if (element == 0) {
            throw new MidasException("Parser class is 1 based");
        }
        if (this.curindex == 0 || element < this.curindex) {
            this.curindex = 1;
            this.curoffset = 0;
            this.curlength = this.lengthd(this.curoffset);
        }
        while (this.curindex < element) {
            ++this.curindex;
            this.curoffset += this.curlength + 1;
            if (this.curoffset > this.length) {
                this.curlength = 0;
                continue;
            }
            this.curlength = this.lengthd(this.curoffset);
        }
        if (this.curoffset >= this.length || this.curlength < 0) {
            return "";
        }
        if (addLeadingChar && this.curoffset > 0) {
            return new String(this.buffer, this.curoffset - 1, this.curlength + 1);
        }
        if (this.curlength == 0) {
            return "";
        }
        return new String(this.buffer, this.curoffset, this.curlength);
    }

    public String get(int offset, int length) {
        return new String(this.buffer, offset, length);
    }

    public boolean more() {
        return this.curoffset + this.curlength < this.length;
    }

    public void reset() {
        this.curindex = 0;
        this.curoffset = 0;
        this.curlength = 0;
    }

    public String next() {
        return this.get(this.curindex + 1);
    }

    public synchronized int elements() {
        int elem = 0;
        for (int i = 0; i < this.length; i += this.lengthd(i) + 1) {
            ++elem;
        }
        return elem;
    }

    public String[] getArray(int maxelem) {
        int i;
        ArrayList<String> list3 = new ArrayList<String>();
        int n = 0;
        this.curoffset = 0;
        while (this.more()) {
            list3.add(this.get(++n));
        }
        if (maxelem == 0) {
            maxelem = n;
        }
        String[] s = new String[maxelem];
        for (i = 0; i < n && i < maxelem; ++i) {
            s[i] = (String)list3.get(i);
        }
        for (i = n; i < maxelem; ++i) {
            s[i] = "";
        }
        return s;
    }

    public static String get(String string, int element, int offset) {
        return Parser.get(string, element - offset);
    }

    public static String get(String string, int element) {
        if (element <= 0) {
            return "";
        }
        int i = -1;
        for (int n = 1; n < element; ++n) {
            if ((i = string.indexOf(44, i + 1)) >= 0) continue;
            return "";
        }
        int j = string.indexOf(44, i + 1);
        if (j < 0) {
            j = string.length();
        }
        return string.substring(i + 1, j);
    }

    public static String getUC(String string, int element) {
        String tmp = Parser.get(string, element);
        if (tmp != null) {
            tmp = tmp.toUpperCase();
        }
        return tmp;
    }

    public static int find(String list3, String match, int defindex) {
        return Parser.find(list3, match, defindex, 0, 0);
    }

    public static int find(String list3, String match, int defindex, int offset) {
        return Parser.find(list3, match, defindex, offset, 0);
    }

    public static int find(String list3, String match, int defindex, int offset, int notify) {
        int i;
        if (match == null || match.length() == 0) {
            return defindex;
        }
        if (notify != 0 && notify != 1 && notify != 2) {
            notify = 0;
        }
        int numMatches = 0;
        int firstMatch = -1;
        int j = 0;
        int k = match.length();
        for (i = -1; i < list3.length(); ++i) {
            if (i != -1 && list3.charAt(i) != ',' && list3.charAt(i) != '|') continue;
            ++j;
            if (!match.regionMatches(0, list3, i + 1, k) || ++numMatches != 1) continue;
            firstMatch = offset + j;
            if (!Parser.perfectMatch(match, list3.substring(i + 1), k)) continue;
            return firstMatch;
        }
        if (numMatches > 0) {
            if (numMatches > 1) {
                Shell.getSharedMidasContext().warning("Ambiguous items match '" + match + "'. Returning first match in list [" + list3 + "]");
            }
            return firstMatch;
        }
        match = match.toUpperCase();
        list3 = list3.toUpperCase();
        j = 0;
        k = match.length();
        for (i = -1; i < list3.length(); ++i) {
            if (i != -1 && list3.charAt(i) != ',' && list3.charAt(i) != '|') continue;
            ++j;
            if (!match.regionMatches(0, list3, i + 1, k) || ++numMatches != 1) continue;
            firstMatch = offset + j;
            if (!Parser.perfectMatch(match, list3.substring(i + 1), k)) continue;
            return firstMatch;
        }
        if (numMatches > 0) {
            if (numMatches > 1) {
                Shell.getSharedMidasContext().warning("Ambiguous items match '" + match + "'. Returning first match in list [" + list3 + "]");
            }
            return firstMatch;
        }
        char c = match.charAt(0);
        if (c >= '0' && c <= '9' || c == '-') {
            try {
                return Convert.s2l(match);
            }
            catch (MidasException midasException) {
                // empty catch block
            }
        }
        if (notify == 2) {
            Shell.getSharedMidasContext().error("Item: " + match + " not found in list: " + list3);
        } else if (notify == 1) {
            Shell.getSharedMidasContext().warning("Item: " + match + " not found in list: " + list3);
        } else if (notify == 0) {
            // empty if block
        }
        return offset - 1;
    }

    private static boolean perfectMatch(String match, String list3, int len) {
        if (match.length() == list3.length()) {
            if (match.equals(list3)) {
                return true;
            }
        } else if (match.length() < list3.length()) {
            char c = list3.charAt(len);
            if (match.equals(list3.substring(0, len)) && (c == ',' || c == '|')) {
                return true;
            }
        }
        return false;
    }

    public static int mask(String list3, String matchlist, int defmask) {
        int mask = 0;
        int mode = -2;
        if (matchlist == null || matchlist.length() == 0) {
            return defmask;
        }
        if ((matchlist = matchlist.toUpperCase()).startsWith("0X")) {
            mask = Convert.o2l(matchlist);
            return mask;
        }
        list3 = list3.toUpperCase();
        while (matchlist.length() > 0) {
            String match;
            int i = matchlist.indexOf(124);
            if (i < 0) {
                match = matchlist;
                matchlist = "";
            } else {
                match = matchlist.substring(0, i);
                matchlist = matchlist.substring(i + 1);
            }
            if (i == 0) continue;
            if (match.startsWith("+")) {
                match = match.substring(1);
                mode = 1;
            } else if (match.startsWith("-")) {
                match = match.substring(1);
                mode = 0;
            } else if (match.startsWith("~")) {
                match = match.substring(1);
                mode = -1;
            }
            int k = 0;
            if (list3.startsWith(match)) {
                k = 1;
            } else {
                i = list3.indexOf("," + match) + 1;
                if (i > 0) {
                    int j = 0;
                    while (i > 0) {
                        if (list3.charAt(i) == ',') {
                            ++j;
                        }
                        --i;
                    }
                    k = 1 << j;
                } else if (match.equals("DEF")) {
                    k = defmask;
                } else if (match.equals("DEFAULT")) {
                    k = defmask;
                } else if (match.equals("ALL")) {
                    k = Parser.maskAll(list3);
                } else if (match.equals("NONE")) {
                    k = 0;
                } else {
                    Shell.warning("Illegal mask value: " + match + " in " + list3);
                }
            }
            if (mode == 1) {
                mask = defmask |= k;
                continue;
            }
            if (mode == 0) {
                mask = defmask &= ~k;
                continue;
            }
            if (mode == -1) {
                mask = defmask ^= k;
                continue;
            }
            mask |= k;
        }
        return mask;
    }

    public static String mask2s(String list3, int mask) {
        StringBuilder sb = new StringBuilder("|");
        for (int i = 0; i < 32; ++i) {
            String item;
            if ((mask >> i & 1) != 1 || (item = Parser.get(list3, i + 1)) == null) continue;
            sb.append(item).append('|');
        }
        return sb.toString();
    }

    private static int maskAll(String list3) {
        int mask = 1;
        for (int i = 0; i < list3.length(); ++i) {
            if (list3.charAt(i) != ',') continue;
            mask = mask << 1 | 1;
        }
        return mask;
    }

    public static String find(String string, String match, String defvalue) {
        int item = Parser.find(string, match, 0);
        if (item == 0) {
            return defvalue;
        }
        return Parser.get(string, item);
    }

    public static String findUC(String string, String match, String defvalue) {
        int item = Parser.find(string, match, 0);
        if (item == 0) {
            return defvalue.toUpperCase();
        }
        return Parser.getUC(string, item);
    }

    public static int indexOfIgnoreCase(String token, String text) throws NullPointerException {
        String upperCaseText = text.toUpperCase();
        return upperCaseText.indexOf(token.toUpperCase());
    }

    public static int findUnquoted(char token, String text) {
        int i = text.indexOf(59);
        if (i == -1) {
            return i;
        }
        if (text.indexOf(34) == -1) {
            return i;
        }
        int numQuotes = 0;
        boolean found = false;
        int length = text.length();
        char[] buffer = new char[length];
        text.getChars(0, length, buffer, 0);
        int lastBufferIndex = length - 1;
        for (i = 0; i < length && !found; ++i) {
            char c = buffer[i];
            if (c == '\"') {
                if (i != lastBufferIndex && buffer[i + 1] == '\"') {
                    ++i;
                    continue;
                }
                if (++numQuotes != 2) continue;
                numQuotes = 0;
                continue;
            }
            if (c != token || numQuotes == 1) continue;
            found = true;
        }
        if (!found) {
            i = -1;
        }
        return i;
    }

    public static String toUpperCaseWithQuotes(String string) {
        char[] buffer = null;
        boolean inQuote = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (c >= 'a' && c <= 'z' && !inQuote) {
                c = (char)(c - 32);
                if (buffer == null) {
                    buffer = string.toCharArray();
                }
            }
            if (buffer == null) continue;
            buffer[i] = c;
        }
        if (buffer != null) {
            string = new String(buffer);
        }
        return string;
    }

    public static int switchString(String string, Table table) {
        int i;
        int isw = string.indexOf(47);
        while (isw >= 0 && (i = string.lastIndexOf(47)) >= isw) {
            String sw = string.substring(i + 1);
            int j = sw.indexOf(61);
            if (j < 0) {
                table.put(sw.toUpperCase(), (Object)"TRUE");
            } else {
                table.put(sw.substring(0, j).toUpperCase(), (Object)sw.substring(j + 1));
            }
            string = string.substring(0, i);
        }
        return isw;
    }

    public static int findIndex(String list3, String match) {
        return Parser.findIndex(list3, match, -1, 0, null, false);
    }

    public static int findIndex(String list3, String match, int defindex, int boffset, String delims, boolean cs) {
        int foundIndex = -1;
        Pattern regex = delims == null ? COMMA_PIPE_REGEX : Pattern.compile("[" + delims + "]");
        if (match == null || match.length() == 0) {
            return defindex;
        }
        String[] strs = regex.split(list3);
        for (int i = 0; i < strs.length; ++i) {
            boolean found;
            String str = strs[i];
            boolean bl = found = cs ? str.equals(match) : str.equalsIgnoreCase(match);
            if (!found) continue;
            foundIndex = i + 1;
            break;
        }
        return boffset + foundIndex;
    }
}

