/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.ShellParent;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public final class OptionTree {
    private static boolean DEBUG = false;
    public static final String SUBDIRNAMES = "CFG,MCR,INC,PRIM,EXP,DAT,HOST,DOCS,TEST";
    public static final String COMMAND_FILE_NAME = "commands.cnf";
    public static final String TYPE_STAND_ALONE = "STAND_ALONE";
    public static final String TYPE_UNDER_NMROOT = "UNDER_NMROOT";
    public static final String TYPE_BACK_LINK = "BACK_LINK";
    public static final String TYPE_FLAT = "FLAT";
    public static final String TYPE_JAR_FILE = "JAR_FILE";
    public static final String TYPE_URL = "URL";
    public static final String TYPE_ERROR = "ERROR";
    static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final String DEAFULT_VERSION = "0.0.0.version_not_set";
    static final Pattern FUZZY_VERSION_REGEX = Pattern.compile("(\\d+)(\\.(\\d+))?(\\.(\\d+))?([\\.\\-\\_]?([a-zA-Z0-9_\\-]+))?");
    private static Map<String, Set<String>> optsEverAddedToPath = Collections.synchronizedMap(new HashMap());
    private static OptionTreeFinder optRootFinder = null;

    private OptionTree() {
    }

    private static boolean isXMidasOpt(Midas midas, String path) {
        String dir = FileName.terminatePath(path) + "cfg";
        String cfg = FileName.terminatePath(dir) + "commands.cfg";
        BaseFile bf = new BaseFile(midas, (Object)cfg);
        return bf.exists();
    }

    private static boolean checkOptLevel(Midas midas, String name, String path) {
        String dir = FileName.terminatePath(path) + "cfg";
        String cnf = FileName.terminatePath(dir) + COMMAND_FILE_NAME;
        return new BaseFile(midas, (Object)cnf).exists() || OptionTree.isXMidasOpt(midas, path);
    }

    private static boolean checkNxmLevel(Midas midas, String optname, String path) {
        String nxmPath = FileName.terminatePath(path) + "nxm";
        String optPath = FileName.terminatePath(nxmPath) + optname;
        return OptionTree.checkOptLevel(midas, optname, optPath);
    }

    public static boolean defineOptionTree(Midas midas, String name, String path) {
        boolean shouldRestartJVM = false;
        Table optTable = OptionTree.getOptTable(midas);
        if (!path.startsWith("classpath:") && !path.endsWith(".jar")) {
            String canNmroot;
            String canPath;
            if (!OptionTree.checkNxmLevel(midas, name = name.toLowerCase(), path = FileUtil.terminatePath(path))) {
                int inxm;
                String nxm;
                String sep;
                if (OptionTree.checkOptLevel(midas, name, path)) {
                    sep = FileUtil.getPathSeparator(path);
                    nxm = sep + "nxm" + sep + name + sep;
                    inxm = path.lastIndexOf(nxm);
                    if (inxm >= 0) {
                        path = path.substring(0, inxm + 1);
                    } else if (!OptionTree.isXMidasOpt(midas, path)) {
                        midas.warning("Missing '" + nxm + "' in option tree path '" + path + "'.");
                    }
                } else {
                    sep = File.separator;
                    nxm = sep + "nxm" + sep + name + sep;
                    inxm = path.indexOf(nxm);
                    if (inxm >= 0) {
                        midas.deprecate("Since NeXtMidas 2.5.3: Support for specifying an OPTION with " + path + " is deprecated, please see the OPTION explain file for details.");
                        path = path.substring(0, inxm);
                    }
                }
            }
            if ((canPath = FileUtil.getCanonicalPath(path)).equals(canNmroot = FileUtil.getCanonicalPath(Shell.getNmRoot()))) {
                path = null;
            }
        }
        if (path != null) {
            int removeCount;
            String optName = name.toUpperCase();
            String prevOptPath = optTable.getS(optName);
            optTable.put(optName, (Object)path, 16);
            if (prevOptPath != null && !path.equals(prevOptPath) && (removeCount = OptionTree.removeFromOptClasspath(optTable.getTable("CLASSPATH"), optName)) > 0) {
                Shell.addOptToClasspath(optName, true);
                shouldRestartJVM = true;
            }
            if (OptionTree.hasOtherPaths(optName, path)) {
                shouldRestartJVM = true;
            }
        }
        return shouldRestartJVM;
    }

    public static boolean removeOptionTree(Midas midas, String name) {
        boolean removed = false;
        Table optTable = OptionTree.getOptTable(midas);
        String optName = name.toUpperCase();
        Table optInfo = OptionTree.getOption(midas, optName);
        if (optInfo == null) {
            midas.warning("Option tree [" + name + "] not found.");
        } else if (optInfo.get("TYPE").equals(TYPE_UNDER_NMROOT)) {
            midas.warning("Option tree [" + name + "] is under NMROOT at '" + optInfo.get("PATH") + "'. Remove this using OS commands.");
        } else {
            optTable.remove(optName, 16);
            removed = true;
        }
        return removed;
    }

    @InternalUseOnly
    public static String findOptRoot(String opt) {
        if (OptionTree.getOptionTreeFinder() != null && !"sys".equalsIgnoreCase(opt)) {
            return OptionTree.getOptionTreeFinder().findOptRoot(opt);
        }
        return "classpath:";
    }

    static String getOptsHelper(String opts, ShellParent shellParent, boolean needPath) {
        StringBuilder str = new StringBuilder(128);
        if (opts != null && opts.length() > 0) {
            String[] options;
            for (String opt : options = opts.split("[|,]")) {
                if (opt.equalsIgnoreCase("SYS")) continue;
                String optpath = OptionTree.findOptRoot(opt);
                if (optpath != null) {
                    if (str.length() > 0) {
                        str.append(",");
                    }
                    str.append(opt).append("=").append(optpath);
                    continue;
                }
                if (needPath) continue;
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(opt);
            }
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("SYS=").append(shellParent.getNmRoot());
        }
        return str.toString();
    }

    public static String getOptionPath(Midas midas, String optname, String area) {
        String retPath = null;
        Table optTable = OptionTree.getOptTable(midas);
        String definedOptPath = (String)optTable.getKey(optname.toUpperCase());
        if (definedOptPath == null) {
            String pathUnderNmroot = FileName.getOptionPath(Shell.getNmRoot(), optname, area);
            if (CoreIO.fexists(pathUnderNmroot, true)) {
                retPath = pathUnderNmroot;
            }
        } else {
            retPath = definedOptPath;
            if (area != null) {
                retPath = FileName.addPathDir(definedOptPath, area.toLowerCase());
            }
        }
        return retPath;
    }

    public static String getOptPath(String opt, String area) {
        return Shell.getOptPath(opt, area);
    }

    public static String getCfgRoot(Midas midas, String optName) {
        Table opt = OptionTree.getOption(midas, optName);
        return opt == null ? null : opt.getS("CFGROOT");
    }

    public static String getNxmRoot(Midas midas, String optName) {
        Table opt = OptionTree.getOption(midas, optName);
        return opt == null ? null : opt.getS("NXMROOT");
    }

    public static String[] getJars(String opt) {
        File[] jarFiles = OptionTree.getJarFiles(opt);
        String[] jars = null;
        if (jarFiles != null) {
            jars = new String[jarFiles.length];
            for (int i = 0; i < jars.length; ++i) {
                jars[i] = jarFiles[i].toString();
            }
        }
        return jars;
    }

    public static File[] getJarFiles(String opt) {
        File jars;
        String path = OptionTree.getOptPath(opt, "jars");
        if (FileUtil.isLocalFileName(path) && (jars = new File(FileUtil.toLocalFileName(path))).isDirectory()) {
            FileUtil.FnFilter filter = FileUtil.createFnFilter(path, "*.jar|*.JAR", null);
            return FileUtil.findFiles(jars, filter);
        }
        return EMPTY_FILE_ARRAY;
    }

    public static String[] getOptionNames(Midas midas) {
        return OptionTree.getAllOptions(midas).getKeys();
    }

    public static Table getOption(Midas midas, String optName) {
        return OptionTree.getAllOptions(midas).getTable(optName.toUpperCase());
    }

    public static Table getAllOptions(Midas midas) {
        String[] keys;
        Table options = new Table();
        Table optTable = OptionTree.getOptTable(midas);
        String nxmDir = FileName.terminatePath(Shell.getNmRoot() + "nxm");
        String[] files = midas.io.listFiles(nxmDir, "*", "DIR");
        for (int i = 0; files != null && i < files.length; ++i) {
            String optDir = FileName.terminatePath(nxmDir + files[i]);
            String cnfFile = FileName.terminatePath(optDir + "cfg") + COMMAND_FILE_NAME;
            if (!midas.io.find(cnfFile)) continue;
            File dir = new File(optDir);
            String name = files[i].toUpperCase();
            if (!dir.exists() || !dir.isDirectory()) continue;
            if (options.containsKey(name)) {
                Shell.warning("OPTION multiple definitions for OPT=" + name + " found.");
                continue;
            }
            options.put(name, (Object)OptionTree.getOptionTreeInfo(midas, files[i], optDir, true));
        }
        for (String key : keys = optTable.getKeys()) {
            if (key.equals("PATH") || key.equals("CLASSPATH") || key.equals("CP")) continue;
            if (options.containsKey(key)) {
                Shell.warning("OPTION multiple definitions for OPT=" + key + " found.");
                continue;
            }
            options.put(key, (Object)OptionTree.getOptionTreeInfo(midas, key, optTable.getS(key), false));
        }
        return options;
    }

    private static Table getOptTable(Midas midas) {
        return midas.getResults().getTable("OPT");
    }

    @InternalUseOnly(value="since initial version")
    public static Table getUnconfiguredOption(Midas midas, String optName, String path) {
        return OptionTree.getOptionTreeInfo(midas, optName, path, true);
    }

    private static Table getOptionTreeInfo(Midas midas, String optName, String path, boolean inNmroot) {
        String root;
        String type;
        optName = optName.toLowerCase();
        String file = path;
        String base = null;
        boolean link = false;
        if (file.startsWith("file:")) {
            file = file.substring(5);
        }
        if (IOResource.isURLResource(file)) {
            type = path.startsWith("jar:") ? TYPE_JAR_FILE : TYPE_URL;
            root = path;
            base = path + "nxm/" + optName + "/";
        } else {
            File dir = new File(path);
            if (dir.isFile()) {
                if (dir.getName().endsWith(".jar")) {
                    type = TYPE_JAR_FILE;
                    root = dir.toString();
                    base = path + "!/nxm/" + optName + "/";
                } else {
                    Shell.warning("OPTION: Can not determine type of option " + optName.toUpperCase() + "=" + path);
                    type = TYPE_JAR_FILE;
                    root = dir.toString();
                }
            } else {
                boolean isStandalone;
                File cfg;
                File top;
                File nxm;
                File opt;
                path = FileName.terminatePath(path);
                File nmroot = new File(Shell.getNmRoot());
                File nmrootCan = FileUtil.getCanonicalFile(nmroot);
                File nmrootNxm = new File(nmroot, "nxm");
                File nmrootOpt = new File(nmrootNxm, optName);
                File nmrootCfg = new File(nmrootOpt, "cfg");
                File nmrootCC = FileUtil.getCanonicalFile(nmrootCfg);
                File canonical = FileUtil.getCanonicalFile(dir);
                if (inNmroot) {
                    File canNxm = new File(canonical, "nxm");
                    File canOpt = new File(canNxm, optName);
                    File canCfg = new File(canOpt, "cfg");
                    opt = canonical;
                    nxm = canonical.getParentFile();
                    top = nxm.getParentFile();
                    cfg = canCfg;
                } else {
                    top = canonical;
                    nxm = new File(top, "nxm");
                    opt = new File(nxm, optName);
                    cfg = new File(opt, "cfg");
                }
                File cfgFlat = new File(canonical, "cfg");
                File optCan = FileUtil.getCanonicalFile(opt);
                boolean bl = isStandalone = top.exists() && top.isDirectory() && nxm.exists() && nxm.isDirectory() && nxm.getName().equals("nxm") && opt.exists() && opt.isDirectory() && opt.getName().equals(optName);
                if (inNmroot) {
                    link = nmrootCfg.exists() && nmrootCC.equals(FileUtil.getCanonicalFile(cfgFlat));
                    base = canonical.toString();
                } else {
                    link = nmrootCfg.exists() && nmrootCC.equals(FileUtil.getCanonicalFile(cfg));
                    base = dir.toString();
                    if (isStandalone) {
                        File tempNxm = new File(base, "nxm");
                        File tempOpt = new File(tempNxm, optName);
                        base = tempOpt.toString();
                    }
                }
                if (top.equals(nmrootCan)) {
                    root = nmroot.toString();
                    type = TYPE_UNDER_NMROOT;
                    base = nmrootOpt.toString();
                    link = false;
                } else if (top.equals(optCan)) {
                    root = top.toString();
                    type = TYPE_BACK_LINK;
                } else if (isStandalone) {
                    root = FileUtil.getCanonicalFile(top).toString();
                    type = TYPE_STAND_ALONE;
                } else if (cfgFlat.exists() && inNmroot) {
                    if (FileUtil.getCanonicalFile(cfgFlat).equals(FileUtil.getCanonicalFile(cfg))) {
                        root = nmroot.toString();
                        type = TYPE_BACK_LINK;
                    } else {
                        root = nmroot.toString();
                        type = TYPE_FLAT;
                    }
                } else if (cfgFlat.exists() && inNmroot) {
                    root = nmroot.toString();
                    type = TYPE_FLAT;
                } else {
                    root = dir.toString();
                    type = TYPE_ERROR;
                }
                if (!link && type == TYPE_BACK_LINK) {
                    base = path;
                }
                if (DEBUG) {
                    midas.type(">>> -------------------------------------");
                    midas.type(">>> OPT       = " + optName);
                    midas.type(">>> CANONICAL = " + canonical);
                    midas.type(">>> TOP       = " + top);
                    midas.type(">>> NXM       = " + nxm);
                    midas.type(">>> OPT       = " + opt);
                    midas.type(">>> CFG       = " + cfg);
                    midas.type(">>> CFGFLAT   = " + cfgFlat);
                    midas.type(">>> NMROOTCFG = " + nmrootCfg);
                    midas.type(">>>");
                    midas.type(">>> NXMROOT   = " + root);
                    midas.type(">>> CFGROOT   = " + base);
                    midas.type(">>> PATH      = " + path);
                    midas.type(">>> TYPE      = " + type);
                }
                path = FileName.terminatePath(path);
                base = FileName.terminatePath(base);
                root = FileName.terminatePath(root);
            }
        }
        Table tbl = new Table();
        tbl.put("NAME", (Object)optName.toUpperCase());
        tbl.put("LINK", link);
        tbl.put("TYPE", (Object)type);
        tbl.put("PATH", (Object)path);
        tbl.put("CFGROOT", (Object)base);
        tbl.put("NXMROOT", (Object)root);
        if (DEBUG) {
            midas.type("getOptionTreeInfo ==> " + tbl);
        }
        return tbl;
    }

    @InternalUseOnly(value="This method should be package-private, but nxm.sys.intr.Configure needs access it it, hence it is public")
    public static int removeFromOptClasspath(Table cpTable, String optName) {
        String[] keys;
        int count = 0;
        boolean removeAll = "*".equals(optName);
        String optKeyPrefix = optName.toUpperCase() + "_";
        for (String key : keys = cpTable.getKeys()) {
            boolean reservedKey;
            boolean bl = reservedKey = key.indexOf(95) == 0;
            if (reservedKey || !removeAll && !key.startsWith(optKeyPrefix)) continue;
            cpTable.remove(key, 16);
            ++count;
        }
        return count;
    }

    @InternalUseOnly(value="since initial version")
    static void addedToPath(String optName, String optPath) {
        Set<String> optPathSet = optsEverAddedToPath.get(optName);
        if (optPathSet == null) {
            optPathSet = Collections.synchronizedSet(new LinkedHashSet(16));
            optsEverAddedToPath.put(optName, optPathSet);
        }
        optPathSet.add(optPath);
    }

    @InternalUseOnly(value="since initial version")
    static boolean hasOtherPaths(String optName, String optPath) {
        boolean foundOtherPathDef = false;
        Set<String> optPathSet = optsEverAddedToPath.get(optName);
        if (optPathSet != null) {
            int size = optPathSet.size();
            if (size > 1) {
                foundOtherPathDef = true;
            } else if (size == 1 && !optPathSet.contains(optPath)) {
                foundOtherPathDef = true;
            }
        }
        return foundOtherPathDef;
    }

    public static Table getInfo(String optName, Midas M, boolean verbose, boolean warn) {
        optName = optName.trim().toLowerCase();
        String OPTNAME = optName.toUpperCase();
        String FROM_OPT = " [" + OPTNAME + "]";
        Table optConfigTbl = new Table();
        Table requiredOpts = new Table();
        String optpath = OptionTree.getOptPath(optName, null);
        optConfigTbl.put("NAME", (Object)OPTNAME);
        optConfigTbl.put("PATH", (Object)optpath);
        if (optpath != null) {
            FileName configFileName;
            TextFile textFile;
            FileName manifestFileName = new FileName("nxm." + optName + ".cfg.manifest.mf");
            BaseFile mf = new BaseFile(M, (Object)manifestFileName);
            if (mf.exists() && mf.open()) {
                try {
                    Manifest manifest = new Manifest(mf.getResource().getInputStream());
                    Attributes mfMainAttributes = manifest.getMainAttributes();
                    String bundleVersion = mfMainAttributes.getValue("Bundle-Version");
                    String implVersion = mfMainAttributes.getValue("Implementation-Version");
                    if (bundleVersion != null) {
                        optConfigTbl.put("VERSION", (Object)OptionTree.cleanVersion(bundleVersion));
                        optConfigTbl.put("VERSION_BUNDLE", (Object)bundleVersion);
                    }
                    if (implVersion != null) {
                        optConfigTbl.addIfNotPresent("VERSION", OptionTree.cleanVersion(implVersion));
                        optConfigTbl.put("VERSION_IMPLEMENTATION", (Object)implVersion);
                    }
                }
                catch (Exception e) {
                    throw new MidasException("Unable to load " + manifestFileName, e);
                }
                finally {
                    mf.close();
                }
            }
            if ((textFile = new TextFile(configFileName = new FileName(optpath + "version.txt"))).open(32)) {
                String line;
                if (verbose) {
                    M.info("Parsing" + FROM_OPT + " option tree's info/version from " + configFileName.getFullName());
                }
                String version = null;
                String description = null;
                while ((line = textFile.read()) != null) {
                    Table reqOpt;
                    line = line.trim();
                    if (version == null && (version = OptionTree.parseForVersion(line)) != null) {
                        optConfigTbl.addIfNotPresent("VERSION", version);
                        optConfigTbl.put("VERSION_TXT", (Object)version);
                    }
                    if (description == null && !line.startsWith("****")) {
                        description = line;
                        optConfigTbl.put("DESCRIPTION", (Object)description);
                    }
                    if ((reqOpt = OptionTree.parseForRequiredOpt(line)) == null) continue;
                    requiredOpts.merge(reqOpt);
                }
            }
            textFile.close();
        }
        if (optConfigTbl.addIfNotPresent("VERSION", DEAFULT_VERSION) && warn) {
            M.warning("VERSION not specified in" + FROM_OPT + "/version.txt or in manifest.mf, defaulting to " + DEAFULT_VERSION);
        }
        optConfigTbl.put("REQUIRED_OPTS", (Object)requiredOpts);
        return optConfigTbl;
    }

    private static String removeLeadingZeroes(String numstr) {
        int n;
        if (numstr == null) {
            return null;
        }
        int checkLen = numstr.length() - 1;
        for (n = 0; n < checkLen && numstr.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return numstr;
        }
        return numstr.substring(n);
    }

    public static String cleanVersion(String version) {
        Matcher m = FUZZY_VERSION_REGEX.matcher(version);
        if (m.matches()) {
            String major = OptionTree.removeLeadingZeroes(m.group(1));
            String minor = OptionTree.removeLeadingZeroes(m.group(3));
            String micro = OptionTree.removeLeadingZeroes(m.group(5));
            String qualifier = m.group(7);
            StringBuilder sb = new StringBuilder(major);
            if (minor == null) {
                minor = "0";
            }
            sb.append('.').append(minor);
            if (micro == null) {
                micro = "0";
            }
            sb.append('.').append(micro);
            if (qualifier != null) {
                sb.append('.').append(qualifier);
            }
            return sb.toString();
        }
        return null;
    }

    @InternalUseOnly(value="since initial version")
    public static String replaceVersionQualifier(String version, String customQualifier) {
        Matcher m = FUZZY_VERSION_REGEX.matcher(version);
        if (customQualifier != null && m.matches()) {
            int index = m.start(6);
            if (index != -1) {
                version = version.substring(0, index);
            }
            return version + "." + customQualifier;
        }
        return version;
    }

    public static String parseForVersion(String text) {
        int startIndex = text.toUpperCase().indexOf("VERSION");
        if (startIndex >= 0) {
            startIndex += 7;
            if (text.length() > 7 && text.charAt(7) == ':') {
                ++startIndex;
            }
            text = text.substring(startIndex);
        }
        String version = null;
        StringTokenizer st = new StringTokenizer(text, " \t");
        while (version == null && st.hasMoreTokens()) {
            String token = st.nextToken();
            version = OptionTree.cleanVersion(token);
        }
        return version;
    }

    public static Table parseForRequiredOpt(String text) {
        Table reqOpt = null;
        if (text.startsWith("#REQUIREDOPT:")) {
            text = text.substring(13);
            String reqOptName = null;
            StringTokenizer st = new StringTokenizer(text, " \t;");
            Table constraints = new Table();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (reqOptName == null) {
                    reqOptName = token.toUpperCase();
                    reqOpt = new Table();
                    reqOpt.put(reqOptName, (Object)constraints);
                    continue;
                }
                int iEq = token.indexOf(61);
                if (iEq <= 0) continue;
                String key = token.substring(0, iEq);
                String val = token.substring(iEq + 1);
                constraints.put(key.toUpperCase(), (Object)val);
            }
        }
        return reqOpt;
    }

    public static void setDebug(boolean state) {
        DEBUG = state;
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static OptionTreeFinder registerOptionTreeFinder(OptionTreeFinder optTreeFinder) {
        OptionTreeFinder prev = optRootFinder;
        optRootFinder = optTreeFinder;
        return prev;
    }

    public static OptionTreeFinder getOptionTreeFinder() {
        return optRootFinder;
    }

    public static interface OptionTreeFinder {
        public String findOptRoot(String var1);
    }
}

