/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import nxm.sys.inc.ANSIColor;
import nxm.sys.inc.IDable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.CallStackUtil;
import nxm.sys.lib.Command;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Dictionary;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Import;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Logger;
import nxm.sys.lib.Macro;
import nxm.sys.lib.MessageQueue;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.MidasToJavaLog;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Terminal;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.Util;

@CallStackUtil.IgnoreStackElement
public class Midas
implements Cloneable,
MidasReference {
    private static final int CONTEXT_PRE = 4;
    private static final int CONTEXT_POST = 2;
    private static final int CODE_LIMIT = 16;
    private static final Pattern JAVA_FILE = Pattern.compile("[A-Za-z0-9_$]+[.]java");
    private static final Pattern NXM_CLASS = Pattern.compile("nxm[.][^.]+[.][^.]+[.][^.]+");
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int DEPRECATE = 3;
    public static final int INTERACTIVE = 4;
    public static final int POFF = 0;
    public static final int PINIT = 1;
    public static final int PRUN = 2;
    public static final int PPAUSE = 3;
    public static final int PWAIT = 4;
    public static final int PSTOP = 5;
    static final String pipeModes = "Off,Init,Run,Pause,Wait,Stop";
    static final int pipeModesOffset = -1;
    private static Logger DEF_LOGGER = MidasToJavaLog.BOOTSTRAP_JAVALOGGER;
    private static boolean javaVsMidasDebug = false;
    public Registry registry;
    public Dictionary dictionary;
    public Results results;
    public Table pipes;
    public MessageQueue queue;
    public Macro macro;
    public int pipeMode = 0;
    @Deprecated
    public Terminal terminal;
    public Logger logger;
    public String msglog;
    public CoreIO io;
    public int verify = 0;
    public int debug;
    private static boolean useANSIColors = false;
    private static int fromLength = -1;
    private static boolean useLogUtilities = false;
    public long timer = 0L;
    public long elapse = 0L;
    public int status = -1;
    public double pause = 0.0125;
    public Midas parent;
    public String lastMessageString;
    private int timeStamp = 0;
    private int buildStatus;
    private Table buildErrors;
    private int errorCount;
    private static String nmJavaMode = Import.getEnv("NM_JAVA_MODE", "OFF");
    private boolean autoDetectBehavior = "AUTO".equals(nmJavaMode);
    private boolean javaBehavior = !"OFF".equals(nmJavaMode);
    private static boolean forceAutoDetect = false;
    private static boolean forceJavaBehaviorDefault = false;
    private static final int LOG_ERROR = Level.SEVERE.intValue();
    private static final int LOG_WARNING = Level.WARNING.intValue();
    private static final int LOG_INFO = Level.INFO.intValue();

    public Midas() {
        this.registry = new Registry();
        this.dictionary = new Dictionary();
        this.pipes = new Table();
        this.results = new Results(this);
        this.io = new CoreIO(this);
        this.queue = new MessageQueue(this, null);
        this.terminal = new Terminal(this);
        this.logger = DEF_LOGGER;
        this.debug = this.loadDebugDefault();
        if (forceAutoDetect) {
            this.autoDetectBehavior = true;
        }
        if (forceJavaBehaviorDefault) {
            this.javaBehavior = true;
        }
        if (javaVsMidasDebug) {
            System.out.println("#JvsM Midas Constructed with autoDetectBehavior:" + this.autoDetectBehavior + " javaBehavior defaulted to:" + this.javaBehavior);
        }
        this.resetBuildStatus();
    }

    public Midas cloneOf() {
        Midas midas;
        try {
            midas = (Midas)this.clone();
            midas.io = new CoreIO(midas);
            midas.queue = new MessageQueue(midas, null);
            midas.registry = new Registry();
            midas.parent = this;
            midas.logger = DEF_LOGGER;
            midas.lastMessageString = null;
            midas.javaBehavior = this.javaBehavior;
        }
        catch (CloneNotSupportedException e) {
            this.info("Clone not supported");
            return this;
        }
        if (javaVsMidasDebug) {
            System.out.println("#JvsM Midas clone with autoDetectBehavior:" + midas.autoDetectBehavior + " javaBehavior defaulted to:" + midas.javaBehavior);
        }
        return midas;
    }

    public void detach() {
        this.pipeMode = 0;
        this.macro = null;
        this.msglog = null;
    }

    public void type(CharSequence text) {
        this.message(text, 4);
    }

    public void print(CharSequence text) {
        Command from = this.registry.getThreadOwner();
        this.message(text, 4, from, true);
    }

    public String getCurrentPathString() {
        return this.results.getS("OPT.PATH");
    }

    public String[] getCurrentPathArray() {
        return this.results.getS("OPT.PATH").split(",");
    }

    public void println(CharSequence text) {
        this.message(text, 4);
    }

    public void deprecate(CharSequence msg) {
        if ((this.debug & 0x200) != 0) {
            this.message(msg, 3);
        }
    }

    public void info(CharSequence text) {
        this.message(text, 0);
    }

    public void info(Throwable t) {
        this.info(t.toString());
    }

    public void warning(CharSequence text) {
        this.message(text, 1);
    }

    public void warning(Throwable t) {
        this.warning(t.toString());
    }

    public void error(String text) {
        this.throwMidasException(text, null);
    }

    public void error(Throwable t) {
        this.throwMidasException(t.getMessage(), t);
    }

    public void error(CharSequence text, Throwable t) {
        String str = text == null ? null : text.toString();
        this.throwMidasException(str, t);
    }

    public void except(String text) {
        this.throwMidasException(text, null);
    }

    public void except(Throwable t) {
        this.throwMidasException(t.getMessage(), t);
    }

    private void throwMidasException(String msg, Throwable t) {
        MidasException e = new MidasException(msg, t);
        StackTraceElement[] stack = e.getStackTrace();
        if (stack.length > 2) {
            StackTraceElement[] stack2 = new StackTraceElement[stack.length - 2];
            System.arraycopy(stack, 2, stack2, 0, stack2.length);
            e.setStackTrace(stack2);
        }
        throw e;
    }

    public void moreString(String text) {
        this.moreString(StringUtil.cleanSplit(text, "\n"));
    }

    public final void moreString(String ... lines) {
        this.moreString(lines, 0, lines.length - 1);
    }

    public final void moreString(String[] lines, int start, int end) {
        if (lines == null) {
            return;
        }
        start = Math.max(start, 0);
        end = Math.min(end, lines.length);
        Command from = this.registry.getThreadOwner();
        this.terminal.more(1);
        for (int i = start; this.terminal.more() && i <= end; ++i) {
            this.terminal.more(lines[i]);
        }
        this.terminal.more(9);
    }

    public boolean more(int func) {
        return this.terminal.more(func);
    }

    public boolean more() {
        return this.terminal.more();
    }

    public void more(String text) {
        this.terminal.more(text);
    }

    public void more(CharSequence text) {
        this.terminal.more(text);
    }

    public void more(String text, int columnwidth) {
        this.terminal.more(text, columnwidth);
    }

    public void message(CharSequence text, int severity) {
        Command from = this.registry.getThreadOwner();
        this.message(text, severity, from);
    }

    public void message(CharSequence text, int severity, Object from) {
        this.message(text, severity, from, false);
    }

    private void message(CharSequence text, int severity, Object from, boolean textPartialLine) {
        Level level;
        String type;
        ANSIColor ansiColor = ANSIColor.DEFAULT;
        switch (severity) {
            case 4: {
                type = "INTERACTIVE";
                level = Level.INFO;
                ansiColor = ANSIColor.PURPLE;
                break;
            }
            case 3: {
                type = "DEPRECATE";
                level = Level.INFO;
                ansiColor = ANSIColor.PURPLE;
                break;
            }
            case 0: {
                type = "INFO";
                level = Level.INFO;
                ansiColor = ANSIColor.PURPLE;
                break;
            }
            case 1: {
                type = "WARN";
                level = Level.WARNING;
                ansiColor = ANSIColor.YELLOW;
                break;
            }
            case 2: {
                type = "ERROR";
                level = Level.SEVERE;
                ansiColor = ANSIColor.RED;
                break;
            }
            default: {
                type = "TEXT";
                level = Level.INFO;
                ansiColor = ANSIColor.PURPLE;
            }
        }
        if (useLogUtilities && severity != 4) {
            String message = text.toString();
            if (severity == 3) {
                message = type + ":" + text;
            }
            LogUtilities.log(this, level, message);
            return;
        }
        this.lastMessageString = type + ": " + text;
        String fid = null;
        if (from == null) {
            fid = null;
        } else if (from instanceof IDable) {
            fid = ((IDable)from).getID();
            if (fid.length() == 0 && from instanceof Command) {
                fid = ((Command)from).name;
            }
        } else {
            fid = from.toString();
            if (fromLength >= 0 && fid.length() > fromLength) {
                fid = fid.substring(0, fromLength);
            }
        }
        if (fid != null) {
            this.lastMessageString = this.lastMessageString + " [" + fid + "]";
        }
        if (this.timeStamp > 0) {
            String ts = Time.toString(Time.current(), this.timeStamp);
            this.lastMessageString = ts + " " + this.lastMessageString;
        }
        if (this.logger != null) {
            if (severity == 4) {
                if (textPartialLine) {
                    this.terminal.write(text.toString());
                } else {
                    this.terminal.writeln(text.toString());
                }
                int len = text.length();
                if (len >= 6) {
                    String test = text.subSequence(0, 6).toString();
                    if (test.equals("INFO: ")) {
                        type = "INFO";
                        text = text.subSequence(6, len);
                    }
                    if (test.equals("WARN: ")) {
                        type = "WARN";
                        text = text.subSequence(6, len);
                    }
                    if (test.equals("ERROR:")) {
                        type = "ERROR";
                        text = text.subSequence(7, len);
                    }
                }
            }
            this.logger.processMessage(this, type, text, fid);
        } else if (!useANSIColors) {
            String textForWrite;
            String string = textForWrite = severity == 4 ? text.toString() : this.lastMessageString;
            if (useANSIColors) {
                textForWrite = Midas.color(ansiColor, textForWrite);
            }
            if (textPartialLine) {
                this.terminal.write(textForWrite);
            } else {
                this.terminal.writeln(textForWrite);
            }
        }
        if (this.msglog != null) {
            this.queue.put("LOG", severity, text, this.msglog, from);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @InternalUseOnly(value="Since creation of method, only used for testing")
    public Logger setLogger(Logger newLogger) {
        Logger previousLogger = this.logger;
        this.logger = newLogger;
        return previousLogger;
    }

    @InternalUseOnly(value="Since creation of method, only used for testing")
    public void clearLogger() {
        this.logger = null;
    }

    @InternalUseOnly(value="Since creation of method, only used for testing")
    public String useMidasToJavaLog(String javaUtilLoggingConfigUrl) {
        String previousConfigFile = System.getProperty("java.util.logging.config.file");
        MidasToJavaLog.setGlobalInstance(this, javaUtilLoggingConfigUrl);
        this.setLogger(MidasToJavaLog.getGlobalInstance());
        return previousConfigFile;
    }

    @InternalUseOnly(value="Since creation of method, only used for testing")
    public static Logger setDefaultLogger(Logger newLogger) {
        Logger previousLogger = DEF_LOGGER;
        DEF_LOGGER = newLogger;
        return previousLogger;
    }

    @InternalUseOnly(value="Since creation of method, only used for testing")
    public static Logger getDefaultLogger() {
        return DEF_LOGGER;
    }

    public String getDebug() {
        return Parser.mask2s("IO,Macro,Pipes,Graphics,Results,Primitive,Shell,Args,Trace,Deprecate,SuperTrace", this.debug);
    }

    public void setDebug(String str) {
        this.debug = Parser.mask("IO,Macro,Pipes,Graphics,Results,Primitive,Shell,Args,Trace,Deprecate,SuperTrace", str, this.debug);
    }

    public void setDebug(int mask) {
        this.debug = mask;
    }

    public boolean debug(int mask) {
        return (mask & this.debug) != 0;
    }

    private int loadDebugDefault() {
        InputStream in = Midas.class.getResourceAsStream("/nxm/sys/cfg/midas_default_debug.txt");
        if (in == null) {
            return 0;
        }
        int loadDebug = 0;
        String line = "";
        try (BufferedReader myReader = new BufferedReader(new InputStreamReader(in));){
            while ((line = myReader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("!")) continue;
                loadDebug = line.startsWith("0x") ? Integer.decode(line) : Integer.parseInt(line);
                break;
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            loadDebug = 0;
        }
        return loadDebug;
    }

    public final CoreIO getCoreIO() {
        return this.io;
    }

    public final CoreIO getIO() {
        return this.getCoreIO();
    }

    public String getVerify() {
        return Parser.mask2s("Commands,Switches,Qualifiers,Controls,Beep,Break", this.verify);
    }

    public void setVerify(String str) {
        this.verify = Parser.mask("Commands,Switches,Qualifiers,Controls,Beep,Break", str, this.verify);
    }

    public boolean verify(int mask) {
        return (mask & this.verify) != 0;
    }

    public boolean isPiped() {
        return this.pipeMode != 0 && this.pipeMode != 5;
    }

    public void pause() {
        Time.sleep(this.pause);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public Midas getParent() {
        if (javaVsMidasDebug) {
            System.out.println("#JvsM Midas.getParent parent autoDetectBehavior:" + this.autoDetectBehavior + " javaBehavior currently:" + this.javaBehavior);
        }
        return this.parent;
    }

    public String getServer() {
        Shell shell = (Shell)this.registry.get("SHELL");
        if (shell != null && shell.parent != null) {
            return shell.parent.getServer();
        }
        return null;
    }

    public Table getPipes() {
        return this.pipes;
    }

    public Table getResults() {
        return this.results;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Macro getMacro() {
        return this.macro;
    }

    public final void printStackTrace(Throwable err) {
        this.printStackTrace(null, err, false);
    }

    public final void printStackTrace(Throwable err, boolean forceTrace) {
        this.printStackTrace(null, err, forceTrace);
    }

    public final void printStackTrace(CharSequence msg, Throwable err) {
        this.printStackTrace(msg, err, false);
    }

    public final void printStackTrace(CharSequence msg, Throwable err, boolean forceTrace) {
        this.printStackTrace(msg, err, forceTrace, 2);
    }

    public final void warnStackTrace(CharSequence msg, Throwable throwable) {
        this.printStackTrace(msg, throwable, false, 1);
    }

    public final void printStackTrace(CharSequence msg, Throwable err, boolean forceTrace, int severity) {
        boolean code;
        if (msg == null && err == null) {
            throw new IllegalArgumentException("Provided msg AND error/exception cannot BOTH be null.");
        }
        boolean trace = this.debug(256) || forceTrace;
        boolean bl = code = trace && this.debug(1024);
        int capacity = code ? 4096 : (trace ? 2048 : 512);
        StringBuilder sb = new StringBuilder(capacity);
        if (msg != null && msg.length() > 0) {
            sb.append(msg);
        }
        if (err != null) {
            String eMsg;
            String details = null;
            if (sb.length() > 0) {
                sb.append(": ");
            }
            if (err instanceof MidasException) {
                if (trace) {
                    details = ((MidasException)err).getDetails();
                }
            } else {
                sb.append(Util.getClassName(err)).append(": ");
            }
            if ((eMsg = err.getMessage()) != null && !eMsg.isEmpty()) {
                sb.append(eMsg);
            }
            if (details != null && details.length() > 0) {
                sb.append(" (").append(details).append(')');
            }
            if (err.getCause() != null) {
                sb.append(" Cause=" + err.getCause());
            }
        }
        if (trace) {
            while (err != null) {
                StackTraceElement[] st = err.getStackTrace();
                boolean done = false;
                for (int i = 0; i < st.length; ++i) {
                    if (!code) {
                        sb.append("\n        at " + st[i]);
                        continue;
                    }
                    if (done || i >= 16) {
                        sb.append("\n======== " + st[i]);
                        continue;
                    }
                    sb.append("\n======== " + st[i]);
                    done = this.printSourceCodeFor(sb, i, st[i]);
                }
                if ((err = err.getCause()) == null) continue;
                sb.append("\n    Caused by " + err);
            }
        }
        this.message(sb, severity);
    }

    private final boolean printSourceCodeFor(StringBuilder sb, int level, StackTraceElement ele) {
        try {
            String fullName = ele.getClassName();
            String fileName = ele.getFileName();
            int lineNum = ele.getLineNumber();
            int start = lineNum - 4;
            int end = lineNum + 2;
            Class<?> clazz = Class.forName(fullName);
            Class<?> parent = clazz.getSuperclass();
            if (level > 0) {
                if (clazz == Command.class) {
                    return true;
                }
                if (parent == Command.class) {
                    return true;
                }
                if (clazz == KeyObject.class) {
                    return false;
                }
            }
            TextFile tf = null;
            if (lineNum > 0 && JAVA_FILE.matcher(fileName).matches() && NXM_CLASS.matcher(fullName).matches()) {
                String pkg = fullName.substring(0, fullName.lastIndexOf(46));
                tf = new TextFile(this, (Object)new FileName(pkg + "." + fileName, true));
            }
            if (tf != null && tf.open(32)) {
                String line;
                for (int i = 1; i <= end && (line = tf.read()) != null; ++i) {
                    if (i == lineNum) {
                        sb.append("\n--> " + i + ":" + line);
                        continue;
                    }
                    if (i < start || i > end) continue;
                    sb.append("\n    " + i + ":" + line);
                }
                tf.close();
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public Midas getMidas() {
        return this;
    }

    @ProvisionalUseOnly(value="Beta version - API could change")
    public void setIfJavaBehavior(boolean isJavaBehavior) {
        this.javaBehavior = isJavaBehavior;
    }

    @ProvisionalUseOnly(value="Beta version - API could change")
    public boolean isJavaBehavior() {
        return this.javaBehavior;
    }

    @ProvisionalUseOnly(value="Beta version - API could change")
    public void needJavaBehavior() {
        this.javaBehavior = true;
    }

    @InternalUseOnly
    public static void setForceNmJavaMode(String nmJavaMode) {
        forceAutoDetect = "AUTO".equals(nmJavaMode);
        forceJavaBehaviorDefault = !"OFF".equals(nmJavaMode);
    }

    public static String getNmJavaMode() {
        return nmJavaMode;
    }

    @ProvisionalUseOnly(value="Beta version - API could change")
    public boolean isAutoDetectingBehavior() {
        return this.autoDetectBehavior;
    }

    @InternalUseOnly
    public static boolean isJavaVsMidasDebug() {
        return javaVsMidasDebug;
    }

    @InternalUseOnly
    public static void enableJavaVsMidasDebug(boolean enable) {
        javaVsMidasDebug = enable;
    }

    @InternalUseOnly
    public int getBuildStatus() {
        return this.buildStatus;
    }

    @InternalUseOnly
    public void setBuildStatus(int status) {
        this.buildStatus = status;
    }

    @InternalUseOnly
    public Table getBuildErrors() {
        return this.buildErrors;
    }

    void resetBuildStatus() {
        this.buildStatus = 0;
        this.buildErrors = new Table();
        this.errorCount = 0;
    }

    void addBuildError(String errorInfo) {
        ++this.errorCount;
        errorInfo = errorInfo.replace('\\', '/');
        this.buildErrors.put("ERROR_" + this.errorCount, (Object)errorInfo);
    }

    public static void log(CharSequence text, int level) {
        Shell.getSharedMidasContext().message(text, level, null);
    }

    public Handler createLogHandler() {
        return new LogHandler();
    }

    @InternalUseOnly
    public static int getFromLength() {
        return fromLength;
    }

    @InternalUseOnly
    public static void setFromLength(int fromLength) {
        Midas.fromLength = fromLength;
    }

    @InternalUseOnly
    public static void setUseLogUtilities(boolean b) {
        useLogUtilities = b;
    }

    public static void setUseANSIColors(boolean useANSIColors) {
        Midas.useANSIColors = useANSIColors;
    }

    private static String color(ANSIColor color, String msg) {
        return color.toString() + msg + ANSIColor.DEFAULT.toString();
    }

    private class LogHandler
    extends Handler {
        private boolean closed = false;

        public LogHandler() {
            this.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    String time = Time.toString(record.getMillis() / 1000L + 631152000L);
                    String name = record.getLoggerName() == null ? "Anonymous Logger" : record.getLoggerName();
                    return name + ": " + this.formatMessage(record) + " [" + time + "] ";
                }
            });
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.flush();
            this.closed = true;
        }

        @Override
        public synchronized void flush() {
            if (this.closed) {
                return;
            }
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return !this.closed && super.isLoggable(record);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            String text;
            if (this.closed) {
                return;
            }
            if (!this.isLoggable(record)) {
                return;
            }
            int lvl = record.getLevel().intValue();
            try {
                text = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
            if (lvl >= LOG_ERROR) {
                Midas.this.message(text, 2, null);
            } else if (lvl >= LOG_WARNING) {
                Midas.this.message(text, 1, null);
            } else if (lvl >= LOG_INFO) {
                Midas.this.message(text, 0, null);
            } else {
                Midas.this.message(text, 0, null);
            }
        }
    }
}

