/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.MessageQueue;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class Macro
extends Command
implements Cloneable {
    @InternalUseOnly
    public Table jumps;
    @InternalUseOnly
    public Args[] lines;
    @InternalUseOnly
    public int lastIndex = 0;
    @InternalUseOnly
    public int nextIndex;
    @InternalUseOnly
    public String waitFor = null;
    protected String filename;
    @InternalUseOnly
    public int level;
    @InternalUseOnly
    public int[] returns;
    private int[] traps;
    private Message trapMsg;
    private boolean trapQuiet;
    @InternalUseOnly
    public Results[] results;
    @InternalUseOnly
    public Table controls;
    private int closeLevel;
    private int maxIndex = 1024;
    private int maxLevel = 64;
    private int processMessageIndex;
    private int processExceptionIndex;
    private String textNext = null;
    private Midas midas1;
    private Midas midas2;
    private KeyVector primitives = new KeyVector(16);
    private boolean hasMessageProcedures;
    private Shell suspendShell;
    @InternalUseOnly
    public int suspend;
    private boolean txt;
    private int staticCount = 1;
    private Table sysctags;
    private int nTimers = 0;
    private double timeLast;
    private double[] timer;
    private double[] timerinit;
    private boolean processingMessage = false;
    private boolean processingException = false;
    private boolean msgDebug;
    private String debugLevel = "DEFAULT";
    public static final String shareList = "PIPES,RESULTS";
    public static final int SHARE_DEFAULT = 0;
    public static final int SHARE_PIPES = 1;
    @InternalUseOnly
    public static final int SHARE_RESULTS = 2;
    private int shareMask = 0;
    KeyVector cwidgets;

    @Override
    public int checkin(Midas midas) {
        super.checkin(midas);
        this.shareMask = this.MA.getOptionMask("/SHAREMASK", shareList, 0);
        this.midas1 = midas;
        this.midas2 = Macro.cloneContext(this.midas1, false, this.shareMask);
        this.midas2.macro = this;
        this.midas2.results.put("THIS", (Object)this);
        this.lines = new Args[this.maxIndex];
        this.returns = new int[this.maxLevel];
        this.traps = new int[this.maxLevel];
        this.results = new Results[this.maxLevel];
        this.jumps = new Table();
        this.controls = new Table();
        this.lastIndex = 0;
        if (this.MA.find("/MFN")) {
            this.filename = this.args.getCS("/MFN");
            this.args.remove("/MFN");
        } else {
            this.filename = Macro.getFileName(this.M, this.name, this.option);
        }
        this.setTimers(1);
        return 0;
    }

    @Override
    public int open() {
        String dlvl;
        super.checkin(this.midas2);
        this.verbose = this.MA.getState("/VERBOSE", this.verbose || this.M.parent.macro == null);
        this.msgDebug = this.MA.isPresent("/MSGDEBUG");
        if (this.msgDebug && !(dlvl = this.MA.getS("/MSGDEBUG", this.debugLevel)).equals("")) {
            this.debugLevel = dlvl;
        }
        this.level = 0;
        this.returns[0] = -1;
        this.results[0] = this.MR;
        if (this.lastIndex == 0) {
            this.loadText();
        }
        if (this.lastIndex <= 0) {
            return 10;
        }
        this.primitives.clear();
        Macro.argsToResults(this.M, this.args, this.lines[1], 0);
        this.processMessageIndex = this.lookupIndex("PROCESSMESSAGE");
        this.processExceptionIndex = this.lookupIndex("PROCESSEXCEPTION");
        Table.Iterator ti = this.jumps.iterator();
        while (ti.getNext()) {
            this.hasMessageProcedures |= ti.key.startsWith("PROCESS") && ti.key.endsWith("MESSAGE") && !ti.key.equals("PROCESSMESSAGE");
        }
        this.nextIndex = 1;
        int index = this.execBranch(this.nextIndex, 0);
        if (index < 0) {
            return 9;
        }
        return 0;
    }

    @Override
    public int process() {
        int work = 0;
        for (int i = 0; i < this.primitives.size(); ++i) {
            Command cmd = (Command)this.primitives.get(i);
            if (cmd.state == 4 || cmd.state == -3) continue;
            int status = cmd.runSingle();
            if (status == 0) {
                ++work;
            }
            if (this.M.pipeMode == 0 && cmd.state != 4) {
                cmd.close();
                cmd.state = 4;
            }
            if (cmd.state != 4 && cmd.state != -3) continue;
            cmd.runExit();
            cmd.checkout();
        }
        if (this.M.pipeMode == 0) {
            int index = this.execBranch(this.nextIndex, 0);
            if (index < 0) {
                return 9;
            }
            return 0;
        }
        if (this.waitFor != null && this.M.registry.get(this.waitFor) == null) {
            this.setPipeMode(5);
        }
        if (this.waitFor == null && this.M.registry.table.size() <= this.staticCount) {
            this.setPipeMode(5);
        }
        if (this.nTimers > 0 && (this.nTimers != 1 || this.timer[0] != 0.0)) {
            this.processTimers();
        }
        return work > 0 ? 0 : -1;
    }

    private void processTimers() {
        double time = Time.current();
        double tdiff = time - this.timeLast;
        boolean trst = tdiff > 10.0 || tdiff < -10.0;
        for (int i = 0; i < this.nTimers; ++i) {
            if (trst) {
                this.timerinit[i] = time;
                continue;
            }
            if (this.timer[i] == 0.0 || !(time - this.timerinit[i] > Math.abs(this.timer[i]))) continue;
            this.MQ.put("TIMER", i, time, this, this);
            if (this.timer[i] > 0.0) {
                this.timerinit[i] = time;
                continue;
            }
            this.timer[i] = 0.0;
        }
        this.timeLast = time;
    }

    @Override
    public int processMessage(Message msg) {
        MessageQueue safeMQ = this.MQ;
        if (msg.name.equals("ERROR")) {
            if (this.processingException) {
                this.M.printStackTrace((Exception)msg.getData());
            } else if (this.processingMessage) {
                this.trapMsg = msg;
            } else if (this.thisIsMe()) {
                this.processTrap(msg);
            } else if (safeMQ != null) {
                safeMQ.put(msg);
            } else {
                System.out.println("WARN: Macro.processMessage(ERROR msg) - MQ is null, cannot queue/process " + msg);
            }
            return 0;
        }
        if (!this.thisIsMe() || this.processingMessage) {
            if (safeMQ != null) {
                safeMQ.put(msg);
            } else {
                System.out.println("WARN: Macro.processMessage() - MQ is null, cannot queue/process " + msg);
            }
            return 0;
        }
        if (this.msgDebug) {
            this.M.info(this.getName() + " received " + msg.toString(this.debugLevel));
        }
        int handlerIndex = this.hasMessageProcedures ? this.lookupIndex("PROCESS" + msg.name + "MESSAGE") : 0;
        this.processingMessage = true;
        if (msg.name.equals("EXEC")) {
            this.execBranch(msg.info, 1);
        } else if (handlerIndex > 0) {
            this.M.results.put("MSG", (Object)msg);
            this.execBranch(handlerIndex + 1, 1);
        } else if (msg.name.equals("EXIT")) {
            this.setPipeMode(5);
        } else if (this.processMessageIndex > 0) {
            this.M.results.put("MSG", (Object)msg);
            this.execBranch(this.processMessageIndex + 1, 1);
        } else if (msg.name.equals("MACRO")) {
            String text = (String)msg.data;
            if (text.equals("INIT")) {
                this.M.pipeMode = 1;
            } else if (text.equals("RUN")) {
                this.M.pipeMode = 2;
            } else if (text.equals("PAUSE")) {
                this.M.pipeMode = 3;
            } else if (text.equals("STOP")) {
                this.M.pipeMode = 5;
            } else if (text.equals("EXIT")) {
                this.M.pipeMode = 0;
            }
        }
        this.processingMessage = false;
        return 0;
    }

    public void setTrapHandler(String label, boolean quiet) {
        int index;
        int n = index = label.equals("OFF") ? 0 : this.lookupIndex(label);
        if (index < 0) {
            this.M.warning("Unresolved trap handler: " + label);
        }
        this.traps[this.level] = index;
        this.trapQuiet = quiet;
    }

    private void processTrap(Message msg) {
        this.M.results.put("EMSG", (Object)msg);
        if (this.processExceptionIndex > 0) {
            this.processingException = true;
            this.execBranch(this.processExceptionIndex + 1, 1);
            this.processingException = false;
            if (msg.name.equals("CAUGHT")) {
                return;
            }
        } else {
            this.M.printStackTrace((Exception)msg.getData());
        }
        if (this.processingMessage && this.traps[this.level] > 0) {
            if (!this.trapQuiet) {
                this.M.println("Trapped ERROR to line: " + this.traps[this.level]);
            }
            this.nextIndex = this.traps[this.level] + 1;
        }
    }

    @Override
    public void processException(Exception e) {
        this.processingMessage = false;
        if (this.midas1.macro != null) {
            this.midas1.macro.MQ.put("ERROR", 0, e, this.midas1.macro, this);
            try {
                this.close();
            }
            catch (Exception exception) {}
        } else {
            super.processException(e);
        }
    }

    @Override
    public int close() {
        if (this.M.logger != null) {
            this.M.logger.close();
        }
        this.M.macro = null;
        super.checkin(this.midas1);
        return 0;
    }

    @Override
    public void setState(int state) {
        switch (state) {
            case 5: 
            case 12: {
                this.M.pipeMode = 2;
                break;
            }
            case 6: 
            case 11: {
                this.M.pipeMode = 3;
                break;
            }
            case 9: 
            case 10: {
                this.M.pipeMode = 5;
            }
        }
    }

    @Override
    public void checkout() {
        for (int i = 1; i < this.lastIndex; ++i) {
            if (this.lines[i].support != 'I' || this.lines[i].cmd.state == 2) continue;
            this.lines[i].cmd.checkout();
        }
        this.lines = null;
        super.checkout();
    }

    public void setPipeMode(int mode) {
        if (mode == 1) {
            int index = this.lookupIndex("INIT");
            if (index > 0) {
                this.execBranch(index, 1);
            }
        } else if (mode != 2) {
            if (mode == 4) {
                int index = this.lookupIndex("OPEN");
                if (index > 0) {
                    this.execBranch(index, 1);
                }
            } else if (mode == 5) {
                int index = this.lookupIndex("CLOSE");
                if (index > 0) {
                    this.execBranch(index, 1);
                }
                this.nextIndex = this.returns[this.closeLevel];
                this.level = this.closeLevel - 1;
                mode = 0;
            } else if (mode == 0) {
                // empty if block
            }
        }
        this.M.pipeMode = mode;
    }

    public static Midas cloneContext(Midas midas1, boolean sub) {
        return Macro.cloneContext(midas1, sub, false);
    }

    @Deprecated
    @InternalUseOnly
    public static Midas cloneContext(Midas midas1, boolean sub, boolean sharePipes) {
        int flags = sharePipes ? 1 : 0;
        return Macro.cloneContext(midas1, sub, flags);
    }

    @InternalUseOnly
    public static Midas cloneContext(Midas midas1, boolean sub, int flags) {
        Results results1 = midas1.results;
        Midas midas2 = midas1.cloneOf();
        Results results2 = new Results(midas2);
        results2.setPrevious(results1);
        midas2.results = (flags & 2) != 0 ? midas1.results : results2;
        if (sub) {
            midas2.registry.table = midas1.registry.table;
            midas2.queue = midas1.queue;
        } else {
            midas2.pipeMode = 0;
            midas2.registry.table = new Table();
            midas2.registry.table.setPrevious(midas1.registry.table.getRoot());
            if ((flags & 1) != 0) {
                midas2.pipes = midas1.pipes;
            } else {
                midas2.pipes = new Table();
                midas2.pipes.setPrevious(midas1.pipes);
                midas2.pipes.setFlags(0);
            }
            results2.setFlags(0);
        }
        results2.put("ENV", results1.get("ENV"));
        results2.put("AUX", results1.get("AUX"));
        results2.put("OPT", results1.get("OPT"));
        results2.put("RAM", (Object)midas2.pipes);
        results2.put("REG", (Object)midas2.registry.table);
        return midas2;
    }

    public int execBranch(int index, int mode) {
        int curlevel = this.level++;
        if (mode == 1) {
            this.results[this.level] = this.M.results;
            this.returns[this.level] = this.nextIndex;
            this.traps[this.level] = 0;
        }
        while (index > 0 && index < this.maxIndex) {
            this.nextIndex = index + 1;
            Args targs = this.lines[index];
            if (this.state == 10) {
                this.setState(10);
                break;
            }
            if (targs == null) break;
            char sup = targs.support;
            if (sup == 'I') {
                Shell.execCommand(this.M, targs.cmd);
            } else {
                if (sup == 'U' || targs.cmdline.indexOf(94) >= 0) {
                    String cmdline = targs.evaluateCarets(targs.cmdline);
                    targs = Shell.parseCommand(this.M, cmdline);
                }
                targs.cmd = Shell.loadCommand(this.M, targs);
                Shell.execCommand(this.M, targs.cmd);
            }
            if (this.suspend != 0) {
                if (this.suspend > 0) {
                    this.M.info("Entering macro suspend mode at line=" + index);
                } else {
                    this.suspend = -this.suspend;
                }
                if (this.suspendShell == null) {
                    this.suspendShell = new Shell();
                }
                this.suspendShell.M = this.M;
                this.suspendShell.runCommand("MACROFUNC,,LIST,5");
                this.suspendShell.process();
            }
            if (this.trapMsg != null && !this.processingException) {
                this.processTrap(this.trapMsg);
                this.trapMsg = null;
            }
            index = this.nextIndex;
            if (mode == 1 && this.level == curlevel) break;
            if (mode != 0 || this.M.pipeMode != 4) continue;
            this.closeLevel = ++this.level;
            this.results[this.level] = this.M.results;
            this.returns[this.level] = this.nextIndex;
            break;
        }
        return index;
    }

    void addCommand(Command cmd) {
        cmd.setCmdProcEngine(this.M.macro, Thread.currentThread());
        cmd.runEnter();
        cmd.runSingle();
        this.primitives.add(cmd.getID(), cmd);
    }

    public int prepBranch(int index, Midas subM) {
        for (int i = index; i < this.lastIndex; ++i) {
            Args args = this.lines[i];
            args.M = subM;
            if (args.support == 'I') {
                args.cmd.checkin(subM);
            }
            if (i != index && (args.name.equals("SUBROUTINE") || args.name.equals("PROCEDURE"))) break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadText() {
        int iflevel = 0;
        int dolevel = 0;
        int looplevel = 0;
        int forlevel = 0;
        int whilelevel = 0;
        int macrolevel = 0;
        int[] ifindex = new int[100];
        int[] doindex = new int[100];
        int[] loopindex = new int[100];
        int[] forindex = new int[100];
        int[] whileindex = new int[100];
        int i = 0;
        this.lines[i++] = this.args;
        Args largs = this.args;
        boolean autoInitialEntry = false;
        TextFile file = new TextFile(this.M, (Object)this.filename);
        if (!file.exists()) {
            file.setExt("txt");
            this.txt = file.exists();
            if (!this.txt) {
                file.setExt("mm");
            }
        }
        if (this.txt) {
            this.cwidgets = new KeyVector();
            TextFile tf = new TextFile(this, (Object)"nxm.sys.cfg.ctags.tbl");
            this.sysctags = new Table(tf);
        }
        if (!file.open(8193)) {
            return -1;
        }
        file.setIncludeString("include");
        try {
            String text;
            while ((text = this.readFiltered(file)) != null) {
                if ((this.M.debug & 2) != 0) {
                    this.M.info("" + i + " " + text);
                }
                Args targs = Shell.parseCommand(this.M, text);
                if (targs.name.equals("STARTMACRO") && !this.filename.contains("/mcr/")) {
                    if (this.M.isAutoDetectingBehavior()) {
                        this.M.setIfJavaBehavior(false);
                        this.midas2.setIfJavaBehavior(false);
                    }
                    if (Midas.isJavaVsMidasDebug()) {
                        this.M.info("#JvsM Macro.loadText STARTMACRO setting Macro/Midas usage to true filename:" + this.filename);
                    }
                }
                int linenum = file.getReadProperCount();
                targs.setLineNumber(linenum);
                if (targs.support == 'I') {
                    targs.cmd = Shell.loadCommand(this.M, targs);
                }
                if (i == 1) {
                    if (!targs.name.equals("STARTMACRO")) {
                        this.M.error("Macro must begin with STARTMACRO command");
                    }
                    if (targs.cmd.id.length() <= 0) {
                        targs.cmd.id = "MAIN";
                    }
                    this.M.registry.put(targs.cmd.id, this);
                }
                if (targs.name.equals("IF")) {
                    if (this.noTestCase(targs)) {
                        this.M.error("No test condition specified for IF statement around line " + linenum);
                    }
                    ifindex[++iflevel] = i;
                } else if (targs.name.equals("ELSEIF")) {
                    if (this.noTestCase(targs)) {
                        this.M.error("No test condition specified for ELSEIF statement around line " + linenum);
                    }
                    this.checkElseifStruct(targs);
                    if (iflevel < 1) {
                        this.M.error("Unexpected ELSEIF around line " + linenum + " text: " + text);
                    }
                    ((Intrinsic)this.lines[ifindex[iflevel]].cmd).nextIndex = i;
                    ifindex[iflevel] = i;
                } else if (targs.name.equals("ELSE")) {
                    if (iflevel < 1) {
                        this.M.error("Unexpected ELSE around line " + linenum);
                    }
                    ((Intrinsic)this.lines[ifindex[iflevel]].cmd).nextIndex = i;
                    ifindex[iflevel] = i;
                } else if (targs.name.equals("ENDIF")) {
                    if (iflevel < 1) {
                        this.M.error("Unexpected ENDIF around line " + linenum);
                    }
                    ((Intrinsic)this.lines[ifindex[iflevel]].cmd).nextIndex = i;
                    --iflevel;
                } else if (targs.name.equals("DO")) {
                    doindex[++dolevel] = i;
                } else if (targs.name.equals("ENDDO")) {
                    if (dolevel < 1) {
                        this.M.error("Unexpected ENDDO around line " + linenum);
                    }
                    ((Intrinsic)this.lines[doindex[dolevel]].cmd).nextIndex = i;
                    ((Intrinsic)targs.cmd).nextIndex = doindex[dolevel];
                    --dolevel;
                } else if (targs.name.equals("LOOP")) {
                    loopindex[++looplevel] = i;
                } else if (targs.name.equals("ENDLOOP")) {
                    if (looplevel < 1) {
                        this.M.error("Unexpected ENDLOOP around line " + linenum);
                    }
                    ((Intrinsic)this.lines[loopindex[looplevel]].cmd).nextIndex = i;
                    ((Intrinsic)targs.cmd).nextIndex = loopindex[looplevel];
                    --looplevel;
                } else if (targs.name.equals("FOREACH")) {
                    forindex[++forlevel] = i;
                } else if (targs.name.equals("ENDFOR")) {
                    if (forlevel < 1) {
                        this.M.error("Unexpected ENDFOR around line " + linenum);
                    }
                    ((Intrinsic)this.lines[forindex[forlevel]].cmd).nextIndex = i;
                    ((Intrinsic)targs.cmd).nextIndex = forindex[forlevel];
                    --forlevel;
                } else if (targs.name.equals("WHILE")) {
                    if (this.noTestCase(targs)) {
                        this.M.error("No test condition specified for WHILE statement around line " + linenum);
                    }
                    whileindex[++whilelevel] = i;
                } else if (targs.name.equals("ENDWHILE")) {
                    if (whilelevel < 1) {
                        this.M.error("Unexpected ENDWHILE around line " + linenum);
                    }
                    ((Intrinsic)this.lines[whileindex[whilelevel]].cmd).nextIndex = i;
                    ((Intrinsic)targs.cmd).nextIndex = whileindex[whilelevel];
                    --whilelevel;
                } else if (targs.name.equals("LABEL")) {
                    this.jumps.put(targs.getU(1), (Object)i);
                } else if (targs.name.equals("PROCEDURE")) {
                    if (macrolevel != 0) {
                        this.M.error("PROCEDURE definition found inside STARTMACRO/ENDMACRO around line " + linenum + " text: " + text);
                    }
                    this.jumps.put(targs.getU(1), (Object)i);
                } else if (targs.name.equals("SUBROUTINE")) {
                    if (macrolevel != 0) {
                        this.M.error("SUBROUTINE definition found inside STARTMACRO/ENDMACRO around line " + linenum + " text: " + text);
                    }
                    this.jumps.put(targs.getU(1), (Object)i);
                } else if (targs.name.equals("STARTMACRO")) {
                    if (macrolevel != 0) {
                        this.M.error("Duplicate STARTMACRO found before ENDMACRO around line " + linenum + " text: " + text);
                    }
                    ++macrolevel;
                } else if (targs.name.equals("ENDMACRO")) {
                    --macrolevel;
                }
                if (this.txt) {
                    if (targs.name.equals("XCONTROL") && largs.name.equals("STARTCONTROLS")) {
                        autoInitialEntry = true;
                        this.jumps.put("INITIALENTRY", (Object)i);
                    }
                    if (autoInitialEntry && !targs.name.equals("XCONTROL")) {
                        autoInitialEntry = false;
                        Args dargs = Shell.parseCommand(this.M, "RETURN");
                        dargs.cmd = Shell.loadCommand(this.M, dargs);
                        this.lines[i++] = dargs;
                    }
                }
                if (i == this.maxIndex) {
                    this.maxIndex *= 2;
                    Args[] tmp = this.lines;
                    this.lines = new Args[this.maxIndex];
                    for (int ic = 0; ic < tmp.length; ++ic) {
                        this.lines[ic] = tmp[ic];
                    }
                }
                this.lines[i++] = targs;
                largs = targs;
            }
        }
        finally {
            file.close();
        }
        this.lastIndex = i;
        if (iflevel != 0) {
            this.M.error("Unclosed IF/ELSEIF/ELSE/ENDIF block");
        }
        if (dolevel != 0) {
            this.M.error("Unclosed DO/ENDDO block");
        }
        if (looplevel != 0) {
            this.M.error("Unclosed LOOP/ENDLOOP block");
        }
        if (forlevel != 0) {
            this.M.error("Unclosed FOREACH/ENDFOR block");
        }
        if (whilelevel != 0) {
            this.M.error("Unclosed WHILE/ENDWHILE block");
        }
        if (macrolevel != 0) {
            this.M.error("Unbalanced STARTMACRO/ENDMACRO block");
        }
        if ((this.M.debug & 2) != 0) {
            this.jumps.dump(System.out);
        }
        return i;
    }

    private boolean noTestCase(Args targs) {
        String arg = targs.getU(1);
        if (arg.equals("THEN")) {
            return true;
        }
        if (targs.getNArgs() > 1) {
            return false;
        }
        return arg.equals("");
    }

    public int lookupIndex(String label) {
        Object entry = this.jumps.get(label);
        if (entry instanceof Integer) {
            return (Integer)entry;
        }
        return -1;
    }

    public static String getFileName(Midas M, String mname, String option) {
        String fname = mname == null || mname.length() == 0 ? null : (mname.charAt(0) == '%' ? M.io.name("HOMEPATH", mname.substring(1), "MM", "AUX") : M.io.name("MCR", mname, "MM", option));
        return fname;
    }

    public static void argsToResults(Midas M, Args ai, Args ao, int offset) {
        int ic;
        String resname;
        String[] resnames = new String[ao.nargs];
        String[] defValues = new String[ao.nargs];
        String[] macroRes = new String[ao.nargs];
        int[] iColon = new int[ao.nargs];
        boolean isCall = offset != 0;
        int idx = 0;
        int i = offset + 1;
        while (i <= ao.nargs) {
            resname = ao.getU(i);
            int ib = resname.indexOf(91);
            if (ib > 0) {
                defValues[idx] = resname.substring(ib + 1, resname.length() - 1);
                resname = resname.substring(0, ib);
            } else {
                defValues[idx] = "";
            }
            resnames[idx] = resname;
            iColon[idx] = ic = resname.indexOf(58);
            macroRes[idx] = ic >= 0 ? resname.substring(ic + 1) : resname;
            ++i;
            ++idx;
        }
        List<String> macroResList = isCall ? null : Arrays.asList(macroRes);
        idx = 0;
        int i2 = offset + 1;
        while (i2 <= ao.nargs) {
            String key;
            resname = resnames[idx];
            String defValue = defValues[idx];
            String aoRes = macroRes[idx];
            ic = iColon[idx];
            Object value = defValue;
            String string = key = isCall || ai.get(aoRes) == null ? null : aoRes;
            if (key == null && i2 <= ai.nargs) {
                String iKey = ai.getKey(i2);
                if (isCall || !macroResList.contains(iKey)) {
                    key = iKey;
                }
            }
            if (key == null) {
                key = "UNDEFINED";
            }
            if (ic <= 0) {
                value = ai.getU(key, defValue);
            } else if (ic == 1) {
                switch (resname.charAt(0)) {
                    case 'S': {
                        value = ai.getS(key, defValue);
                        break;
                    }
                    case 'U': {
                        value = ai.getU(key, defValue);
                        break;
                    }
                    case 'T': {
                        value = ai.getTable(key, null, 32);
                        break;
                    }
                    case 'D': {
                        value = new Data(ai.getD(key, Convert.s2d(defValue)));
                        break;
                    }
                    case 'F': {
                        value = new Data(ai.getF(key, (float)Convert.s2d(defValue)));
                        break;
                    }
                    case 'L': {
                        value = new Data(ai.getL(key, (int)Convert.s2d(defValue)));
                        break;
                    }
                    case 'I': {
                        value = new Data(ai.getI(key, (short)Convert.s2d(defValue)));
                        break;
                    }
                    case 'B': {
                        value = new Data(ai.getB(key, (byte)Convert.s2d(defValue)));
                        break;
                    }
                    case 'N': {
                        value = new Data(ai.getD(key, Convert.s2d(defValue)));
                        break;
                    }
                    case 'Z': {
                        value = ai.getZ(key, Convert.o2z(defValue));
                        break;
                    }
                    case 'O': {
                        value = ai.getO(key);
                        break;
                    }
                    case 'Q': {
                        if (ao.nargs == 1) {
                            value = ai.getRawArgs();
                            break;
                        }
                        value = ai.getQ(key, defValue);
                        break;
                    }
                    case 'A': {
                        value = ai.getS(key, defValue);
                        if (M.macro != null && M.macro.isTxt()) break;
                        M.warning("Replacing A: with S: in macro/procedure command line arg = " + resname);
                        break;
                    }
                    default: {
                        M.error("Unsupported argument type in " + resname);
                        break;
                    }
                }
            } else if (resname.startsWith("CS:")) {
                value = ai.getCS(key, defValue);
            } else if (resname.startsWith("FN:")) {
                value = ai.getFileName(key, defValue);
            } else {
                M.error("Unsupported argument type in " + resname);
            }
            M.results.put(aoRes, value);
            ++i2;
            ++idx;
        }
    }

    private String readFiltered(TextFile file) {
        String text = this.textNext;
        this.textNext = null;
        if (text == null) {
            text = file.readProper();
        }
        if (text == null) {
            return text;
        }
        int i = text.indexOf(10);
        if (i > 0) {
            this.textNext = text.substring(i + 1);
            return text.substring(0, i);
        }
        if (!(text.length() < 3 || text.charAt(0) != 'i' && text.charAt(0) != 'I' || text.charAt(1) != 'f' && text.charAt(1) != 'F' || text.charAt(2) != ' ' && text.charAt(2) != ',')) {
            String op;
            Parser p = new Parser(text);
            p.clean();
            i = 3;
            while ((op = p.get(i)).length() != 0) {
                if (op.charAt(0) == 'N') {
                    op = op.substring(1);
                }
                if (Args.isUnaryTest(op)) {
                    ++i;
                } else if (!Args.isCompoundTest(op) && !op.equals("THEN")) {
                    i += 2;
                }
                op = p.get(i);
                if (op.length() == 0 || !Args.isCompoundTest(op)) break;
                i += 2;
            }
            if (op.equals("THEN")) {
                op = p.get(++i);
            }
            if (op.length() > 0) {
                i = p.curoffset;
                this.textNext = new String(p.buffer, i, p.length - i);
                if (!this.textNext.endsWith("\nENDIF")) {
                    this.textNext = this.textNext + "\nENDIF";
                }
                text = new String(p.buffer, 0, i - 1);
            }
        }
        return text;
    }

    private void checkElseifStruct(Args targs) {
        String tmpstr;
        int i = 2;
        while ((tmpstr = targs.getU(i)).length() != 0) {
            if (tmpstr.toUpperCase().equals("THEN")) {
                if ((tmpstr = targs.getU(++i)).length() == 0) break;
                StringBuilder sb = new StringBuilder();
                while (targs.getU(i).length() != 0) {
                    sb.append(targs.getU(i)).append(" ");
                    ++i;
                }
                sb.deleteCharAt(sb.lastIndexOf(" "));
                this.M.warning("The following text beyond 'THEN' in ELSEIF statement will be ignored: [" + sb + "]");
            }
            ++i;
        }
    }

    public void setTimers(int nTimers) {
        this.nTimers = nTimers;
        this.timer = new double[nTimers];
        this.timerinit = new double[nTimers];
    }

    public double getTimer(int i) {
        if (i < 0 || i >= this.nTimers) {
            throw new MidasException("Invalid timer index = " + i);
        }
        return this.timer[i];
    }

    public void setTimer(int i, double value) {
        if (i < 0 || i >= this.nTimers) {
            throw new MidasException("Invalid timer index = " + i + " to set value = " + value);
        }
        this.timer[i] = value;
        this.timerinit[i] = Time.current();
    }

    public void setControls(Table controls) {
        this.controls = controls;
    }

    public Table getControls() {
        return this.controls;
    }

    public Macro cloneOf() {
        try {
            Macro macro = (Macro)this.clone();
            macro.returns = new int[this.maxLevel];
            macro.results = new Results[this.maxLevel];
            macro.level = 0;
            macro.returns[0] = -1;
            macro.results[0] = this.midas2.results;
            macro.nextIndex = -1;
            return macro;
        }
        catch (CloneNotSupportedException e) {
            throw new MidasException("Clone of Macro not supported", e);
        }
    }

    public Args[] getLines() {
        return this.lines;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public Midas getParentContext() {
        return this.midas1;
    }

    public Table getRegistry() {
        return this.midas2.registry.table;
    }

    public Results getResults() {
        return this.midas2.results;
    }

    public KeyVector getPrimitives() {
        return this.primitives;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean isShared(int mask) {
        return (this.shareMask & mask) != 0;
    }

    @Override
    public synchronized String getMsgID() {
        String retMsgID = super.getMsgID();
        if (!(retMsgID.isEmpty() || retMsgID.startsWith("GLOBAL.") || retMsgID.equals("<unknown>"))) {
            retMsgID = "PARENT." + retMsgID;
        }
        return retMsgID;
    }

    public boolean isTxt() {
        return this.txt;
    }

    public void prepTxtCommand(Command cmd) {
        String ctags;
        if (cmd.support == 'P' && (ctags = this.sysctags.getS(cmd.name)) != null) {
            Parser p = new Parser(ctags);
            this.parseControlTagSwitch(cmd, p);
            for (int i = 1; i <= p.elements(); ++i) {
                this.cwidgets.add(cmd.getID() + "-" + i, p.get(i));
                int wbid = cmd.args.getL("/WB") * 1000 + i;
                if (wbid <= 0) continue;
                this.MR.addFunction("W_" + wbid, new ControlTag("REG." + cmd.getID() + "." + p.get(i)));
            }
        }
    }

    public synchronized void adjustStaticCount(int inc) {
        this.staticCount += inc;
    }

    public void addControlWidget(Command cmd, int cid, String name) {
        if (!this.txt) {
            return;
        }
        if (cid == 1) {
            this.parseControlTagSwitch(cmd, null);
        }
        this.cwidgets.add(cmd.getID() + "-" + cid, name);
        int wbid = cmd.args.getL("/WB") * 1000 + cid;
        if (wbid > 0) {
            this.MR.addFunction("W_" + wbid, new ControlTag("REG." + cmd.getID() + ".W_" + cid));
        }
    }

    private void parseControlTagSwitch(Command cmd, Parser cp) {
        String ctag = cmd.args.getS("/CTAG");
        if (ctag == null || ctag.length() == 0) {
            return;
        }
        if (ctag.charAt(0) == '(') {
            ctag = ctag.substring(1, ctag.length() - 1);
        }
        Parser p = new Parser(ctag);
        for (int i = 1; i <= p.elements(); ++i) {
            String tag = p.get(i);
            int lc = tag.indexOf(58);
            int tid = Convert.s2l(tag.substring(0, lc));
            tag = tag.substring(lc + 1);
            String func = cp != null ? cp.get(tid) : "W_" + tid;
            this.MR.addFunction(tag, new ControlTag("REG." + cmd.getID() + "." + func));
        }
    }

    public KeyVector getControlWidgets() {
        return this.cwidgets;
    }

    public Map<String, Table.Function> getControlTags() {
        return this.MR.getFunctions();
    }

    @Override
    public String getStatus() {
        Object s = this.results[0].get("STATUS");
        return s == null ? this.getState() : s.toString();
    }

    public class ControlTag
    implements Table.Function {
        private String expression;

        public ControlTag(String expr) {
            this.expression = expr;
        }

        @Override
        public Object exec(Object args) {
            return null;
        }

        @Override
        public void set(Object value) {
            if (Macro.this.MR != null) {
                Macro.this.MR.put(this.expression, value);
            }
        }

        @Override
        public Object get() {
            return Macro.this.MR != null ? Macro.this.MR.get(this.expression) : null;
        }

        public String toString() {
            return this.expression;
        }
    }
}

