/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyValuePair;
import nxm.sys.inc.MapKBT;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.SpecialLoggingRequired;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.CallStackUtil;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.JsonUtilities;
import nxm.sys.lib.Midas;
import nxm.sys.lib.PropsUtilities;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;
import nxm.sys.lib.Util;

@ProvisionalUseOnly(value="Not fully tested and API could change")
@SpecialLoggingRequired
public final class LogUtilities {
    private static final Object[] ONE_ARG = new Object[0];
    private static final Object[] NO_ARGS = null;
    public static final Level VERBOSE = new Level("VERBOSE", 600){
        private static final long serialVersionUID = 315666203327385033L;
    };
    public static final Level DEBUG = new Level("DEBUG", 200){
        private static final long serialVersionUID = 315666203327385033L;
    };
    public static final Level ADMIN = new Level("ADMIN", 1100){
        private static final long serialVersionUID = 315666203327385033L;
    };
    public static final Level Level_VERBOSE = VERBOSE;
    public static final Level Level_DEBUG = DEBUG;
    public static final Level Level_ADMIN = ADMIN;
    private static final Logger LOG = Logger.getLogger(LogUtilities.class.getName());
    private static final int INFO_INT_LEVEL = 800;
    private static final int WARNING_INT_LEVEL = 900;
    private static final int SEVERE_INT_LEVEL = 1000;
    private static final int NOT_AVAILABLE = -1;
    private static final Map<String, Logger> LOGGERS = new WeakHashMap<String, Logger>(128);
    private static final Logger GLOBAL = Logger.getGlobal();
    private static final Method demandLogger;
    private static final String JDK_17_INACCESSIBLEOBJECTEXCEPTION_CLASS_STRING = "class java.lang.reflect.InaccessibleObjectException";

    private LogUtilities() {
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void initLogUtilities() {
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void resetLogUtilities() {
        LogUtilities.initLogUtilities();
        LOGGERS.clear();
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Properties loadLoggingProperties(MapKBT propMap) {
        return LogUtilities.loadLoggingProperties(propMap, true);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Properties loadLoggingProperties(MapKBT propMap, boolean hasPrefix) {
        Properties properties = PropsUtilities.loadProps(propMap);
        LogUtilities.loadLoggingProperties(properties, hasPrefix);
        return properties;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void loadLoggingProperties(String propsFile) {
        LogUtilities.loadLoggingProperties(PropsUtilities.loadProps(propsFile), true);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void loadLoggingProperties(Properties props) {
        LogUtilities.loadLoggingProperties(props, true);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void loadLoggingProperties(String propsFile, boolean hasPrefix) {
        LogUtilities.loadLoggingProperties(PropsUtilities.loadProps(propsFile), hasPrefix);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void loadLoggingProperties(Properties props, boolean hasPrefix) {
        Properties logProps = hasPrefix ? PropsUtilities.extractProps(props, "LOGGING-", false) : props;
        try {
            StringWriter out = new StringWriter();
            logProps.store(out, null);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            LogUtilities.resetLogUtilities();
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException | SecurityException e) {
            throw new RuntimeException("Unable to load logging properties", e);
        }
    }

    @InternalUseOnly
    public static Map<String, String> propsAsMap(Properties props) {
        if (props == null) {
            return null;
        }
        Enumeration<?> e = props.propertyNames();
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String val = props.getProperty(key);
            if (val != null) {
                val = val.replaceAll("\n", "\\n").replaceAll("\r", "\\r").replaceAll("\f", "\\f");
            }
            map.put(key, val);
        }
        return map;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, String msg) {
        LogUtilities._log_with_class(clazz, null, level, msg, null, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, String msg, Object param) {
        LogUtilities._log_with_class(clazz, null, level, msg, null, param, ONE_ARG);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, String msg, Object ... params) {
        LogUtilities._log_with_class(clazz, null, level, msg, null, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, String msg, Throwable thrown) {
        LogUtilities._log_with_class(clazz, null, level, msg, thrown, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, String msg, Throwable thrown, Object param) {
        LogUtilities._log_with_class(clazz, null, level, msg, thrown, param, ONE_ARG);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, String msg, Throwable thrown, Object ... params) {
        LogUtilities._log_with_class(clazz, null, level, msg, thrown, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, Supplier<String> msgSupplier) {
        LogUtilities._log_with_class(clazz, null, level, null, msgSupplier);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Level level, Throwable thrown, Supplier<String> msgSupplier) {
        LogUtilities._log_with_class(clazz, null, level, thrown, msgSupplier);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Midas midas, Level level, String msg) {
        LogUtilities._log_with_class(clazz, midas, level, msg, null, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Midas midas, Level level, String msg, Object params) {
        LogUtilities._log_with_class(clazz, midas, level, msg, null, params, ONE_ARG);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Midas midas, Level level, String msg, Object ... params) {
        LogUtilities._log_with_class(clazz, midas, level, msg, null, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Midas midas, Level level, String msg, Throwable thrown) {
        LogUtilities._log_with_class(clazz, midas, level, msg, thrown, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Midas midas, Level level, Supplier<String> msgSupplier) {
        LogUtilities._log_with_class(clazz, midas, level, null, msgSupplier);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Class<?> clazz, Midas midas, Level level, Throwable thrown, Supplier<String> msgSupplier) {
        LogUtilities._log_with_class(clazz, midas, level, thrown, msgSupplier);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Level level, String msg) {
        LogUtilities._log(null, level, msg, null, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Level level, String msg, Object param) {
        LogUtilities._log(null, level, msg, null, param, ONE_ARG);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Level level, String msg, Object ... params) {
        LogUtilities._log(null, level, msg, null, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Level level, String msg, Throwable thrown) {
        LogUtilities._log(null, level, msg, thrown, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Level level, String msg, Throwable thrown, Object param) {
        LogUtilities._log(null, level, msg, thrown, param, ONE_ARG);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Level level, String msg, Throwable thrown, Object ... params) {
        LogUtilities._log(null, level, msg, thrown, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Midas midas, Level level, String msg) {
        LogUtilities._log(midas, level, msg, null, null, NO_ARGS);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Midas midas, Level level, String msg, Object params) {
        LogUtilities._log(midas, level, msg, null, params, ONE_ARG);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void log(Midas midas, Level level, String msg, Object ... params) {
        LogUtilities._log(midas, level, msg, null, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Level level1, String msg1, Level level2, String msg2, Object ... params) {
        LogUtilities._log(null, Objects.requireNonNull(level1), msg1, null, null, params, Objects.requireNonNull(level2), msg2, null, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Level level1, String msg1, Object params1, Level level2, String msg2, Object ... params2) {
        LogUtilities._log(null, Objects.requireNonNull(level1), msg1, null, params1, ONE_ARG, Objects.requireNonNull(level2), msg2, null, null, params2);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Level level1, String msg1, Object[] params1, Level level2, String msg2, Object ... params2) {
        LogUtilities._log(null, Objects.requireNonNull(level1), msg1, null, null, params1, Objects.requireNonNull(level2), msg2, null, null, params2);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Level level1, String msg1, Throwable thrown1, Object params1, Level level2, String msg2, Throwable thrown2, Object ... params2) {
        LogUtilities._log(null, Objects.requireNonNull(level1), msg1, thrown1, params1, ONE_ARG, Objects.requireNonNull(level2), msg2, thrown2, null, params2);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Level level1, String msg1, Throwable thrown1, Object[] params1, Level level2, String msg2, Throwable thrown2, Object ... params2) {
        LogUtilities._log(null, Objects.requireNonNull(level1), msg1, thrown1, null, params1, Objects.requireNonNull(level2), msg2, thrown2, null, params2);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Midas midas, Level level1, String msg1, Level level2, String msg2, Object ... params) {
        LogUtilities._log(midas, Objects.requireNonNull(level1), msg1, null, null, params, Objects.requireNonNull(level2), msg2, null, null, params);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Midas midas, Level level1, String msg1, Object params1, Level level2, String msg2, Object ... params2) {
        LogUtilities._log(midas, Objects.requireNonNull(level1), msg1, null, params1, ONE_ARG, Objects.requireNonNull(level2), msg2, null, null, params2);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logEither(Midas midas, Level level1, String msg1, Object[] params1, Level level2, String msg2, Object ... params2) {
        LogUtilities._log(midas, Objects.requireNonNull(level1), msg1, null, null, params1, Objects.requireNonNull(level2), msg2, null, null, params2);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void logUncaughtException(Thread t, Throwable e) {
        LogUtilities.log(Level.SEVERE, "Caught exception in {0}", e, (Object)t.getName());
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void severe(String msg) {
        LogUtilities.log(Level.SEVERE, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void warning(String msg) {
        LogUtilities.log(Level.WARNING, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void info(String msg) {
        LogUtilities.log(Level.INFO, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void config(String msg) {
        LogUtilities.log(Level.CONFIG, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void verbose(String msg) {
        LogUtilities.log(Level_VERBOSE, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void fine(String msg) {
        LogUtilities.log(Level.FINE, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void finer(String msg) {
        LogUtilities.log(Level.FINER, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void finest(String msg) {
        LogUtilities.log(Level.FINEST, msg);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static void debug(String msg) {
        LogUtilities.log(Level_DEBUG, msg);
    }

    private static void _log(Midas midas, Level level, String msg, Throwable thrown, Object param, Object[] params) {
        LogUtilities._log(midas, level, msg, thrown, param, params, null, null, null, null, null);
    }

    private static void _log_with_class(Class<?> clazz, Midas midas, Level level, String msg, Throwable thrown, Object param, Object[] params) {
        LogUtilities._log_with_class(clazz, midas, level, msg, thrown, param, params, null, null, null, null, null);
    }

    private static void _log_with_class(Class<?> clazz, Midas midas, Level level, Throwable thrown, Supplier<String> msgSupplier) {
        LogUtilities._log_with_class(clazz, midas, level, thrown, msgSupplier, null, null, null);
    }

    private static void _log(Midas midas, Level level1, String msg1, Throwable thrown1, Object param1, Object[] params1, Level level2, String msg2, Throwable thrown2, Object param2, Object[] params2) {
        Logger log;
        StackTraceElement caller = CallStackUtil.getCaller(LogUtilities.class);
        if (caller != null && caller.getClassName() != null) {
            log = LOGGERS.get(caller.getClassName());
            if (log == null) {
                log = LogUtilities.getLogger(caller);
                LOGGERS.put(caller.getClassName(), log);
            }
        } else {
            log = GLOBAL;
        }
        if (level2 == null || level1.intValue() >= level2.intValue()) {
            if (!log.isLoggable(level1)) {
                return;
            }
        } else {
            if (!log.isLoggable(level2)) {
                return;
            }
            level1 = level2;
            msg1 = msg2;
            thrown1 = thrown2;
            param1 = param2;
            params1 = params2;
        }
        if (params1 == ONE_ARG) {
            params1 = new Object[]{param1};
        }
        LogUtilities._logRecord(midas, caller, level1, msg1, thrown1, params1, log);
    }

    @InternalUseOnly
    public static void createAndAddHandler(String className, Handler handler) {
        Logger log = LOGGERS.get(className);
        if (log == null) {
            log = LogUtilities.getLogger(className);
            LOGGERS.put(className, log);
        }
        log.addHandler(handler);
    }

    private static void _log_with_class(Class<?> clazz, Midas midas, Level level1, String msg1, Throwable thrown1, Object param1, Object[] params1, Level level2, String msg2, Throwable thrown2, Object param2, Object[] params2) {
        Logger log = LOGGERS.get(clazz.getName());
        if (log == null) {
            log = LogUtilities.getLogger(clazz.getName());
            LOGGERS.put(clazz.getName(), log);
        }
        if (level2 == null || level1.intValue() >= level2.intValue()) {
            if (!log.isLoggable(level1)) {
                return;
            }
        } else {
            if (!log.isLoggable(level2)) {
                return;
            }
            level1 = level2;
            msg1 = msg2;
            thrown1 = thrown2;
            param1 = param2;
            params1 = params2;
        }
        if (params1 == ONE_ARG) {
            params1 = new Object[]{param1};
        }
        StackTraceElement caller = CallStackUtil.getCallerByClass(clazz);
        LogUtilities._logRecord(midas, caller, level1, msg1, thrown1, params1, log);
    }

    private static void _log_with_class(Class<?> clazz, Midas midas, Level level1, Throwable thrown1, Supplier<String> msgSupplier1, Level level2, Throwable thrown2, Supplier<String> msgSupplier2) {
        Logger log = LOGGERS.get(clazz.getName());
        if (log == null) {
            log = LogUtilities.getLogger(clazz.getName());
            LOGGERS.put(clazz.getName(), log);
        }
        if (level2 == null || level1.intValue() >= level2.intValue()) {
            if (!log.isLoggable(level1)) {
                return;
            }
        } else {
            if (!log.isLoggable(level2)) {
                return;
            }
            level1 = level2;
            msgSupplier1 = msgSupplier2;
            thrown1 = thrown2;
        }
        StackTraceElement caller = CallStackUtil.getCallerByClass(clazz);
        LogUtilities._logRecord(midas, caller, level1, msgSupplier1.get(), thrown1, null, log);
    }

    private static void _logRecord(Midas midas, StackTraceElement caller, Level level, String msg, Throwable thrown, Object[] params, Logger log) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof Supplier)) continue;
                params[i] = ((Supplier)params[i]).get();
            }
        }
        boolean classBaseLoggerShouldUseMidasLogger = false;
        if (Shell.isShellInit()) {
            classBaseLoggerShouldUseMidasLogger = Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.ClassBasedLoggerShouldUseMidasLogger);
        }
        if (level.intValue() < 800 || !classBaseLoggerShouldUseMidasLogger) {
            EnhancedLogRecord rec = new EnhancedLogRecord(level, msg);
            rec.setResourceBundle(log.getResourceBundle());
            rec.setResourceBundleName(log.getResourceBundleName());
            rec.setParameters(params);
            rec.setThrown(thrown);
            if (caller != null) {
                rec.setSourceClassName(caller.getClassName());
                rec.setSourceMethodName(caller.getMethodName());
                rec.setSourceLineNumber(caller.getLineNumber());
                rec.setSourceFileName(caller.getFileName());
            } else {
                rec.setSourceClassName(null);
                rec.setSourceMethodName(null);
                rec.setSourceLineNumber(null);
                rec.setSourceFileName(null);
            }
            log.log(rec);
        } else {
            LogUtilities.midasLog(midas, level, caller.getClassName(), caller.getMethodName(), caller.getLineNumber(), msg, params);
        }
    }

    public static void midasLog(Midas midas, Level level, String msg, Object[] params) {
        StackTraceElement caller = CallStackUtil.getCaller(LogUtilities.class);
        LogUtilities.midasLog(midas, level, caller.getClassName(), caller.getMethodName(), caller.getLineNumber(), msg, params);
    }

    private static void midasLog(Midas midas, Level level, String sourceClass, String sourceMethod, int lineNumber, String msg, Object[] params) {
        String from;
        int intLogLevel = level.intValue();
        if (intLogLevel < 800) {
            return;
        }
        if (midas == null) {
            midas = Shell.getMidasContext();
        }
        String string = from = lineNumber == -1 ? sourceClass + "." + sourceMethod : sourceClass + "." + sourceMethod + ":" + lineNumber;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                msg = msg.replace("{" + i + "}", params[i].toString());
            }
        }
        switch (intLogLevel) {
            case 800: {
                midas.message(msg, 0, from);
                break;
            }
            case 900: {
                midas.message(msg, 1, from);
                break;
            }
            case 1000: {
                midas.message(msg, 2, from);
            }
        }
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Supplier<String> lazyToString(Object obj) {
        return () -> LogUtilities._toJSON(obj);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Supplier<String> lazyToString(Properties props) {
        return () -> LogUtilities._toJSON(LogUtilities.propsAsMap(props));
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Supplier<String> lazyToString(byte[] buf) {
        return () -> LogUtilities._toJSON(buf, 0, -1);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Supplier<String> lazyToString(char[] buf) {
        return () -> LogUtilities._toJSON(buf, 0, -1);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Supplier<String> lazyToString(byte[] buf, int off, int len) {
        return () -> LogUtilities._toJSON(buf, off, len);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Supplier<String> lazyToString(char[] buf, int off, int len) {
        return () -> LogUtilities._toJSON(buf, off, len);
    }

    private static String _toJSON(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            return JsonUtilities.toJSON(obj, JsonUtilities.Mode.Auto).toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    private static String _toJSON(byte[] buf, int off, int len) {
        if (buf == null) {
            return "null";
        }
        try {
            if (len < 0) {
                len = buf.length;
            }
            return JsonUtilities.toJSON(new String(buf, off, len)).toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    private static String _toJSON(char[] buf, int off, int len) {
        if (buf == null) {
            return "null";
        }
        try {
            if (len < 0) {
                len = buf.length;
            }
            return JsonUtilities.toJSON(new String(buf, off, len)).toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    @InternalUseOnly
    public static Method getDemandLogger() {
        return demandLogger;
    }

    @InternalUseOnly
    public static Logger getLogger() {
        return LogUtilities.getLogger(CallStackUtil.getCaller(LogUtilities.class));
    }

    private static Logger getLogger(StackTraceElement caller) {
        if (demandLogger != null) {
            try {
                Class<?> callingClass = Class.forName(caller.getClassName());
                return (Logger)demandLogger.invoke(null, caller.getClassName(), null, callingClass);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Unable to use demandLogger", t);
                return Logger.getLogger(caller.getClassName());
            }
        }
        return Logger.getLogger(caller.getClassName());
    }

    private static Logger getLogger(String className) {
        if (demandLogger != null) {
            try {
                Class<?> callingClass = Class.forName(className);
                return (Logger)demandLogger.invoke(null, className, null, callingClass);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Unable to use demandLogger", t);
                return Logger.getLogger(className);
            }
        }
        return Logger.getLogger(className);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra extra() {
        return new Extra();
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra extra(KeyValuePair<?> ... extraArgs) {
        return new Extra(extraArgs);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(Map<String, Object> map) {
        return new Extra(map);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(BaseFile file) {
        Extra extra = LogUtilities.asExtra("FILE", file);
        extra.put("FILENAME", (Object)file.getName());
        return extra;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(File file) {
        Extra extra = LogUtilities.asExtra("FILE", file);
        extra.put("FILENAME", (Object)file);
        return extra;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(Path path) {
        Extra extra = LogUtilities.asExtra("FILE", path);
        extra.put("FILENAME", (Object)path);
        return extra;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(String prefix, Path path) {
        return LogUtilities.asExtra(prefix, path == null ? null : path.toFile());
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(String prefix, BaseFile file) {
        Extra extra = new Extra();
        double now = Time.current();
        if (file != null) {
            extra.put(prefix + "_NAME", (Object)file.getName());
            extra.put(prefix + "_SIZE", (Object)file.getSize());
            if (file.io != null) {
                Time time = file.io.lastModifiedTime();
                extra.put(prefix + "_EXISTS", (Object)file.io.exists());
                extra.put(prefix + "_LENGTH", (Object)file.io.getLength());
                if (time != null) {
                    extra.put(prefix + "_LAST_MODIFIED", (Object)time);
                    extra.put(prefix + "_LAST_MODIFIED_J1950", (Object)time.getSec());
                    extra.put(prefix + "_LAST_MODIFIED_SINCE", (Object)(now - time.getSec()));
                }
            }
            if (file instanceof DataFile) {
                DataFile df = (DataFile)file;
                Time start = df.getTimeAt(0.0, null);
                Time end = df.getTimeAt(df.getSize(), null);
                extra.put(prefix + "_TIME", (Object)start);
                extra.put(prefix + "_TIME_J1950", (Object)start.getSec());
                extra.put(prefix + "_TIME_SINCE", (Object)(now - start.getSec()));
                extra.put(prefix + "_DURATION", (Object)end.diff(start));
            }
        } else {
            extra.put(prefix + "_NAME", (Object)null);
        }
        return extra;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra asExtra(String prefix, File file) {
        Extra extra = new Extra();
        double now = Time.current();
        extra.put(prefix + "_NAME", (Object)Objects.toString(file));
        if (file != null) {
            long t = file.lastModified();
            extra.put(prefix + "_EXISTS", (Object)file.exists());
            extra.put(prefix + "_LENGTH", (Object)file.length());
            if (t > 0L) {
                Time time = new Time(6.31152E8 + (double)t * 0.001);
                extra.put(prefix + "_LAST_MODIFIED", (Object)time);
                extra.put(prefix + "_LAST_MODIFIED_J1950", (Object)time.getSec());
                extra.put(prefix + "_LAST_MODIFIED_SINCE", (Object)(now - time.getSec()));
            }
        }
        return extra;
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Duration duration() {
        return LogUtilities.duration("DURATION");
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Duration duration(String name) {
        return new Duration(name);
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static Extra singletonExtra(String key, Object val) {
        return new Extra(MapKBT.singletonMap(key, val));
    }

    @InternalUseOnly
    public static String buildMessage(String msg, Object ... params) {
        for (Object param : Arrays.asList(params)) {
            if (msg.contains("{}")) {
                msg = msg.replaceFirst("\\{\\}", Matcher.quoteReplacement(LogUtilities.parseParam(param)));
                continue;
            }
            msg = msg.concat(" " + LogUtilities.parseParam(param));
        }
        return msg;
    }

    private static String parseParam(Object param) {
        if (param == null) {
            return "null";
        }
        if (param instanceof List) {
            StringBuilder list3 = new StringBuilder();
            ((List)param).forEach(o -> {
                if (!list3.toString().isEmpty()) {
                    list3.append(", ");
                } else {
                    list3.append("[");
                }
                list3.append(LogUtilities.parseParam(o));
            });
            list3.append("]");
            return list3.toString();
        }
        return param.toString();
    }

    @InternalUseOnly
    public static String indentBlock(String msg) {
        return LogUtilities.indentBlock(msg, 1);
    }

    @InternalUseOnly
    public static String indentBlock(String msg, int indentLevel) {
        StringBuilder out = new StringBuilder();
        String[] lines = msg.split(System.lineSeparator());
        for (int i = 0; i < lines.length; ++i) {
            out.append(System.lineSeparator());
            for (int j = 0; j < indentLevel; ++j) {
                out.append("\t");
            }
            out.append(lines[i]);
        }
        return out.toString();
    }

    static {
        Method _demandLogger = null;
        try {
            _demandLogger = Logger.class.getDeclaredMethod("demandLogger", String.class, String.class, Class.class);
            _demandLogger.setAccessible(true);
        }
        catch (Throwable t) {
            if (t.getClass().toString().equals(JDK_17_INACCESSIBLEOBJECTEXCEPTION_CLASS_STRING)) {
                LOG.log(Level.WARNING, "java.lang.reflect.InaccessibleObjectException: To use Logger.demandLogger(..) add this jvm option: --add-opens java.logging/java.util.logging=ALL-UNNAMED");
            } else {
                LOG.log(Level.FINE, "Could not use Logger.demandLogger(..)", t);
            }
            _demandLogger = null;
        }
        demandLogger = _demandLogger;
    }

    static class LinkedHashSet2
    extends LinkedHashSet<Object> {
        private static final long serialVersionUID = 1314040165671785607L;

        LinkedHashSet2(Collection<?> c) {
            super(c);
        }
    }

    static class TreeSet2
    extends TreeSet<Comparable<?>> {
        private static final long serialVersionUID = 1960306712106128519L;

        TreeSet2(Collection<Comparable<?>> c) {
            super(c);
        }
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static class EnhancedLogRecord
    extends LogRecord
    implements EnhancedLogInfo {
        private static final long serialVersionUID = 5000238113247900758L;
        private Integer sourceLineNumber;
        private String sourceFileName;
        private Instant instant;

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public EnhancedLogRecord(Level level, String msg) {
            super(level, msg);
            this.setInstant(null);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public void setSourceLineNumber(Integer val) {
            this.sourceLineNumber = val == null || val < 0 ? null : val;
        }

        @Override
        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public Integer getSourceLineNumber() {
            return this.sourceLineNumber;
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public void setSourceFileName(String val) {
            this.sourceFileName = val;
        }

        @Override
        public String getSourceFileName() {
            return this.sourceFileName;
        }

        @Override
        public Instant getInstant() {
            return this.instant;
        }

        @Override
        public final long getMillis() {
            return this.instant.toEpochMilli();
        }

        @Override
        public final void setMillis(long ms) {
            this.setInstant(Instant.ofEpochMilli(ms));
        }

        @Override
        public void setInstant(Instant ts) {
            this.instant = ts != null ? ts : Instant.ofEpochSecond(0L, Util.currentTimeNano());
            super.setMillis(this.instant.toEpochMilli());
        }
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static interface EnhancedLogInfo {
        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public Instant getInstant();

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        default public Integer getSourceLineNumber() {
            return null;
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        default public String getSourceFileName() {
            return null;
        }
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static class Duration
    extends Extra {
        private final String name;
        private final long start;

        Duration(String name) {
            this.name = name;
            this.start = System.currentTimeMillis();
        }

        @Override
        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public MapKBT getExtra() {
            MapKBT extraMap = super.getExtra();
            Number val = Util.round((double)this.getDurationMS() * 0.001, 3);
            extraMap.put(this.name, val);
            return extraMap;
        }

        public long getDurationMS() {
            return System.currentTimeMillis() - this.start;
        }
    }

    @ProvisionalUseOnly(value="Not fully tested and API could change")
    public static class Extra {
        private final KeyValuePair<?>[] extraArgs;
        private MapKBT extraMap;

        Extra() {
            this(new TreeMap<String, Object>());
        }

        Extra(Map<String, Object> map) {
            this.extraArgs = null;
            this.extraMap = MapKBT.wrapMap(map);
        }

        Extra(KeyValuePair<?> ... extraArgs) {
            this.extraArgs = extraArgs;
            this.extraMap = null;
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public MapKBT getExtra() {
            if (this.extraMap == null) {
                this.extraMap = this.extraArgs == null || this.extraArgs.length == 0 ? MapKBT.newMap() : MapKBT.wrapMap(KeyValuePair.toMap(this.extraArgs));
            }
            return this.extraMap;
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void putAll(Map<String, ? extends Object> map) {
            this.getExtra().putAll(map);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void putAll(Extra extra) {
            this.putAll(extra.getExtra());
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void add(String key, Object val) {
            this.put(key, val, true);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void add(String key, Collection<?> vals) {
            this.put(key, vals, true);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void add(String key, Object ... vals) {
            this.put(key, Arrays.asList(vals), true);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void put(String key, Object val) {
            this.put(key, val, false);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void put(String key, Object ... vals) {
            this.put(key, Arrays.asList(vals), false);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final void put(String key, Collection<?> val) {
            this.put(key, val, false);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        protected void put(String key, Object val, boolean add) {
            if (add && val == null) {
                return;
            }
            if (key.endsWith("(S)")) {
                Set<?> s;
                String single = key.substring(0, key.length() - 3);
                String multiple = single + "S";
                MapKBT e = this.getExtra();
                if (!add) {
                    e.put(multiple, Collections.singleton(val));
                    e.put(single, val);
                    return;
                }
                if (e.containsKey(multiple)) {
                    s = Extra.merge(e.getCollection(multiple), val);
                } else if (e.containsKey(single)) {
                    s = Extra.merge(Collections.singleton(val), e.get(single));
                } else {
                    e.put(multiple, Collections.singleton(val));
                    e.put(single, val);
                    return;
                }
                if (s.size() == 1) {
                    e.put(multiple, Collections.singleton(val));
                    e.put(single, val);
                } else {
                    e.put(multiple, s);
                    e.put(single, null);
                }
            } else {
                this.getExtra().put(key, val);
            }
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        protected void put(String key, Collection<?> c, boolean add) {
            if (key.endsWith("(S)")) {
                String single = key.substring(0, key.length() - 3);
                String multiple = single + "S";
                MapKBT e = this.getExtra();
                if (add) {
                    if (c == null || c.isEmpty()) {
                        return;
                    }
                    if (e.containsKey(multiple)) {
                        c = Extra.merge(e.getCollection(multiple), c);
                    } else if (e.containsKey(single)) {
                        c = Extra.merge(c, e.get(single));
                    }
                }
                if (c != null && c.size() == 1) {
                    e.put(multiple, c);
                    e.put(single, Util.first(c));
                } else {
                    e.put(multiple, c);
                    e.put(single, null);
                }
            } else if (!add || c != null) {
                this.getExtra().put(key, c);
            }
        }

        private static Set<?> merge(Collection<?> a, Collection<?> b) {
            if (a.isEmpty()) {
                return Extra.setOf(b);
            }
            if (b.isEmpty()) {
                return Extra.setOf(a);
            }
            if (a instanceof LinkedHashSet2) {
                a.addAll(b);
                return (Set)a;
            }
            LinkedHashSet2 set = new LinkedHashSet2(a);
            set.addAll(b);
            return set;
        }

        private static Set<?> merge(Collection<?> a, Object b) {
            if (a instanceof LinkedHashSet2) {
                LinkedHashSet2 s = (LinkedHashSet2)a;
                s.add(b);
                return s;
            }
            if (a instanceof TreeSet2 && Util.first(a).getClass() == b.getClass()) {
                TreeSet2 s = (TreeSet2)a;
                s.add((Comparable)b);
                return s;
            }
            return Extra.merge(a, Collections.singleton(b));
        }

        private static Set<?> setOf(Collection<?> c) {
            if (c instanceof Set) {
                return (Set)c;
            }
            if (c.isEmpty()) {
                return Collections.emptySortedSet();
            }
            return new LinkedHashSet2(c);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final Object remove(String key) {
            return this.getExtra().remove(key);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final Object get(String key) {
            return this.getExtra().get(key);
        }

        @ProvisionalUseOnly(value="Not fully tested and API could change")
        public final String toString() {
            return this.getExtra().toString();
        }
    }
}

