/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class Keywords
implements Keyable,
DataTypes,
AsciiMap {
    @InternalUseOnly(value="Since NeXtMidas 3.3.0")
    public static final String[] MAIN_HEADER_KEYWORDS = new String[]{"CREATOR", "IO", "PACKET", "PKT_BYTE_COUNT", "TC_PREC", "VER"};
    @InternalUseOnly(value="Since created")
    public static final String[] MAIN_HEADER_IGNORE = new String[]{"ACQDATE", "ACQTIME", "COMMENT"};
    private static final int IKOFF = 164;
    private static final int IKMAX = 92;
    private static final int EXTSIZE = 2048;
    @InternalUseOnly(value="Since NeXtMidas 3.7.0")
    public static final int HEADER_LEN = 8;
    public static final int SCOPE = 0;
    public static final int MAIN = 1;
    public static final int EXTENDED = 2;
    public static final int ADD = 1;
    public static final int REPLACE = 2;
    private static final int ADD_REPLACE = 3;
    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this field should be private")
    public static final boolean EXTRACTINPLACE = false;
    public static final String flagsList = "NoAbort";
    public static final int NOABORT = 1;
    private static final int DEF_FLAGS = 0;
    @InternalUseOnly(value="Since NeXtMidas 3.7.1")
    public static final String DOT_SUBSTITUTE = "->";
    private static String dotSubstitute = "->";
    @InternalUseOnly(value="Since NeXtMidas 3.7.0")
    public byte[] buf;
    @InternalUseOnly(value="Since NeXtMidas 3.7.0")
    public byte[] ibuf;
    @InternalUseOnly(value="Since NeXtMidas 3.7.0")
    public int size = 0;
    @InternalUseOnly(value="Since NeXtMidas 3.7.0")
    public int isize = 0;
    private byte rep;
    private String scope = "";
    private int scope_start;
    private int scope_end;
    private Key cur = new Key();
    private DataFile hcb;
    private int flags = 0;
    private HashSet<String> warnedForInvalidBlockSet = new HashSet();
    private Integer prevInvalidHcbKeylength;
    static final String LPAREN_S = "(";
    static final String RPAREN_S = ")";
    @InternalUseOnly
    public static final int UNITS_WARN = 256;
    @InternalUseOnly
    public static final int UNITS_LIST = 512;
    @InternalUseOnly
    public static final int UNITS_PREFER_UNIT = 1024;
    @InternalUseOnly
    public static final int UNITS_MATCH = 2048;

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - Keywords objects should only be initialized by DataFile")
    public Keywords() {
        this.cur.offset = 0;
        this.hcb = null;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - Keywords objects should only be initialized by DataFile")
    public Keywords(DataFile hcb) {
        this();
        this.hcb = hcb;
        this.ibuf = hcb.hb;
        this.isize = -1;
    }

    private void initFromDataFile() throws MidasException {
        if (this.hcb == null) {
            throw new MidasException("Cannot init Keywords's main header fields from a null DataFile!");
        }
        this.ibuf = this.hcb.hb;
        this.isize = this.hcb.getKeyLength();
        if (this.isize > 92) {
            if (this.prevInvalidHcbKeylength == null || this.prevInvalidHcbKeylength != this.isize) {
                this.prevInvalidHcbKeylength = this.isize;
                this.warn("DataFile's main header has invalid keylength [" + this.isize + "]. Capping to max of " + 92 + " bytes.");
            }
            this.isize = 92;
        }
    }

    public void clear() {
        this.deleteAll();
    }

    public void deleteAll() {
        this.cur.offset = 0;
        this.isize = 0;
        this.size = 0;
        this.scope_end = 0;
        this.scope_start = 0;
    }

    public void clearScope() {
        this.scope_start = -this.isize;
        this.scope_end = this.size;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - Keywords objects should only be initialized by DataFile")
    public void init(byte[] buf, int size, byte rep) {
        this.size = size;
        this.buf = buf;
        if (this.hcb != null) {
            this.initFromDataFile();
        }
        this.rep = rep != 0 ? rep : Shell.rep;
        if (!this.chk(1024)) {
            String msg = "Bad Extended Header on URL=" + (this.hcb != null ? this.hcb.getURL() : "");
            this.warn(msg);
            this.size = 0;
        }
        this.clearScope();
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - Keywords objects should only be initialized by DataFile")
    public void init(Keywords kw) {
        this.buf = null;
        if (kw.size > 0) {
            this.buf = new byte[kw.buf.length];
            System.arraycopy(kw.buf, 0, this.buf, 0, kw.size);
        }
        this.init(this.buf, kw.size, (byte)0);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int newFlags) {
        this.flags = newFlags;
    }

    public void setFlags(String newFlagsStr) {
        this.setFlags(Parser.mask(flagsList, newFlagsStr, 0));
    }

    public String getFlagsString() {
        return Parser.mask2s(flagsList, this.flags);
    }

    public String getScope() {
        return this.scope;
    }

    public int setScope(String newScope) {
        Parser parser;
        int levels = 0;
        String string = this.scope = newScope == null ? "" : newScope.trim();
        if (this.scope.equals("ALL") || this.scope.length() == 0) {
            this.clearScope();
            return 1;
        }
        this.scope_start = -this.isize;
        this.scope_end = 0;
        if (this.scope.equals("MAIN")) {
            return 1;
        }
        this.scope_start = 0;
        this.scope_end = this.size;
        if (this.scope.equals("EXT")) {
            return 1;
        }
        if (this.scope.startsWith(LPAREN_S)) {
            if (this.scope.endsWith(RPAREN_S)) {
                parser = new Parser(this.scope.substring(1, this.scope.length() - 1), ',');
            } else {
                this.warn("Unbalanced parenthesis in '" + this.scope + "'");
                parser = new Parser(this.scope.substring(1), ',');
            }
        } else {
            parser = new Parser(this.scope, ',');
        }
        while (parser.more()) {
            String value;
            int iEqual;
            String str = parser.next();
            String name = str.substring(0, iEqual = str.indexOf(61));
            int found = this.setScope(name, value = str.substring(iEqual + 1));
            if (found == 1) {
                ++levels;
                continue;
            }
            levels = 0;
            break;
        }
        return levels;
    }

    private int setScope(String name, String value) {
        boolean nexttag;
        int blen;
        boolean found = false;
        Key k = new Key();
        byte[] bname = name.getBytes();
        boolean skiptag = bname[(blen = bname.length) - 1] == 45 || bname[blen - 1] == 43;
        boolean bl = nexttag = bname[blen - 1] == 43;
        if (nexttag || skiptag) {
            --blen;
        }
        k.offset = this.scope_start;
        while (k.offset < this.scope_end) {
            String invalidDetails = this.unpack(k);
            if (invalidDetails != null) {
                if (k.length < 8) break;
            } else if (k.ltag == blen) {
                int i;
                for (i = 0; i < blen && bname[i] == this.buf[k.offset + 8 + k.ldat + i]; ++i) {
                }
                if (i == blen) {
                    if (found) {
                        this.scope_end = k.offset;
                        if (nexttag) {
                            this.scope_end += k.length;
                        }
                        return 1;
                    }
                    this.extractData(k);
                    if (!Data.isString(k.type)) {
                        if (Convert.o2d(k.value) == Convert.o2d(value)) {
                            found = true;
                            this.scope_start = k.offset;
                            if (skiptag) {
                                this.scope_start += k.length;
                            }
                        }
                    } else if (value.equals(k.value.toString())) {
                        found = true;
                        this.scope_start = k.offset;
                        if (skiptag) {
                            this.scope_start += k.length;
                        }
                    }
                }
            }
            k.offset += k.length;
        }
        if (found) {
            return 1;
        }
        return 0;
    }

    public Key getNext() {
        this.cur.offset += this.cur.length;
        if (this.cur.offset >= this.scope_end) {
            return null;
        }
        String invalidDetails = this.unpack(this.cur);
        if (invalidDetails != null) {
            return null;
        }
        this.extractName(this.cur);
        this.extractData(this.cur);
        return this.cur;
    }

    private String unpack(Key k) {
        return this.unpack(k, Shell.rep);
    }

    private String unpack(Key k, byte hcbNullRep) {
        int off = k.offset;
        if (off < 0) {
            int i;
            for (i = off += this.isize; i < this.isize && this.ibuf[164 + i] != 0; ++i) {
            }
            k.length = i - off;
            for (i = off; i < off + k.length && this.ibuf[164 + i] != 61; ++i) {
            }
            k.ltag = i - off;
            k.ldat = k.length - k.ltag - 1;
            k.type = (byte)65;
            if (this.ibuf[164 + off + 1] == 58) {
                k.type = this.ibuf[164 + off];
            }
            k.length = off + k.length < this.isize ? ++k.length : this.isize - off;
        } else {
            byte _rep = this.hcb == null ? hcbNullRep : this.hcb.headRep;
            k.length = Convert.unpackL(this.buf, off, _rep);
            short lext = Convert.unpackI(this.buf, off + 4, _rep);
            k.ltag = this.buf[off + 6];
            k.type = this.buf[off + 7];
            k.ldat = k.length - lext;
            if (k.length < 8 || lext > k.length || k.ltag >= k.length || k.ldat >= k.length) {
                int count = 0;
                StringBuilder details = new StringBuilder(88);
                if (k.length < 8) {
                    details.append((count = (int)((byte)(count + 1))) > 1 ? "," : "").append(" lkey < ").append(8);
                }
                if (lext > k.length) {
                    details.append((count = (int)((byte)(count + 1))) > 1 ? "," : "").append(" lext > lkey");
                }
                if (lext < 0) {
                    details.append((count = (int)((byte)(count + 1))) > 1 ? "," : "").append(" lext is negative");
                }
                if (k.ltag >= k.length) {
                    details.append((count = (int)((byte)(count + 1))) > 1 ? "," : "").append(" ltag >= lkey");
                }
                if (k.ldat >= k.length) {
                    details.append((count = (int)((byte)(count + 1))) > 1 ? "," : "").append(" ldat >= lkey");
                }
                if (k.ldat < 0) {
                    details.append((count = (int)((byte)(count + 1))) > 1 ? "," : "").append(" ldat is negative");
                }
                details.append(' ');
                this.handleBadKeywordBlock(k, "unpack", details);
                return details.toString();
            }
        }
        return null;
    }

    public Key find(String name) {
        return this.find(name, 0);
    }

    public Key find(String name, int where) {
        Key k = new Key();
        byte[] bname = name.getBytes();
        int start = this.scope_start;
        int end = this.scope_end;
        if (where == 1) {
            start = -this.isize;
            end = 0;
        } else if (where == 2) {
            start = 0;
            end = this.size;
        }
        k.offset = start;
        while (k.offset < end) {
            String invalidDetails = this.unpack(k);
            if (invalidDetails != null) {
                if (k.length < 8) break;
            } else {
                int len;
                int off;
                byte[] tmp;
                if (k.offset < 0) {
                    tmp = this.ibuf;
                    off = 164 + k.offset + this.isize;
                    len = k.ltag;
                } else {
                    tmp = this.buf;
                    off = k.offset + 8 + k.ldat;
                    len = k.ltag;
                }
                if (tmp[off + 1] == 58) {
                    off += 2;
                    len -= 2;
                }
                if (len == bname.length) {
                    int i;
                    for (i = 0; i < bname.length && bname[i] == tmp[off + i]; ++i) {
                    }
                    if (i == bname.length) {
                        return k;
                    }
                }
            }
            k.offset += k.length;
        }
        return null;
    }

    private boolean chk(int maxlen) {
        byte _rep = this.hcb == null ? Shell.rep : this.hcb.headRep;
        Key k = new Key();
        if (this.size > 8 && Convert.unpackL(this.buf, 4, _rep) < 200) {
            this.convertMartes();
        }
        int end = maxlen >= 0 ? Math.min(this.size, maxlen) : this.size;
        k.offset = 0;
        while (k.offset < end) {
            String invalidDetails = this.unpack(k);
            if (invalidDetails != null) {
                return false;
            }
            if (k.offset + k.length > this.size || k.offset + 8 + k.ldat + k.ltag > this.size) {
                this.handleBadKeywordBlock(k, "chk", "bad tag length and/or data length");
                return false;
            }
            int j = k.offset + 8 + k.ldat;
            for (int i = 0; i < k.ltag; ++i) {
                char c = (char)this.buf[j + i];
                if (c >= ' ' && c <= '~') continue;
                this.handleBadKeywordBlock(k, "chk", "bad char in tag name");
                return false;
            }
            k.offset += k.length;
        }
        return true;
    }

    private void convertMartes() {
        byte _rep = this.hcb == null ? Shell.rep : this.hcb.headRep;
        byte[] tmp = new byte[256];
        Key k = new Key();
        k.offset = 0;
        int off = 0;
        while (off < this.size) {
            int next = Convert.unpackL(this.buf, off + 0, _rep);
            int ltag = Convert.unpackL(this.buf, off + 4, _rep);
            int ldat = Convert.unpackL(this.buf, off + 8, _rep);
            int idat = 12 + (ltag + 3) & 0xFC;
            int type = this.buf[off + 13] == 58 ? this.buf[off + 12] : 65;
            System.arraycopy(this.buf, off + 12, tmp, 0, ltag);
            k.length = 8 + ldat + ltag + 7 & 0xFFFFFFF8;
            Convert.packL(this.buf, k.offset + 0, k.length);
            Convert.packI(this.buf, k.offset + 4, (short)(k.length - ldat));
            if (_rep != Shell.rep) {
                Convert.rep(this.buf, k.offset + 0, (byte)76, 1, Shell.rep, _rep);
                Convert.rep(this.buf, k.offset + 4, (byte)73, 1, Shell.rep, _rep);
            }
            this.buf[k.offset + 6] = (byte)ltag;
            this.buf[k.offset + 7] = type;
            System.arraycopy(this.buf, off + 12 + (ltag + 3 & 0xFC), this.buf, k.offset + 8, ldat);
            System.arraycopy(tmp, 0, this.buf, k.offset + 8 + ldat, ltag);
            k.offset += k.length;
            off = next;
        }
        this.size = k.offset;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only used internal to Keywords and XBC")
    public void extractName(Key k) {
        if (k.ltag < 0) {
            this.handleBadKeywordBlock(k, "extractName", "negative ltag");
            return;
        }
        k.name = k.offset < 0 ? new String(this.ibuf, 164 + k.offset + this.isize, k.ltag) : new String(this.buf, k.offset + 8 + k.ldat, k.ltag);
        if (k.ltag > 1 && k.name.charAt(1) == ':') {
            k.name = k.name.substring(2);
        }
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only used internal to Keywords and XBC")
    public void extractData(Key k) {
        byte _rep = this.hcb == null ? Shell.rep : this.hcb.headRep;
        int offset = k.offset + 8;
        if (k.offset < 0) {
            k.value = new String(this.ibuf, 164 + k.offset + this.isize + k.ltag + 1, k.ldat);
        } else if (Data.isString(k.type)) {
            k.value = new String(this.buf, offset, k.ldat);
        } else {
            byte[] buffer = new byte[k.ldat];
            System.arraycopy(this.buf, offset, buffer, 0, k.ldat);
            if (_rep != Shell.rep && k.type != 66) {
                Convert.rep(buffer, 0, k.type, k.ldat / Data.getBPS(k.type), _rep, Shell.rep);
            }
            k.value = new Data(buffer, 0, k.ldat, (int)k.type);
        }
    }

    public final Collection<Map.Entry<String, Object>> getAll() {
        return this.getAll("ALL", false);
    }

    public final Collection<Map.Entry<String, Object>> getAll(String scope, boolean sort2) {
        if (scope.startsWith("EXT")) {
            scope = "EXT";
        }
        Iterator iter = this.iterator(scope);
        boolean err = false;
        ArrayList<Map.Entry<String, Object>> keys = new ArrayList<Map.Entry<String, Object>>();
        try {
            while (iter.hasNext()) {
                Key k = iter.next();
                keys.add(new AbstractMap.SimpleEntry<String, Object>(k.name, k.value));
            }
        }
        catch (RuntimeException e) {
            if ((this.flags & 1) == 0) {
                throw e;
            }
            err = true;
        }
        if (sort2) {
            Collections.sort(keys, StringUtil.KEY_COMPARATOR);
        }
        if (err) {
            keys.add(new AbstractMap.SimpleEntry<String, String>("<error>", "<corrupted keyword block>"));
        }
        return keys;
    }

    public Object get(String name) {
        Key k = this.find(name);
        if (k == null) {
            return null;
        }
        this.extractData(k);
        return k.value;
    }

    public int getL(String name, int def) {
        Object value = this.get(name);
        if (value == null) {
            return def;
        }
        return Convert.o2l(value);
    }

    public double getD(String name, double def) {
        Object value = this.get(name);
        if (value == null) {
            return def;
        }
        return Convert.o2d(value);
    }

    public final Integer getUnitsFor(String name) {
        return this.getUnitsFor(name, null, 256);
    }

    public final Integer getUnitsFor(String name, Integer def) {
        return this.getUnitsFor(name, def, 256);
    }

    public Integer getUnitsFor(String name, Integer def, int flags) {
        int _unit;
        Object units = this.get(name + ".UNITS");
        Object unit = this.get(name + ".UNIT");
        if (unit == null && units == null) {
            return def;
        }
        if (unit == null && units != null) {
            return Convert.o2l(units);
        }
        if (unit != null && units == null) {
            return Convert.o2l(unit);
        }
        int _units = Convert.o2l(units);
        if (_units == (_unit = Convert.o2l(unit))) {
            return _units;
        }
        if ((flags & 0x100) != 0) {
            this.warn("Found keyword mismatch " + name + ".UNIT=" + _unit + " and " + name + ".UNITS=" + _units + " using " + name + ".UNITS=" + _units);
        }
        return (flags & 0x400) != 0 ? _unit : _units;
    }

    public Integer getL(String name, Integer def) {
        Object value = this.get(name);
        if (value == null) {
            return def;
        }
        return Convert.o2l(value);
    }

    public Double getD(String name, Double def) {
        Object value = this.get(name);
        if (value == null) {
            return def;
        }
        return Convert.o2d(value);
    }

    public String getS(String name, String def) {
        Object value = this.get(name);
        if (value == null) {
            return def;
        }
        return Convert.o2s(value);
    }

    public void add(String name, Object obj) {
        this.set(name, obj, 1);
    }

    public final void addWithUnits(String name, Object value, Object units) {
        this.addWithUnits(name, value, units, 0);
    }

    public final void addWithUnits(String name, Object value, Object units, int flags) {
        this.setWithUnits(name, value, units, flags | 1);
    }

    public void addAll(Map<String, Object> map) {
        this.setAll(map, 1);
    }

    public void put(String name, Object obj) {
        this.set(name, obj, 2);
    }

    public final void putWithUnits(String name, Object value, Object units) {
        this.putWithUnits(name, value, units, 2048);
    }

    public final void putWithUnits(String name, Object value, Object units, int flags) {
        this.setWithUnits(name, value, units, flags | 2);
    }

    public void putAll(Map<String, Object> map) {
        this.setAll(map, 2);
    }

    public void putAll(Collection<Map.Entry<String, Object>> entries) {
        this.setAll(entries, 2);
    }

    public void setAll(Map<String, Object> map, int flags) {
        if (map == null) {
            return;
        }
        this.setAll(map.entrySet(), flags);
    }

    public void setAll(Collection<Map.Entry<String, Object>> entries, int flags) {
        if (entries == null) {
            return;
        }
        for (Map.Entry<String, Object> e : entries) {
            this.set(e.getKey(), e.getValue(), flags);
        }
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.0")
    private void setWithUnits(String name, Object value, Object units, int flags) {
        boolean preferUnit;
        String kwdName = name.length() > 2 && name.charAt(1) == ':' ? name.substring(2) : name;
        boolean bl = preferUnit = (flags & 0x400) != 0;
        if ((flags & 3) == 0) {
            flags &= 2;
        } else if ((flags & 3) == 3) {
            throw new MidasException("ADD and REPLACE flags are mutually exclusive, but both were given");
        }
        if ((flags & 2) != 0) {
            Key oldUnits = this.find(kwdName + ".UNITS");
            Key oldUnit = this.find(kwdName + ".UNIT");
            if ((flags & 0x800) != 0) {
                if (oldUnits != null && oldUnit == null) {
                    preferUnit = false;
                }
                if (oldUnits == null && oldUnit != null) {
                    preferUnit = true;
                }
            }
            if (oldUnits != null && preferUnit) {
                this.delete(oldUnits);
            }
            if (oldUnit != null && !preferUnit) {
                this.delete(oldUnit);
            }
        }
        if (preferUnit) {
            this.set(name, value, flags & 3);
            this.set("B:" + kwdName + ".UNIT", DataFile.getUnitsID(units), flags & 3);
        } else {
            this.set(name, value, flags & 3);
            this.set("B:" + kwdName + ".UNITS", DataFile.getUnitsID(units), flags & 3);
        }
    }

    public void set(String name, Object obj, int flags) {
        char type = '_';
        if (name.length() == 0) {
            return;
        }
        if (name.length() > 2 && name.charAt(1) == ':') {
            type = name.charAt(0);
            name = name.substring(2);
            obj = Convert.o2o(obj, type, null);
        } else if (!(obj instanceof Data || obj instanceof String || obj instanceof Table)) {
            obj = Convert.o2o(obj, type, null);
        }
        if (name.contains(Keywords.getDotSubstitute())) {
            name = name.replace(Keywords.getDotSubstitute(), ".");
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            if (data.isString()) {
                String string = "" + obj;
                this.set(name, data.type, string.getBytes(), string.length(), flags);
            } else {
                this.set(name, data.type, data.buf, data.size * data.bpe, flags);
            }
        } else if (obj instanceof String) {
            String string = (String)obj;
            this.set(name, (byte)65, string.getBytes(), string.length(), flags);
        } else if (obj instanceof Table) {
            byte[] bbuf = ((Table)obj).toBytes();
            this.set(name, (byte)65, bbuf, bbuf.length, flags);
        } else {
            throw new MidasException("Illegal Keyword Data type: " + obj);
        }
    }

    public void set(String name, byte type, byte[] data, int len, int flags) {
        String value;
        byte _rep = this.hcb == null ? Shell.rep : this.hcb.headRep;
        int off = this.scope_end;
        int olength = 0;
        int ltag = name.length();
        int length = (len + ltag + 15) / 8 * 8;
        short lext = (short)(length - len);
        if (type == 83) {
            type = (byte)65;
        }
        boolean replacingEXT = false;
        boolean replacingMAIN = false;
        Key k = null;
        if ((flags & 2) != 0 && (k = this.find(name, 0)) != null) {
            replacingMAIN = k.offset < 0;
            boolean bl = replacingEXT = !replacingMAIN;
        }
        if (replacingEXT) {
            off = k.offset;
            olength = k.length;
        } else if ((replacingMAIN || !this.scope.equals("EXT") && Keywords.isReqMain(name)) && (value = this.convertDataToString(name, type, data, len)) != null) {
            this.putMain(name, value);
            return;
        }
        if (this.buf == null) {
            this.buf = new byte[2048];
        }
        if (this.size + length - olength > this.buf.length) {
            byte[] bufo = this.buf;
            this.buf = new byte[(this.size + length + 2048) / 2048 * 2048];
            System.arraycopy(bufo, 0, this.buf, 0, this.size);
        }
        if (length != olength && off < this.size) {
            System.arraycopy(this.buf, off + olength, this.buf, off + length, this.size - (off + olength));
        }
        Convert.packL(this.buf, off + 0, length);
        Convert.packI(this.buf, off + 4, lext);
        this.buf[off + 6] = ltag;
        this.buf[off + 7] = type;
        if (_rep != Shell.rep) {
            if (!Data.isString(type) && type != 66) {
                int nelems = len / Data.getBPS(type);
                Convert.rep(data, 0, type, nelems, Shell.rep, _rep);
            }
            Convert.rep(this.buf, off, (byte)76, 1, Shell.rep, _rep);
            Convert.rep(this.buf, off + 4, (byte)73, 1, Shell.rep, _rep);
        }
        System.arraycopy(data, 0, this.buf, off + 8, len);
        int i = 0;
        int j = off + 8 + len;
        while (i < ltag) {
            this.buf[j++] = (byte)name.charAt(i++);
        }
        this.scope_end += length - olength;
        this.size += length - olength;
    }

    private String convertDataToString(String name, byte type, byte[] data, int len) {
        String value = null;
        if (Data.isString(type)) {
            value = new String(data, 0, len);
        } else if (type != 72) {
            if ("TC_PREC".equals(name) && Data.isFloat(type)) {
                Data thisValue = new Data(data);
                value = "" + thisValue.getD(0);
            } else if ("PKT_BYTE_COUNT".equals(name) && !Data.isFloat(type)) {
                Data thisValue = new Data(data);
                value = "" + thisValue.getL(0);
            }
        }
        return value;
    }

    public int delete(String name) {
        if (name.equals("TIMELINE") && this.hcb != null) {
            this.hcb.setTimeLineHandler(null);
        }
        return this.delete(this.find(name));
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.0")
    private int delete(Key k) {
        if (k == null) {
            return 0;
        }
        if (k.offset < 0) {
            return this.deleteMain(k.name);
        }
        this.size -= k.length;
        System.arraycopy(this.buf, k.offset + k.length, this.buf, k.offset, this.size - k.offset);
        if (this.scope_start > k.offset) {
            this.scope_start -= k.length;
        }
        if (this.scope_end > k.offset) {
            this.scope_end -= k.length;
        }
        return this.size;
    }

    public boolean deleteScope(String scope) {
        int i = this.setScope(scope);
        if (i > 0) {
            if (this.buf == null) {
                Shell.info("No " + scope + " keywords deleted in header as keyword buffer is null");
                return true;
            }
            int len = this.size - this.scope_end;
            System.arraycopy(this.buf, this.scope_start, this.buf, this.scope_end, len);
            this.size = len;
        }
        this.clearScope();
        return true;
    }

    public boolean deleteVolatileKeywords() {
        boolean deleted = false;
        Iterator kwi = this.iterator();
        LinkedList<Key> volatileKeys = new LinkedList<Key>();
        while (kwi.hasNext()) {
            Key key = kwi.next();
            if (!key.name.startsWith("VOLATILE_KW_")) continue;
            this.delete(key);
            volatileKeys.add(key);
            deleted = true;
        }
        return deleted;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only used internal to Keywords and DataFile")
    public void putMain(String name, String value, boolean warn) {
        if (name == null || name.length() <= 0) {
            return;
        }
        if (name.length() > 2 && name.charAt(1) == ':') {
            name = name.substring(2);
        }
        if (!Keywords.isOkMain(name) && warn) {
            this.warn(name + "=" + value + " should only be set in the EXTENDED header");
        }
        if (this.isize < 0) {
            this.initFromDataFile();
        }
        this.deleteMain(name);
        String knv = name + "=" + value + '\u0000';
        int off = this.isize;
        int len = knv.length();
        if (off + len > 92 && Keywords.isReqMain(name)) {
            Table main = this.makeTable(true, 1);
            String[] keys = main.getKeys();
            for (int i = keys.length - 1; i >= 0 && off + len > 92; --i) {
                if (Keywords.isReqMain(keys[i])) continue;
                if (warn) {
                    this.warn("No room in MAIN header for " + name + "='" + value + "', deleting " + keys[i] + "='" + main.getS(keys[i]) + "' to make room");
                }
                this.deleteMain(keys[i]);
                off = this.isize;
            }
        }
        if (off + len > 92) {
            if (warn) {
                this.warn("No room in MAIN header keywords for entry: " + name + "='" + value + "'");
            }
            return;
        }
        System.arraycopy(knv.getBytes(), 0, this.ibuf, 164 + off, len);
        this.isize += len;
        this.hcb.setKeyLength(this.isize);
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only used internal to Keywords and DataFile")
    public void putMain(String name, String value) {
        this.putMain(name, value, true);
    }

    private static boolean isReqMain(String name) {
        return Arrays.binarySearch(MAIN_HEADER_KEYWORDS, name) >= 0;
    }

    private static boolean isOkMain(String name) {
        return Keywords.isReqMain(name) || Arrays.binarySearch(MAIN_HEADER_IGNORE, name) >= 0;
    }

    private void handleBadKeywordBlock(Key key, String fromMethod, CharSequence moreDetails) throws MidasException {
        if ((this.flags & 1) == 0) {
            throw new MidasException(fromMethod + " found invalid keyword block (" + moreDetails + ") " + key.headerInfo());
        }
        if (!this.warnedForInvalidBlockSet.contains(fromMethod)) {
            this.warnedForInvalidBlockSet.add(fromMethod);
            this.warn(fromMethod + " invalid block (" + moreDetails + ") " + key.headerInfo());
        }
    }

    private void warn(String msg) {
        String wmsg = "Keywords: " + msg + " file='" + this.hcb + "'.";
        if (this.hcb != null && this.hcb.M != null) {
            this.hcb.M.warning(wmsg);
        } else {
            Shell.warning(wmsg);
        }
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only used internal to Keywords and DataFile")
    public String getMain(String name) {
        Key k;
        if (this.isize < 0) {
            this.initFromDataFile();
        }
        if (this.isize <= 0 || name == null || name.length() == 0) {
            return null;
        }
        if (name.length() > 2 && name.charAt(1) == ':') {
            name = name.substring(2);
        }
        if ((k = this.find(name, 1)) == null) {
            return null;
        }
        this.extractData(k);
        return (String)k.value;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only used internal to Keywords and DataFile")
    public int deleteMain(String name) {
        Key k;
        if (this.isize < 0) {
            this.initFromDataFile();
        }
        if (this.isize <= 0 || name == null || name.length() == 0) {
            return 0;
        }
        if (name.length() > 2 && name.charAt(1) == ':') {
            name = name.substring(2);
        }
        if ((k = this.find(name, 1)) == null) {
            return 0;
        }
        int off = k.offset + this.isize;
        int len = k.ltag + 1 + k.ldat + 1;
        if (off + len < this.isize) {
            System.arraycopy(this.ibuf, 164 + off + len, this.ibuf, 164 + off, this.isize - off - len);
        }
        this.isize -= len;
        this.hcb.setKeyLength(this.isize);
        return len;
    }

    private String list(Key key) {
        String sep;
        String string = sep = key.offset < 0 ? "=" : "==";
        if (key.value instanceof String) {
            return "S:" + key.name + sep + key.value;
        }
        if (key.value instanceof Data) {
            Data data = (Data)key.value;
            return (char)data.type + ":" + key.name + sep + key.value;
        }
        return "?:" + key.name + "=unknown (invalid keyword block at offset=" + key.offset + RPAREN_S;
    }

    @InternalUseOnly(value="Since created")
    public static CharSequence list(Map.Entry<String, Object> kwd, String scope, int pad, int flags) {
        StringBuilder str = new StringBuilder(512);
        String sep = scope.equals("MAIN") ? "= " : "==";
        String key = kwd.getKey();
        Object val = kwd.getValue();
        if (val instanceof String) {
            str.append('S');
        } else if (val instanceof Data) {
            str.append(((Data)val).getFormatTypeChar());
        } else {
            str.append('?');
        }
        str.append(':');
        str.append(key);
        if (pad > 0) {
            while (str.length() < pad) {
                str.append(' ');
            }
            str.append(' ').append(sep).append(' ');
        } else {
            str.append(sep);
        }
        str.append(val);
        if ((flags & 0x200) != 0 && (key.endsWith(".UNIT") || key.endsWith(".UNITS"))) {
            try {
                String units = DataFile.getUnitsVarName(Convert.o2i(val));
                str.append("\t(").append(units).append(')');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only intended for use by the KEYWORDS command")
    public void dump(TextFile tf) {
        Iterator kwi = this.iterator();
        while (kwi.getNext()) {
            tf.writeln(kwi.list());
        }
    }

    public Table makeTable() {
        return this.makeTable(true);
    }

    public Table makeTable(boolean flat) {
        return this.makeTable(flat, 0);
    }

    private Table makeTable(boolean flat, int scope) {
        Table tb = new Table(2, 4);
        Table mainTab = null;
        Table extendTab = null;
        if (!flat) {
            mainTab = new Table(2, 4);
            tb.put("MAIN", (Object)mainTab);
            extendTab = new Table(2, 4);
            tb.put("EXTENDED", (Object)extendTab);
        }
        Iterator kwi = this.iterator(scope);
        while (kwi.getNext()) {
            if (flat) {
                kwi.name = kwi.getName(true);
                tb.putx(kwi.name, kwi.value);
                continue;
            }
            if (((Iterator)kwi).curentKey.offset < 0) {
                mainTab.put(kwi.name, kwi.value);
                continue;
            }
            kwi.name = kwi.getName(true);
            extendTab.put(kwi.name, kwi.value);
        }
        return tb;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only intended for use by the KEYWORDS command")
    public void load(TextFile tf) {
        String text;
        while ((text = tf.readProper()) != null) {
            int ie;
            int off = 0;
            int len = text.length();
            char type = '_';
            if (text.charAt(1) == ':') {
                type = text.charAt(0);
                if (Data.isString((byte)type)) {
                    type = 'S';
                }
                off = 2;
            }
            if ((ie = text.indexOf(61)) < 0) {
                throw new MidasException("Invalid entry " + text + " found in " + tf.getName());
            }
            String name = text.substring(off, ie);
            if (ie + 1 < len && text.charAt(ie + 1) == '=') {
                text = text.substring(ie + 2);
                if (type == 'S') {
                    this.add(name, text);
                    continue;
                }
                this.add(name, Convert.s2o(text, type, null));
                continue;
            }
            text = text.substring(ie + 1);
            this.putMain(name, text);
        }
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - this is only intended for use by the KEYWORDS command")
    public void loadExt(TextFile tf) {
        String text;
        while ((text = tf.readProper()) != null) {
            int ie;
            int off = 0;
            int len = text.length();
            char type = '_';
            if (text.charAt(1) == ':') {
                type = text.charAt(0);
                if (Data.isString((byte)type)) {
                    type = 'S';
                }
                off = 2;
            }
            if ((ie = text.indexOf(61)) < 0) {
                throw new MidasException("Invalid entry " + text + " found in " + tf.getName());
            }
            String name = text.substring(off, ie);
            if (++ie < len && text.charAt(ie) == '=') {
                ++ie;
            }
            text = ie >= len ? "" : text.substring(ie);
            if (type == 'S') {
                this.add(name, text);
                continue;
            }
            this.add(name, Convert.s2o(text, type, null));
        }
    }

    private void convertRep(byte from, byte to) {
        this.convertExtRep(from, to);
        this.rep = to;
    }

    void convertExtRep(byte from, byte to) {
        Key k = new Key();
        k.offset = 0;
        while (k.offset < this.size) {
            String invalidDetails = this.unpack(k, from);
            if (invalidDetails != null) {
                if (k.length < 8) break;
            } else {
                int off = k.offset;
                Convert.rep(this.buf, off, (byte)76, 1, from, to);
                Convert.rep(this.buf, off + 4, (byte)73, 1, from, to);
                if (!Data.isString(k.type) && k.type != 66) {
                    Convert.rep(this.buf, off + 8, k.type, k.ldat / Data.getBPS(k.type), from, to);
                }
            }
            k.offset += k.length;
        }
    }

    @InternalUseOnly
    static Keywords convertedCopyOfKeywords(Keywords kwSrc, byte srcRep, byte newRep) {
        Keywords kw = new Keywords();
        if (kwSrc.size > 0) {
            kw.size = kwSrc.size;
            kw.buf = new byte[kwSrc.buf.length];
            System.arraycopy(kwSrc.buf, 0, kw.buf, 0, kwSrc.size);
            if (srcRep != newRep) {
                kw.convertExtRep(srcRep, newRep);
            }
        }
        return kw;
    }

    @Override
    public String[] getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator kwi = this.iterator();
        while (kwi.getNext()) {
            keys.add(kwi.name);
        }
        return keys.toArray(new String[keys.size()]);
    }

    public String[] getKeys(String scope) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator kwi = this.iterator(scope);
        while (kwi.getNext()) {
            keys.add(kwi.name);
        }
        return keys.toArray(new String[keys.size()]);
    }

    @InternalUseOnly
    public String[] getKeys(String scope, String keyPrefix) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator kwi = this.iterator(scope);
        while (kwi.getNext()) {
            if (!kwi.name.startsWith(keyPrefix)) continue;
            keys.add(kwi.name);
        }
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("SCOPE")) {
            this.setScope((String)value);
        } else {
            this.put(name, value);
        }
        return value;
    }

    @Override
    public Object getKey(String name) {
        if (name.equals("SCOPE")) {
            return this.scope;
        }
        return this.get(name);
    }

    public String toString() {
        StringBuilder keywordsString = new StringBuilder(512);
        Iterator kwi = this.iterator();
        while (kwi.getNext()) {
            if (kwi.value instanceof String) {
                keywordsString.append("S:");
            } else if (kwi.value instanceof Data) {
                Data data = (Data)kwi.value;
                keywordsString.append((char)data.type).append(":");
            }
            keywordsString.append(kwi.name).append("=").append(kwi.value).append("\n");
        }
        return keywordsString.toString();
    }

    public Iterator iterator() {
        return this.iterator(0);
    }

    public Iterator iterator(String scope) {
        int i = this.setScope(scope);
        return i <= 0 ? null : this.iterator(0);
    }

    private Iterator iterator(int scope) {
        int start = 0;
        int end = 0;
        if (scope == 0) {
            start = this.scope_start;
            end = this.scope_end;
        }
        if ((scope & 1) != 0) {
            start = Math.min(start, -this.isize);
            end = Math.max(end, 0);
        }
        if ((scope & 2) != 0) {
            start = Math.min(start, 0);
            end = Math.max(end, this.size);
        }
        return new Iterator(this, start, end);
    }

    public static String getDotSubstitute() {
        return dotSubstitute;
    }

    public static void setDotSubstitute(String dotSubstitute) {
        if (dotSubstitute == null) {
            return;
        }
        Keywords.dotSubstitute = dotSubstitute;
    }

    public static class Iterator
    implements java.util.Iterator<Key> {
        public Keywords kw;
        public String name;
        public Object value;
        private int end;
        private int atBlock = 0;
        private Key curentKey = new Key();

        public Iterator(Keywords kw) {
            this(kw, kw.scope_start, kw.scope_end);
        }

        Iterator(Keywords kw, int start, int end) {
            this.kw = kw;
            this.end = end;
            this.curentKey.offset = start;
            this.curentKey.length = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.atBlock > 0 && this.curentKey.length < 1) {
                return false;
            }
            return this.curentKey.offset + this.curentKey.length < this.end;
        }

        @Override
        public Key next() {
            this.curentKey.offset += this.curentKey.length;
            if (this.curentKey.offset >= this.end) {
                return null;
            }
            String invalidDetails = this.kw.unpack(this.curentKey);
            ++this.atBlock;
            if (invalidDetails != null) {
                this.curentKey.name = null;
                this.curentKey.value = null;
                if (this.curentKey.length < 8) {
                    return null;
                }
            }
            this.kw.extractName(this.curentKey);
            this.kw.extractData(this.curentKey);
            return this.curentKey;
        }

        @Override
        public void remove() {
            this.kw.delete(this.name);
        }

        public boolean getNext() {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
            this.name = this.curentKey.name;
            this.value = this.curentKey.value;
            return true;
        }

        public String getName(boolean modify) {
            if (modify) {
                return this.name.replace(".", Keywords.getDotSubstitute());
            }
            return this.name;
        }

        public String list() {
            return this.kw.list(this.curentKey);
        }
    }

    public static class Key {
        byte type;
        int offset;
        int length;
        int ltag;
        int ldat;
        public String name;
        public Object value;

        public char getType() {
            return (char)this.type;
        }

        public String toString() {
            String t = this.type >= 65 && this.type <= 90 ? Character.toString((char)this.type) : "n/a";
            return "Key: type=" + t + " offset=" + this.offset + " length=" + this.length + " ltag=" + this.ltag + " ldat=" + this.ldat + " name=" + this.name + " value=" + this.value;
        }

        private String headerInfo() {
            String t = this.type >= 65 && this.type <= 90 ? Character.toString((char)this.type) : "n/a";
            return "Key: lkey=" + this.length + " lext=" + (this.length - this.ldat) + " ltag=" + this.ltag + " type=" + t + " offset=" + this.offset + " ldat=" + this.ldat;
        }
    }
}

