/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.Indexable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyObjectNames;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.XMValue;

public class KeyObject
implements DataTypes {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<String> INIT_ONLY = Collections.singleton("<init>");
    private static final String[] COMMON_PACKAGES = new String[]{"java.lang.", "java.util.", "nxm.sys.inc.", "nxm.sys.lib.", "nxm.sys.libg."};
    private static final boolean BE_ANNOYING = false;
    private static final boolean DEBUG_FINDER = false;
    private static final boolean EXTRA_DEBUG = false;
    private static final boolean DEBUG_GETKEY = false;
    private static final boolean WARN_AMBIGUOUS = false;
    private static final Map<Class<?>, Set<MacroAccessibleObject>> allMAOsByClass = new ConcurrentHashMap(128);
    public static final int SOFT = 1;
    public static final int RESOLVE = 2;
    private static final int WARN = 4;
    public static final int SOFTWARN = 5;
    public static final int KEY_EXACT = 0;
    public static final int KEY_CAPS = 1;
    public static final int KEY_ABBR = 2;
    public static final int KEY_NONE = 3;
    public static final int ARG_EXACT = 0;
    public static final int ARG_NUM = 1;
    public static final int ARG_NUMO = 2;
    public static final int ARG_CVT = 3;
    public static final int ARG_NONE = 4;

    @Deprecated
    public KeyObject() {
    }

    public static Object getKey(Object root, String key) {
        return KeyObject.getKey(root, key, null, null);
    }

    public static Object getKey(Object root, String key, Object value, Object ref) {
        Object[] args;
        int kp;
        while ((kp = key.indexOf(46)) > 0) {
            int klp = key.indexOf(40);
            if (klp > 0 && klp < kp) {
                int ii;
                int lpcount = 1;
                int rpcount = 0;
                boolean doublequote = false;
                boolean singlequote = false;
                int klen = key.length();
                for (ii = klp + 1; ii < klen; ++ii) {
                    char ch = key.charAt(ii);
                    if (ch == ')' && !doublequote && !singlequote) {
                        if (ii + 1 != kp || ++rpcount != lpcount) continue;
                        break;
                    }
                    if (ch == '(' && !doublequote && !singlequote) {
                        ++lpcount;
                        continue;
                    }
                    if (ch == '\"') {
                        doublequote = !doublequote;
                        continue;
                    }
                    if (ch != '\'') continue;
                    singlequote = !singlequote;
                }
                if (rpcount > lpcount) {
                    throw new MidasException("Extra right-parenthesis. key=" + key);
                }
                if (rpcount == lpcount) {
                    if (ii == klen) {
                        break;
                    }
                } else {
                    throw new MidasException("Unbalanced parenthesis. key=" + key);
                }
            }
            String subKey = key.substring(0, kp);
            root = KeyObject.getKey(root, subKey, null, ref);
            key = key.substring(kp + 1);
        }
        if (root == null) {
            return null;
        }
        int ip = key.indexOf(40);
        if (ip > 0) {
            args = KeyObject.parseArgs(key, ip, key.length(), value, ref);
            key = key.substring(0, ip);
        } else {
            args = value instanceof Object[] ? (Object[])value : null;
        }
        return KeyObject.findAndInvoke(" | ", root, key, args, SearchOrder.SOFT_GET, ref);
    }

    public static Object setKey(Object root, String key, Object value) {
        return KeyObject.setKey(root, key, value, null);
    }

    public static Object setKey(Object root, String key, Object value, Object ref) {
        Object[] args;
        int klp;
        int kp;
        while ((kp = key.indexOf(46)) > 0 && ((klp = key.indexOf(40)) <= 0 || klp >= kp)) {
            root = KeyObject.getKey(root, key.substring(0, kp), null, ref);
            key = key.substring(kp + 1);
        }
        if (root == null) {
            return null;
        }
        if (value == null) {
            return KeyObject.getKey(root, key, null, ref);
        }
        int ip = key.indexOf(40);
        if (ip > 0) {
            args = KeyObject.parseArgs(key, ip, key.length(), value, ref);
            key = key.substring(0, ip);
        } else {
            args = value instanceof Object[] ? (Object[])value : new Object[]{value};
        }
        value = KeyObject.findAndInvoke(" | ", root, key, args, SearchOrder.SET, ref);
        return value == null ? args[args.length - 1] : value;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This is only for internal use within SYS")
    public static Object getIndexed(Object root, int index) {
        try {
            if (root instanceof Indexable) {
                return ((Indexable)root).getIndex(index);
            }
            if (root instanceof List) {
                return ((List)root).get(index);
            }
            if (root != null && root.getClass().isArray()) {
                return Array.get(root, index);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("KeyObject.getIndexed(): Error in accessing element " + index + " from " + root + ": " + e);
        }
        throw new MidasException("Object is not indexable. index=" + index + " root=[" + root + "]");
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This is only for internal use within SYS")
    public static Object setIndexed(Object root, int index, Object value) {
        try {
            if (root instanceof Indexable) {
                ((Indexable)root).setIndex(index, value);
                return value;
            }
            if (root instanceof List) {
                ((List)root).set(index, value);
                return value;
            }
            if (root != null && root.getClass().isArray()) {
                Array.set(root, index, value);
                return value;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("KeyObject.setIndexed(): Error in setting element " + index + " in " + root + " to " + value + ": " + e);
        }
        throw new MidasException("Object is not indexable. index=" + index + " value=" + value + " root=[" + root + "]");
    }

    private static boolean isIndexable(Object obj) {
        return obj instanceof Indexable || obj instanceof List || obj != null && obj.getClass().isArray();
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This is only for internal use within SYS")
    public static int getKeyIndex(String key) {
        return KeyObject.getKeyIndex(key, null);
    }

    private static int getKeyIndex(String key, Object obj) {
        if (obj != null && !KeyObject.isIndexable(obj)) {
            return -1;
        }
        if (StringUtil.isNumber(key)) {
            return Convert.o2l(key);
        }
        switch (key) {
            case "X": {
                return 0;
            }
            case "Y": {
                return 1;
            }
            case "Z": {
                return 2;
            }
            case "T": {
                return 3;
            }
            case "R": {
                return 0;
            }
            case "I": {
                return 1;
            }
            case "ALT": {
                return 0;
            }
            case "LAT": {
                return 1;
            }
            case "LON": {
                return 2;
            }
        }
        return -1;
    }

    public static int setKeys(Object root, Table tab) {
        return KeyObject.setKeys(root, tab, null, 0);
    }

    public static int setKeys(Object root, Table tab, Object ref, int flags) {
        if (root == null || tab == null || tab.isEmpty()) {
            return -1;
        }
        if (tab.isEmpty()) {
            return 0;
        }
        int nkey = 0;
        Table.Iterator ti = tab.iterator();
        while (ti.getNext()) {
            Object xarg;
            String key;
            block12: {
                key = ti.key;
                xarg = ti.value;
                if (xarg instanceof Table) {
                    try {
                        KeyObject.setKey(root, key, xarg, ref);
                        ++nkey;
                    }
                    catch (MidasException ex) {
                        Object troot = null;
                        try {
                            troot = KeyObject.getKey(root, key);
                        }
                        catch (MidasException midasException) {
                            // empty catch block
                        }
                        if (troot == null) break block12;
                        KeyObject.setKeys(troot, (Table)xarg, ref, flags);
                    }
                    continue;
                }
            }
            if (xarg instanceof String) {
                xarg = Convert.s2o((String)xarg, '_', ref);
            }
            if ((flags & 1) == 0) {
                KeyObject.setKey(root, key, xarg, ref);
                ++nkey;
                continue;
            }
            try {
                KeyObject.setKey(root, key, xarg, ref);
                ++nkey;
            }
            catch (MidasException e) {
                if ((flags & 4) == 0) continue;
                KeyObject.ref2Midas(ref).printStackTrace("KeyObject: Can not set " + key + "=" + xarg, e);
            }
        }
        return nkey;
    }

    private static Midas ref2Midas(Object ref) {
        Midas midas = Convert.ref2Midas(ref);
        return midas != null ? midas : Shell.getSharedMidasContext();
    }

    private static Object[] parseArgs(String argstr, int i1, int i2, Object xarg, Object ref) {
        int i;
        int nargs = 0;
        int quotes = 0;
        --i2;
        for (i = ++i1; i < i2; ++i) {
            if (argstr.charAt(i) == '\"') {
                quotes = 1 - quotes;
            }
            if (quotes != 0) continue;
            if ((i = argstr.indexOf(44, i)) < 0) {
                i = i2;
            }
            ++nargs;
        }
        if (xarg != null) {
            ++nargs;
        }
        Object[] args = new Object[nargs];
        int iQuoteStart = -1;
        nargs = 0;
        while (i1 < i2) {
            int iQuote = argstr.charAt(i1) == '\"' ? i1 : -1;
            if (iQuote >= 0 && iQuoteStart < 0) {
                iQuoteStart = iQuote;
            }
            if (iQuoteStart < 0) {
                i = argstr.indexOf(44, i1);
                if (i < 0) {
                    i = i2;
                }
                args[nargs++] = Convert.s2o(argstr.substring(i1, i), '_', ref);
            } else {
                i = argstr.indexOf(34, iQuoteStart + 1);
                i = i < 0 ? i2 : ++i;
                args[nargs++] = Convert.s2o(argstr.substring(iQuoteStart, i), '_', ref);
                iQuoteStart = -1;
            }
            i1 = i + 1;
        }
        if (xarg != null) {
            args[nargs++] = xarg;
        }
        return args;
    }

    @Deprecated
    public static Object invokeStaticMethod(String className, String methodName, Object[] args) {
        try {
            Method[] methods;
            Class<?> clas = Class.forName(className);
            for (Method method : methods = clas.getMethods()) {
                Class<?>[] params;
                String name = method.getName();
                if (!name.equals(methodName) || (params = method.getParameterTypes()).length != args.length) continue;
                boolean okArgs = true;
                for (int j = 0; okArgs && j < params.length; ++j) {
                    String pname = params[j].getName();
                    Class<?> aclass = args[j].getClass();
                    String aname = aclass.getName();
                    if (aname.equals(pname)) continue;
                    okArgs = false;
                    for (Class<?> sclass = aclass.getSuperclass(); !okArgs && sclass != null; sclass = sclass.getSuperclass()) {
                        okArgs = sclass.getName().equals(pname);
                    }
                    if (okArgs) continue;
                    Class<?>[] classes = aclass.getInterfaces();
                    for (int k = 0; classes != null && k < classes.length && !okArgs; ++k) {
                        okArgs = classes[k].getName().equals(pname);
                    }
                }
                if (!okArgs) continue;
                return method.invoke(null, args);
            }
        }
        catch (Exception e) {
            throw new MidasException("invokeStaticMethod: " + e);
        }
        throw new MidasException("No match to " + className + "." + methodName + " with " + Arrays.toString(args));
    }

    @Deprecated
    public static Object invokeInstanceMethod(Object obj, String methName, Object[] args) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        int nargs = args != null ? args.length : 0;
        Class[] argTypes = new Class[nargs];
        for (int i = 0; i < nargs; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method meth = obj.getClass().getMethod(methName, argTypes);
        return meth.invoke(obj, args);
    }

    private static boolean isMatchingType(Class<?> givenType, Class<?> sampleType, boolean allowBoxing, boolean allowConversion, boolean allowMidasConv) {
        boolean match = givenType.isAssignableFrom(sampleType);
        if (!match && allowBoxing && (givenType.isPrimitive() || sampleType.isPrimitive())) {
            match = KeyObject.isMatchingType(KeyObject.getBoxedType(givenType), KeyObject.getBoxedType(sampleType), false, allowConversion, allowMidasConv);
        }
        if (!match && allowConversion) {
            if (Number.class.isAssignableFrom(givenType)) {
                boolean bl = match = Number.class.isAssignableFrom(sampleType) || sampleType.equals(Character.class);
            }
            if (givenType.equals(Character.class)) {
                boolean bl = match = match || Number.class.isAssignableFrom(sampleType);
            }
        }
        if (!match && allowMidasConv) {
            boolean bl = match = givenType.equals(String.class) || givenType.equals(Data.class);
            if (sampleType.equals(String.class)) {
                boolean bl2 = match = match || Number.class.isAssignableFrom(givenType) || Boolean.class.isAssignableFrom(givenType) || Character.class.isAssignableFrom(givenType);
            }
            if (!sampleType.isPrimitive()) {
                match = match || givenType.equals(Table.class);
            }
        }
        return match;
    }

    private static Class<?> getClassOf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            int spa = data.getSPA();
            switch (data.getFormat().charAt(1)) {
                case 'A': {
                    return String.class;
                }
                case 'Z': {
                    return String.class;
                }
                case 'D': {
                    return spa == 1 ? Double.TYPE : new double[spa].getClass();
                }
                case 'F': {
                    return spa == 1 ? Float.TYPE : new float[spa].getClass();
                }
                case 'X': {
                    return spa == 1 ? Long.TYPE : new long[spa].getClass();
                }
                case 'L': {
                    return spa == 1 ? Integer.TYPE : new int[spa].getClass();
                }
                case 'I': {
                    return spa == 1 ? Short.TYPE : new short[spa].getClass();
                }
                case 'B': {
                    return spa == 1 ? Byte.TYPE : new byte[spa].getClass();
                }
            }
        }
        return obj.getClass();
    }

    private static Class<?>[] getClassOf(Object[] objs) {
        Class[] classes = new Class[objs.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = KeyObject.getClassOf(objs[i]);
        }
        return classes;
    }

    private static Object[] convertParams(Class<?>[] types, Object[] params) {
        Object[] newParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            newParams[i] = KeyObject.convertParam(types[i], params[i]);
            if (newParams[i] != null || params[i] == null) continue;
            Shell.warning("KeyObject: Error converting " + params[i] + " to type " + types[i].getName() + ".");
        }
        return newParams;
    }

    private static Object convertParam(Class<?> type, Object param) {
        type = KeyObject.getBoxedType(type);
        if (param == null || type.isInstance(param)) {
            return param;
        }
        if (type.isArray() && param.getClass().isArray()) {
            Class<?> clazz;
            Object[] array = new Object[Array.getLength(param)];
            try {
                clazz = Class.forName(type.getName().substring(1));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("KeyObject: Unable to instantiate class " + type.getName().substring(1) + ": " + e);
            }
            for (int i = 0; i < Array.getLength(param); ++i) {
                array[i] = KeyObject.convertParam(clazz, Array.get(param, i));
            }
            return array;
        }
        if (Number.class.isAssignableFrom(type) && param instanceof Character) {
            char charVal = ((Character)param).charValue();
            return KeyObject.convertParam(type, charVal);
        }
        if (type == Double.class) {
            return Convert.o2d(param);
        }
        if (type == Float.class) {
            return Float.valueOf(Convert.o2f(param));
        }
        if (type == Long.class) {
            return Convert.o2x(param);
        }
        if (type == Integer.class) {
            return Convert.o2l(param);
        }
        if (type == Short.class) {
            return Convert.o2i(param);
        }
        if (type == Byte.class) {
            return Convert.o2b(param);
        }
        if (type == Character.class) {
            return Character.valueOf((char)Convert.o2l(param));
        }
        if (type == Boolean.class) {
            return StringUtil.isTrue("" + param);
        }
        if (type == String.class) {
            return Convert.o2s(param);
        }
        if (type == Data.class) {
            return new Data(param);
        }
        if (type == Table.class) {
            return Convert.o2t(param);
        }
        return param;
    }

    private static Class<?> getBoxedType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        throw new AssertionError((Object)("KeyObject: Unknown Java type " + type.getName() + "."));
    }

    private static StringBuilder getDeprecatedFieldWarning(Class<?> clazz, Field field, boolean isModifier) {
        char[] fieldName = field.getName().toCharArray();
        StringBuilder sig = new StringBuilder(255);
        sig.append("Direct use of public fields is deprecated, please add a method '");
        fieldName[0] = Character.toUpperCase(fieldName[0]);
        sig.append("public ");
        if (Modifier.isStatic(field.getModifiers())) {
            sig.append("static ");
        }
        sig.append(isModifier ? "void" : field.getType().getName());
        sig.append(isModifier ? " set" : " get");
        sig.append(fieldName);
        sig.append("(");
        sig.append(isModifier ? field.getType().getName() : "");
        sig.append(")");
        sig.append("' to ").append(clazz).append('.');
        return sig;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This is only for internal use within SYS")
    public static Member[] findMembers(Class<?> clazz, String name, Class<?>[] types, boolean staticOnly) {
        Set<MacroAccessibleObject> allMAOs = KeyObject.allMacroAccessibleObjects(clazz);
        TreeSet<MacroAccessibleObject> goodMAOs = new TreeSet<MacroAccessibleObject>();
        for (MacroAccessibleObject mao : allMAOs) {
            if (staticOnly && !mao.hasModifier(8) || mao.nameMatchMetric(SearchOrder.GET, name) < 0 && mao.nameMatchMetric(SearchOrder.SET, name) < 0 || mao.typeMatchMetric(SearchOrder.GET, types) < 0 && mao.typeMatchMetric(SearchOrder.SET, types) < 0) continue;
            goodMAOs.add(mao);
        }
        Member[] members = new Member[goodMAOs.size()];
        int i = 0;
        for (MacroAccessibleObject mao : goodMAOs) {
            members[i] = (Member)((Object)mao.accessibleObject);
        }
        return members;
    }

    private static Object findAndInvoke(String debugPrefix, Object obj, String key, Object[] args, SearchOrder searchOrder, Object ref) {
        Object nextLink;
        boolean staticOnly;
        Class<?>[] types;
        MacroAccessibleObject bestMAO;
        Object value;
        Class<?> clazz;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        SearchOrder origSearchOrder = searchOrder;
        SearchOrder hardSearchOrder = searchOrder;
        boolean hasOneArg = args != null && args.length == 1;
        boolean isStatic = obj != Class.class && obj instanceof Class || obj == null;
        Class<?> clazz2 = clazz = isStatic ? (Class<?>)obj : obj.getClass();
        if (searchOrder == SearchOrder.SOFT_GET || searchOrder == SearchOrder.SOFT_SET) {
            String keyLC = key.toLowerCase();
            if (keyLC.startsWith("get") || keyLC.startsWith("is")) {
                searchOrder = SearchOrder.GET;
                hardSearchOrder = SearchOrder.GET;
            } else if (keyLC.startsWith("set")) {
                searchOrder = SearchOrder.SET;
                hardSearchOrder = SearchOrder.SET;
            } else if (args.length == 0) {
                searchOrder = SearchOrder.GET;
                hardSearchOrder = SearchOrder.GET;
            } else {
                hardSearchOrder = searchOrder == SearchOrder.SOFT_GET ? SearchOrder.GET : SearchOrder.SET;
            }
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof Table || obj instanceof KeyVector) {
            Object iarg;
            Keyable keyable = (Keyable)obj;
            Object object = iarg = args.length == 2 ? args[0] : null;
            if (hardSearchOrder == SearchOrder.SET && iarg != null) {
                return KeyObject.setIndexed(keyable.getKey(key), Convert.o2l(iarg), args[1]);
            }
            if (!hasOneArg || hardSearchOrder == SearchOrder.GET) {
                Object value2 = keyable.getKey(key);
                return hasOneArg ? KeyObject.getIndexed(value2, KeyObject.getKeyIndex(args[0].toString())) : value2;
            }
            return keyable.setKey(key, args[0]);
        }
        if (obj instanceof XMValue) {
            XMValue xmvalue = (XMValue)obj;
            if (key.equalsIgnoreCase("GETSIZE")) {
                return xmvalue.getSize();
            }
            if (!hasOneArg || hardSearchOrder == SearchOrder.GET) {
                return xmvalue.get(key);
            }
            return xmvalue.set(key, args[0]);
        }
        if (obj instanceof Keyable && (args.length == 0 && hardSearchOrder == SearchOrder.GET ? (value = ((Keyable)obj).getKey(key)) != null : args.length == 1 && hardSearchOrder == SearchOrder.SET && (value = ((Keyable)obj).setKey(key, args[0])) != null)) {
            return value;
        }
        if (clazz.isArray()) {
            int index = KeyObject.getKeyIndex(key, obj);
            if (key.equalsIgnoreCase("SIZE") || key.equalsIgnoreCase("GETSIZE")) {
                if (args.length == 0) {
                    return Array.getLength(obj);
                }
                throw new MidasException("KeyObject: Unable to set size of array, array size is immutable.");
            }
            if (args.length < 2) {
                int length = Array.getLength(obj);
                if (index >= 0 || index < Array.getLength(obj)) {
                    if (args.length == 0) {
                        return KeyObject.getIndexed(obj, index);
                    }
                    return KeyObject.setIndexed(obj, index, args[0]);
                }
                throw new MidasException("KeyObject: Unable to set array index '" + key + "' in " + KeyObject.getClassName(obj) + ": Given array has only " + length + " elements numbered 0.." + (length - 1) + ".");
            }
            throw new MidasException("KeyObject: Unable to set array index '" + key + "' in " + KeyObject.getClassName(obj) + " when given " + args.length + " arguments.");
        }
        int keyIndex = KeyObject.getKeyIndex(key, obj);
        if (keyIndex >= 0) {
            if (hardSearchOrder == SearchOrder.GET && args.length == 0) {
                return KeyObject.getIndexed(obj, keyIndex);
            }
            if (hardSearchOrder == SearchOrder.SET && args.length == 1) {
                return KeyObject.setIndexed(obj, keyIndex, args[0]);
            }
        }
        if ((bestMAO = KeyObject.bestMacroAccessibleObject(debugPrefix, clazz, key, types = KeyObject.getClassOf(args), staticOnly = isStatic && !key.equalsIgnoreCase("<init>"), hardSearchOrder)) != null) {
            return KeyObject.invokeMAO(debugPrefix, obj, key, args, clazz, types, bestMAO);
        }
        int n = keyIndex = args.length == 0 ? -2 : KeyObject.getKeyIndex(args[0].toString());
        if (keyIndex >= 0 && hardSearchOrder == SearchOrder.GET) {
            Object val;
            try {
                val = KeyObject.findAndInvoke(debugPrefix + " | ", obj, key, EMPTY_CLASS_ARRAY, SearchOrder.GET, ref);
            }
            catch (Exception e) {
                val = null;
            }
            try {
                if (KeyObject.isIndexable(val)) {
                    return KeyObject.getIndexed(val, keyIndex);
                }
            }
            catch (Exception e) {
                throw new MidasException("KeyObject: An exception occurred while trying to access " + key + " via index " + keyIndex, e);
            }
        }
        if (searchOrder != hardSearchOrder && (bestMAO = KeyObject.bestMacroAccessibleObject(debugPrefix, clazz, key, types, staticOnly, searchOrder)) != null) {
            return KeyObject.invokeMAO(debugPrefix, obj, key, args, clazz, types, bestMAO);
        }
        Object object = nextLink = obj instanceof Chainable ? ((Chainable)obj).getNextLink() : null;
        if (nextLink != null) {
            return KeyObject.findAndInvoke(debugPrefix + " | ", nextLink, key, args, searchOrder, ref);
        }
        if (obj instanceof Keyable || clazz.isArray()) {
            return null;
        }
        throw new MidasException("KeyObject: Can not access '" + key + "' in " + KeyObject.getClassName(obj) + " when given " + KeyObject.getTypesList(types) + ": No methods found.");
    }

    private static Object invokeMAO(String debugPrefix, Object obj, String key, Object[] args, Class<?> clazz, Class<?>[] types, MacroAccessibleObject bestMAO) {
        Class<?>[] paramTypes = null;
        Object[] params = null;
        if (bestMAO.accessibleObject instanceof Method) {
            paramTypes = ((Method)bestMAO.accessibleObject).getParameterTypes();
            params = KeyObject.convertParams(paramTypes, args);
        } else if (bestMAO.accessibleObject instanceof Constructor) {
            paramTypes = ((Constructor)bestMAO.accessibleObject).getParameterTypes();
            params = KeyObject.convertParams(paramTypes, args);
        } else if (bestMAO.accessibleObject instanceof Field && args.length != 0) {
            paramTypes = new Class[]{((Field)bestMAO.accessibleObject).getType()};
            params = KeyObject.convertParams(paramTypes, args);
        }
        if (bestMAO.accessibleObject instanceof Method) {
            Method method = (Method)bestMAO.accessibleObject;
            try {
                if (Modifier.isAbstract(method.getModifiers())) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return method.invoke(obj, params);
            }
            catch (InvocationTargetException e) {
                throw new MidasException("KeyObject: An exception occurred while trying to run " + method, e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MidasException("KeyObject: An exception occurred while trying to run " + method, e);
            }
        }
        if (bestMAO.accessibleObject instanceof Constructor) {
            Constructor constructor = (Constructor)bestMAO.accessibleObject;
            try {
                return constructor.newInstance(params);
            }
            catch (InvocationTargetException e) {
                throw new MidasException("KeyObject: An exception occurred while trying to run " + constructor, e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new MidasException("KeyObject: An exception occurred while trying to run " + constructor, e);
            }
        }
        if (bestMAO.accessibleObject instanceof Field) {
            Field field = (Field)bestMAO.accessibleObject;
            if (args.length > 1) {
                throw new MidasException("KeyObject: Could not access '" + key + "' in " + KeyObject.getClassName(obj) + " when given " + KeyObject.getTypesList(types) + ": Too many parameters given (" + args.length + ") when trying to set " + field);
            }
            try {
                if (args.length == 0) {
                    return field.get(obj);
                }
                field.set(obj, params[0]);
                return null;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MidasException("KeyObject: An exception occurred while trying to " + (args.length == 1 ? "set" : "get") + " the value of " + field, e);
            }
        }
        throw new AssertionError((Object)("Variable member must be an instance of either Constructor, Method or Field, given instance of " + KeyObject.toString(bestMAO.accessibleObject.getClass())));
    }

    private static CharSequence getTypesList(Class<?>[] types) {
        if (types == null || types.length == 0) {
            return "no arguments";
        }
        if (types.length == 1) {
            return "one argument of type (" + KeyObject.toString(types[0]) + ")";
        }
        StringBuilder str = new StringBuilder(40);
        str.append("arguments of type (");
        str.append(KeyObject.toString(types[0]));
        for (int i = 1; i < types.length; ++i) {
            str.append(", ");
            str.append(KeyObject.toString(types[i]));
        }
        str.append(")");
        return str;
    }

    private static String getClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Class) {
            return obj.toString();
        }
        return KeyObject.toString(obj.getClass());
    }

    private static String toString(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String str = clazz.getName();
        for (String packageName : COMMON_PACKAGES) {
            if (!str.startsWith(packageName) || str.indexOf(46, packageName.length()) >= 0) continue;
            return str.substring(packageName.length());
        }
        return str;
    }

    private static void debug(String debugPrefix, Object obj) {
        Shell.writeln(debugPrefix + obj);
    }

    private static Set<MacroAccessibleObject> allMacroAccessibleObjects(Class<?> clazz) {
        Set<MacroAccessibleObject> allMAOs = allMAOsByClass.get(clazz);
        if (allMAOs == null) {
            allMAOs = MacroAccessibleObject.allInstancesFor(clazz);
            allMAOsByClass.put(clazz, allMAOs);
        }
        return allMAOs;
    }

    private static MacroAccessibleObject bestMacroAccessibleObject(String debugPrefix, Class<?> clazz, String name, Class<?>[] types, boolean staticOnly, SearchOrder searchOrder) {
        boolean FAST = true;
        Set<MacroAccessibleObject> allMAOs = KeyObject.allMacroAccessibleObjects(clazz);
        TreeMap<MatchMetric, LinkedHashSet<MacroAccessibleObject>> rankedMAOs = new TreeMap<MatchMetric, LinkedHashSet<MacroAccessibleObject>>();
        MatchMetric matchMetric = new MatchMetric();
        for (MacroAccessibleObject mao : allMAOs) {
            if (staticOnly && !mao.hasModifier(8)) continue;
            matchMetric.nameMatchMetric = mao.nameMatchMetric(searchOrder, name);
            if (matchMetric.nameMatchMetric == Integer.MAX_VALUE) continue;
            matchMetric.typeMatchMetric = mao.typeMatchMetric(searchOrder, types);
            if (matchMetric.typeMatchMetric == Integer.MAX_VALUE) continue;
            LinkedHashSet<MacroAccessibleObject> maoSet = (LinkedHashSet<MacroAccessibleObject>)rankedMAOs.get(matchMetric);
            if (maoSet == null) {
                maoSet = new LinkedHashSet<MacroAccessibleObject>(4);
                rankedMAOs.put(matchMetric, maoSet);
                matchMetric = new MatchMetric();
            }
            maoSet.add(mao);
        }
        if (rankedMAOs.isEmpty()) {
            return null;
        }
        Map.Entry firstEntry = rankedMAOs.firstEntry();
        MatchMetric bestMatch = (MatchMetric)firstEntry.getKey();
        Set bestMAOs = (Set)firstEntry.getValue();
        if (bestMAOs.size() == 1) {
            return (MacroAccessibleObject)bestMAOs.iterator().next();
        }
        LinkedHashSet<MacroAccessibleObject> bestMethods = new LinkedHashSet<MacroAccessibleObject>(4);
        for (MacroAccessibleObject mao : bestMAOs) {
            if (mao.accessibleObject instanceof Field) continue;
            bestMethods.add(mao);
        }
        if (bestMethods.size() == 1) {
            return (MacroAccessibleObject)bestMethods.iterator().next();
        }
        StringBuilder errMsg = new StringBuilder(128);
        boolean first = true;
        errMsg.append("KeyObject: Ambiguous member definition: found multiple matches for name '");
        errMsg.append(name);
        errMsg.append("': ");
        for (MacroAccessibleObject o : (Set)firstEntry.getValue()) {
            if (!first) {
                errMsg.append(", ");
            }
            errMsg.append(o.accessibleObject);
            first = false;
        }
        throw new MidasException(errMsg.toString());
    }

    private static class MatchMetric
    implements Comparable<MatchMetric> {
        int nameMatchMetric;
        int typeMatchMetric;

        private MatchMetric() {
        }

        public String toString() {
            return "MatchMetric(0x" + Integer.toHexString(this.nameMatchMetric) + ", 0x" + Integer.toHexString(this.typeMatchMetric) + ")";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MatchMetric)) {
                return false;
            }
            MatchMetric that = (MatchMetric)obj;
            return this.nameMatchMetric == that.nameMatchMetric && this.typeMatchMetric == that.typeMatchMetric;
        }

        public int hashCode() {
            return this.nameMatchMetric << 4 ^ this.typeMatchMetric;
        }

        private long getCompValue() {
            if (this.nameMatchMetric == Integer.MAX_VALUE || this.typeMatchMetric == Integer.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return (long)this.nameMatchMetric << 32 | (long)this.typeMatchMetric;
        }

        @Override
        public int compareTo(MatchMetric that) {
            return Long.compare(this.getCompValue(), that.getCompValue());
        }
    }

    private static class MacroAccessibleObject
    implements Comparable<MacroAccessibleObject> {
        final Class<?> accessibleObjectClass;
        final AccessibleObject accessibleObject;
        final String name;
        final Collection<String> aliases;
        final Collection<String> abbreviations;
        final Class<?>[] types;

        MacroAccessibleObject(AccessibleObject accessibleObject, String name, Collection<String> aliases, Collection<String> abbreviations, Class<?>[] types) {
            Class<?> aoClass = null;
            if (accessibleObject instanceof Member) {
                aoClass = ((Member)((Object)accessibleObject)).getDeclaringClass();
            }
            this.accessibleObjectClass = aoClass;
            this.accessibleObject = accessibleObject;
            this.name = name;
            this.aliases = aliases == null ? Collections.EMPTY_LIST : aliases;
            this.abbreviations = abbreviations == null ? Collections.EMPTY_LIST : abbreviations;
            this.types = types;
        }

        static Set<MacroAccessibleObject> allInstancesFor(Class<?> clazz) {
            return MacroAccessibleObject.allInstancesFor(new TreeSet<MacroAccessibleObject>(), clazz);
        }

        private static Set<MacroAccessibleObject> allInstancesFor(Set<MacroAccessibleObject> maoSet, Class<?> clazz) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    MacroAccessibleObject.tryAdd(maoSet, constructor);
                }
                for (Executable executable : clazz.getMethods()) {
                    MacroAccessibleObject.tryAdd(maoSet, executable);
                }
                for (AccessibleObject accessibleObject : clazz.getFields()) {
                    MacroAccessibleObject.tryAdd(maoSet, accessibleObject);
                }
            } else {
                if (clazz.getSuperclass() != null) {
                    MacroAccessibleObject.allInstancesFor(maoSet, clazz.getSuperclass());
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    MacroAccessibleObject.allInstancesFor(maoSet, clazz2);
                }
            }
            return maoSet;
        }

        private static void tryAdd(Set<MacroAccessibleObject> maoSet, AccessibleObject accessibleObject) {
            try {
                MacroAccessibleObject.add(maoSet, accessibleObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private static void add(Set<MacroAccessibleObject> maoSet, AccessibleObject accessibleObject) {
            Collection<String> aliases;
            KeyObjectNames kon = accessibleObject.getAnnotation(KeyObjectNames.class);
            Collection<String> collection = aliases = kon == null ? null : Arrays.asList(kon.value());
            if (accessibleObject instanceof Constructor) {
                Constructor constructor = (Constructor)accessibleObject;
                String name = "<init>";
                Class<?>[] types = constructor.getParameterTypes();
                if (aliases == null) {
                    aliases = INIT_ONLY;
                }
                maoSet.add(new MacroAccessibleObject(constructor, name, aliases, null, types));
            } else if (accessibleObject instanceof Method) {
                String baseName;
                boolean isIs;
                Method method = (Method)accessibleObject;
                String name = method.getName();
                Class<?>[] types = method.getParameterTypes();
                ArrayList<String> abbreviations = null;
                boolean isGet = name.startsWith("get") && name.length() > 3;
                boolean isSet = name.startsWith("set") && name.length() > 3;
                boolean bl = isIs = name.startsWith("is") && name.length() > 2;
                if (aliases == null) {
                    aliases = new ArrayList<String>(3);
                    aliases.add(name);
                    if (isGet || isSet || isIs) {
                        baseName = isIs ? name.substring(2) : name.substring(3);
                        String accronym = StringUtil.getAcronym(baseName);
                        aliases.add(baseName);
                        if (!accronym.isEmpty()) {
                            aliases.add(accronym);
                        }
                    }
                }
                if (kon == null && (isGet || isSet || isIs)) {
                    abbreviations = new ArrayList<String>(4);
                    baseName = isIs ? name.substring(2) : name.substring(3);
                    for (int i = 1; i <= 4 && i < baseName.length(); ++i) {
                        abbreviations.add(baseName.substring(0, i));
                    }
                }
                maoSet.add(new MacroAccessibleObject(method, name, aliases, abbreviations, types));
            } else if (accessibleObject instanceof Field) {
                Class[] types;
                Field field = (Field)accessibleObject;
                Class<?> clazz = field.getDeclaringClass();
                String name = field.getName();
                if (aliases == null) {
                    aliases = Collections.singleton(name);
                }
                if (MacroAccessibleObject.lacksGetter(clazz, field)) {
                    types = EMPTY_CLASS_ARRAY;
                    maoSet.add(new MacroAccessibleObject(field, name, aliases, null, types));
                }
                if (MacroAccessibleObject.lacksSetter(clazz, field)) {
                    types = new Class[]{((Field)accessibleObject).getType()};
                    maoSet.add(new MacroAccessibleObject(field, name, aliases, null, types));
                }
            } else {
                throw new AssertionError((Object)("AccessibleObject " + accessibleObject + " is of unexpected type: " + accessibleObject.getClass()));
            }
        }

        private static boolean lacksGetter(Class<?> clazz, Field field) {
            String getterName = "get" + field.getName();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equalsIgnoreCase(getterName) || method.getParameterTypes().length != 0 || !KeyObject.isMatchingType(method.getReturnType(), field.getType(), true, true, true)) continue;
                return false;
            }
            return true;
        }

        private static boolean lacksSetter(Class<?> clazz, Field field) {
            if (Modifier.isFinal(field.getModifiers())) {
                return false;
            }
            String setterName = "set" + field.getName();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equalsIgnoreCase(setterName) || method.getParameterTypes().length != 1 || !KeyObject.isMatchingType(method.getParameterTypes()[0], field.getType(), true, true, true)) continue;
                return false;
            }
            return true;
        }

        public boolean hasModifier(int modifier) {
            return 0 < (modifier & ((Member)((Object)this.accessibleObject)).getModifiers());
        }

        int nameMatchMetric(SearchOrder searchOrder, String baseName) {
            if (baseName == null) {
                return 0;
            }
            if (this.accessibleObject instanceof Method) {
                Method method = (Method)this.accessibleObject;
                if (searchOrder == SearchOrder.SET && (method.getName().startsWith("get") || method.getName().startsWith("is"))) {
                    return Integer.MAX_VALUE;
                }
                if (searchOrder == SearchOrder.GET && method.getName().startsWith("set")) {
                    return Integer.MAX_VALUE;
                }
            }
            SearchOrder _searchOrder = searchOrder != null ? searchOrder : SearchOrder.GET;
            boolean abbrOk = baseName.length() > 1 && baseName.length() <= 4;
            String baseNameTC = baseName.substring(0, 1).toUpperCase() + baseName.substring(1);
            String fullName1 = _searchOrder.prefix + baseNameTC;
            String fullName2 = _searchOrder.alternate + baseNameTC;
            String baseNameUC = baseName;
            int metric = Integer.MAX_VALUE;
            for (String memberName : this.aliases) {
                if (memberName.equals(fullName1) || memberName.equals(fullName2)) {
                    return 0;
                }
                if (memberName.equalsIgnoreCase(fullName1) || memberName.equalsIgnoreCase(fullName2)) {
                    metric = Math.min(metric, 0x1000000);
                    continue;
                }
                if (memberName.equals(baseName)) {
                    metric = Math.min(metric, 0x3000000);
                    continue;
                }
                if (!memberName.equalsIgnoreCase(baseName)) continue;
                metric = Math.min(metric, 0x4000000);
            }
            if (abbrOk && metric == Integer.MAX_VALUE) {
                for (String memberName : this.abbreviations) {
                    if (!memberName.equalsIgnoreCase(baseName)) continue;
                    metric = Math.min(metric, 0x5000000 + (this.name.length() - baseNameUC.length()));
                }
            }
            return metric;
        }

        int typeMatchMetric(SearchOrder searchOrder, Class<?>[] thatTypes) {
            Class<?>[] thisTypes;
            if (thatTypes == null) {
                thatTypes = EMPTY_CLASS_ARRAY;
            }
            if ((thisTypes = this.types).length != thatTypes.length) {
                return Integer.MAX_VALUE;
            }
            int metric = 0;
            for (int i = 0; i < thisTypes.length; ++i) {
                Class thisType = KeyObject.getBoxedType(thisTypes[i]);
                Class thatType = KeyObject.getBoxedType(thatTypes[i]);
                boolean isIF = thisType.isInterface();
                if (thisType == thatType) {
                    metric += 0;
                    continue;
                }
                if (thisType.isAssignableFrom(thatType) && isIF) {
                    ++metric;
                    continue;
                }
                if (thisType.isAssignableFrom(thatType)) {
                    metric += 2;
                    continue;
                }
                if (KeyObject.isMatchingType(thisType, thatType, false, true, false)) {
                    metric += 65536;
                    continue;
                }
                if (KeyObject.isMatchingType(thisType, thatType, true, true, false)) {
                    metric += 131072;
                    continue;
                }
                if (KeyObject.isMatchingType(thisType, thatType, true, true, true)) {
                    metric += 196608;
                    continue;
                }
                return Integer.MAX_VALUE;
            }
            return metric;
        }

        @Override
        public int compareTo(MacroAccessibleObject that) {
            if (that == null) {
                throw new NullPointerException("Can not compare " + this + " to " + that + ".");
            }
            if (that.equals(this)) {
                return 0;
            }
            int retval = this.name.compareTo(that.name);
            if (retval != 0) {
                return retval;
            }
            retval = this.types.length - that.types.length;
            if (retval != 0) {
                return retval;
            }
            int t = 0;
            for (Class<?> thisType : this.types) {
                retval = thisType.getName().compareTo(that.types[t++].getName());
                if (retval == 0) continue;
                return retval;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MacroAccessibleObject)) {
                return false;
            }
            MacroAccessibleObject that = (MacroAccessibleObject)object;
            return that == this || this.accessibleObject.equals(that.accessibleObject) && Arrays.equals(this.types, that.types);
        }

        public int hashCode() {
            return this.accessibleObject.hashCode();
        }

        public String toString() {
            return "MacroAccessibleObject(class=" + this.accessibleObjectClass + " accObj=" + this.accessibleObject + ", name='" + this.name + "', aliases=" + this.aliases + ", abbreviations=" + this.abbreviations + ", types=" + Arrays.toString(this.types) + ")";
        }
    }

    private static enum SearchOrder {
        GET("get", "is"),
        SET("set", null),
        SOFT_GET("get", "is"),
        SOFT_SET("set", null);

        public final String prefix;
        public final String alternate;

        private SearchOrder(String prefix, String alternate) {
            this.prefix = prefix;
            this.alternate = alternate;
        }
    }
}

