/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.XmlFile;

public class JnlpFile
extends XmlFile
implements Tablizable {
    public static final String SPEC_1_0 = "1.0+";
    public static final String SPEC_1_5 = "1.5+";
    public static final String SPEC_6_0 = "6.0+";
    public static final String SPEC_7_0 = "7.0+";
    public static final int VERSION_1_0 = JnlpFile.encodeVersion(1, 0, 0);
    public static final int VERSION_1_5 = JnlpFile.encodeVersion(1, 5, 0);
    public static final int VERSION_6 = JnlpFile.encodeVersion(6, 0, 0);
    public static final int VERSION_6_0_10 = JnlpFile.encodeVersion(6, 0, 10);
    public static final int VERSION_6_0_18 = JnlpFile.encodeVersion(6, 0, 18);
    public static final int VERSION_7 = JnlpFile.encodeVersion(7, 0, 0);
    public static final int[] SUPPORTED_VERSIONS = new int[]{VERSION_1_0, VERSION_1_5, VERSION_6, VERSION_6_0_10, VERSION_6_0_18, VERSION_7};
    public static final int VERSION_LATEST = VERSION_7;
    public static final int VERSION_COMPATIBLE = VERSION_1_0;
    protected double seek;
    protected Integer ver;
    protected String spec;
    protected String version;
    protected String codebase;
    protected String href;
    protected final NonEmptyList<JnlpInformation> jnlpInformation = new NonEmptyList<JnlpInformation>(new JnlpInformation("", "", ""));
    protected boolean allPermissions;
    protected boolean clientPermissions;
    protected JnlpUpdateCheck updateCheck;
    protected JnlpUpdatePolicy updatePolicy;
    protected final List<JnlpResources> jnlpResources = new LinkedList<JnlpResources>();
    protected JnlpDescElement jnlpDesc = new JnlpComponentDesc();

    public JnlpFile() {
    }

    public JnlpFile(String fileName) {
        this();
        this.init(null, (Object)fileName);
    }

    @Deprecated
    public JnlpFile(Object ref, Object fileName) {
        this();
        this.init(Convert.ref2Midas(ref), fileName);
    }

    public JnlpFile(MidasReference ref, Object fileName) {
        this();
        this.init(ref, fileName);
    }

    private String ver2spec(int ver) {
        int major = ver / 1000000;
        int minor = ver / 1000 % 1000;
        return "" + major + "." + minor + "+";
    }

    private String ver2string(int ver) {
        int major = ver / 1000000;
        int minor = ver / 1000 % 1000;
        int update = ver % 1000;
        return "" + major + "." + minor + "." + update;
    }

    private int spec2ver(String spec, boolean latestUpdate) {
        if (spec.endsWith("+")) {
            spec = spec.substring(0, spec.length() - 1);
        }
        int major = 0;
        int minor = 0;
        int update = 0;
        try {
            String[] token = spec.split("[.]");
            major = Integer.parseInt(token[0]);
            if (token.length > 1) {
                minor = Integer.parseInt(token[1]);
                if (token.length > 2) {
                    update = Integer.parseInt(token[2]);
                }
            }
        }
        catch (NumberFormatException e) {
            this.warning("JNLP file has malformed specification version = " + spec + ". Using Version 1.0");
            major = 1;
        }
        int ver = JnlpFile.encodeVersion(major, minor, update);
        if (latestUpdate && ver == VERSION_6) {
            ver = VERSION_6_0_18;
        }
        return ver;
    }

    private static int encodeVersion(int major, int minor, int update) {
        if (major <= 0) {
            throw new IllegalArgumentException("Unexpected major version: " + major);
        }
        if (minor < 0 || minor > 1000) {
            throw new IllegalArgumentException("Unexpected minor version: " + minor);
        }
        if (update < 0 || update > 1000) {
            throw new IllegalArgumentException("Unexpected update version: " + update);
        }
        return major * 1000000 + minor * 1000 + update;
    }

    @Override
    public int seek(double val) {
        this.seek = this.seek >= 1.0 ? 1.0 : 0.0;
        return 0;
    }

    @Override
    public double seek() {
        return this.seek;
    }

    @Override
    public double avail() {
        return this.getSize() - this.seek();
    }

    @Override
    public double getSize() {
        return 1.0;
    }

    @Override
    public String getMimeType() {
        return "application/x-java-jnlp-file";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allPermissions ? 1231 : 1237);
        result = 31 * result + (this.clientPermissions ? 1231 : 1237);
        result = 31 * result + (this.codebase == null ? 0 : this.codebase.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.jnlpDesc == null ? 0 : this.jnlpDesc.hashCode());
        result = 31 * result + (this.jnlpInformation == null ? 0 : this.jnlpInformation.hashCode());
        result = 31 * result + (this.jnlpResources == null ? 0 : this.jnlpResources.hashCode());
        long temp = Double.doubleToLongBits(this.seek);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
        result = 31 * result + (this.updateCheck == null ? 0 : this.updateCheck.hashCode());
        result = 31 * result + (this.updatePolicy == null ? 0 : this.updatePolicy.hashCode());
        result = 31 * result + (this.ver == null ? 0 : this.ver.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object inobj, int flags) {
        if (flags == 1) {
            return this.equalsBinary(inobj);
        }
        return this.equals(inobj);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JnlpFile other = (JnlpFile)obj;
        this.open();
        other.open();
        if (this.allPermissions != other.allPermissions) {
            return false;
        }
        if (this.clientPermissions != other.clientPermissions) {
            return false;
        }
        if (this.codebase == null ? other.codebase != null : !this.codebase.equals(other.codebase)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.jnlpDesc == null ? other.jnlpDesc != null : !this.jnlpDesc.equals(other.jnlpDesc)) {
            return false;
        }
        if (this.jnlpInformation == null ? other.jnlpInformation != null : !this.jnlpInformation.equals(other.jnlpInformation)) {
            return false;
        }
        if (this.jnlpResources == null ? other.jnlpResources != null : !this.jnlpResources.equals(other.jnlpResources)) {
            return false;
        }
        if (Double.doubleToLongBits(this.seek) != Double.doubleToLongBits(other.seek)) {
            return false;
        }
        if (this.spec == null ? other.spec != null : !this.spec.equals(other.spec)) {
            return false;
        }
        if (this.updateCheck != other.updateCheck) {
            return false;
        }
        if (this.updatePolicy != other.updatePolicy) {
            return false;
        }
        if (this.ver == null ? other.ver != null : !this.ver.equals(other.ver)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public boolean equalsBinary(Object inobj) {
        if (this == inobj) {
            return true;
        }
        if (inobj == null) {
            return false;
        }
        boolean theSame = false;
        if (inobj.getClass() == this.getClass()) {
            BaseFile bf1 = new BaseFile(this.M, (Object)this.getFileName());
            BaseFile bf2 = new BaseFile(this.M, (Object)((JnlpFile)inobj).getFileName());
            this.flags = 3;
            return bf1.equalsBF(bf2, this.flags);
        }
        return theSame;
    }

    @Override
    public String toString() {
        return "JnlpFile : " + this.getURL();
    }

    @Override
    public boolean open() {
        if (super.open()) {
            if (this.isInput) {
                this.readFile();
            }
            this.setInternals();
        }
        return this.isOpen;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void update() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.isOutput && this.isOpen) {
            CharSequence xml = this.toXML();
            byte[] buf = xml.toString().getBytes();
            super.seek(0.0);
            super.write(buf, 0, buf.length);
        }
    }

    @Override
    public String listHeader() {
        StringBuilder str = new StringBuilder(256);
        str.append("JnlpFile    : ").append(this.getURL()).append("\n");
        return str.toString();
    }

    @Override
    public String listElements(double start, int elem, String format, int flags) {
        return "\n" + this.toXML();
    }

    @Override
    public int listElementsPerLine(int lineWidth, String format, int flags) {
        return 1;
    }

    public CharSequence toXML() {
        int _ver = this.getVer();
        StringBuilder xml = new StringBuilder(4096);
        xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        JnlpFile.appendOpenTag(xml, "", "jnlp", "spec", this.getSpec(), "version", this.getVersion(), "codebase", this.getCodebase(), "href", this.getHref());
        for (JnlpInformation info : this.getInformation()) {
            info.appendXML(xml, _ver);
        }
        if (this.isAllPermissions() || this.isClientPermissions()) {
            xml.append("  <security>\n");
            if (this.isAllPermissions()) {
                xml.append("    <all-permissions/>\n");
            }
            if (this.isClientPermissions()) {
                xml.append("    <j2ee-application-client-permissions/>\n");
            }
            xml.append("  </security>\n");
        }
        if (_ver >= VERSION_6 && (this.getUpdateCheck() != null || this.getUpdatePolicy() != null)) {
            JnlpFile.appendOpenCloseTag(xml, "  ", "update", new Object[]{"check", this.getUpdateCheck(), "policy", this.getUpdatePolicy()});
        }
        for (JnlpResources resource : this.getResources()) {
            resource.appendXML(xml, _ver);
        }
        this.getDesc().appendXML(xml, _ver);
        xml.append("</jnlp>\n");
        return xml;
    }

    protected byte[] readAll() {
        this.seek(0.0);
        byte[] buf = new byte[32768];
        int numRead = super.read(buf, 0, buf.length);
        int boff = 0;
        while (numRead >= 0) {
            int toRead = buf.length - (boff += numRead);
            if (toRead < 4096) {
                Arrays.copyOf(buf, buf.length + 32768);
                toRead = buf.length - boff;
            }
            numRead = super.read(buf, boff, toRead);
        }
        return Arrays.copyOf(buf, boff);
    }

    protected void readFile() {
        this.seek(0.0);
        byte[] buf = new byte[32768];
        int numRead = super.read(buf, 0, buf.length);
        int length = 0;
        while (numRead >= 0) {
            int toRead = buf.length - (length += numRead);
            if (toRead < 4096) {
                Arrays.copyOf(buf, buf.length + 32768);
                toRead = buf.length - length;
            }
            numRead = super.read(buf, length, toRead);
        }
        String xml = new String(buf, 0, length);
        XmlFile.XmlToTableHandler handler = new XmlFile.XmlToTableHandler("#", "#CDATA#", 0, true, 5);
        JnlpFile.parseXmlFast(xml, handler);
        this.fromTable(handler.getTable());
    }

    @Override
    public Table toTable() {
        XmlFile.XmlToTableHandler handler = new XmlFile.XmlToTableHandler("#", "#CDATA#", 0, true, 5);
        JnlpFile.parseXmlFast(this.toXML().toString(), handler);
        return handler.getTable();
    }

    public void fromTable(Table tbl) {
        Table t;
        if (tbl.containsKey("SPEC")) {
            this.setSpec(tbl.getS("SPEC"));
        }
        if (tbl.containsKey("VERSION")) {
            this.setVersion(tbl.getS("VERSION"));
        }
        if (tbl.containsKey("CODEBASE")) {
            this.setCodebase(tbl.getS("CODEBASE"));
        }
        if (tbl.containsKey("HREF")) {
            this.setHref(tbl.getS("HREF"));
        }
        this.getInformation().clear(null);
        for (Table t2 : JnlpFile.getTables(tbl, "INFORMATION")) {
            this.getInformation().add(new JnlpInformation(t2));
        }
        this.getInformation().remove(null);
        if (tbl.containsKey("SECURITY")) {
            t = tbl.getTable("SECURITY");
            this.setAllPermissions(t.containsKey("ALL-PERMISSIONS"));
            this.setClientPermissions(t.containsKey("J2EE-APPLICATION-CLIENT-PERMISSIONS"));
        }
        if (tbl.containsKey("UPDATE")) {
            t = tbl.getTable("UPDATE");
            this.setUpdateCheck(t.getS("CHECK"));
            this.setUpdatePolicy(t.getS("POLICY"));
        }
        this.getResources().clear();
        for (Table t2 : JnlpFile.getTables(tbl, "RESOURCES")) {
            this.getResources().add(new JnlpResources(t2));
        }
        if (tbl.containsKey("APPLICATION-DESC")) {
            this.setDesc(new JnlpApplicationDesc(tbl.getTable("APPLICATION-DESC")));
        }
        if (tbl.containsKey("COMPONENT-DESC")) {
            this.setDesc(new JnlpComponentDesc(tbl.getTable("COMPONENT-DESC")));
        }
        if (tbl.containsKey("INSTALLER-DESC")) {
            this.setDesc(new JnlpInstallerDesc(tbl.getTable("INSTALLER-DESC")));
        }
    }

    public final String getSpec() {
        return this.ver2spec(this.getVer());
    }

    public final void setSpec(String spec) {
        this.setVer(this.spec2ver(spec, true));
    }

    public int getVer() {
        return this.ver == null ? VERSION_COMPATIBLE : this.ver;
    }

    public void setVer(Integer ver) {
        if (ver == null) {
            this.ver = null;
        } else {
            if (Arrays.binarySearch(SUPPORTED_VERSIONS, ver) < 0) {
                this.warning("Specification version " + this.ver2string(ver) + " (or " + this.ver2spec(ver) + ") is not fully supported");
            }
            this.ver = ver;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setCodebase(String codebase) {
        this.codebase = FileUtil.terminatePath(codebase);
    }

    public String getHref() {
        return this.href != null ? this.href : this.getName().getBasename();
    }

    public void setHref(String href) {
        this.href = href;
    }

    public NonEmptyList<JnlpInformation> getInformation() {
        return this.jnlpInformation;
    }

    public JnlpInformation getInfo() {
        return this.getInformation().get(0);
    }

    public List<JnlpResources> getResources() {
        return this.jnlpResources;
    }

    public boolean isAllPermissions() {
        return this.allPermissions;
    }

    public void setAllPermissions(boolean all) {
        this.allPermissions = all;
    }

    public boolean isClientPermissions() {
        return this.clientPermissions;
    }

    public void setClientPermissions(boolean client) {
        this.clientPermissions = client;
    }

    public JnlpUpdateCheck getUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(JnlpUpdateCheck check) {
        this.updateCheck = check;
    }

    public final void setUpdateCheck(String check) {
        this.setUpdateCheck(JnlpUpdateCheck.parse(check));
    }

    public JnlpUpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(JnlpUpdatePolicy policy) {
        this.updatePolicy = policy;
    }

    public final void setUpdatePolicy(String policy) {
        this.setUpdatePolicy(JnlpUpdatePolicy.parse(policy));
    }

    public JnlpDescElement getDesc() {
        return this.jnlpDesc;
    }

    public void setDesc(JnlpDescElement desc) {
        this.jnlpDesc = desc;
    }

    private static Table _getTable(Table tbl, String key) {
        Table t = tbl.getTable(key);
        if (t == null) {
            t = new Table();
            t.put("#CDATA#", (Object)tbl.getS(key));
        }
        return t;
    }

    private static List<Table> getTables(Table tbl, String key) {
        LinkedList<Table> all = new LinkedList<Table>();
        int i = 0;
        String k = key + "#" + i++;
        if (tbl.containsKey(key)) {
            all.add(JnlpFile._getTable(tbl, key));
        }
        while (tbl.containsKey(k)) {
            all.add(JnlpFile._getTable(tbl, k));
            k = key + "#" + i++;
        }
        return all;
    }

    private static List<String> getStrings(Table tbl, String key) {
        LinkedList<String> all = new LinkedList<String>();
        int i = 0;
        String k = key + "#" + i++;
        if (tbl.containsKey(key)) {
            all.add(tbl.getS(key));
        }
        while (tbl.containsKey(k)) {
            all.add(tbl.getS(k));
            k = key + "#" + i++;
        }
        return all;
    }

    private static StringBuilder _appendOpenTag(StringBuilder xml, String prefix, String name, String close, Object ... tagValue) {
        StringBuilder subPrefix = new StringBuilder();
        for (int i = 0; i < prefix.length() + name.length() + 1; ++i) {
            subPrefix.append(' ');
        }
        boolean first = true;
        xml.append(prefix).append('<').append(name);
        for (int i = 0; i < tagValue.length; i += 2) {
            if (tagValue[i + 1] == null) continue;
            if (!first) {
                xml.append('\n').append((CharSequence)subPrefix);
            }
            xml.append(' ').append(tagValue[i]).append("=\"").append(tagValue[i + 1]).append('\"');
            first = false;
        }
        xml.append(close);
        return xml;
    }

    private static StringBuilder appendOpenCloseTag(StringBuilder xml, String prefix, String name, Object ... tagValue) {
        return JnlpFile._appendOpenTag(xml, prefix, name, "/>\n", tagValue);
    }

    private static StringBuilder appendOpenTag(StringBuilder xml, String prefix, String name, Object ... tagValue) {
        return JnlpFile._appendOpenTag(xml, prefix, name, ">\n", tagValue);
    }

    private static StringBuilder appendElement(StringBuilder xml, String prefix, Object val, String suffix) {
        if (val != null) {
            xml.append(prefix).append(val).append(suffix);
        }
        return xml;
    }

    private static class ListIter<E>
    implements ListIterator<E> {
        private final NonEmptyList<E> list;
        private final ListIterator<E> iter;

        ListIter(NonEmptyList<E> list3, ListIterator<E> iter) {
            this.list = list3;
            this.iter = iter;
        }

        @Override
        public void add(E v) {
            this.iter.add(v);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public E previous() {
            return this.iter.previous();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void set(E v) {
            this.iter.set(v);
        }

        @Override
        public void remove() {
            if (this.list.size() == 1) {
                throw new UnsupportedOperationException("Can not remove all elements from a NonEmptyList");
            }
            this.iter.remove();
        }
    }

    public static final class NonEmptyList<E>
    implements List<E> {
        private final LinkedList<E> list = new LinkedList();

        public NonEmptyList(E value) {
            this.add(value);
        }

        public NonEmptyList(Collection<E> values) {
            if (values.isEmpty()) {
                throw new IllegalArgumentException("Can not create an empty NonEmptyList.");
            }
            this.addAll(values);
        }

        @Override
        public boolean add(E v) {
            return this.list.add(v);
        }

        @Override
        public void add(int i, E v) {
            this.list.add(i, v);
        }

        @Override
        public boolean contains(Object v) {
            return this.list.contains(v);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        @Override
        public E get(int i) {
            return this.list.get(i);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object v) {
            return this.list.indexOf(v);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object v) {
            return this.list.lastIndexOf(v);
        }

        @Override
        public E set(int i, E v) {
            return this.list.set(i, v);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public List<E> subList(int i, int j) {
            return this.list.subList(i, j);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        public String toString() {
            return this.list.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new ListIter<E>(this, this.list.listIterator(0));
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ListIter<E>(this, this.list.listIterator(0));
        }

        @Override
        public ListIterator<E> listIterator(int i) {
            return new ListIter<E>(this, this.list.listIterator(i));
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(int i, Collection<? extends E> c) {
            return this.list.addAll(i, c);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Can not remove all elements from a NonEmptyList");
        }

        public void clear(E entry) {
            this.list.clear();
            this.add(entry);
        }

        @Override
        public E remove(int i) {
            if (this.size() == 1 && i == 0) {
                this.clear();
            }
            return this.list.remove(i);
        }

        @Override
        public boolean remove(Object v) {
            if (this.size() == 1 && this.contains(v)) {
                this.clear();
            }
            return this.list.remove(v);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c.size() < this.size()) {
                return this.list.removeAll(c);
            }
            int count = 0;
            for (Object o : c) {
                if (!this.contains(o)) continue;
                ++count;
            }
            if (count == this.size()) {
                this.clear();
            }
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (c.isEmpty()) {
                this.clear();
            }
            int count = 0;
            for (E v : this) {
                if (!c.contains(v)) continue;
                ++count;
            }
            if (count == this.size()) {
                this.clear();
            }
            return this.list.retainAll(c);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }
    }

    public static final class JnlpRelatedContent
    extends DescribedJnlpElement {
        private String href;
        private String title;

        public JnlpRelatedContent(String href) {
            this.setHref(href);
        }

        JnlpRelatedContent(Table tbl) {
            super(tbl);
            this.setHref(tbl.getS("HREF"));
            this.setTitle(tbl.getS("TITLE"));
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            String kind = this.getDescriptionKind() == null ? "" : " kind='" + (Object)((Object)this.getDescriptionKind()) + "'";
            JnlpFile.appendOpenTag(xml, "    ", "related-content", new Object[]{"href", this.getHref()});
            JnlpFile.appendElement(xml, "      <title>", this.getTitle(), "</title>");
            JnlpFile.appendElement(xml, "      <description" + kind + ">", this.getDescription(), "</description>");
            if (this.getIcon() != null) {
                this.getIcon().appendXML(xml, ver);
            }
            return xml.append("    </related-content>\n");
        }

        public final String getHref() {
            return this.href;
        }

        public final void setHref(String href) {
            if (href == null) {
                throw new NullPointerException("HREF can not be null.");
            }
            this.href = href;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    public static final class JnlpAssociation
    extends DescribedJnlpElement {
        private final NonEmptyList<String> extensions;
        private String mimeType;

        public JnlpAssociation(String mimeType, String ... ext) {
            this.extensions = new NonEmptyList<String>(Arrays.asList(ext));
            this.setMimeType(mimeType);
        }

        public JnlpAssociation(String mimeType, NonEmptyList<String> extensions) {
            this.extensions = extensions;
            this.setMimeType(mimeType);
        }

        JnlpAssociation(Table tbl) {
            super(tbl);
            this.extensions = new NonEmptyList<String>(Arrays.asList(new String[]{null}));
            this.setMimeType(tbl.getS("MIME-TYPE"));
            this.setExt(tbl.getS("EXTENSIONS"));
            if (tbl.containsKey("ICON")) {
                this.setIcon(new JnlpIcon(tbl.getTable("ICON")));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            String kind = this.getDescriptionKind() == null ? "" : " kind='" + (Object)((Object)this.getDescriptionKind()) + "'";
            JnlpFile.appendOpenTag(xml, "    ", "association", new Object[]{"extensions", this.getExt(), "mime-type", this.getMimeType()});
            JnlpFile.appendElement(xml, "      <description" + kind + ">", this.getDescription(), "</description>");
            if (this.getIcon() != null) {
                this.getIcon().appendXML(xml, ver);
            }
            return xml.append("    </association>\n");
        }

        public CharSequence getExt() {
            StringBuilder str = new StringBuilder();
            str.append(this.extensions.get(0));
            for (int i = 1; i < this.extensions.size(); ++i) {
                str.append(' ').append(this.extensions.get(i));
            }
            return str;
        }

        public void setExt(CharSequence ext) {
            String[] exts = ext.toString().split(" ");
            if (this.extensions.size() > 0) {
                this.extensions.removeAll(this.extensions.subList(1, this.extensions.size()));
            }
            this.extensions.set(0, exts[0]);
            for (int i = 1; i < exts.length; ++i) {
                this.extensions.add(exts[i]);
            }
        }

        public NonEmptyList<String> getExtensions() {
            return this.extensions;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("mime-type can not be null");
            }
            this.mimeType = mimeType;
        }
    }

    @Deprecated
    public static final class JnlpAppletDesc
    extends JnlpDescElement {
        private String documentBase;
        private String name;
        private int width;
        private int height;
        private final Map<String, String> params = new LinkedHashMap<String, String>();

        JnlpAppletDesc(Table tbl) {
            super("applet-desc", tbl);
            this.setDocumentBase(tbl.getS("DOCUMENT-BASE"));
            this.setName(tbl.getS("NAME"));
            if (tbl.containsKey("WIDTH")) {
                this.setWidth(tbl.getL("WIDTH"));
            }
            if (tbl.containsKey("HEIGHT")) {
                this.setHeight(tbl.getL("HEIGHT"));
            }
            for (Table t : JnlpFile.getTables(tbl, "ARGUMENT")) {
                this.getParams().put(t.getS("NAME"), t.getS("VALUE"));
            }
        }

        public JnlpAppletDesc(String mainClass, String name, int width, int height) {
            super("applet-desc");
            this.setMainClass(mainClass);
            this.setName(name);
            this.setWidth(width);
            this.setHeight(height);
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            if (ver >= VERSION_6_0_18) {
                JnlpFile.appendOpenTag(xml, "    ", "applet-desc", new Object[]{"documentbase", this.getDocumentBase(), "main-class", this.getMainClass(), "progress-class", this.getProgressClass(), "name", this.getName(), "width", this.getWidth(), "height", this.getHeight()});
            } else {
                JnlpFile.appendOpenTag(xml, "    ", "applet-desc", new Object[]{"documentbase", this.getDocumentBase(), "main-class", this.getMainClass(), "name", this.getName(), "width", this.getWidth(), "height", this.getHeight()});
            }
            for (Map.Entry<String, String> p : this.getParams().entrySet()) {
                JnlpFile.appendOpenCloseTag(xml, "      ", "param", new Object[]{"name", p.getKey(), "value", p.getValue()});
            }
            return xml.append("    </applet-desc>\n");
        }

        @Override
        public void setProgressClass(String mainClass) {
            super.setProgressClass(mainClass);
        }

        public String getDocumentBase() {
            return this.documentBase;
        }

        public void setDocumentBase(String documentBase) {
            this.documentBase = documentBase;
        }

        @Override
        public void setMainClass(String mainClass) {
            if (mainClass == null) {
                throw new NullPointerException("Main class can not be null.");
            }
            super.setMainClass(mainClass);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new NullPointerException("Name can not be null.");
            }
            this.name = name;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width can not be " + width);
            }
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            if (height <= 0) {
                throw new IllegalArgumentException("Height can not be " + this.width);
            }
            this.height = height;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }

    public static final class JnlpApplicationDesc
    extends JnlpDescElement {
        private final List<String> arguments = new LinkedList<String>();

        public JnlpApplicationDesc() {
            super("application-desc");
        }

        JnlpApplicationDesc(Table tbl) {
            super("application-desc", tbl);
            for (String s : JnlpFile.getStrings(tbl, "ARGUMENT")) {
                this.getArguments().add(s);
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            if (ver >= VERSION_6_0_18) {
                JnlpFile.appendOpenTag(xml, "    ", "application-desc", new Object[]{"main-class", this.getMainClass(), "progress-class", this.getProgressClass()});
            } else {
                JnlpFile.appendOpenTag(xml, "    ", "application-desc", new Object[]{"main-class", this.getMainClass()});
            }
            for (String a : this.getArguments()) {
                xml.append("      <argument>").append(a).append("</argument>\n");
            }
            return xml.append("    </application-desc>\n");
        }

        @Override
        public void setMainClass(String mainClass) {
            super.setMainClass(mainClass);
        }

        @Override
        public void setProgressClass(String mainClass) {
            super.setProgressClass(mainClass);
        }

        public List<String> getArguments() {
            return this.arguments;
        }
    }

    public static final class JnlpInstallerDesc
    extends JnlpDescElement {
        public JnlpInstallerDesc() {
            super("installer-desc");
        }

        JnlpInstallerDesc(Table tbl) {
            super("installer-desc", tbl);
        }
    }

    public static final class JnlpComponentDesc
    extends JnlpDescElement {
        public JnlpComponentDesc() {
            super("component-desc");
        }

        JnlpComponentDesc(Table tbl) {
            super("component-desc", tbl);
        }

        @Override
        public void setProgressClass(String mainClass) {
            super.setProgressClass(mainClass);
        }
    }

    public static abstract class JnlpDescElement
    extends JnlpElement {
        private final String tag;
        private String mainClass;
        private String progressClass;

        JnlpDescElement(String tag) {
            this.tag = tag;
        }

        JnlpDescElement(String tag, Table tbl) {
            this(tag);
            this.setMainClass(tbl.getS("MAIN-CLASS"));
            this.setProgressClass(tbl.getS("PROGRESS-CLASS"));
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            if (ver >= VERSION_6_0_18) {
                return JnlpFile.appendOpenCloseTag(xml, "  ", this.tag, new Object[]{"main-class", this.getMainClass(), "progress-class", this.getProgressClass()});
            }
            return JnlpFile.appendOpenCloseTag(xml, "  ", this.tag, new Object[]{"main-class", this.getMainClass()});
        }

        public String getMainClass() {
            return this.mainClass;
        }

        protected void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public String getProgressClass() {
            return this.progressClass;
        }

        protected void setProgressClass(String progressClass) {
            this.progressClass = progressClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mainClass == null ? 0 : this.mainClass.hashCode());
            result = 31 * result + (this.progressClass == null ? 0 : this.progressClass.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JnlpDescElement other = (JnlpDescElement)obj;
            if (this.mainClass == null ? other.mainClass != null : !this.mainClass.equals(other.mainClass)) {
                return false;
            }
            if (this.progressClass == null ? other.progressClass != null : !this.progressClass.equals(other.progressClass)) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }

    public static final class JnlpPackage
    extends JnlpElement {
        private String name;
        private String part;
        private Boolean recursive;

        public JnlpPackage(String name, String part) {
            this.setName(name);
            this.setPart(part);
        }

        JnlpPackage(Table tbl) {
            this.setName(tbl.getS("NAME"));
            this.setPart(tbl.getS("PART"));
            if (tbl.containsKey("RECURSIVE")) {
                this.setRecursive(tbl.getState("RECURSIVE"));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            return JnlpFile.appendOpenCloseTag(xml, "    ", "package", new Object[]{"name", this.getName(), "part", this.getPart(), "recursive", this.isRecursive()});
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new NullPointerException("Name can not be null");
            }
            this.name = name;
        }

        public String getPart() {
            return this.part;
        }

        public void setPart(String part) {
            if (part == null) {
                throw new NullPointerException("Part can not be null");
            }
            this.part = part;
        }

        public Boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
            result = 31 * result + (this.recursive == null ? 0 : this.recursive.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JnlpPackage other = (JnlpPackage)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.part == null ? other.part != null : !this.part.equals(other.part)) {
                return false;
            }
            return !(this.recursive == null ? other.recursive != null : !this.recursive.equals(other.recursive));
        }
    }

    public static final class JnlpExtDownload
    extends JnlpElement {
        private String extPart;
        private JnlpDownload download;
        private String part;

        public JnlpExtDownload(String extPart) {
            this.setExtPart(extPart);
        }

        JnlpExtDownload(Table tbl) {
            this.setExtPart(tbl.getS("EXT-PART"));
            this.setDownload(tbl.getS("DOWNLOAD"));
            this.setPart(tbl.getS("PART"));
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            return JnlpFile.appendOpenCloseTag(xml, "          ", "ext-download", new Object[]{"ext-part", this.getExtPart(), "download", this.getDownload(), "part", this.getPart()});
        }

        public String getExtPart() {
            return this.extPart;
        }

        public void setExtPart(String extPart) {
            if (extPart == null) {
                throw new NullPointerException("ext-part can not be null");
            }
            this.extPart = extPart;
        }

        public JnlpDownload getDownload() {
            return this.download;
        }

        public void setDownload(JnlpDownload download) {
            this.download = download;
        }

        public final void setDownload(String download) {
            this.setDownload(JnlpDownload.parse(download));
        }

        public String getPart() {
            return this.part;
        }

        public void setPart(String part) {
            this.part = part;
        }
    }

    public static final class JnlpExtension
    extends JnlpElement2 {
        private final List<JnlpExtDownload> extDownload = new LinkedList<JnlpExtDownload>();
        private String name;

        public JnlpExtension(String href) {
            super(href);
        }

        JnlpExtension(Table tbl) {
            super(tbl);
            this.setName(tbl.getS("NAME"));
            for (Table t : JnlpFile.getTables(tbl, "EXT-DOWNLOAD")) {
                this.getExtDownload().add(new JnlpExtDownload(t));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            JnlpFile.appendOpenTag(xml, "        ", "extension", new Object[]{"version", this.getVersion(), "name", this.getName(), "href", this.getHref()});
            for (JnlpExtDownload d : this.getExtDownload()) {
                d.appendXML(xml, ver);
            }
            xml.append("        </extension>\n");
            return xml;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<JnlpExtDownload> getExtDownload() {
            return this.extDownload;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.extDownload == null ? 0 : this.extDownload.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JnlpExtension other = (JnlpExtension)obj;
            if (this.extDownload == null ? other.extDownload != null : !this.extDownload.equals(other.extDownload)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static final class JnlpNativeLib
    extends AbstractJnlpJar {
        public JnlpNativeLib(String href) {
            super("nativelib", href);
        }

        JnlpNativeLib(Table tbl) {
            super("nativelib", tbl);
        }
    }

    public static final class JnlpJar
    extends AbstractJnlpJar {
        public JnlpJar(String href) {
            super("jar", href);
        }

        JnlpJar(Table tbl) {
            super("jar", tbl);
        }

        @Override
        public Boolean isMain() {
            return super.isMain();
        }

        @Override
        public void setMain(Boolean main) {
            super.setMain(main);
        }
    }

    public static abstract class AbstractJnlpJar
    extends JnlpElement2 {
        private final String tag;
        private Boolean main;
        private JnlpDownload download;
        private String part;

        protected AbstractJnlpJar(String tag, String href) {
            super(href);
            this.tag = tag;
        }

        AbstractJnlpJar(String tag, Table tbl) {
            super(tbl);
            this.tag = tag;
            if (tbl.containsKey("MAIN")) {
                this.setMain(tbl.getState("MAIN"));
            }
            if (tbl.containsKey("PART")) {
                this.setPart(tbl.getS("PART"));
            }
            if (tbl.containsKey("DOWNLOAD")) {
                this.setDownload(tbl.getS("DOWNLOAD"));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            JnlpDownload tmpDownload = this.getDownload();
            if (tmpDownload == JnlpDownload.progress && ver < VERSION_6_0_18) {
                tmpDownload = null;
            }
            return JnlpFile.appendOpenCloseTag(xml, "    ", this.tag, new Object[]{"href", this.getHref(), "version", this.getVersion(), "main", this.isMain(), "download", tmpDownload, "size", this.getSize(), "part", this.getPart()});
        }

        @Override
        public Integer getSize() {
            return super.getSize();
        }

        @Override
        public void setSize(Integer size) {
            super.setSize(size);
        }

        protected Boolean isMain() {
            return this.main;
        }

        protected void setMain(Boolean main) {
            this.main = main;
        }

        public JnlpDownload getDownload() {
            return this.download;
        }

        public void setDownload(JnlpDownload download) {
            this.download = download;
        }

        public final void setDownload(String download) {
            this.setDownload(JnlpDownload.parse(download));
        }

        public String getPart() {
            return this.part;
        }

        public void setPart(String part) {
            this.part = part;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.download == null ? 0 : this.download.hashCode());
            result = 31 * result + (this.main == null ? 0 : this.main.hashCode());
            result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractJnlpJar other = (AbstractJnlpJar)obj;
            if (this.download != other.download) {
                return false;
            }
            if (this.main == null ? other.main != null : !this.main.equals(other.main)) {
                return false;
            }
            if (this.part == null ? other.part != null : !this.part.equals(other.part)) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }

    public static final class JnlpJava
    extends AbstractJnlpJ2SE {
        public JnlpJava() {
            super("java");
        }

        JnlpJava(Table tbl) {
            super("java", tbl);
        }

        public JnlpJava(String ver, String initialHeap, String maxHeap) {
            super("java", ver, initialHeap, maxHeap);
        }
    }

    public static final class JnlpJ2SE
    extends AbstractJnlpJ2SE {
        public JnlpJ2SE() {
            super("j2se");
        }

        JnlpJ2SE(Table tbl) {
            super("j2se", tbl);
        }

        public JnlpJ2SE(String ver, String initialHeap, String maxHeap) {
            super("j2se", ver, initialHeap, maxHeap);
        }
    }

    public static class AbstractJnlpJ2SE
    extends JnlpElement {
        private final String tag;
        private String version;
        private String href;
        private String initialHeapSize;
        private String maxHeapSize;
        private String vmArgs;
        private JnlpResources resources;

        AbstractJnlpJ2SE(String tag) {
            this.tag = tag;
        }

        AbstractJnlpJ2SE(String tag, String ver, String initialHeap, String maxHeap) {
            this.tag = tag;
            this.setVersion(ver);
            this.setHref("http://java.sun.com/products/autodl/j2se");
            this.setInitialHeapSize(initialHeap);
            this.setMaxHeapSize(maxHeap);
        }

        AbstractJnlpJ2SE(String tag, Table tbl) {
            this(tag);
            this.setVersion(tbl.getS("VERSION"));
            this.setHref(tbl.getS("HREF"));
            this.setInitialHeapSize(tbl.getS("INITIAL-HEAP-SIZE"));
            this.setMaxHeapSize(tbl.getS("MAX-HEAP-SIZE"));
            this.setVMArgs(tbl.getS("VM-ARGS"));
            if (tbl.containsKey("RESOURCES")) {
                this.setResources(new JnlpResources(tbl.getTable("RESOURCES")));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            String _tag = this.tag;
            if (ver < VERSION_6 && !this.tag.equals("j2se")) {
                _tag = "j2se";
            }
            JnlpFile.appendOpenTag(xml, "    ", _tag, new Object[]{"version", this.getVersion(), "href", this.getHref(), "initial-heap-size", this.getInitialHeapSize(), "max-heap-size", this.getMaxHeapSize(), "vm-args", this.getVMArgs()});
            if (this.getResources() != null) {
                this.getResources().appendXML(xml, ver);
            }
            xml.append("    </").append(this.tag).append(">\n");
            return xml;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getInitialHeapSize() {
            return this.initialHeapSize;
        }

        public void setInitialHeapSize(String initialHeapSize) {
            this.initialHeapSize = initialHeapSize;
        }

        public String getMaxHeapSize() {
            return this.maxHeapSize;
        }

        public void setMaxHeapSize(String maxHeapSize) {
            this.maxHeapSize = maxHeapSize;
        }

        public String getVMArgs() {
            return this.vmArgs;
        }

        public void setVMArgs(String vmArgs) {
            this.vmArgs = vmArgs;
        }

        public JnlpResources getResources() {
            return this.resources;
        }

        public void setResources(JnlpResources resources) {
            this.resources = resources;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
            result = 31 * result + (this.initialHeapSize == null ? 0 : this.initialHeapSize.hashCode());
            result = 31 * result + (this.maxHeapSize == null ? 0 : this.maxHeapSize.hashCode());
            result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + (this.vmArgs == null ? 0 : this.vmArgs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractJnlpJ2SE other = (AbstractJnlpJ2SE)obj;
            if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
                return false;
            }
            if (this.initialHeapSize == null ? other.initialHeapSize != null : !this.initialHeapSize.equals(other.initialHeapSize)) {
                return false;
            }
            if (this.maxHeapSize == null ? other.maxHeapSize != null : !this.maxHeapSize.equals(other.maxHeapSize)) {
                return false;
            }
            if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
                return false;
            }
            if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
                return false;
            }
            if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
                return false;
            }
            return !(this.vmArgs == null ? other.vmArgs != null : !this.vmArgs.equals(other.vmArgs));
        }
    }

    public static final class JnlpResources
    extends JnlpElement {
        private String os;
        private String arch;
        private String locale;
        private final List<AbstractJnlpJ2SE> java = new LinkedList<AbstractJnlpJ2SE>();
        private final List<AbstractJnlpJar> jars = new LinkedList<AbstractJnlpJar>();
        private final List<JnlpExtension> extensions = new LinkedList<JnlpExtension>();
        private final Map<String, String> properties = new LinkedHashMap<String, String>();
        private final List<JnlpPackage> packages = new LinkedList<JnlpPackage>();

        public JnlpResources() {
        }

        JnlpResources(Table tbl) {
            this.setOS(tbl.getS("OS"));
            this.setArch(tbl.getS("ARCH"));
            this.setLocale(tbl.getS("LOCALE"));
            for (Table t : JnlpFile.getTables(tbl, "JAVA")) {
                this.getJava().add(new JnlpJava(t));
            }
            for (Table t : JnlpFile.getTables(tbl, "J2SE")) {
                this.getJava().add(new JnlpJ2SE(t));
            }
            for (Table t : JnlpFile.getTables(tbl, "JAR")) {
                this.getJars().add(new JnlpJar(t));
            }
            for (Table t : JnlpFile.getTables(tbl, "EXTENSION")) {
                this.getExtensions().add(new JnlpExtension(t));
            }
            for (Table t : JnlpFile.getTables(tbl, "PACKAGE")) {
                this.getPackages().add(new JnlpPackage(t));
            }
            for (Table t : JnlpFile.getTables(tbl, "PROPERTY")) {
                String name = t.getS("NAME");
                String value = t.getS("VALUE");
                this.getProperties().put(name, value);
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            JnlpFile.appendOpenTag(xml, "  ", "resources", new Object[]{"os", this.getOS(), "arch", this.getArch(), "locale", this.getLocale()});
            for (AbstractJnlpJ2SE abstractJnlpJ2SE : this.getJava()) {
                abstractJnlpJ2SE.appendXML(xml, ver);
            }
            for (AbstractJnlpJar abstractJnlpJar : this.getJars()) {
                abstractJnlpJar.appendXML(xml, ver);
            }
            for (JnlpPackage jnlpPackage : this.getPackages()) {
                jnlpPackage.appendXML(xml, ver);
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                JnlpFile.appendOpenCloseTag(xml, "    ", "property", new Object[]{"name", entry.getKey(), "value", entry.getValue()});
            }
            xml.append("  </resources>\n");
            return xml;
        }

        public String getOS() {
            return this.os;
        }

        public void setOS(String os) {
            this.os = os;
        }

        public String getArch() {
            return this.arch;
        }

        public void setArch(String arch) {
            this.arch = arch;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public List<AbstractJnlpJar> getJars() {
            return this.jars;
        }

        public List<AbstractJnlpJ2SE> getJava() {
            return this.java;
        }

        public List<JnlpExtension> getExtensions() {
            return this.extensions;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public List<JnlpPackage> getPackages() {
            return this.packages;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
            result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
            result = 31 * result + (this.jars == null ? 0 : this.jars.hashCode());
            result = 31 * result + (this.java == null ? 0 : this.java.hashCode());
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
            result = 31 * result + (this.packages == null ? 0 : this.packages.hashCode());
            result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JnlpResources other = (JnlpResources)obj;
            if (this.arch == null ? other.arch != null : !this.arch.equals(other.arch)) {
                return false;
            }
            if (this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions)) {
                return false;
            }
            if (this.jars == null ? other.jars != null : !this.jars.equals(other.jars)) {
                return false;
            }
            if (this.java == null ? other.java != null : !this.java.equals(other.java)) {
                return false;
            }
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
                return false;
            }
            if (this.packages == null ? other.packages != null : !this.packages.equals(other.packages)) {
                return false;
            }
            return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
        }
    }

    public static final class JnlpIcon
    extends JnlpElement2 {
        private Integer width;
        private Integer height;
        private JnlpIconKind kind;
        private Integer depth;

        public JnlpIcon(String href, String version) {
            super(href);
            this.setVersion(version);
        }

        JnlpIcon(Table tbl) {
            super(tbl);
            this.setKind(tbl.getS("KIND"));
            if (tbl.containsKey("WIDTH")) {
                this.setWidth(tbl.getL("WIDTH"));
            }
            if (tbl.containsKey("HEIGHT")) {
                this.setHeight(tbl.getL("HEIGHT"));
            }
            if (tbl.containsKey("DEPTH")) {
                this.setDepth(tbl.getL("DEPTH"));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            return JnlpFile.appendOpenCloseTag(xml, "        ", "icon", new Object[]{"href", this.getHref(), "version", this.getVersion(), "width", this.getWidth(), "height", this.getHeight(), "kind", this.getKind(), "depth", this.getDepth(), "size", this.getSize()});
        }

        @Override
        public void setVersion(String version) {
            if (version == null) {
                throw new NullPointerException("Version can not be null.");
            }
            super.setVersion(version);
        }

        @Override
        public Integer getSize() {
            return super.getSize();
        }

        @Override
        public void setSize(Integer size) {
            super.setSize(size);
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public JnlpIconKind getKind() {
            return this.kind;
        }

        public void setKind(JnlpIconKind kind) {
            this.kind = kind;
        }

        public void setKind(String kind) {
            this.setKind(JnlpIconKind.parse(kind));
        }

        public Integer getDepth() {
            return this.depth;
        }

        public void setDepth(Integer depth) {
            this.depth = depth;
        }
    }

    public static final class JnlpInformation
    extends JnlpElement {
        private String os;
        private String arch;
        private String platform;
        private String locale;
        private String title;
        private String vendor;
        private String homepage;
        private String description;
        private String descriptionOneLine;
        private String descriptionShort;
        private String descriptionTooltip;
        private final List<JnlpIcon> icons = new LinkedList<JnlpIcon>();
        private boolean offlineAllowed;
        private Boolean shortcutOnline;
        private Boolean shortcutInstall;
        private boolean shortcutDesktop;
        private boolean shortcutMenu;
        private String shortcutSubMenu;
        private final List<JnlpAssociation> associations = new LinkedList<JnlpAssociation>();
        private final List<JnlpRelatedContent> relatedContent = new LinkedList<JnlpRelatedContent>();

        public JnlpInformation(String title, String vendor, String homepage) {
            this.setTitle(title);
            this.setVendor(vendor);
            this.setHomepage(homepage);
        }

        JnlpInformation(Table tbl) {
            this(tbl.getS("TITLE"), tbl.getS("VENDOR"), tbl.getS("HOMEPAGE.HREF"));
            this.setOS(tbl.getS("OS"));
            this.setArch(tbl.getS("ARCH"));
            this.setPlatform(tbl.getS("PLATFORM"));
            this.setLocale(tbl.getS("LOCALE"));
            this.setDescription(null);
            this.setDescriptionShort(null);
            this.setDescriptionOneLine(null);
            this.setDescriptionTooltip(null);
            this.setOfflineAllowed(tbl.containsKey("OFFLINE-ALLOWED"));
            this.setShortcutOnline(null);
            this.setShortcutDesktop(false);
            this.setShortcutMenu(false);
            this.setShortcutSubMenu(null);
            for (Table t : JnlpFile.getTables(tbl, "DESCRIPTION")) {
                String kind = t.getS("KIND", null);
                String cdata = t.getS("#CDATA#", "");
                if (kind == null) {
                    this.setDescription(cdata);
                    continue;
                }
                if (kind.equals("short")) {
                    this.setDescriptionShort(cdata);
                    continue;
                }
                if (kind.equals("one-line")) {
                    this.setDescriptionOneLine(cdata);
                    continue;
                }
                if (!kind.equals("tooltip")) continue;
                this.setDescriptionTooltip(cdata);
            }
            Table s = tbl.getTable("SHORTCUT");
            if (s != null) {
                this.setShortcutOnline(s.getState("ONLINE"));
                this.setShortcutInstall(s.getState("INSTALL"));
                this.setShortcutDesktop(s.containsKey("DESKTOP"));
                this.setShortcutMenu(s.containsKey("MENU"));
                this.setShortcutSubMenu(s.getS("MENU.SUBMENU"));
            }
            this.getIcons().clear();
            for (Table t : JnlpFile.getTables(tbl, "ICON")) {
                this.getIcons().add(new JnlpIcon(t));
            }
            this.getAssociations().clear();
            for (Table t : JnlpFile.getTables(tbl, "ASSOCIATION")) {
                this.getAssociations().add(new JnlpAssociation(t));
            }
            this.getRelatedContent().clear();
            for (Table t : JnlpFile.getTables(tbl, "RELATED-CONTENT")) {
                this.getRelatedContent().add(new JnlpRelatedContent(t));
            }
        }

        @Override
        public StringBuilder appendXML(StringBuilder xml, int ver) {
            if (ver >= VERSION_1_5) {
                JnlpFile.appendOpenTag(xml, "  ", "information", new Object[]{"os", this.getOS(), "arch", this.getArch(), "platform", this.getPlatform(), "locale", this.getLocale()});
            } else {
                JnlpFile.appendOpenTag(xml, "  ", "information", new Object[0]);
            }
            JnlpFile.appendElement(xml, "    <title>", this.getTitle(), "</title>\n");
            JnlpFile.appendElement(xml, "    <vendor>", this.getVendor(), "</vendor>\n");
            JnlpFile.appendElement(xml, "    <homepage href='", this.getHomepage(), "'/>\n");
            JnlpFile.appendElement(xml, "    <description>", this.getDescription(), "</description>\n");
            JnlpFile.appendElement(xml, "    <description kind='one-line'>", this.getDescriptionOneLine(), "</description>\n");
            JnlpFile.appendElement(xml, "    <description kind='short'>", this.getDescriptionShort(), "</description>\n");
            JnlpFile.appendElement(xml, "    <description kind='tooltip'>", this.getDescriptionTooltip(), "</description>\n");
            for (JnlpIcon i : this.getIcons()) {
                i.appendXML(xml, ver);
            }
            if (this.isOfflineAllowed()) {
                xml.append("    <offline-allowed/>\n");
            }
            if (ver >= VERSION_1_5) {
                if (this.isShortcutDesktop() || this.isShortcutMenu()) {
                    Boolean shortcutInstall = ver >= VERSION_7 ? this.getShortcutInstall() : null;
                    JnlpFile.appendOpenTag(xml, "    ", "shortcut", new Object[]{"online", this.getShortcutOnline(), "install", shortcutInstall});
                    if (this.isShortcutDesktop()) {
                        JnlpFile.appendOpenCloseTag(xml, "      ", "desktop", new Object[0]);
                    }
                    if (this.isShortcutMenu()) {
                        JnlpFile.appendOpenCloseTag(xml, "      ", "menu", new Object[]{"submenu", this.getShortcutSubMenu()});
                    }
                    xml.append("    </shortcut>\n");
                }
                for (JnlpAssociation a : this.getAssociations()) {
                    a.appendXML(xml, ver);
                }
                for (JnlpRelatedContent r : this.getRelatedContent()) {
                    r.appendXML(xml, ver);
                }
            }
            xml.append("  </information>\n");
            return xml;
        }

        public String getOS() {
            return this.os;
        }

        public void setOS(String os) {
            this.os = os;
        }

        public String getArch() {
            return this.arch;
        }

        public void setArch(String arch) {
            this.arch = arch;
        }

        public String getPlatform() {
            return this.platform;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            if (title == null) {
                throw new NullPointerException("Title can not be null.");
            }
            this.title = title;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            if (vendor == null) {
                throw new NullPointerException("Vendor can not be null.");
            }
            this.vendor = vendor;
        }

        public String getHomepage() {
            return this.homepage;
        }

        public void setHomepage(String homepage) {
            if (homepage == null) {
                throw new NullPointerException("Homepage can not be null.");
            }
            this.homepage = homepage;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setDescriptionOneLine(String descr) {
            this.descriptionOneLine = descr;
        }

        public String getDescriptionOneLine() {
            return this.descriptionOneLine;
        }

        public void setDescriptionShort(String descr) {
            this.descriptionShort = descr;
        }

        public String getDescriptionShort() {
            return this.descriptionShort;
        }

        public void setDescriptionTooltip(String descr) {
            this.descriptionTooltip = descr;
        }

        public String getDescriptionTooltip() {
            return this.descriptionTooltip;
        }

        public List<JnlpIcon> getIcons() {
            return this.icons;
        }

        public List<JnlpAssociation> getAssociations() {
            return this.associations;
        }

        public List<JnlpRelatedContent> getRelatedContent() {
            return this.relatedContent;
        }

        public boolean isOfflineAllowed() {
            return this.offlineAllowed;
        }

        public void setOfflineAllowed(boolean allowed) {
            this.offlineAllowed = allowed;
        }

        public boolean isShortcutOnline() {
            return this.shortcutOnline;
        }

        public void setShortcutOnline(boolean online) {
            this.shortcutOnline = online;
        }

        public boolean isShortcutDesktop() {
            return this.shortcutDesktop;
        }

        public void setShortcutDesktop(boolean desktop) {
            this.shortcutDesktop = desktop;
        }

        public boolean isShortcutMenu() {
            return this.shortcutMenu;
        }

        public void setShortcutMenu(boolean menu) {
            this.shortcutMenu = menu;
        }

        public String getShortcutSubMenu() {
            return this.shortcutSubMenu;
        }

        public void setShortcutSubMenu(String submenu) {
            this.shortcutSubMenu = submenu;
        }

        public Boolean getShortcutOnline() {
            return this.shortcutOnline;
        }

        public void setShortcutOnline(Boolean online) {
            this.shortcutOnline = online;
        }

        public Boolean getShortcutInstall() {
            return this.shortcutInstall;
        }

        public void setShortcutInstall(Boolean val) {
            this.shortcutInstall = val;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
            result = 31 * result + (this.associations == null ? 0 : this.associations.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.descriptionOneLine == null ? 0 : this.descriptionOneLine.hashCode());
            result = 31 * result + (this.descriptionShort == null ? 0 : this.descriptionShort.hashCode());
            result = 31 * result + (this.descriptionTooltip == null ? 0 : this.descriptionTooltip.hashCode());
            result = 31 * result + (this.homepage == null ? 0 : this.homepage.hashCode());
            result = 31 * result + (this.icons == null ? 0 : this.icons.hashCode());
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.offlineAllowed ? 1231 : 1237);
            result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
            result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
            result = 31 * result + (this.relatedContent == null ? 0 : this.relatedContent.hashCode());
            result = 31 * result + (this.shortcutDesktop ? 1231 : 1237);
            result = 31 * result + (this.shortcutMenu ? 1231 : 1237);
            result = 31 * result + (this.shortcutOnline == null ? 0 : this.shortcutOnline.hashCode());
            result = 31 * result + (this.shortcutInstall == null ? 0 : this.shortcutInstall.hashCode());
            result = 31 * result + (this.shortcutSubMenu == null ? 0 : this.shortcutSubMenu.hashCode());
            result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
            result = 31 * result + (this.vendor == null ? 0 : this.vendor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JnlpInformation other = (JnlpInformation)obj;
            if (this.arch == null ? other.arch != null : !this.arch.equals(other.arch)) {
                return false;
            }
            if (this.associations == null ? other.associations != null : !this.associations.equals(other.associations)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.descriptionOneLine == null ? other.descriptionOneLine != null : !this.descriptionOneLine.equals(other.descriptionOneLine)) {
                return false;
            }
            if (this.descriptionShort == null ? other.descriptionShort != null : !this.descriptionShort.equals(other.descriptionShort)) {
                return false;
            }
            if (this.descriptionTooltip == null ? other.descriptionTooltip != null : !this.descriptionTooltip.equals(other.descriptionTooltip)) {
                return false;
            }
            if (this.homepage == null ? other.homepage != null : !this.homepage.equals(other.homepage)) {
                return false;
            }
            if (this.icons == null ? other.icons != null : !this.icons.equals(other.icons)) {
                return false;
            }
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            if (this.offlineAllowed != other.offlineAllowed) {
                return false;
            }
            if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
                return false;
            }
            if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
                return false;
            }
            if (this.relatedContent == null ? other.relatedContent != null : !this.relatedContent.equals(other.relatedContent)) {
                return false;
            }
            if (this.shortcutDesktop != other.shortcutDesktop) {
                return false;
            }
            if (this.shortcutMenu != other.shortcutMenu) {
                return false;
            }
            if (this.shortcutOnline == null ? other.shortcutOnline != null : !this.shortcutOnline.equals(other.shortcutOnline)) {
                return false;
            }
            if (this.shortcutInstall == null ? other.shortcutInstall != null : !this.shortcutInstall.equals(other.shortcutInstall)) {
                return false;
            }
            if (this.shortcutSubMenu == null ? other.shortcutSubMenu != null : !this.shortcutSubMenu.equals(other.shortcutSubMenu)) {
                return false;
            }
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return !(this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor));
        }
    }

    public static abstract class DescribedJnlpElement
    extends JnlpElement {
        private String description;
        private JnlpDescriptionKind descriptionKind;
        private JnlpIcon icon;

        DescribedJnlpElement() {
        }

        DescribedJnlpElement(Table tbl) {
            if (tbl.containsKey("DESCRIPTION")) {
                if (tbl.containsKey("DESCRIPTION.#CDATA#")) {
                    this.setDescription(tbl.getS("DESCRIPTION.#CDATA#"), tbl.getS("DESCRIPTION.KIND"));
                } else {
                    this.setDescription(tbl.getS("DESCRIPTION"));
                }
            }
            if (tbl.containsKey("ICON")) {
                this.setIcon(new JnlpIcon(tbl.getTable("ICON")));
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setDescription(String descr, JnlpDescriptionKind kind) {
            this.description = descr;
            this.descriptionKind = kind;
        }

        public JnlpDescriptionKind getDescriptionKind() {
            return this.descriptionKind;
        }

        public void setDescriptionKind(JnlpDescriptionKind kind) {
            this.descriptionKind = kind;
        }

        public final void setDescription(String descr, String kind) {
            this.setDescription(descr, JnlpDescriptionKind.parse(kind));
        }

        public final void setDescriptionKind(String kind) {
            this.setDescriptionKind(JnlpDescriptionKind.parse(kind));
        }

        public JnlpIcon getIcon() {
            return this.icon;
        }

        public void setIcon(JnlpIcon icon) {
            this.icon = icon;
        }
    }

    public static abstract class JnlpElement2
    extends JnlpElement {
        private String href;
        private String version;
        private Integer size;

        JnlpElement2(String href) {
            this.setHref(href);
        }

        JnlpElement2(Table tbl) {
            this.setHref(tbl.getS("HREF"));
            this.setVersion(tbl.getS("VERSION"));
            if (tbl.containsKey("SIZE")) {
                this.setSize(tbl.getL("SIZE"));
            }
        }

        public final String getHref() {
            return this.href;
        }

        public final void setHref(String href) {
            if (href == null) {
                throw new NullPointerException("HREF can not be null.");
            }
            this.href = href;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        protected Integer getSize() {
            return this.size;
        }

        protected void setSize(Integer size) {
            this.size = size;
        }

        protected void setSize(Number size) {
            this.size = size == null ? null : Integer.valueOf(size.intValue());
        }
    }

    public static abstract class JnlpElement {
        JnlpElement() {
        }

        public abstract StringBuilder appendXML(StringBuilder var1, int var2);

        public String toString() {
            return this.appendXML(new StringBuilder(), VERSION_LATEST).toString();
        }
    }

    public static enum JnlpDescriptionKind {
        one_line,
        brief,
        tooltip;


        public String toString() {
            if (this == brief) {
                return "short";
            }
            return super.name().replace('_', '-');
        }

        public static JnlpDescriptionKind parse(String s) {
            if ("".equals("short")) {
                return brief;
            }
            return s == null ? null : JnlpDescriptionKind.valueOf(s);
        }
    }

    public static enum JnlpIconKind {
        splash;


        public static JnlpIconKind parse(String s) {
            return s == null ? null : JnlpIconKind.valueOf(s);
        }
    }

    public static enum JnlpUpdatePolicy {
        always,
        prompt_update,
        prompt_run;


        public String toString() {
            return super.name().replace('_', '-');
        }

        public static JnlpUpdatePolicy parse(String s) {
            return s == null ? null : JnlpUpdatePolicy.valueOf(s);
        }
    }

    public static enum JnlpUpdateCheck {
        always,
        timeout,
        background;


        public static JnlpUpdateCheck parse(String s) {
            return s == null ? null : JnlpUpdateCheck.valueOf(s);
        }
    }

    public static enum JnlpDownload {
        eager,
        lazy,
        progress;


        public static JnlpDownload parse(String s) {
            return s == null ? null : JnlpDownload.valueOf(s);
        }
    }
}

