/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.ImageFileModSwapInterface;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

public class ImageFile
extends BaseFile
implements ImageFileModSwapInterface {
    public final String propertyList = "Name,Size,Comment,Qualifiers,XStart,XDelta,XUnits,XFrame,YStart,YDelta,YUnits,YFrame";
    private double xstart = 0.0;
    private double ystart = 0.0;
    private double xdelta = Double.NaN;
    private double ydelta = Double.NaN;
    private int xunits = 0;
    private int yunits = 0;
    private int xframe = 1;
    private int yframe = 1;
    private double timecode = 0.0;
    private String format = "UNK";
    private InputStream inputStream = null;
    private ImageInputStream iis = null;
    private ImageReader imageReader = null;
    private IIOMetadata metadata = null;

    public ImageFile() {
    }

    @Deprecated
    public ImageFile(Object ref, Object filename) {
        if (ref instanceof MidasReference) {
            this.init((MidasReference)ref, filename);
        } else {
            this.init(Convert.ref2Midas(ref), filename);
        }
    }

    public ImageFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public String getMimeType() {
        String fmt = this.getFormat();
        if (fmt != null) {
            if ((fmt = fmt.toLowerCase()).equals("gif")) {
                return "image/gif";
            }
            if (fmt.equals("jpg")) {
                return "image/jpeg";
            }
            if (fmt.equals("jpeg")) {
                return "image/jpeg";
            }
            if (fmt.equals("png")) {
                return "image/png";
            }
            if (fmt.equals("tif")) {
                return "image/tiff";
            }
            if (fmt.equals("tiff")) {
                return "image/tiff";
            }
            if (fmt.equals("bmp")) {
                return "image/bmp";
            }
            if (fmt.equals("wbmp")) {
                return "image/vnd.wap.wbmp";
            }
            if (fmt.equals("pdf")) {
                return "application/pdf";
            }
        }
        return super.getMimeType();
    }

    @Override
    @ProvisionalUseOnly(value="API may be removed at a later date")
    public void setName(MidasReference ref, Object filename) {
        this.M = Convert.ref2Midas(ref);
        if (ref != null && this.M != null && this.M.isJavaBehavior()) {
            this.flags |= 0x80000;
        }
        this.setName(filename);
    }

    @Override
    public void setName(Object filename) {
        super.setName(filename);
        this.format = this.getFileName().getExt().toUpperCase();
        this.comment = (String)this.getQualifier("COMMENT");
    }

    @Override
    public boolean open() {
        super.open();
        if (this.isOpen && this.isInput) {
            try {
                this.inputStream = this.io.getInputStream();
                this.iis = ImageIO.createImageInputStream(this.inputStream);
                Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(this.iis);
                if (!imageReaders.hasNext()) {
                    Object[] formats = ImageIO.getReaderFormatNames();
                    throw new MidasException("No appropriate image reader found for " + this.getName() + " supported types are " + StringUtil.join(formats) + ". It is also possible the file is corrupt and non-readable.");
                }
                this.imageReader = imageReaders.next();
                this.imageReader.setInput(this.iis, false, false);
                this.metadata = this.imageReader.getImageMetadata(0);
                this.format = this.imageReader.getFormatName();
                int width = this.imageReader.getWidth(0);
                int height = this.imageReader.getHeight(0);
                this.setXFrame(width);
                if (Double.isNaN(this.xdelta)) {
                    this.setXDelta(1.0 / (double)width);
                }
                this.setYFrame(height);
                if (Double.isNaN(this.ydelta)) {
                    this.setYDelta(-1.0 / (double)height);
                }
                this.io.seek(0L);
            }
            catch (Exception e) {
                this.close();
                if ((this.flags & 0x20) != 0) {
                    return this.isOpen;
                }
                if (e instanceof MidasException) {
                    throw (MidasException)e;
                }
                throw new MidasException("Unable to read " + this.getName(), e);
            }
        }
        return this.isOpen;
    }

    @Override
    public void close() {
        super.close();
        if (this.imageReader != null) {
            this.imageReader.dispose();
            this.imageReader = null;
        }
        if (this.iis != null) {
            try {
                this.iis.close();
            }
            catch (IOException ioe) {
                this.M.printStackTrace("ImageFile: Unable to close iis " + this.getName(), ioe);
            }
            this.iis = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ioe) {
                this.M.printStackTrace("ImageFile: Unable to close inputStream " + this.getName(), ioe);
            }
            this.inputStream = null;
        }
        this.metadata = null;
    }

    @Override
    public String toString() {
        String str = "Image-" + this.getFormat() + " ";
        if (this.io != null) {
            str = str + this.io.getTypeString();
        }
        str = str + " Resource";
        return str;
    }

    @Override
    public void connect(int mode) {
    }

    @Override
    public Data getDataBuffer(int size) {
        return null;
    }

    @Override
    public int read(Data data, int ndo) {
        return -1;
    }

    public BufferedImage readImage() {
        if (!this.isOpen || !this.isInput) {
            throw new MidasException("Can not read from " + this.getName() + " file has not been opened for input.");
        }
        try {
            return this.imageReader.read(0);
        }
        catch (Exception e) {
            throw new MidasException("Unable to read " + this.getName(), e);
        }
    }

    @Deprecated
    public static void listFormats() {
        Object[] formats = ImageIO.getReaderFormatNames();
        Shell.info("ImageIO current format list: " + StringUtil.join(formats));
    }

    @Override
    public String listHeader() {
        String list3 = "FileName    :  " + this.getURL() + "\nFormat      :  " + this.getFormat() + "\nSize        :  " + this.getSize() + "\nX units     :  " + DataFile.getUnitsName(this.getXUnits()) + "\nX start     :  " + this.getXStart() + "\nX delta     :  " + this.getXDelta() + "\nX frame     :  " + this.getXFrame() + "\nY units     :  " + DataFile.getUnitsName(this.getYUnits()) + "\nY start     :  " + this.getYStart() + "\nY delta     :  " + this.getYDelta() + "\nY frame     :  " + this.getYFrame() + "\nComment     :  " + this.getComment() + "\n";
        return list3;
    }

    public IIOMetadata getImageMetadata() {
        return this.metadata;
    }

    @Override
    public int getType() {
        return 7000;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public double getStart() {
        return this.ystart;
    }

    @Override
    public double getDelta() {
        return this.ydelta;
    }

    @Override
    public int getUnits() {
        return this.yunits;
    }

    @Override
    public double getXStart() {
        return this.xstart;
    }

    @Override
    public double getXDelta() {
        return this.xdelta;
    }

    @Override
    public int getXUnits() {
        return this.xunits;
    }

    @Override
    public int getXFrame() {
        return this.xframe;
    }

    @Override
    public double getYStart() {
        return this.ystart;
    }

    @Override
    public double getYDelta() {
        return this.ydelta;
    }

    @Override
    public int getYUnits() {
        return this.yunits;
    }

    @Override
    public int getYFrame() {
        return this.yframe;
    }

    @Override
    public double getTimeAt(double offset) {
        return this.timecode;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public void setXStart(double value) {
        this.xstart = value;
    }

    public void setXDelta(double value) {
        this.xdelta = value;
    }

    public void setXUnits(int value) {
        this.xunits = value;
    }

    public void setXFrame(int value) {
        this.xframe = value;
    }

    public void setYStart(double value) {
        this.ystart = value;
    }

    public void setYDelta(double value) {
        this.ydelta = value;
    }

    public void setYUnits(int value) {
        this.yunits = value;
    }

    public void setYFrame(int value) {
        this.yframe = value;
    }

    public void setTimeCode(double value) {
        this.timecode = value;
    }
}

