/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.Map;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MapKBT;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Table;

@InternalUseOnly(value="Experimental Prototype in NeXtMidas 4.1.3")
public class GeoJSONObjects {
    private ArrayList<GeoJSONPoint> points = new ArrayList();
    private ArrayList<GeoJSONPolygon> polygons = new ArrayList();
    private ArrayList<GeoJSONLineString> lineStrings = new ArrayList();

    public void addGeoJSONObject(Object obj) {
    }

    void addGeoJSONPoint(String name, double[] coordsPoint, int atomsPerElem, Map properties, GeoJSONGroup group2) {
        this.points.add(new GeoJSONPoint(name, coordsPoint, atomsPerElem, properties, group2));
    }

    void addGeoJSONLineString(String name, double[] coordsLineString, int atomsPerElem, Map properties, GeoJSONGroup group2) {
        this.lineStrings.add(new GeoJSONLineString(name, coordsLineString, atomsPerElem, properties, group2));
    }

    void addGeoJSONPolygon(String name, double[] outerCoordsPoly, int atomsPerElem, Map properties, GeoJSONGroup group2) {
        this.polygons.add(new GeoJSONPolygon(name, outerCoordsPoly, atomsPerElem, properties, group2));
    }

    void addGeoJSONPolygon(String name, double[] outerCoordsPoly, double[][] innerCoordsPoly, int atomsPerElem, Map properties, GeoJSONGroup group2) {
        this.polygons.add(new GeoJSONPolygon(name, outerCoordsPoly, innerCoordsPoly, atomsPerElem, properties, group2));
    }

    @InternalUseOnly
    public ArrayList<GeoJSONPoint> getGeoJSONPoints() {
        return this.points;
    }

    @InternalUseOnly
    public ArrayList<GeoJSONLineString> getGeoJSONLineStrings() {
        return this.lineStrings;
    }

    @InternalUseOnly
    public ArrayList<GeoJSONPolygon> getGeoJSONPolygons() {
        return this.polygons;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (GeoJSONPoint pt : this.points) {
            out.append(pt).append("\n");
        }
        for (GeoJSONPolygon poly : this.polygons) {
            out.append(poly).append("\n");
        }
        for (GeoJSONLineString lineStr : this.lineStrings) {
            out.append(lineStr).append("\n");
        }
        return out.toString();
    }

    @InternalUseOnly
    public static class GeoJSONGroup {
        private ArrayList<GeoJSONObject> objectsInGroup = new ArrayList();
        private String name;
        private String type;

        GeoJSONGroup(String name, String type) {
            this.name = name;
            this.type = type;
        }

        boolean add(GeoJSONObject groupObject) {
            return this.objectsInGroup.add(groupObject);
        }

        boolean remove(GeoJSONObject groupObject) {
            return this.objectsInGroup.remove(groupObject);
        }

        public String toString() {
            StringBuilder stb = new StringBuilder("GroupName=" + this.name + ",GroupType=" + this.type + ",Objects=[");
            for (int i = 0; i < this.objectsInGroup.size(); ++i) {
                stb.append(this.objectsInGroup.get(i).toString() + ",");
            }
            stb.replace(stb.length() - 1, stb.length(), "]");
            return stb.toString();
        }

        public Table toTable() {
            Table groupInnerTable = new Table();
            groupInnerTable.setFlags(groupInnerTable.getFlagsInt() | 1 | 0x40);
            for (GeoJSONObject groupObject : this.objectsInGroup) {
                String oldObjKey = groupObject.getClass().getSimpleName();
                Table objTbl = (Table)groupObject.toTable().get(oldObjKey);
                String objName = groupObject.getName();
                char newObjKey = objName.charAt(objName.length() - 1);
                if (this.type.contains("GeometryCollection")) {
                    objTbl.addIfNotPresent("type", oldObjKey);
                }
                groupInnerTable.addIfNotPresent("" + newObjKey, objTbl);
            }
            Table groupTable = new Table();
            groupTable.setFlags(groupTable.getFlagsInt() | 1 | 0x40);
            groupTable.addIfNotPresent(this.type, groupInnerTable);
            return groupTable;
        }
    }

    @InternalUseOnly
    public class GeoJSONPolygon
    extends GeoJSONFeature {
        private double[][] innerCoords;
        private boolean fill;

        public GeoJSONPolygon() {
            this.innerCoords = null;
            this.fill = false;
        }

        public GeoJSONPolygon(String name, double[] outerCoords, int atomsPerElem, Map properties, GeoJSONGroup group2) {
            super(name, outerCoords, atomsPerElem, properties, group2);
            this.innerCoords = null;
            this.fill = false;
            if (properties != null) {
                this.fill = Convert.o2z(properties.get("fill"));
            }
        }

        public GeoJSONPolygon(String name, double[] outerCoords, double[][] innerCoords, int atomsPerElem, Map properties, GeoJSONGroup group2) {
            this(name, outerCoords, atomsPerElem, properties, group2);
            this.innerCoords = innerCoords;
            if (properties != null) {
                this.fill = Convert.o2z(properties.get("fill"));
            }
        }

        public double[] getOuterBoundary() {
            return this.coords;
        }

        public double[][] getInnerBoundaries() {
            return this.innerCoords;
        }

        public boolean getFill() {
            return this.fill;
        }

        private String getInnerCoordsAsString() {
            StringBuilder stb = new StringBuilder("[");
            for (double[] elem : this.innerCoords) {
                stb.append(this.getCoordsAsString(elem, this.atomsPerElem)).append(",");
            }
            stb.replace(stb.length() - 1, stb.length(), "]");
            return stb.toString();
        }

        @Override
        String infoString() {
            StringBuilder stb = new StringBuilder(super.infoString());
            if (this.innerCoords != null) {
                stb.append(",innercoords=\"").append(this.getInnerCoordsAsString()).append("\"");
            }
            return stb.toString();
        }
    }

    @InternalUseOnly
    public class GeoJSONLineString
    extends GeoJSONFeature {
        public GeoJSONLineString(String name, double[] flatCoords, int atomsPerElem, Map properties, GeoJSONGroup group2) {
            super(name, flatCoords, atomsPerElem, properties, group2);
        }
    }

    @InternalUseOnly
    public class GeoJSONPoint
    extends GeoJSONFeature {
        public GeoJSONPoint() {
            this.coords = new double[3];
        }

        public GeoJSONPoint(String name, double[] flatCoordArray, int atomsPerElem, Map properties, GeoJSONGroup group2) {
            super(name, flatCoordArray, atomsPerElem, properties, group2);
        }
    }

    @InternalUseOnly
    public class GeoJSONFeature
    extends GeoJSONObject {
        Map properties;
        double[] coords;
        int atomsPerElem;
        GeoJSONGroup group;

        public GeoJSONFeature() {
            this.name = "";
            this.properties = MapKBT.newMap();
        }

        public GeoJSONFeature(String name, double[] flatCoords, int atomsPerElem, Map properties, GeoJSONGroup group2) {
            this.name = name;
            this.coords = flatCoords;
            this.atomsPerElem = atomsPerElem;
            this.properties = properties;
            this.group = group2;
            if (group2 != null) {
                group2.add(this);
            }
        }

        public int getAtomsPerElem() {
            return this.atomsPerElem;
        }

        public double[] getCoords() {
            return this.coords;
        }

        public GeoJSONGroup getGroup() {
            return this.group;
        }

        public Map getProperties() {
            return this.properties;
        }

        String getCoordsAsString(double[] coords, int atomsPerElem) {
            StringBuilder stb = new StringBuilder("[");
            int coorGroups = coords.length / atomsPerElem;
            boolean multCoordGroups = coorGroups > 1;
            int coordIdx = 0;
            for (int cg = 0; cg < coorGroups; ++cg) {
                if (multCoordGroups) {
                    stb.append("[");
                }
                for (int atom = 0; atom < atomsPerElem; ++atom) {
                    stb.append(coords[coordIdx++] + ",");
                }
                stb.replace(stb.length() - 1, stb.length(), "");
                if (multCoordGroups) {
                    stb.append("]");
                }
                stb.append(",");
            }
            stb.replace(stb.length() - 1, stb.length(), "]");
            return stb.toString();
        }

        String infoString() {
            return "name=" + this.name + ",coords=\"" + this.getCoordsAsString(this.coords, this.atomsPerElem) + "\"";
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.infoString();
        }

        @Override
        public Table toTable() {
            return new Table("{" + this.getClass().getSimpleName() + "={" + this.infoString() + "}}", 65);
        }
    }

    @InternalUseOnly
    public class GeoJSONObject {
        String name;

        public String getName() {
            return this.name;
        }

        public Table toTable() {
            return new Table("{GeoJSONObject={name=" + this.name + "}}");
        }
    }
}

