/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Arrays;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Units;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class Format
extends DecimalFormat {
    private static final long serialVersionUID = 5256251046960840573L;
    private String pattern;
    private String units = "";
    private transient FieldPosition fp = new FieldPosition(0);
    private int fones;
    private int ones;
    private int exp;
    private int imult;
    private int digitSel;
    private double mult = 1.0;
    private char cmult = (char)32;
    private boolean isSelected;
    private boolean hms;
    private boolean dms;
    private int dpHMS;
    private boolean sdf;
    private String sdfDisplayPattern;
    private char[] SDF_NEEDS_2 = new char[]{'H', 'K', 'L', 'Y', 'd', 'h', 'k', 'm', 's', 'y'};
    private char SDF_NEEDS_3 = (char)68;

    public Format() {
    }

    public Format(String pattern) {
        this();
        this.setFormat(pattern);
    }

    public void setFormat(String pattern) {
        int space;
        this.pattern = pattern;
        boolean hmsWithFSec = pattern.matches("HH:MM:SS\\.[S]+");
        boolean bl = this.hms = hmsWithFSec || pattern.equals("HH:MM:SS");
        if (hmsWithFSec) {
            this.dpHMS = pattern.length() - pattern.indexOf(46) - 1;
        }
        this.dms = pattern.equals("DMS");
        this.sdf = pattern.startsWith("SDF:");
        if (this.sdf) {
            pattern = this.fixSDF(pattern);
        }
        this.fones = pattern.indexOf(46);
        if (this.fones < 0) {
            this.fones = pattern.lastIndexOf(35) + 1;
        }
        if (this.fones <= 0) {
            this.fones = pattern.lastIndexOf(48) + 1;
        }
        this.imult = pattern.indexOf(63);
        if (this.imult >= 0) {
            pattern = pattern.replace('?', ' ');
        }
        if (this.imult < 0) {
            this.imult = 0;
        }
        if (!this.hms && !this.dms) {
            this.applyPattern(pattern);
        }
        if ((space = pattern.lastIndexOf(32)) >= 0) {
            this.units = pattern.substring(space + 1);
        }
    }

    private String fixSDF(String pattern) {
        int maxFracSec = 0;
        int currFracSec = 0;
        pattern = pattern.replaceAll("Z", "");
        pattern = pattern.replaceAll("z", "");
        pattern = pattern.replaceAll("X", "");
        pattern.trim();
        for (int i = 4; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            boolean needsTwo = Arrays.binarySearch(this.SDF_NEEDS_2, c) != -1;
            int numCharRemaining = pattern.length() - 1 - i;
            if (c == 'S') {
                maxFracSec = Math.max(maxFracSec, ++currFracSec);
                continue;
            }
            if (needsTwo) {
                if (numCharRemaining == 0) {
                    pattern = pattern + c;
                } else if (pattern.charAt(i + 1) != c) {
                    pattern = pattern.substring(0, i + 1) + c + pattern.substring(i + 1);
                }
                ++i;
                currFracSec = 0;
                continue;
            }
            if (c == this.SDF_NEEDS_3) {
                if (numCharRemaining == 0) {
                    pattern = pattern + c + c;
                } else if (pattern.charAt(i + 1) != c) {
                    pattern = pattern.substring(0, i + 1) + c + c + pattern.substring(i + 1);
                } else if (numCharRemaining == 1) {
                    pattern = pattern + c;
                } else if (pattern.charAt(i + 2) != c) {
                    pattern = pattern.substring(0, i + 2) + c + pattern.substring(i + 2);
                }
                i += 2;
                currFracSec = 0;
                continue;
            }
            currFracSec = 0;
        }
        this.pattern = pattern;
        if (maxFracSec > 0) {
            char[] arrayS = new char[maxFracSec];
            Arrays.fill(arrayS, 'S');
            this.sdfDisplayPattern = "yyyy:MM:dd::HH:mm:ss." + new String(arrayS);
        } else {
            this.sdfDisplayPattern = "yyyy:MM:dd::HH:mm:ss";
        }
        return pattern;
    }

    @InternalUseOnly
    public int getDecPlacesHMS() {
        return this.dpHMS;
    }

    public String getSdfDisplayPattern() {
        return this.sdfDisplayPattern;
    }

    public String getFormat() {
        return this.pattern;
    }

    public void setExp(Object obj) {
        int imult = 0;
        if (obj instanceof Data) {
            int val = ((Data)obj).toL();
            if (val < -12 || val > 12 || val % 3 > 0) {
                Shell.warning("Invalid argument for Format.setExp: " + obj);
                return;
            }
            imult = val;
        } else if (obj instanceof String) {
            int index = -1;
            String arg = ((String)obj).trim();
            if (arg.length() > 1) {
                for (int i = 0; i < Units.expNames.length; ++i) {
                    if (!Units.expNames[i].equalsIgnoreCase(arg)) continue;
                    imult = Units.expValues[i];
                    index = i;
                    break;
                }
            } else {
                char cmult = arg.charAt(0);
                for (int i = 0; i < Units.expAbbr.length; ++i) {
                    if (Units.expAbbr[i] != cmult) continue;
                    imult = Units.expValues[i];
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                Shell.warning("Invalid argument for Format.setExp: " + arg);
                return;
            }
        }
        this.setExp(imult);
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(double dmin, double dmax) {
        double absmax = Math.max(Math.abs(dmin), Math.abs(dmax));
        int kengr = absmax == 0.0 ? 0 : (int)(0.1447648 * Math.log(absmax * 0.5));
        this.setExp(kengr * 3);
    }

    public void setExp(int exp) {
        if (this.imult == 0) {
            exp = 0;
        }
        this.exp = exp;
        this.mult = Math.pow(10.0, -exp);
        switch (exp) {
            case 0: {
                this.cmult = (char)32;
                break;
            }
            case 3: {
                this.cmult = (char)107;
                break;
            }
            case 6: {
                this.cmult = (char)77;
                break;
            }
            case 9: {
                this.cmult = (char)71;
                break;
            }
            case 12: {
                this.cmult = (char)84;
                break;
            }
            case -3: {
                this.cmult = (char)109;
                break;
            }
            case -6: {
                this.cmult = (char)117;
                break;
            }
            case -9: {
                this.cmult = (char)110;
                break;
            }
            case -12: {
                this.cmult = (char)112;
                break;
            }
            default: {
                this.cmult = (char)63;
            }
        }
    }

    public String getCmult() {
        if (this.cmult == ' ') {
            return "";
        }
        return "" + this.cmult;
    }

    public String getUnits() {
        return this.units;
    }

    public String form(double dval) {
        String s;
        if (this.hms) {
            s = Time.toString(dval, 1, this.dpHMS);
            this.ones = s.length();
        } else if (this.dms) {
            s = Convert.deg2dmsUnicode(dval);
            this.ones = 2;
        } else if (this.sdf) {
            Time t = new Time(dval);
            s = t.toString(this.pattern.substring(4));
        } else {
            StringBuffer sb = new StringBuffer(this.pattern.length());
            sb = super.format(dval * this.mult, sb, this.fp);
            this.ones = this.fp.getEndIndex();
            int i = this.imult + sb.length() - this.pattern.length();
            if (this.imult != 0) {
                if (this.exp == 0) {
                    sb.deleteCharAt(i);
                } else {
                    sb.setCharAt(i, this.cmult);
                }
            }
            s = sb.toString();
            i = s.indexOf(69);
            if (this.imult == 0 && i >= 0) {
                this.exp = Integer.parseInt(s.substring(i + 1));
                if (s.endsWith("E0")) {
                    s = s.substring(0, i);
                }
            }
        }
        return s;
    }

    public void incDigitPos() {
        ++this.digitSel;
    }

    public void decDigitPos() {
        --this.digitSel;
    }

    public void setDigitPos(int pos) {
        int digit = this.ones - pos + this.exp;
        if (pos < this.ones) {
            --digit;
        }
        this.isSelected = pos >= 0 && pos != this.ones && (!this.isSelected || digit != this.digitSel);
        this.digitSel = digit;
    }

    public int getDigitPos() {
        if (!this.isSelected) {
            return -1;
        }
        int digit = this.digitSel - this.exp;
        int pos = this.ones - digit;
        if (digit >= 0) {
            --pos;
        }
        return pos;
    }

    @InternalUseOnly
    public int getDigitSel() {
        return this.digitSel;
    }

    public double getDigitInc() {
        return this.isSelected ? this.getDigitInc(this.digitSel - this.exp) : 0.0;
    }

    public boolean isDigitSel() {
        return this.isSelected;
    }

    public int getDigitPos(int digit) {
        return this.ones - digit;
    }

    public int getDigitIndex(int pos) {
        return this.ones - pos;
    }

    public double getDigitInc(int digit) {
        double inc = 0.0;
        if (this.hms) {
            if (digit >= 0) {
                switch (digit) {
                    case 0: {
                        inc = 1.0;
                        break;
                    }
                    case 1: {
                        inc = 10.0;
                        break;
                    }
                    case 3: {
                        inc = 60.0;
                        break;
                    }
                    case 4: {
                        inc = 600.0;
                        break;
                    }
                    case 6: {
                        inc = 3600.0;
                        break;
                    }
                    case 7: {
                        inc = 36000.0;
                        break;
                    }
                    case 10: {
                        inc = 86400.0;
                        break;
                    }
                    case 11: {
                        inc = 864000.0;
                    }
                }
            } else {
                inc = Math.pow(10.0, digit);
            }
        } else if (this.dms) {
            switch (digit) {
                case 0: {
                    inc = 1.0;
                    break;
                }
                case 1: {
                    inc = 10.0;
                    break;
                }
                case -1: {
                    inc = 0.16666666666666666;
                    break;
                }
                case -2: {
                    inc = 0.016666666666666666;
                    break;
                }
                case -4: {
                    inc = 0.002777777777777778;
                    break;
                }
                case -5: {
                    inc = 2.777777777777778E-4;
                }
            }
        } else {
            inc = Math.pow(10.0, this.exp + digit);
        }
        return inc;
    }

    @Deprecated
    public static Format getDefaultFormatFor(String format, int units) {
        char type = format.charAt(1);
        Format fmt = null;
        if (Data.isString((byte)type)) {
            fmt = null;
        } else {
            String unitsStr = DataFile.getUnitsNameShort(units);
            String floatStr = null;
            String intStr = null;
            switch (units) {
                case 60: 
                case 61: {
                    floatStr = "##0.0000";
                    intStr = "###";
                    unitsStr = "";
                    break;
                }
                default: {
                    floatStr = "##0.#####E000";
                    intStr = "0";
                }
            }
            if (unitsStr.length() > 0) {
                unitsStr = "'" + unitsStr + "'";
            }
            fmt = type == 'D' || type == 'F' ? new Format(floatStr + unitsStr) : new Format(intStr + unitsStr);
        }
        return fmt;
    }

    @InternalUseOnly
    public FieldPosition getFieldPosition() {
        return this.fp;
    }

    @InternalUseOnly
    public boolean isSimpleDateFormat() {
        return this.sdf;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.fp = new FieldPosition(0);
    }
}

