/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Command;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class Foreign
extends Command {
    private static boolean debug = false;
    protected boolean canRunExternal;

    public Foreign() {
        this(true);
    }

    public Foreign(boolean canRunExternal) {
        this.canRunExternal = canRunExternal;
    }

    @Override
    public void run() {
        this.runEnter();
        boolean external = this.canRunExternal;
        String cmdline = this.args.getRaw();
        if (cmdline.charAt(0) == '$') {
            if ((cmdline = cmdline.substring(1)).charAt(0) == '$') {
                cmdline = cmdline.substring(1);
            } else {
                external = false;
            }
        }
        String msf = this.M.results.getString("ENV.MSF");
        if (this.M.verify != 0) {
            this.verify();
        }
        try {
            if (external && this.M.macro == null && msf != null) {
                Foreign.runExternal(this.M, cmdline);
            } else {
                if (this.id.length() > 0) {
                    this.M.registry.put(this.id, this);
                }
                Foreign.runInternal(this.M, cmdline);
                if (this.id.length() > 0) {
                    this.M.registry.remove(this.id);
                }
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        this.runExit();
    }

    public static void runInternal(Midas M, String cmdline) {
        Foreign.runInternal(M, cmdline, false);
    }

    public static int runInternal(Midas M, String cmdline, boolean wait) {
        return Foreign.runInternal(M, cmdline, wait, null, null);
    }

    public static int runInternal(Midas M, String cmdline, boolean wait, String stdoutResname, String stderrResname) {
        StringBuilder out = stdoutResname != null ? new StringBuilder(512) : null;
        StringBuilder err = stderrResname != null ? new StringBuilder(256) : null;
        int status = Foreign._runInternal(M, cmdline, wait, out, err);
        if (out != null) {
            M.results.put(stdoutResname, (Object)((Object)out).toString());
        }
        if (err != null) {
            M.results.put(stderrResname, (Object)((Object)err).toString());
        }
        return status;
    }

    @InternalUseOnly(value="since created")
    public static int runInternal(String cmdline, Appendable out, Appendable err) {
        return Foreign._runInternal(null, cmdline, true, out, err);
    }

    @InternalUseOnly
    private static int _runInternal(Midas M, String cmdline, boolean wait, Appendable out, Appendable err) {
        int status = 0;
        int timeout = -1;
        if (!Shell.getPriv(1)) {
            throw new MidasException("No privilege to run OS command: '" + cmdline + "'");
        }
        boolean bg = cmdline.endsWith("&");
        if (bg) {
            cmdline = cmdline.substring(0, cmdline.length() - 1);
        }
        try {
            boolean hasErrOutput = false;
            Runtime runtime = Runtime.getRuntime();
            Parser parser = new Parser(cmdline, ' ');
            parser.clean(false);
            Process osProcess = runtime.exec(parser.getArray(0));
            if (debug && M != null) {
                String[] array = parser.getArray(0);
                if (array.length > 0) {
                    M.type("Foreign.runInternal: command = '" + array[0] + "'");
                    for (int ii = 1; ii < array.length; ++ii) {
                        M.type("                     arg " + ii + " = '" + array[ii] + "'");
                    }
                } else {
                    M.type("Foreign.runInternal: no command specified");
                }
            }
            if (bg && !wait) {
                return 0;
            }
            OutputStream osInput = osProcess.getOutputStream();
            InputStream osOutput = osProcess.getInputStream();
            InputStream osError = osProcess.getErrorStream();
            int state = 0;
            while (state >= 0 && timeout != 0) {
                byte[] barray;
                int bytes = osOutput.available();
                if (bytes > 0) {
                    barray = new byte[bytes];
                    if ((bytes = osOutput.read(barray)) > 0) {
                        if (out != null) {
                            out.append(new String(barray, 0, bytes));
                        } else if (M != null) {
                            M.type(new String(barray, 0, bytes));
                        }
                    }
                    state = 1;
                }
                if ((bytes = osError.available()) > 0) {
                    barray = new byte[bytes];
                    if ((bytes = osError.read(barray)) > 0) {
                        if (debug && !hasErrOutput && M != null) {
                            hasErrOutput = true;
                            M.warning("Got stderr running: " + cmdline);
                        }
                        if (err != null) {
                            err.append(new String(barray, 0, bytes));
                        } else if (M != null) {
                            M.type(new String(barray, 0, bytes));
                        }
                    }
                    state = 1;
                }
                try {
                    status = osProcess.exitValue();
                    if (osOutput.available() > 0 || osError.available() > 0) {
                        state = 0;
                        continue;
                    }
                    state = -1;
                }
                catch (IllegalThreadStateException e) {
                    if (state == 0) {
                        Time.sleep(0.1);
                        --timeout;
                        continue;
                    }
                    state = 0;
                }
            }
            osInput.close();
            osOutput.close();
            osError.close();
        }
        catch (Exception e) {
            throw new MidasException("Running OS cmd: " + cmdline, e);
        }
        return status;
    }

    public static void runExternal(Midas M, String cmdline) {
        String msf = M.results.getString("ENV.MSF");
        if (msf == null) {
            throw new MidasException("No ENV.MSF for external OS cmd: '" + cmdline + "'");
        }
        msf = msf + ".bat";
        try {
            FileOutputStream fos = new FileOutputStream(msf, true);
            PrintWriter pw = new PrintWriter(fos);
            if ("DOS".equals(Shell.ostype)) {
                pw.println(cmdline);
            } else if ("VMS".equals(Shell.ostype)) {
                pw.println("$" + cmdline);
            } else {
                pw.println(cmdline);
            }
            pw.close();
            M.status = -3;
        }
        catch (Exception e) {
            throw new MidasException("Error writing OS file to " + msf, e);
        }
    }

    @Override
    public String toString() {
        return "O: " + this.args.cmdline;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean val) {
        debug = val;
    }
}

