/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import nxm.sys.inc.Constants;
import nxm.sys.inc.DataTypes;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Midas;
import nxm.sys.libm.Dbf;
import nxm.sys.libm.Fft;
import nxm.sys.libm.OpId;
import nxm.sys.libm.Operator;
import nxm.sys.libm.Operators;
import nxm.sys.libm.Window;

public class DataOp
implements OpId,
Constants,
DataTypes {
    public static final int S = 1;
    public static final int C = 2;
    public static final int V = 3;
    public static final int G = 10;
    public static final int SS = 17;
    public static final int CS = 18;
    public static final int SC = 33;
    public static final int CC = 34;
    public static final int CG = 162;
    public static final int VS = 19;
    public static final int VV = 51;
    public static final int SSS = 273;
    public static final int CSC = 530;
    public static final int SCC = 545;
    public static final int CCC = 546;
    public static final int CGC = 674;
    public static final int GCC = 2594;
    public static final int VSV = 787;
    public static final int VVV = 819;
    public static final int CCS = 290;
    public static final int VVS = 307;
    public static final int SSC = 529;
    public static final int CSS = 274;
    public static final int SSSV = 12561;
    public static final int VSSS = 4371;
    public static String windowList = Window.nameList;
    private static Operator[] ops = new Operator[69];

    public static synchronized void fft(Data A, int size, int flag) {
        Fft.process(A.buf, size, flag);
    }

    public static void dbf(Data A, int size, int flag) {
        Dbf.process(A.buf, size, flag);
    }

    public static Data getWindow(String name, int size, double scale, Midas M) {
        Data data;
        float[] buf = Window.get(name, size, scale);
        if (buf != null) {
            data = new Data(buf);
        } else {
            DataFile hcb = new DataFile();
            hcb.init(M, (Object)name, "1000", "SF", 0);
            hcb.open();
            data = hcb.getDataBuffer((int)hcb.getSize());
            hcb.read(data);
            hcb.close();
        }
        return data;
    }

    public static void zero(Data A, int off, int n) {
        int bpe = A.bpe;
        int boff = A.boff + off * bpe;
        Arrays.fill(A.buf, boff, boff + n * bpe, (byte)0);
    }

    public static void fill(Data A, int off, double dval, int n) {
        int boff;
        if (n < 1) {
            return;
        }
        if (dval == 0.0) {
            DataOp.zero(A, off, n);
            return;
        }
        byte[] buf = A.buf;
        int bpe = A.bpe;
        switch (A.type) {
            case 68: {
                boff = A.boff + (off << 3);
                Convert.packD(buf, boff, dval);
                break;
            }
            case 70: {
                boff = A.boff + (off << 2);
                Convert.packF(buf, boff, (float)dval);
                break;
            }
            case 76: {
                boff = A.boff + (off << 2);
                Convert.packL(buf, boff, (int)dval);
                break;
            }
            default: {
                return;
            }
        }
        int start = boff + bpe;
        int end = boff + n * bpe;
        int i = start;
        int j = 0;
        while (i < end) {
            buf[i] = buf[boff + j % bpe];
            ++i;
            ++j;
        }
    }

    public static void copy(Data A, Data B) {
        System.arraycopy(A.buf, A.boff, B.buf, B.boff, A.size * A.bpe);
    }

    public static void copy(Data A, int offA, Data B, int offB, int n) {
        System.arraycopy(A.buf, A.boff + offA * A.bpe, B.buf, B.boff + offB * A.bpe, n * A.bpe);
    }

    public static void copy(Data A, int offA, int strideA, Data B, int offB, int strideB, int bytes, int n) {
        offA += A.boff;
        offB += B.boff;
        if (bytes >= 16) {
            for (int j = 0; j < n; ++j) {
                System.arraycopy(A.buf, offA, B.buf, offB, bytes);
                offA += strideA;
                offB += strideB;
            }
        } else {
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < bytes; ++i) {
                    B.buf[offB++] = A.buf[offA++];
                }
                offA += strideA - bytes;
                offB += strideB - bytes;
            }
        }
    }

    public static void noop(Data A, Data B) {
        DataOp.run(1, A, B, -1, -1);
    }

    public static void noop(Data A, Data B, int n) {
        DataOp.run(1, A, B, n, -1);
    }

    public static void noop(Data A, Data B, int n, int mode) {
        DataOp.run(1, A, B, n, mode);
    }

    public static void scale(Data A, Data B, double scale) {
        DataOp.run(3, A, B, -1, -1, scale);
    }

    public static void scale(Data A, Data B, int n, double scale) {
        DataOp.run(3, A, B, n, -1, scale);
    }

    public static void scale(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(3, A, B, n, mode, scale);
    }

    public static void sum(Data A, Data B) {
        DataOp.run(8, A, B, -1, -1);
    }

    public static void sum(Data A, Data B, int n) {
        DataOp.run(8, A, B, n, -1);
    }

    public static void sum(Data A, Data B, int n, int mode) {
        DataOp.run(8, A, B, n, mode);
    }

    public static void add(Data A, Data B, Data C) {
        DataOp.run(4, A, B, C, -1, -1);
    }

    public static void add(Data A, Data B, Data C, int n) {
        DataOp.run(4, A, B, C, n, -1);
    }

    public static void add(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(4, A, B, C, n, mode);
    }

    public static void sub(Data A, Data B, Data C) {
        DataOp.run(5, A, B, C, -1, -1);
    }

    public static void sub(Data A, Data B, Data C, int n) {
        DataOp.run(5, A, B, C, n, -1);
    }

    public static void sub(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(5, A, B, C, n, mode);
    }

    public static void mul(Data A, Data B, Data C) {
        DataOp.run(6, A, B, C, -1, -1);
    }

    public static void mul(Data A, Data B, Data C, int n) {
        DataOp.run(6, A, B, C, n, -1);
    }

    public static void mul(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(6, A, B, C, n, mode);
    }

    public static void div(Data A, Data B, Data C) {
        DataOp.run(7, A, B, C, -1, -1);
    }

    public static void div(Data A, Data B, Data C, int n) {
        DataOp.run(7, A, B, C, n, -1);
    }

    public static void div(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(7, A, B, C, n, mode);
    }

    public static void pow(Data A, Data B, Data C) {
        DataOp.run(9, A, B, C, -1, -1);
    }

    public static void pow(Data A, Data B, Data C, int n) {
        DataOp.run(9, A, B, C, n, -1);
    }

    public static void pow(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(9, A, B, C, n, mode);
    }

    public static void min(Data A, Data B, Data C) {
        DataOp.run(10, A, B, C, -1, -1);
    }

    public static void min(Data A, Data B, Data C, int n) {
        DataOp.run(10, A, B, C, n, -1);
    }

    public static void min(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(10, A, B, C, n, mode);
    }

    public static void max(Data A, Data B, Data C) {
        DataOp.run(12, A, B, C, -1, -1);
    }

    public static void max(Data A, Data B, Data C, int n) {
        DataOp.run(12, A, B, C, n, -1);
    }

    public static void max(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(12, A, B, C, n, mode);
    }

    public static void mux(Data A, Data B, Data C) {
        DataOp.run(15, A, B, C, -1, -1);
    }

    public static void mux(Data A, Data B, Data C, int n) {
        DataOp.run(15, A, B, C, n, -1);
    }

    public static void mux(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(15, A, B, C, n, mode);
    }

    public static void demux(Data A, Data B, Data C) {
        DataOp.run(17, A, B, C, -1, -1);
    }

    public static void demux(Data A, Data B, Data C, int n) {
        DataOp.run(17, A, B, C, n, -1);
    }

    public static void demux(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(17, A, B, C, n, mode);
    }

    public static void mod(Data A, Data B, Data C) {
        DataOp.run(23, A, B, C, -1, -1);
    }

    public static void mod(Data A, Data B, Data C, int n) {
        DataOp.run(23, A, B, C, n, -1);
    }

    public static void mod(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(23, A, B, C, n, mode);
    }

    public static void dot(Data A, Data B, Data C) {
        DataOp.run(28, A, B, C, -1, -1);
    }

    public static void dot(Data A, Data B, Data C, int n) {
        DataOp.run(28, A, B, C, n, -1);
    }

    public static void dot(Data A, Data B, Data C, int n, int mode) {
        DataOp.run(28, A, B, C, n, mode);
    }

    public static void round(Data A, Data B) {
        DataOp.run(29, A, B, -1, -1);
    }

    public static void round(Data A, Data B, int n) {
        DataOp.run(29, A, B, n, -1);
    }

    public static void round(Data A, Data B, int n, int mode) {
        DataOp.run(29, A, B, n, mode);
    }

    public static void fix(Data A, Data B) {
        DataOp.run(32, A, B, -1, -1);
    }

    public static void fix(Data A, Data B, int n) {
        DataOp.run(32, A, B, n, -1);
    }

    public static void fix(Data A, Data B, int n, int mode) {
        DataOp.run(32, A, B, n, mode);
    }

    public static void mag(Data A, Data B) {
        DataOp.run(33, A, B, -1, -1);
    }

    public static void mag(Data A, Data B, int n) {
        DataOp.run(33, A, B, n, -1);
    }

    public static void mag(Data A, Data B, int n, int mode) {
        DataOp.run(33, A, B, n, mode);
    }

    public static void mag2(Data A, Data B) {
        DataOp.run(34, A, B, -1, -1);
    }

    public static void mag2(Data A, Data B, int n) {
        DataOp.run(34, A, B, n, -1);
    }

    public static void mag2(Data A, Data B, int n, int mode) {
        DataOp.run(34, A, B, n, mode);
    }

    public static void phase(Data A, Data B) {
        DataOp.run(35, A, B, -1, -1);
    }

    public static void phase(Data A, Data B, int n) {
        DataOp.run(35, A, B, n, -1);
    }

    public static void phase(Data A, Data B, int n, int mode) {
        DataOp.run(35, A, B, n, mode);
    }

    public static void polar(Data A, Data B) {
        DataOp.run(37, A, B, -1, -1);
    }

    public static void polar(Data A, Data B, int n) {
        DataOp.run(37, A, B, n, -1);
    }

    public static void polar(Data A, Data B, int n, int mode) {
        DataOp.run(37, A, B, n, mode);
    }

    public static void rect(Data A, Data B) {
        DataOp.run(38, A, B, -1, -1);
    }

    public static void rect(Data A, Data B, int n) {
        DataOp.run(38, A, B, n, -1);
    }

    public static void rect(Data A, Data B, int n, int mode) {
        DataOp.run(38, A, B, n, mode);
    }

    public static void real(Data A, Data B) {
        DataOp.run(19, A, B, -1, -1);
    }

    public static void real(Data A, Data B, int n) {
        DataOp.run(19, A, B, n, -1);
    }

    public static void real(Data A, Data B, int n, int mode) {
        DataOp.run(19, A, B, n, mode);
    }

    public static void imag(Data A, Data B) {
        DataOp.run(20, A, B, -1, -1);
    }

    public static void imag(Data A, Data B, int n) {
        DataOp.run(20, A, B, n, -1);
    }

    public static void imag(Data A, Data B, int n, int mode) {
        DataOp.run(20, A, B, n, mode);
    }

    public static void cmplx(Data A, Data B) {
        DataOp.run(21, A, B, -1, -1);
    }

    public static void cmplx(Data A, Data B, int n) {
        DataOp.run(21, A, B, n, -1);
    }

    public static void cmplx(Data A, Data B, int n, int mode) {
        DataOp.run(21, A, B, n, mode);
    }

    public static void ln(Data A, Data B) {
        DataOp.run(39, A, B, -1, -1);
    }

    public static void ln(Data A, Data B, int n) {
        DataOp.run(39, A, B, n, -1);
    }

    public static void ln(Data A, Data B, int n, int mode) {
        DataOp.run(39, A, B, n, mode);
    }

    public static void exp(Data A, Data B) {
        DataOp.run(41, A, B, -1, -1);
    }

    public static void exp(Data A, Data B, int n) {
        DataOp.run(41, A, B, n, -1);
    }

    public static void exp(Data A, Data B, int n, int mode) {
        DataOp.run(41, A, B, n, mode);
    }

    public static void dblog(Data A, Data B) {
        DataOp.run(39, A, B, -1, -1, 4.3429448190325);
    }

    public static void dblog(Data A, Data B, int n) {
        DataOp.run(39, A, B, n, -1, 4.3429448190325);
    }

    public static void dblog(Data A, Data B, int n, int mode) {
        DataOp.run(39, A, B, n, mode, 4.3429448190325);
    }

    public static void dblogb(Data A, Data B) {
        DataOp.run(40, A, B, -1, -1, 4.3429448190325);
    }

    public static void dblogb(Data A, Data B, int n) {
        DataOp.run(40, A, B, n, -1, 4.3429448190325);
    }

    public static void dblogb(Data A, Data B, int n, int mode) {
        DataOp.run(40, A, B, n, mode, 4.3429448190325);
    }

    public static void log10(Data A, Data B) {
        DataOp.run(39, A, B, -1, -1, 0.43429448190325);
    }

    public static void log10(Data A, Data B, int n) {
        DataOp.run(39, A, B, n, -1, 0.43429448190325);
    }

    public static void log10(Data A, Data B, int n, int mode) {
        DataOp.run(39, A, B, n, mode, 0.43429448190325);
    }

    public static void log20(Data A, Data B) {
        DataOp.run(39, A, B, -1, -1, 0.8685889638065);
    }

    public static void log20(Data A, Data B, int n) {
        DataOp.run(39, A, B, n, -1, 0.8685889638065);
    }

    public static void log20(Data A, Data B, int n, int mode) {
        DataOp.run(39, A, B, n, mode, 0.8685889638065);
    }

    public static void dblogb2(Data A, Data B) {
        DataOp.run(40, A, B, -1, -1, 8.685889638065);
    }

    public static void dblogb2(Data A, Data B, int n) {
        DataOp.run(40, A, B, n, -1, 8.685889638065);
    }

    public static void dblogb2(Data A, Data B, int n, int mode) {
        DataOp.run(40, A, B, n, mode, 8.685889638065);
    }

    public static void sin(Data A, Data B, double scale) {
        DataOp.run(44, A, B, -1, -1, scale);
    }

    public static void sin(Data A, Data B, int n, double scale) {
        DataOp.run(44, A, B, n, -1, scale);
    }

    public static void sin(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(44, A, B, n, mode, scale);
    }

    public static void cos(Data A, Data B, double scale) {
        DataOp.run(45, A, B, -1, -1, scale);
    }

    public static void cos(Data A, Data B, int n, double scale) {
        DataOp.run(45, A, B, n, -1, scale);
    }

    public static void cos(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(45, A, B, n, mode, scale);
    }

    public static void tan(Data A, Data B, double scale) {
        DataOp.run(46, A, B, -1, -1, scale);
    }

    public static void tan(Data A, Data B, int n, double scale) {
        DataOp.run(46, A, B, n, -1, scale);
    }

    public static void tan(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(46, A, B, n, mode, scale);
    }

    public static void asin(Data A, Data B, double scale) {
        DataOp.run(47, A, B, -1, -1, scale);
    }

    public static void asin(Data A, Data B, int n, double scale) {
        DataOp.run(47, A, B, n, -1, scale);
    }

    public static void asin(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(47, A, B, n, mode, scale);
    }

    public static void acos(Data A, Data B, double scale) {
        DataOp.run(48, A, B, -1, -1, scale);
    }

    public static void acos(Data A, Data B, int n, double scale) {
        DataOp.run(48, A, B, n, -1, scale);
    }

    public static void acos(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(48, A, B, n, mode, scale);
    }

    public static void atan(Data A, Data B, double scale) {
        DataOp.run(49, A, B, -1, -1, scale);
    }

    public static void atan(Data A, Data B, int n, double scale) {
        DataOp.run(49, A, B, n, -1, scale);
    }

    public static void atan(Data A, Data B, int n, int mode, double scale) {
        DataOp.run(49, A, B, n, mode, scale);
    }

    public static void atan2(Data A, Data B, Data C, double scale) {
        DataOp.run(50, A, B, C, -1, -1, scale);
    }

    public static void atan2(Data A, Data B, Data C, int n, double scale) {
        DataOp.run(50, A, B, C, n, -1, scale);
    }

    public static void atan2(Data A, Data B, Data C, int n, int mode, double scale) {
        DataOp.run(50, A, B, C, n, mode, scale);
    }

    public static int run(int opi, Data A, Data B, Data C, int n, int mode) {
        Operator op;
        if (n < 0) {
            n = A.size * A.ape;
        }
        if (mode < 0) {
            mode = A.spa | B.spa << 4 | C.spa << 8;
        }
        if ((op = ops[opi]) == null) {
            op = DataOp.ops[opi] = Operators.get(opi);
        }
        if (C.type == 68) {
            double[][] v = new double[3][];
            DataOp.vcastD(A, B, C, v);
            n = op.process(v, n, mode);
            DataOp.unvcastD(A, B, C, v);
        } else if (C.type == 70) {
            float[][] v = new float[3][];
            DataOp.vcastF(A, B, C, v);
            n = op.process(v, n, mode);
            DataOp.unvcastF(A, B, C, v);
        } else {
            int[][] v = new int[3][];
            DataOp.vcastL(A, B, C, v);
            n = op.process(v, n, mode);
            DataOp.unvcastL(A, B, C, v);
        }
        return n;
    }

    public static int run(int opi, Data A, Data B, Data C, int n, int mode, double scale) {
        Operator op;
        if (n < 0) {
            n = A.size * A.ape;
        }
        if (mode < 0) {
            mode = A.spa | B.spa << 4 | C.spa << 8;
        }
        if ((op = ops[opi]) == null) {
            op = DataOp.ops[opi] = Operators.get(opi);
        }
        if (C.type == 68) {
            double[][] v = new double[3][];
            DataOp.vcastD(A, B, C, v);
            n = op.process(v, n, mode, scale);
            DataOp.unvcastD(A, B, C, v);
        } else if (C.type == 70) {
            float[][] v = new float[3][];
            DataOp.vcastF(A, B, C, v);
            n = op.process(v, n, mode, scale);
            DataOp.unvcastF(A, B, C, v);
        } else {
            int[][] v = new int[3][];
            DataOp.vcastL(A, B, C, v);
            n = op.process(v, n, mode, scale);
            DataOp.unvcastL(A, B, C, v);
        }
        return n;
    }

    public static int run(int opi, Data A, Data B, int n, int mode) {
        Operator op;
        if (n < 0) {
            n = A.size * A.ape;
        }
        if (mode < 0) {
            mode = A.spa | B.spa << 4;
        }
        if ((op = ops[opi]) == null) {
            op = DataOp.ops[opi] = Operators.get(opi);
        }
        if (B.type == 68) {
            double[][] v = new double[2][];
            DataOp.vcastD(A, B, v);
            n = op.process(v, n, mode);
            DataOp.unvcastD(A, B, v);
        } else if (B.type == 70) {
            float[][] v = new float[2][];
            DataOp.vcastF(A, B, v);
            n = op.process(v, n, mode);
            DataOp.unvcastF(A, B, v);
        } else {
            int[][] v = new int[2][];
            DataOp.vcastL(A, B, v);
            n = op.process(v, n, mode);
            DataOp.unvcastL(A, B, v);
        }
        return n;
    }

    public static int run(int opi, Data A, Data B, int n, int mode, double scale) {
        Operator op;
        if (n < 0) {
            n = A.size * A.ape;
        }
        if (mode < 0) {
            mode = A.spa | B.spa << 4;
        }
        if ((op = ops[opi]) == null) {
            op = DataOp.ops[opi] = Operators.get(opi);
        }
        if (B.type == 68) {
            double[][] v = new double[2][];
            DataOp.vcastD(A, B, v);
            n = op.process(v, n, mode, scale);
            DataOp.unvcastD(A, B, v);
        } else if (B.type == 70) {
            float[][] v = new float[2][];
            DataOp.vcastF(A, B, v);
            n = op.process(v, n, mode, scale);
            DataOp.unvcastF(A, B, v);
        } else {
            int[][] v = new int[2][];
            DataOp.vcastL(A, B, v);
            n = op.process(v, n, mode, scale);
            DataOp.unvcastL(A, B, v);
        }
        return n;
    }

    private static void vcastD(Data A, Data B, Data C, double[][] v) {
        v[0] = A.castD(true);
        v[1] = B.castD(true);
        v[2] = C.castD(false);
    }

    private static void unvcastD(Data A, Data B, Data C, double[][] v) {
        A.uncast(v[0], false);
        B.uncast(v[1], false);
        C.uncast(v[2], true);
    }

    private static void vcastF(Data A, Data B, Data C, float[][] v) {
        v[0] = A.castF(true);
        v[1] = B.castF(true);
        v[2] = C.castF(false);
    }

    private static void unvcastF(Data A, Data B, Data C, float[][] v) {
        A.uncast(v[0], false);
        B.uncast(v[1], false);
        C.uncast(v[2], true);
    }

    private static void vcastL(Data A, Data B, Data C, int[][] v) {
        v[0] = A.castL(true);
        v[1] = B.castL(true);
        v[2] = C.castL(false);
    }

    private static void unvcastL(Data A, Data B, Data C, int[][] v) {
        A.uncast(v[0], false);
        B.uncast(v[1], false);
        C.uncast(v[2], true);
    }

    private static void vcastD(Data A, Data B, double[][] v) {
        v[0] = A.castD(true);
        v[1] = B.castD(false);
    }

    private static void unvcastD(Data A, Data B, double[][] v) {
        A.uncast(v[0], false);
        B.uncast(v[1], true);
    }

    private static void vcastF(Data A, Data B, float[][] v) {
        v[0] = A.castF(true);
        v[1] = B.castF(false);
    }

    private static void unvcastF(Data A, Data B, float[][] v) {
        A.uncast(v[0], false);
        B.uncast(v[1], true);
    }

    private static void vcastL(Data A, Data B, int[][] v) {
        v[0] = A.castL(true);
        v[1] = B.castL(false);
    }

    private static void unvcastL(Data A, Data B, int[][] v) {
        A.uncast(v[0], false);
        B.uncast(v[1], true);
    }
}

