/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyObjectNames;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.Units;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFileModSwapInterface;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Pipe;
import nxm.sys.lib.PipeResource;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.TimeLine;
import nxm.sys.lib.TuneAdjust;
import nxm.sys.lib.Util;
import nxm.sys.libm.Tolerance;

public class DataFile
extends BaseFile
implements DataFileModSwapInterface,
ListFile,
Cloneable {
    public static final String propertyList = "Name,Type,Format,Size,Qualifiers,Keywords,Extended";
    public static final String propagationMaskList = "Header,Keywords,KeywordMain,KeywordExt,TimeCode,PacketHandler";
    public static final int PM_HEADER = 1;
    public static final int PM_KEYWORDS = 2;
    public static final int PM_KEYWORDSMAIN = 4;
    public static final int PM_KEYWORDSEXT = 8;
    public static final int PM_TIMECODE = 16;
    public static final int PM_PACKETHANDLER = 32;
    public static final int PM_DEFAULT = -1;
    public static final int Q_RF = 0;
    public static final int Q_ALT = 1;
    public static final int Q_LAT = 2;
    public static final int Q_LON = 3;
    public static final int Q_AZIM = 4;
    public static final int Q_ELEV = 5;
    public static final int Q_ROLL = 6;
    public static final int Q_YEAR = 9;
    public static final int Q_SEC = 10;
    public static final int Q_GHA = 11;
    public static final int BYTE_BLOCK_SIZE = 512;
    public static final int HEADER_SIZE = 512;
    public static final int OFF_VERSION = 0;
    public static final int OFF_HEADREP = 4;
    public static final int OFF_DATAREP = 8;
    public static final int OFF_DETACHED = 12;
    public static final int OFF_PROTECTED = 16;
    public static final int OFF_PIPE = 20;
    public static final int OFF_EXTSTART = 24;
    public static final int OFF_EXTSIZE = 28;
    public static final int OFF_DATASTART = 32;
    public static final int OFF_DATASIZE = 40;
    public static final int OFF_TYPE = 48;
    public static final int OFF_FORMAT = 52;
    public static final int OFF_FLAGMASK = 54;
    public static final int OFF_TIMECODE = 56;
    public static final int OFF_INLET = 64;
    public static final int OFF_OUTLETS = 66;
    public static final int OFF_OUTMASK = 68;
    public static final int OFF_PIPELOC = 72;
    public static final int OFF_PIPESIZE = 76;
    public static final int OFF_INBYTE = 80;
    public static final int OFF_OUTBYTE = 88;
    public static final int OFF_OUTBYTES = 96;
    public static final int OFF_KEYLGTH = 160;
    public static final int OFF_KEYWORDS = 164;
    public static final int OFF_ADJUNCT = 256;
    public static final int ADJUNCT_XSTART_OFF = 0;
    public static final int ADJUNCT_XDELTA_OFF = 8;
    public static final int ADJUNCT_XUNITS_OFF = 16;
    public static final int ADJUNCT_SUBSIZE_OFF = 20;
    public static final int ADJUNCT_YSTART_OFF = 24;
    public static final int ADJUNCT_YDELTA_OFF = 32;
    public static final int ADJUNCT_YUNITS_OFF = 40;
    public static final int ADJUNCT_RECLGTH_OFF = 44;
    public static final int ADJUNCT_RSTART_OFF = 0;
    public static final int ADJUNCT_RDELTA_OFF = 8;
    public static final int ADJUNCT_RUNITS_OFF = 16;
    public static final int ADJUNCT_SUBREC_OFF = 20;
    public static final int ADJUNCT_R2START_OFF = 24;
    public static final int ADJUNCT_R2DELTA_OFF = 32;
    public static final int ADJUNCT_R2UNITS_OFF = 40;
    public static final int ADJUNCT_SUBRSTR_OFF = 48;
    public static final int ADJUNCT_VRSTART_OFF = 0;
    public static final int ADJUNCT_VRDELTA_OFF = 8;
    public static final int ADJUNCT_VRUNITS_OFF = 16;
    public static final int ADJUNCT_NRECORD_OFF = 20;
    public static final int ADJUNCT_VR2START_OFF = 24;
    public static final int ADJUNCT_VR2DELTA_OFF = 32;
    public static final int ADJUNCT_VR2UNITS_OFF = 40;
    public static final int ADJUNCT_TSTART_OFF = 0;
    public static final int ADJUNCT_TDELTA_OFF = 8;
    public static final int ADJUNCT_TUNITS_OFF = 16;
    public static final int ADJUNCT_COMPONENTS_OFF = 20;
    public static final int ADJUNCT_T2START_OFF = 24;
    public static final int ADJUNCT_T2DELTA_OFF = 32;
    public static final int ADJUNCT_T2UNITS_OFF = 40;
    public static final int ADJUNCT_COMP_OFF = 48;
    public static final int ADJUNCT_QUADWORD_OFF = 160;
    public static final int CHARS_VERSION = 4;
    public static final int CHARS_REP = 4;
    public static final int CHARS_FORMAT = 2;
    public static final String QUALIFIER_USEC_TIMELINE = "USEBLUEUSECTIMELINE";
    public static final String QUALIFIER_TC_TIMELINE = "USEBLUETCTIMELINE";
    public static final String QUALIFIER_PLATINUM_TIMELINE = "USEPLATINUMTIMELINE";
    private static final String BLANK_T6_SUBREC = "                        0000000000000000000000000000000000000000000000000000000000010000SB000000";
    private static final String BLUE_VER_ORIG = "1.0";
    static final String BLUE_VER_DEFAULT = "1.1";
    static final String BLUE_VER_Z_DATA = "1.2";
    private static final String BLUE_VER_PLATINUM = "2.0";
    private static final Pattern BLUE_VER_PATTERN = Pattern.compile("1.\\d");
    private static final Pattern PLATINUM_VER = Pattern.compile("2.\\d");
    @InternalUseOnly
    public int bps = 1;
    @InternalUseOnly
    public int bpa = 1;
    @InternalUseOnly
    public int spa = 1;
    @InternalUseOnly
    public int ape = 1;
    @InternalUseOnly
    public double dbpe = 1.0;
    @InternalUseOnly
    public String types;
    @InternalUseOnly
    public String formats;
    @InternalUseOnly
    public int xferLength = -1;
    @InternalUseOnly
    public int consLength = -1;
    @InternalUseOnly
    public byte dataMode;
    @InternalUseOnly
    public byte dataType;
    @KeyObjectNames(value={"typeClass"})
    @InternalUseOnly
    public int typeClass = 1;
    private DataFile next;
    private DataFile previous;
    @InternalUseOnly
    public int defPipeSize = 131072;
    @InternalUseOnly
    public IOResource ioh;
    private PipeResource iop;
    @InternalUseOnly
    public PacketHandler pkh;
    @InternalUseOnly
    public DataFile hp;
    @InternalUseOnly
    public TimeLine timeLine;
    private Time time = new Time();
    @InternalUseOnly
    public byte[] hb = new byte[512];
    @InternalUseOnly
    public Keywords keywords = new Keywords(this);
    @InternalUseOnly
    public Data buffer;
    @InternalUseOnly
    public boolean enableNewRestartCode = false;
    private double firstbyte;
    private double wsize;
    private double cfsize;
    private double cftop;
    private boolean trimSet = false;
    private double trim1;
    private double trim2;
    private boolean isStream;
    private int listLineWidth = 80;
    private double saveOffset;
    private int saveLength;
    private byte[] saveBuf;
    private byte[] tempBuf;
    private boolean preserveDB;
    private byte dataRep;
    byte headRep;
    private StringBuffer t6s;
    private String[] recNames;
    private byte[] tempVms = new byte[8];
    private boolean isBlueVersion1dot2 = false;
    private boolean offset0AutoCorrectIsEnabled;
    private boolean minimalSupportForUnsupportedDataTypes = false;
    private boolean sameTimelineKeywords = false;
    private static volatile boolean autoConvertPlatinumDefault = true;
    private volatile boolean autoConvertPlatinum = autoConvertPlatinumDefault;
    private boolean allowablePlatinum = false;
    private boolean supportTuneAdjustmentsOnRaster = false;
    private TuneAdjust tuneAdjustments = null;
    TimeLine.Format sourceTimeLineFormat;
    double sourceTimeLineTolr;
    private static final SortedSet<String> BLUE_MAGIC = Util.asSortedSet("BLUEIEEEIEEE", "BLUEIEEEEEEI", "BLUEEEEIIEEE", "BLUEEEEIEEEI");
    public static final String BLUE_FILE_READ_ERROR = "Error reading BLUE file";
    private static String scalarSeparator = "|";
    private static String elementSeparator = ",";
    public static final int E_HCB_OK = 1;
    public static final int E_HCB_FAIL = 2;
    public static final int E_DET_OK = 4;
    public static final int E_DET_FAIL = 8;
    public static final int E_PKT_OK = 16;
    public static final int E_PKT_FAIL = 32;
    public static final int E_PROT_FAIL = 64;
    public static final int ISTART = 1;
    public static final int IEND = 2;
    public static final int IDELTA = 3;
    public static final int RDELTA = 4;
    public static final int JSTART = 5;
    public static final int JEND = 6;
    public static final int JDELTA = 7;
    public static final String addressingModeList = "INDEX,ABSCISSA,ABSCISSA_AUTO,TIMECODE,ABSCISSA_LEGACY";
    public static final int ADDR_UNKNOWN = 0;
    public static final int ADDR_INDEX = 1;
    public static final int ADDR_ABSCISSA = 2;
    public static final int ADDR_ABSCISSA_AUTO = 3;
    public static final int ADDR_TIMECODE = 4;
    public static final int ADDR_ABSCISSA_LEGACY = 5;
    public static final int IMODEDEF = 1;
    public static final int ITILDE = 2;
    public static final int IRELATIVE = 4;
    public static final int IFROMSIZE = 8;

    public DataFile() {
        this.flags = 0;
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0")
    public DataFile(Object ref, Object filename) {
        this(Convert.ref2MidasReference(ref), filename);
    }

    public DataFile(MidasReference ref, Object filename) {
        this();
        Midas refM;
        int _flags = 0;
        if (ref != null && (refM = ref.getMidas()) != null && refM.isJavaBehavior()) {
            _flags = 524288;
        }
        this.setFlags(_flags);
        if (Midas.isJavaVsMidasDebug()) {
            Midas.log("#JvsM DataFile 2-arg constructor filename:" + filename + " flags:" + DataFile.getFlagsString(this.flags), 0);
        }
        this.init(ref, filename);
    }

    public DataFile(MidasReference ref, Object filename, int flags) {
        this();
        this.setFlags(flags);
        if (Midas.isJavaVsMidasDebug()) {
            Midas.log("#JvsM DataFile 3-arg constructor filename:" + filename + " flags:" + DataFile.getFlagsString(flags), 0);
        }
        this.init(ref, filename, "", "", 0);
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0")
    public DataFile(Object ref, Object name, String types, String formats, int flags) {
        this(Convert.ref2MidasReference(ref), name, types, formats, flags);
    }

    public DataFile(MidasReference ref, Object name, String types, String formats, int flags) {
        this(ref, name, types, formats, flags, -1.0, null);
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0")
    public DataFile(Object ref, Object name, DataFile hcbin, int flags) {
        this(Convert.ref2MidasReference(ref), name, hcbin, flags);
    }

    public DataFile(MidasReference ref, Object name, DataFile hcbin, int flags) {
        this(ref, name, "", "", flags | 2, -1.0, hcbin);
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0")
    public DataFile(Object ref, Object name, String types, String formats, int flags, double size, DataFile hcbin) {
        this(Convert.ref2MidasReference(ref), name, types, formats, flags, size, hcbin);
    }

    public DataFile(MidasReference ref, Object name, String types, String formats, int flags, double size, DataFile hcbin) {
        this();
        if (Midas.isJavaVsMidasDebug()) {
            Midas.log("DataFile constructor 4 Arg filename:" + this.filename + " flags:" + DataFile.getFlagsString(flags), 0);
        }
        this.init(ref, name, types, formats, flags, size, hcbin);
    }

    public String getClassVersion() {
        return "BLUE";
    }

    public void initMain() {
        this.setVersion("BLUE");
        this.setHeadRep(Shell.osrep);
        this.setDataRep(Shell.osrep);
        this.setDataStart(this.hb.length);
        this.setDataSize(0.0);
        this.setTimeCode(0.0);
        this.setFormat("SF");
        this.setType(1000);
        this.setXStart(0.0);
        this.setXDelta(1.0);
        this.setYStart(0.0);
        this.setYDelta(1.0);
        this.setInByte(0.0);
        for (int i = 0; i <= 8; ++i) {
            this.setOutByte(i, 0.0);
        }
    }

    public void init(MidasReference ref, Object name, String types, String formats, int flags, double size, DataFile hcbin) {
        if (hcbin != null) {
            this.init(ref, name, hcbin, flags | 2);
            if (types != null && types.length() == 4) {
                this.types = types;
                this.setType(Convert.s2l(types));
            }
            if (formats != null && formats.length() == 2) {
                this.formats = formats;
                this.setFormat(formats);
            }
        } else {
            this.init(ref, name, types, formats, flags);
        }
        if (size > 0.0) {
            this.setSize(size);
        }
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0")
    public void init(Object ref, Object filename, String types, String formats, int flags) {
        this.init(Convert.ref2MidasReference(ref), filename, types, formats, flags);
    }

    public void init(MidasReference ref, Object filename, String types, String formats, int flags) {
        this.initMain();
        this.M = Convert.ref2Midas(ref);
        super.init(ref, this.M, filename);
        if (Midas.isJavaVsMidasDebug()) {
            Midas.log("#JvsM DataFile init that calls BaseFile init filename:" + filename + " flags:" + DataFile.getFlagsString(flags), 0);
        }
        if (this.M != null && this.M.io != null) {
            if (this.M.io.isOptionSet(CoreIO.IOOptions.TruncateBLUE)) {
                flags |= 0x800;
            }
            if (this.M.io.isOptionSet(CoreIO.IOOptions.MinimalSupportForUnsupportedDataTypes)) {
                this.minimalSupportForUnsupportedDataTypes = true;
            }
            if (this.M.io.isOptionSet(CoreIO.IOOptions.SameTimelineKeywords)) {
                this.sameTimelineKeywords = true;
            }
            this.offset0AutoCorrectIsEnabled = !this.M.io.isOptionSet(CoreIO.IOOptions.DisableTimeLineAutoCorrectNoOffset0Entry) && !this.M.io.isOptionSet(CoreIO.IOOptions.SameTimelineKeywords);
        }
        this.setFlags(flags);
        this.types = types;
        this.formats = formats;
        if (formats.length() == 2) {
            this.setFormat(formats);
        }
        if (types.length() == 4) {
            this.setType(Convert.s2l(types));
        }
        if (this.cmd != null) {
            this.defPipeSize = this.cmd.args.getL("/PS", this.defPipeSize);
        }
    }

    @Override
    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0")
    public void init(Object ref, Object filename) {
        this.init(Convert.ref2MidasReference(ref), filename);
    }

    @Override
    public void init(MidasReference ref, Object filename) {
        this.M = Convert.ref2Midas(ref);
        if (ref != null && this.M != null && this.M.isJavaBehavior()) {
            this.flags |= 0x80000;
        }
        this.init(ref, filename, "", "", 0);
    }

    public void init(MidasReference ref, Object fname, DataFile hcb, int flags) {
        this.init(ref, fname, "", "", flags | 2);
        this.propagate(hcb, -1);
    }

    public void init(Object ref, Object filename, DataFile hcb, int flags) {
        this.init(ref, filename, "", "", flags | 2);
        this.propagate(hcb, -1);
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.0 - has alway been for internal use by Rmif.java which is in a different package")
    public void init(Object ref, Object filename, byte[] hb, int flags) {
        this.init(ref, filename, "", "", flags | 2);
        this.copyHeader(hb);
        this.setInternals();
    }

    public void propagate(DataFile hcb, String propmaskStr) {
        int propmask = Parser.mask(propagationMaskList, propmaskStr, -1);
        this.propagate(hcb, propmask);
    }

    public void propagate(DataFile hcb, int propmask) {
        if (hcb.timeLine != null) {
            this.sourceTimeLineFormat = hcb.timeLine.format;
            this.sourceTimeLineTolr = hcb.timeLine.getTolerance();
        }
        if (hcb.sourceTimeLineFormat != null) {
            this.sourceTimeLineFormat = hcb.sourceTimeLineFormat;
            this.sourceTimeLineTolr = hcb.sourceTimeLineTolr;
        }
        if (propmask == 8) {
            this.propagateExtKeywords(hcb);
            return;
        }
        boolean propHeader = (propmask & 1) != 0;
        boolean propMainKeys = (propmask & 6) != 0;
        boolean propKeywords = (propmask & 0xA) != 0;
        boolean propNoVolatile = this.M.io.isOptionSet(CoreIO.IOOptions.DoNotPropagateVolatileKeywords);
        boolean propTimecode = (propmask & 0x10) != 0;
        String inFileName = hcb.getFileName().getFullName();
        boolean inFnNotEmpty = inFileName.length() > 0;
        boolean isSameFN = inFileName.equals(this.getFileName().getFullName());
        if (!hcb.isOpen && inFnNotEmpty && !isSameFN) {
            this.M.warning("Cannot propagate 'ALL' header/keyword to [" + this.getURL() + "] from UNOPENED file [" + hcb.getURL() + "]");
        }
        if (propHeader) {
            this.copyHeader(hcb.hb);
            this.headRep = hcb.headRep;
        }
        if (propMainKeys && !propHeader) {
            this.setKeywords(hcb.getKeywords());
        }
        if (propKeywords) {
            Keywords kw = Keywords.convertedCopyOfKeywords(hcb.keywords, hcb.headRep, Shell.rep);
            this.keywords.init(kw.buf, kw.size, Shell.rep);
            boolean forceQual = Convert.o2z(hcb.getQualifier("FORCE"));
            if (this.autoConvertPlatinum && PLATINUM_VER.matcher(hcb.getBlueVer()).matches() && !forceQual) {
                this.M.info("Performing auto-conversion Platinum to Blue in keyword propagation from file:" + hcb.filename + " to:" + this.filename);
                Table plat2blueTable = Table.fromTableFile(this.M, "nxm.sys.dat.kwconv_plat2blue.tbl");
                plat2blueTable.put("_WARN_MISSING_", true);
                FileUtil.convertKeywordsInPlace(this.M, hcb, this.keywords, plat2blueTable);
            }
            if (propNoVolatile) {
                this.keywords.deleteVolatileKeywords();
            }
        }
        if (propHeader) {
            this.convertHeaderRep(Shell.osrep);
            this.setDataRep(Shell.osrep);
            this.setProtected(false);
            this.setDetached(0);
            this.setPipeId(0);
            this.setDataStart(this.hb.length);
            this.setInternals();
            this.size = hcb.size;
        }
        if (propTimecode && !propHeader) {
            this.setTimeCode(hcb.getTimeCode());
        }
        if ((propmask & 0x20) != 0) {
            this.pkh = hcb.pkh;
        }
    }

    private void propagateExtKeywords(DataFile dfSrc) {
        DataFile dfDest = this;
        String fnSrc = dfSrc.getFileName().getFullName();
        String fnDest = dfDest.getFileName().getFullName();
        if (!dfSrc.isOpen && fnSrc.length() > 0 && !fnSrc.equals(fnDest)) {
            this.M.warning("Cannot propagate keywords to [" + this.getURL() + "] from UNOPENED file [" + dfSrc.getURL() + "]");
        }
        Keywords kwSrc = dfSrc.keywords;
        Keywords kw = new Keywords();
        if (kwSrc.size > 0) {
            kw.size = kwSrc.size;
            kw.buf = new byte[kwSrc.buf.length];
            System.arraycopy(kwSrc.buf, 0, kw.buf, 0, kwSrc.size);
            byte repSrc = (byte)dfSrc.getHeadRep().charAt(0);
            byte repDest = (byte)dfDest.getHeadRep().charAt(0);
            if (repSrc != repDest) {
                kw.convertExtRep(repSrc, repDest);
            }
        }
        Keywords kwDest = dfDest.keywords;
        kwDest.size = kw.size;
        kwDest.buf = kw.buf;
        kwDest.clearScope();
        if (this.typeClass == 6) {
            this.t6s = this.readT6def(false);
        }
    }

    public void copyHeader(byte[] buf) {
        int bytes = buf.length;
        this.extendHeader(bytes);
        System.arraycopy(buf, 0, this.hb, 0, bytes);
    }

    @Override
    public synchronized boolean find(int dir) {
        IOResource oldio = this.io;
        IOResource oldioh = this.ioh;
        this.io = this.ioh = this.M.io.findResource(this.getFileName(), dir, "", this.aux, (this.flags & 0x100000) != 0);
        if (this.isPipe()) {
            this.iop = (PipeResource)this.io;
        } else {
            if (oldio != null) {
                oldio.close();
            }
            if (oldioh != null && oldioh != oldio) {
                oldioh.close();
            }
        }
        return this.io.exists() && !this.io.isContainer();
    }

    @Override
    public synchronized boolean open() {
        block82: {
            this.isOpen = false;
            this.wsize = 0.0;
            FileName fn = this.getFileName();
            if ((this.flags & 3) == 0) {
                this.flags = this.size > 0.0 ? (this.flags |= 2) : (this.flags |= 1);
            }
            if (this.tag.length() == 0 || this.tag.equals("NULL") || fn.getRoot().equalsIgnoreCase("null")) {
                if ((this.flags & 0x40) != 0) {
                    return this.isOpen;
                }
                if (this.tag.length() != 0 && (this.flags & 2) != 0) {
                    return this.isOpen;
                }
                this.M.error("No FileName specified");
            }
            if ((this.flags & 8) != 0) {
                this.isInput = (this.flags & 1) != 0 || this.exists();
                this.isOutput = true;
            } else {
                this.isInput = (this.flags & 1) != 0;
                this.isOutput = (this.flags & 2) != 0;
            }
            int dir = this.getDir(this.isInput, this.isOutput, false);
            this.isFound = this.find(dir);
            String url = this.getURL();
            if ((this.M.debug & 1) != 0) {
                this.M.info("OpenDF tag=" + this.tag + " Path=" + url);
            }
            if (this.isInput && !this.isFound && this.cmd != null && this.cmd.isPiped && ((this.flags & 0x200) != 0 || this.isPipe())) {
                this.waitForFile();
                if (!this.isFound && (this.flags & 0x20) == 0) {
                    this.close();
                    return this.isOpen;
                }
            }
            dir = this.getDir(this.isInput, this.isOutput, this.isFound);
            if (this.isPipe()) {
                this.setDataStart(0.0);
                this.setPipeId(0);
                int ps = Convert.o2l(fn.getQualifier("PS"), this.M);
                if (ps > 0) {
                    this.defPipeSize = ps;
                }
                this.iop.df = this;
                this.iop.pipeSize = this.defPipeSize;
            }
            try {
                String qpacket;
                boolean noProtect;
                if (this.isOutput && !this.isInput) {
                    this.setBlueVerIO();
                    this.setSize(this.size);
                    this.io.setLength((long)(this.getDataStart() + this.getDataSize()));
                }
                boolean bl = noProtect = !Convert.o2z(fn.getQualifier("PROT", true));
                if (this.isInput && this.isOutput && this.isFound) {
                    if (!this.io.open(0)) {
                        throw new MidasException("Could not open " + url + " for input/output");
                    }
                    this.readHeader();
                    if (this.getProtected() && !noProtect) {
                        throw new MidasException("Output is protected");
                    }
                } else if (this.isInput && this.isFound) {
                    if (!this.io.open(-1)) {
                        throw new MidasException("Could not open " + url + " for input");
                    }
                    this.readHeader();
                } else {
                    if (this.isInput) {
                        if ((this.flags & 0x20) != 0) {
                            return this.isOpen;
                        }
                        throw new BaseFile.CouldNotFindException();
                    }
                    if (this.isOutput && this.isFound) {
                        if (!this.io.open(dir)) {
                            throw new MidasException("Could not open " + url + " for output");
                        }
                        byte[] hbt = new byte[512];
                        this.readHeader(hbt);
                        if ((this.flags & 0x800) == 0 && !Convert.unpackS(hbt, 0, 4).equals(this.getClassVersion())) {
                            String localFileName = "";
                            try {
                                localFileName = BaseFile.getFileNameFor(this.M, this.getFileName().toString()).toLocalFileName();
                            }
                            catch (MalformedURLException e) {
                                this.M.warning(e);
                            }
                            File f = new File(localFileName);
                            if (f.length() != 0L) {
                                this.M.warning("DataFile: Overwriting non-" + this.getClassVersion() + " file: " + url);
                            }
                        } else {
                            if (hbt[16] + hbt[19] != 0 && !noProtect && this.getClassVersion().equals("BLUE")) {
                                throw new MidasException("Output is protected");
                            }
                            if (StringUtil.isEmpty(FileName.getExt(url)) && this.io.isFile() && this.io.getType() != 7) {
                                this.M.warning("DataFile: Overwriting extensionless BLUE file: " + url);
                            }
                        }
                        if (this.enableNewRestartCode && this.previous != null) {
                            Time stopTime = this.previous.getTimeAt(this.previous.seek(), null);
                            Time startTime = stopTime.addSec(this.previous.getDelta());
                            this.newTimeLineFromDF(this.previous);
                            this.setTimeAt(0.0, startTime, TimeLine.NotifyInvalidEntry.WARNING);
                        }
                        if ((this.flags & 8) != 0 && this.getClassVersion().equals("BLUE")) {
                            if (this.hb[52] != hbt[52]) {
                                throw new MidasException("Cannot APPEND with formatMode=" + Convert.unpackS(hbt, 52, 1));
                            }
                            if (this.hb[53] != hbt[53]) {
                                throw new MidasException("Cannot APPEND with formatType=" + Convert.unpackS(hbt, 53, 1));
                            }
                            this.readHeader();
                            this.setReps();
                            this.readKeywords(this.getBlueVer(), this.getBlueIO());
                        } else {
                            this.writeHeader();
                        }
                    } else if (this.isOutput) {
                        if (!this.io.open(dir)) {
                            throw new MidasException("Could not open " + url + " for output");
                        }
                        if (this.io.isStream() && this.keywords.size > 0 && this.getDetached() == 0) {
                            long start = ((this.hb.length + 511) / 512 + (this.keywords.size + 511) / 512) * 512;
                            this.setDataStart(start);
                            this.writeHeader();
                            this.setDetached(1);
                            this.writeKeywords();
                            this.setDetached(0);
                            this.io.seek(start);
                        } else {
                            this.writeHeader();
                        }
                    }
                }
                this.isOpen = true;
                this.setReps();
                String origBlueVer = this.getBlueVer();
                String origBlueIO = this.getBlueIO();
                if (this.isInput && !this.checkBlueVer()) {
                    if (this.autoConvertPlatinum && PLATINUM_VER.matcher(origBlueVer).matches()) {
                        this.M.info("DataFile: Does not have full support PLATINUM files VER='" + origBlueVer + "' IO='" + origBlueIO + "' found for " + this.getName() + ".");
                    } else {
                        this.M.warning("DataFile: Unsupported BLUE version VER='" + origBlueVer + "' IO='" + origBlueIO + "' found for " + this.getName() + ".");
                    }
                }
                if (this.isOutput && this.isInput) {
                    this.setBlueVerIO();
                }
                if ((qpacket = (String)fn.getQualifier("PACKET")) != null) {
                    this.setPacket(qpacket);
                }
                if ((this.flags & 0x400) != 0) {
                    this.io = null;
                    this.isStream = false;
                } else {
                    this.openPacketHandler();
                    this.isStream = this.io.isStream();
                    if (this.io.isStreaming()) {
                        this.setDataStart(this.io.seek());
                    }
                }
                this.setInternals();
                if (this.getPipeId() < 0) {
                    this.cfsize = this.getOutByte(0) / this.dbpe;
                    this.cftop = this.cfsize * Math.floor(this.getInByte() / this.dbpe / this.cfsize);
                    this.flags |= 4;
                }
                if (this.isOutput && this.isFound && (this.isInput || (this.flags & 8) != 0)) {
                    this.wsize = this.size;
                }
                if (this.isInput) {
                    this.readKeywords(origBlueVer, origBlueIO);
                    if (this.setTrim(fn.getTrimmers()) < 0) {
                        this.M.warning("DataFile: Bad trim string=" + fn.getTrimmers());
                    }
                    if (this.dataType == 80 && !this.getBlueIO().equals("NeXtMidas")) {
                        this.setDataRep("IEEE");
                    }
                }
                if (fn.hasQualifiers()) {
                    Table qualifiers = fn.getQualifierTable();
                    KeyObject.setKeys(this, qualifiers, this.M, 1);
                    this.setInternals();
                    if (this.isOutput) {
                        if (this.isPipe() || this.getDetached() != 0) {
                            this.writeKeywords();
                        }
                        this.writeHeader();
                    }
                }
                if (this.isOpen && !this.isPipe() && this.getDetached() != 0) {
                    if (dir > 0) {
                        Object ds = fn.getQualifier("DS");
                        Object datastart = fn.getQualifier("DATASTART");
                        Object dsval = datastart != null ? datastart : ds;
                        this.setDataStart(Convert.o2l(dsval, this.M, 0));
                    }
                    if ((this.flags & 0x400) == 0) {
                        this.io = this.M.io.findResource(this.getDetachName(), "", "", fn.getQualifierTable(), dir, true);
                        this.io.setLength((long)(this.getDataStart() + this.getDataSize()));
                        if (this.isInput && this.isOutput && this.io.exists()) {
                            if (!this.io.open(0)) {
                                throw new MidasException("Could not open detached data: " + this.io.getURL());
                            }
                        } else if (!this.io.open(dir)) {
                            throw new MidasException("Could not open detached data: URL=" + this.io.getURL());
                        }
                    }
                }
                if ((this.flags & 8) == 0) {
                    this.seek(0.0);
                } else if ((this.flags & 4) == 0) {
                    this.seek(this.wsize);
                } else {
                    this.seek(this.getInByte() / this.dbpe);
                }
                if (this.isInput && this.isOpen) {
                    boolean warn;
                    boolean bl2 = warn = (this.flags & 8) != 0;
                    if (!DataFile.checkType(this.getType(), this.types)) {
                        if (warn) {
                            this.M.warning("DataFile: Unallowed Type=" + this.getType() + " allowable=" + this.types + " for " + this.getName());
                        } else {
                            throw new MidasException("Unallowed Type=" + this.getType() + " allowable=" + this.types);
                        }
                    }
                    if (!DataFile.checkFormat(this.getFormat(), this.formats, this.minimalSupportForUnsupportedDataTypes)) {
                        if (warn) {
                            this.M.warning("DataFile: Unallowed Format=" + this.getFormat() + " allowable=" + this.formats + " for " + this.getName());
                        } else {
                            throw new MidasException("Unallowed Format=" + this.getFormat() + " allowable=" + this.formats);
                        }
                    }
                    if ((this.flags & 0x20000) != 0 && this.size <= 0.0 && !this.isPipe()) {
                        this.M.warning("No data elements in URL=" + url);
                    }
                }
                if (this.isInput && this.isOpen && this.isCreator("<=NXM2.6.0") && this.typeClass == 5) {
                    Time.checkQuadwords(this.M, this);
                }
                if (this.isPipe() && this.timeLine != null) {
                    this.timeLine.setDelta(this.getDelta() / this.dbpe);
                }
            }
            catch (MidasException e) {
                if (this.io != null) {
                    this.io.close();
                }
                if (this.ioh != null && this.ioh != this.io) {
                    this.ioh.close();
                }
                this.isOpen = false;
                if ((this.flags & 0x20) == 0) {
                    throw new MidasException("Could not open " + this.getName() + ": " + e.getMessage(), "flags=" + this.getFlagsString(), e);
                }
                if ((this.M.debug & 1) == 0) break block82;
                this.M.printStackTrace(e);
            }
        }
        return this.isOpen;
    }

    @Override
    public void update() {
        this.resetDataSize();
        if (this.isStream && !this.isPipe()) {
            return;
        }
        this.writeKeywords();
        this.writeHeader();
    }

    @Override
    public void flush() {
        if (!this.isOpen) {
            return;
        }
        if (this.hp != null) {
            this.hp.flush();
        }
        double ds1 = this.getDataSize();
        double ds2 = this.resetDataSize();
        if (this.isStream && !this.isPipe()) {
            return;
        }
        if (this.timeLine != null && this.iop == null && this.ioh != this.io) {
            this.writeKeywords();
        }
        if (ds2 > ds1 || (this.flags & 4) != 0) {
            this.writeHeader();
        }
    }

    private double resetDataSize() {
        double writebyte = this.wsize * this.dbpe;
        if (this.isOutput) {
            if (this.pkh != null) {
                writebyte = this.pkh.dataToPacketOffset(this, writebyte);
            }
            if (!this.isInput || !(writebyte <= this.getDataSize())) {
                this.setDataSize(writebyte, false);
            }
            if ((this.flags & 4) != 0) {
                this.setInByte((this.cftop + this.offset) * this.dbpe);
            }
        }
        return writebyte;
    }

    @Override
    public synchronized void close() {
        if (!this.isOpen) {
            return;
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("CloseDF tag=" + this.tag);
        }
        if (this.cmd != null && this.cmd.state == 7) {
            this.flags |= 0x100;
        }
        if (this.isOutput) {
            this.update();
        }
        if (this.isOutput && (this.flags & 0x20000) != 0 && this.getOffset() == 0.0) {
            this.M.warning("No output written to URL=" + this.getURL());
        }
        if (this.pkh != null) {
            this.pkh.close(this);
        }
        if (this.io != null) {
            this.io.close();
        }
        if (this.ioh != this.io && this.ioh != null) {
            this.ioh.close();
        }
        this.isOpen = false;
    }

    @Override
    public int erase(boolean force) {
        int status = 0;
        if (!this.find(-1)) {
            return 0;
        }
        this.open();
        this.close();
        if (!force && this.getProtected()) {
            return 64;
        }
        status |= this.ioh.delete() ? 1 : 2;
        if (this.getDetached() != 0) {
            status |= this.io.delete() ? 4 : 8;
        }
        if (this.hp != null) {
            status |= this.hp.io.delete() ? 16 : 32;
        }
        return status;
    }

    public int eraseFileName(boolean force) {
        DataFile htmp = new DataFile(this.M, (Object)this.getFileName());
        return htmp.erase(force);
    }

    @Override
    public int rename(String newName) {
        int status = 0;
        if (!this.find(-1)) {
            return 0;
        }
        this.open();
        this.close();
        FileName fni = new FileName(this.getURL());
        FileName fno = new FileName(newName);
        boolean ok = CoreIO.rename(fni.getFullName(), fno.getFullName());
        status |= ok ? 1 : 2;
        if (this.getDetached() != 0) {
            fni.setExt(this.getDetachExt());
            fno.setExt(this.getDetachExt());
            ok = CoreIO.rename(fni.getFullName(), fno.getFullName());
            status |= ok ? 4 : 8;
        }
        if (this.hp != null) {
            fni.setExt("pkt");
            fno.setExt("pkt");
            ok = CoreIO.rename(fni.getFullName(), fno.getFullName());
            status |= ok ? 16 : 32;
        }
        return status;
    }

    public static boolean checkType(int type, String typeList) {
        int typeClass = type / 1000;
        if (typeList == null || typeList.length() == 0) {
            return true;
        }
        int i = typeList.indexOf("" + type);
        if (i < 0) {
            i = typeList.indexOf("" + typeClass + "000");
        }
        if (i < 0 && typeList.charAt(0) != '-') {
            return false;
        }
        return i <= 0 || typeList.charAt(i - 1) != '-';
    }

    public static boolean checkFormat(String format, String formatList) {
        return DataFile.checkFormat(format, formatList, false);
    }

    private static boolean checkFormat(String format, String formatList, boolean minimalSupportOfUnsupportedDataTypes) {
        char mode = format.charAt(0);
        char type = format.charAt(1);
        if (formatList == null || formatList.length() == 0) {
            return true;
        }
        int i = formatList.indexOf(format);
        if (i < 0 && "DFXLIJBNP".indexOf(type) >= 0) {
            i = formatList.indexOf(mode + "#");
        }
        if (i < 0) {
            if (!minimalSupportOfUnsupportedDataTypes) {
                if ("DFXLIJBNPA,Z".indexOf(type) >= 0) {
                    i = formatList.indexOf(mode + "*");
                }
            } else if ("DFXLIJBNPA,ZUV".indexOf(type) >= 0) {
                i = formatList.indexOf(mode + "*");
            }
        }
        if (i < 0 && "123456789X".indexOf(mode) >= 0) {
            i = formatList.indexOf("#" + type);
        }
        if (i < 0 && formatList.charAt(0) != '-') {
            return false;
        }
        return i <= 0 || formatList.charAt(i - 1) != '-';
    }

    public void setPacket(String config) {
        if (config.equals("NONE") || config.equals("NULL")) {
            this.keywords.deleteMain("PACKET");
            this.pkh = null;
            return;
        }
        if (config.charAt(0) == '/') {
            String s = this.getPacket();
            int i = s.indexOf(47);
            config = i > 0 ? s.substring(0, i) + config + s.substring(i) : s + config;
        }
        this.keywords.putMain("PACKET", config);
    }

    public String getPacket() {
        return this.keywords.getMain("PACKET");
    }

    public void setPacketHandler(PacketHandler packetHandler) {
        String config;
        if (this.isOpen) {
            this.M.error("Cannot set PacketHandler on opened URL=" + this.getURL());
        }
        this.pkh = packetHandler;
        this.keywords.deleteMain("PACKET");
        if (this.pkh != null && (config = this.pkh.getConfiguration(this)) != null) {
            this.keywords.putMain("PACKET", config);
        }
    }

    public PacketHandler getPacketHandler() {
        return this.pkh;
    }

    private void openPacketHandler() {
        try {
            String packetConfig = this.keywords.getMain("PACKET");
            if (packetConfig == null) {
                return;
            }
            if ((this.M.debug & 1) != 0) {
                this.M.info("Open PacketHandler Cfg=" + packetConfig);
            }
            Table pt = null;
            boolean strip = false;
            int ip = packetConfig.indexOf(47);
            if (ip > 0) {
                pt = new Table();
                Parser.switchString(packetConfig, pt);
                packetConfig = packetConfig.substring(0, ip);
            }
            if (this.pkh == null) {
                String name = packetConfig.toUpperCase();
                this.pkh = (PacketHandler)Registry.getHandler("PACKET." + name);
                if (this.pkh == null) {
                    throw new MidasException("Unable to load packet handler class for type '" + name + "'.");
                }
            }
            if (pt != null) {
                String paux = (String)pt.get("DET");
                if (paux == null || Convert.isFalseString(paux)) {
                    this.hp = null;
                } else {
                    FileName pfn = new FileName(this.io.getURL());
                    if (!Convert.isTrueString(paux)) {
                        pfn.setPath(this.M.io.getAuxPath(paux));
                        this.hp.aux = paux;
                    }
                    pfn.setExt("pkt");
                    this.pkh.setFileName(this, pfn);
                }
                pt.remove("DET");
                strip = pt.getState("STRIP");
                if (strip) {
                    pt.remove("STRIP");
                }
                if (pt.getSize() > 0) {
                    KeyObject.setKeys(this.pkh, pt);
                }
            }
            this.pkh.open(this);
            if (strip) {
                this.keywords.deleteMain("PACKET");
            } else {
                this.keywords.putMain("PACKET", this.pkh.getConfiguration(this));
            }
        }
        catch (RuntimeException e) {
            if ((this.flags & 0x20) != 0) {
                this.M.warning("DataFile: Unable to open packet handler for " + this.getName() + ": " + e.getMessage());
                this.pkh = null;
            }
            throw e;
        }
    }

    public int getPacketHandlerFlags() {
        return (this.flags | 0x10000) & 0xFFFFFFFB;
    }

    @ProvisionalUseOnly(value="In evaluation phase")
    public static String trimmersFromTimes(String fileName, double tmin, double tmax) {
        DataFile df = new DataFile(Shell.getMidasContext(), (Object)fileName);
        df.open();
        double firstElement = df.getIndexAt(tmin);
        double secondElement = df.getIndexAt(tmax);
        df.close();
        String fileTrimmers = "(" + firstElement + ":" + secondElement + ")";
        return fileTrimmers;
    }

    private int setTrim(String trim) {
        this.trim1 = 0.0;
        this.trim2 = this.size;
        if (trim == null && (this.flags & 4) != 0 && !this.isOutput) {
            trim = "(:)";
        }
        if (trim == null) {
            return 0;
        }
        int ie = trim.length() - 1;
        int ic = trim.indexOf(58);
        if (ic <= 0) {
            return -1;
        }
        double d1 = this.getIndex(trim.substring(1, ic), 1, 0);
        double d2 = this.getIndex(trim.substring(ic + 1, ie), 2, d1, 0);
        return this.setTrimByIndex(d1, d2);
    }

    private int setTrimByAbsc(double d1, double d2) {
        return this.setTrimByIndex(this.getIndex(d1), this.getIndex(d2));
    }

    private int setTrimByIndex(double d1, double d2) {
        double maxOffset;
        double minOffset;
        if ((this.flags & 4) == 0) {
            minOffset = 0.0;
            maxOffset = Math.max(0.0, this.size);
        } else {
            maxOffset = this.getInByte() / this.dbpe;
            minOffset = Math.max(0.0, maxOffset - this.cfsize);
        }
        if (d1 < minOffset) {
            this.M.warning("Trim start=" + d1 + " before file start=" + minOffset);
            d1 = minOffset;
        }
        if (d2 > maxOffset) {
            this.M.warning("Trim end=" + d2 + " past file end=" + maxOffset);
            d2 = maxOffset;
        }
        if (d1 > d2) {
            this.M.warning("Trim start=" + d1 + " after trim end=" + d2);
            d1 = d2;
        }
        this.trim1 = d1;
        this.trim2 = d2;
        this.size = d2 - d1;
        this.trimSet = true;
        this.seek(0.0);
        if ((this.flags & 4) == 0) {
            this.setStart(this.getStart() + d1 * this.getDelta());
        } else {
            this.setStart(0.0);
            this.setTimeCode(this.getTimeAtCurrent());
        }
        return 1;
    }

    @InternalUseOnly
    @Deprecated
    public double getIndex(double value, int mode, double relOff, int addressingMode, int options) {
        double size;
        double start;
        double delta;
        boolean isDelta = mode == 3 || mode == 7 || mode == 4;
        boolean isWrapping = (this.flags & 4) != 0;
        int units = 0;
        if (mode >= 5) {
            delta = this.getXDelta();
            start = this.getXStart();
            size = this.getSubSize();
            units = this.getXUnits();
        } else {
            delta = this.getDelta();
            start = this.getStart();
            size = this.getSize();
            units = this.getUnits();
        }
        if (mode < 5 && isWrapping) {
            size = this.getInByte() / this.dbpe;
        }
        if ((options & 1) != 0) {
            double defIndex = mode == 2 || mode == 6 ? size : (mode == 1 || mode == 5 ? 0.0 : (mode == 3 || mode == 7 ? 1.0 : 0.0));
            if (isWrapping) {
                if (mode == 2) {
                    defIndex = this.getInByte() / this.dbpe;
                } else if (mode == 1) {
                    defIndex = Math.max(0.0, this.getInByte() / this.dbpe - this.cfsize);
                    relOff += defIndex;
                }
            }
            return defIndex;
        }
        if (isWrapping && mode == 1) {
            relOff += Math.max(0.0, this.getInByte() / this.dbpe - this.cfsize);
        }
        boolean relative = (options & 4) != 0 || isDelta;
        boolean fromsize = (options & 8) != 0 && !isDelta;
        boolean abscissa = (options & 2) != 0 || addressingMode >= 2;
        double retIndex = value;
        if (relative) {
            if (abscissa) {
                retIndex /= delta;
            }
            retIndex += relOff;
        } else {
            if (abscissa) {
                boolean timecodeMode;
                if (addressingMode == 0) {
                    addressingMode = 5;
                }
                boolean abscOnlyMode = addressingMode == 2;
                boolean bl = timecodeMode = addressingMode == 4;
                if (units == 1) {
                    abscOnlyMode |= addressingMode == 5 && retIndex <= 1.0E8;
                    timecodeMode |= addressingMode >= 3;
                }
                if (!timecodeMode) {
                    abscOnlyMode = true;
                }
                if (abscOnlyMode) {
                    retIndex = (retIndex - start) / delta;
                } else if (timecodeMode) {
                    retIndex = this.timeLine != null ? this.timeLine.getOffsetAt(retIndex) / this.dbpe : (retIndex - this.getTimeCode() - start) / delta;
                }
            }
            if (fromsize) {
                retIndex = size - retIndex;
            }
        }
        if (mode != 4) {
            retIndex = Math.floor(retIndex + 0.5);
        }
        if (this.pkh != null && !isDelta) {
            retIndex = Math.floor(this.pkh.naturalDataOffset(this, retIndex * this.dbpe) / this.dbpe);
        }
        return retIndex;
    }

    public double getIndex(String arg, int mode, double relOff, int addressingMode) {
        boolean isDelta;
        if (arg == null || arg.length() == 0 || arg.equals("*")) {
            return this.getIndex(0.0, mode, relOff, addressingMode, 1);
        }
        int ii = 0;
        int optionsMask = 0;
        boolean bl = isDelta = mode == 3 || mode == 7 || mode == 4;
        if (arg.charAt(ii) == '+') {
            ++ii;
            optionsMask |= 4;
        }
        if (arg.charAt(ii) == '-' && !isDelta) {
            ++ii;
            optionsMask |= 8;
        }
        if (arg.charAt(ii) == '~') {
            ++ii;
            optionsMask |= 2;
        }
        double d = Convert.s2d(arg.substring(ii), this.M);
        return this.getIndex(d, mode, relOff, addressingMode, optionsMask);
    }

    @Deprecated
    public double getIndex(String arg, int mode, double relOff, boolean absc) {
        int addressingMode = absc ? 2 : 1;
        return this.getIndex(arg, mode, relOff, addressingMode);
    }

    @Deprecated
    public double getIndex(String arg, int mode) {
        return this.getIndex(arg, mode, 0.0, 1);
    }

    public double getIndex(String arg, int mode, int addressingMode) {
        return this.getIndex(arg, mode, 0.0, addressingMode);
    }

    public double getIndex(double dvalue, int mode, int addressingMode) {
        return this.getIndex(dvalue, mode, 0.0, addressingMode, 0);
    }

    @Deprecated
    public double getIndex(String arg, int mode, boolean absc) {
        int addressingMode = absc ? 2 : 1;
        return this.getIndex(arg, mode, 0.0, addressingMode);
    }

    public double getIndex(String arg, int mode, double relOff) {
        return this.getIndex(arg, mode, relOff, 1);
    }

    public double getIndex(double absc) {
        return Math.floor((absc - this.getStart()) / this.getDelta() + 0.5);
    }

    public void align(DataFile h2, boolean absc, boolean tc) {
        DataFile h1 = this;
        double size1 = h1.getSize();
        double size2 = h2.getSize();
        if (absc) {
            double d1 = h1.getDelta();
            double d2 = h2.getDelta();
            double dc = d2 - d1;
            double s1 = h1.getStart();
            double s2 = h2.getStart();
            double sc = s2 - s1;
            double sx = Math.max(s1, s2);
            double e1 = s1 + d1 * size1;
            double e2 = s2 + d2 * size2;
            double ex = Math.min(e1, e2);
            if (d1 == 0.0 || d2 == 0.0) {
                this.M.error("Cannot abscissa align files with delta=0");
            }
            if (Math.abs(dc / d1) > 1.0E-6) {
                this.M.error("Cannot abscissa align files with delta mismatch > 1e-6");
            }
            h1.setTrimByAbsc(sx, ex);
            h2.setTrimByAbsc(sx, ex);
        } else {
            double _size = Math.min(size1, size2);
            h1.setTrimByIndex(0.0, _size);
            h2.setTrimByIndex(0.0, _size);
        }
    }

    private void setReps() {
        this.headRep = this.hb[4];
        this.dataRep = this.hb[8];
    }

    @Override
    public void setInternals() {
        boolean setwsize;
        this.setReps();
        this.typeClass = this.getType() / 1000;
        if (this.typeClass == 2 && this.getSubSize() <= 0) {
            this.setSubSize(1);
        }
        this.dataType = this.getFormatType();
        this.dataMode = this.getFormatMode();
        this.getBPS();
        this.getSPA();
        this.getBPE();
        this.firstbyte = this.getDataStart();
        if (this.typeClass == 6 && this.t6s == null) {
            this.t6s = this.readT6def(false);
        }
        if (this.typeClass != 6 && this.t6s != null) {
            this.t6s = null;
        }
        boolean bl = setwsize = this.wsize != 0.0 && this.wsize == this.size;
        if (this.isOpen && (this.isInput || (this.flags & 8) != 0) && this.dbpe > 0.0) {
            this.setSize();
        }
        if (this.isOpen && setwsize) {
            this.wsize = this.size;
        }
    }

    public void setDFS(int fs) {
        if (this.trimSet) {
            this.trim1 *= (double)this.ape;
            this.trim2 *= (double)this.ape;
        }
        if (fs == 0) {
            this.ape = 1;
            this.dbpe = this.bpa;
            this.typeClass = 1;
            if (this.trimSet) {
                this.seek(0.0);
            }
        } else {
            this.ape = fs;
            this.dbpe = fs * this.bpa;
            this.typeClass = 2;
        }
        if (this.trimSet) {
            this.trim1 /= (double)this.ape;
            this.trim2 /= (double)this.ape;
        }
        if (this.dbpe < 0.0) {
            this.dbpe = -this.dbpe / 8.0;
        }
        this.setSize();
        if ((this.M.debug & 1) != 0) {
            this.M.info("FrameDF tag=" + this.tag + " Frame=" + this.ape + " Size=" + this.size);
        }
    }

    public int addSubRec(String name, String format) {
        return this.setSubRec(-1, name, format, -1, 1, 0, true);
    }

    public int addSubRec(String name, String format, int offset) {
        return this.setSubRec(-1, name, format, offset, 1, 0, true);
    }

    public int addSubRec(String name, String format, int offset, int type, int units) {
        return this.setSubRec(-1, name, format, offset, type, units, true);
    }

    public int addSubRec(String name, String format, int offset, String type, String units) {
        int t = DataFile.getCompTypeID(type, 1);
        int u = DataFile.getUnitsID(units, 0);
        return this.setSubRec(-1, name, format, offset, t, u, true);
    }

    public int addComp(String name, String format, String type, String units) {
        int t = DataFile.getCompTypeID(type, 1);
        int u = DataFile.getUnitsID(units, 0);
        return this.setSubRec(-1, name, format, -1, t, u, true);
    }

    public int addComp(String name, String format, int type, int units) {
        return this.setSubRec(-1, name, format, -1, type, units, true);
    }

    private int setSubRec(int n, String name, String format, int offset, int type, int units, boolean setInt) {
        if (n < 0) {
            n = this.getSubSize();
            this.setSubSize(n + 1);
            int boff = this.getRecLength();
            if (offset < 0) {
                offset = boff;
            }
            if (n == 0) {
                this.setFormat(format);
            }
            boff = this.typeClass == 5 ? (boff += Data.getBPA(format)) : Math.max(boff, offset + Data.getBPA(format));
            this.setRecLength(boff);
        }
        this.setRecName(n, name);
        this.setRecFormat(n, format);
        this.setRecType(n, (byte)type);
        this.setRecUnits(n, (byte)units);
        this.setRecOffset(n, (short)offset);
        if (setInt) {
            this.setInternals();
        }
        return n + 1;
    }

    public void writeHeader() {
        this.writeHeader(this.hb);
    }

    private int writeHeader(byte[] buf) {
        int bytes = buf.length;
        if (this.isPipe()) {
            bytes = this.iop.writeHeader(buf);
        } else {
            long lseek = this.io == this.ioh ? this.io.seek() : 0L;
            bytes = this.ioh.write(buf, 0, bytes, 0L);
            if (this.io == this.ioh) {
                this.io.seek(lseek);
            }
        }
        return bytes;
    }

    private int getHeaderLength(int tc) {
        int bytes = 256;
        int subs = this.getSubSize();
        switch (tc) {
            case 1: {
                bytes += 20;
                break;
            }
            case 2: {
                bytes += 44;
                break;
            }
            case 3: {
                bytes += 48;
                bytes += subs * 8;
                break;
            }
            case 4: {
                bytes += 20;
                break;
            }
            case 5: {
                bytes += 256;
                if (subs <= 14) break;
                bytes += (subs - 14) * 8;
                break;
            }
            case 6: {
                bytes += 48;
            }
        }
        return bytes;
    }

    protected void readHeader() {
        this.readHeader(this.hb);
        String version = this.getVersion();
        if (version.equals("BLUE")) {
            int tc = this.getType() / 1000;
            int bytes = this.getHeaderLength(tc);
            if (bytes > this.hb.length) {
                this.extendHeader(bytes);
                this.readHeader(this.hb);
            }
        } else {
            throw new MidasException("DataFile " + this.getURL() + " does not have a valid BLUE Header");
        }
    }

    private int readHeader(byte[] buf) {
        int bytes = buf.length;
        if (this.isPipe()) {
            this.iop.readHeader(buf);
        } else {
            bytes = this.ioh.read(buf, 0, bytes, 0L);
        }
        return bytes;
    }

    private void extendHeader() {
        int tc = this.getType() / 1000;
        int subs = this.getSubSize();
        if (tc == 3 || tc == 5) {
            this.extendHeader(this.iSub(subs));
        }
        if (this.t6s != null) {
            this.checkT6cap(subs);
        }
        if (this.recNames != null && this.recNames.length < subs) {
            int count = (subs + 35) / 36 * 36;
            String[] names = new String[count];
            System.arraycopy(this.recNames, 0, names, 0, this.recNames.length);
            this.recNames = names;
        }
    }

    private int extendHeader(int bytes) {
        if (bytes <= this.hb.length) {
            return this.hb.length;
        }
        bytes = (bytes + 511) / 512 * 512;
        byte[] hbt = new byte[bytes];
        System.arraycopy(this.hb, 0, hbt, 0, this.hb.length);
        this.hb = hbt;
        if (!this.isPipe()) {
            this.setDataStart(bytes);
        }
        return bytes;
    }

    public int write(Data data) {
        int elements = data.size;
        if (data.ape != this.ape) {
            elements = data.size * data.ape / this.ape;
        }
        return this.write(data, elements);
    }

    public int write(Data data, double index) {
        this.seek(index);
        return this.write(data, data.size);
    }

    public int write(Data data, double index, int elements) {
        this.seek(index);
        return this.write(data, elements);
    }

    public int write(Data data, int elements) {
        int status;
        Object dh;
        if (!this.isOpen) {
            this.offset += (double)elements;
            return 0;
        }
        if (data.writeMult != 1 && elements % data.writeMult != 0) {
            this.M.error("DataFile.write of " + data.getFormat() + " requires writes in multiples of " + data.writeMult + " file:" + this);
        }
        byte[] dbuf = data.buf;
        int boff = data.boff;
        if (elements > data.size) {
            elements = data.size;
        }
        if (data.type != this.dataType) {
            int tbsize = (int)((double)elements * this.dbpe);
            if (this.dataType == 74) {
                tbsize = tbsize * 4 / 3;
            }
            if (this.tempBuf == null || this.tempBuf.length < tbsize) {
                this.tempBuf = new byte[tbsize];
            }
            if (boff > 0) {
                boff /= data.bps;
            }
            Convert.type(dbuf, boff, data.type, this.tempBuf, 0, this.dataType, elements * this.ape * this.spa);
            dbuf = this.tempBuf;
            boff = 0;
        }
        if (data.rep != this.dataRep) {
            if (this.dataType == 72 || this.typeClass == 6) {
                this.convertRecordRep(dbuf, boff, elements, data.rep, this.dataRep);
            } else {
                Convert.rep(dbuf, boff, this.dataType, elements * this.ape * this.spa, data.rep, this.dataRep);
            }
        }
        int bytes = (int)((double)elements * this.dbpe);
        if ((this.M.debug & 1) != 0) {
            this.M.info("WriteDF tag=" + this.tag + " Offset=" + this.offset + " elem=" + elements);
        }
        if ((dh = data.getHeader()) instanceof Time) {
            this.setTimeAt((Time)dh, TimeLine.NotifyInvalidEntry.WARNING);
        }
        if ((status = this.pkh == null ? this.io.write(dbuf, boff, bytes) : this.pkh.write(this, dbuf, boff, bytes, 0L)) != bytes) {
            elements = (int)((double)status / this.dbpe);
        }
        if (elements > 0) {
            this.offset += (double)elements;
        }
        if (this.offset > this.wsize) {
            this.wsize = this.offset;
        }
        if ((this.flags & 4) != 0 && this.offset >= this.cfsize) {
            this.wrapCircularFile();
        }
        if ((this.flags & 0x10) != 0) {
            this.flush();
        }
        return elements;
    }

    public int write(byte[] buf, int boff, int bytes, double index, int recByteOffset) {
        if ((index += (double)recByteOffset / this.dbpe) != this.offset) {
            this.seek(index);
        }
        return this.write(buf, boff, bytes);
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        int status;
        if (!this.isOpen) {
            this.offset += (double)bytes / this.dbpe;
            return 0;
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("WriteDF " + this.tag + " bytes=" + bytes);
        }
        if ((status = this.pkh == null ? this.io.write(buf, boff, bytes) : this.pkh.write(this, buf, boff, bytes, 0L)) > 0) {
            this.offset = (double)Math.round((double)status + this.offset * this.dbpe) / this.dbpe;
        }
        if (this.offset > this.wsize) {
            this.wsize = this.offset;
        }
        if ((this.flags & 4) != 0 && this.offset >= this.cfsize) {
            this.wrapCircularFile();
        }
        if ((this.flags & 0x10) != 0) {
            this.flush();
        }
        return status;
    }

    public int write(long lbuf, int boff, int bytes) {
        int status;
        if (!this.isOpen) {
            this.offset += (double)bytes / this.dbpe;
            return 0;
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("WriteDFn " + this.tag + " bytes=" + bytes);
        }
        if ((status = this.pkh == null ? this.io.write(lbuf, boff, bytes) : this.pkh.write(this, null, boff, bytes, lbuf)) > 0) {
            this.offset = (double)Math.round((double)status + this.offset * this.dbpe) / this.dbpe;
        }
        if (this.offset > this.wsize) {
            this.wsize = this.offset;
        }
        if ((this.flags & 4) != 0 && this.offset >= this.cfsize) {
            this.wrapCircularFile();
        }
        if ((this.flags & 0x10) != 0) {
            this.flush();
        }
        return status;
    }

    public int write(long lbuf, int boff, int bytes, boolean convert2) {
        if (this.isOpen && convert2 && Shell.rep != this.dataRep) {
            int elements = (int)((double)bytes / this.dbpe);
            if (this.dataType == 72) {
                this.convertRecordRep(lbuf, boff, elements, Shell.rep, this.dataRep);
            } else {
                Convert.rep(lbuf, boff, this.dataType, elements * this.ape * this.spa, Shell.rep, this.dataRep);
            }
        }
        return this.write(lbuf, boff, bytes);
    }

    public int read(Data data) {
        int elements = this.xferLength;
        if (elements < 0) {
            elements = data.size;
        }
        if (data.ape != this.ape) {
            elements = data.size * data.ape / this.ape;
        }
        return this.read(data, elements);
    }

    public int read(Data data, double index) {
        int elements = this.xferLength;
        if (elements < 0) {
            elements = data.size;
        }
        this.seek(index);
        return this.read(data, elements);
    }

    public int read(Data data, double index, int elements) {
        this.seek(index);
        return this.read(data, elements);
    }

    @Override
    public int read(Data data, int elements) {
        int soff;
        double tmp;
        if (!this.isOpen || elements <= 0) {
            return 0;
        }
        int boff = data.boff;
        int cons = this.consLength;
        if (elements > data.size) {
            elements = data.size;
        }
        if (!this.isStream) {
            if (this.cftop + this.offset + (double)elements > this.trim1 + this.size) {
                elements = (int)Math.max(0.0, this.trim1 + this.size - this.cftop - this.offset);
            }
            if (this.cfsize > 0.0 && this.offset + (double)elements > this.cfsize) {
                elements = (int)Math.max(0.0, this.cfsize - this.offset);
            }
            if (elements <= 0) {
                return -1;
            }
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("ReadDF tag=" + this.tag + " Offset=" + this.offset + " elem=" + elements);
        }
        int bytes = this.dataType == 80 || this.dataType == 78 || this.dataType == 74 ? ((tmp = (double)elements * this.dbpe) % 1.0 != 0.0 ? (int)tmp + 1 : (int)tmp) : (int)((double)elements * this.dbpe);
        if (this.saveLength > 0) {
            soff = (int)((this.offset - this.saveOffset) * this.dbpe);
            boff = Math.max(0, this.saveLength - soff);
            System.arraycopy(this.saveBuf, soff, data.buf, 0, boff);
            bytes -= boff;
        }
        int status = this.pkh == null ? this.io.read(data.buf, boff, bytes) : this.pkh.read(this, data.buf, boff, bytes, 0L);
        if (this.timeLine != null) {
            this.time = this.getTimeAtCurrent(this.time);
            data.setHeader(this.time);
        }
        if (status < 0) {
            if (status == -2 && this.cmd != null) {
                this.cmd.setState(7);
            }
            return status;
        }
        if (status != bytes) {
            if (elements == data.size && !this.isPipe()) {
                this.M.warning("DataFile " + this.fn + " does not have expected size only able to read " + (double)(status + boff) / this.dbpe + " out of " + elements + " elements");
            }
            elements = (int)((double)(status + boff) / this.dbpe);
        }
        if (cons > elements) {
            this.seek(this.cftop + this.offset + (double)cons - this.trim1);
            this.saveLength = 0;
        } else if (cons >= 0) {
            this.saveOffset = this.offset + (double)cons;
            soff = (int)((double)cons * this.dbpe) + data.boff;
            this.saveLength = bytes + boff - soff;
            if (this.saveBuf == null || this.saveBuf.length < this.saveLength) {
                this.saveBuf = new byte[this.saveLength];
            }
            System.arraycopy(data.buf, soff, this.saveBuf, 0, this.saveLength);
            this.offset += (double)cons;
        } else {
            this.offset += (double)elements;
        }
        if ((this.flags & 4) != 0 && this.offset >= this.cfsize) {
            this.wrapCircularFile();
        }
        if (data.rep != this.dataRep) {
            boff = data.boff;
            if (boff > 0) {
                boff /= this.bps;
            }
            if (this.dataType == 72 || this.typeClass == 6) {
                this.convertRecordRep(data.buf, data.boff, elements, this.dataRep, data.rep);
            } else {
                Convert.rep(data.buf, boff, this.dataType, elements * this.ape * this.spa, this.dataRep, data.rep);
            }
        }
        if (data.type != this.dataType) {
            soff = data.boff;
            boff = soff;
            if (boff > 0) {
                boff /= this.bps;
                soff /= data.bps;
            }
            Convert.type(data.buf, boff, this.dataType, data.buf, soff, data.type, elements * this.ape * this.spa);
        }
        return elements;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int status;
        if (!this.isStream) {
            int elem = (int)((double)bytes / this.dbpe);
            int elements = elem;
            if (this.cftop + this.offset + (double)elements > this.trim1 + this.size) {
                elements = (int)Math.max(0.0, this.trim1 + this.size - this.cftop - this.offset);
            }
            if (this.cfsize > 0.0 && this.offset + (double)elements > this.cfsize) {
                elements = (int)Math.max(0.0, this.cfsize - this.offset);
            }
            if (elements <= 0 && elem > 0) {
                return -1;
            }
            if (elem != elements) {
                bytes = (int)((double)elements * this.dbpe);
            }
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("ReadDFb " + this.tag + " bytes=" + bytes);
        }
        if ((status = this.pkh == null ? this.io.read(buf, boff, bytes) : this.pkh.read(this, buf, boff, bytes, 0L)) > 0) {
            this.offset = (double)Math.round((double)status + this.offset * this.dbpe) / this.dbpe;
        } else if (status == -2 && this.cmd != null) {
            this.cmd.setState(7);
        }
        if ((this.flags & 4) != 0 && this.offset >= this.cfsize) {
            this.wrapCircularFile();
        }
        return status;
    }

    public int read(long lbuf, int boff, int bytes) {
        return this.read(lbuf, boff, bytes, false);
    }

    public int read(long lbuf, int boff, int bytes, boolean convert2) {
        int status;
        if (!this.isStream) {
            int elem = (int)((double)bytes / this.dbpe);
            int elements = elem;
            if (this.cftop + this.offset + (double)elements > this.trim1 + this.size) {
                elements = (int)Math.max(0.0, this.trim1 + this.size - this.cftop - this.offset);
            }
            if (this.cfsize > 0.0 && this.offset + (double)elements > this.cfsize) {
                elements = (int)Math.max(0.0, this.cfsize - this.offset);
            }
            if (elements <= 0 && elem > 0) {
                return -1;
            }
            if (elem != elements) {
                bytes = (int)((double)elements * this.dbpe);
            }
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("ReadDFn " + this.tag + " bytes=" + bytes);
        }
        if ((status = this.pkh == null ? this.io.read(lbuf, boff, bytes) : this.pkh.read(this, null, boff, bytes, lbuf)) > 0) {
            this.offset = (double)Math.round((double)status + this.offset * this.dbpe) / this.dbpe;
        } else if (status == -2 && this.cmd != null) {
            this.cmd.setState(7);
        }
        if ((this.flags & 4) != 0 && this.offset >= this.cfsize) {
            this.wrapCircularFile();
        }
        if (convert2 && status > 0 && this.dataRep != Shell.rep) {
            int elements = (int)((double)status / this.dbpe);
            if (this.dataType == 72) {
                this.convertRecordRep(lbuf, boff, elements, this.dataRep, Shell.rep);
            } else {
                Convert.rep(lbuf, boff, this.dataType, elements * this.ape * this.spa, this.dataRep, Shell.rep);
            }
        }
        return status;
    }

    private void seekF(double offset, int fieldNum) {
        short fieldOffset = this.getRecOffset(fieldNum);
        if ((offset += (double)fieldOffset / this.dbpe) != this.offset) {
            this.seek(offset);
        }
    }

    @Override
    public int seek(double value) {
        this.offset = value + this.trim1 - this.cftop;
        if (!(this.cfsize <= 0.0)) {
            if (this.offset < 0.0 && this.cftop >= this.cfsize) {
                this.cftop -= this.cfsize;
                this.offset += this.cfsize;
            } else if (this.offset >= this.cfsize) {
                this.cftop += this.cfsize;
                this.offset -= this.cfsize;
            }
        }
        if (this.isOutput && this.offset > this.wsize) {
            this.wsize = this.offset;
        }
        double boffset = this.offset * this.dbpe;
        if (this.pkh != null) {
            this.pkh.seek(this, boffset);
        } else if (this.io != null) {
            this.io.seek((long)(this.firstbyte + boffset + 0.1));
        }
        return 0;
    }

    @Override
    public double seek() {
        return this.offset + this.cftop - this.trim1;
    }

    @Override
    public double avail() {
        if (this.isStream) {
            double bytes = this.io.avail();
            if (bytes <= 0.0) {
                return bytes;
            }
            if (bytes < this.dbpe) {
                return 1.0;
            }
            return bytes / this.dbpe;
        }
        return this.trim1 + this.size - (this.offset + this.cftop);
    }

    @Override
    public boolean isReady(double numElements) {
        double availTrimmers = this.trim1 + this.size - (this.offset + this.cftop);
        if (availTrimmers < numElements) {
            numElements = availTrimmers;
        }
        int numBytes = (int)Math.ceil(numElements * this.dbpe);
        return this.io.isReady(numBytes);
    }

    public int processReady(int xfer) {
        if (this.isStream) {
            double bpx;
            double bytes = this.io.avail();
            if (bytes < (bpx = (double)xfer * this.dbpe) && this.isPipe() && this.iop.pipe.inlet == 0) {
                return 1;
            }
            if (bytes <= 0.0) {
                return (int)bytes;
            }
            return (int)(bytes / bpx);
        }
        double elements = this.trim1 + this.size - (this.offset + this.cftop);
        if (elements < (double)xfer) {
            return 1;
        }
        return (int)(elements / (double)xfer);
    }

    public int skip(int elements) {
        double avail = this.avail();
        if (avail < 0.0) {
            return (int)avail;
        }
        if (elements < 0) {
            elements = (int)avail;
        }
        if (elements > 0) {
            if (this.iop != null && this.pkh == null) {
                this.offset += (double)elements;
                this.iop.seek((long)(this.firstbyte + (this.trim1 + this.offset) * this.dbpe));
            } else {
                this.seek(this.cftop + this.offset + (double)elements - this.trim1);
            }
        }
        return elements;
    }

    @Override
    public void connect(int flag) {
        if (this.isPipe()) {
            this.iop.connect(flag);
        }
    }

    public DataFile reOpen() {
        this.close();
        MidasReference ref = this.cmd;
        if (ref == null) {
            ref = this.M;
        }
        DataFile df = new DataFile(ref, (Object)this.getFileName());
        df.flags = this.flags;
        df.open();
        return df;
    }

    public Pipe getPipe() {
        if (this.iop == null) {
            return null;
        }
        return this.iop.pipe;
    }

    @Override
    public String toString() {
        FileName fn = this.getFileName();
        String str = "Type=" + this.getType() + " Resource=" + (this.io != null ? this.io.getTypeString() : " ") + " Name=" + (fn != null ? fn.getBasename() : "") + " Flags=" + this.getFlagsString();
        if (this.M != null && (this.M.debug & 1) != 0) {
            str = str + " @" + Integer.toHexString(this.hashCode());
        }
        return str;
    }

    @Override
    public String listHeader() {
        int extHdrSize;
        int ihs;
        int i;
        int decimalPlaces;
        Time _time;
        boolean all;
        boolean quads = all = this.cmd != null && this.cmd.args.getState("/ALL");
        String list3 = "DataFile (" + this.getVersion() + ")    :  " + this.ioh.getURL() + "\n";
        if (this.getDetached() != 0) {
            list3 = list3 + "DataFile (Detached):  " + this.io.getURL() + "\n";
        }
        if (this.getPacket() != null) {
            list3 = list3 + "Packet Config      :  " + this.getPacket() + "\n";
        }
        boolean hasTimecode = !(_time = this.getTime()).isZero() && this.getTimeCode() != 0.0;
        boolean hasTC_PREC = this.getTCPREC() != 0.0;
        int n = decimalPlaces = hasTC_PREC ? 12 : Time.getDecimalPrecision(_time.getSec());
        if (this.cmd != null && this.cmd.args.isPresent("/PREC")) {
            decimalPlaces = this.cmd.args.getL("/PREC", decimalPlaces);
        }
        if (hasTimecode || hasTC_PREC || all) {
            list3 = list3 + "Timecode           :  " + _time.toString(decimalPlaces) + "\n";
        }
        int xUnits = this.getXUnits();
        int yUnits = this.getYUnits();
        double xStart = this.getXStart();
        double yStart = this.getYStart();
        StringBuffer xsAsTimeSb = new StringBuffer(36);
        StringBuffer ysAsTimeSb = new StringBuffer(36);
        list3 = list3 + this.extractStartTime(_time, hasTimecode, hasTC_PREC, decimalPlaces, xUnits, yUnits, xStart, yStart, xsAsTimeSb, ysAsTimeSb);
        list3 = list3 + "Data Rep (H/D)     :  " + this.getHeadRep() + " / " + this.getDataRep() + "\nNumber of Elements :  " + this.getSize() + "\nFile Type          :  " + this.getType() + "\nData Format        :  " + this.getFormat() + " - " + DataFile.getFormatModeName(this.getFormatMode()) + " " + DataFile.getFormatTypeName(this.getFormatType()) + "\nWrite Protect      :  " + this.getProtected() + "\nAbscissa units     :  " + DataFile.getUnitsName(xUnits) + "\nAbscissa start     :  " + xStart + xsAsTimeSb + "\nAbscissa delta     :  " + this.getXDelta() + "\n";
        if (all || this.getUnits() == 1) {
            if (this.typeClass == 1) {
                list3 = list3 + "Sample Rate (1/xd) :  " + 1.0 / this.getDelta() + " Hz\n";
            }
            if (this.typeClass == 2) {
                list3 = list3 + "Frame Rate  (1/yd) :  " + 1.0 / this.getDelta() + " Hz\n";
            }
            list3 = list3 + "Duration (sz*delta):  " + this.getSize() * this.getDelta() + " sec\n";
            list3 = list3 + "Duration (end-start): " + this.getTimeDuration() + " sec\n";
        }
        if (this.typeClass == 2) {
            list3 = list3 + "Frame Length       :  " + this.getSubSize() + "\nSecondary units    :  " + DataFile.getUnitsName(yUnits) + "\nSecondary start    :  " + yStart + ysAsTimeSb + "\nSecondary delta    :  " + this.getYDelta() + "\n";
        }
        if (this.typeClass == 3) {
            list3 = list3 + "Number Subrecords  :  " + this.getSubSize() + "\nBytes per Record   :  " + this.getRecLength() + "\n";
            for (i = 0; i < this.getSubSize(); ++i) {
                list3 = list3 + "SubRecord Name=" + this.getRecName(i) + "  Format=" + this.getRecFormat(i) + "  Offset=" + this.getRecOffset(i) + "\n";
            }
        }
        if (this.typeClass == 6) {
            list3 = list3 + "Number Subrecords  :  " + this.getSubSize() + "\nBytes per Record   :  " + this.getRecLength() + "\n";
            for (i = 0; i < this.getSubSize(); ++i) {
                list3 = list3 + "SubRecord Name=" + this.getRecName(i) + "  Format=" + this.getRecFormat(i) + "  Offset=" + this.getRecOffset(i) + "  Elem=" + this.getRecElements(i) + "  Min=" + this.getRecMinimum(i) + "  Max=" + this.getRecMaximum(i) + "  Units=" + this.getRecUnitsName(i) + "\n";
            }
        }
        if (this.typeClass == 5) {
            list3 = list3 + "Number Components  :  " + this.getSubSize() + "\nBytes per Record   :  " + this.getRecLength() + "\nFrame of Reference :  " + this.getReferenceFrame() + "\n";
            if (quads || this.getReferenceFrame().startsWith("TOP")) {
                list3 = list3 + "  Altitude         :  " + this.getQuadword(1) + " meters\n  Latitude         :  " + this.getQuadword(2) + " deg\n  Longitude        :  " + this.getQuadword(3) + " deg\n";
            }
            if (quads || this.getReferenceFrame().equals("TOP")) {
                list3 = list3 + "  Azimuth          :  " + this.getQuadword(4) + " deg\n  Elevation        :  " + this.getQuadword(5) + " deg\n  Roll             :  " + this.getQuadword(6) + " deg\n";
            }
            if (quads || this.getReferenceFrame().equals("ECI") || this.getQuadword(9) != 0.0) {
                list3 = list3 + "  Epoch Year       :  " + this.getQuadword(9) + "\n  Epoch Seconds    :  " + this.getQuadword(10) + "\n  Epoch GHA        :  " + this.getQuadword(11) + " radians\n";
            }
            for (i = 0; i < this.getSubSize(); ++i) {
                list3 = list3 + "Component Name=" + this.getRecName(i) + "   Format=" + this.getRecFormat(i) + "  Type=" + this.getRecCompTypeName(i) + "  Units=" + this.getRecUnitsName(i) + "\n";
            }
        }
        if ((ihs = this.getKeyLength()) > 0 || all) {
            list3 = list3 + "IntHeader KeySize  :  " + ihs + " bytes\n";
        }
        if ((extHdrSize = this.getExtSize()) > 0 || all) {
            list3 = list3 + "ExtHeader Size     :  " + extHdrSize + " bytes\n";
        }
        if (this.io != null && this.isPipe()) {
            list3 = list3 + "Pipe Size          :  " + this.iop.pipe.getSize() + " bytes\n";
            list3 = list3 + "Pipe inByte/outByte:  " + this.getInByte() + " / " + this.getOutByte(0) + "\n";
            for (int i2 = 0; i2 <= this.iop.pipe.getMaxOutlets(); ++i2) {
                String pName = i2 == 0 ? "Inlet" : "Outlet " + i2;
                String pStat = "<not attached>";
                if (this.iop.pipe.isAttached(i2)) {
                    pStat = "" + this.getOutByte(i2) + " / " + Convert.ref2String(this.iop.pipe.getOwner(i2));
                }
                list3 = list3 + "  outByte/" + StringUtil.padRight(pName, 9) + ":  " + pStat + "\n";
            }
        }
        if ((this.flags & 4) != 0) {
            list3 = list3 + "CirFile inByte/size:  " + this.getInByte() + " / " + this.getOutByte(0) + "\n";
        }
        if (all) {
            list3 = list3 + "ExtHeader Start    :  " + this.getExtStart() + " (512-byte) blocks\nData start         :  " + this.getDataStart() + " bytes\nData size          :  " + this.getDataSize() + " bytes\nDetached header    :  " + this.getDetached() + "\n";
            list3 = list3 + "pipe mode          :  " + this.getPipeId() + "\nflagmask           :  " + this.getDataMask() + "\ninlet              :  " + this.getInlet() + "\noutlets            :  " + this.getOutlets() + "\noutmask (async)    :  " + this.getOutMask() + "\npipeloc            :  " + this.getPipeLoc() + "\n";
            if (!this.isPipe()) {
                list3 = list3 + "pipesize           :  " + this.getPipeSize() + " bytes\nin_byte            :  " + this.getInByte() + "\nout_byte           :  " + this.getOutByte(0) + "\n";
            }
        }
        try {
            Object _comment = this.keywords.get("COMMENT");
            if (_comment != null) {
                list3 = list3 + "Comment            :  " + _comment + "\n";
            }
        }
        catch (Exception e) {
            this.M.warning("DataFile: Unable to list 'COMMENT' keyword for " + this.getFileName().getFullName());
        }
        return list3;
    }

    private String extractStartTime(Time time, boolean hasTimecode, boolean hasTC_PREC, int decimalPlaces, int xUnits, int yUnits, double xStart, double yStart, StringBuffer xsAsTimeSb, StringBuffer ysAsTimeSb) {
        Time startTime;
        StringBuilder startTimeSource = new StringBuilder(23);
        if (this.timeLine != null) {
            startTime = this.timeLine.getTimeAt(0.0, null);
            startTimeSource.append("TimeLine");
            if (this.timeLine.format != TimeLine.Format.MICROSECOND_PRECISION) {
                decimalPlaces = 12;
            }
        } else {
            startTime = new Time(time);
            if (hasTimecode) {
                startTimeSource.append("TimeCode");
            }
            if (hasTC_PREC) {
                if (startTimeSource.length() > 0) {
                    startTimeSource.append('+');
                }
                startTimeSource.append("TC_PREC");
            }
            if (this.typeClass == 2) {
                if (yUnits == 1 && yStart != 0.0) {
                    Time yTime = Time.toTimeAndStringBuffer(yStart, ysAsTimeSb, " (", ")");
                    startTime.addSec(yTime.getSec());
                    if (startTimeSource.length() > 0) {
                        startTimeSource.append('+');
                    }
                    startTimeSource.append("YStart");
                }
            } else if (xUnits == 1 && xStart != 0.0) {
                Time xTime = Time.toTimeAndStringBuffer(xStart, xsAsTimeSb, " (", ")");
                startTime.addSec(xTime.getSec());
                if (startTimeSource.length() > 0) {
                    startTimeSource.append('+');
                }
                startTimeSource.append("XStart");
            }
        }
        if (startTimeSource.length() > 0) {
            decimalPlaces = Math.max(decimalPlaces, Time.getDecimalPrecision(startTime.getSec()));
            return "Start time         :  " + startTime.toString(decimalPlaces) + " (" + startTimeSource + ")\n";
        }
        return "";
    }

    @Override
    public String listKeywords() {
        StringBuilder sb = new StringBuilder(4096);
        for (Map.Entry<String, Object> kwd : this.keywords.getAll("MAIN", false)) {
            sb.append(Keywords.list(kwd, "MAIN", 18, 0)).append('\n');
        }
        for (Map.Entry<String, Object> kwd : this.keywords.getAll("EXT", false)) {
            sb.append(Keywords.list(kwd, "EXT", 18, 0)).append('\n');
        }
        return sb.toString();
    }

    @Override
    public String listElements(double start, int elements, String format, int flags) {
        String line = "";
        int len = 0;
        int radix = this.flagsToRadix(flags);
        Data data = this.getDataBuffer(elements);
        this.seek(start);
        elements = this.read(data, elements);
        if (elements <= 0) {
            return null;
        }
        switch (this.typeClass) {
            default: {
                line = data.toString(null, 0, elements, radix, true, scalarSeparator, elementSeparator, false).toString();
                break;
            }
            case 2: {
                int i;
                int j;
                int ape = data.ape;
                data.ape = 1;
                int j1 = Math.max(1, j - 4);
                line = ")";
                for (j = this.getSubSize(); j > j1; --j) {
                    String s = data.toString((j - 1) * data.spa, 1, radix);
                    if (line.length() + s.length() > this.listLineWidth / 2) break;
                    line = ',' + s + line;
                }
                String eline = line;
                line = "(";
                for (i = 0; i < j; ++i) {
                    String s = data.toString(i * data.spa, 1, radix);
                    if (line.length() + eline.length() + s.length() + 4 > this.listLineWidth) break;
                    line = line + s;
                    line = line + ',';
                }
                line = i == j ? line + eline.substring(1) : line + "..." + eline;
                data.ape = ape;
                break;
            }
            case 3: 
            case 6: {
                short ioff = 0;
                for (int i = 0; i < this.getSubSize(); ++i) {
                    ioff = this.getRecOffset(i);
                    int n = this.getRecElements(i);
                    Data subdata = data.getAtomAt(ioff, this.getRecFormat(i), n);
                    String subtext = this.getRecName(i);
                    subtext = subdata.type == 68 && subtext.equals("TIME") && subdata.toD() > 1000000.0 ? subtext + "=" + Time.format(subdata.toD(), 1, 6) : subtext + "=" + subdata.toString(0, subdata.size, radix);
                    if (len != 0) {
                        if (len + subtext.length() > this.listLineWidth) {
                            line = line + "\n     ";
                            len = 5;
                        } else {
                            line = line + "  ";
                        }
                    }
                    line = line + subtext;
                    len += subtext.length();
                }
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int ioff = 0;
                for (int i = 0; i < this.getSubSize(); ++i) {
                    Data subdata = data.getAtomAt(ioff, this.getRecFormat(i));
                    String subtext = this.getRecName(i) + "=" + subdata.toString(0, subdata.size, radix);
                    if (len != 0) {
                        if (len + subtext.length() > this.listLineWidth) {
                            line = line + "\n     ";
                            len = 5;
                        } else {
                            line = line + "  ";
                        }
                    }
                    line = line + subtext;
                    len += subtext.length();
                    ioff += subdata.bpe;
                }
            }
        }
        return line + "\n";
    }

    @Override
    public int listElementsPerLine(int lineWidth, String form, int flags) {
        this.listLineWidth = lineWidth;
        byte formatType = this.getFormatType();
        int ncols = formatType == 65 ? (int)((double)(lineWidth - 6) / (1.0 + this.dbpe)) : (formatType == 90 ? (int)((double)(lineWidth - 6) / (1.0 + this.dbpe)) : ((flags & 1) != 0 ? (lineWidth - 6) / (3 + Math.max(1, 2 * this.bps)) : ((flags & 2) != 0 ? (lineWidth - 6) / (3 + Math.max(1, 8 * this.bps)) : (formatType == 78 ? lineWidth / 5 : (formatType == 66 ? lineWidth / 5 : (formatType == 73 ? lineWidth / 7 : (formatType == 74 ? lineWidth / 7 : (formatType == 76 ? lineWidth / 10 : (formatType == 70 ? lineWidth / 10 : (formatType == 68 ? lineWidth / 20 : (formatType == 80 ? lineWidth / 9 * 8 : 8)))))))))));
        ncols = this.typeClass >= 2 ? -this.getSubSize() : Math.max(1, ncols / this.getSPA());
        if (formatType == 80) {
            ncols = Math.max(1, ncols / 8) * 8;
        }
        return ncols;
    }

    private int readKeywords(String origBlueVer, String origBlueIO) {
        int extSize;
        block16: {
            extSize = this.getExtSize();
            int extStart = this.getExtStart();
            long off = (long)extStart * 512L;
            try {
                if (extSize == 0) {
                    this.keywords.init(null, 0, this.headRep);
                } else if (this.iop != null) {
                    this.keywords.init(this.iop.pipe.getDataFile().keywords);
                } else {
                    int len = (extSize + 511) / 512 * 512;
                    byte[] buf = new byte[len];
                    int bytes = this.ioh.read(buf, 0, extSize, off);
                    if (bytes != extSize) {
                        this.M.warning("Size mismatch in reading extended header for file=" + this.getFileName().getFullName());
                    }
                    this.keywords.init(buf, bytes, this.headRep);
                }
                if (this.typeClass == 6) {
                    this.t6s = this.readT6def(true);
                }
                Data tld = (Data)this.keywords.get("TIMELINE");
                try {
                    if (tld != null) {
                        this.newTimeLineFromData(tld);
                    }
                    this.handlePlatinumTimelineKeywords(origBlueVer, origBlueIO);
                    this.handleBlueTCTimelineKeywords(origBlueVer, origBlueIO);
                    if (this.timeLine != null) {
                        this.timeLine.format = this.overrideTimeLineFormat(this.timeLine.format);
                    }
                }
                catch (MidasException me) {
                    this.M.warnStackTrace("Invalid TimeLine for file:" + this.getFileName(), me);
                }
                if (this.isRecordBased()) {
                    String scope = this.keywords.getScope();
                    this.keywords.clearScope();
                    Keywords.Iterator iter = this.keywords.iterator("SECTION-=SUBRECORD_NAMES");
                    if (iter != null) {
                        this.initRecNames();
                        while (iter.hasNext()) {
                            Keywords.Key key = iter.next();
                            int sr = Convert.s2l(key.name.substring(2)) - 1;
                            this.recNames[sr] = key.value.toString();
                        }
                    }
                    this.keywords.setScope(scope);
                }
            }
            catch (Exception e) {
                extSize = -1;
                this.M.warning("DataFile: Unable to read keywords for file=" + this.getFileName().getFullName() + " reason=" + (e instanceof MidasException ? e.getMessage() : e));
                if ((this.M.debug & 1) == 0) break block16;
                this.M.printStackTrace(e);
            }
        }
        if (this.allowablePlatinum && !Convert.o2z(this.getFileName().getQualifier("FORCE"))) {
            this.M.info("Performing auto-conversion Platinum to Blue on file:" + this.filename);
            Table plat2blueTable = Table.fromTableFile(this.M, "nxm.sys.dat.kwconv_plat2blue.tbl");
            plat2blueTable.put("_WARN_MISSING_", true);
            FileUtil.convertKeywordsInPlace(this.M, this, plat2blueTable);
            this.keywords.putMain("VER", BLUE_VER_DEFAULT, true);
        }
        return extSize;
    }

    protected int writeKeywords() {
        String kwsb;
        if (this.timeLine != null && this.timeLine.getSize() > 0 && this.iop == null && !this.sameTimelineKeywords && !this.keywords.getScope().equals("MAIN")) {
            boolean debug;
            boolean bl = debug = (this.M.debug & 1) != 0;
            if ((this.flags & 4) != 0) {
                this.timeLine.purge(this.getInByte() - this.getOutByte(0));
            }
            if (this.usePlatinumTimeline()) {
                if (debug) {
                    this.M.info("DEBUG: writing high precision Platinume time line keywords... to " + this.getName());
                }
                double defTimeDelta = 0.0;
                Time timeEpoch = null;
                Object tmpobj = this.keywords.get("TIME_EPOCH");
                if (tmpobj instanceof String) {
                    try {
                        timeEpoch = new Time((String)tmpobj, 10);
                        defTimeDelta = 1.0E-9;
                    }
                    catch (Exception e) {
                        this.M.warning("Invalid TIME_EPOCH [" + tmpobj + "] specified! Falling back to start of today for epoch. " + e);
                    }
                }
                if (timeEpoch == null) {
                    timeEpoch = this.getTimeAt(0.0, null);
                    defTimeDelta = 0.0;
                }
                double timeDelta = this.keywords.getD("TIME_DELTA", defTimeDelta);
                Map<String, Object> tlKeywords = this.timeLine.toPlatinumKeywords(timeEpoch, timeDelta, this.dbpe);
                this.keywords.delete("TIMELINE");
                this.keywords.putAll(tlKeywords);
            } else if (this.useBlueTCTimeline()) {
                if (debug) {
                    this.M.type("DEBUG: writing high precision BLUE TC time line keywords... to " + this.getName());
                }
                Map<String, Object> tlKeywords = this.timeLine.toBlueTCKeywords(this.dbpe);
                this.keywords.delete("TIMELINE");
                this.keywords.putAll(tlKeywords);
            } else {
                if (debug) {
                    this.M.type("DEBUG: writing microsecond precision TIMELINE keyword... to " + this.getName());
                }
                this.keywords.put("TIMELINE", this.timeLine.toData());
            }
        }
        if (this.typeClass == 6) {
            int len = this.getSubSize();
            this.checkT6cap(len);
            this.keywords.put("SUBREC_DESCRIP", "TYPE0");
            this.keywords.put("SUBREC_DEF", this.t6s.substring(0, len * 96));
        }
        if (this.isRecordBased()) {
            String scope = this.keywords.getScope();
            this.keywords.clearScope();
            this.keywords.deleteScope("SECTION=-SUBRECORD_NAMES");
            if (this.recNames != null) {
                int max = this.t6s == null ? 4 : 24;
                boolean any = false;
                this.keywords.setScope("EXT");
                for (int sr = 0; sr < this.getSubSize(); ++sr) {
                    if (this.recNames[sr].length() <= max) continue;
                    if (!any) {
                        this.keywords.add("SECTION", "SUBRECORD_NAMES");
                        any = true;
                    }
                    this.keywords.add("SR" + (sr + 1), this.recNames[sr]);
                }
                if (any) {
                    this.keywords.add("SECTION", "END");
                }
            }
            this.keywords.setScope(scope);
        }
        int size = this.keywords.size;
        int start = (this.hb.length + 511) / 512;
        if (this.getDetached() == 0) {
            start = (int)((this.getDataStart() + this.getDataSize() + 511.0) / 512.0);
        }
        if (size == 0) {
            start = 0;
        }
        if ((kwsb = this.keywords.getMain("KWSB")) != null) {
            start = Convert.s2l(kwsb);
        }
        this.setExtSize(size);
        this.setExtStart(start);
        if (size == 0 || this.iop != null) {
            return 0;
        }
        long coffset = this.ioh.seek();
        long offset = (long)start * 512L;
        int len = (size + 511) / 512 * 512;
        int bytes = this.ioh.write(this.keywords.buf, 0, len, offset);
        if (this.io == this.ioh) {
            this.ioh.seek(coffset);
        }
        if (bytes != len) {
            this.M.warning("Err writing extended header to " + this.getName() + " wrote=" + bytes + " expected=" + len + " bytes");
        }
        return bytes;
    }

    public void setKWSB(int blk) {
        this.keywords.putMain("KWSB", "" + blk, false);
    }

    private void initRecNames() {
        int subs = this.getSubSize();
        int min = this.typeClass == 5 ? 14 : 26;
        int num = subs > min ? subs : min;
        this.recNames = new String[num];
        for (int i = 0; i < subs; ++i) {
            this.recNames[i] = this.getRecName(i, true);
        }
    }

    public String getDetachName() {
        String dname = this.io.getURL();
        int i = dname.lastIndexOf(46);
        if (i < 0) {
            return dname;
        }
        return dname.substring(0, i + 1) + this.getDetachExt();
    }

    public String getDetachExt() {
        int lval = this.getDetached();
        if (lval == -1 || lval >= 0 && lval < 128) {
            return "det";
        }
        return this.unpackS(12, 4).toLowerCase();
    }

    public void setKeyScope(String scope) {
        this.keywords.setScope(scope);
    }

    public String getKeyScope() {
        return this.keywords.getScope();
    }

    public Object getKeyWord(String name) {
        return this.keywords.get(name);
    }

    public Object getKeyWord(String name, String scope) {
        this.keywords.setScope(scope);
        Object value = this.keywords.get(name);
        this.keywords.clearScope();
        return value;
    }

    public Data getData(double offset) {
        Data data = this.getDataBuffer(1);
        int ok = this.read(data, offset, 1);
        return ok < 0 ? null : data;
    }

    private Object getDataObject(double offset) {
        if (this.isRecordBased()) {
            return this.getDataTable(offset);
        }
        return this.getData(offset);
    }

    @Override
    public Table getDataTable(double offset) {
        Table tbl = new Table();
        int ok = this.getDataTable(offset, tbl);
        return ok < 0 ? null : tbl;
    }

    @Override
    public int readDataTable(Table tbl) {
        tbl.clear();
        return this.getDataTable(this.seek(), tbl);
    }

    private int getDataTableOld(double offset, Table tbl) {
        if (offset < 0.0) {
            return -3;
        }
        if (this.typeClass == 1 || this.typeClass == 2) {
            Data data = this.getData(offset);
            if (data == null) {
                return -1;
            }
            if (data.type == 80 || data.type == 78) {
                data = this.getBitsFromByte(data, offset);
            }
            for (int i = 0; i < data.getAPE(); ++i) {
                tbl.put("F" + (i + 1), (Object)data.getAtomAt(i));
            }
        } else {
            for (int i = 0; i < this.getSubSize(); ++i) {
                Data data = this.getData(offset, i);
                if (data == null) {
                    return -1;
                }
                if (data.type == 80 || data.type == 78) {
                    data = this.getBitsFromByte(data, offset);
                }
                tbl.put(this.getRecName(i), (Object)data);
            }
        }
        return 1;
    }

    private int getDataTable(double offset, Table tbl) {
        if (offset < 0.0) {
            return -3;
        }
        Data data = this.getData(offset);
        if (data == null) {
            return -1;
        }
        if (this.typeClass == 1 || this.typeClass == 2) {
            if (data.type == 80 || data.type == 78) {
                data = this.getBitsFromByte(data, offset);
            }
            if (data.type == 74 && this.dbpe == 1.5) {
                data = this.getDataFromSJ(data, offset);
            }
            for (int i = 0; i < data.getAPE(); ++i) {
                tbl.put("F" + (i + 1), (Object)data.getAtomAt(i));
            }
        } else {
            for (int i = 0; i < this.getSubSize(); ++i) {
                short fieldOffset = this.getRecOffset(i);
                int numElements = this.getRecElements(i);
                String fieldName = this.getRecName(i);
                String fieldFormat = this.getRecFormat(i);
                Data dataf = null;
                char formatType = fieldFormat.charAt(1);
                if (!this.minimalSupportForUnsupportedDataTypes || numElements > 1 || formatType != 'U' && formatType != 'V') {
                    dataf = new Data(fieldFormat, numElements);
                    System.arraycopy(data.buf, fieldOffset, dataf.buf, 0, dataf.buf.length);
                    if (dataf.type == 80 || dataf.type == 78) {
                        dataf = this.getBitsFromByte(dataf, 0.0);
                    }
                } else {
                    dataf = this.moveUnsignedIntoLargerSigned(fieldFormat, data, numElements, fieldOffset);
                }
                tbl.put(fieldName, (Object)dataf);
            }
        }
        return 1;
    }

    private Data moveUnsignedIntoLargerSigned(String fieldFormat, Data data, int numElements, int fieldOffset) {
        char mode = fieldFormat.charAt(0);
        char type = fieldFormat.charAt(1);
        String newFormat = type == 'U' ? mode + "L" : mode + "X";
        int spa = Data.getSPA(mode);
        int bps = Data.getBPS(type);
        Data dataf = new Data(newFormat, numElements, (Number)0);
        for (int s = 0; s < spa; ++s) {
            System.arraycopy(data.buf, fieldOffset + s * bps, dataf.buf, s * bps * 2, bps);
        }
        return dataf;
    }

    private Data getBitsFromByte(Data data, double offset) {
        if (data.type == 80 || data.type == 78) {
            byte newByte;
            if (data.type == 80) {
                int start = (int)(offset % 8.0);
                if (this.getDataRep().equalsIgnoreCase("IEEE")) {
                    start = 7 - start;
                }
                newByte = (byte)(data.buf[start >> 3] >> (start & 7) & 1);
            } else {
                int start = (int)(offset % 2.0);
                newByte = (byte)(data.buf[start >> 1] << ((start & 1) == 0 ? 28 : 24) >> 28);
            }
            return new Data(newByte);
        }
        return data;
    }

    private Data getDataFromSJ(Data data, double offset) {
        Data newData = offset % 2.0 == 0.0 ? new Data((short)(data.buf[1] << 12 | (0xFF & data.buf[0]) << 4)) : new Data((short)(data.buf[1] << 8 | 0xF0 & data.buf[0]));
        return newData;
    }

    public int writeDataTable(Table tbl) {
        return this.setData(this.seek(), tbl);
    }

    public final Table getDataT(double offset) {
        return this.getDataTable(offset);
    }

    public final Table getRecord(double offset) {
        return this.getDataTable(offset);
    }

    public Data getData(double offset, String fieldName) {
        return this.getData(offset, this.findRec(fieldName));
    }

    public Data getDataZ(double offset, int fieldNum) {
        Data data = null;
        if (fieldNum >= 0 && fieldNum < this.getRecordDefCount()) {
            String fieldFormat = this.getRecFormat(fieldNum);
            int numElements = this.getRecElements(fieldNum);
            data = new Data(fieldFormat, numElements);
            this.seekF(offset, fieldNum);
            int status = this.read(data.buf, 0, data.buf.length);
            if (status != data.buf.length) {
                data = null;
            } else if (data.rep != this.dataRep) {
                Convert.rep(data.buf, 0, fieldFormat, numElements, this.dataRep, data.rep);
            }
        }
        return data;
    }

    public Data getData(double offset, int fieldNum) {
        if (fieldNum < 0 || fieldNum >= this.getRecordDefCount()) {
            return null;
        }
        Data data = this.getData(offset);
        if (data == null) {
            return null;
        }
        short fieldOffset = this.getRecOffset(fieldNum);
        int numElements = this.getRecElements(fieldNum);
        String fieldFormat = this.getRecFormat(fieldNum);
        Data dataf = new Data(fieldFormat, numElements);
        System.arraycopy(data.buf, fieldOffset, dataf.buf, 0, dataf.buf.length);
        return dataf;
    }

    @Override
    public void insertData(double offset, Object obj) {
        if (offset < 0.0) {
            offset = this.getSize();
        }
        Data buf = this.getDataBuffer(1);
        while (this.getSize() < offset) {
            this.write(buf, this.getSize());
            this.setSize(this.wsize);
        }
        this.write(buf, this.getSize());
        this.setSize(this.wsize);
        for (double pos = this.getSize() - 2.0; pos >= offset; pos -= 1.0) {
            this.setData(pos + 1.0, this.getDataObject(pos));
        }
        this.setData(offset, obj);
    }

    @Override
    public void removeData(double offset) {
        this.removeData(offset, 1L);
    }

    @Override
    public void removeData(double offset, long count) {
        if (offset < this.getSize() && count != 0L) {
            if (this.wsize == 0.0) {
                this.wsize = this.getSize();
            }
            if (count > 0L) {
                for (double pos = offset; pos < this.getSize() - (double)count; pos += 1.0) {
                    this.setData(pos, this.getDataObject(pos + (double)count));
                }
                this.wsize -= (double)count;
            } else {
                this.wsize = offset;
            }
            this.setSize(this.wsize);
        }
    }

    public void setData(double offset, Object obj) {
        if (obj instanceof Table) {
            this.setData(offset, (Table)obj);
        } else {
            Data data = Convert.o2Data(obj, (char)this.dataType, (Object)this.M);
            this.write(data, offset, 1);
        }
    }

    @Override
    public void setData(double offset, String fieldName, Object obj) {
        int fieldNum = this.findRec(fieldName);
        if (fieldNum >= 0) {
            this.setData(offset, fieldNum, obj);
        } else {
            this.M.warning("DataFile: Invalid Field name '" + fieldName + "'");
        }
    }

    public void setData(double offset, int fieldNum, Object obj) {
        if (fieldNum >= 0 && fieldNum < this.getRecordDefCount()) {
            char type;
            String fieldFormat = this.getRecFormat(fieldNum);
            int numElements = this.getRecElements(fieldNum);
            if (this.minimalSupportForUnsupportedDataTypes && ((type = fieldFormat.charAt(1)) == 'U' || type == 'V')) {
                this.M.warning("DataFile: No support for modifying type " + type + " fields");
                return;
            }
            Data data = Data.fromObject(obj, fieldFormat, numElements, this.M);
            if (data.rep != this.dataRep) {
                Convert.rep(data.buf, 0, fieldFormat, numElements, this.dataRep, data.rep);
            }
            this.seekF(offset, fieldNum);
            this.write(data.buf, 0, data.buf.length);
        } else {
            this.M.warning("DataFile: Invalid Field number " + fieldNum);
        }
    }

    @Override
    public int setData(double offset, Table table) {
        for (int i = 0; i < this.getRecordDefCount(); ++i) {
            this.setData(offset, i, table.get(this.getRecName(i)));
        }
        return 1;
    }

    @KeyObjectNames(value={"getFrameSize"})
    public int getFrameSize() {
        return this.getSubSize();
    }

    @KeyObjectNames(value={"setFrameSize"})
    public void setFrameSize(int fs) {
        boolean setwsize = this.wsize != 0.0 && this.wsize == this.size;
        int tc = this.getType() / 1000;
        double dbpei = this.dbpe;
        if (fs == 0 && tc == 2) {
            this.setType(1000);
        } else if (fs > 0 && tc == 1) {
            this.setType(2000);
            this.setYStart(this.getXStart());
            this.setYDelta((double)fs * this.getXDelta());
            this.setYUnits(this.getXUnits());
            this.setXStart(0.0);
            this.setSubSize(fs);
        } else if (fs > 0 && tc == 2) {
            this.setSubSize(fs);
        }
        this.typeClass = this.getType() / 1000;
        this.getBPE();
        this.setSize();
        this.trim1 = this.trim1 * dbpei / this.dbpe;
        this.trim2 = this.trim2 * dbpei / this.dbpe;
        if (this.isOpen && setwsize) {
            this.wsize = this.size;
        }
    }

    public String getUniqueRecName(String prefix, int irec, String oname) {
        return this.getUniqueRecName(prefix, irec, oname, false);
    }

    public String getUniqueRecName(String prefix, int irec, String oname, boolean warn) {
        String name = irec > 99 ? prefix.substring(0, 1) + irec : (irec > 9 ? prefix.substring(0, 2) + irec : prefix.substring(0, 3) + irec);
        if (oname != null) {
            for (int i = 0; i < this.getSubSize(); ++i) {
                if (!oname.equals(this.getRecName(i))) continue;
                if (warn) {
                    this.M.warning("SubRecName " + oname + " conflicts. Rename to " + name);
                }
                oname = name;
            }
            name = oname;
        }
        return name;
    }

    public void setSubRecords(String value) {
        if (!this.isRecordBased()) {
            this.setType(3000);
        }
        this.setSubRecords(value, false);
    }

    private void setSubRecords(String value, boolean comp) {
        if (value.startsWith("+")) {
            value = value.substring(1);
        } else {
            this.setSubSize(0);
            this.setRecLength(0);
        }
        int i = value.indexOf(40);
        int j = value.lastIndexOf(41);
        if (i == 0 && j > 0) {
            value = value.substring(1, j);
        }
        if (value.length() > 0) {
            Parser st = new Parser(value);
            for (int k = 1; k <= st.elements(); ++k) {
                String recString = st.get(k);
                this.setSubRec(-k, recString, comp);
            }
        }
        this.setInternals();
    }

    private void setSubRec(int n, String recString, boolean comp) {
        int recUnits;
        int recType;
        int recOffset;
        String recFormat;
        String recName;
        Parser recTokens = new Parser(recString);
        if (recString.indexOf(47) >= 0) {
            recTokens.setDelimiter('/');
        }
        if (recString.indexOf(124) >= 0) {
            recTokens.setDelimiter('|');
        }
        int nt = recTokens.elements();
        if (n < 0) {
            int k = -n;
            recName = comp ? "C" + k : "SR" + k;
            recFormat = "SF";
            recOffset = -1;
            recType = comp ? 1 : 0;
            recUnits = 0;
        } else {
            recName = this.getRecName(n);
            recFormat = this.getRecFormat(n);
            recOffset = this.typeClass == 5 ? -1 : (int)this.getRecOffset(n);
            recType = this.getRecCompType(n);
            recUnits = this.getRecUnits(n);
        }
        if (nt > 0) {
            recName = recTokens.get(1);
        }
        if (nt > 1) {
            recFormat = recTokens.get(2);
        }
        if (comp) {
            if (nt > 2) {
                recType = DataFile.getCompTypeID(recTokens.get(3), recType);
            }
            if (nt > 3) {
                recUnits = DataFile.getUnitsID(recTokens.get(4), recUnits);
            }
        } else {
            if (nt > 2) {
                recOffset = Convert.s2l(recTokens.get(3));
            }
            if (nt > 3) {
                recType = DataFile.getCompTypeID(recTokens.get(4), recType);
            }
            if (nt > 4) {
                recUnits = DataFile.getUnitsID(recTokens.get(5), recUnits);
            }
        }
        this.setSubRec(n, recName, recFormat, recOffset, recType, recUnits, false);
    }

    @KeyObjectNames(value={"setSubRec"})
    public void setSubRec(int n, String value) {
        int i = value.indexOf(40);
        int j = value.lastIndexOf(41);
        if (i == 0 && j > 0) {
            value = value.substring(1, j);
        }
        this.setSubRec(n, value, false);
        this.setInternals();
    }

    public void setComponents(String value) {
        if (this.typeClass != 5) {
            this.setType(5000);
        }
        this.setSubRecords(value, true);
    }

    @KeyObjectNames(value={"setComp"})
    public void setComp(int n, String value) {
        int i = value.indexOf(40);
        int j = value.lastIndexOf(41);
        if (i == 0 && j > 0) {
            value = value.substring(1, j);
        }
        this.setSubRec(n, value, true);
        this.setInternals();
    }

    @Override
    public Data getDataBuffer(int elements) {
        return this.getDataBuffer(elements, this.dataType);
    }

    public final Data createDataBuffer(int elements) {
        return this.getDataBuffer(elements);
    }

    public Data getDataBuffer(int elements, char type) {
        return this.getDataBuffer(elements, (byte)type);
    }

    public final Data createDataBuffer(int elements, char type) {
        return this.getDataBuffer(elements, type);
    }

    public Data getDataBuffer(int elements, byte type) {
        Data data = new Data();
        int fbytes = this.dataType == 80 ? (int)(8.0 * this.dbpe + 0.9) : (int)this.dbpe;
        int dbytes = type != this.dataType ? this.ape * Data.getSPA(this.dataMode) * Data.getBPS(type) : fbytes;
        data.setFormatType(type);
        data.setFormatMode(this.dataMode);
        if (this.typeClass == 2) {
            data.setFrame(this.ape);
        }
        if (this.isRecordBased()) {
            data.setRecLength(dbytes);
        }
        data.setSize(elements);
        if (fbytes > dbytes) {
            data.buf = new byte[elements * fbytes];
        }
        this.xferLength = elements;
        return data;
    }

    public final Data createDataBuffer(int elements, byte type) {
        return this.getDataBuffer(elements, type);
    }

    public void setPreserveDataBuffer(boolean state) {
        this.preserveDB = state;
    }

    public double getBPE() {
        this.ape = this.typeClass >= 2 ? this.getSubSize() : 1;
        this.dbpe = this.typeClass >= 3 ? (double)this.getRecLength() : (this.typeClass >= 2 ? (double)(this.ape * this.getBPA()) : (double)this.getBPA());
        if (this.dbpe < 0.0) {
            this.dbpe = -this.dbpe / 8.0;
        }
        return this.dbpe;
    }

    public int getBPA() {
        this.bpa = Data.getSPA(this.dataMode) * Data.getBPS(this.dataType);
        if (this.bpa < 0 && -this.bpa % 8 == 0) {
            this.bpa = -this.bpa / 8;
        }
        return this.bpa;
    }

    public int getAPE() {
        this.ape = this.typeClass >= 2 ? this.getSubSize() : 1;
        return this.ape;
    }

    public int getSPA() {
        this.spa = Data.getSPA(this.dataMode);
        return this.spa;
    }

    public int getBPS() {
        this.bps = Data.getBPS(this.dataType);
        return this.bps;
    }

    private void wrapCircularFile() {
        double cur = this.seek();
        if (this.wsize > this.cfsize) {
            this.cfsize = this.wsize;
            this.setOutByte(0, this.cfsize * this.dbpe);
        }
        this.cftop += this.cfsize;
        this.seek(cur);
    }

    public void setCircularFileLength(double length) {
        if (length > 0.0) {
            this.setPipeId(-1);
            this.flags |= 4;
            this.cfsize = Math.max(this.cfsize, (double)Math.round(length / this.getDelta()));
        } else {
            this.setPipeId(0);
            this.flags &= 0xFFFFFFFB;
            this.cfsize = 0.0;
        }
        this.setOutByte(0, this.cfsize * this.dbpe);
    }

    public double getCircularFileOffset() {
        return this.getInByte() / this.dbpe * this.getDelta();
    }

    public void setTimeLineLength(int tll) {
        if (this.timeLine == null) {
            this.newTimeLine();
        }
        this.timeLine.setAlloc(tll);
    }

    public int getTimeLineLength() {
        return this.getTimeLineLength(TimeLine.getUsecPrecisionAllocDefault());
    }

    private int getTimeLineLength(int tll) {
        if (this.timeLine != null) {
            tll = this.timeLine.getAlloc();
        } else if (this.cmd != null && this.cmd.args.find("/TLL")) {
            int tllSwitch = this.cmd.args.getL("/TLL");
            tll = tllSwitch > -128 && tllSwitch < 128 ? (tllSwitch == -1 || tllSwitch < -128 ? tllSwitch : Math.max(tll, tllSwitch)) : tllSwitch;
        }
        return tll;
    }

    public void setTimeLineTolerance(double tolr) {
        if (this.timeLine == null) {
            this.newTimeLine();
        }
        this.timeLine.setTolerance(tolr);
    }

    public double getTimeLineTolerance() {
        double tlt = 0.1;
        if (this.timeLine != null) {
            tlt = this.timeLine.getTolerance();
        } else if (this.cmd != null && this.cmd.args.find("/TLT")) {
            tlt = this.cmd.args.getD("/TLT");
        }
        return tlt;
    }

    void setTimeLineFormat(TimeLine.Format format) {
        if (this.timeLine == null) {
            this.newTimeLine();
        }
        this.timeLine.format = format;
    }

    private double getTimeLineDelta() {
        return this.timeLine == null ? this.getDelta() / this.dbpe : this.timeLine.getDelta();
    }

    private void newTimeLine() {
        if (this.dbpe == 0.0) {
            throw new MidasException("Cannot initialize TimeLine until after sub-records are defined for type=" + this.getType() + " with format=" + this.getFormat() + " for " + this.getName());
        }
        TimeLine.Format formatOfKeywords = this.timeLineFormatFromKeywords();
        TimeLine.Format format = TimeLine.Format.MICROSECOND_PRECISION;
        if (this.timeLine == null) {
            Object tllQual = this.getQualifier("TLL");
            int tll = tllQual != null ? Convert.o2l(tllQual) : this.getTimeLineLength(0);
            double tolr = 0.1;
            TimeLine.Format overrideFormat = this.overrideTimeLineFormat(null);
            if (overrideFormat != null) {
                if (overrideFormat == TimeLine.Format.MICROSECOND_PRECISION) {
                    if (tll == 0) {
                        tll = TimeLine.getUsecPrecisionAllocDefault();
                    }
                    if (this.sourceTimeLineTolr != 0.0) {
                        tolr = Math.max(this.sourceTimeLineTolr, 1.0E-6);
                    }
                } else {
                    if (tll == 0) {
                        tll = TimeLine.getHighPrecisionAllocDefault();
                    }
                    tolr = 2.5E-10;
                }
                format = overrideFormat;
            } else if (formatOfKeywords != null) {
                if (formatOfKeywords == TimeLine.Format.MICROSECOND_PRECISION) {
                    if (tll == 0) {
                        tll = TimeLine.getUsecPrecisionAllocDefault();
                    }
                    Data tld = (Data)this.keywords.get("TIMELINE");
                    tolr = tld.getD(1);
                } else {
                    if (tll == 0) {
                        tll = TimeLine.getHighPrecisionAllocDefault();
                    }
                    tolr = 2.5E-10;
                }
                format = formatOfKeywords;
            } else if (this.sourceTimeLineFormat != null) {
                if (this.sourceTimeLineFormat == TimeLine.Format.MICROSECOND_PRECISION) {
                    if (tll == 0) {
                        tll = TimeLine.getUsecPrecisionAllocDefault();
                    }
                    if (this.sourceTimeLineTolr != 0.0) {
                        tolr = this.sourceTimeLineTolr;
                    }
                } else {
                    if (tll == 0) {
                        tll = TimeLine.getHighPrecisionAllocDefault();
                    }
                    tolr = 2.5E-10;
                }
                format = this.sourceTimeLineFormat;
            }
            if (tll == 0) {
                tll = 128;
            }
            this.timeLine = new TimeLine(tll, this.getTimeLineDelta(), tolr);
        } else {
            this.M.info("This DataFile has existing TimeLine, but a new one is being created :" + this);
            Object tllQual = this.getQualifier("TLL");
            int tll = tllQual != null ? Convert.o2l(tllQual) : this.getTimeLineLength();
            this.timeLine = new TimeLine(tll, this.getTimeLineDelta(), 0.1);
            format = this.timeLine.format;
        }
        this.timeLine.format = format;
        if (!this.sameTimelineKeywords) {
            this.deleteTCKeywords();
        }
    }

    private TimeLine.Format timeLineFormatFromKeywords() {
        TimeLine.Format format = null;
        Data tld = (Data)this.keywords.get("TIMELINE");
        if (tld != null) {
            format = TimeLine.Format.MICROSECOND_PRECISION;
        } else if (this.keywords.get("TCSAMPLE_1") != null) {
            format = TimeLine.Format.BLUE_HIGH_PRECISION;
        } else if (this.keywords.get("TIMETAG.OFFSET") != null) {
            format = TimeLine.Format.PLATINUM_HIGH_PRECISION;
        }
        return format;
    }

    private boolean deletePlatinumTimeLineKeywords() {
        if (this.keywords.delete("TIMETAG.OFFSET") != 0) {
            this.keywords.delete("TIMETAG.TIME");
            this.keywords.delete("TIMETAG.TIME.UNITS");
            this.keywords.delete("TIME_EPOCH");
            this.keywords.delete("TIME_DELTA");
            this.keywords.delete("TIME_TICKS");
            if (this.timeLine != null) {
                this.timeLine.format = TimeLine.Format.PLATINUM_HIGH_PRECISION;
                this.timeLine.setTolerance(2.5E-10);
            }
            return true;
        }
        return false;
    }

    private boolean deleteTCKeywords() {
        int i = 1;
        while (this.keywords.delete("TCSAMPLE_" + i) != 0) {
            this.keywords.delete("TC_WHOLE_" + i);
            this.keywords.delete("TC_FRAC_" + i);
            ++i;
        }
        boolean keywordsDeleted = i > 1;
        if (keywordsDeleted & this.timeLine != null) {
            this.timeLine.format = TimeLine.Format.BLUE_HIGH_PRECISION;
            this.timeLine.setTolerance(2.5E-10);
        }
        return keywordsDeleted;
    }

    @InternalUseOnly
    public boolean deleteTimeLineKeywords() {
        boolean someKeywordsRemoved = this.keywords.delete("TIMELINE") != 0;
        someKeywordsRemoved |= this.deletePlatinumTimeLineKeywords();
        return someKeywordsRemoved |= this.deleteTCKeywords();
    }

    @InternalUseOnly
    public boolean deleteNonTimeLineKeywords() {
        String[] extKeys;
        boolean keywordsWereDeleted = false;
        for (String key : extKeys = this.keywords.getKeys("EXT")) {
            Matcher matchTC = TimeLine.TIMELINE_KEYWORD_PATTERN.matcher(key);
            if (matchTC.matches()) continue;
            this.keywords.delete(key);
            keywordsWereDeleted = true;
        }
        return keywordsWereDeleted;
    }

    void newTimeLineFromDF(DataFile in) {
        this.timeLine = new TimeLine(in.getTimeLineLength(), in.getTimeLineDelta(), in.getTimeLineTolerance());
    }

    private void newTimeLineFromData(Data data) {
        this.newTimeLine();
        CoreIO coreIO = Shell.getMidasContext().io;
        int timeLineSize = (data.size * data.spa - 2) / 2;
        if (!TimeLine.dataObjectTimelineStartsWithFirstElement(data) && this.getTime().getSec() > 0.0) {
            boolean disableErrorMsg = coreIO.isOptionSet(CoreIO.IOOptions.SuppressInvalidTimeLineEntryErrors);
            if (!disableErrorMsg) {
                String warning = "TimeLine entries for " + this.fn + " do not start at the first element.";
                if (this.offset0AutoCorrectIsEnabled) {
                    warning = warning + "  Inserting entry for offset 0 based on TimeCode";
                }
                this.M.warning(warning);
            }
            if (this.offset0AutoCorrectIsEnabled) {
                ++timeLineSize;
            }
        }
        this.timeLine.setAlloc(timeLineSize);
        this.timeLine.fromData(data, this.getTime().addSec(this.getStart()));
    }

    @ProvisionalUseOnly(value="This API is still under evaluation")
    public void updateTimeLineFromKeywords() {
        this.timeLine = null;
        Data tld = (Data)this.keywords.get("TIMELINE");
        if (tld != null) {
            this.newTimeLineFromData(tld);
        }
        this.handlePlatinumTimelineKeywords(this.getBlueVer(), this.getBlueIO());
        this.handleBlueTCTimelineKeywords(this.getBlueVer(), this.getBlueIO());
    }

    @ProvisionalUseOnly(value="This API is still under evaluation")
    public void updateKeywordsAndTimeLine(Map<String, Object> map) {
        this.keywords.putAll(map);
        this.updateTimeLineFromKeywords();
    }

    public TimeLine getTimeLineHandler() {
        return this.timeLine;
    }

    void setTimeLineHandler(TimeLine tl) {
        if (tl != null) {
            throw new MidasException("DataFile: Use TimeLine.setTimeLineObject(..) or the setTimeAt(..) method to alter the TimeLine.");
        }
        this.timeLine = tl;
    }

    public void setTimeLineObject(TimeLine tl) {
        this.timeLine = tl;
    }

    public boolean isFile() {
        return this.io != null && this.io.isFile();
    }

    public boolean isJarFile() {
        return this.io != null && this.io.isJarFile();
    }

    public boolean isPipe() {
        return this.io != null && this.io.isPipe();
    }

    public String getVersion() {
        return this.unpackS(0, 4);
    }

    public String getHeadRep() {
        return this.unpackS(4, 4);
    }

    public String getDataRep() {
        return this.unpackS(8, 4);
    }

    public int getDetached() {
        return this.unpackL(12);
    }

    @Override
    public boolean getProtected() {
        return this.unpackL(16) != 0;
    }

    public int getPipeId() {
        return this.unpackL(20);
    }

    public int getExtStart() {
        return this.unpackL(24);
    }

    public int getExtSize() {
        return this.unpackL(28);
    }

    public double getDataStart() {
        return this.unpackD(32);
    }

    public double getDataSize() {
        return this.unpackD(40);
    }

    @Override
    public int getType() {
        return this.unpackL(48);
    }

    @Override
    public int getTypeCodeClass() {
        return this.typeClass;
    }

    @Override
    public String getFormat() {
        return this.unpackS(52, 2);
    }

    public byte getFormatMode() {
        return this.unpackB(52);
    }

    public byte getFormatType() {
        return this.unpackB(53);
    }

    public short getDataMask() {
        return this.unpackI(54);
    }

    public double getTimeCode() {
        return this.unpackD(56);
    }

    public short getInlet() {
        return this.unpackI(64);
    }

    public short getOutlets() {
        return this.unpackI(66);
    }

    public int getOutMask() {
        return this.unpackL(68);
    }

    public int getPipeLoc() {
        return this.unpackL(72);
    }

    public int getPipeSize() {
        return this.isPipe() ? this.iop.pipe.getSize() : this.unpackL(76);
    }

    public double getInByte() {
        return this.isPipe() ? this.iop.pipe.getInByte() : this.unpackD(80);
    }

    public double getOutByte(int i) {
        return this.isPipe() ? this.iop.pipe.getOutByte(i) : this.unpackD(88 + i * 8);
    }

    public int getKeyLength() {
        return this.unpackL(160);
    }

    public String getKeywords() {
        return new String(this.hb, 164, this.getKeyLength());
    }

    public Keywords getKeywordsObject() {
        return this.keywords;
    }

    @Override
    public double getXStart() {
        return this.unpackD(256);
    }

    @Override
    public double getXDelta() {
        return this.unpackD(264);
    }

    @Override
    public int getXUnits() {
        return this.unpackL(272);
    }

    public String getXUnitsName() {
        return DataFile.getUnitsVarName(this.getXUnits());
    }

    public int getSubSize() {
        return this.unpackL(276);
    }

    @Override
    public double getYStart() {
        return this.unpackD(280);
    }

    @Override
    public double getYDelta() {
        return this.unpackD(288);
    }

    @Override
    public int getYUnits() {
        return this.unpackL(296);
    }

    public String getYUnitsName() {
        return DataFile.getUnitsVarName(this.getYUnits());
    }

    public int getRecLength() {
        return this.unpackL(300);
    }

    public int getHeaderLength() {
        int len = this.getHeaderLength(this.typeClass);
        return Math.max(512, len);
    }

    public String getRecName(int i) {
        return this.getRecName(i, false);
    }

    public String getRecName(int i, boolean raw) {
        if (!raw && this.recNames != null) {
            return this.recNames[i];
        }
        if (!this.isRecordBased()) {
            return "F" + (i + 1);
        }
        return this.t6s != null ? this.getT6s(i, 0, 24).trim() : this.unpackS(this.iSub(i), 4);
    }

    public String getRecFormat(int i) {
        if (this.isRecordBased()) {
            return this.t6s != null ? this.getT6s(i, 88, 2) : this.unpackS(this.iSub(i) + 4, 2);
        }
        return this.getFormat();
    }

    public byte getRecFormatMode(int i) {
        return (byte)this.getRecFormat(i).charAt(0);
    }

    public byte getRecFormatType(int i) {
        return (byte)this.getRecFormat(i).charAt(1);
    }

    public short getRecOffset(int i) {
        if (this.t6s != null) {
            return (short)this.getT6l(i, 72, 8);
        }
        if (this.typeClass == 3) {
            return this.unpackI(this.iSub(i) + 6);
        }
        String form = this.getFormat();
        if (form.equals("NH")) {
            short ioff = 0;
            while (i > 0) {
                ioff = (short)(ioff + Data.getBPA(this.getRecFormat(--i)));
            }
            return ioff;
        }
        return (short)(Data.getBPA(form) * i);
    }

    public int getRecElements(int i) {
        return this.t6s != null ? this.getT6l(i, 80, 4) : 1;
    }

    public void setRecElements(int i, int val) {
        if (val != 1) {
            this.M.warning("NeXtMidas does not support Type 6000 files with " + val + " rec elements.");
        }
        if (this.t6s != null) {
            this.setT6l(i, 80, 4, val);
        }
    }

    public int getRecUnits(int i) {
        if (this.t6s != null) {
            return this.getT6l(i, 84, 4);
        }
        if (this.typeClass == 5) {
            return this.unpackB(this.iSub(i) + 7);
        }
        return this.getUnits();
    }

    public final String getRecUnitsName(int i) {
        return DataFile.getUnitsVarName(this.getRecUnits(i));
    }

    public int getRecCompType(int i) {
        if (this.typeClass == 5) {
            return this.unpackB(this.iSub(i) + 6);
        }
        return 0;
    }

    public String getRecCompTypeName(int i) {
        return DataFile.getCompTypeName((byte)this.getRecCompType(i), true);
    }

    public double getRecMinimum(int i) {
        return this.t6s != null ? this.getT6d(i, 24, 24) : 0.0;
    }

    public double getRecMaximum(int i) {
        return this.t6s != null ? this.getT6d(i, 48, 24) : 0.0;
    }

    public void setRecMinimum(int i, double val) {
        if (this.t6s != null) {
            this.setT6d(i, 24, 24, val);
        }
    }

    public void setRecMaximum(int i, double val) {
        if (this.t6s != null) {
            this.setT6d(i, 48, 24, val);
        }
    }

    @InternalUseOnly(value="Since initial version, use of this field is discouraged in BLUE ICD.")
    public String getRecUnitsPrefix(int i) {
        return this.t6s != null ? this.getT6s(i, 90, 3) : "";
    }

    @InternalUseOnly(value="Since initial version, use of this field is discouraged in BLUE ICD.")
    public void setRecUnitsPrefix(int i, String val) {
        if (this.t6s != null) {
            int fieldLen = 3;
            if (val.length() < 3) {
                val = StringUtil.padRight(val, 3, '0');
            }
            this.setT6s(i, 90, 3, val);
        }
    }

    @InternalUseOnly(value="Since initial version, use of this field is reserved in BLUE ICD (to pad to 8-byte boundary).")
    public String getRecReserved(int i) {
        return this.t6s != null ? this.getT6s(i, 93, 3) : "";
    }

    void setRecReserved(int i, String val) {
        if (this.t6s != null) {
            int fieldLen = 3;
            if (val.length() < 3) {
                val = StringUtil.padRight(val, 3, '0');
            }
            this.setT6s(i, 93, 3, val);
        }
        if (this.t6s != null) {
            this.setT6s(i, 93, 3, val);
        }
    }

    private String getT6s(int index, int offset, int len) {
        int off = 96 * index + offset;
        return this.t6s.substring(off, off + len);
    }

    private double getT6d(int index, int offset, int len) {
        return Convert.s2d(this.getT6s(index, offset, len));
    }

    private int getT6l(int index, int offset, int len) {
        return Convert.s2l(this.getT6s(index, offset, len));
    }

    private void setT6s(int index, int offset, int len, String str) {
        if (str.length() > len) {
            str = str.substring(0, len);
        }
        if (str.length() < len) {
            str = StringUtil.padRight(str, len);
        }
        this.checkT6cap(index + 1);
        int off = 96 * index + offset;
        this.t6s.replace(off, off + len, str);
    }

    private void setT6d(int index, int offset, int len, double val) {
        String str = StringUtil.padLeft(Double.toString(val), len, '0');
        this.setT6s(index, offset, len, str);
    }

    private void setT6l(int index, int offset, int len, int val) {
        String str = StringUtil.padLeft(Integer.toString(val), len, '0');
        this.setT6s(index, offset, len, str);
    }

    private StringBuffer readT6def(boolean warn) {
        String des = (String)this.keywords.get("SUBREC_DESCRIP");
        String def = (String)this.keywords.get("SUBREC_DEF");
        if (des != null && !des.equals("TYPE0")) {
            this.M.warning("DataFile: Unknown Type 6000 definition SUBREC_DESCRIP='" + des + "'");
        }
        if (def == null && warn) {
            this.M.warning("DataFile: No SUBREC_DEF keyword found in type 6000 file");
        }
        return def == null ? new StringBuffer() : new StringBuffer(def);
    }

    private void checkT6cap(int nsubrec) {
        int len = 96 * nsubrec;
        while (this.t6s.length() < len) {
            this.t6s.append(BLANK_T6_SUBREC);
        }
    }

    public final String getCompName(int i) {
        return this.getRecName(i);
    }

    public final String getCompFormat(int i) {
        return this.getRecFormat(i);
    }

    public final byte getCompType(int i) {
        return (byte)this.getRecCompType(i);
    }

    public final byte getCompUnits(int i) {
        return (byte)this.getRecUnits(i);
    }

    public final String getCompUnitsName(int i) {
        return this.getRecUnitsName(i);
    }

    public String getReferenceFrame() {
        return this.unpackS(416, 8);
    }

    public double getQuadword(int i) {
        return this.unpackD(416 + i * 8);
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public int getXferLength() {
        return this.xferLength;
    }

    public int getTransLength() {
        return this.xferLength;
    }

    public int getConsLength() {
        return this.consLength;
    }

    @Deprecated
    public Keywords getExtended() {
        return this.keywords;
    }

    public double getDataStop() {
        double writebyte = this.wsize * this.dbpe;
        if (this.pkh != null) {
            writebyte = this.pkh.dataToPacketOffset(this, writebyte);
        }
        return this.firstbyte + writebyte;
    }

    public double getNyquist() {
        return 0.5 / this.getXDelta();
    }

    public double getXRate() {
        return 1.0 / this.getXDelta();
    }

    public double getYRate() {
        return 1.0 / this.getYDelta();
    }

    public void setXRate(double rate) {
        this.setXDelta(1.0 / rate);
    }

    public void setYRate(double rate) {
        this.setYDelta(1.0 / rate);
    }

    @Override
    public int getMode() {
        return this.getSPA();
    }

    @Override
    public int getXFrame() {
        return this.getSubSize();
    }

    @Override
    public int getYFrame() {
        return (int)this.getSize();
    }

    public double getLength() {
        return this.getSize() * this.getDelta();
    }

    @Override
    public String getURL() {
        if (this.ioh == null) {
            return this.getFileName().getFullName();
        }
        return this.ioh.getURL();
    }

    public void setVersion(String value) {
        this.packS(0, 4, value);
    }

    public void setHeadRep(String value) {
        this.packS(4, 4, value);
        this.setReps();
    }

    public void setHeadRep(byte value) {
        this.packB(4, value);
        this.setReps();
    }

    public void setDataRep(String value) {
        this.packS(8, 4, value);
        this.setReps();
    }

    public void setDetached(int value) {
        this.packL(12, value);
    }

    public void setDetached(String value) {
        if (value.equals("0")) {
            this.setDetached(0);
        } else if (value.equals("1")) {
            this.setDetached(1);
        } else {
            this.packS(12, 4, value);
        }
    }

    public void setProtected(boolean value) {
        int i = value ? 1 : 0;
        this.packL(16, i);
    }

    public void setPipeId(int value) {
        this.packL(20, value);
    }

    public void setExtStart(int value) {
        this.packL(24, value);
    }

    public void setExtSize(int value) {
        this.packL(28, value);
    }

    public void setDataStart(double value) {
        this.packD(32, value);
        this.firstbyte = value;
    }

    public void setDS(double value) {
        this.setDataStart(value);
    }

    public void setDataSize(double value) {
        this.setDataSize(value, true);
    }

    protected void setDataSize(double value, boolean resetInternals) {
        this.packD(40, value);
        if (resetInternals) {
            this.setInternals();
        }
    }

    public void setType(int value) {
        this.packL(48, value);
        this.setInternals();
    }

    public void setFormatMode(byte value) {
        this.packB(52, value);
        this.setInternals();
    }

    public void setFormatType(byte value) {
        if (!this.isBlueVersion1dot2 && value == 90) {
            this.setBlueVer(BLUE_VER_Z_DATA);
        }
        this.packB(53, value);
        this.setInternals();
    }

    public void setFormat(String value) {
        if (!this.isBlueVersion1dot2 && value.charAt(1) == 'Z') {
            this.setBlueVer(BLUE_VER_Z_DATA);
        }
        this.packS(52, 2, value);
        this.setInternals();
    }

    public void setDataMask(short value) {
        this.packI(54, value);
    }

    public void setTimeCode(double value) {
        this.packD(56, value);
    }

    public void setTimeCode(Time time) {
        this.setTimeCode(time.getSec());
    }

    public void setInlet(short value) {
        this.packI(64, value);
    }

    public void setOutlets(short value) {
        this.packI(66, value);
    }

    public void setOutMask(int value) {
        this.packL(68, value);
    }

    public void setPipeLoc(int value) {
        this.packL(72, value);
    }

    public void setPipeSize(int value) {
        this.packL(76, value);
        if (this.isPipe()) {
            this.iop.pipe.setSize(value);
        }
    }

    public void setInByte(double value) {
        this.packD(80, value);
        if (this.isPipe()) {
            this.iop.pipe.setInByte(value);
        }
    }

    public void setOutByte(int i, double value) {
        this.packD(88 + i * 8, value);
        if (this.isPipe()) {
            this.iop.pipe.setOutByte(i, value);
        }
    }

    public void setKeyLength(int value) {
        this.packL(160, value);
    }

    public void setKeywords(String value) {
        this.packS(164, 92, value);
        this.setKeyLength(value.length());
    }

    public void setExtKw(String value) {
        String[] extKeywords;
        for (String keyvalue : extKeywords = value.split(",")) {
            String[] kv = keyvalue.split("=");
            this.keywords.setKey(kv[0].trim(), kv[1].trim());
        }
    }

    public void setMainKw(String value) {
        String[] mainKeywords;
        for (String keyvalue : mainKeywords = value.split(",")) {
            String[] kv = keyvalue.split("=");
            this.keywords.putMain(kv[0].trim(), kv[1].trim());
        }
    }

    public void setSameTLKW(String dontTouch) {
        this.sameTimelineKeywords = dontTouch.toLowerCase().startsWith("true");
    }

    public void setSameTLKW(boolean dontTouch) {
        this.sameTimelineKeywords = dontTouch;
    }

    public void setSameTimeLineKeywords(String dontTouch) {
        this.setSameTLKW(dontTouch);
    }

    public void setSameTimeLineKeywords(boolean dontTouch) {
        this.setSameTLKW(dontTouch);
    }

    @InternalUseOnly
    public void setRasterTuneAdjust(boolean supportTuneAdjustmentsOnRaster) {
        if (this.tuneAdjustments == null) {
            try {
                this.tuneAdjustments = new TuneAdjust(this.keywords, this.getXStart(), this.getYStart());
            }
            catch (Exception e) {
                System.out.println("exception " + e);
            }
        }
        this.supportTuneAdjustmentsOnRaster = supportTuneAdjustmentsOnRaster;
    }

    @InternalUseOnly
    public boolean getRasterTuneAdjust() {
        return this.supportTuneAdjustmentsOnRaster;
    }

    @InternalUseOnly
    public TuneAdjust getTuneAdjustments() {
        return this.tuneAdjustments;
    }

    public void setXStart(double value) {
        this.packD(256, value);
    }

    public void setXDelta(double value) {
        this.packD(264, value);
    }

    public void setXUnits(int value) {
        this.packL(272, value);
    }

    public void setXUnits(String value) {
        this.setXUnits(DataFile.getUnitsID(value));
    }

    public void setSubSize(int value) {
        this.packL(276, value);
        this.extendHeader();
    }

    public void setYStart(double value) {
        this.packD(280, value);
    }

    public void setYDelta(double value) {
        this.packD(288, value);
    }

    public void setYUnits(int value) {
        this.packL(296, value);
    }

    public void setYUnits(String value) {
        this.setYUnits(DataFile.getUnitsID(value));
    }

    public void setRecLength(int value) {
        this.packL(300, value);
    }

    public void setRecName(int i, String value) {
        int max = this.t6s != null ? 24 : 4;
        int off = 0;
        int isub = this.iSub(i);
        if (value.length() > max) {
            off = 1;
            if (this.recNames == null) {
                this.initRecNames();
            }
        }
        if (this.t6s != null) {
            if (off == 1) {
                this.setT6s(i, 0, 1, "~");
            }
            this.setT6s(i, off, 24 - off, value);
        }
        if (this.t6s == null || this.hb.length >= this.iSub(i + 1)) {
            if (off == 1) {
                this.hb[isub] = 126;
            }
            this.packS(isub + off, 4 - off, value);
        }
        if (this.recNames != null) {
            this.recNames[i] = value;
        }
    }

    public void setRecFormat(int i, String value) {
        String form;
        if (!this.isBlueVersion1dot2 && value.charAt(1) == 'Z') {
            this.setBlueVer(BLUE_VER_Z_DATA);
        }
        if (this.t6s != null) {
            this.setT6s(i, 88, 2, value);
            if (this.hb.length >= this.iSub(i + 1)) {
                this.packS(this.iSub(i) + 4, 2, value);
            }
        } else {
            this.packS(this.iSub(i) + 4, 2, value);
        }
        if (!(form = this.getFormat()).equals("NH") && !form.equals(value)) {
            this.setFormat("NH");
        }
    }

    public void setRecOffset(int i, short value) {
        if (this.t6s != null) {
            this.setT6l(i, 72, 8, value);
            if (this.hb.length >= this.iSub(i + 1)) {
                this.packI(this.iSub(i) + 6, value);
            }
        } else if (this.typeClass == 3) {
            this.packI(this.iSub(i) + 6, value);
        }
    }

    public void setRecType(int i, byte value) {
        if (this.typeClass == 5) {
            this.packB(this.iSub(i) + 6, value);
        }
    }

    public void setRecUnits(int i, byte value) {
        if (this.t6s != null) {
            this.setT6l(i, 84, 4, value);
        }
        if (this.typeClass == 5) {
            this.packB(this.iSub(i) + 7, value);
        }
    }

    public void setCompName(int i, String value) {
        this.setRecName(i, value);
    }

    public void setCompFormat(int i, String value) {
        this.setRecFormat(i, value);
    }

    public void setCompType(int i, byte value) {
        this.setRecType(i, value);
    }

    public void setCompUnits(int i, byte value) {
        this.setRecUnits(i, value);
    }

    public void setReferenceFrame(String value) {
        this.packS(416, 8, value);
    }

    public void setQuadword(int i, double value) {
        this.packD(416 + i * 8, value);
    }

    @Override
    public String getComment() {
        return (String)this.keywords.get("COMMENT");
    }

    @Override
    public void setComment(String value) {
        super.setComment(value);
        this.keywords.put("COMMENT", value);
    }

    public String getCreator() {
        String creator = this.keywords.getMain("CREATOR");
        if (creator == null) {
            creator = "UNKNOWN";
        }
        return creator;
    }

    private boolean isCreator(String str) {
        String actVer;
        String creator = this.getCreator();
        if (creator.equals("UNKNOWN")) {
            return false;
        }
        boolean lt = false;
        boolean gt = false;
        boolean eq = false;
        if (str.startsWith("<")) {
            lt = true;
            str = str.substring(1);
        }
        if (str.startsWith(">")) {
            gt = true;
            str = str.substring(1);
        }
        if (str.startsWith("=")) {
            eq = true;
            str = str.substring(1);
        }
        String expTri = str.substring(0, 3);
        String expVer = str.substring(3);
        if (!creator.startsWith(expTri)) {
            return false;
        }
        if (creator.matches("...[0-9]+[.][0-9]+[.][0-9]+")) {
            actVer = creator.substring(3);
        } else if (creator.matches("...[0-9][0-9][0-9]")) {
            actVer = "" + creator.charAt(3) + "." + creator.charAt(4) + "." + creator.charAt(5);
        } else if (creator.matches("...[0-9][0-9][0-9][a-zA-Z]")) {
            actVer = "" + creator.charAt(3) + "." + creator.charAt(4) + "." + creator.charAt(5);
        } else {
            return false;
        }
        int comp = StringUtil.compareVersions(actVer, expVer);
        return eq && comp == 0 || lt && comp < 0 || gt && comp > 0;
    }

    public static synchronized void setAutoConvertPlatinumDefault(boolean autoConvertPlatinum) {
        autoConvertPlatinumDefault = autoConvertPlatinum;
    }

    public static boolean getAutoConvertPlatinumDefault() {
        return autoConvertPlatinumDefault;
    }

    public synchronized void setAutoConvertPlatinum(boolean autoConvertPlatinum) {
        this.autoConvertPlatinum = autoConvertPlatinum;
    }

    public boolean getAutoConvertPlatinum() {
        return this.autoConvertPlatinum;
    }

    protected void setBlueVerIO() {
        String currentVer = this.keywords.getMain("VER");
        String defaultVersion = currentVer == null || currentVer.contentEquals(BLUE_VER_ORIG) ? BLUE_VER_DEFAULT : currentVer;
        this.setBlueVer(defaultVersion);
        this.setBlueIO("NeXtMidas");
        String value = "NXM4.1.4";
        this.keywords.putMain("CREATOR", value, false);
    }

    public final void setBlueVer(String blueVer) {
        this.setBlueVer(blueVer, false);
    }

    public final void setBlueIO(String blueIO) {
        this.setBlueIO(blueIO, false);
    }

    @InternalUseOnly
    public void setBlueVer(String blueVer, boolean force) {
        boolean forceQual = Convert.o2z(this.getFileName().getQualifier("FORCE"));
        boolean forcing = force || forceQual;
        boolean bl = this.allowablePlatinum = !forcing && this.autoConvertPlatinum && PLATINUM_VER.matcher(blueVer).matches();
        if (!forcing) {
            if (this.allowablePlatinum) {
                blueVer = BLUE_VER_DEFAULT;
            } else if (!this.checkBlueVer(blueVer)) {
                throw new MidasException("DataFile: Can not set VER=" + blueVer + ", version number is invalid.");
            }
        }
        this.isBlueVersion1dot2 = blueVer.equals(BLUE_VER_Z_DATA);
        this.keywords.putMain("VER", blueVer, true);
    }

    @InternalUseOnly
    public void setBlueIO(String blueIO, boolean force) {
        if (!(force || Convert.o2z(this.getFileName().getQualifier("FORCE")) || blueIO.equals("NeXtMidas"))) {
            throw new MidasException("DataFile: Can not set IO=" + blueIO + ", I/O library name is invalid.");
        }
        this.keywords.putMain("IO", blueIO, true);
    }

    public String getBlueVer() {
        String val = this.keywords.getMain("VER");
        return val == null ? BLUE_VER_ORIG : val;
    }

    private boolean checkBlueVer() {
        return this.checkBlueVer(this.getBlueVer());
    }

    private boolean checkBlueVer(String ver) {
        return ver.equals(BLUE_VER_ORIG) || ver.equals(BLUE_VER_DEFAULT) || ver.contentEquals(BLUE_VER_Z_DATA);
    }

    public String getBlueIO() {
        String creator;
        String val = this.keywords.getMain("IO");
        if (val == null && (creator = this.keywords.getMain("CREATOR")) != null && creator.startsWith("NXM")) {
            val = "NeXtMidas";
        }
        return val == null ? "UNKNOWN" : val;
    }

    private int iSub(int i) {
        if (i >= 14 && this.typeClass == 5) {
            return 512 + (i - 14) * 8;
        }
        return 304 + i * 8;
    }

    @KeyObjectNames
    public void setSubsize(int value) {
        this.setSubSize(value);
    }

    public int getSubsize() {
        return this.getSubSize();
    }

    public void setNumberComponents(int value) {
        this.setSubSize(value);
    }

    public int getNumberComponents() {
        return this.getSubSize();
    }

    public void setNumberSubRecords(int value) {
        this.setSubSize(value);
    }

    public int getNumberSubRecords() {
        return this.getSubSize();
    }

    @Override
    public double getStart() {
        return this.typeClass == 2 ? this.getYStart() : this.getXStart();
    }

    @Override
    public double getDelta() {
        return this.typeClass == 2 ? this.getYDelta() : this.getXDelta();
    }

    @Override
    public int getUnits() {
        return this.typeClass == 2 ? this.getYUnits() : this.getXUnits();
    }

    public double getRate() {
        return this.typeClass == 2 ? this.getYRate() : this.getXRate();
    }

    public static String getCompUnitsName(byte key) {
        return DataFile.getUnitsName(key);
    }

    public static String getUnitsName(int key, String cmult) {
        String name = "Unknown (U)";
        if (key == 3) {
            name = "Frequency (" + cmult + "Hz)";
        } else if (key >= 0 && key < Units.UNITS_INFO.length && Units.UNITS_INFO[key][0] != null) {
            name = Units.UNITS_INFO[key][2] != null ? Units.UNITS_INFO[key][1] + " (" + Units.UNITS_INFO[key][2] + ")" : Units.UNITS_INFO[key][1] + " (U)";
        }
        return name;
    }

    public static int getCompTypeID(String name) {
        return DataFile.getCompTypeID(name, 0);
    }

    private static int getCompTypeID(String name, int def) {
        name = name.trim().toUpperCase();
        return Parser.find("Scalar,Cartesian,Spherical,Cylindric,Ellipsoid,Geodetic,,,,Matrix", name, def);
    }

    public static int getUnitsID(Object name) {
        if (name == null) {
            return 0;
        }
        if (name instanceof Number) {
            int id = ((Number)name).intValue();
            return id < 0 ? 30 : id;
        }
        return DataFile.getUnitsID(name.toString());
    }

    public static int getUnitsID(String name) {
        return DataFile.getUnitsID(name, 30);
    }

    private static int getUnitsID(String name, int def) {
        int i;
        int id = -1;
        name = name.trim().toUpperCase();
        for (i = 0; id < 0 && i < Units.UNITS_ABBR.length; ++i) {
            if (!name.equals(Units.UNITS_ABBR[i][0])) continue;
            id = (Integer)Units.UNITS_ABBR[i][1];
        }
        for (i = 0; id < 0 && i < Units.UNITS_INFO.length; ++i) {
            if (!name.equals(Units.UNITS_INFO[i][0])) continue;
            id = i;
        }
        if (id < 0 && StringUtil.isNumber(name)) {
            id = Convert.o2l(name);
        }
        return id < 0 ? 30 : id;
    }

    public static String getUnitsVarName(int key) {
        String varName = null;
        if (key >= 0 && key < Units.UNITS_INFO.length) {
            varName = Units.UNITS_INFO[key][0];
        }
        return varName == null ? "UNKNOWN" : varName;
    }

    public static String getUnitsName(int key) {
        return DataFile.getUnitsName(key, "");
    }

    public static String getUnitsNameShort(int key, String cmult) {
        String name = "";
        if (key == 3) {
            name = cmult + "Hz";
        } else if (key >= 0 && key < Units.UNITS_INFO.length && Units.UNITS_INFO[key][2] != null) {
            name = Units.UNITS_INFO[key][2];
        }
        return name;
    }

    public static String getUnitsNameShort(int key) {
        return DataFile.getUnitsNameShort(key, "");
    }

    public static String getFormatTypeName(byte key) {
        return Data.getFormatTypeName(key);
    }

    public static String getFormatModeName(byte key) {
        return Data.getFormatModeName(key);
    }

    public static String getCompTypeName(byte key) {
        return DataFile.getCompTypeName(key, false);
    }

    private static String getCompTypeName(byte key, boolean upcase) {
        String name = null;
        if (key >= 0 && key < Units.COMP_TYPE_INFO.length) {
            name = upcase ? Units.COMP_TYPE_INFO[key][1] : Units.COMP_TYPE_INFO[key][0];
        }
        return name != null ? name : DataFile.getCompTypeName((byte)0, upcase);
    }

    public void setStart(double start) {
        if (this.typeClass == 2) {
            this.setYStart(start);
        } else {
            this.setXStart(start);
        }
    }

    public void setDelta(double delta) {
        if (this.typeClass == 2) {
            this.setYDelta(delta);
        } else {
            this.setXDelta(delta);
        }
    }

    public void setUnits(int units) {
        if (this.typeClass == 2) {
            this.setYUnits(units);
        } else {
            this.setXUnits(units);
        }
    }

    public final short getCompOffset(int i) {
        return this.getRecOffset(i);
    }

    public void setFormat(String format, String allowable) {
        if (!DataFile.checkFormat(format, allowable)) {
            this.M.error("Unallowed Format: " + format);
        }
        this.setFormat(format);
    }

    public void setType(int type, String allowable) {
        if (!DataFile.checkType(type, this.types)) {
            this.M.error("Unallowed Type: " + type);
        }
        this.setType(type);
    }

    @Override
    public void setSize(double value) {
        this.size = value;
        this.getBPE();
        double bsize = this.size * this.dbpe;
        if (this.pkh != null) {
            bsize = this.pkh.dataToPacketOffset(this, bsize);
        }
        this.setDataSize(bsize);
        if (this.isOpen) {
            this.wsize = this.size;
        }
    }

    public void setSize() {
        double bsize = this.getDataSize();
        if (this.pkh != null) {
            bsize = this.pkh.packetToDataOffset(this, bsize);
        }
        if (this.trimSet) {
            this.size = this.trim2 - this.trim1;
        } else if (this.dbpe > 0.0) {
            this.size = bsize / this.dbpe;
        }
    }

    public void setTime(Time time) {
        this.setTime(time.getWSec(), time.getFSec(), true);
    }

    public void setTime(Time time, boolean alwaysPutTCPREC) {
        this.setTime(time.getWSec(), time.getFSec(), alwaysPutTCPREC);
    }

    public void setTime(double wsec, double fsec) {
        this.setTime(wsec, fsec, true);
    }

    public void setTime(double wsec, double fsec, boolean alwaysPutTCPREC) {
        double timeu = 1.0E-6 * Math.floor(fsec * 1000000.0 + 0.5);
        double timep = 1.0E-12 * Math.floor((fsec - timeu) * 1.0E12 + 0.5);
        this.setTimeCode(wsec + timeu);
        if (alwaysPutTCPREC || timep != 0.0) {
            this.keywords.putMain("TC_PREC", "" + timep);
        }
    }

    private double getTCPREC() {
        double val = 0.0;
        String tc_prec = this.keywords.getMain("TC_PREC");
        if (tc_prec != null) {
            try {
                val = Convert.s2d(tc_prec);
            }
            catch (Exception e) {
                this.M.warning("Unable to add TC_PREC=" + tc_prec + " to time_code value: " + e.getMessage());
            }
        }
        return val;
    }

    public Time getTime() {
        Time tc = new Time(this.getTimeCode());
        tc.addSec(this.getTCPREC());
        return tc;
    }

    public Time getTimeAt(double index, Time time) {
        if (time == null) {
            time = new Time();
        }
        if (index < 0.0 && (index += this.seek()) < 0.0) {
            if (this.getPreviousDataFile() != null) {
                time = this.getPreviousDataFile().getTimeAt(index, time);
            } else {
                time.fromJ1950x(0.0, 0.0);
            }
            return time;
        }
        index += this.trim1;
        if (this.timeLine != null) {
            time = this.timeLine.getTimeAt(index * this.dbpe, time);
        } else {
            time.fromTime(this.getTime());
            time.addSec(this.getStart() + index * this.getDelta());
        }
        return time;
    }

    public Time getTimeAtCurrent() {
        return this.getTimeAt(this.cftop + this.offset - this.trim1, null);
    }

    public Time getTimeAtCurrent(Time time) {
        return this.getTimeAt(this.cftop + this.offset - this.trim1, time);
    }

    @Override
    public double getTimeAt(double index) {
        return this.getTimeAt(index, null).getSec();
    }

    public double getTimeAt() {
        return this.getTimeAt(this.cftop + this.offset - this.trim1);
    }

    public void setTimeAt(double index, Time time) {
        this.setTimeAt(index, time, TimeLine.NotifyInvalidEntry.EXCEPTION);
    }

    @InternalUseOnly
    public void setTimeAt(double index, Time time, TimeLine.NotifyInvalidEntry notifyLevel) {
        index += this.trim1;
        if (this.timeLine == null) {
            this.newTimeLine();
        }
        this.timeLine.setTimeAt(index, this.dbpe, time, notifyLevel);
    }

    public void setTimeAt(double index, double time) {
        this.setTimeAt(index, new Time(time));
    }

    public void setTimeAt(Time time) {
        this.setTimeAt(this.cftop + this.offset - this.trim1, time);
    }

    public void setTimeAt(Time time, TimeLine.NotifyInvalidEntry notifyLevel) {
        this.setTimeAt(this.cftop + this.offset - this.trim1, time, notifyLevel);
    }

    public void setTimeAt(double time) {
        this.setTimeAt(this.cftop + this.offset - this.trim1, time);
    }

    public double getIndexAt(Time time) {
        return this.getIndexAt(time, 0.0);
    }

    public double getIndexAt(double time) {
        return this.getIndexAt(new Time(time), 0.0);
    }

    private double getIndexAt(Time time, double count) {
        double index;
        if (time.diff(this.getTimeAt(0.0, null)) < 0.0) {
            DataFile df = this.getPreviousDataFile();
            index = df != null ? df.getIndexAt(time, df.seek() + count) : Double.NaN;
        } else {
            double off = this.timeLine != null ? this.timeLine.getOffsetAt(time) / this.dbpe : (time.diff(this.getTime()) - this.getStart()) / this.getDelta();
            index = Math.floor(off - this.trim1) - count;
        }
        return index;
    }

    public void setXferLength(int elements) {
        this.xferLength = elements;
    }

    public void setTransLength(int elements) {
        this.xferLength = elements;
    }

    public void setConsLength(int elements) {
        this.consLength = elements;
    }

    @Override
    public int findRec(String name) {
        int index;
        String num;
        if (this.isRecordBased()) {
            for (int i = 0; i < this.getSubSize(); ++i) {
                if (!name.equals(this.getRecName(i))) continue;
                return i;
            }
        } else if ((name.charAt(0) == 'F' || name.charAt(0) == 'f') && StringUtil.isNumber(num = name.substring(1)) && (index = Convert.s2l(num)) >= 0 && index < this.getSubSize()) {
            return index;
        }
        return -1;
    }

    public int findRecOffset(String name) {
        int i = this.findRec(name);
        return i < 0 ? -1 : (int)this.getRecOffset(i);
    }

    @Deprecated
    public int findIndex(String name) {
        return this.findRec(name);
    }

    private byte unpackB(int off) {
        return this.hb[off];
    }

    private short unpackI(int off) {
        return Convert.unpackI(this.hb, off, this.headRep);
    }

    private int unpackL(int off) {
        return Convert.unpackL(this.hb, off, this.headRep);
    }

    private String unpackS(int off, int len) {
        return Convert.unpackS(this.hb, off, len);
    }

    private double unpackD(int off) {
        if (this.headRep != 86) {
            return Convert.unpackD(this.hb, off, this.headRep);
        }
        System.arraycopy(this.hb, off, this.tempVms, 0, 8);
        Convert.rep(this.tempVms, 0, (byte)68, 1, this.headRep, Shell.rep);
        return Convert.unpackD(this.tempVms, 0);
    }

    private void packB(int off, byte val) {
        this.hb[off] = val;
    }

    private void packI(int off, short val) {
        Convert.packI(this.hb, off, val, this.headRep);
    }

    private void packL(int off, int val) {
        Convert.packL(this.hb, off, val, this.headRep);
    }

    private void packS(int off, int len, String val) {
        Convert.packS(this.hb, off, len, val);
    }

    private void packD(int off, double val) {
        if (this.headRep != 86) {
            Convert.packD(this.hb, off, val, this.headRep);
            return;
        }
        Convert.packD(this.tempVms, 0, val);
        Convert.rep(this.tempVms, 0, (byte)68, 1, Shell.rep, this.headRep);
        System.arraycopy(this.tempVms, 0, this.hb, off, 8);
    }

    public void convertRecordRep(byte[] buf, int off, int n, byte from, byte to) {
        int bpe = (int)this.dbpe;
        for (int i = 0; i < this.getSubSize(); ++i) {
            byte type = this.getRecFormatType(i);
            byte mode = this.getRecFormatMode(i);
            int spa = Data.getSPA(mode) * this.getRecElements(i);
            int bpa = spa * Data.getBPS(type);
            Convert.rep(buf, off, type, spa, from, to, n, bpe);
            off += bpa;
        }
    }

    void convertRecordRep(long lbuf, int off, int n, byte from, byte to) {
        int bpe = (int)this.dbpe;
        for (int i = 0; i < this.getSubSize(); ++i) {
            byte type = this.getRecFormatType(i);
            byte mode = this.getRecFormatMode(i);
            int spa = Data.getSPA(mode) * this.getRecElements(i);
            int bpa = spa * Data.getBPS(type);
            Convert.rep(lbuf, off, type, spa, from, to, n, bpe);
            off += bpa;
        }
    }

    public static byte testRep(String rep) {
        if (rep.startsWith("VAX")) {
            return 86;
        }
        if (rep.equals("IEEE")) {
            return 73;
        }
        if (rep.equals("EEEI")) {
            return 69;
        }
        return 0;
    }

    public void convertHeaderRep(String rep) {
        byte from = this.headRep;
        byte to = DataFile.testRep(rep);
        this.convertHeaderRep(from, to);
        this.setHeadRep(rep);
    }

    public void convertHeaderRep(byte from, byte to) {
        if (to == from) {
            return;
        }
        this.convertHeaderRep(this.hb, from, to);
        if (this.keywords != null) {
            this.keywords.convertExtRep(from, to);
        }
        this.headRep = to;
    }

    public void convertHeaderRep(byte[] buf, byte from, byte to) {
        Convert.rep(buf, 12, (byte)76, 5, from, to);
        Convert.rep(buf, 32, (byte)68, 2, from, to);
        Convert.rep(buf, 48, (byte)76, 1, from, to);
        Convert.rep(buf, 54, (byte)73, 1, from, to);
        Convert.rep(buf, 56, (byte)68, 1, from, to);
        Convert.rep(buf, 64, (byte)73, 2, from, to);
        Convert.rep(buf, 68, (byte)76, 3, from, to);
        Convert.rep(buf, 80, (byte)68, 10, from, to);
        Convert.rep(buf, 160, (byte)76, 1, from, to);
        Convert.rep(buf, 256, (byte)68, 2, from, to);
        Convert.rep(buf, 272, (byte)76, 2, from, to);
        Convert.rep(buf, 280, (byte)68, 2, from, to);
        Convert.rep(buf, 296, (byte)76, 2, from, to);
        int tc = Convert.unpackL(buf, 48, to) / 1000;
        switch (tc) {
            case 3: 
            case 6: {
                for (int i = 0; i < 26; ++i) {
                    Convert.rep(buf, 310 + i * 8, (byte)73, 1, from, to);
                }
                break;
            }
            case 5: {
                Convert.rep(buf, 424, (byte)68, 11, from, to);
            }
        }
    }

    @Override
    public boolean equals(Object infile) {
        return this.equals(infile, 30);
    }

    @Override
    public boolean equals(Object infile, int flags) {
        boolean status = false;
        if (infile instanceof DataFile) {
            status = this.equals((DataFile)infile, flags);
        }
        return status;
    }

    public boolean equals(DataFile df2, int flags) {
        double tolerance;
        if ((flags & 0x20) == 32) {
            this.setFeqTolerance();
            tolerance = this.getFeqTolerance();
        } else if ((flags & 0x200) == 512) {
            this.setFeqAbsTolerance();
            tolerance = this.getFeqAbsTolerance();
        } else {
            tolerance = 0.0;
        }
        return this.equals(df2, flags, tolerance);
    }

    public boolean equals(DataFile df2, int flags, double tolerance) {
        boolean theSame;
        boolean absoluteTol;
        if (flags == 32768) {
            flags = 12;
        }
        boolean bl = absoluteTol = (flags & 0x200) != 0;
        if ((flags & 1) != 0) {
            DataFile bf1 = this;
            DataFile bf2 = df2;
            theSame = bf1.equalsBF(bf2, flags);
        } else {
            DataFile df1 = this;
            df1.open();
            df2.open();
            boolean sameSize = true;
            if ((flags & 2) != 0) {
                sameSize = df1.getSize() == df2.getSize();
            }
            theSame = sameSize;
            boolean sameHdr = true;
            if (theSame && (flags & 4) != 0) {
                sameHdr = df1.equalsHeader(df2);
            }
            theSame = theSame && sameHdr;
            boolean sameData = true;
            if (theSame && (flags & 8) != 0 || (flags & 0x20) != 0 || (flags & 0x400) != 0) {
                if (df1.getSize() != 0.0 && df2.getSize() != 0.0) {
                    double _offset = 0.0;
                    if ((flags & 0x400) != 0) {
                        double _size = Math.min(df1.getSize(), df2.getSize());
                        sameData = DataFile.compare(df1, df2, _offset, _size, tolerance, absoluteTol);
                    } else {
                        sameData = df1.getSize() == df2.getSize() ? DataFile.compare(df1, df2, _offset, df1.getSize(), tolerance, absoluteTol) : false;
                    }
                } else if (df1.getSize() != 0.0 || df2.getSize() != 0.0) {
                    sameData = false;
                }
            }
            theSame = theSame && sameData;
            boolean sameKey = true;
            if (theSame && (flags & 0x10) != 0) {
                sameKey = df1.equalsKeywordsExt(df2);
            }
            if ((this.M.debug & 1) != 0) {
                this.M.type("DataFile.equals: size? " + sameSize + ", hdr? " + sameHdr + ", data? " + sameData + ", key? " + sameKey);
            }
            theSame = theSame && sameKey;
            df1.close();
            df2.close();
        }
        return theSame;
    }

    public static boolean compare(DataFile df1, DataFile df2, double offset, double size) {
        return DataFile.compare(df1, df2, offset, size, 0.0);
    }

    public static boolean compare(DataFile df1, DataFile df2, double offset, double size, double tolerance) {
        return DataFile.compare(df1, df2, offset, size, tolerance, false);
    }

    public static boolean compare(DataFile df1, DataFile df2, double offset, double size, double tolerance, boolean absoluteTol) {
        Data data2;
        Data data1;
        boolean type3000orGreater;
        int elemsPer = (int)Math.max(1.0, Math.min(131072.0, size * df1.dbpe) / df1.dbpe);
        boolean bl = type3000orGreater = df1.getType() / 1000 > 2 || df2.getType() / 1000 > 2;
        if (type3000orGreater) {
            data1 = df1.getDataBuffer(elemsPer);
            data2 = df2.getDataBuffer(elemsPer);
        } else {
            byte type2;
            byte type1 = df1.getFormatType();
            byte type = type1 == (type2 = df2.getFormatType()) ? type1 : Data.promoteType(type1, type2);
            data1 = df1.getDataBuffer(elemsPer, type);
            data2 = df2.getDataBuffer(elemsPer, type);
        }
        if (tolerance > 0.0) {
            int elements2;
            int elements1 = (int)df1.getSize();
            if (elements1 != (elements2 = (int)df2.getSize())) {
                return false;
            }
            for (int zz = 0; zz < elements1; zz += elemsPer) {
                df1.read(data1, offset + (double)zz, elemsPer);
                df2.read(data2, offset + (double)zz, elemsPer);
                int subElems1 = data1.getSize();
                for (int xx = 0; xx < subElems1; ++xx) {
                    Data elemData1 = data1.getIndex(xx);
                    Data elemData2 = data2.getIndex(xx);
                    int ape = elemData1.getAPE();
                    for (int yy = 0; yy < ape; ++yy) {
                        Data value1 = elemData1.getAtomAt(yy);
                        Data value2 = elemData2.getAtomAt(yy);
                        double d1 = value1.toD();
                        double d2 = value2.toD();
                        if (!(!absoluteTol ? !Tolerance.equalsWithTolerance(d1, d2, tolerance) : !Tolerance.equalsWithAbsTol(d1, d2, tolerance))) continue;
                        return false;
                    }
                }
            }
        } else {
            int elements;
            for (double off = offset; off < size + offset; off += (double)elements) {
                elements = (int)Math.min((double)elemsPer, size - off);
                if (elements == 0) {
                    return false;
                }
                int status1 = df1.read(data1, off, elements);
                int status2 = df2.read(data2, off, elements);
                if (Arrays.equals(data1.buf, data2.buf)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equalsHeader(DataFile df2) {
        boolean theSame;
        block12: {
            int i;
            DataFile df1;
            block13: {
                block15: {
                    block14: {
                        theSame = false;
                        df1 = this;
                        if (df1.getType() != df2.getType() || !df1.getFormat().equals(df2.getFormat()) || df1.getTimeCode() != df2.getTimeCode()) break block12;
                        int fileType = df1.getType() / 1000;
                        int nbytes = 0;
                        boolean doSubRecs = fileType > 2;
                        int nSubrecs = df1.getSubSize();
                        byte df1rep = (byte)df1.getHeadRep().charAt(0);
                        byte df2rep = (byte)df2.getHeadRep().charAt(0);
                        df1.convertHeaderRep(df1rep, Shell.rep);
                        df2.convertHeaderRep(df2rep, Shell.rep);
                        if (fileType == 1) {
                            nbytes = 20;
                        } else if (fileType == 2) {
                            nbytes = 44;
                        } else {
                            nbytes = 24;
                            doSubRecs = true;
                        }
                        byte[] buf1 = new byte[nbytes];
                        byte[] buf2 = new byte[nbytes];
                        System.arraycopy(df1.hb, 256, buf1, 0, nbytes);
                        System.arraycopy(df2.hb, 256, buf2, 0, nbytes);
                        df1.convertHeaderRep(Shell.rep, df1rep);
                        df2.convertHeaderRep(Shell.rep, df2rep);
                        if (Arrays.equals(buf1, buf2)) {
                            if (doSubRecs) {
                                boolean subRecsSame = true;
                                for (int i2 = 0; i2 < nSubrecs; ++i2) {
                                    if (df1.getRecOffset(i2) == df2.getRecOffset(i2) && df1.getRecName(i2).equals(df2.getRecName(i2)) && df1.getRecFormat(i2).equals(df2.getRecFormat(i2))) continue;
                                    subRecsSame = false;
                                    break;
                                }
                                theSame = subRecsSame;
                            } else {
                                theSame = true;
                            }
                        }
                        if (this.getTypeCodeClass() != 5 || !theSame || this.M != null && this.M.io != null && this.M.io.isOptionSet(CoreIO.IOOptions.DisableQuadwordsEqualityChecks)) break block12;
                        if (this.getType() != 5001) break block13;
                        if (df1.getReferenceFrame().equals(df2.getReferenceFrame())) break block14;
                        theSame = false;
                        break block12;
                    }
                    if (!df1.getReferenceFrame().equals("ECI")) break block15;
                    theSame = df1.getQuadword(9) == df2.getQuadword(9) && df1.getQuadword(10) == df2.getQuadword(10) && df1.getQuadword(11) == df2.getQuadword(11);
                    break block12;
                }
                if (df1.getReferenceFrame().equals("ECR")) break block12;
                if (df1.getReferenceFrame().equals("TOP") || df1.getReferenceFrame().equals("TOPOCENT")) {
                    theSame = df1.getQuadword(1) == df2.getQuadword(1) && df1.getQuadword(2) == df2.getQuadword(2) && df1.getQuadword(3) == df2.getQuadword(3) && df1.getQuadword(4) == df2.getQuadword(4) && df1.getQuadword(5) == df2.getQuadword(5) && df1.getQuadword(6) == df2.getQuadword(6);
                } else {
                    for (i = 416; i < 512 && theSame; ++i) {
                        theSame = df1.unpackB(i) == df2.unpackB(i);
                    }
                }
                break block12;
            }
            for (i = 416; i < 512 && theSame; ++i) {
                theSame = df1.unpackB(i) == df2.unpackB(i);
            }
        }
        return theSame;
    }

    public boolean equalsKeywordsExt(DataFile df2) {
        boolean debug;
        DataFile df1 = this;
        boolean bl = debug = this.M != null && (this.M.debug & 1) != 0;
        if (debug) {
            Keywords.Key key;
            this.M.type("DataFile.equalsKeywordsExt(): size keys in this file '" + df1.getFileName().getFullName() + "' = " + df1.keywords.size);
            Keywords.Iterator kwi = df1.keywords.iterator();
            while ((key = kwi.next()) != null) {
                this.M.type(key.name + "=" + key.value);
            }
            this.M.type("DataFile.equalsKeywordsExt(): size keys in other file '" + df2.getFileName().getFullName() + "' = " + df2.keywords.size);
            kwi = df2.keywords.iterator();
            while ((key = kwi.next()) != null) {
                this.M.type(key.name + "=" + key.value);
            }
        }
        boolean status = false;
        if (df1.keywords.size == df2.keywords.size) {
            Keywords.Key key2;
            Keywords.Key key1;
            status = true;
            df1.keywords.setScope("EXT");
            df2.keywords.setScope("EXT");
            Keywords.Iterator kwi1 = df1.keywords.iterator();
            Keywords.Iterator kwi2 = df2.keywords.iterator();
            while ((key1 = kwi1.next()) != null && (key2 = kwi2.next()) != null) {
                if (debug) {
                    this.M.type("DataFile.equalsKeywordsExt(): key1 name '" + key1.name + "', value '" + key1.value + "', key2 name '" + key2.name + "' value '" + key2.value + "'");
                }
                if (key1.name.equals(key2.name) && key1.value.equals(key2.value)) continue;
                if (debug) {
                    this.M.type("DataFile.equalsKeywordsExt(): name '" + key1.name + "' != '" + key2.name + "', or value \n'" + key1.value + "' != \n'" + key2.value + "'");
                }
                status = false;
                break;
            }
        }
        return status;
    }

    public void setCTG(int value) {
    }

    public void setQW(int index, double value) {
        this.setQuadword(index - 1, value);
    }

    public double getQW(int index) {
        return this.getQuadword(index - 1);
    }

    public int getFS() {
        return this.getFrameSize();
    }

    public void setFS(int fs) {
        this.setFrameSize(fs);
    }

    public void setC(int index, String fields) {
        this.setComp(index - 1, fields);
    }

    public void setSR(int index, String fields) {
        this.setSubRec(index - 1, fields);
    }

    @Override
    public double getNumberOfRows() {
        return this.getSize();
    }

    @Override
    public int getRecordDefCount() {
        return this.typeClass == 1 ? 1 : this.getSubSize();
    }

    @Override
    public void setRecordDefs(Table defs) {
        String[] keys = defs.getKeys();
        if (this.typeClass <= 2) {
            this.setType(3000);
        }
        this.setSubSize(keys.length);
        short offset = 0;
        for (int i = 0; i < keys.length; ++i) {
            String name = keys[i];
            Table def = defs.getTable(name);
            String form = def.getS("FORMAT", "XA");
            short off = def.getI("OFFSET", offset);
            String comp = def.getS("TYPE", null);
            String units = def.getS("UNITS", null);
            name = def.getS("NAME", name);
            this.setRecName(i, name);
            this.setRecFormat(i, form);
            this.setRecOffset(i, off);
            if (comp != null) {
                this.setRecType(i, (byte)DataFile.getCompTypeID(comp));
            }
            if (units != null) {
                this.setRecUnits(i, (byte)DataFile.getUnitsID(units));
            }
            int numElementsPerSubRecord = 1;
            if (this.t6s != null) {
                double minval = def.getD("MINVAL", Double.NaN);
                double maxval = def.getD("MAXVAL", Double.NaN);
                int numElts = def.getL("NUM_ELTS", -1);
                String uprefix = def.getS("UPREFIX", null);
                String reserved = def.getS("RESERVED", null);
                if (!Double.isNaN(minval)) {
                    this.setRecMinimum(i, minval);
                }
                if (!Double.isNaN(maxval)) {
                    this.setRecMaximum(i, maxval);
                }
                if (uprefix != null) {
                    this.setRecUnitsPrefix(i, uprefix);
                }
                if (reserved != null) {
                    this.setRecReserved(i, reserved);
                }
                if (numElts > 0) {
                    this.setRecElements(i, numElts);
                    numElementsPerSubRecord = numElts;
                }
            }
            offset = (short)(off + Data.getBPA(form) * numElementsPerSubRecord);
        }
        this.setRecLength(offset);
        this.setInternals();
    }

    @Override
    public Table getRecordDefs() {
        int subsize = this.getRecordDefCount();
        Table table = new Table();
        for (int i = 0; i < subsize; ++i) {
            table.put(this.getRecName(i), (Object)this.getRecordDef(i));
        }
        return table;
    }

    @Override
    public Table getRecordDef(int i) {
        Table table = null;
        if (i >= 0 && i < this.getRecordDefCount()) {
            table = new Table();
            table.put("NAME", (Object)this.getRecName(i));
            table.put("FORMAT", (Object)this.getRecFormat(i));
            table.put("OFFSET", this.getRecOffset(i));
            table.put("TYPE", (Object)this.getRecCompTypeName(i));
            table.put("UNITS", (Object)this.getRecUnitsName(i));
            if (this.t6s != null) {
                table.put("MINVAL", this.getRecMinimum(i));
                table.put("MAXVAL", this.getRecMaximum(i));
                table.put("NUM_ELTS", this.getRecElements(i));
                table.put("UPREFIX", (Object)this.getRecUnitsPrefix(i));
                table.put("RESERVED", (Object)this.getRecReserved(i));
            }
        }
        return table;
    }

    public boolean isRecordBased() {
        return this.typeClass == 3 || this.typeClass == 5 || this.typeClass == 6;
    }

    public DataFile getNextDataFile() {
        return this.next;
    }

    public DataFile getPreviousDataFile() {
        return this.previous;
    }

    void setNextDataFile(DataFile df) {
        this.next = df;
    }

    void setPreviousDataFile(DataFile df) {
        this.previous = df;
    }

    DataFile copy() {
        try {
            return (DataFile)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MidasException("DataFile: Can not clone.", e);
        }
    }

    private boolean usePlatinumTimeline() {
        Object overrideQualifier = this.getFileName().getQualifier(QUALIFIER_PLATINUM_TIMELINE, null);
        if (BLUE_VER_PLATINUM.equals(this.getBlueVer())) {
            return true;
        }
        if (overrideQualifier != null) {
            return Convert.o2z(overrideQualifier);
        }
        Boolean tcTimeLineQualifier = this.getBooleanQualifierValue(QUALIFIER_TC_TIMELINE);
        Boolean usecTimeLineQualifier = this.getBooleanQualifierValue(QUALIFIER_USEC_TIMELINE);
        if (tcTimeLineQualifier != null && tcTimeLineQualifier.booleanValue() || usecTimeLineQualifier != null && usecTimeLineQualifier.booleanValue()) {
            return false;
        }
        boolean fromPlatinumTimeline = this.timeLine != null && this.timeLine.format == TimeLine.Format.PLATINUM_HIGH_PRECISION;
        return fromPlatinumTimeline || this.M.io.isOptionSet(CoreIO.IOOptions.PreferPlatinumTimeLine);
    }

    private void handlePlatinumTimelineKeywords(String origBlueVer, String origBlueIO) {
        TimeLine platTimeLine = TimeLine.fromPlatinumKeywords(this.keywords, this.getDelta(), this.dbpe);
        if (platTimeLine != null) {
            boolean usePlatinumTimeline;
            boolean isPlatinum = BLUE_VER_PLATINUM.equals(origBlueVer);
            boolean bl = usePlatinumTimeline = isPlatinum || this.isCreator(">=NXM3.3.0") || this.usePlatinumTimeline();
            if (this.timeLine == null) {
                if (usePlatinumTimeline) {
                    this.timeLine = platTimeLine;
                } else {
                    this.M.warning("Ignoring Platinum timeline keywords since it has been modified by IO=" + this.getBlueIO() + ("UNKNOWN".equals(this.getCreator()) ? "" : " CREATOR=" + this.getCreator()) + " in file " + this.getName());
                }
            } else if (this.keywords.find("TIMELINE") != null) {
                this.M.warning("File contains NeXtMidas TIMELINE with microsecond precision and Platinum high precision timeline keywords, using TIMELINE = " + this.timeLine + " for file=" + this.getName());
            }
            double start = this.getStart();
            Time blueStartTime = this.getTime().addSec(start);
            Time platStartTime = platTimeLine.getTimeAt(0.0, null);
            double tdiff = blueStartTime.diff(platStartTime);
            if (Math.abs(tdiff) > 1.0E-12) {
                Time tc_tcprec_Time = this.getTime();
                if (isPlatinum && (tc_tcprec_Time.isZero() || tdiff < 1.0E-6)) {
                    if (start != 0.0) {
                        platStartTime.addSec(-start);
                    }
                    this.M.warning("Internally fixing BLUE TimeCode+TC_PREC to " + platStartTime.toString(12) + " for " + this.getName());
                    this.setTime(platStartTime);
                } else {
                    this.M.warning("Midas TimeCode+TC_PREC+Start =" + blueStartTime.toString(12) + " does not match\n      Platinum TIMETAG.TIME keyword=" + platStartTime.toString(12) + "\n      diff from Midas=" + tdiff + " ; VER=" + origBlueVer + " IO=" + origBlueIO + " for " + this.getName());
                }
            }
        }
    }

    private boolean useBlueTCTimeline() {
        Boolean tcTimeLineQualifier = this.getBooleanQualifierValue(QUALIFIER_TC_TIMELINE);
        Boolean usecTimeLineQualifier = this.getBooleanQualifierValue(QUALIFIER_USEC_TIMELINE);
        if (usecTimeLineQualifier != null && usecTimeLineQualifier.booleanValue()) {
            return false;
        }
        if (tcTimeLineQualifier != null) {
            return tcTimeLineQualifier;
        }
        Boolean platTimeLineQualifier = this.getBooleanQualifierValue(QUALIFIER_PLATINUM_TIMELINE);
        if (platTimeLineQualifier != null && platTimeLineQualifier.booleanValue()) {
            return false;
        }
        boolean fromBlueTCTimeline = this.timeLine != null && this.timeLine.format == TimeLine.Format.BLUE_HIGH_PRECISION;
        boolean preferTCSet = this.M.io.isOptionSet(CoreIO.IOOptions.PreferBlueTCTimeLine);
        return fromBlueTCTimeline || preferTCSet;
    }

    private void handleBlueTCTimelineKeywords(String origBlueVer, String origBlueIO) {
        TimeLine blueTCTimeLine = TimeLine.fromBlueTCKeywords(this.keywords, this.getTime().addSec(this.getStart()), this.getDelta(), this.dbpe);
        if (blueTCTimeLine != null) {
            boolean isBlue = BLUE_VER_PATTERN.matcher(origBlueVer).matches();
            boolean useBlueTCTimeline = this.useBlueTCTimeline();
            if (this.timeLine == null || useBlueTCTimeline) {
                this.timeLine = blueTCTimeLine;
            } else {
                this.M.warning("File contains NeXtMidas TIMELINE with microsecond precision and BLUE TC high precision timeline keywords, using TIMELINE = " + this.timeLine + " for file=" + this.getName());
            }
        }
    }

    private TimeLine.Format overrideTimeLineFormat(TimeLine.Format original) {
        Boolean usecOverride;
        TimeLine.Format format = original;
        if (this.usePlatinumTimeline()) {
            format = TimeLine.Format.PLATINUM_HIGH_PRECISION;
        }
        if (this.useBlueTCTimeline()) {
            format = TimeLine.Format.BLUE_HIGH_PRECISION;
        }
        if ((usecOverride = this.getBooleanQualifierValue(QUALIFIER_USEC_TIMELINE)) != null && usecOverride.booleanValue()) {
            format = TimeLine.Format.MICROSECOND_PRECISION;
        }
        return format;
    }

    private Boolean getBooleanQualifierValue(String qualifier) {
        Object overrideQualifier = this.getFileName().getQualifier(qualifier, null);
        if (overrideQualifier != null) {
            return Convert.o2z(overrideQualifier);
        }
        return null;
    }

    public Time getTimeAtStart() {
        return this.getTimeAt(0.0, null);
    }

    public Time getTimeAtEnd() {
        return this.getTimeAt(this.getSize(), null);
    }

    public double getTimeDuration() {
        return this.getTimeAtEnd().diff(this.getTimeAtStart());
    }

    public static boolean isCompleteBlueFile(Path p) {
        return DataFile.isCompleteBlueFile(p.toFile());
    }

    public static boolean isCompleteBlueFile(File f) {
        return DataFile.getPartialBlueFileError(f) == null;
    }

    public static String getPartialBlueFileError(Path p) {
        return DataFile.getPartialBlueFileError(p.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPartialBlueFileError(File f) {
        long len = f.length();
        if (len < 256L) {
            return "Incomplete MAIN header (way too short)";
        }
        try (DataFile df = new DataFile(null, (Object)f);){
            df.open(1056);
            if (!df.isOpen()) {
                String string = "Failed to open file";
                return string;
            }
            long extStart = df.getExtStart();
            long extSize = df.getExtSize();
            long dataStart = (long)df.getDataStart();
            long dataSize = (long)df.getDataSize();
            long mainSize = df.getHeaderLength();
            double size = df.getSize();
            long sizeBytes = (long)Math.ceil(size * df.getBPE());
            if (len < mainSize) {
                String string = "Incomplete MAIN header (too short)";
                return string;
            }
            if (size == 0.0 && dataSize != 0L) {
                String string = "Incomplete MAIN header (incomplete data)";
                return string;
            }
            if (len < dataStart + dataSize) {
                String string = "Incomplete DATA (by offset check)";
                return string;
            }
            if (len < dataStart + sizeBytes) {
                String string = "Incomplete DATA (by element count)";
                return string;
            }
            if (extSize <= 0L) return null;
            if (len >= extStart + extSize) return null;
            String string = "Incomplete EXTENDED header";
            return string;
        }
        catch (Exception e) {
            return BLUE_FILE_READ_ERROR;
        }
    }

    public static boolean isBlueFile(MidasReference ref, Object fname) {
        return DataFile.isBlueFileName(fname) || DataFile.isBlueFileMagic(ref, fname);
    }

    public static boolean isBlueFileMagic(MidasReference ref, Object fname) {
        try (BaseFile bf = new BaseFile(ref, fname);){
            if (!bf.exists()) {
                boolean bl = false;
                return bl;
            }
            bf.open();
            byte[] buf = new byte[12];
            bf.read(buf, 0, buf.length);
            boolean bl = BLUE_MAGIC.contains(new String(buf));
            return bl;
        }
    }

    public static boolean isBlueFileName(Object fname) {
        String ext;
        FileName fn = FileName.toFileName(fname);
        switch (ext = fn.getExt()) {
            case "tmp": {
                return true;
            }
            case "prm": {
                return true;
            }
            case "bdif": {
                return true;
            }
            case "cdif": {
                return true;
            }
            case "cwdw": {
                return true;
            }
            case "ncwdw": {
                return true;
            }
            case "npdw": {
                return true;
            }
            case "pdw": {
                return true;
            }
            case "ppdw": {
                return true;
            }
            case "rpdw": {
                return true;
            }
            case "sdw": {
                return true;
            }
            case "spdw": {
                return true;
            }
            case "wpdw": {
                return true;
            }
            case "wcwdw": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setFlags(int flags) {
        CoreIO io = Shell.getSharedMidasContext().io;
        if (io.isOptionSet(CoreIO.IOOptions.CreateFileMaintainCase)) {
            flags |= 0x80000;
        }
        if (io.isOptionSet(CoreIO.IOOptions.CreateFileWithoutTmpExtenstion)) {
            flags |= 0x100000;
        }
        if (Midas.isJavaVsMidasDebug()) {
            Midas.log("#JvsM DataFile.setFlags fileName:" + this.filename + " flags:" + DataFile.getFlagsString(flags), 0);
        }
        super.setFlags(flags);
    }

    public int getNumTimelineEntries() {
        return TimeLine.getNumTCEntries(this.keywords);
    }

    public boolean isAutoCorrectEnabled() {
        return this.offset0AutoCorrectIsEnabled;
    }

    @InternalUseOnly
    public static String getScalarSeparator() {
        return scalarSeparator;
    }

    @InternalUseOnly
    public static void setScalarSeparator(String sSep) {
        scalarSeparator = sSep;
    }
}

