/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.FileVisitor;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MaskValue;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.WindowsAltFileSystemView;
import nxm.sys.lib.XmUtil;

public class CoreIO
implements AsciiMap {
    public static final int UNTANGLE = 1;
    public static final int CLOSED = -1;
    public static final int REOPEN = -2;
    public static final int ERROR = -3;
    private static final MaskValue<IOOptions> DEF_IOOPTIONS_OPTIONS = MaskValue.constant(IOOptions.class, (Enum[])new IOOptions[0]);
    private MaskValue<IOOptions> ioOptions = DEF_IOOPTIONS_OPTIONS.copy();
    private Midas M;
    static final int COPY_OK = 1;
    static final int COPY_FILE_NOT_FOUND = -1;
    static final int COPY_DIR_NOT_FOUND = -2;
    static final int COPY_NO_OVERWRITE = -3;
    static final int COPY_DIR_CREATION_ERROR = -4;

    @InternalUseOnly(value="This should only be used by Midas and BaseFile")
    public CoreIO() {
    }

    @InternalUseOnly(value="This should only be used by Midas and BaseFile")
    public CoreIO(Midas M) {
        this();
        this.M = M;
        if (M.io != null) {
            this.ioOptions = M.io.ioOptions;
        }
    }

    public IOResource findResource(Object filename, int dir) {
        return this.findResource(filename, dir, "", "");
    }

    public IOResource findResource(Object filename, int dir, String ext, String aux) {
        return this.findResource(filename, dir, ext, aux, false);
    }

    IOResource findResource(Object filename, int dir, String ext, String aux, boolean doNotAddExtension) {
        boolean noPath;
        IOResource res = null;
        FileName fn = FileName.toFileName(filename);
        Table quals = fn.getQualifierTable();
        String path = fn.getPath();
        String root = fn.getRoot();
        boolean bl = noPath = path == null || path.isEmpty();
        if (ext == null || ext.length() == 0) {
            ext = fn.getExt();
        }
        if (aux != null && aux.length() != 0) {
            path = this.getAuxPath(aux) + path;
        }
        if (noPath && root.startsWith("_")) {
            path = "ram:";
        }
        if (path != null && path.length() > 0) {
            if (path.startsWith("./")) {
                path = this.getAuxPath("CWD") + path.substring(2);
            }
            res = this.findResource(path, root, ext, quals, dir, true, doNotAddExtension);
        } else {
            Table taux = this.M.results.getTable("AUX");
            String waux = taux.getString("WRITE");
            if (dir > 0 && waux.startsWith("-")) {
                waux = waux.substring(1);
                res = this.findResource(this.getAuxPath(waux), root, ext, quals, dir, true, doNotAddExtension);
            } else {
                String raux = taux.getString("READ");
                Parser auxes = new Parser(raux);
                auxes.setDelimiter('|');
                auxes.reset();
                while (auxes.more() && res == null) {
                    aux = auxes.next();
                    path = this.getAuxPath(aux);
                    res = this.findResource(path, root, ext, quals, dir, false, doNotAddExtension);
                }
                if (res == null) {
                    res = this.findResource(this.getAuxPath(waux), root, ext, quals, dir, true, doNotAddExtension);
                }
            }
        }
        return res;
    }

    private String createClasspathPath(String path, String root) {
        String[] paths = (path = path.replace("\\", "/")).split(":");
        if (paths.length > 1) {
            return path.endsWith("/") ? path + root : path + "/" + root;
        }
        return path + root;
    }

    public IOResource findResource(String path, String root, String ext, Table quals, int dir, boolean create) {
        return this.findResource(path, root, ext, quals, dir, create, false);
    }

    private IOResource findResource(String path, String root, String ext, Table quals, int dir, boolean create, boolean doNotAddExtension) {
        IOResource res = null;
        boolean exists = false;
        int lroot = root.length();
        int lext = ext.length();
        boolean isClasspathUrl = path.toLowerCase().startsWith("classpath:");
        String url = isClasspathUrl ? this.createClasspathPath(path, root) : path + root;
        int type = IOResource.getType(url);
        if (type == 1 || type == 8 || type == 9) {
            if (lroot == 0) {
                exists = this.fexists(url);
            } else if (lext > 0) {
                if (!url.endsWith("." + ext)) {
                    url = url + "." + ext;
                }
                exists = this.fexists(url);
            } else {
                exists = this.fexists(url);
                if (!exists) {
                    url = path + root + ".prm";
                    exists = this.fexists(url);
                }
                if (!exists) {
                    url = path + root + ".tmp";
                    exists = this.fexists(url);
                }
            }
            if (exists) {
                res = IOResource.getInstance(this.M, type, url, dir, quals);
            } else if (create) {
                if (doNotAddExtension) {
                    url = path + root;
                }
                res = IOResource.getInstance(this.M, type, url, dir, quals);
            }
        } else if (type == 5 || type == 12 || type == 6) {
            if (lroot == 0) {
                url = path;
            } else if (lext > 0) {
                url = path + root + "." + ext;
            } else {
                url = path + root;
                res = IOResource.getInstance(this.M, type, url, dir, quals);
                exists = res.exists();
                if (!exists) {
                    url = path + root + ".prm";
                    res.setURL(url);
                }
            }
            if (res == null) {
                res = IOResource.getInstance(this.M, type, url, dir, quals);
            }
            if (!(exists || res.exists() || create)) {
                res = null;
            }
        } else if (type == 7) {
            if (lext > 0 && lroot > 0) {
                root = root + "-" + ext;
            }
            if ((exists = lroot == 0 ? true : this.M.pipes.containsKey(root)) || create) {
                res = IOResource.getInstance(this.M, type, path + root, dir, quals);
            }
        } else if (type == 2) {
            if (lext > 0 && lroot > 0) {
                root = root + "-" + ext;
            }
            if ((exists = lroot == 0 ? true : this.M.pipes.containsKey(root.toUpperCase())) || create) {
                res = IOResource.getInstance(this.M, type, path + root, dir, quals);
            }
        } else {
            if (lroot > 0 && lext > 0) {
                url = url + "." + ext;
            }
            if ((res = IOResource.getInstance(this.M, type, url, dir, quals)) != null && !res.exists() && lext == 0 && type == 13 && path.toLowerCase().startsWith("classpath") && (res = IOResource.getInstance(this.M, type, url = path + root + ".prm", dir, quals)) != null && !res.exists()) {
                url = path + root + ".tmp";
                res = IOResource.getInstance(this.M, type, url, dir, quals);
            }
            if (res != null && !res.exists() && !create) {
                res = null;
            }
        }
        return res;
    }

    public boolean dexists(String url) {
        return CoreIO.fexists(url, true);
    }

    public boolean fexists(String url) {
        return CoreIO.fexists(url, false);
    }

    private static boolean fexistsClasspath(String url, boolean checkDir) {
        String urlTemp = IOResource.getInstance(Shell.getMidasContext(), 0, url, 0, null).getURL();
        if (urlTemp.toLowerCase().startsWith("classpath:")) {
            return false;
        }
        if (urlTemp.endsWith("/")) {
            return checkDir;
        }
        urlTemp = url + "/";
        urlTemp = IOResource.getInstance(Shell.getMidasContext(), 0, urlTemp, 0, null).getURL();
        return urlTemp.toLowerCase().startsWith("classpath:") == !checkDir;
    }

    public static boolean fexists(String url, boolean checkDir) {
        boolean retVal;
        int i = url.indexOf(58);
        if (url.toLowerCase().startsWith("classpath:")) {
            return CoreIO.fexistsClasspath(url, checkDir);
        }
        if (i > 0) {
            String prefix = url.substring(0, i + 1).toUpperCase();
            boolean isRoot = false;
            File[] roots = CoreIO.isWindows() ? WindowsAltFileSystemView.listRoots() : File.listRoots();
            for (int j = 0; !isRoot && j < roots.length; ++j) {
                String root = ("" + roots[j]).toUpperCase();
                isRoot = root.startsWith(prefix);
            }
            if (!isRoot) {
                url = url.substring(i + 1);
            }
        }
        File f = new File(url);
        try {
            retVal = checkDir ? f.isDirectory() : f.isFile();
        }
        catch (SecurityException e) {
            retVal = false;
        }
        return retVal;
    }

    private static boolean isWindows() {
        return "DOS".equals(Shell.ostype);
    }

    @InternalUseOnly
    @Deprecated
    public String name(String area, String name, String ext) {
        return this.getName("SYS", area, name, ext);
    }

    public String name(String area, String name, String ext, String opt) {
        return this.getName(opt, area, name, ext);
    }

    public String getName(String opt, String area, String name, String ext) {
        String path = opt.equals("AUX") ? this.getAuxPath(area) : Shell.getOptPath(opt, area);
        if (name == null) {
            return path;
        }
        if (name.equals(name.toUpperCase())) {
            name = name.toLowerCase();
        }
        String fname = path + name;
        if (ext != null && ext.length() > 0) {
            fname = fname + "." + ext.toLowerCase();
        }
        return fname;
    }

    public String[] getAuxList() {
        String[] keys = this.M.results.getTable("AUX").getKeys();
        ArrayList<String> list3 = new ArrayList<String>(keys.length - 2);
        for (String aux : keys) {
            if (aux.equals("READ") || aux.equals("WRITE") || aux.startsWith("_") && aux.endsWith("_")) continue;
            list3.add(aux);
        }
        return list3.toArray(StringUtil.EMPTY_STRING_ARRAY);
    }

    public String getWriteAux() {
        String write = this.M.results.getTable("AUX").getS("WRITE");
        return write == null || write.length() == 0 ? null : write;
    }

    public String[] getReadAux() {
        String read = this.M.results.getS("AUX.READ", "");
        Parser parser = new Parser(read, '|');
        String[] list3 = new String[parser.elements()];
        for (int i = 0; i < list3.length; ++i) {
            list3[i] = parser.get(i + 1);
        }
        return list3;
    }

    public String getAuxPath(String aux) {
        return this.getAuxPath(aux, true, true);
    }

    public String getAuxPath(String aux, boolean clean) {
        return this.getAuxPath(aux, clean, true);
    }

    String getAuxPath(String aux, boolean clean, boolean trans) {
        Table taux;
        if (trans) {
            aux = XmUtil.checkAuxName(aux);
        }
        if ((taux = this.M.results.getTable("AUX")) == null) {
            return null;
        }
        String path = taux.getString(aux);
        if (aux.equals("WRITE")) {
            path = taux.getString(path);
        }
        if (path == null) {
            return null;
        }
        if (IOResource.getType(path) == 1 && !path.endsWith(File.separator)) {
            path = FileName.terminatePath(path);
        }
        if (clean) {
            int i;
            int j = path.indexOf(44);
            if (j > 0) {
                path = path.substring(0, j);
            }
            if ((i = path.indexOf(43)) < 0) {
                return path;
            }
            String user = this.M.results.getString("ENV.USER").toLowerCase();
            path = path.substring(0, i) + user + path.substring(i + 1);
        }
        return path;
    }

    public String getOptPath(String opt, String area) {
        return Shell.getOptPath(opt, area);
    }

    @InternalUseOnly
    @Deprecated
    public boolean exists(String area, String name, String ext) {
        IOResource res = this.findResource(this.getName("SYS", area, name, ext), -1, "", "");
        return res.exists();
    }

    public boolean exists(String url) {
        IOResource res = this.findResource(url, -1, "", "");
        return res.exists();
    }

    public boolean find(String filename) {
        IOResource res = this.findResource(filename, -1);
        return res.exists();
    }

    public String[] listFiles(Object path, String name, String ext) {
        MatchCriteria filter = new MatchCriteria(name, ext);
        return this.listFiles(path, filter);
    }

    public String[] listFiles(Object path, FilenameFilter filter) {
        if (path == null) {
            return null;
        }
        IOResource res = this.findResource(path, -1, "", "");
        if (res == null) {
            return null;
        }
        return res.getEntryList(filter);
    }

    public String getTag(String name) {
        String tag = name;
        return tag;
    }

    public static boolean rename(String fn1, String fn2) {
        File f1;
        if (fn1.startsWith("file:")) {
            fn1 = fn1.substring(5);
        }
        if (fn2.startsWith("file:")) {
            fn2 = fn2.substring(5);
        }
        File toDelete = f1 = new File(fn1);
        File f2 = new File(fn2);
        boolean renamed = f1.renameTo(f2);
        if (!renamed) {
            try {
                FileUtil.copyBaseFile(null, f1, f2);
                renamed = true;
            }
            catch (Exception e) {
                Shell.printStackTrace("Copy attempt failed for rename across file systems", e);
            }
        }
        if (renamed && toDelete.exists()) {
            toDelete.delete();
        }
        return renamed;
    }

    public static boolean isDirectoryName(String pathname) {
        boolean isDir;
        File tempFile = new File(pathname);
        try {
            isDir = tempFile.exists() ? tempFile.isDirectory() : pathname.endsWith(System.getProperty("file.separator"));
        }
        catch (Exception e) {
            isDir = pathname.endsWith(System.getProperty("file.separator"));
        }
        return isDir;
    }

    public String getOptions() {
        return this.ioOptions.toString();
    }

    public void setOptions(String maskStr) {
        boolean curDisableEscapes;
        boolean prevDisableEscapes = this.ioOptions.isSet(IOOptions.DisableEscapeSequences);
        if (this.isMidasLoggerOptionValid(maskStr)) {
            this.ioOptions.setValue((CharSequence)maskStr, DEF_IOOPTIONS_OPTIONS);
        }
        if (this.M != null && this.M.macro != null && (curDisableEscapes = this.ioOptions.isSet(IOOptions.DisableEscapeSequences)) != prevDisableEscapes) {
            String tmp = curDisableEscapes ? "Adding" : "Removing";
            this.M.warning(tmp + " IOOPTIONS.DisableEscapeSequences DOES NOT take effect until macro is parsed.");
        }
        if (this.ioOptions.isSet(IOOptions.DisableEscapeSequences)) {
            String msg = "Single backslash char ('\\') in quoted strings are deprecated since 3.1.0.\n  Run 'ENV set IOOPTIONS -DisableEscapeSequences' to enable Java/C-like backslash\n  escape sequences (i.e. two backslashes \\\\ to represent one backslash \\).";
            if (this.M != null) {
                this.M.deprecate(msg);
            } else {
                System.out.println("DEPRECATE: " + msg);
            }
        }
        if (this.ioOptions.isSet(IOOptions.MidasLoggerShouldUseLogUtilities)) {
            Midas.setUseLogUtilities(true);
        } else {
            Midas.setUseLogUtilities(false);
        }
        Convert.setFavorJavaBehavior(this.ioOptions.isSet(IOOptions.FavorJavaBehaviorOverTraditionalMidasBehavior));
        Convert.setAlwaysDefaultToDouble(this.ioOptions.isSet(IOOptions.DefaultToDoubleOnConvertO2nS2nEvenWhenPrecisionIsLost));
        Convert.setMinSupportUnsupportedDataTypes(this.ioOptions.isSet(IOOptions.MinimalSupportForUnsupportedDataTypes));
    }

    private boolean isMidasLoggerOptionValid(String maskStr) {
        if (maskStr.toUpperCase().contains("MIDASLOGGERSHOULDUSELOGUTILITIES") && this.ioOptions.isSet(IOOptions.ClassBasedLoggerShouldUseMidasLogger) && !maskStr.toUpperCase().contains("-CLASSBASEDLOGGERSHOULDUSEMIDASLOGGER")) {
            this.M.warning("Option not set sucessfully, please disable ClassBasedLoggerShouldUseMidasLogger in order to enable MidasLoggerShouldUseLogUtilities");
            return false;
        }
        if (maskStr.toUpperCase().contains("CLASSBASEDLOGGERSHOULDUSEMIDASLOGGER") && this.ioOptions.isSet(IOOptions.MidasLoggerShouldUseLogUtilities) && !maskStr.toUpperCase().contains("-MIDASLOGGERSHOULDUSELOGUTILITIES")) {
            this.M.warning("Option not set sucessfully, please disable MidasLoggerShouldUseLogUtilities in order to enable ClassBasedLoggerShouldUseMidasLogger");
            return false;
        }
        return true;
    }

    public boolean isOptionSet(IOOptions flag) {
        return this.ioOptions.isSet(flag);
    }

    static int okToCopy(File SourceFullFile, File TargetFullFile, boolean OverwriteExistingFile, boolean MakeNonExistingDirs) {
        File TargetDirectory;
        Shell.deprecate("CoreIO.okToCopy method has been deprecated. Since NeXtMidas 2.5.0");
        int status = 1;
        if (!SourceFullFile.exists()) {
            status = -1;
        } else if (TargetFullFile.exists() && !OverwriteExistingFile) {
            status = -3;
        } else if (!(TargetFullFile.exists() || (TargetDirectory = TargetFullFile.getParentFile()).exists() || MakeNonExistingDirs)) {
            status = -2;
        }
        return status;
    }

    static int copyFile(String sourcename, String targetname, boolean OverWriteExistingFile, boolean MakeNonExistingDirs) {
        File TargetFullFile;
        Shell.deprecate("CoreIO.copyFile method has been deprecated. Since NeXtMidas 2.5.0");
        long MAX_BYTES_TO_READ = 0x100000L;
        File SourceFullFile = new File(sourcename);
        if (CoreIO.isDirectoryName(targetname)) {
            String tempPathName = targetname + sourcename;
            TargetFullFile = new File(tempPathName);
        } else {
            TargetFullFile = new File(targetname);
        }
        try {
            SourceFullFile = SourceFullFile.getCanonicalFile();
            TargetFullFile = TargetFullFile.getCanonicalFile();
        }
        catch (IOException e) {
            System.out.println("Exception " + e + " attempting to build full file names");
        }
        File TargetDirectory = TargetFullFile.getParentFile();
        int status = CoreIO.okToCopy(SourceFullFile, TargetFullFile, OverWriteExistingFile, MakeNonExistingDirs);
        if (status == 1) {
            try {
                boolean DirsExist = TargetDirectory.exists() ? true : TargetDirectory.mkdirs();
                if (DirsExist) {
                    FileInputStream fins = new FileInputStream(SourceFullFile);
                    FileOutputStream fouts = new FileOutputStream(TargetFullFile);
                    long totalBytes = SourceFullFile.length();
                    int bytesToRead = (int)Math.min(0x100000L, totalBytes);
                    byte[] byteBlock = new byte[bytesToRead];
                    for (double bytesRemaining = (double)totalBytes; bytesRemaining > 0.0; bytesRemaining -= (double)bytesToRead) {
                        if (bytesRemaining < (double)bytesToRead) {
                            byte[] byteTailArray = new byte[(int)bytesRemaining];
                            fins.read(byteTailArray);
                            fouts.write(byteTailArray);
                            break;
                        }
                        fins.read(byteBlock);
                        fouts.write(byteBlock);
                    }
                    fins.close();
                    fouts.close();
                } else {
                    status = -4;
                }
            }
            catch (IOException e) {
                System.out.println("IO Exception " + e);
            }
        }
        return status;
    }

    @Deprecated
    public static void recursiveCopy(String root, FilenameFilter filter, File fromDir, File toDir, boolean verbose, boolean flatten) {
        Copier copier = new Copier(toDir, filter, root);
        copier.setVerbose(verbose);
        copier.setFlatten(flatten);
        copier.execute(fromDir);
    }

    static class Copier
    extends FileVisitor {
        private File toDir = null;
        private String root = "";
        private boolean verbose = false;
        private boolean flatten = false;

        public Copier(File toDir, FilenameFilter ff, String root) {
            super(ff);
            Shell.deprecate("Copier class has been deprecated. Since NeXtMidas 2.5.0");
            this.toDir = toDir;
            this.root = root;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void setFlatten(boolean flatten) {
            this.flatten = flatten;
        }

        @Override
        public void visit(String name) {
            if (this.verbose) {
                System.out.println("Copying " + name);
            }
            String newName = this.getDestFileName(name);
            CoreIO.copyFile(name, newName, true, true);
        }

        public String getDestFileName(String name) {
            String newName = name;
            if (name.startsWith(this.root)) {
                newName = newName.substring(this.root.length());
            }
            if (this.flatten) {
                newName = new File(name).getName();
            }
            return new File(this.toDir, newName).getAbsolutePath();
        }
    }

    public static class MatchCriteria
    implements FilenameFilter {
        private String nameList;
        private String extList;
        private Parser parsedName;
        private Parser parsedExt;
        private boolean excludeName = false;
        private boolean excludeExt = false;
        private boolean dir = false;
        private boolean dirExists = false;

        public MatchCriteria() {
            this.setCriteria("", "");
        }

        public MatchCriteria(String name, String ext) {
            this.setCriteria(name, ext);
        }

        public MatchCriteria(String name, String ext, boolean dirExists) {
            this.setCriteria(name, ext);
            this.dirExists = dirExists;
        }

        @Override
        public boolean accept(File path, String name) {
            File fut;
            String lcname = name.toLowerCase();
            if (this.dirExists && (fut = new File(path, name)).isDirectory()) {
                return true;
            }
            if (this.excludeName == this.passFN(lcname)) {
                return false;
            }
            if (!this.dir && this.excludeExt == this.passEXT(lcname)) {
                return false;
            }
            if (path != null) {
                fut = new File(path, name);
                if (!fut.exists()) {
                    return false;
                }
                if (this.dir != fut.isDirectory()) {
                    return false;
                }
            }
            return true;
        }

        public void setCriteria(String name, String ext) {
            this.setMatchName(name);
            this.setMatchExt(ext);
        }

        public void setDirExists(boolean state) {
            this.dirExists = state;
        }

        public void setMatchName(String name) {
            this.nameList = name.toLowerCase();
            this.excludeName = this.nameList.startsWith("-");
            if (this.excludeName) {
                this.nameList = this.nameList.substring(1);
            }
            this.parsedName = new Parser(this.nameList, '|');
        }

        public void setMatchExt(String ext) {
            this.extList = ext.toLowerCase();
            this.dir = this.extList.equals("dir");
            this.excludeExt = this.extList.startsWith("-");
            if (this.excludeExt) {
                this.extList = this.extList.substring(1);
            }
            this.parsedExt = new Parser(this.extList, '|');
        }

        protected boolean passFN(String name) {
            if (this.nameList.equals("all")) {
                return true;
            }
            if (this.nameList.equals("*")) {
                return true;
            }
            if (this.nameList.isEmpty()) {
                return true;
            }
            int i = name.lastIndexOf(46);
            if (i >= 0) {
                name = name.substring(0, i);
            }
            this.parsedName.reset();
            while (this.parsedName.more()) {
                String criteria = this.parsedName.next();
                if (!StringUtil.isWildcardMatch(criteria, name)) continue;
                return true;
            }
            return false;
        }

        protected boolean passEXT(String name) {
            boolean noExt;
            boolean bl = noExt = this.extList.length() == 0;
            if (this.extList.equals("all")) {
                return true;
            }
            if (this.extList.equals("*")) {
                return true;
            }
            int i = name.lastIndexOf(46);
            if (i < 0) {
                return noExt;
            }
            name = name.substring(i + 1);
            if (noExt && (name.equals("prm") || name.equals("tmp") || name.equals("txt"))) {
                return true;
            }
            this.parsedExt.reset();
            while (this.parsedExt.more()) {
                String criteria = this.parsedExt.next();
                if (!StringUtil.isWildcardMatch(criteria, name)) continue;
                return true;
            }
            return false;
        }
    }

    static enum IOOptions {
        StrictHTTP,
        TruncateBLUE,
        DisableEscapeSequences,
        DisableQuadwordsEqualityChecks,
        DoNotPropagateTimelineKeywordsInPipe,
        DoublePropagateTimelineKeywordsInPipe,
        PreferPlatinumTimeLine,
        PreferBlueTCTimeLine,
        FixPipeRestartTimeLines,
        DisablePipeRestartTimeLinesFix,
        SuppressInvalidTimeLineEntryErrors,
        WriteNoAbort,
        FileIONoAbort,
        UseSemiColonsInGenerateManifest,
        EnableGraphicsOptimizationRequiringNoOverlappingPanes,
        FavorJavaBehaviorOverTraditionalMidasBehavior,
        DefaultToDoubleOnConvertO2nS2nEvenWhenPrecisionIsLost,
        ShapeFileBooleanAsString,
        ClassBasedLoggerShouldUseMidasLogger,
        DisableResultUsageWithCaretInTable,
        MidasLoggerShouldUseLogUtilities,
        DisableTimeLineAutoCorrectNoOffset0Entry,
        CreateFileWithoutTmpExtenstion,
        CreateFileMaintainCase,
        SetKeywordDefaultFlatValueToFalse,
        DoNotPropagateVolatileKeywords,
        DoNotAllowExecutionOfMacroOutsideOfHomepath,
        MinimalSupportForUnsupportedDataTypes,
        SameTimelineKeywords;

    }
}

