/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import nxm.sys.inc.SpecialLoggingRequired;
import nxm.sys.lib.IsFoundHelper;
import nxm.sys.lib.Shell;

@SpecialLoggingRequired
public final class CallStackUtil {
    private static final Logger LOG;
    private static final Object javaLangAccess;
    private static final Method getStackTraceDepth;
    private static final Method getStackTraceElement;
    private static final Object stackWalker;
    private static final Method walk;
    private static final Method toStackTraceElement;
    private static final Method getClassNameStackWalker;

    private CallStackUtil() {
    }

    public static StackTraceElement getCaller(Class<?> self) {
        return CallStackUtil.getCaller(self, null);
    }

    public static StackTraceElement getCallerByClass(Class<?> clazz) {
        try {
            return CallStackUtil.getStackTraceElementJava8ByClass(clazz);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.log(Level.WARNING, "Error inspecting stack", e);
            return null;
        }
    }

    private static StackTraceElement getCallerJava8Code(Class<?> self, Class<?> expectType) {
        Throwable t = new Throwable();
        boolean foundSelf = false;
        StackTraceElement save = null;
        try {
            int depth = (Integer)getStackTraceDepth.invoke(javaLangAccess, t);
            for (int i = 0; i < depth; ++i) {
                StackTraceElement elem = (StackTraceElement)getStackTraceElement.invoke(javaLangAccess, t, i);
                String clazz = elem.getClassName();
                try {
                    Class<?> c;
                    IgnoreStackElement ignore;
                    if (clazz.equals(self.getName())) {
                        foundSelf = true;
                        continue;
                    }
                    if (!foundSelf || clazz.startsWith("java.lang.reflect.") || clazz.startsWith("sun.reflect.") || CallStackUtil.isIgnored(ignore = (c = Class.forName(clazz)).getAnnotation(IgnoreStackElement.class), elem)) continue;
                    if (expectType == null) {
                        return elem;
                    }
                    if (save == null) {
                        save = elem;
                    }
                    if (clazz.startsWith("org.junit.") || clazz.startsWith("org.gradle.api.internal.")) {
                        return save;
                    }
                    if (!expectType.isAssignableFrom(Class.forName(clazz))) continue;
                    return elem;
                }
                catch (ClassNotFoundException e) {
                    LOG.log(Level.WARNING, "Error inspecting stack", e);
                    return save == null ? elem : save;
                }
            }
            return save;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not obtain caller using fast method", e);
            return null;
        }
    }

    public static StackTraceElement getCaller(Class<?> self, Class<?> expectType) {
        if (javaLangAccess != null) {
            return CallStackUtil.getCallerJava8Code(self, expectType);
        }
        if (stackWalker != null) {
            try {
                return CallStackUtil.getStackTraceElementJava8(self, expectType);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.log(Level.WARNING, "Error inspecting stack", e);
                return null;
            }
        }
        Throwable t = new Throwable();
        boolean foundSelf = false;
        StackTraceElement save = null;
        for (StackTraceElement elem : t.getStackTrace()) {
            try {
                Class<?> c;
                IgnoreStackElement ignore;
                String clazz = elem.getClassName();
                if (clazz.equals(self.getName())) {
                    foundSelf = true;
                    continue;
                }
                if (!foundSelf || clazz.startsWith("java.lang.reflect.") || clazz.startsWith("sun.reflect.") || CallStackUtil.isIgnored(ignore = (c = Class.forName(clazz)).getAnnotation(IgnoreStackElement.class), elem)) continue;
                if (expectType == null) {
                    return elem;
                }
                if (save == null) {
                    save = elem;
                }
                if (clazz.startsWith("org.junit.") || clazz.startsWith("org.gradle.api.internal.")) {
                    return save;
                }
                if (!expectType.isAssignableFrom(Class.forName(clazz))) continue;
                return elem;
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.WARNING, "Error inspecting stack", e);
                return save == null ? elem : save;
            }
        }
        return save;
    }

    static boolean isIgnored(IgnoreStackElement ignore, StackTraceElement elem) {
        if (ignore == null) {
            return false;
        }
        String[] methods = ignore.methods();
        if (methods.length == 1 && methods[0].equals("*")) {
            return true;
        }
        String methodName = elem.getMethodName();
        for (String name : methods) {
            if (!name.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchHelper(Object f, Class<?> self, IsFoundHelper ifh) {
        if (self == null) {
            return true;
        }
        try {
            String clazz = (String)getClassNameStackWalker.invoke(f, new Object[0]);
            if (!ifh.pastSelf && clazz.equals(self.getName())) {
                ifh.isFound = true;
                return false;
            }
            if (!ifh.isFound) {
                return false;
            }
            ifh.pastSelf = true;
            ifh.elem = (StackTraceElement)toStackTraceElement.invoke(f, new Object[0]);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.log(Level.CONFIG, "Current configuration does not support fast implementation of getCaller(..)", e);
            return true;
        }
    }

    private static boolean matchExpectType(Object f, Class<?> expectType, IsFoundHelper ifh) {
        if (expectType == null) {
            return true;
        }
        try {
            if (expectType.isAssignableFrom(Class.forName((String)getClassNameStackWalker.invoke(f, new Object[0])))) {
                ifh.elem = (StackTraceElement)toStackTraceElement.invoke(f, new Object[0]);
                return true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean shouldIgnore(Object f) {
        try {
            boolean dwInstanceOfStackTraceElement = f instanceof StackTraceElement;
            String className = dwInstanceOfStackTraceElement ? ((StackTraceElement)f).getClassName() : (String)getClassNameStackWalker.invoke(f, new Object[0]);
            Class<?> clazz = Class.forName(className);
            IgnoreStackElement ignore = clazz.getAnnotation(IgnoreStackElement.class);
            return CallStackUtil.isIgnored(ignore, dwInstanceOfStackTraceElement ? (StackTraceElement)f : (StackTraceElement)toStackTraceElement.invoke(f, new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static StackTraceElement getStackTraceElementJava8(Class<?> self, Class<?> expectType) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IsFoundHelper ifh = new IsFoundHelper();
        walk.invoke(stackWalker, s -> s.filter(f -> CallStackUtil.dropWhileHelperReflection(f, self, expectType, ifh)).findFirst().orElse(null));
        return ifh.elem;
    }

    private static boolean dropWhileHelperReflection(Object f, Class<?> self, Class<?> expectType, IsFoundHelper ifh) {
        try {
            StackTraceElement elem;
            String clazz = (String)getClassNameStackWalker.invoke(f, new Object[0]);
            if (!ifh.pastSelf && clazz.equalsIgnoreCase(self.getName())) {
                ifh.isFound = true;
                return false;
            }
            if (!ifh.isFound) {
                return false;
            }
            ifh.pastSelf = true;
            Class<?> c = Class.forName(clazz);
            IgnoreStackElement ignore = c.getAnnotation(IgnoreStackElement.class);
            if (CallStackUtil.isIgnored(ignore, elem = (StackTraceElement)toStackTraceElement.invoke(f, new Object[0]))) {
                return false;
            }
            if (expectType == null) {
                ifh.elem = elem;
                return true;
            }
            if (ifh.save == null) {
                ifh.save = elem;
            }
            if (clazz.startsWith("org.junit.") || clazz.startsWith("org.gradle.api.internal.") || clazz.startsWith("junit.framework.")) {
                ifh.elem = ifh.save;
                return true;
            }
            if (expectType.isAssignableFrom(Class.forName(clazz))) {
                ifh.elem = elem;
                return true;
            }
        }
        catch (Exception e) {
            LOG.log(Level.CONFIG, "Current configuration does not support fast implementation of getCaller(..)", e);
        }
        return false;
    }

    private static StackTraceElement getStackTraceElementJava8ByClass(Class<?> self) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object elem = null;
        if (stackWalker != null) {
            elem = walk.invoke(stackWalker, s -> s.filter(f -> {
                try {
                    return getClassNameStackWalker.invoke(f, new Object[0]).equals(self.getName());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    return false;
                }
            }).findFirst().orElse(null));
            return elem == null ? null : (StackTraceElement)toStackTraceElement.invoke(elem, new Object[0]);
        }
        return CallStackUtil.getCaller(self, null);
    }

    static {
        boolean currentJavaIs8;
        LOG = Logger.getLogger(CallStackUtil.class.getName());
        boolean bl = currentJavaIs8 = Shell.getJavaMajorVersion() == 8;
        if (!currentJavaIs8) {
            LOG.log(Level.INFO, "To get fast implementation, recompile with current version of Java (" + Shell.getJavaMajorVersion() + ") or run with JDK 8.\nThis code was originally compiled with JDK 8 and does not include the fast version for JDK9+");
        }
        if (currentJavaIs8) {
            Method _getStackTraceElement;
            Method _getStackTraceDepth;
            Object _javaLangAccess;
            try {
                Class<?> SharedSecrets = Class.forName("sun.misc.SharedSecrets");
                Class<?> JavaLangAccess = Class.forName("sun.misc.JavaLangAccess");
                Method getJavaLangAccess = SharedSecrets.getMethod("getJavaLangAccess", new Class[0]);
                _javaLangAccess = getJavaLangAccess.invoke(null, new Object[0]);
                _getStackTraceDepth = JavaLangAccess.getMethod("getStackTraceDepth", Throwable.class);
                _getStackTraceElement = JavaLangAccess.getMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
                Throwable t = new Throwable();
                int depth = (Integer)_getStackTraceDepth.invoke(_javaLangAccess, t);
                StackTraceElement stackTraceElement = (StackTraceElement)_getStackTraceElement.invoke(_javaLangAccess, t, 0);
            }
            catch (Throwable t) {
                LOG.log(Level.CONFIG, "Current configuration does not support fast implementation of getCaller(..)", t);
                _javaLangAccess = null;
                _getStackTraceDepth = null;
                _getStackTraceElement = null;
            }
            javaLangAccess = _javaLangAccess;
            getStackTraceDepth = _getStackTraceDepth;
            getStackTraceElement = _getStackTraceElement;
            stackWalker = null;
            walk = null;
            toStackTraceElement = null;
            getClassNameStackWalker = null;
        } else {
            Method _getClassNameStackWalker;
            Method _toStackTraceElement;
            Method _walk;
            Object _stackWalker;
            try {
                Method getStackWalker = Class.forName("java.lang.StackWalker").getMethod("getInstance", Class.forName("java.lang.StackWalker$Option"));
                HashSet options = new HashSet();
                options.add(Class.forName("java.lang.StackWalker$Option").getEnumConstants()[0]);
                _stackWalker = getStackWalker.invoke(null, Class.forName("java.lang.StackWalker$Option").getEnumConstants()[0]);
                _walk = _stackWalker.getClass().getMethod("walk", Function.class);
                _toStackTraceElement = Class.forName("java.lang.StackWalker$StackFrame").getMethod("toStackTraceElement", new Class[0]);
                _getClassNameStackWalker = Class.forName("java.lang.StackWalker$StackFrame").getMethod("getClassName", new Class[0]);
            }
            catch (Exception e) {
                LOG.log(Level.CONFIG, "Current configuration does not support fast implementation of getCaller(..)", e);
                _stackWalker = null;
                _walk = null;
                _toStackTraceElement = null;
                _getClassNameStackWalker = null;
            }
            stackWalker = _stackWalker;
            walk = _walk;
            toStackTraceElement = _toStackTraceElement;
            getClassNameStackWalker = _getClassNameStackWalker;
            javaLangAccess = null;
            getStackTraceDepth = null;
            getStackTraceElement = null;
        }
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IgnoreStackElement {
        public String[] methods() default {"*"};
    }
}

