/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.regex.Pattern;
import nxm.sys.lib.CommandLine;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class Update
extends Intrinsic {
    private static final Pattern CMD_NAME_REGEX = Pattern.compile("[A-Z_][A-Z0-9_]*([*][A-Z0-9_]*)?");
    CommandLine OldCmdLine;
    CommandLine CurCmdLine;
    String path;
    boolean done;

    @Override
    public int process() {
        Table tbl;
        int entry;
        this.done = false;
        boolean delete = this.MA.getState("/DELETE");
        boolean autoUpdate = this.MA.getState("/AUTO") || delete;
        String commandName = this.MA.getS("NAME");
        String support = this.MA.getS("SUPPORT");
        String sargs = this.MA.getS("NARGS");
        String opt = "";
        int iSemi = (commandName = this.getCommandName(commandName)).indexOf(";");
        if (iSemi >= 0) {
            opt = commandName.substring(iSemi + 1);
            commandName = commandName.substring(0, iSemi);
        }
        if (commandName.length() == 0) {
            commandName = this.promptUser("Command name", "", null);
            if (commandName == null || commandName.length() == 0) {
                throw new MidasException("UPDATE: No command name specified.");
            }
            commandName = commandName.toUpperCase();
        }
        if (commandName.endsWith(".MM") || commandName.endsWith(".JAVA") || commandName.endsWith(".FOR")) {
            throw new MidasException("UPDATE: Illegal command name '" + commandName + "'. Do not include file extension when calling UPDATE.");
        }
        if (!CMD_NAME_REGEX.matcher(commandName).matches()) {
            throw new MidasException("UPDATE: Illegal command name '" + commandName + "'. Command names must start with a letter and may only include letters (A-Z) numbers (0-9) and the underscore (_).");
        }
        String savedOpt = opt;
        opt = this.MA.getS("OPT", opt);
        if (!savedOpt.equals("") && !savedOpt.equalsIgnoreCase(opt)) {
            this.M.warning("Option '" + savedOpt + "' on command name overridden by OPT=" + opt);
        }
        this.path = "" + this.M.results.get("OPT.PATH");
        if (!autoUpdate && opt != null && !opt.equals("")) {
            this.path = opt;
        }
        this.OldCmdLine = new CommandLine(commandName, this.path);
        this.CurCmdLine = this.OldCmdLine.isInCommandsFile(this.path) ? this.OldCmdLine : new CommandLine(commandName, opt, support, sargs, null);
        if (opt != null && !opt.equals("")) {
            this.CurCmdLine.setOption(opt);
        }
        if (this.MA.isPresent("SUPPORT")) {
            this.CurCmdLine.setSupport(support);
        }
        if (this.MA.isPresent("NARGS")) {
            this.CurCmdLine.setNargsString(sargs);
        }
        if ((entry = this.M.dictionary.findMatch(commandName)) != -1 && (tbl = this.M.dictionary.getEntry(entry)) != null && tbl.containsKey("NARGS")) {
            this.CurCmdLine.setNargsString(tbl.getS("NARGS"));
        }
        int nargs = this.CurCmdLine.getNargs();
        String defs = ",";
        boolean anyDefaultsPresent = false;
        for (int i = 1; i <= nargs; ++i) {
            String defStr = this.MA.getS("DEF" + i);
            if (defStr != null && defStr != "") {
                anyDefaultsPresent = true;
                defs = defs.concat(defStr + ",");
                continue;
            }
            defs = defs.concat(this.CurCmdLine.getDefault(i) + ",");
        }
        if (anyDefaultsPresent) {
            this.CurCmdLine.setDefaults(defs);
        }
        if (!autoUpdate && !this.done) {
            this.prompt(commandName);
        }
        if (!this.done) {
            this.updateCommand(delete);
            Shell.runCommand(this.M, "PATH,REDO");
        }
        return 9;
    }

    private String getCommandName(String cmdName) {
        Parser p = this.M.dictionary.findParser(cmdName);
        if (p != null) {
            String tmp = p.get(1);
            int i = tmp.indexOf(59);
            return tmp.substring(0, i);
        }
        return cmdName;
    }

    public void prompt(String commandName) {
        if (!this.MA.isPresent("OPT")) {
            String opt = this.CurCmdLine.getOption();
            if (opt.equals("") && this.path != null) {
                int index = this.path.indexOf(",");
                opt = index != -1 ? this.path.substring(0, index) : this.path;
            }
            if ((opt = this.promptUser("Option tree (USER, SITE, UCL, etc):", opt, "Invalid option tree entered")) == null || opt == "") {
                this.done = true;
            } else {
                this.CurCmdLine.setOption(opt);
            }
        }
        if (this.path.toUpperCase().indexOf(this.CurCmdLine.getOption().toUpperCase()) < 0) {
            this.M.error(this.CurCmdLine.getOption() + " is not in path " + this.path);
        }
        String nameAbbrev = this.CurCmdLine.getAbbrevName();
        String nameFull = this.CurCmdLine.getName();
        if (commandName.indexOf("*") <= 0) {
            nameAbbrev = this.promptUser(nameFull + " Abbreviation:", nameAbbrev, "Invalid name abbreviation entered");
        }
        this.CurCmdLine.setAbbrevName(nameAbbrev);
        if (!this.MA.isPresent("SUPPORT")) {
            String support = this.CurCmdLine.getSupport();
            if (support == null || support == "") {
                support = "M";
            }
            if ((support = this.promptUser("Support (Any of: IPMHDOU)", support, "Invalid support entered")) == null || support == "") {
                this.done = true;
            } else {
                if (!CommandLine.isValidSupport(support = support.trim().toUpperCase())) {
                    this.M.error("Invalid support '" + support + "' entered. Valid supports are " + CommandLine.getValidSupports());
                }
                this.CurCmdLine.setSupport(support);
            }
        }
        if (!this.MA.isPresent("NARGS")) {
            String sargs = this.CurCmdLine.getNargsString();
            if ((sargs = this.promptUser("Number of arguments", sargs, "Invalid NARGS entered")) == null || sargs == "") {
                this.done = true;
            } else {
                this.CurCmdLine.setNargsString(sargs);
            }
        }
        int nargs = this.CurCmdLine.getNargs();
        String defs = ",";
        for (int i = 1; i <= nargs; ++i) {
            String token = this.CurCmdLine.getDefault(i);
            if (!this.MA.isPresent("DEF" + i)) {
                if (token == null) {
                    token = "";
                }
                token = this.promptUser("Default (TAG=value or - to remove) " + i, token, "Invalid default value entered");
            }
            defs = token.equals("-") ? defs.concat(",") : defs.concat(token + ",");
        }
        this.CurCmdLine.setDefaults(defs);
    }

    private String promptUser(String prompt, String def, String warnMsg) {
        String strInput;
        if (def != null) {
            prompt = prompt + " [" + def + "] -> ";
        }
        if ((strInput = this.M.terminal.getInput(prompt, "", 2)).startsWith("!") || strInput.startsWith("[") || strInput.startsWith("^")) {
            Shell.warning("Invalid input. Setting to default, if applicable");
            strInput = "";
        }
        if (strInput.length() == 0) {
            strInput = def;
            if (def == null) {
                this.M.warning(warnMsg);
            }
        }
        return strInput;
    }

    private String[] getTemplate() {
        String fname = this.M.io.name("CFG", "commands", "template", "SYS");
        TextFile infile = new TextFile(this.M, (Object)fname);
        String[] lines = null;
        lines = infile.open(32) ? infile.readAllLines() : new String[]{};
        infile.close();
        return lines;
    }

    private void updateCommand(boolean delete) {
        boolean updated = false;
        String fname = this.M.io.name("CFG", "commands", "cnf", this.CurCmdLine.getOption());
        TextFile infile = new TextFile(this.M, (Object)fname);
        TextFile outfile = new TextFile(this.M, (Object)fname);
        String cmdName = this.CurCmdLine.getName();
        String[] lines = null;
        if (!infile.exists()) {
            lines = this.getTemplate();
        } else {
            infile.open(8193);
            lines = infile.readAllLines();
        }
        infile.close();
        outfile.open(8194);
        for (String line : lines) {
            CommandLine tempCL = new CommandLine(line);
            String curname = tempCL.getName();
            int comparison = curname.compareTo(cmdName);
            if (comparison >= 0 && !updated) {
                if (!delete) {
                    this.writeCommand(outfile);
                }
                if (comparison > 0) {
                    outfile.writeln(line);
                }
                updated = true;
                continue;
            }
            outfile.writeln(line);
        }
        if (!updated && !delete) {
            this.writeCommand(outfile);
        }
        outfile.close();
    }

    private void writeCommand(TextFile outfile) {
        outfile.writeln(this.CurCmdLine.getCommandLine());
    }
}

