/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Table;

public class Switch
extends Intrinsic {
    @Override
    public int process() {
        String func = this.MA.getU("FUNC");
        String name = this.MA.getU("NAME");
        String label = this.MA.getU("VALUE");
        Object def = this.MA.find("DEF") ? this.MA.getO("DEF") : null;
        Object sdef = this.MA.find("SDEF") ? this.MA.getO("SDEF") : null;
        String nameAsSwitch = '/' + name;
        boolean bl = this.verbose = !this.MA.getZ("/QUIET", !this.verbose);
        if (func.equals("GET")) {
            this.MR.put(label, this.getSwitchValue(nameAsSwitch, def, sdef));
        } else if (func.equals("GETALL")) {
            Table values = Convert.o2t(label, this);
            if (values == null) {
                values = new Table();
            }
            for (String key : this.MA.getAllSwitchNames()) {
                String tag = key.substring(1);
                Object val = this.getSwitchValue(key, def, sdef);
                values.put(tag, val);
            }
            this.MR.put(label, (Object)values);
        } else if (func.equals("SET")) {
            if (label != null && this.M.macro != null && this.M.macro.lines != null && this.M.macro.lines[0] != null) {
                this.M.macro.lines[0].put(nameAsSwitch, label);
            }
        } else if (func.equals("DEL")) {
            Object val = this.getSwitchValue(nameAsSwitch, def, sdef);
            this.MR.put(label, val);
            if (this.MA.find(nameAsSwitch)) {
                if (this.verbose && this.MT != null) {
                    this.M.println("Removing " + name + " from Args table");
                }
                this.MA.remove(nameAsSwitch);
            }
            if (this.M.macro != null && this.M.macro.lines != null) {
                if (this.M.macro.lines[0] != null && this.M.macro.lines[0].find(nameAsSwitch)) {
                    if (this.verbose && this.MT != null) {
                        this.M.println("INFO: Removing " + nameAsSwitch + " from parent macro line switches");
                    }
                    this.M.macro.lines[0].remove(nameAsSwitch);
                }
                if (this.M.macro.lines[1] != null && this.M.macro.lines[1] != null) {
                    if (this.verbose && this.MT != null) {
                        this.M.println("INFO: Removing " + nameAsSwitch + " from macro line switches");
                    }
                    this.M.macro.lines[1].remove(nameAsSwitch);
                }
            }
        } else {
            this.M.warning("Switch func " + func + " not implemented yet");
        }
        return 9;
    }

    private Object getSwitchValue(String name, Object def, Object sdef) {
        boolean upperCase = this.MA.getNoState("/CS", true);
        Object value = this.MA.getO(name, null, upperCase);
        if (value == null) {
            return def;
        }
        if (value == Args.STATE_SWITCH_VAL) {
            if (sdef != null) {
                return sdef;
            }
            if (def != null) {
                return def;
            }
        }
        return value;
    }
}

