/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Remove
extends Intrinsic {
    public static final Table Protected_Results_Table = new Table("{1=OPT,2=REG,3=AUX,4=ENV,5=RAM}");

    @Override
    public int process() {
        boolean force = this.MA.getState("/FORCE");
        int removeOption = force ? 16 : 0;
        this.verbose = this.MA.getState("/VERBOSE", false);
        Table rt = this.MR;
        if (this.MA.getState("/PARENT")) {
            rt = this.MR.getPrevious();
        }
        if (this.MA.getState("/GLOBAL")) {
            rt = this.MR.getRoot();
        }
        for (int i = 1; i <= this.MA.numberOf(); ++i) {
            String label = this.MA.getU(i);
            if (StringUtil.isWildcardString(label)) {
                Table.Iterator ti = rt.iterator();
                while (ti.getNext()) {
                    String key = ti.key;
                    if (!StringUtil.isWildcardMatch(label, key)) continue;
                    if (Remove.isProtected(key)) {
                        if (!this.verbose) continue;
                        this.M.println(key + " is protected ");
                        continue;
                    }
                    if (this.verbose) {
                        this.M.println("removing " + key);
                    }
                    rt.remove(key);
                }
                continue;
            }
            if (Remove.isProtected(label)) {
                if (!this.verbose) continue;
                this.M.println(label + " is protected ");
                continue;
            }
            if (this.verbose) {
                this.M.println("removing " + label);
            }
            rt.remove(label, removeOption);
        }
        return 9;
    }

    private static boolean isProtected(String label) {
        boolean isProtected = false;
        Table tab = Protected_Results_Table;
        Table.Iterator ti = tab.iterator();
        while (ti.getNext()) {
            String protectedLabel = ti.value.toString();
            if (!protectedLabel.equals(label)) continue;
            isProtected = true;
            break;
        }
        return isProtected;
    }
}

