/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.intr.Results;
import nxm.sys.lib.Command;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Time;

public class Registry
extends Intrinsic {
    String func;
    String p1;
    String p2;
    boolean all;

    @Override
    public int process() {
        this.func = this.MA.getU("FUNC");
        this.p1 = this.MA.getU("P1");
        this.p2 = this.MA.getU("P2");
        this.all = this.MA.getState("/ALL");
        if (this.func.equals("SHOW")) {
            if (this.p1.length() == 0) {
                Results.listSingleResult(this.M, this.M.results, "REG", 0, this.all);
            } else {
                Object cmd = this.M.results.get("REG." + this.p1);
                if (cmd == null) {
                    this.M.warning("REGISTRY: " + this.p1 + " not found.");
                } else if (cmd instanceof Macro) {
                    Results.listMultipleResult(this.M, ((Macro)cmd).getRegistry(), "*", 0, true);
                } else {
                    Results.listSingleResult(this.M, this.M.results, "REG." + this.p1, 0, this.all);
                }
            }
        } else if (this.func.equals("SET")) {
            this.M.warning(this.func + " function: not yet CODED");
        } else if (this.func.equals("GET")) {
            this.M.warning(this.func + " function: not yet CODED");
        } else if (this.func.equals("START") || this.func.equals("STOP") || this.func.equals("RUN") || this.func.equals("PAUSE") || this.func.equals("FINISH") || this.func.equals("ABORT")) {
            double timeout;
            Command cmd = this.M.registry.getCommand(this.p1, 0);
            if (cmd == null) {
                this.M.error("Command " + this.p1 + " not found in registry");
            }
            cmd.setState(this.func);
            if (this.func.equals("FINISH") || this.func.equals("ABORT")) {
                for (timeout = this.MA.getD("/TIMEOUT", this.MA.getD("P2", 5.0)); timeout >= 0.0 && cmd.state != 4; timeout -= 0.1) {
                    Time.sleep(0.1);
                }
            }
            if (this.func.equals("START") || this.func.equals("RUN")) {
                while (timeout >= 0.0 && cmd.state != 2) {
                    Time.sleep(0.1);
                    timeout -= 0.1;
                }
            }
            if (timeout < 0.0) {
                this.M.warning("Command " + this.p1 + " to " + this.func + " timed out");
            }
        } else if (this.func.equals("WAIT")) {
            double timeout;
            Command cmd = this.M.registry.getCommand(this.p1, 0);
            if (cmd == null) {
                this.M.error("Command " + this.p1 + " not found in registry");
            }
            for (timeout = this.MA.getD("/TIMEOUT", this.MA.getD("P2", 5.0)); timeout >= 0.0 && (cmd.state == 0 || cmd.state == 1); timeout -= 0.1) {
                Time.sleep(0.1);
            }
            if (timeout < 0.0) {
                this.M.warning("Command " + this.p1 + " to " + this.func + " timed out");
            }
        } else if (this.func.startsWith("COPY")) {
            Object entry = this.M.registry.get(this.p1);
            if (entry == null) {
                this.M.error("Object not in registry");
            } else {
                this.M.registry.put(this.p2, entry);
            }
        } else {
            this.M.warning("Unsupported function: " + this.func);
        }
        return 9;
    }
}

