/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Command;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class Pipe
extends Intrinsic {
    String func;
    String controls;

    @Override
    public int process() {
        this.func = this.MA.getU("FUNC");
        if (this.func.equals("INIT") || this.func.equals("ON")) {
            this.setPipeMode(1);
            if (this.MA.find("/PANEL")) {
                String switches = "/MSGID=MAIN/SETUP=" + this.MA.getS("/SETUP");
                if (this.MA.find("/CONTROLS")) {
                    switches = switches + "/CONTROLS=" + this.MA.getS("/CONTROLS");
                }
                Shell.runCommand(this.M, "PANEL" + switches);
            }
        } else if (this.func.equals("RUN")) {
            this.setPipeMode(2);
        } else if (this.func.equals("PAUSE")) {
            this.setPipeMode(3);
        } else if (this.func.equals("WAIT")) {
            this.setPipeMode(4);
        } else if (this.func.equals("WAITFOR")) {
            this.setPipeMode(4);
            String regname = this.MA.getU(2);
            if (this.M.macro == null) {
                this.M.warning("No macro running");
            } else if (this.M.registry.get(regname) == null) {
                this.M.warning("WaitFor command " + regname + " not found in registry");
            } else {
                this.M.macro.waitFor = regname;
            }
        } else if (this.func.equals("STOP")) {
            this.setPipeMode(5);
        } else if (this.func.equals("OFF")) {
            Table.Iterator ti;
            Table mreg = this.M.registry.table;
            if (this.M.macro == null) {
                this.setPipeMode(4);
                while (mreg.size() > 1) {
                    Time.sleep(0.1);
                }
            } else if (this.M.pipeMode == 1 || this.M.pipeMode == 2) {
                this.setPipeMode(4);
                --this.M.macro.nextIndex;
                return 9;
            }
            this.setPipeMode(0);
            this.M.status = -3;
            if (this.M.macro != null && this.M.macro.getRegistry() != null) {
                mreg = this.M.macro.getRegistry();
                ti = mreg.iterator();
                while (ti.getNext()) {
                    if (ti.value instanceof Command && ((Command)ti.value).state != 0) continue;
                    mreg.remove(ti.key);
                }
            }
            if (mreg != null) {
                for (int i = 0; i < 20 && mreg.size() > 1; ++i) {
                    Time.sleep(0.1);
                }
            }
            if (mreg.size() > 1) {
                ti = mreg.iterator();
                while (ti.getNext()) {
                    if (ti.key.equals("MAIN")) continue;
                    this.M.warning("Timeout closing " + ti.value);
                }
            }
            if (this.M.macro != null && !this.M.macro.isShared(1)) {
                this.removePipes();
            }
            this.M.status = 0;
        } else {
            this.M.error("Unsupported pipe function: " + this.func);
        }
        return 9;
    }

    private void removePipes() {
        for (String key : this.M.pipes.getKeys()) {
            Object obj = this.M.pipes.get(key);
            if (!(obj instanceof nxm.sys.lib.Pipe)) continue;
            this.M.pipes.remove(key);
        }
    }

    private void setPipeMode(int mode) {
        if (this.M.macro != null) {
            this.M.macro.setPipeMode(mode);
        }
        this.M.pipeMode = mode;
    }
}

