/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Command;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class Message
extends Intrinsic {
    private static Class<?> rmifPrimClass = null;
    private static Class<?> plotPrimClass = null;
    private static Method plotStaticProcessMessage = null;

    @Override
    public int process() {
        Message from;
        String func = this.MA.getU("FUNC");
        Command command = from = this.M.macro != null ? this.M.macro : this;
        if (func.startsWith("SEND")) {
            boolean replace;
            boolean direct;
            boolean sync = func.indexOf(87, 4) > 0;
            nxm.sys.lib.Message msgt = this.send(sync, direct = func.indexOf(88, 4) > 0, replace = func.indexOf(82, 4) > 0, from);
            if (msgt != null) {
                this.MR.put(this.MA.getU("MSG"), (Object)msgt);
            }
        } else if (func.equals("GET")) {
            nxm.sys.lib.Message msg = this.MQ.get();
            this.MR.put(this.MA.getU("MSG"), (Object)msg);
        } else if (func.startsWith("GET")) {
            nxm.sys.lib.Message msg;
            int flags = 0;
            int timeout = 0;
            nxm.sys.lib.Message msgt = new nxm.sys.lib.Message("NULL", 0, null);
            if (func.indexOf(78) > 0) {
                msgt.name = this.MA.getS("NAME");
                flags |= 0x10;
            }
            if (func.indexOf(70) > 0) {
                msgt.from = this.M.registry.get(this.MA.getS("FROM"));
                flags |= 0x20;
            }
            if (func.indexOf(87) > 0) {
                timeout = (int)(1000.0 * this.MA.getD("/WAIT"));
            }
            if ((msg = this.MQ.get(flags, msgt, timeout)) == null) {
                msg = msgt;
                msg.name = "NULL";
            }
            this.MR.put(this.MA.getU("MSG"), (Object)msg);
        } else if (func.startsWith("PASS")) {
            String id = this.MA.getS("ID");
            nxm.sys.lib.Message msg = this.MA.getMessage("MSG");
            if (msg == null) {
                this.M.error("Message not found in results table");
            }
            if (this.MQ.put(msg, id, (Object)this.messageHandler) < 0) {
                this.M.warning("Command " + id + " not found in registry");
            }
        } else if (func.startsWith("PRUNE")) {
            nxm.sys.lib.Message msgt;
            nxm.sys.lib.Message msg = this.MA.getMessage("MSG");
            if (msg == null) {
                this.M.warning("Trying to prune a null message");
            }
            if ((msgt = this.MQ.prune(msg)) != msg) {
                this.MR.put(this.MA.getU("MSG"), (Object)msgt);
            }
        } else if (func.startsWith("QUERY")) {
            this.M.println("MQ owner = " + this.MQ.owner);
            this.M.println("MQ avail = " + this.MQ.avail());
        } else if (func.startsWith("SYNC")) {
            String id = this.MA.getS("ID");
            Command command2 = this.M.registry.getCommand(id, 0);
            this.MQ.put("NULL", 0, null, command2, from);
            while (command2.queue.avail() > 0) {
                Time.sleep(0.01);
            }
        } else if (func.startsWith("REPLACE")) {
            nxm.sys.lib.Message msg = this.getMessage(from);
            nxm.sys.lib.Message msgt = this.MQ.replace(msg);
            if (msgt != msg) {
                this.MR.put(this.MA.getU("MSG"), (Object)msgt);
            }
        } else {
            this.M.error("Unsupported function: " + func);
        }
        return 9;
    }

    nxm.sys.lib.Message send(boolean sync, boolean direct, Object from) {
        return this.send(sync, direct, false, from);
    }

    nxm.sys.lib.Message send(boolean sync, boolean direct, boolean replace, Object from) {
        Object to;
        nxm.sys.lib.Message replacedMsg = null;
        String id = this.MA.getS("ID");
        boolean msgDebug = this.MA.find("/MSGDEBUG");
        String debugLevel = this.MA.getS("/MSGDEBUG", "DEFAULT");
        if (debugLevel.equals("")) {
            debugLevel = "DEFAULT";
        }
        nxm.sys.lib.Message msg = this.getMessage(from);
        if (id.equals("REPLY")) {
            if (this.MA.find("NAME")) {
                msg.name = this.MA.getS("NAME");
            }
            if (this.MA.find("INFO")) {
                msg.info = this.MA.getL("INFO", 0);
            }
            if (this.MA.find("DATA")) {
                msg.data = this.MA.getO("DATA");
            }
            if (this.MA.find("QUALS")) {
                msg.quals = this.MA.getO("QUALS");
            }
            to = msg.from;
            from = msg.to;
        } else {
            to = id.indexOf(".") > 0 ? this.MA.getO("ID") : this.M.registry.getMessageHandler(id);
        }
        int status = -1;
        if (to == null) {
            status = -1;
        } else if (direct) {
            msg.from = from;
            msg.to = to;
            if (msg.to instanceof MessageHandler) {
                if (msgDebug) {
                    this.M.info(this.getName() + " sending direct " + msg.toString(debugLevel));
                }
                if (plotPrimClass != null && plotPrimClass.isInstance(msg.to)) {
                    try {
                        status = (Integer)plotStaticProcessMessage.invoke(null, msg.to, msg, direct);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        this.getMidas().warning("intr.Message unable to send message to plot " + ex);
                    }
                } else {
                    status = ((MessageHandler)msg.to).processMessage(msg);
                }
            }
        } else {
            if (msgDebug) {
                this.M.info(this.getName() + " sending " + msg.toString(debugLevel));
            }
            if (replace) {
                replacedMsg = this.MQ.replace(msg);
            }
            status = replacedMsg == null ? this.MQ.put(msg, to, from) : 0;
        }
        if (to != null && rmifPrimClass != null && rmifPrimClass.isInstance(to) && !sync) {
            if (msg.name.equals("OPEN") || msg.name.equals("ADDR")) {
                this.M.warning("Forcing use of MESSAGE SENDW for Rmif OPEN and ADDR messages");
            }
            sync = true;
        }
        if (status < 0) {
            this.M.warning("Unable to send Msg=" + msg.name + " to Id=" + id + " status=" + status + " to=" + to + " " + msg.toString(debugLevel));
        } else if (sync) {
            if (to instanceof Command) {
                Command command = (Command)to;
                status = this.MQ.put("NULL", 0, null, command, from);
                for (int timeout = (int)(1000.0 * this.MA.getD("/WAIT", 1.0)); timeout > 0 && command.queue.avail() > 0; timeout -= 10) {
                    Time.sleep(0.01);
                }
            } else {
                this.M.warning("Forcing use of MESSAGE SEND instead of SENDW for messages not destined for a Command. to=" + to);
            }
        }
        return replacedMsg;
    }

    nxm.sys.lib.Message getMessage(Object from) {
        nxm.sys.lib.Message msg = this.MA.getMessage("MSG");
        if (msg == null) {
            String msg_name = this.MA.getS("NAME");
            int msg_info = this.MA.getL("INFO", 0);
            Object msg_data = this.MA.getO("DATA");
            Object msg_quals = this.MA.getO("QUALS");
            Message.XmMsgType msg_type = this.MA.getSelection("/XMTYPE", Message.XmMsgType.AUTO);
            msg = new nxm.sys.lib.Message(msg_name, msg_info, msg_data, null, from, msg_quals);
            msg.setXmMessageType(msg_type);
        }
        return msg;
    }

    static {
        try {
            rmifPrimClass = Class.forName("nxm.sys.prim.rmif");
            plotPrimClass = Class.forName("nxm.sys.prim.plot");
            plotStaticProcessMessage = plotPrimClass.getDeclaredMethod("processMessage", plotPrimClass, nxm.sys.lib.Message.class, Boolean.TYPE);
        }
        catch (Exception ex) {
            Shell.getMidasContext().info("intr.Message seems to be operating in LIBNXM mode without Primitives");
        }
    }
}

