/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;

public class Import
extends Intrinsic {
    private boolean showWarnings = true;

    @Override
    public int process() {
        this.showWarnings = this.MA.getState("/WARN", this.showWarnings);
        if (this.MA.getState("/F")) {
            this.importFile();
        } else {
            this.importEnv();
        }
        return 9;
    }

    private void importEnv() {
        String in = this.MA.getString("IN", null, 0);
        String out = this.MA.getU("OUT");
        String def = this.MA.getCS("DEF");
        if (in == null || in.length() == 0) {
            this.M.error("Must give a variable name to import");
        }
        if (out == null || out.length() == 0) {
            out = in.toUpperCase();
        }
        Object value = null;
        value = in.equalsIgnoreCase("all") ? nxm.sys.lib.Import.getEnvTable() : nxm.sys.lib.Import.getEnv(in);
        if (value != null) {
            this.MR.put(out, value);
        } else if (!this.MR.containsKey(out) && !def.equals("")) {
            value = def;
            this.MR.put(out, value);
        } else if (this.showWarnings) {
            this.M.warning("Could not find ENV variable '" + in + "'");
        }
    }

    private void importFile() {
        DataFile dfi;
        boolean rename;
        FileName fileName;
        String extension;
        BaseFile bfi = this.MA.getBaseFile("IN");
        if (bfi.open()) {
            this.M.info("Importing URL=" + bfi.getURL());
        } else {
            this.M.error("Could not find URL=" + bfi.getURL());
        }
        if (bfi instanceof DataFile) {
            this.M.error("URL=" + bfi.getURL() + " is already a Midas file");
        }
        if ((extension = (fileName = bfi.getFileName()).getExt()).equals("tmp") || extension.equals("prm")) {
            this.M.error("Cannot import files with .tmp or .prm extensions - rename");
        }
        FileName fn = new FileName(bfi.getURL());
        fn.setExt("tmp");
        String newname = this.MA.getCS("OUT");
        boolean bl = rename = newname.length() > 0;
        if (rename) {
            fn.setRoot(newname);
        }
        if ((dfi = new DataFile(this, (Object)fn)).find(-1)) {
            dfi.erase(false);
            this.M.info("Erased Midas file URL=" + dfi.getURL());
        }
        DataFile dfo = new DataFile(this, (Object)fn);
        dfo.setFormat("SB");
        dfo.open(1026);
        if (rename) {
            dfo.setDetached(1);
        } else {
            dfo.setDetached(extension);
        }
        dfo.setDataStart(0.0);
        dfo.setDataSize(bfi.getSize());
        double size = -1.0;
        boolean dataSizeSet = false;
        for (int n = 3; n <= this.MA.numberOf(); ++n) {
            String key = this.MA.getKey(n);
            Object value = this.MA.getO(key);
            if (key.equals("DATASIZE")) {
                dataSizeSet = true;
            }
            if (key.equals("SIZE")) {
                size = Convert.o2d(value);
                continue;
            }
            KeyObject.setKey(dfo, key, value, this.M);
        }
        if (size == -1.0) {
            size = dataSizeSet ? dfo.getDataSize() / dfo.getBPE() : (bfi.getSize() - dfo.getDataStart()) / dfo.getBPE();
        }
        dfo.setSize(size);
        dfo.update();
        dfo.close();
        this.M.info("Created Midas header file URL=" + dfo.getURL());
        if (rename) {
            fn.setExt("det");
            bfi.rename(fn.getFullName());
            this.M.info("Renamed Import file to " + fn.getFullName());
        }
        bfi.close();
    }
}

