/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.FileInputStream;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Midas;
import nxm.sys.lib.StringUtil;

public class Headermod
extends Intrinsic {
    private static final String[] COMMON_HEADER_DEFINITION = new String[]{"4S:Header Version", "4S:Header Format", "4S:Data Format", "L:Detached Header", null, "L:Protection", "L:Pipe Mode", "L:Ext Header Start", "L:Ext Header Size", null, "D:Data Start", "D:Data Size", "L:File Type", "2S:Data Format", null, "I:Flag Mask", "D:Time Code", "I:Inlet Owner", "I:Num Outlets", null, "L:Outlet Asynch Mask", "L:Pipe Location", "L:Pipe Size (Bytes)", "D:Next In Byte", "D:Next Out Byte (Cum)", null, "D:Next Out Byte (Out1)", "D:              (Out2)", "D:              (Out3)", "D:              (Out4)", "D:              (Out5)", "D:              (Out6)", "D:              (Out7)", "D:              (Out8)", null, "L:Keyword Length", null, "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "8S:Keywords", "4S:Keywords"};
    private static final String[] TYPE1000_ADJUNCT_DEFINITION = new String[]{"D:Abscissa Start", "D:Abscissa Delta", "L:Abscissa Units", "L:Frame Size", null, "D:Secondary Start", "D:Secondary Delta", "L:Secondary Units", "L:Buffer ID"};
    private static final String[] TYPE3000_ADJUNCT_DEFINITION = new String[]{"D:Abscissa Start", "D:Abscissa Delta", "L:Abscissa Units", "L:Num Subrecords", null, "D:Secondary Start", "D:Secondary Delta", "L:Secondary Units", "L:Record Length", null, "#:SubRec  1", "#:SubRec  2", "#:SubRec  3", "#:SubRec  4", null, "#:SubRec  5", "#:SubRec  6", "#:SubRec  7", "#:SubRec  8", null, "#:SubRec  9", "#:SubRec 10", "#:SubRec 11", "#:SubRec 12", null, "#:SubRec 13", "#:SubRec 14", "#:SubRec 15", "#:SubRec 16", null, "#:SubRec 17", "#:SubRec 18", "#:SubRec 19", "#:SubRec 20", null, "#:SubRec 21", "#:SubRec 22", "#:SubRec 23", "#:SubRec 24", null, "#:SubRec 25", "#:SubRec 26"};

    @Override
    public int process() {
        boolean create = this.MA.getState("/CREATE");
        boolean attach = this.MA.getState("/ATTACH");
        boolean detach = this.MA.getState("/DETACH");
        boolean view = this.MA.getState("/VIEW");
        if (attach) {
            this.M.error("/ATTACH not implemented yet - see IMPORT/EXPORT");
        }
        if (this.MA.isPresent("/REP")) {
            this.M.warning("HEADERMOD: /REP=... not supported: use DATAREP= or HEADREP=");
        }
        DataFile hcb = this.MA.getDataFile("FILE");
        if (view) {
            Headermod.viewHeader(this.M, hcb);
        } else {
            if (detach) {
                hcb.setDetached(1);
            }
            if (create) {
                hcb.eraseFileName(false);
            } else {
                hcb.open(11);
            }
            for (int n = 2; n <= this.MA.numberOf(); ++n) {
                String key = this.MA.getKey(n);
                if (key.equalsIgnoreCase("REP")) {
                    this.M.error("HEADERMOD: REP=... not supported: use DATAREP= or HEADREP=");
                    continue;
                }
                if (key.equalsIgnoreCase("T")) {
                    this.M.error("HEADERMOD: T=... not supported: use TYPE=");
                    continue;
                }
                Object value = this.MA.getO(key);
                KeyObject.setKey(hcb, key, value, this.M);
            }
            if (create) {
                hcb.open(2);
                hcb.seek(hcb.size);
            }
            hcb.update();
            hcb.close();
        }
        return 9;
    }

    private static void viewHeader(Midas midas, DataFile dataFile) {
        dataFile.open(1);
        dataFile.convertHeaderRep(midas.getResults().getS("ENV.OSREP"));
        byte[] dfHeader = new byte[dataFile.hb.length];
        System.arraycopy(dataFile.hb, 0, dfHeader, 0, dfHeader.length);
        dataFile.close();
        String fName = dataFile.ioh.getURL();
        fName = fName.startsWith("file:") ? fName.substring(5) : null;
        byte[] fileHeader = new byte[dfHeader.length];
        try {
            FileInputStream in = new FileInputStream(fName);
            int bytes = in.read(fileHeader);
            if (bytes != fileHeader.length) {
                in.close();
                throw new Exception("Unable to read header from " + fName);
            }
            in.close();
        }
        catch (Exception e) {
            fileHeader = null;
        }
        int type = 0;
        if (fileHeader != null) {
            midas.type("");
            midas.type("Reading File: " + fName);
            midas.type("Using Format: " + Headermod.toString(fileHeader, 4, "4S"));
            midas.type("Using Type:   " + Headermod.toString(fileHeader, 48, "L"));
            try {
                type = Integer.parseInt(Headermod.toString(fileHeader, 48, "L"));
            }
            catch (Exception e) {
                midas.error(e);
            }
        } else {
            midas.type("");
            midas.type("File not found, reading from pipe.");
            type = dataFile.getType();
        }
        midas.type("");
        midas.type("COMMON HEADER         |             FILE AS READ FROM DISK             |        FILE AFTER BEING READ BY DATAFILE     ");
        Headermod.print(midas, '-');
        Headermod.print(midas, COMMON_HEADER_DEFINITION, fileHeader, dfHeader, 0);
        midas.type("");
        midas.type("");
        midas.type("TYPE " + type + " ADJUNCT     |             FILE AS READ FROM DISK             |        FILE AFTER BEING READ BY DATAFILE     ");
        Headermod.print(midas, '-');
        if (type < 1000) {
            midas.warning("Adjunct header info not available for Type " + type + " files");
        } else if (type < 3000) {
            Headermod.print(midas, TYPE1000_ADJUNCT_DEFINITION, fileHeader, dfHeader, 256);
        } else if (type < 4000) {
            Headermod.print(midas, TYPE3000_ADJUNCT_DEFINITION, fileHeader, dfHeader, 256);
        } else {
            midas.warning("Adjunct header info not available for Type " + type + " files");
        }
    }

    private static char getTypeChar(String type) {
        if (type.indexOf("S") == 1) {
            return 'S';
        }
        return type.charAt(0);
    }

    private static int getBPE(String type) {
        switch (Headermod.getTypeChar(type)) {
            case 'S': {
                return type.charAt(0) - 48;
            }
            case '#': {
                return 8;
            }
        }
        return Data.getBPS(type.charAt(0));
    }

    private static void print(Midas midas, String[] definition, byte[] fileHeader, byte[] nativeHeader, int index) {
        for (String def : definition) {
            if (def != null) {
                String[] entry = def.split(":");
                Headermod.print(midas, entry[1], fileHeader, nativeHeader, index, entry[0]);
                index += Headermod.getBPE(entry[0]);
                continue;
            }
            Headermod.print(midas, ' ');
        }
    }

    private static void print(Midas midas, String title, byte[] fileHeader, byte[] nativeHeader, int offset, String type) {
        if (fileHeader != null) {
            Headermod.print(midas, title, Headermod.bytesToString(fileHeader, offset, Headermod.getBPE(type)), Headermod.bytesToString(nativeHeader, offset, Headermod.getBPE(type)), Headermod.toString(fileHeader, offset, type), Headermod.toString(nativeHeader, offset, type));
        } else {
            Headermod.print(midas, title, "", Headermod.bytesToString(nativeHeader, offset, Headermod.getBPE(type)), "", Headermod.toString(nativeHeader, offset, type));
        }
    }

    private static String toString(byte[] buffer, int offset, String type) {
        char basicType = Headermod.getTypeChar(type);
        switch (basicType) {
            case 'S': {
                String str = "'";
                for (int i = 0; i < type.charAt(0) - 48; ++i) {
                    char val = (char)buffer[offset + i];
                    str = str + (val < ' ' || val > '~' ? (char)'.' : val);
                }
                str = str + "'";
                return str;
            }
            case '#': {
                return StringUtil.padRight(Headermod.toString(buffer, offset + 0, "4S") + "  " + Headermod.toString(buffer, offset + 4, "2S") + "  " + Headermod.toString(buffer, offset + 6, "I"), 20);
            }
            case 'D': 
            case 'F': {
                return "";
            }
            case 'B': 
            case 'I': 
            case 'L': 
            case 'X': {
                return Headermod.toIntStr(buffer, offset, type);
            }
        }
        throw new RuntimeException("Unknown data type '" + type + "'.");
    }

    private static String toIntStr(byte[] buffer, int offset, String type) {
        long value;
        block13: {
            String rep;
            block14: {
                char basicType;
                block12: {
                    basicType = Headermod.getTypeChar(type);
                    rep = new String(buffer, 4, 4);
                    value = 0L;
                    if (!rep.equals("EEEI")) break block12;
                    switch (basicType) {
                        case 'X': {
                            value += (long)((0xFF & buffer[offset + 7]) << 56);
                            value += (long)((0xFF & buffer[offset + 6]) << 48);
                            value += (long)((0xFF & buffer[offset + 5]) << 40);
                            value += (long)((0xFF & buffer[offset + 4]) << 32);
                        }
                        case 'L': {
                            value += (long)((0xFF & buffer[offset + 3]) << 24);
                            value += (long)((0xFF & buffer[offset + 2]) << 16);
                        }
                        case 'I': {
                            value += (long)((0xFF & buffer[offset + 1]) << 8);
                        }
                        case 'B': {
                            value += (long)((0xFF & buffer[offset + 0]) << 0);
                            break block13;
                        }
                        default: {
                            throw new RuntimeException("Unknown data type '" + type + "'.");
                        }
                    }
                }
                if (!rep.equals("IEEE")) break block14;
                switch (basicType) {
                    case 'X': {
                        value += (long)((0xFF & buffer[offset + 4]) << 56);
                        value += (long)((0xFF & buffer[offset + 5]) << 48);
                        value += (long)((0xFF & buffer[offset + 6]) << 40);
                        value += (long)((0xFF & buffer[offset + 7]) << 32);
                    }
                    case 'L': {
                        value += (long)((0xFF & buffer[offset + 0]) << 24);
                        value += (long)((0xFF & buffer[offset + 1]) << 16);
                        value += (long)((0xFF & buffer[offset + 2]) << 8);
                        value += (long)((0xFF & buffer[offset + 3]) << 0);
                        break block13;
                    }
                    case 'I': {
                        value += (long)((0xFF & buffer[offset + 0]) << 8);
                        value += (long)((0xFF & buffer[offset + 1]) << 0);
                    }
                    case 'B': {
                        value += (long)((0xFF & buffer[offset + 0]) << 0);
                        break block13;
                    }
                    default: {
                        throw new RuntimeException("Unknown data type '" + type + "'.");
                    }
                }
            }
            throw new RuntimeException("Unknown data rep '" + rep + "'.");
        }
        return Long.toString(value);
    }

    private static String bytesToString(byte[] buffer, int offset, int bytes) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < bytes; ++i) {
            int value = buffer[i + offset] & 0xFF;
            if (value < 16) {
                str.append('0');
            }
            str.append(Integer.toHexString(value));
            if (i % 2 != 1 || i == bytes - 1) continue;
            str.append(' ');
        }
        return str.toString();
    }

    private static void print(Midas midas, String title, String fileData, String nativeData, String fileInfo, String nativeInfo) {
        StringBuilder str = new StringBuilder(120);
        str.append(StringUtil.padRight(title, 20));
        str.append("  |  ");
        str.append(StringUtil.padRight(fileData, 20));
        str.append("  (");
        str.append(StringUtil.padLeft(fileInfo, 20));
        str.append(")  |  ");
        str.append(StringUtil.padRight(nativeData, 20));
        str.append("  (");
        str.append(StringUtil.padLeft(nativeInfo, 20));
        str.append(")");
        midas.type(str);
    }

    private static void print(Midas midas, char spacer) {
        midas.type(StringUtil.padRight("", 22, spacer) + '|' + StringUtil.padRight("", 48, spacer) + '|' + StringUtil.padRight("", 46, spacer));
    }
}

