/**
  Implements an RealTime RamBuffer File to GPU Memory Circular Buffer transfer 

  @author Jeff Schoen
  @version $Id: icertmon.c,v 1.9 2011/05/24 13:21:12 jgs Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include "icelib.h"
#include "icehdr.h"

int main (int argc, char *argv[])
{
  ICEHDR hcb;
  int_4 fd, status, xfer, count, *vaddr;
  int_8 paddr, psize, vsize, voff, iPtr, oPtr;
  char *froot, fname[80];

  if (argc != 4) { 
    printf ("Usage: icertmon filename xferLength count\n"); 
    exit(1); 
  }
  froot = argv[1]; 
  xfer = atoi(argv[2]); 
  count = atoi(argv[3]); 
  if (xfer<0) xfer *= -1024 * 1024;

  strcpy(fname,froot); strcat(fname,".det");
  fd = open(fname,O_RDONLY,0);
  if (fd<0) { printf ("Cannot open specified RAM file=%s\n",fname); exit(-1); }
  status = read(fd,&paddr,8);
  status = read(fd,&psize,8);
  close(fd);
  vaddr = (int_4*)pic_mapram(paddr,psize);
  printf ("Physical RAM alloc: paddr=%lx psize=%lx vaddr=%p\n",paddr,psize,vaddr);

  strcpy(fname,froot); strcat(fname,".tmp");
  fd = open(fname,O_RDONLY,0);
  if (fd<0) { printf ("Cannot open specified RAM file=%s\n",fname); exit(-1); }

  status = read(fd,&hcb,512);
  vsize = (int_8)(hcb.data_size);
  iPtr = oPtr = (int_8)hcb.in_byte;

  printf ("Virtual RAM alloc: size=%lx iptr=%lx \n",vsize,iPtr);
  if (fd<0) printf ("Cannot allocate specified RAM\n");

  for (;count!=0;) {
    if (iPtr-oPtr<xfer) {
      status = lseek(fd,0,SEEK_SET);
      status = read(fd,&hcb,512);
      iPtr = (int_8)hcb.in_byte;
    }
    if (iPtr-oPtr<xfer) { 
      usleep(10000);
    } else {
      voff = oPtr % vsize;
      printf("Processing data at voff=%lx optr=%lx iptr=%lx data=%08x\n",voff,oPtr,iPtr,vaddr[voff>>2]);
      oPtr += xfer;
      count--;
    }

  }

  pic_unmapram(paddr,psize,(char*)vaddr);
  close (fd);

  return 0;
}
