package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.ice.lib.ICEPacket;

/**
  Fan out multichannel packetized data into seperate pipes.

  @author Jeff Schoen
  @version $Id: picfanout.java,v 1.3 2001/04/25 17:08:12 kingm Exp $
*/
public class picfanout extends Primitive {

  private DataFile hi,ho[];
  private Data data;
  private boolean strip;
  private int nchan;
  private ICEPacket pkt;
  private byte buffer[];
  private int maxbytes;
  private int index=1;

  public int open() {

    hi = MA.getDataFile ("IN");
    hi.open();

    pkt = (ICEPacket)hi.getPacketHandler();
    if (pkt==null) M.error("Input file is not packetized: "+hi.getTag());

    String root = MA.getCS("OUT");
    nchan = MA.getL("NCHAN");
    ho = new DataFile[nchan];

    strip = MA.getState("/STRIP",false);
    index = MA.getL("/INDEX",index);

    for (int nc=0; nc<nchan; nc++) {
      ho[nc] = new DataFile();
      ho[nc].init(this,root+(nc+index),hi,0);
      if (strip) ho[nc].setPacketHandler(null);
      ho[nc].open();
    }

    maxbytes = hi.bpa * MA.getL("/TL",pkt.getFixedSize());
    buffer = new byte[maxbytes];

    return (NORMAL);
  }

  public int process() {

    // get the next packet header
    int n = hi.read(buffer,0,maxbytes);
    if (n==0) return (NOOP);
    if (n<0) return (FINISH);

    // validate the channel number
    int nc = pkt.getChannel();
    if (nc<=0 || nc>nchan) {
//      M.warning("Channel "+nc+" out of range [1-"+nchan+"]");
      return(NORMAL);
    }
    nc--; // zero based array indices

    // copy data to output
    ho[nc].write(buffer,0,n);

    return (NORMAL);
  }

  public int close() {
    hi.close();
    for (int nc=0; nc<nchan; nc++) ho[nc].close();
    return (NORMAL);
  }

  public int getChannels() { return nchan; }

}
