package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;

/**
  Compare two data files, determine offsets and/or errors.

  @author Jeff Schoen
  @version $Id: icediff.java,v 1.1 2006/10/07 18:54:49 jgs Exp $
*/
public class icediff extends Primitive {

  private DataFile hd,h1,h2;
  private Data dd,d1,d2;
  private boolean all,sync;
  private int diffs,maxSeek,maxShow,maxChk,find,mask;
  private double offset=0,total=0;

  public int open() {

    h1 = MA.getDataFile ("IN1","1000,2000","S#,C#",0);
    h1.open();

    h2 = MA.getDataFile ("IN2","1000,2000","S#,C#",0);
    h2.open();

    maxChk  = MA.getL("/MAXCHK",-1);
    maxSeek = MA.getL("/SEEK",64);
    maxShow = MA.getL("/SHOW",16);
    find    = MA.getL("/FIND",-1);
    mask    = MA.getL("/MASK",-1);
    all     = MA.getState("/ALL");
    sync    = all;

    byte dtype = h1.getFormatType();
    if (h1.getXDelta()!=h2.getXDelta()) M.warning("File xdeltas do not match");
    if (h1.getXUnits()!=h2.getXUnits()) M.warning("File xunits do not match");
    dtype = Data.promoteType(h1.getFormatType(),h2.getFormatType());

    hd = MA.getDataFile ("OUT",h1,0);
    hd.setFormatType(dtype);
    hd.open(hd.OUTPUT|hd.OPTIONAL);

    if (h1.typeClass==2) {
      h1.setDFS(0);
      h2.setDFS(0);
      hd.setDFS(0);
    }

    xfer = Math.max(1,(int)(bufSize/hd.dbpe));
    if (maxChk>0 && maxChk<xfer) xfer=maxChk;
    xfer = MA.getL("/TL",xfer);

    d1 = h1.getDataBuffer(xfer,dtype);
    d2 = h2.getDataBuffer(xfer,dtype);
    dd = hd.getDataBuffer(xfer,dtype);
    
    return (NORMAL);
  }

  public int process() {

    offset = h1.seek();
    if (maxChk>0 && offset>=maxChk) return (FINISH);

    int n1 = h1.read(d1);
    if (n1<=0) return (FINISH);

    int n2 = h2.read(d2);
    if (n2<=0) return (FINISH);

    int n = Math.min(n1,n2);
    if (sync) total += n;

    if (find>0) {
      for (int i=0; i<n-find; i++) {
        diffs=0; checkBytes (d1,d2,0,i,hd.bpa,find,false);
        if (diffs==0) M.info("Found pattern match at offset="+((long)h2.seek()-n+i));
      }
      h1.seek(0);
    }
    else if (sync) {
      checkBytes (d1,d2,0,0,hd.bpa,n,true);
    }
    else {
      int seek=maxSeek;
      for (int i=0; i<maxSeek; i++) {
        checkBytes (d1,d2,maxSeek,maxSeek+i,hd.bpa,maxSeek,false);
        if (diffs==0) { seek=i; break; } diffs=0;
        checkBytes (d1,d2,maxSeek,maxSeek-i,hd.bpa,maxSeek,false);
        if (diffs==0) { seek=-i; break; } diffs=0;
      }
      if (seek==maxSeek) {
        M.warning("No correlation found");
        seek = 0;
      } else if (seek!=0) {
        M.warning("Files appear to be offset by "+seek+" samples");
      }
      if (seek==0) {
        h1.seek(0);
        h2.seek(0);
      } else {
        h1.seek(maxSeek);
        h2.seek(maxSeek+seek);
      }
      sync = true;
    }
    return (NORMAL);
  }

  public int close() {
    MR.put(MA.getU("/STAT"),diffs);
    M.info ("Total of "+diffs+" differences found in "+total+" samples at "+Time.toString(Time.current()));
    h1.close();
    h2.close();
    hd.close();
    return (NORMAL);
  }

  private String l2x (int i4) {
    return Convert.l2x(i4);
  }
  private String x2x (long i8) {
    byte[] buf = new byte[8];
    Convert.packX(buf,0,i8);
    return Convert.bb2hex(buf,0,8);
  }

  private void checkBytes (Data d1, Data d2, int i1, int i2, int bpa, int n, boolean show) {
    byte[] b1 = d1.buf, b2 = d2.buf;
    if (bpa<0) { n = n*(-bpa)/8; bpa=1; }
    i1 *= bpa; i2 *= bpa; n *= bpa;
    int bps = (bpa>4)? 8 : 4;
    for (int i=0; i<n; i+=bps,i1+=bps,i2+=bps) {
      if (all);
      else if (mask==-1) {
        boolean ok=true;
        for (int j=0; j<bps; j++) if (b1[i1+j]!=b2[i2+j]) ok=false;
        if (ok) continue;
      } else {
        int m1 = mask & Convert.unpackL(b1,i1);
        int m2 = mask & Convert.unpackL(b2,i2);
        if (m1 == m2) continue;
      }
      diffs++;
      if (all);
      else if (!show || diffs>maxShow) continue;
      long off = (long)(offset+(i/bpa));
      if (bps==8) {
        long m1 = Convert.unpackX(b1,i1);
        long m2 = Convert.unpackX(b2,i2);
        M.info(" b1="+x2x(m1)+" b2="+x2x(m2)+" xor="+x2x(m1^m2)+" at "+l2x((int)off)+" or "+off);
      } else {
        int m1 = Convert.unpackL(b1,i1);
        int m2 = Convert.unpackL(b2,i2);
        M.info(" b1="+l2x(m1)+" b2="+l2x(m2)+" xor="+l2x(m1^m2)+" at "+l2x((int)off)+" or "+off);
      }
    }
  }

}
