package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.MDevIce;

/**
  Ice connector primitive to discover other ICE servers on the same network. 

  @author Jeff Schoen
  @version $Id: iceconnector.java,v 1.9 2011/05/24 13:21:12 jgs Exp $
*/
public class iceconnector extends Primitive {

  private Table node,nodes;
  private NetIO nio;
  private int port,xfer,nstat;
  private double timeLast,timeUpdate=2;
  private String hname,haddr,addr,rname,sname;
  private byte[] msgbuf;

  public int open() {

    port = MA.getL("PORT");		// multicase network port
    addr = MA.getS("ADDR");		// multicast network address
    node = MA.getTable("NODE");		// input this node config
    rname = MA.getU("NODES");		// output all nodes config

    hname = MR.getS("ENV.HOSTNAME");
    haddr = MR.getS("ENV.HOSTADDR");
    sname = hname+"-"+haddr;
    sname = sname.replace(".","_");

    nodes = new Table(Table.KV);
    nodes.put(sname,node);
    MR.put (rname,nodes);
    
    nio = new NetIO(true);
    String nioaddr = "udp:"+haddr+":"+port+"/"+addr+":"+port;
    M.info("IceConnector opening: "+nioaddr);
    nstat = nio.open(nioaddr,0,NetIO.INPUT|NetIO.OUTPUT);
    if (nstat<0) M.warning("Problem opening: "+nioaddr+" - local reporting only");

    xfer = 8192;
    msgbuf = new byte[xfer];
    timeUpdate = MA.getD("/TIMEUPD",timeUpdate);

    return (NORMAL);
  }

  public int process() {
    int n=recvNode();
    double timeCur = Time.current();
    if (timeCur-timeLast>timeUpdate) {
      sendNode();
      timeLast = timeCur;
    }
    return (n>0)?NORMAL:NOOP;
  }

  public int close() {
    if (nstat>=0) nio.close();
    return (NORMAL);
  }

  private int recvNode() {
    if (nstat<0) return 0;
    int n = nio.recv (0, msgbuf,0, xfer, 0);
    if (n>0) {
      String s = new String(msgbuf,0,n);
      int i = s.indexOf("={");
      String name = s.substring(0,i);
      if (name.equals(sname)) return 0;		// dont add possibly stale loopback of local node
      Table tbl = new Table(msgbuf,i+1,n-i-1);
      nodes.put(name,tbl);
    }
    return n;
  }

  private void sendNode() {
    if (nstat<0) return;
    String s = sname+"="+node.toString();
    byte[] msgb = s.getBytes();
    int n = msgb.length;
    nio.send (0, msgb,0, n, 0);
  }

  public int processMessage (Message msg) {
    if (msg.name.equals("UPDATE")) {
      sendNode();
    }
    else if (msg.name.equals("EXIT")) {
      return FINISH;
    }
    return NORMAL;
  }

}
