package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.MWindow;

import java.net.URL;
import java.net.URI;
import java.awt.Desktop;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.JScrollPane;
import javax.swing.JEditorPane;

/** Displays text/html content in a Midas window.

    @author Jeff Schoen 
    @version $Id: browse.java,v 1.66 2015/06/18 13:58:15 ntn Exp $
*/
public class browse extends GPrimitive implements MouseListener, MouseMotionListener, HyperlinkListener {

  private int level=0,status=0;
  private boolean exiting;
  private JScrollPane jsp;
  private JEditorPane jep;
  private URL[] urls = new URL[10];
  private int[] scrolls = new int[10];

  private static Desktop desktop; 
  static {
    try { desktop = Desktop.getDesktop(); } 
    catch (Exception e) { Shell.warning("Unable to get java.awt.Desktop instance for using browse(URI) method: "+e); }
  }

  public int open() {

    String sfn = MA.getCS("URL");
    URL url = formURL(sfn);
    urls[level] = url;

    MW = new MWindow("Text/HTML Browser",this);
    MW.open();
    MW.addTo(this);
    jep = new JEditorPane();
    jep.setContentType("text/html");
    jep.setEditable(false);
    jep.addHyperlinkListener(this);
    jep.addMouseMotionListener(this);
    jep.addMouseListener(this);
    showDoc(url);
    jsp = new JScrollPane();
    jsp.setViewportView(jep);
    Container panel = MW.getPanel();
    panel.setLayout(new java.awt.BorderLayout());
    panel.add(jsp);
    panel.invalidate();	// to get jsp to repaint()
    panel.validate();
    return NORMAL;
  }

  private void revalidate() {
    Container panel = MW.getPanel();
    if (panel==null || !panel.isShowing()) return;
    Container parent = panel.getParent();
    if (parent==null || !parent.isShowing()) return;
    parent.invalidate();
    parent.validate();
    panel.revalidate();
  }

  private URL formURL (String sfn) {
    if (!sfn.startsWith("\"")) sfn = "\""+sfn+"\"";
    FileName fn = BaseFile.getFileNameFor(this,sfn);
    sfn = fn.getFullName();
    URL url = null;
    if (sfn.indexOf(":")!=4) sfn="file:"+sfn;
    try { url = new URL(sfn); }
    catch (Exception e) { System.out.println("Bad URL: "+e); }
    return url;
  }

  private void showDoc (URL url) {
    try { 
      Document doc = jep.getDocument(); // next line to force reload
      if (doc!=null) doc.putProperty(Document.StreamDescriptionProperty,null);
      jep.setPage(url);
    }
    catch (Exception e) { System.out.println("Bad Document: "+e); }
  }

  public int process () {
    if (exiting) return FINISH;
    return NOOP;
  }

  public int close() {
    MW.close();
    return NORMAL;
  }

  // MW listerner
  public int processMessage (Message msg) {
//  System.out.println("Got msg: "+msg+" "+msg.data);
    switch (msg.name) {
      case "PAINT":	break;
      case "REFRESH":	MW.refresh(); break;
      case "RESIZE":	MW.resize(1); revalidate(); break;
      case "WINDOW":	if (msg.info==0) exiting=true; break;
      case "SAVEFILE":	saveCurrent(); break;
      case "SAVEFILEAS": saveCurrent(msg.data.toString()); break;
      case "BUTTON":	if (msg.info==2) new GMenu (MW,"Browse","Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit",0,0,this); break;
      case "OPENFILE": 
	URL url = formURL(msg.data.toString());
	if (msg.info<0) level++; else level=msg.info;
	urls[level]=url;
	showDoc(url);
	break;
      case "BROWSE":
	switch (msg.data.toString()) {
	  case "BACK":
	    if (level<=0);
	    else if (jep.isEditable()) verifyCurrent();
	    else showDoc(urls[--level]);
	    break;
	  case "FORWARD":
	    if (urls[level+1]==null);
	    else if (jep.isEditable()) verifyCurrent();
	    else showDoc(urls[++level]);
	    break;
	  case "OPENBROWSER":	openBrowser(urls[level]); break;
	  case "OPENEDITOR":	openEditor(urls[level]); break;
	  case "SYNC":		if (jep.isEditable()) saveCurrent(); break;
	  case "EDIT":		jep.setEditable(true); break;
	  case "SAVE":		saveCurrent(); break;
	  case "SAVEAS": 	jep.setEditable(false); new GFiles(MW,"SaveFileAs",urls[level].toString(),"*.txt|java|jv|c|sv|v",null,M,0,0,0,this); break;
	  case "EXIT":		exiting=true; break;
	  default: M.warning("Browse menu item="+msg.data+" not coded yet");
	}
    }
    return NORMAL;
  }

  private void verifyCurrent () {
    new GAlert (MW,"SaveFile","Save current modifications? ","Yes,No",1,0,this);
  }

  private void saveCurrent () {
    String fn = urls[level].toString();
    saveCurrent(fn);
  }

  private void saveCurrent (String fn) {
    jep.setEditable(false);
    String s = jep.getText();
    TextFile tf = new TextFile(fn);
    M.info("Saving file as: "+fn);
    tf.open(tf.OUTPUT);
    tf.write(s);
    tf.close();
  }

  public boolean openBrowser (URL url) {
    boolean result = false;
    if (desktop!=null && url!=null) { // if we have java.awt.Desktop instance AND URL is not null
      try {
        desktop.browse(new URI(url.toString())); // Java6 API
        // if we got here without an Exceptions, then URL was probably opened in browser
        result = true;
      }
      catch (Exception e) { Shell.printStackTrace(e); }
    }
    return result;
  }

  public boolean openEditor (URL url) {
    String editor = MR.getString("ENV.EDITOR");
    String sfn = url.toString();
    if (sfn.startsWith("file:")) sfn = sfn.substring(5);
    Foreign.runInternal (M,editor+" "+sfn);
    return true;
  }

  // jep mouse listeners
  public void mouseEntered (MouseEvent e) { }
  public void mouseExited (MouseEvent e) { }
  public void mousePressed (MouseEvent e) { }
  public void mouseReleased (MouseEvent e) { }
  public void mouseClicked (MouseEvent e) {
    int modifiers = e.getModifiers();
    if ((modifiers&MouseEvent.BUTTON3_MASK)!=0 && level>0) {
      showDoc(urls[--level]);
    }
    if ((modifiers&MouseEvent.BUTTON2_MASK)!=0) {
      new GMenu (MW,"Browse","Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit",0,0,this);
    }
  }
  public void mouseMoved (MouseEvent e) {
    MW.px = e.getX();
    MW.py = e.getY();
  }
  public void mouseDragged (MouseEvent e) { }


  // jep hyperlink listeners
  public void hyperlinkUpdate (HyperlinkEvent evt) {
    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
      if (evt instanceof HTMLFrameHyperlinkEvent) {
	M.warning("Frame hyperlink event");
      } else if (level>=urls.length-1) {
	M.warning("Too many hyperlinkevt.getURL() levels");
      } else {
	URL url = evt.getURL();
	String surl = url.toString();
	int iq = surl.indexOf('?');
	if (iq<0) urls[++level]=url;
	else if (surl.charAt(iq-1)=='/') {
	  surl = urls[level].toString()+surl.substring(iq);
	  try { url = new URL(surl); } catch (Exception e) { System.out.println("Browse: "+e); }
	}
	showDoc(url);
      }
    }
  }

}
