package nxm.ice.net;

import nxm.sys.lib.*;

/** A class to send a message to a macro through an Http request.
    @author Jeff Schoen / Neon Ngo
    @version $Id: HMessage.java,v 1.21 2014/09/23 15:13:49 ntn Exp $
*/
public class HMessage extends HSource {

  private Midas M;
  private static boolean debug = false; // enable to turn on debug messages

  public HMessage (String name, Midas M) {
    if (!name.endsWith("/")) name += '/';
    this.name = name;
    this.M = M;
  }

  public void handleRequest (String uri, HPage hp) {
    if (debug) Shell.writeln("HMessage.handle() "+uri);
    int i = uri.indexOf('?');
    String a = uri.substring(0,i);
    String s = uri.substring(i+1);
    Table t = new Table(s);
    String name = t.getS("NAME");
    int    info = t.getL("INFO",0);
    Object data = t.getO("DATA");
    if (name.equals("SYNC")) {
      M.macro.queue.put("NULL",0,null);
      int timeout = (info>0)? 1000*info : 1000;	// default to 1 sec timeout
      while (timeout>0 && M.macro.queue.avail()>0) { Time.sleep(0.010); timeout-=10; }
    }
    else if (a.endsWith("Send")) {
      M.macro.queue.put(name,info,data);
      a = "Ack";
    }
    else if (a.endsWith("Recv")) {
      Message msg = new Message(name,info,data);
      M.macro.queue.put(msg,M.macro.queue,M.macro);
      int to = t.getL("TIMEOUT",10)*100;
      Object datain = msg.data;
      while (to>0 && msg.data==datain) { Time.usleep(10000); to--; }
      a = "Ret"; 
      if (to==0) data = "TimedOut";
      s = "{NAME="+msg.name+",INFO="+msg.info+",DATA="+msg.data+"}";
    }
    else {
      a = a.substring(9);
      s = "UnknownMessageAction";
    }
    hp.setContentType("text/plain");
    hp.open();
    hp.write("/Message/"+a+"?"+s);
    hp.close();
  }

}
