startmacro s:mtype[BPSK]  d:fsym[21] s:fec[V27] s:scr[v35] l:nfgain[-20]

! adjust A2D rate to cover 
if fsym lt 35
  set fs 50
else
  set fs 100
endif
set fshz fs*1e6
set fsymhz fsym*1e6

! create snapapp configuration table
table cfg create	
set cfg.snapset {FORMAT=CI,RATE=^fs,CLOCK=PX,LENGTH=1,DEC=1,FREQ=0,GAIN=0,FRAME=512,NFFT=2K,PSDR=25,PSDA=5,WAVE=NONE,FLAGS=PMFPGA=iqt,MBITS=-16}

! general cases
set cfg.case_mod {CARD=PIC2AUTO,PORT=PM0CORE1,WAVE=SIN,FREQ=.001,GAIN=-3,DEC=32,SWITCHES=PLAY/GC={RFGAIN=20,RFFREQ=1000}/NFGC=^nfgain}
set cfg.case_dem {CARD=PIC1AUTO,PORT=PM1CORE1,DEC=32,SWITCHES=GC={RFGAIN=12,RFFREQ=1000}}
set cfg.case_dbg {CARD=PIC1AUTO,PORT=PM2CORE1,DEC=2,SWITCHES=XYP/GC={RFGAIN=12,RFFREQ=1000}}

! core specific case additions
set cfg.case_mod_x {CASE=MOD,AFLAGS=CORE=(NAME=MOD,  S:RFP=ICE,S:MOD=^mtype,S:FEC=^fec,S:SCR=^scr,D:FS=^fshz,D:FSYM=^fsymhz,S:FMT=VSOFT,L:FRAME=960)}
set cfg.case_dem_x {CASE=DEM,AFLAGS=CORE=(NAME=IQ;IQ,S:RFP=ICE,S:MOD=^mtype,S:FEC=^fec,S:SCR=^scr,D:FS=^fshz,D:FSYM=^fsymhz,S:FMT=VSOFT,L:FRAME=960)}
set cfg.case_dbg_x {CASE=DBG,AFLAGS=CORE=(NAME=IQ;IQ,S:RFP=ICE,S:MOD=^mtype,S:FEC=^fec,S:SCR=^scr,D:FS=^fshz,D:FSYM=^fsymhz,S:FMT=RAWIQ,L:FRAME=960)}

! special exceptions
if fec eqss "TCM" or fec eqs "NONE" then
  sedit cfg.case_mod_x.AFLAGS cfg.case_mod_x.AFLAGS subs "VSOFT" "HARD"
  sedit cfg.case_dem_x.AFLAGS cfg.case_dem_x.AFLAGS subs "VSOFT" "HARD"
endif

! verify table contents
if /v then	
  res/all cfg
endif

! call snapapp with 1 cfg table and 3 cases with auto start
snapapp cfg mod_x dem_x dbg_x /action=mon

endmacro
