!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This macro controls a SNAPAPP server via ICENET to implement a simple recorder GUI
!
startmacro s:remote

! set default config
switch "DISPLAY" display get "FRONT" 
switch "THEME" theme get "GEAR3" 
switch "TBL" cfg get "snapapp" 
switch "OPT" opt get "ice" 
switch "PORT" port get 7000
switch "CSW" cswitches get "" 

if ";" subs cfg then 			! support /tbl=table;opt syntax
  sedit cfg opt trim ";"
  sedit cfg cfg trim ,, ";" 
  set cfgn "nxm.^{opt}.tbl.^{cfg}.tbl"
else
  if ".tbl" nsubs cfg then set cfg "^{cfg}.tbl"
  find cfg cfgn ! look for it in standard aux path
  if cfgn eqs "" then set cfgn "nxm.^{opt}.tbl.^{cfg}"
endif
set t:cfg cfgn
set fname "archive"
set plist "_CB|_CBF"

pipe on
  panel/controls=gc/setup/theme=^theme/display=^display/logger
!  set reg.panel.eventfilter "NOMOVE"
  gcontrol button "DO"     "" "Act,Msg,Cfg" /toff
  gcontrol button "MODE"   "" "[],||,>" "[]" /toff
  gcontrol file   "AFNAME" "File" fname ,, aux.write
  gcontrol tval   "TIME"   "Time" 0 1 -1 1  
  gcontrol lval   "ADLM"   "" -48 -48 10 1 /vumeter
  gcontrol tval   "ATCT"   "Top " 0 0 -1 1  
  gcontrol tval   "ATCL"   "Len " 0 0 -1 1  /slider /maximum
  gcontrol lval   "MGAIN"  "Gain" 0 -100 100 1  /slider 
  gcontrol dval   "RFFREQ" "Freq" 0 0 10000 1 /fmt="#0.000" /units="MHz" 
  gcontrol choice "PLOT"   "Plot" "None,RT-Spectra,TD-Line,TD-Raster,FD-Line,FD-Raster,Specs" "None" /CS
  icermif/id=rmif/prange=5 port ,, {ID=ICESRV,HP=^remote} q:ack|^plist
  plot axis=frame type=line options=+bstore
  set this.timer(0) 1
pipe off

endmacro

procedure open
return

procedure close
return

procedure processMessage

if msg.name eqs "TIMER" and msg.info eq 0 then
  if reg.icesrv rexists and reg.icesrv.status eqs "OPENED" then
    set t:tbl {AFNAME=?,TIME=?,ATCT=?,ATCL=?,MGAIN=?}
    if "ADLM" subs cswitches then set tbl.ADLM "?"
    if "RCVR" subs cswitches then set tbl.RFFREQ "?"
    sendto "ICESRV" "GET" tbl
  endif

elseif msg.fid eqs "ICESRV" then          ! handle server/client messaging 
  if msg.name eqs "RET" then
!    res msg.data
    foreach item intable msg.data
      if gc.^item rexists	! control
        set gc.^{item}.v msg.data.^item
      else			! result
        set ^item msg.data.^item
      endif
    endfor
  elseif msg.name eqs "ACK" then
  endif

elseif msg.fid eqs "RMIF" then          ! handle server/client messaging
  if msg.name eqs "OPEN"
    info "Got open ^msg.data from ^msg.fid"
  elseif msg.name eqs "OPENED"
    info "Got opened ^msg.data from ^msg.fid"
    sendto "ICESRV" "GET" {cswitches=?}
    set gc.PLOT.action "RT-SPECTRA"
!    pause 0.5  ! make sure plots are up
!    set gc.COMP.action "PLOT"
  elseif msg.name eqs "CLOSE"
    info "Got close ^msg.data from ^msg.fid"
  elseif msg.name eqs "CLOSED"
    info "Got closed ^msg.data from ^msg.fid"
  endif

elseif msg.name eqs "MODE" then
  if msg.data eqs ">" then
    sendto "ICESRV" "SET" {MODE=RTMEMORY}
  elseif msg.data eqs "[]" then
    sendto "ICESRV" "SET" {MODE=SETUP}
  elseif msg.data eqs "||" then
    sendto "ICESRV" "SET" {MODE=SETUP}
  endif

elseif msg.name eqs "DO" then
  if msg.data eqs "ACT" then
    gc/temp menu "ACTION" "Action" "Setup,Monitor,Record,Playback,DeArchive,OneShot,Archive,&
    OneShotArch,OneRtArch,PowerOff,DmacX,Status,Exit"
  elseif msg.data eqs "MSG" then
    set reg.panel.toggleborders 0x8
  elseif msg.data eqs "CFG" then
    set reg.panel.toggleborders 0x1
  endif

elseif msg.name eqs "ACTION" then
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "CONFIG" then
  endif

elseif msg.name eqs "AFNAME" then
  sendto "ICESRV" "SET" {AFNAME="^msg.data"}

elseif msg.name eqs "MGAIN" then
  sendto "ICESRV" "SET" {MGAIN=^msg.data}

elseif msg.name eqs "PLOT" then
  set reg.panel.panes.plot.title gc.PLOT.v
  call doPlot 

elseif msg.name eqs "FILE" then
  set fname gc.FILE.v

endif
return

procedure doPlot
set ptype gc.PLOT.v
set plotfile "snaplet_plot"
if ptype eqs "RT-Spectra" then
  set plotfile "_cbf"
elseif fname nfexists then
  warn "File ^fname not found"
elseif ptype eqs "FD-Line" then
  spectra fname(0:64k) plotfile 
elseif ptype eqs "FD-Raster" then
  fft/psd fname(0:1m) plotfile 
endif
sendto "PLOT" "OPENFILE" ^plotfile info=-1
return
