!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This macro coordinates a collection of SNAPPER/TAPPER/PACKER/SENSOR macros defined through 
! a table file. By default each of these macros is executed in a graphical subpanel
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main

global hwalias

! set default config file
switch "TBL" cfg get "icebox" 
switch "OPT" opt get "ice" 
if ";" subs cfg then 			! support /tbl=table;opt syntax
  sedit cfg opt trim ";"
  sedit cfg cfg trim ,, ";" 
  set cfgn "nxm.^{opt}.tbl.^{cfg}.tbl"
else
  if ".tbl" nsubs cfg then set cfg "^{cfg}.tbl"
  find cfg cfgn ! look for it in standard aux path
  if cfgn eqs "" then set cfgn "nxm.^{opt}.tbl.^{cfg}"
endif

! save original command line args for later substitution of scene args
sedit this.args.getraw rawargs "TRIM" "" ",," 
set l:iarg 1
set l:nargs this.args.size
if nargs ge 1
  set appn this.args.geto(^iarg)
  if appn instanceof "nxm.sys.lib.Table" or ".TBL" subs appn then set l:iarg 2
endif
set sarg this.args.getcs(^iarg)
if sarg eqs "" then 
  sedit rawargs rawargs "APPEND" ",sceneargs"
else
  sedit rawargs rawargs "GSUBS" " " "," "SUBS" ",^sarg" ",sceneargs"
endif

iceutil "TPP" cfgn "CFG"

! setup HTTPS mode
if cfg.server_defaults.https rexists then 
  invoke nxm.ice.net.HServer.setHTTPS(^cfg.server_defaults.https)
endif

switch "VERBOSE" verbose get 0 1
switch "DISPLAY" display get "FRONT" 
switch "USE"    t:usetbl get {}
switch "TEST"  test get 0 1
switch "SCRIPT" script get "NONE" 
switch "MAXDUR" l:maxdur get -1
set lastAct "STOP"

! status logger
switch "MLOG" s:logfn get "OFF" logfn
switch "MCFL" l:mcfl get 1M 1M
if logfn neqs "OFF" then report on logfn{CFL=^mcfl}

! get specified table file
set l:show 3
set l:config 0
set l:appoff 1
set l:defshow 1
set l:modcntrls 3
set l:nargs this.args.size
if nargs ge 1 then
  set appn this.args.geto(1)
else
  set appn "NONE"
endif
if appn instanceof "nxm.sys.lib.Table" then
  set t:cfg appn
  set l:appoff 2
elseif appn ends ".TBL" then
  iceutil "TPP" appn "CFG"
  set l:appoff 2
endif
if cfg ninstanceof "nxm.sys.lib.Table" then
  error "Opening configuration table"
  stop
endif

! prepare default snapper table
table snapdef create {port=MODULE1,format=SB,rate=10,clock=N,length=1.0,dec=32,&
        freq=1,gain=0,mgain=0,nfft=1024,psdr=25,psda=5,dspr=5,expa=0,frame=512,wave=none,afname="archive"}
table snapdef merge snapdef cfg.snapset

! remove controls table until nxm320i table fix
if snapdef.controls rexists then
  set snapdef_controls snapdef.controls
  rem snapdef.controls
endif

! prepare configuration table
set apps "NONE"
if cfg.public rexists then	! specified cases listed in table
  res apps "^apps,^cfg.public"
else
 foreach key intable cfg	! build list from all cases
  if key neqss "CASE_" continue
  sedit key key trim "CASE_"
  if cfg.private rexists and ",^key," subs ",^cfg.private," continue
  res apps "^apps,^key"
 endfor
endif

! look for the APPLIST entry
set scenario "NONE"
if cfg.applist rexists then
  set scenarios "None,^cfg.applist.getlist"
  if /menu then
    gcontrol menu ans "Scenarios" "^scenarios,<Cancel>"
    if ans nrexists or ans eqs "<CANCEL>" stop
    call setscene ans
  elseif appoff le nargs then
    set appn this.args.geto(appoff)
    if cfg.applist.^appn rexists then call setscene appn
  endif
else
  set scenarios "NULL"
  if /menu then error "No APPLIST entry in config table for MENU"
endif

! set global controls modes
if cfg.defshow rexists set defshow cfg.defshow
if cfg.modcntrls rexists set modcntrls cfg.modcntrls

! parse switches after scene activation
switch "NORESET" noreset get 0 1
switch "SERVICE" server get 0 9000
switch "SHOW" defshow get defshow
if /noshow then set defshow 0
switch "FILE" t:cct get "NULL"
switch "CCT" t:cct get cct
if /server gt 0 then
  warning "The /SERVER switch on SNAPAPP has been replaced by the /SERVICE switch to allow proper nesting. Please replace."
  switch "SERVER" server get 0 9000
endif

! parse command line and calculate number of windows
set l:config 0
set app1 "None"
do ii appoff this.args.size
  set appn this.args.geto(ii)
  if appn neqs "THIS.ARGS.GETO(II)" then
    set l:config config+1
    set app^config appn
  endif
enddo

if config le 0 set l:config 1
switch "NW" l:config get config
switch "FILL" s:fill get "LRTB"
switch "PS" s:ps get "NONE"
switch "BATCH" l:batch get 0 config
switch "AUTOEXIT" l:autoexit get batch config
switch "AUTOSTOP" l:autostop get autoexit config
if cfg.actions nrexists set cfg.actions "Monitor,Rec/PB,Stop,Cntrls,More,Scene,Exit"
switch "ACTIONS" actions get cfg.actions
if actions eqss "CFG." then set actions ^actions

! calculate layout of windows
set l:ny 1
if config gt 3 set l:ny 2
set l:nx (config+ny-1)/ny
calc l:nc cfg.getsize 8 / round 5 min 1 max

pipe on
  set l:timeout -1
  if server gt 0 icermif/id=rmif/http/partners=config server "q:ack"
  call setLayout
  if ps neqs "NONE" then
    panel/controls=gc/setup=^ps/display=^display
  else
    panel/controls=gc/setup/grid=tgrid/display=^display
  endif
  set reg.panel.eventfilter "NOMOVE"
  gcontrol button "ACTION" "Action" "Config,Scene,Exit" /input /toff
  gcontrol label  "CONFIG"   "Config" "Open"
  gcontrol choice "SCENARIO" "Scenario " scenarios scenario
  gcontrol choice "NAPP"     "Windows  " "1,2,3,4,6,8,10,12,16" "^config" /nc=3
  do nn 1 config
    gcontrol choice "CASE_^nn" "App^nn" apps /nc=nc
  enddo
  gcontrol label  "APPLAB"   "Application" "Closed"
  gcontrol tval   "GTIME"    "TC" 0 1 -1 1 /noedit
  gcontrol tval   "GSYNC"    "Sync" 0 1 -1 1 /nomsg
  gcontrol tval   "MAXDUR"   "Duration" maxdur 1 -1 1 /nomsg
  if cfg.appcontrols rexists
    set gc.APPLAB.action "OPEN"
    foreach entry intable cfg.appcontrols
      sedit/ob cfg.appcontrols.^entry line range 2 -1
      if "^" subs line then iceutil "CARETS" line line
      run line
    endfor
  else
    gcontrol prompt "COMMAND"  "Run:" " " 20 
  endif
  gcontrol label  "LABEL_0"   "Global Controls" "Open"
  set gc.action.itemcolors {MONITOR=darkgreen,REC/PB=darkred,STOP=gray}
  if scenario neqs "NONE" then set gc.CONFIG.action "CLOSED"
pipe off

if logfn neqs "OFF" then report off

endmacro

procedure open
call doConfig 
set this.timers 2
set this.timer(0) 1
set this.timer(1) 0.2
return

procedure close
call undoConfig
return

procedure processMessage

if msg.name eqs "TIMER" then
  if msg.info eq 1
    if reg.snap1 rexists and reg.snap1.controls.time rexists and reg.snap1.controls.mode.v neqs "Setup" then
      calc time reg.snap1.controls.time.v round
    else
      timex now round=1 time
    endif
    if time neq gc.GTIME.v then set gc.GTIME.action time
    return
  endif
  if gc.ACTION.v neqs "STOP" and autostop gt 0 then
    res count 0
    do nn 1 autostop
      if reg.snap^nn rexists then res count count+1
    enddo
    if count eq 0 then 
      set gc.ACTION.v "STOP"
      if autoexit gt 0 call setAction "EXITNOW"
    endif
  endif
  if "ONE" subs gc.ACTION.v then
    res count 0
    do nn 1 config
      set rsnap reg.snap^nn
      if rsnap rexists and rsnap.res.onestate eqs "FINISHED" then res count count+1
    enddo
    if count ge config then 
      set gc.ACTION.action "Stop"
      if autoexit gt 0 call setAction "EXITNOW"
    endif
  endif
  if /autocheck and reg.snap1.res.gc.MODE.v eqss "RT" then
    if reg.snap1.reg.sp.cycle gt 0 sendto "MAIN" "MORE" "CHECKDATAAPP1V2"
  endif
  if timeout ge 0 then
    if timeout eq 0 then call setAction "EXITNOW"
    set l:timeout timeout-1
  endif
  if maxdur gt 0 and gc.ACTION.v neqs "STOP" then
    timer elapse dur
    if dur gt maxdur then
      set gc.ACTION.action "STOP"
      if autoexit gt 0 call setAction "EXITNOW"
    endif
  endif
  call updateControls -1

elseif msg.fid eqs "SBAR" then
  if cfg.sbarhandler rexists then
    sedit/ob cfg.sbarhandler line range 2 -1
    run line
  endif

elseif msg.name eqs "INFO" then
  info msg.data

elseif msg.name eqs "SCENARIO" then
  if cfg.applist.^msg.data eqs "LABEL" then return
  call setAction "STOP"
  call undoConfig
  call setScene msg.data
  sendto/sync panel "LOADSETUPTABLE" {L1=^tgrid}
  call doConfig

elseif msg.name eqs "NAPP" then
  if ^msg.data eq config return
  call setAction "STOP"
  call undoConfig
  set l:config ^msg.data
  call setLayout
  sendto/sync panel "LOADSETUPTABLE" {L1=^tgrid}
  call doConfig

elseif msg.name eqss "CASE_" then
  call setAction "STOP"
  sedit msg.name l:nn trim "_"
  call stopSnapper nn
  call formSnapper nn msg.data
  call runSnapper nn

elseif "_" subs msg.name then
  sedit msg.name l:nn trim "_"
  sedit msg.name name trim ,, "_"
  if nn eq 0 then
    do nn 1 ng
      if name eqs "AFNAME" and config gt 1 then
        set reg.snap^{nn}.res.gc.^{name}.action "^{msg.data}_^{nn}"
      elseif reg.snap^{nn}.res.gc.^{name} rexists
        set reg.snap^{nn}.res.gc.^{name}.action msg.data
        if name eqs "DEC" then call setDec msg.name 1
      endif
    enddo
  elseif reg.snap^{nn}.res.gc.^{name} rexists
    set reg.snap^{nn}.res.gc.^{name}.action msg.data
    if name eqs "DEC" then call setDec msg.name nn
  endif

elseif msg.name eqs "COMMAND" then
  if msg.data eqss "(" then
    sedit msg.data cmd trim "(" ")"
  else
    set cmd msg.data
  endif
  run ^cmd

elseif msg.name eqs "ACTION" or msg.name eqs "MORE" then
  if msg.data eqs "EXIT" and /noexitmenu and msg.quals.actionType eq 0 then
    warn "Exit button has been disabled - use launch window"

  elseif msg.data eqs "EXITSERVICE" then
    sendto "REMOTE" "SET" {MODE=CLOSE}

  elseif msg.data eqs "ALLCONTROLS"
    call setShow 3

  elseif msg.data eqs "CHECKDATAAPP1V2" 
    timex now time
    if config neq 2 or reg.snap1 nrexists or reg.snap2 nrexists then
      warn "App1 & App2 must be run to apply file equality check"
    elseif reg.snap1.res.ramfile2 rexists then
      icediff reg.snap1.res.ramfile1{fs=0} reg.snap2.res.ramfile1{fs=0}
      icediff reg.snap1.res.ramfile2{fs=0} reg.snap2.res.ramfile2{fs=0}
    else
      icediff reg.snap1.res.ramfile{fs=0} reg.snap2.res.ramfile{fs=0}
    endif

  elseif msg.data eqs "CHECKDATAPORT1V2" 
    timex now time
    do nn 1 config
      if reg.snap^{nn} rexists and reg.snap^{nn}.res.ramfile2 rexists then
        icediff reg.snap^{nn}.res.ramfile1{fs=0} reg.snap^{nn}.res.ramfile2{fs=0}
      else
        warn "App^nn must be run in /DUAL mode to apply file equality check"
      endif
    enddo

  elseif msg.data eqs "OneShotTFDoA" 
    call setAction "ONESHOT"
    pause 1
    while reg.snap1.res.gc.MODE.v neqs "SETUP"
      pause .1
    endwhile
    set tfreq -1
    if snapset1.port eqss "T" set tfreq ^reg.snap2.res.gc.FREQ.v*1e6
    icetfdoa ^reg.snap1.res.ramfile ^reg.snap2.res.ramfile  ,,, .1 tfreq

  elseif msg.data eqs "TFDoApp1V2" 
    if config neq 2 or reg.snap1 nrexists or reg.snap2 nrexists then
      warn "App1 & App2 must be running to apply TFDOA check"
    else
      if reg.snap1.res.gc.MODE.v eqss "RTMEM" then
        erase/warn=no reg.snap1.res.gc.AFNAME.v reg.snap2.res.gc.AFNAME.v
        say "Snapshot to ^reg.snap1.res.gc.AFNAME.v and ^reg.snap2.res.gc.AFNAME.v"
        set atfn "^{reg.snap1.res.gc.AFNAME.v}{AUX=^reg.snap1.res.aux0}"
        invoke reg.snap1.reg.sp.startArchiver(^atfn) 
        pause 0.5
        set atfn "^{reg.snap2.res.gc.AFNAME.v}{AUX=^reg.snap2.res.aux0}"
        invoke reg.snap2.reg.sp.startArchiver(^atfn) 
        pause 2.0
        invoke reg.snap1.reg.sp.stopArchiver() 
        invoke reg.snap2.reg.sp.stopArchiver() 
      endif
      icetfdoa ^reg.snap1.res.gc.AFNAME.v ^reg.snap2.res.gc.AFNAME.v ,,,1, ^reg.snap2.res.gc.FREQ.v*1e6
    endif

  elseif msg.data eqs "STATUS"
    pic status ^reg.snap1.res.gc.card.v

  elseif msg.data eqs "DMACX"
    pic dmacx ^reg.snap1.res.gc.card.v

  else
    if msg.data eqss "MON" and lastAct neqs "STOP" then
      call setAction "STOP"
      pause 1
    endif
    call setAction msg.data
    set lastAct msg.data
  endif

elseif msg.name eqs "EXITCHK" then
  if msg.data neqss "N" pipe stop

elseif msg.name eqs "GET" then          ! server side
  set t:sets msg.data
  foreach key intable sets
    set sets.^key gc.^{key}.value
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "SET" then          ! server side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.action "^sets.^key"
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "OPEN" then          ! server side

elseif msg.name eqs "CLOSE" then         ! server side

elseif cfg.apphandlers.^{msg.name} rexists then 
  res handler cfg.apphandlers.^{msg.name}
  foreach entry intable handler
    sedit/ob handler.^entry line range 2 -1
    if "^" subs line then iceutil "CARETS" line line
    run line
  endfor

elseif cfg.apphandler rexists then 
  sedit/ob cfg.apphandler line range 2 -1
  run line

elseif msg.name eqs "GTIME" then

else
  say "Unexpected message: ^msg : ^msg.data"
endif
return

procedure setAction s:action
if action eqss "EXIT"
  set narch 0
  do nn 1 config
    if reg.snap^nn rexists and reg.snap^{nn}.res.gc.mode.v eqss "RTARCH" then set narch narch+1
  enddo
  if narch gt 0 and msg.quals.actionType eq 0 and action neqs "EXITNOW" then
    gc/temp/msg=y/tleft menu "EXITCHK" "Archive in progress. Are you sure?" "Yes,No" "No"
  else
    pipe stop
  endif
elseif action eqs "NULL"
elseif action eqs "NONE"
elseif action eqss "MORE"
 if msg.quals.actionType eq 0 
  gc/temp/nc=1 menu "MORE" "Action" "Setup,Monitor,Record,Playback,DeArchive,DeArchPlay,OneShot,Archive,&
    OneShotArch,OneRtArch,CheckDataApp1v2,CheckDataPort1v2,OneShotTFDoA,TFDoApp1v2,AllControls,DmacX,Status,ExitService,ExitNow"
 endif
elseif action eqss "SCENE"
 if msg.quals.actionType eq 0 
  gc/temp menu "SCENARIO" "Scenario" scenarios
 endif
elseif action eqs "CONFIG" 
  set gc.CONFIG.v "OPEN"
  call setShow 1
elseif action eqs "CNTRLS" 
  call setShow calc(show+1,modcntrls,mod)
elseif reg.snap1 nrexists then 
  if action neqs "STOP" gc/temp/msg=n alert ,,, "At least App1 must be configured first"
elseif action eqss "DEARCH"
  do nn 1 config
    set reg.snap^{nn}.res.gc.mode.action "DEARCHIVE"
    while reg.snap^{nn}.res.gc.mode.v neqs "Setup"
      say "Waiting on Snapper #^nn dearchive"
      pause .25
    endwhile
  enddo
  set gc.ACTION.v "Stop"
  if action eqs "DEARCHPLAY" set gc.ACTION.act "MON"
else
  switch "SYNCONSEC" sos get -1 1
  if config eq 1 and sos lt 0	! single snapper 
    message send snap1 ,, "ACTION" 0 action	
    message sync snap1
  else			! multi mode startup - special sequencing
    switch "ORDER" order get 
    do nn 1 config
      if reg.snap^nn nrexists continue
      if action eqss "STOP" then
	message send snap^nn ,, "ACTION" 0 action ! stop 
      else
	message send snap^nn ,, "ACTION" -1 action ! setup, no start master/slave
        message sync snap^nn	! wait till setup but not for stop's archive flush
      endif
    enddo
    if sos gt 0 and action neqs "STOP" then
      set sos gc.GSYNC.v
      timex now ftmp
      if sos gt 1 and ftmp lt sos
	timex sos soso
        say "Waiting on sync=^soso at ^ftmp"
        while ftmp lt sos-1.5
          pause 0.2
          timex now ftmp
	endwhile
      endif
      timex now fsec=ftmp
      say "Waiting on 1 PPS at ^ftmp"
      while ftmp lt 0.025 or ftmp gt 0.1
        pause 0.025
        timex now fsec=ftmp
      endwhile
      say "Waiting on 1 PPS done at ^ftmp"
    endif
    do ii 0 config-1 
      set l:nn config-ii  ! default to start backwards
      if order nisnull then set l:nn order(ii)
      if reg.snap^nn nrexists continue
      if action eqs "STOP" continue
      message send snap^nn ,, "ACTION" 0 "START"	! now start master/slave 
      if /nosync isfalse and sos lt 0 then message sync snap^nn	! wait till running
    enddo
  endif
  if "ONE" subs action
    do nn 1 config
      set reg.snap^{nn}.res.onestate "STARTED"
    enddo
  endif
  timer set
  set maxdur gc.MAXDUR.v
  switch "TIMEOUT" l:timeout get -1
  if action eqss "MON"
    set gc.action.itemcolors {MONITOR=green,REC/PB=darkred,STOP=darkgray}
  elseif action eqss "REC"
    set gc.action.itemcolors {MONITOR=darkgreen,REC/PB=red,STOP=darkgray}
  elseif action eqss "STOP"
    set gc.action.itemcolors {MONITOR=darkgreen,REC/PB=darkred,STOP=gray}
  endif
endif
return

procedure doConfig
if config le 0 return
env gc
switch "SB" s:sb get "None"
if sb eqs "LIST" then
  view/bg/id=sbar/msgid=main
elseif sb eqs "PLOT" then
  plot/bg/id=sbar/msgid=main
endif
switch "NG" l:ng get config
if /nopic isfalse then
  picd/stat=npic "NUMDEV" 
  if npic le 0 warn "No PICs detected on this devIce. Scene=^scenario."
endif
do nn 1 config
  if app^nn rexists then
    res appn app^nn
  else
    res appn "NONE"
  endif
  call formSnapper nn appn
enddo
if /autoconfig and config gt 0 then
  picd get ^snapset1.card "CONFIG" "HWALIAS_^snapset1.card"
  info "AutoConfig of ^snapset1.card = ^HWALIAS_^snapset1.card"
endif
do nn 1 config
  call runSnapper nn
enddo
pause 1
env gc
! initialize the operator controls
if app1 neqs "None" then
  do nn 1 config
    sendto snap^nn "ACTION" "STOP" /sync /wait=10
  enddo
  pause 1	! make sure controls are ready for action
  call createControls 1
  call updateControls 1
  if reg.snap1 rexists then call setShow defshow
  if /action neqs "NULL" then 
    pause 1
    set gc.ACTION.action "^/action"
  endif
endif
return

procedure undoConfig 
if config le 0 return
do nn 1 config
  call exitSnapper nn
enddo
pause 1
do nn 1 config
  call stopSnapper nn
enddo
if reg.sbar rexists sendto "SBAR" "FINISH"
call setShow 1
sendto/sync panel "PANEL.CFG" "CLEAR"
sendto/sync panel "LOADSETUP" ""
env gc
return

procedure setShow l:nshow
if nshow eq 1 or nshow eq 3 then 
  set reg.panel.borders "+Left"
else
  set reg.panel.borders "-Left"
endif
do nn 1 config
 if reg.snap^{nn}.reg.panel nrexists continue
 if "HideControls" subs reg.panel.optionsList then	! newer PANEL code
  if nshow ge 2 then
    set reg.snap^{nn}.reg.panel.options "-HideControls"
    set reg.snap^{nn}.reg.panel.borders "+Left"
  else
    set reg.snap^{nn}.reg.panel.options "+HideControls"
    set reg.snap^{nn}.reg.panel.borders "-Left"
  endif
 else							! older PANEL code
  if nshow ge 2 then
    set reg.snap^{nn}.reg.panel.borders "+Left"
  else
    set reg.snap^{nn}.reg.panel.borders "-Left"
  endif
 endif
enddo
set show nshow
return

procedure formSnapper l:nn s:appcase
timex now time
set reg.win.snap^{nn}.title "App^nn : ^appcase"
if gc.CASE_^nn rexists then
  set gc.CASE_^{nn}.v appcase
else
  gcontrol/grp="CONFIG" choice "CASE_^nn" "App^nn" apps appcase /nc=nc 
endif
rem snapset^nn
if appcase eqs "NONE" return
set casename appcase
set caselist appcase
while cfg.case_^{casename}.CASE rexists
  set casename cfg.case_^{casename}.CASE
  set caselist "^casename,^caselist"
endwhile
table controls CREATE {}
if snapdef_controls rexists then table controls MERGE controls snapdef_controls
table snapdef copy snapset^nn	! copy default table
foreach casename inlist caselist
  res t:case cfg.case_^casename	! get the case table
  if case eqs "NULL"
    say "Case ^casename not found in config file"
    return
  endif
 foreach key intable case	! loop to override config
  if key eqs "CASE" then	! copy other case
  elseif key eqs "CONTROLS" then ! copy other case
    table controls MERGE controls case.controls
  else
    set value case.^key
    if "$case" subs value then
      sedit value value subs "$case" "$CASE"
    endif
    if "$CASE" subs value and snapset^{nn}.^key nrexists then		! dont look
      if test gt 0 warn "No previous $CASE defined for key=^key=^value. Ignored."
      sedit value value subs "$CASE" ""
    elseif "$CASE-" subs value then		! remove item
      sedit value value trim "$CASE-" ""
      sedit value snapset^{nn}.^key subs "^value" ""
    elseif "$CASE+" subs value then		! add item
      sedit value value subs "$CASE+" "^snapset^{nn}.^key"
    elseif "$CASE" subs value then		! replace item
      sedit value value subs "$CASE" "^snapset^{nn}.^key"
    endif
    if "^CFG." subs value then	! only eval carets of CFG table from this context
      iceutil "CARETS" value value
    endif
    if "PPCARETS" subs value then	! only eval carets of CFG table from this context
      sedit value value "SUBS" "PPCARETS" ""
      iceutil "CARETS" value value
    endif
    set snapset^{nn}.^key value
  endif
 endfor
endfor
if /bside then
  sedit snapset^{nn}.port snapset^{nn}.port subs "1" "2"
endif
set snapcontrols^nn controls
table snapset^{nn} MERGE snapset^{nn} usetbl
if gc.LABEL_^{nn} rexists
  set gc.LABEL_^{nn}.title "App^nn : ^appcase"
else
  gcontrol label "LABEL_^nn" "App^nn : ^appcase" 
endif
return

procedure runSnapper l:nn
if snapset^nn nrexists return
set ssn snapset^nn
set flags ""
set switches ""
if ssn.flags rexists then set flags ssn.flags
if ssn.switches rexists then set switches ssn.switches
if switches neqss "/" then sedit switches switches "PREPEND" "/"
if "VERBOSE" subs switches then
  say "The VERBOSE switch is only supported on the command line of SNAPAPP.  Removed ..."
  sedit switches switches subs "VERBOSE" "XVERBOSE"
endif
sedit switches switches gsubs "/GC=" "/GCX="
if server gt 0 set switches "^switches/PARTNERS=^config/SERVER=^server+^nn"
if verbose gt 0 set switches "^switches/VERBOSE=^verbose"
if noreset gt 0 set switches "^switches/NORESET"
if batch gt 0 set switches "^switches/AUTOEXIT"
switch "AFLAGS^nn" aflags get ""
switch "ASWITCHES" aswitches get ""
call checkNoReset
if /autosync then call applyAutoSync
if test eq 1 then
  say "Case ^nn   = ^app^{nn}"
  say "Flags    = ^flags"
  say "Switches = ^switches"
  return
endif
if ssn.macro rexists
  set mname ssn.macro
else
  set mname "SNAPPER"
endif
set cname ssn.card
if mname eqs "SNAPPER" then
  snapper/bg/id=snap^nn/noexitmenu/^switches/^aswitches ^cname "^aflags" ssn
elseif mname eqs "PACKER" then
  packer/bg/id=snap^nn/noexitmenu/^switches/^aswitches ^cname "^aflags" ssn
elseif mname eqs "SENSOR" then
  sensor/bg/id=snap^nn/noexitmenu/^switches/^aswitches ^cname "^aflags" ssn
elseif mname eqs "SIGGEN" then
  siggen/bg/id=snap^nn/noexitmenu/^switches/^aswitches ^cname "^aflags" ssn
elseif mname eqs "TUNIQ" then
  tuniq/bg/id=snap^nn/noexitmenu/^switches/^aswitches ^cname ,, "^aflags" ssn
else
  ! add snapapp specific switches to case macros
  sedit ssn.macro rcmd subs "#" ^nn 
  if "$$" nsubs rcmd sedit rcmd rcmd subs "," "/$$,"
  sedit rcmd rcmd subs "$$" "id=snap^nn/noexitmenu/^switches/^aswitches"
  run/bg rcmd
endif
if nn eq 1 then
  calc l:smask 2**sedit(actions,"PARSEDINDEX","More") fix 
  calc l:smask 2**sedit(actions,"PARSEDINDEX","Cntrls") fix smask +
  set gc.ACTION.items actions
  set gc.ACTION.nostatemask smask
  set gc.ACTION.value "STOP"
endif
return

procedure exitSnapper l:nn
if reg.snap^nn rexists 
  message send snap^nn ,, "ACTION" 0 "EXIT"	
endif
return

procedure stopSnapper l:nn
if reg.snap^nn rexists 
  message send snap^nn ,, "ACTION" 0 "EXIT"	
  timer set
  while reg.snap^nn rexists 
    pause 0.25
    timer elapse toff
    if toff gt 5 break
  endwhile
endif
set gc.CASE_^{nn}.value "NONE"
if gc.LABEL_^{nn} nrexists return
! hide off old controls
set gc.LABEL_^{nn}.title "App^nn : NONE"
foreach item intable gc
  if item EQSS "LABEL" continue 
  if gc.^{item}.group eqs "LABEL_^{nn}" set gc.^{item}.show 0
endfor
return

procedure checkNoReset
if /reset then return
do ii 1 nn-1
  if snapset^{nn}.card eqs snapset^{ii}.card then
    if /quiet isfalse then
      say "Applying NORESET switch to App^nn using same card=^snapset^{ii}.card as App^ii"
    endif
    set switches "^switches/NORESET"
    break
  endif
enddo
return

procedure getSide s:gport u:gside
sedit gport side "RANGE" gport.length()-1 gport.length()-1
calc/type=l ^gside ^side 1 - 2 mod 1 +
return

procedure applyAutoSync
call getSide snapset1.port side1
call getSide snapset^{nn}.port siden
if snapset^{nn}.card eqs snapset1.card then
  do ii 2 config
    if snapset^{ii} rexists and snapset^{ii}.card neqs snapset1.card then
      if /TP then
        set aflags "TPOE|^aflags"
      else
        set aflags "XSOE|^aflags"
      endif
      break
    endif
  enddo
endif
if snapset^{nn}.card neqs snapset1.card then
  if /TP then
    set aflags "XTGO|XSTP|^aflags"
  else
    set aflags "XTGO|^aflags"
  endif
elseif siden neq side1 then
  set aflags "SGO|^aflags"
elseif nn gt 1
  set aflags "RGO|^aflags"
endif
if /quiet isfalse and aflags neqs "" then
  say "Applying ^aflags flag to App^nn to autosync Port=^snapset^{nn}.port"
endif
return

procedure setScene s:name
set scenario name
if name eqs "NONE" then
  set config 0
  call setLayout
  return
endif
set appargs cfg.applist.^name
if appargs eqss "(" sedit appargs appargs trim "(" ")"
iceutil "CARETS" appargs appargs
sedit rawargs appargs "SUBS" "sceneargs" "^appargs"
iceutil "MODARGS" appargs this.args
set l:configl config
set l:config 0
do ii appoff this.args.size
  set l:config config+1
  set app^config this.args.geto(ii)
enddo
if gc.NAPP rexists set gc.NAPP.v config
if gc.CONFIG rexists set gc.CONFIG.action "CLOSED"
info "Set SNAPAPP scene to ^name"
call setLayout
return

procedure setLayout 
set l:ny 1
if config gt 3 set l:ny 2
switch "NY" l:ny get ny
calc l:nx (config+ny-1)/ny 1 max
switch "NX" l:nx get nx
switch "NW" l:config get config
switch "FILL" s:fill get "LRTB"
if config eq 5 and ny eq 2 then
  set t:tgrid {type=grid,nx=^nx,ny=^ny,nx2=2,fill=^fill,name=snap,title=app}
else
  set t:tgrid {type=grid,nx=^nx,ny=^ny,fill=^fill,name=snap,title=app}
  if /psx pexists switch "PSX" tgrid.px get
endif
return

procedure setDec s:lname l:nn
return
pause .25
set gc.^{lname}.units reg.snap^{nn}.res.gc.DEC.units
invoke gc.^{lname}.refresh
return

procedure createControls l:dir
if cfg.common_controls rexists
  foreach key intable cfg.common_controls
    call cloneControl key cfg.common_controls.^key 0 reg.snap1.res.gc.^{key}
  endfor
endif
if cct neqs "NULL" then
  foreach key intable cct
    call cloneControl key cct.^key 0 reg.snap1.res.gc.^{key}
  endfor
endif
do ii 1 config
  set controls snapcontrols^ii
  foreach key intable controls
    call cloneControl key controls.^key ii reg.snap^{ii}.res.gc.^{key}
  endfor
enddo
return

procedure cloneControl s:key o:args l:ii o:gcw
if gcw ninstanceof "nxm.sys.libg.GWidget" return
if gc.^{key}_^{ii} rexists then
  if /retaincontrols then
    info "Leaving control key=^key as is from previous run"
  else
    set gc.^{key}_^{ii}.value gcw.value
  endif
  set gc.^{key}_^{ii}.show 1
elseif args instanceof "nxm.sys.lib.Table" then	! create from clone of SNAPPER widget
  table tmods CREATE "^args"
  if     gcw instanceof "nxm.sys.libg.GMenu" then
    gcontrol/grp=LABEL_^ii "MENU" "^{key}_^ii" "^gcw.title" gcw.items gcw.v table=tmods /flags=gcw.flags /units="^gcw.units"
  elseif gcw instanceof "nxm.sys.libg.GValue" then
    sedit "^gcw.type" vtype append "VALUE" 
    gcontrol/grp=LABEL_^ii ^vtype "^{key}_^ii" "^gcw.title" gcw.v gcw.min gcw.max gcw.delta table=tmods /flags=gcw.flags /fmt="^gcw.format" /units="^gcw.units"
  elseif gcw instanceof "nxm.sys.libg.GPrompt" and gcw.isFileChooser then
    gcontrol/grp=LABEL_^ii "FILE" "^{key}_^ii" "^gcw.title" gcw.seed gcw.filter gcw.aux table=tmods
  elseif gcw instanceof "nxm.sys.libg.GPrompt" then
    gcontrol/grp=LABEL_^ii "PROMPT" "^{key}_^ii" "^gcw.title" gcw.seed gcw.digits table=tmods /flags=gcw.flags 
  else
    warning "Unsupported widget type for cloning key=^key of type: ^gcw"
  endif
elseif args eqss "(" then	! create widget from scratch
  sedit args args TRIM "(" ")" subs "^key" "^{key}_^ii"
  run "gcontrol/grp=LABEL_^ii,^args"
else
  warning "Unsupported syntax for widget cloning: ^args"
endif
return


procedure updateControls l:dir
foreach key intable gc
  if "_" nsubs key continue			! dont poll local controls
  if gc.^{key}.show isfalse continue		! dont poll unused controls
  sedit key l:nn trim "_"
  sedit key name trim ,, "_"
  if dir lt 0 then
    if gc.^{key}.flag(8) isfalse continue	! dont poll editable controls
    if nn eq 0 then set l:nn 1			! poll common controls from snapper1
  else
    if gc.^{key}.flag(8) istrue continue	! dont set noneditable controls
  endif
  do ii 1 ng					! for /NG=n cases
    if nn neq 0 and ii neq nn continue
    if reg.snap^ii nrexists continue
    if reg.snap^{ii}.res.gc.^{name} nrexists continue	! not a mirror
    if dir gt 0
      if key eqs "AFNAME_0" and config gt 1  then		! push to snapper
        set reg.snap^{ii}.res.gc.^{name}.v "^{gc.^{key}.v}_^ii"
      else							! pull from snapper
        set reg.snap^{ii}.res.gc.^{name}.action gc.^{key}.v
        if name eqs "DEC" then call setDec DEC_^ii ii
      endif
      if gc.^{key} instanceof "nxm.sys.libg.GValue" and &
         reg.snap^{ii}.res.gc.^{name} instanceof "nxm.sys.libg.GValue" then	! update the bounds
        set reg.snap^{ii}.res.gc.^{name}.min gc.^{key}.min
        set reg.snap^{ii}.res.gc.^{name}.max gc.^{key}.max
        set reg.snap^{ii}.res.gc.^{name}.delta gc.^{key}.delta
      endif
    else
      set val reg.snap^{ii}.res.gc.^{name}.v
      if name eqs "QFREQ" then 			! special handling of QFREQ control
        ! if SNAPAPP has RF widget that is not replicated in SNAPPER, add adjustment here
        if gc.rffreq_^{ii} rexists and reg.snap^{ii}.res.gc.rffreq nrexists then set val val+gc.rffreq_^{ii}.v
      endif
      set gc.^{key}.v val
    endif
  enddo
endfor
return
