startmacro/msgid=main cs:ifn[] cs:ofn["soifile"]


pipe on
panel/setup/controls=gc/logger/poll=.25

gc label  "ACT"  "Function"
gc button "MODE" "Mode" "Refresh,ReScan,Clear,Dearchive,ScanID,Exit" /nc=2 /toff
gc file   "FILE" "FileIn" ifn "*_toc" aux.read
gc file   "ARCH" "FileOut" ofn ,, aux.read
gc dval   "PROG" "Progress" 0 0 1 0.01 /gauge /mon=reg.noop.progress

gc label  "ANAL" "Analysis"
gc tval   "TVOT" "vTm" 0 1 -1 1
gc tval   "TVOD" "vTd" 30 1 -1 1
gc tval   "SOIT" "sTs" 0 1 -1 1
gc tval   "SOID" "sTd" 0 1 -1 1
gc dval   "SOIF" "sFreq" 0 1 -1 1 /units=MHz
gc dval   "SOIW" "sBW  " 0 1 -1 1 /units=MHz
gc dval   "SOIN" "SNR  " 0 1 -1 1 /units=dB
gc dval   "THRE" "Thresh" 0 1 -1 1 /units=dB

gc label  "GEO"  "Location"
gc dval   "LAT"  "Lat " 0 -90 90 1 /units=deg
gc dval   "LON"  "Lon " 0 -180 180 1 /units=deg
gc dval   "ALT"  "Alt " 0 1 -1 1 /units=m

gc label  "NET"  "Network"
gc label  "SYS"  "System"

plot/id=wbp type=line axis=trframe
plot/id=wbr type=rast axis=brframe /all
set reg.wbp.mimic wbr
set reg.wbr.mimic wbp
plot/id=pkp/all type=rast axis=trframe

feature ,, ff {NAME=FF,TYPE=BOX,COLOR=#0080A0} wbr
feature ,, fp {NAME=FF,TYPE=HLINE,COLOR=#0080A0} pkp

set this.timers 1
set this.timer(0) 1
set findMode "IDLE"

pipe run
if ifn nfexists then
  warn "Input file ^ifn not found"
else
  set gc.FILE.action ifn
endif

pipe off

endmacro

procedure processMessage m:msg
!say "Message ^msg.name ^msg.data"

if msg.name eqs "TIMER" then
  if gc.MODE.v eqs "FIND" and findMode eqss "BEST" then
    calc acost 0.075 ! gc.COST.v ABS
    foreach/rev mod inlist modlist 
      res reg.iq_^{mod}.F:DDC_CVAR /res=cv
      res reg.iq_^{mod}.F:MMA_COST /res=cost
      calc cost cost ABS
      if cv lt gc.CVAR.v and cost lt acost and mod neqs gc.TYPE.v then
	set gc.TYPE.v mod
	set gc.CVAR.v cv
        set reg.IQ reg.iq_^mod
	set pipename "_p6_^mod"
	set reg.RT_FANIN.state "RESTART"
      endif
    endfor
  endif

elseif msg.name eqs "FILE"
  sedit msg.data ifn "TRIM" "" "_toc"
  set psdf "^{ifn}_sa"
  set pkpf "^{ifn}_sap"
  call refresh

elseif msg.name eqs "MODE"
  if msg.data eqs "REFRESH"
    call refresh
  elseif msg.data eqs "DEARCHIVE"
    noop/gpw/nopipe ifn(~^gc.SOIT.v:+~^gc.SOID.v) gc.ARCH.v
  elseif msg.data eqs "SCANID"
    noop/gpw/nopipe ifn(~^gc.SOIT.v:+~^gc.SOID.v) sigraw
    sigscan/bg sigraw
  elseif msg.data eqs "EXIT"
    pipe stop
  endif

elseif msg.name eqss "TVO"
  call refresh

elseif msg.fid eqs "WBR" then
  if psdf nfexists return
  if msg.name eqs "MARK" then
    calc l:iy msg.data.y file(sigpsd).ys - file(sigpsd).yd / round 0 max file(sigpsd).size-1 min
    noop/nopipe sigpsd(iy:+1) sigtmp
    header sigtmp fs=0
    sendto "WBP" "OPENFILE" sigtmp
  elseif msg.name eqs "DRAGBOX" and msg.info eq 101 then
    call setCutBounds msg.data 
  endif

elseif msg.fid eqs "PKP" then
  if pkpf nfexists return
  if msg.name eqs "MARK" then
    call setViewMark msg.data.y
  elseif msg.name eqs "DRAGBOX" and msg.info eq 101 then
    call setViewBounds msg.data 
  endif

elseif msg.fid eqs "LST" then
  if msg.name eqs "SELECT" then
    call selectRow msg.data.ROW -1
  endif

elseif msg.name eqs "EXIT"
  pipe stop
endif
return

procedure refresh
  calc l:iy1 gc.TVOT.v-(gc.TVOD.v/2) file(pkpf).ys - file(pkpf).yd / round 0 max file(pkpf).size-1 min
  calc l:iy2 gc.TVOT.v+(gc.TVOD.v/2) file(pkpf).ys - file(pkpf).yd / round 0 max file(pkpf).size-1 min
  noop psdf(iy1:iy2) sigpsd
  noop sigpsd(1:2) sigtmp
  header sigtmp fs=0
  sendto "WBP" "OPENFILE" sigtmp
  sendto "WBR" "OPENFILE" sigpsd
  sendto "PKP" "OPENFILE" pkpf
  set fp.y gc.TVOT.v fp.dy gc.TVOD.v
return

procedure setCutBounds o:box
calc gc.SOIT.v box.tmin 
calc gc.SOID.v box.tmax-box.tmin
calc gc.SOIW.v box.xmax-box.xmin abs 1e-6 *
calc gc.SOIF.v box.xmax+box.xmin 2 / 1e-6 * 
set ff.x (box.xmax+box.xmin)/2 ff.y (box.ymax+box.ymin)/2 ff.dx (box.xmax-box.xmin) ff.dy (box.ymax-box.ymin)
return

procedure setViewBounds o:box
calc gc.TVOT.v box.tmin 
calc gc.TVOD.v box.tmax-box.tmin
set fp.y box.ymin fp.dy (box.ymax-box.ymin)
call refresh
return

procedure setViewMark d:top
calc gc.TVOT.v top
call refresh
return

