!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  PIC - Utility macro for ICE-PIC DSP cards
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:function u:p1 u:p2 u:p3 u:p4 u:p5 u:p6 u:p7 u:p8

global/readall 

if nxm.ice.prim.iceutil.class nfexists
  import/warn=n nmroot nmroot
  if nmroot rexists then
    warn "ICE toolkit not build yet. Not executing 'PIC ^function' command yet"
    stop
  endif
endif

if env.ramaux rexists then
  res ramqual "{CTG=1,AUX=^{ENV.RAMAUX},DET=1}"
else
  res ramqual ""
endif

if function eqs "AUX" then

  iceutil grep "InvalidTimeLine" nxm.sys.exp.environment.exp ioo
  if ioo nisnull env set "IOOPTIONS" "+SuppressInvalidTimeLineEntryErrors"

  if env.ramaux nrexists env set ramaux aux.write
  if p1 eqs "PIC"  ask s:p1 "Ram Aux [^env.ramaux]: "
  if p1 neqs env.ramaux env set ramaux p1

  if env.osname eqs "Linux" and "/proc/driver/icepic" fexists then
    set t:pdit {}
    foreach line intf "/proc/driver/icepic"
      sedit line key trim "" ":" strim subs "#" "_"
      sedit line val trim ":" "" strim
      set pdit.^key val
    endfor
    foreach id intable aux
      set picaux aux.^id
      sedit picaux picaux subs ",ram" ",RAM" subs ",auto" ",AUTO"
      if ",AUTO" nsubs picaux continue
      sedit picaux index trim "RAM" ","
      if index eqs "" then	! default entry
        sedit pdit.ramstart rstart trim "" "Mby" strim
        sedit pdit.ramdisk rdisk trim "" "Mby" strim
      else			! by index
        sedit pdit.node_^index rstart trim "RS=" " "
        sedit pdit.node_^index rdisk  trim "RD=" " "
      endif
      sedit picaux picaux subs "AUTO" "^{rstart}M,^{rdisk}M,"
      set s:aux.^id picaux
      if /quiet isfalse then info "Auto config of RAM aux:^id = ^picaux"
    endfor
  endif

  fname afn home iceauto tbl aux
  if "HWALIAS" nrexists and afn fexists then set/global T:HWALIAS ^afn

  ! fixup resource handlers
  set reg.handlers.packet.ice "nxm.ice.lib.ICEPacket"
  set reg.handlers.packet.vrt "nxm.ice.lib.VRTPacket"
  set reg.handlers.resource.ifs "nxm.ice.lib.IceBlockResource"

elseif function eqs "DIR" then
  files/h ,,, env.ramaux

elseif function eqs "CLEAN" then
  if p1 eqs "PIC" set p1 env.ramaux
  if /batch istrue then
    files/e ,,, p1
  elseif p1 eqs "DATA"
    sedit aux.read list "GSUB" "|DAT" "" "GSUB" "|" ","
    foreach name inlist list
      files ,, tmp name
    endfor
    if /e isfalse warn "Use FILE SAVE <name> to save an entry, rerun with /E to actually erase this list"
  else
    files/h ,, tmp p1
    if p1 eqs env.ramaux then
      ask answer "Erase ICERAM files: All/Some/[None]? "
    else
      ask answer "Erase AUX=^p1 files: Some/[None]? "
    endif
    if answer eqss "A" then
      files/e ,,, p1
      if p1 eqs env.ramaux files/e ,, det p1 ! also erase orphaned detached files
    elseif answer eqss "S" then
      files/f ,,, p1
      foreach name infile files
        ask answer "Erase FILE=^name Y/[N]? "
        if answer eqss "Y" erase name
      endfor
      erase files
    endif
  endif

elseif function eqs "COPY" then
  noop ^p1 ^{p2}^ramqual

elseif function eqs "SNAP" then
  snapper ^p1,^p2

elseif function eqs "APP" then
  if p1 eqs "PIC" then
    snapapp ,,
  elseif p1 neqs "" and p2 eqs "" then
    snapapp/batch ,, ^p1
  else
    snapapp ,, ^p1,^p2
  endif

elseif function eqs "APPS" then
  res t:apps nxm.ice.tbl.snapapp.tbl
  if p1 eqs "PIC" then
    foreach key intable apps
      if key neqss "CASE_" continue
      sedit key name "TRIM" "CASE_"
      say "App=^name Card=^apps.^{key}.card"
    endfor
  else
    res apps.case_^p1
  endif

elseif function eqs "EDIT" then
  if p1 eqss "APPS"
    edit snapapp.tbl tbl ice
  elseif p1 eqss "LIB"
    edit icelib.c lib ice
  elseif p1 eqss "HWF"
    edit hwconfig.key dat ice
    hw cfg
  else
    warn "Unrecognized edit target: ^p1"
  endif

elseif function eqs "CREATE" then
  set p1 this.args.getCS("P1")  ! re-get this case sensitive

  if p1 eqs "PIC" 
    ask q:p1 "Filename [RAMFILE]: "
    if p2 eqs "" ask u:p2 "Format [CI]: "
    if p3 eqs "" ask u:p3 "Samples [16M]: "
    if p4 eqs "" ask u:p4 "SampleRate [10e6]: "
    if p5 eqs "" ask u:p5 "Shape (SIN,RAMP,NOTCH,...) [NONE]: "
    if p5 neqs "NONE" then
      if p6 eqs "" ask u:p6 "Gain (dB) [0]: "
      if p7 eqs "" ask u:p7 "Freq (Hz) [0]: "
      if p8 eqs "" ask u:p8 "Baud (Hz) [1e6]: "
    endif
  endif
  invoke bpa nxm.sys.lib.Data.getBPA(p2)
  if bpa le 0 calc bpa -bpa/8
  if /power2 then
    calc samp ^p3 power2
  elseif /round gt 0 and /exact le 0
    calc samp ^p3 bpa * /round / round 1 max /round * bpa /
  else
    res samp ^p3
  endif

  if p5 eqs "" or p5 eqs "NONE" then
    picd create ^p1 ^p2 samp ^p4
  elseif p5 eqs "BITS"
    waveform testbits ^p2 samp RAMP 0 256+3 0 0 1/^p4
    header testbits f=sp
    reformat testbits ^{p1}^ramqual si
  else
    if p7 eqs "" res p7 "^p4/128"
    icewave/wrap ^{p1}^ramqual shape=p5 form=p2 elem=samp rate=^p4 gain=^p6 freq=^p7 baud=^p8
  endif

elseif function eqs "COPY" then
  noop ^p1 ^{p2}^{ramqual}

elseif function eqss "EXP" then
  explain pic

elseif function eqs "HELP" then
  if p1 eqs "PIC" res p1 "MAINHELP"
  run help ^p1,ice

elseif function eqs "HOME" then
  fname icefat fat ,,, ice
  homepath icefat

elseif function eqss "FSTATS" then
  sedit p1 p1 "LOCASE"
  if p2 eqs "" set p2 "SP"
  iceutil "FSTATS" ^p1 ^{p1}_^{p2}_fstat p2
  if "/L" subs function then
    say "Viewing tail of status log"
    view/bg ^{p1}.mlog(-20:)
  endif
  if "/P" subs function then
    say "Viewing %full at top of buffer for entire run"
    plot/bg/all ^{p1}_^{p2}_fstat y1=-5 y2=105
  endif

elseif function eqs "GPS"
  picd reset ^p1
  if /server gt 0 then
    pipe on
    icermif/http ^/server 
    pipe run
    res state "RUN"
    while state neqs "EXIT"
      picd/dmac=-(/gps) "GPS" ^p1 ,, gpsdat /sv=gpssv
      pause .9
    endwhile
    pipe stop
  else
    global gpsdat gpssv
    picd/dmac=-(/gps) "GPS" ^p1 ,, gpsdat /sv=gpssv
  endif

elseif function eqs "MAKE"
  icemake,^p1,^p2,^p3

elseif function eqs "TEST/SPEC" 
  icetest,"SPEC",^p1

elseif "#" subs p1 then
  if hwalias rexists then
    set nc hwalias.pics
  else
    picd numdev /stat=nc
  endif
  switch "MAXDEV" l:nc get nc
  do l:ic 1 nc
    sedit p1 p1i "SUBS" "#" "^ic"
    pic/quiet=0 , ^function , ^p1i , ^p2 , ^p3 , ^p4 , ^p5 , 
  enddo

elseif function eqs "FAT" then
  fname icefat fat ,,, ice
  homepath icefat
  if p1 eqss "E2D" or p1 eqss "T2D" then
    ask answer "**** Execute short pass [Y]/N :"
    if answer eqss "Y" %testmod/fab io ^p1 3 
    ask answer "**** Execute long pass [Y]/N :"
    if answer eqss "Y" %testmod/fab io ^p1 50 
  elseif p1 eqss "D2E" or p1 eqss "D2T" then
    ask answer "**** Execute short pass [Y]/N :"
    if answer eqss "Y" %testmod/fab oi ^p1 3 
    ask answer "**** Execute long pass [Y]/N :"
    if answer eqss "Y" %testmod/fab oi ^p1 50 
  elseif p1 eqss "PIC" or p1 eqss "MBT" then
    ask answer "**** Execute short pass [Y]/N :"
    if answer eqss "Y" %testcard/fab ^p1 3
    ask answer "**** Execute multituner view [Y]/N :"
    if answer eqss "Y" %testtuners/hs/c ^p1 3
    ask answer "**** Execute long pass [Y]/N :"
    if answer eqss "Y" %testcard/fab ^p1 50
    if answer eqss "Y" %testtuners/hs ^p1
  else
    say "Invalid card type = ^p1"
  endif
  homepath restore

elseif function eqs "PFAT" then
  picd get ^p1 "ACTIVE" active
  if active gt 0 then
    error "Cannot run PFAT on a card with active DMAs. Shutdown APPs first."
    stop
  endif
  fname icefat fat ,,, ice
  homepath icefat
  picd halt p1
  if p1 eqss "E2D" or p1 eqs "D2E" or p1 eqs "A2D" then
    %testmod/noext/noxlink ix ^p1 5 pico
  else
    %testcard/noext/noxlink ^p1 5
    if /nox isfalse %testtuners/hs/c/timeout=15 ^p1
  endif
  homepath restore

elseif function eqs "TACH" then
  picd/flags=test|nosig test ^p1 91

elseif function eqss "ATTACH" then
  picd/flags=test test ^p1 91
  picd/verbose/flags=force reset ^p1

elseif function eqs "STATUS" then
  picd get ^p1 "ACTIVE" active
  if active lt 0 picd reset ^p1
  picd get ^p1 "STATUS" status
  picd get ^p1 "TYPE" ctype 
  picd "DRVFLG" ^p1 
  if ctype ge 5 and ctype le 8 then
    picd/node=0 "ROUTE" ^p1
    if /all then picd/node=0 TRS ^p1 /hex
  endif
  do nn 1 2
    picd get ^p1 "PMTYPE" pmtype /dmac=-nn
    if pmtype eq 0 continue
    picd/node=10+nn "ROUTE" ^p1 
    if /all then picd/node=10+nn TRS ^p1 /hex
  enddo

elseif function eqs "TEMPS" then
  picd get ^p1 "ACTIVE" active
  if active lt 0 picd reset ^p1
  if active le 0 picd set ^p1 log 0
  picd get ^p1 "DEVNO" l:devno
  iceutil grep "Device#^devno" "/proc/driver/icepic" str 
  sedit str str "TRIM" "CompTemp=" ")" "SUBS" "(" "XBar=" "SUBS" "," " IOM1=" "SUBS" "," " IOM2=" "SUBS" "," " PM1=" "SUBS" "," " PM2=" "APPEND" " C"
  if p2 neqs "" then
    set/parent ^p2 "^p1 Temps: ^str"
  else
    info "^p1 Temps: ^str"
  endif

elseif function eqs "DMACX" then
  picd dmac ^p1 ^p2
  icetest PPC/DMA ^p1

elseif "TEST/" subs function then
  sedit function function trim "TEST/"
  icetest,^function,^p1,^p2,^p3,^p4,^p5,^p6

elseif function eqs "FLASH" then
  error "Not supported under NextMidas. Use PICD LOADFLASH ..."

elseif function eqs "SETFLASH" then
  info "Reloading flash on ^p1. Card may fall off the PCIe bus requiring a soft reboot."
  picd set ^p1 flash 999

elseif function eqs "INITFLASH" then
  if p1 eqs "" set p1 "PIC1"
  if p2 eqs "" set p2 "icepic7_hh"
  set flg "K7"
  if "8" subs p2 then   set flg "K8"
  sedit flg flg "APPEND" "|NOVERSION"
  picd/flags=flg loadvirtex ^p1 ^p2 /verbose
  picd/flags=flg loadvirtex ^p1 ^p2 /verbose
  picd/flags=flg loadflash  ^p1 ^p2 /ask=n

elseif function eqs "UNLOADFLASH" then
  picd reset ^p1
  picd/node=0 get ^p1 type ctype
  if /aflags eqs k7 then set ctype 7
  if /aflags eqs k8 then set ctype 8
  sedit "nxm.ice.dat.icepic^{ctype}_hh" fname locase strim
!  key fname get "ICSZ"
  status fname size=len
  picd/flags=^/aflags unloadflash ^p1 ^p2 /len=len*32

elseif function eqs "REFLASH" then
  picd get ^p1 fpgasig sig /str
  picd get ^p1 fpgadsg dsg /str
  sedit "ice^{dsg}_^sig" ffnp "LOCASE"
  if p1 eqs "PIC" then 
    set p1 "PIC1AUTO"
    say "Default PIC card to flash set to ^p1"
  endif
  ask ffn "Choose flash filename for ^p1 [^ffnp]? "
  if ffn eqss "Y" then set ffn ffnp
  while nxm.ice.dat.^ffn nfexists
    ask ffn "Flash filename nxm.ice.dat.^ffn does not exist. Try again [^ffnp]? "
    if ffn eqss "N" then return
  endwhile
  ask ans "Check to see if file=^ffn is current Y/[N] ?
  if ans eqss "Y" then ice checkflash ^p1 ^ffn
  ask ans "Flash ^p1 with file=^ffn Y/[N] ?
  if ans eqss "Y" then
    picd loadflash ^p1 ^ffn /ask=n
    ask ans "Reload FPGA with new flash for Soft Reboot Y/[N] ?
    if ans eqss "Y" then ice setflash ^p1
  endif

elseif function eqs "CHECKFLASH" then
  ! picd reset ^p1
  picd/flags=^/aflags checkflash ^p1 /hex
  if p2 eqs ""
    picd/node=0 get ^p1 fpgasig sig /str
    picd/node=0 get ^p1 fpgadsg dsg /str
    if dsg eqs "" or "~" subs dsg then set dsg "pic8"
    switch "CNAME" cname get "^dsg"
    sedit "nxm.ice.dat.ice^{cname}_^sig" fname locase strim
  else
    sedit "nxm.ice.dat.^p2" fname locase strim
  endif
  key fname get "CRC" crc
  say "File ^fname ChkSum = ^crc"

elseif function eqs "CLEARFLASH" then
  do nn 11 12
    picd get ^p1 "PMTYPE" pmtype /dmac=-(nn-10)
    if pmtype le 7 continue
    picd "CLEARFLASH" ^p1 /flags=FLASHPORT=^nn|NOLOAD
  enddo

else
  picdriver/quiet=0 , ^function , ^p1 , ^p2 , ^p3 , ^p4
endif

endmacro

