startmacro/msgid=main/mlog cs:address

set l:sport 9000	! snapapp port
set l:cport 9001	! snapper or channel port

if /noapp then		! no snapapp mode
  set l:sport 0
endif

set s:saddr "^address:^sport"
set s:caddr "^address:^cport"

if sport gt 0
  icenet get ^saddr {SCENARIO,ACTION} /table=ss
  if ss.scenario eqs "NONE" then set ss.action "STOP"
endif

call getfilenames

pipe on
panel/controls=gc/setup/logger

gcontrol button "MODE"   "Macro" "Refresh,Exit" "Run" /nc=2 

gcontrol label  "SNAP"   "SNAPAPP Controls"

if sport ne 0 then
gcontrol choice "SCENE"  "Scenario" "REC,PB,PBSync,None" ss.scenario
gcontrol choice "ACTION" "Action"   "Monitor,Rec/PB,Stop" ss.action
gcontrol button "PORT"   "Channel" "1,2,3,4" "1" 
gcontrol button "LAUNCH" "Launch" "Snaplet,Snapper,TestTC,TestTCP" "" /nc=2
endif

gcontrol label  "TIVO"   "TIVO Controls"
gcontrol tval   "TTOP"   "Top" 0 0 -1
gcontrol tval   "TDUR"   "Dur" 0 0 -1
gcontrol prompt "EVNT"   "Event" "MyStuff"
gcontrol dval   "SPACE"  "Saved" 0 0 -1 /edit=f /slider /maximum
gcontrol button "TACT"   "Slice Action" "Assign,Select,Protect,Export,Erase,DeSelect,UnProtect,Import" /nc=2
gcontrol prompt "FILE"   "FileName" "testfile"

plot/id=plot/all/db afn_psd
list2/id=list afn_toc nxm.ice.cfg.toclist.tbl

pipe off

endmacro

procedure processMessage m:msg

if msg.name eqs "SCENE" then
  icenet set ^saddr {SCENARIO=^msg.data}

elseif msg.name eqs "ACTION" then
  icenet set ^saddr {ACTION=^msg.data}

elseif msg.name eqs "MODE" then
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "REFRESH" then
    call refresh
  endif

elseif msg.name eqs "PORT" then
  set l:cport sport+^msg.data
  set s:caddr "^address:^cport"
  call getfilenames
  call refresh

elseif msg.name eqs "LAUNCH" then
  if msg.data eqs "SNAPLET" then
    snaplet/bg ^caddr
  elseif msg.data eqs "SNAPPER" then
  elseif msg.data eqs "TESTTC" then
    icetest "TIMECODE" "^gc.FILE.v" "NONE" 30k
  elseif msg.data eqs "TESTTCP" then
    icetest "TIMECODE" "^gc.FILE.v" "LSBP" 30k
  endif
elseif msg.fid eqs "LIST"
  if msg.name eqs "SELECT" and msg.data.type eqs "ROW" then
   set top msg.data.value.time
   set bot msg.data.value.len+top
   foreach item intable msg.data.currsel
      calc top top msg.data.currsel.^{item}.time min
      calc bot bot msg.data.currsel.^{item}.time+msg.data.currsel.^{item}.len max
   endfor
   calc dur (bot-top) 
   calc top top+.1  ! margin for TC=CPU demo
   calc dur dur-.2 0 max
   set gc.TTOP.v top
   set gc.TDUR.v dur
   set gc.EVNT.v msg.data.value.evnt
  endif

elseif msg.fid eqs "PLOT"
  if msg.name eqs "MARK" then
    set reg.list.selectrow ^msg.data.y
  endif

elseif msg.name eqs "TACT" then
  icearchive/server="^caddr",^msg.data,"^afn",^gc.TTOP.v,^gc.TDUR.v,"^gc.EVNT.v","^gc.FILE.v"
  call refresh
endif
return

procedure getfilenames
icenet get ^caddr "AFNAME" "HTTP" /result=afn
if address eqs "xlocalhost" then
  set afn_toc "^{afn}_toc"
  set afn_psd "^{afn}_psd"
else
  set afn_toc "http://^caddr/Files/*/^{afn}_toc.tmp"
  set afn_psd "http://^caddr/Files/*/^{afn}_psd.tmp"
endif
return

procedure refresh
  if reg.list rexists then sendto list "OPENFILE" afn_toc
  if reg.list rexists then sendto list "OPENTEMPLATE" nxm.ice.cfg.toclist.tbl
  if reg.plot rexists then sendto plot "OPENFILE" afn_psd info=-1
  if gc.SCENE.v eqss "REC" and gc.ACTION.v eqss "REC" then
    icenet get ^caddr "REG.SP" "RTAB" /result=isup
    if isup nisnull then
      icenet get ^caddr "REG.SP.ARCHIVER.TOC.TOTALSPACE" "RTAB" /result=d:gc.SPACE.max
      icenet get ^caddr "REG.SP.ARCHIVER.TOC.SAVEDSPACE" "RTAB" /result=d:gc.SPACE.v
    endif
  endif
return
