!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  ICETEST - Test macro for ICE-PIC DSP cards
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:function u:p1 u:p2 u:p3 u:p4 u:p5 u:p6 u:p7

global/readall 
set aflags ^/aflags
set bflags ^/bflags
set p1i p1

switch "TPOLL" tpoll get 10 1

if env.ramaux rexists then
  res ramqual "{CTG=1,AUX=^{ENV.RAMAUX},DET=1}"
else
  res ramqual ""
endif

erase/quiet/warn=n testin testout

fname icefat fat ,,, ice

if function eqs "EXP" then
  explain icetest

elseif function eqs "ALL" then
  picd test ^p1 0

elseif function eqs "PFAT" then
  homepath icefat
  if p1 eqss "E2D" or p1 eqs "D2E" or p1 eqs "A2D" then
    %testmod/noext/noxlink ix ^p1 5 pico
  else
    %testcard/noext/noxlink ^p1 5
    if /nox isfalse %testtuners/hs/c ^p1
  endif
  homepath restore

elseif function eqs "MOD/RT" then

  if p2 eqs "" res p2 "1"
  res p2a ^p2
  res p2b 3-^p2
  if p3 eqs "" res p3 "4K"	! FFT size
  if p4 eqs "" res p4 "1K"	! decimation
  if p5 eqs "" res p5 "50e6"	! rate
  if p7 eqs "" res p7 "TRAMP"	! shape
  res sr p5

  picd reset ^p1 t^p2a /flags=^aflags
  if /ext gt 0 picd reset ^p1 lt^{p2a}
  if /int gt 0 picd reset ^p1 iir

  if p6 neqs ""
    res sr 1/p6(hcb.xd)
  else
    res p6 "testin"
    pic create testin si 1m sr ^p7
  endif
  picd create testout si 40m sr

  if /form neqs "NULL"
    header testin form=^/form
    header testout form=^/form
  endif

  pipe/panel/setup=RT on 
  if /tin le 0
    sourcepic/id=s1/tl=1/port=module^p2a/flags=muxclk=p|^aflags testout{fs=^p3} _cb , ^p1, ^p4 
  endif
  if /tout gt 0
    picd/replay=5/pause=0.25/port=module^p2b/flags=muxclk=p|^bflags play ^p1 ^p6 
  elseif /int le 0 
    picd/replay=2/pause=0.25/port=module^p2b/flags=muxclk=p|^bflags play ^p1 ^p6 
  endif
  fft/psd/log _cb _cbf ^p3 HANN  
  plot/id=plot1 _cb cm=re type=line
  plot/id=plot2 _cbf type=line
  plot/id=plot3 _cbf type=raster
  call setupControls
  pipe off
  picd reset ^p1 

elseif function eqs "CORE/RT" then

  if p2 eqs "" res p2 "1"
  res p2a ^p2
  res p2b 3-^p2
  if p3 eqs "" res p3 "4K"	! FFT size
  if p4 eqs "" res p4 "1K"	! decimation
  if p5 eqs "" res p5 "20e6"	! rate
  if p7 eqs "" res p7 "TRAMP"	! shape
  res sr p5

  picd reset ^p1 t^p2a /flags=^aflags

  if p6 neqs ""
    res sr 1/p6(hcb.xd)
  else
    res p6 "testin"
    pic create testin si 1m sr ^p7
  endif
  picd create testout si 4m sr

  if /form neqs "NULL"
    header testin form=^/form
    header testout form=^/form
  endif

  pipe/panel/setup=RT on 
  sourcepic/id=s1/tl=1/port=core^p2a/flags=alt|muxclk=i|^aflags/skip=p4 &
			testout{fs=^p3} _cb , ^p1, 1 
  picd/replay=2/pause=0.25/port=module^p2b/flags=^aflags play ^p1 ^p6 
  fft/psd/log _cb _cbf ^p3 HANN  
  plot/id=plot1 _cb cm=re type=line
  plot/id=plot2 _cbf type=line
  plot/id=plot3 _cbf type=raster
  call setupControls
  pipe off
  picd reset ^p1 

elseif function eqs "TUN/RT" then

  res sr 8e6
  if p2 eqs "" res p2 "1"
  calc l:p2a ^p2-1 2 mod 1 +
  calc l:p2b ^p2 2 mod 1 +
  if p3 eqs "" res p3 "1K"	! FFT size
  if p4 eqs "" res p4 "256"	! decimation
  if p5 eqs "" res p5 sr/128.1	! frequency

  picd reset ^p1 t^p2a
  if /ovsr ge 0
    picd OVSR ^p1 ,, //ovsr
    calc sr sr /ovsr /
  endif
  if p6 neqs ""
    res sr 1/p6(hcb.xd)
  else
    res p6 "testin"
    waveform testin^ramqual si 64k saw 20000 sr/128 ,,, 1/sr
  endif
  res scale 32k
  res dbmax 70
  switch "FORM" format get "CI"
  picd create testout1 format 64k sr/^p4
  picd create testout2 si 4m sr
  if "C" subs format header testout1 xd=2*^p4/sr
  if "L" subs format res scale 2G
  if "L" subs format res dbmax 150

  pipe/panel/setup=RT on 
  picd/replay=2/port=module^p2b/pause=0.25 play ^p1 ^p6 
  sourcepic/id=s1/tl=1/port=tuner^p2/flags=^aflags &
		testout1{fs=^p3} _cb1 , ^p1, ^p4, ^p5
  sourcepic/id=s2/tl=1/port=module^p2a/flags=^aflags/host=n &
		testout2{fs=^p3} _cb2 , ^p1, 256 
  fft/psd/log _cb1 _cbf1 ^p3 HANN 0 5
  fft/psd/log _cb2 _cbf2 ^p3 HANN 0 5
  plot/id=plot1 _cb1{fs=^p3} y1=-scale y2=scale cm=re type=line
  plot/id=plot2 _cbf2 type=rast z1=-80 z2=40 cnt=motion /msgid=main 
  plot/id=plot3 _cbf1 type=line y1=dbmax-140 y2=dbmax
  call setupControls
  pipe off
  picd reset ^p1 

elseif function eqs "OUT/RT" then

  if p2 eqs "" res p2 "1"
  if p3 eqs "" res p3 "4K"	! FFT size
  if p4 eqs "" res p4 "128"	! decimation
  if p5 eqs "" res p5 "10e6"	! rate
  if p6 eqs "" res p6 "1"	! length
  if p7 eqs "" res p7 "TRAMP"	! shape
  res sr ^p5
  switch "FORM" form get "SI"

  set aflags "^aflags|MUXCLK=P"

  picd reset ^p1 /flags=aflags
  picd create testout si ^p6*sr sr

  pipe/panel/setup=RT on 
  icewave/rt _cb{ps=1m} p7 form inf sr
  sinkpic/id=s1/port=MODULE^p2/stats/flags=aflags _cb testout{fs=^p3} ^p1 /mon=_cbm /skip=p4 /tl=1
  fft/psd/log _cbm _cbf ^p3 HANN  
  plot/id=plot1 _cbm cm=re type=line
  plot/id=plot2 _cbf type=line
  plot/id=plot3 _cbf type=raster
  call setupControls
  pipe off
  picd reset ^p1 

elseif function eqs "CHAIN/RT" then

  key "SR" sr get 10e6
  key "PORT" port get "MODULE2"
  key "CLK" clk get "P"
  pic create testout1 si 1m sr "RAMP"
  pic create testout2 si 1m sr "SINE"
  pic create testout3 si 1m sr "LRS"
  pic create testout4 si 1m sr "TRAMP"
  picd create testin si 8m sr 
  picd reset ^p1

  picd/flags=muxclk=^clk/replay=-20/port=^port/bg/dmac=dmac &
    chain ^p1 testout1|testout2|testout3|testout4
  set this.pc.reg.table.chainpic reg.picdriver

  if /autostop gt 0 then
    pause ^/autostop 
    picd/port=module2 set ^p1 chain 1
  endif

elseif function eqs "MULTI" then

  homepath icefat
  if p2 eqs "" set p2 "256"
  %testtuners/hs/form=sl/mux=3/nplot=^p2 ^p1 dec=1k
  homepath restore

elseif function eqs "ALLPORTS" then

  homepath icefat
  %testall ^p1
  homepath restore

elseif function eqs "SDDSGEN" then

  say "need:  route add -net 224.0.0.0 netmask 240.0.0.0 dev eth0"
  if p1 eqs "PIC" set p1 "224.1.2.3:9001"
  if p2 eqs "" set p2 "SB"
  if p3 eqs "" then
    set p3 "100"
    if p2 eqs "SI" set p3 "20000"
  endif
  if p4 eqs "" set p4 "10e6"
  if p5 eqs "" set p5 "sin"
  if p6 eqs "" set p6 "^p4/16"
  switch port l:port get 9001
  if this.pc.reg.table.sddsgen rexists and /nocheck isfalse
    say "Killing old SDDS Software Generator"
    set this.pc.reg.table.sddsgen.state "STOP"
  endif
  if this.pc.reg.table.picdriver rexists and /nocheck isfalse
    say "Killing old SDDS Hardware Generator"
    set this.pc.reg.table.picdriver.state "STOP"
  endif
  erase sdds1
  say "Generating SDDS src=^port dest=^p1 form=^p2 amp=^p3 rate=^p4 shape=^p5"
  set flg "IPADDR1=192.9.200.177|IPADDR2=192.9.200.178|IPDEST1=224.1.2.3|IPDEST2=224.1.2.4"
  if /fast then
    picd reset ^p1
    pic create sdds1 ^p2 16K ^p4 ^p5 ^p3 ^p6
    picd/replay=spin/port=module2/flags=muxclk=p|^flg play ^p1 sdds1
  elseif /fasttc then
    picd reset ^p1 
    waveform sdds2f shape=^p5 elem=100m form=^p2 amp=^p3 delta=1/^p4 freq=1e6
    header sdds2f tc=2006:11:22::12:34:56
    calc srate ^p4 1080/1024 * 
    erase sdds1
    sinksdds sdds2f sdds1^ramqual
    key sdds1 del "PACKET"
    picd/bg/replay=cont/port=module2/srate=srate/flags=muxclk=p|TXRAWDATA|^flg/bits=16 play ^p1 sdds1
    set this.pc.reg.table.picdriver reg.picdriver
  else
    pic create sdds1 ^p2 50m ^p4 ^p5 ^p3 ^p6
    header sdds1 tc=2006:11:22::12:34:56
    sinksdds/bg/wrap/rt/inmem sdds1 udp:^port/^p1
    set this.pc.reg.table.sddsgen reg.sinksdds
  endif

elseif function eqs "SDDSGEN0" then

  if p1 eqs "PIC" set p1 "224.1.2.3:9001"
  waveform sdds1 shape=sin elem=1m form=sb amp=100 delta=1e-6 freq=10e3
  sinksdds/bg/wrap/rt/inmem sdds1 udp:9001/^p1

elseif function eqs "SDDSGEN1" then

  if p1 eqs "PIC" set p1 "224.1.2.3:9001"
  waveform sdds1 shape=sin elem=1m form=si amp=10000 delta=1e-6 freq=10e3
  sinksdds/bg/wrap/rt/inmem sdds1 udp:9001/^p1

elseif function eqs "SDDSGEN2" then

  if p1 eqs "PIC" set p1 "224.1.2.3:9001"
  waveform sdds2 shape=saw elem=1m form=si amp=10000 delta=1e-6 freq=10e3
  sinksdds/bg/wrap/rt/inmem sdds2 udp:9002/^p1

elseif function eqs "SDDSGEN11" then

  if p1 eqs "PIC" set p1 "224.1.2.11:9001"
  waveform sdds1 shape=sin elem=1m form=si amp=10000 delta=1e-7 freq=1e7/16
  sinksdds/bg/wrap/rt/inmem sdds1 udp:9001/^p1

elseif function eqs "SDDSGEN12" then

  if p1 eqs "PIC" set p1 "224.1.2.12:9001"
  waveform sdds2 shape=saw elem=1m form=si amp=10000 delta=1e-7 freq=1e7/16
  sinksdds/bg/wrap/rt/inmem sdds2 udp:9002/^p1

elseif function eqs "SDDSOUT" then

  header ^p1 form=sb fs=1088
  sdds unpack ^p1 testd testp
  split testp testp_
  header testp_fram datarep=ieee
  fcalc diff testp_fram(1:) testp_fram -
  plot diff y1=-10 y2=10
  header ^p1 form=sb fs=0
  key ^p1 put packet sdds/ice /scope=main
  data/p ^p1
  status ^p1
  key ^p1 del packet /scope=main

elseif function eqs "SDDSIO" then

  snapapp sdds1
  snapapp sdds2
  snapapp sdds3
  snapapp sdds4

elseif function eqs "TCGEN" and /SDDS then

  if p2 eqs "" res p2 "10"
  pipe on /panel
  calc ps 16m
  calc rate ^p2 1e6 *
  res port "224.1.2.3:9001"
  waveform _data{ps=ps} shape=lrs elem=1e12 form=si amp=10000 delta=1/rate freq=rate/16
  if /rayday then
    icetc insert SDN0 _data _datatc{ps=ps} 364::23:59:45
  else
    icetc insert SDN0 _data _datatc{ps=ps} 123::12:34:56
  endif
  sinksdds/rt _datatc udp:9001/^port
  say "Running ^function to ^port at ^p2 MHz"
  pipe off

elseif function eqs "TCGEN" then

  if p2 eqs "" res p2 "10"
  if /LOOP then
    picd reset ^p1 t1nw 
  else
    picd reset ^p1 oow 
  endif
  if /NOFILL then
    picd/flags=tp=1 test ^p1 1000+^p2 
  else
    picd test ^p1 1000+^p2
  endif

elseif function eqs "TCGEN/SDDS/N" then

  pipe on /panel
  calc ps 16m
  calc rate ^p2 1e6 *
  res port "224.1.2.3:9001"
  waveform _data{ps=ps} shape=lrs elem=1e12 form=sn amp=7 delta=1/rate freq=rate/16
  timex 123::12:34:56 file=_data
  sinksdds/rt _data udp:9001/^port
  say "Running ^function to ^port at ^p2 MHz"
  pipe off

elseif function eqs "TCGEN/SDDS/LIVE" then

  switch "FORM" form get "SI"
  switch "SHAPE" shape get "LRS"
  say "Running ^function on ^^p1  Form=^form Shape=^shape Rate=^{p2}MHz"
  if form eqs "SB"
    set amp 100
  elseif form eqs "SN"
    set amp 7
  elseif shape eqs "RAMP"
    set amp 32K
  else
    set amp 10000
  endif
  calc ps 16m
  calc rate ^p2 1e6 *
  picd reset ^p1 /flags=^/aflags
  pic create testsddsout form rate rate
  pipe on /panel /setup=t /logger
  shellgui/id=term/attach
  waveform _data{ps=ps,tc=123::12:34:56} shape=shape elem=1e12 form=form amp=amp delta=1/rate freq=rate/100
  if form eqs "SI" then
    icetc insert SDN0 _data _datatc{ps=ps} 
    set sdfeed _datatc
  else
    set sdfeed _data
  endif
  if /inline then
    sinkpic/port=module2/stats sdfeed testsddsout ^p1 /flags=muxclk=p|^/aflags
  else
    sinksdds sdfeed _datatcsdds{ps=ps}
    sinkpic/port=module2/stats _datatcsdds{packet=none} testsddsout ^p1 /srate=rate*1080/1024 /flags=muxclk=p|txrawdata|^/aflags
  endif
  gcontrol button "ITEM" "Function" "Exit" 
  pipe off

elseif function eqs "TCGEN/I" then

  picd reset ^p1 oow
  if p2 eqs "" res p2 "1000"
  picd test ^p1 3000+^p2

elseif function eqs "TCGLITCH" then

  if p2 eqs "" res p2 "50"
  picd test ^p1 2000+^p2

elseif function eqs "TCMEAS" then

  homepath icefat
  if p2 eqs "" res p2 "50"
  if p3 eqs "" res p3 "1k"
  if p4 eqs "" res p4 "-1"
  picd reset ^p1
  %testtuners/mux/meas/tcx/tc=sdn0/tctolr=10e-9/nox/aflags=itdecx/wbpx=2 &
     ^p1 ,,, ^p3 ,^p4, ^p2*1e6 ^p2*1e6/5
  homepath restore

elseif function eqs "PPC/GET" then

  waveform ppco shape=sin form=sl elem=128 amp=0
  picd recv ^p1 ppco ^p2
  data/hex/nc=2 ppco
!  plot ppco cm=rni

elseif function eqs "PPC/NET" then
  waveform ppco shape=con form=sl elem=256 amp=0
  picd recv ^p1 ppco 0xfd814000
  data/hex/nc=8 ppco 0 256

elseif function eqs "PPC/DMA" then

  picd get ^p1 pmtype1 pmtype1 
  picd get ^p1 pmtype2 pmtype2 
  waveform ppco shape=sin form=sl elem=64 amp=0
  picd recv ^p1 ppco 0xfd813F00
  say "Dma R2X  00=PRC,02=HOST,04=HA,06=HB,08=CA,10=CB,12=TA,14=TB"
  data/hex/nc=2 ppco 0 16
  say "Dma X2R  16=PRC,18=HOST,20=HA,22=HB,24=CA,26=CB,28=TA,30=TB"
  data/hex/nc=2 ppco 16 16
 if /nvme or /nvm then
  say "Dma A2R  00=ch0,02=ch1,04=ch2,06=ch3,08=ch4,10=ch5,12=ch6,14=ch7"
  data/hex/nc=2 ppco 32 16
 endif
 if /net or /nio then
  say "Dma N2R  48=Stream1, 52=Stream2 ... 62=Stream8"
  data/hex/nc=2 ppco 48 16
 endif
  switch "NTUN" ntun get 0 16
 if ntun gt 0
  waveform ppco shape=sin form=sl elem=ntun amp=0
  picd recv ^p1 ppco 0xfd810000
  say "Dma T2R  00=Chan0 , 01=Chan1 ... N=ChanN"
  data/hex/nc=2 ppco 0 -1
 endif
  switch "NTUNI" ntun get 0 16
 if ntun gt 0
  waveform ppco shape=sin form=sl elem=ntun*2 amp=0
  picd recv ^p1 ppco 0xfd810e00
  say "Dma R2T  00=Chan0 , 02=Chan1 ... N=ChanN"
  data/hex/nc=4 ppco 0 -1
 endif
  picd "ROUTE" ^p1

elseif function eqs "PPC/FTT" then
  waveform ppco shape=sin form=sl elem=86 amp=0
  picd get ^p1 "PMTYPE" pmtype
  picd recv ^p1 ppco 0x480
  say "FTT stages,active,cstage,lstage,busy,chantop,bits,speed"
  data/nc=8 ppco 0 8
  say "FTT taddr"
  data/hex/nc=8 ppco 8 16
  do n 0 2
    say "FFT mchan,nchan,dec,cpc,xfer,cons,prod,chan,index      : pass=^n"
    say "FTT pcfg,pstrt,psize,pmask,pindx"
    say "FTT phinc,dphinc,tphinc,tdphinc,tphase,tdphase"
    data/nc=9 ppco n*20+24 9
    data/hex/nc=6 ppco n*20+33 5
    data/hex/nc=6 ppco n*20+38 6
  enddo
  say "FTT omoda,omodb"
  data/nc=8 ppco 84 2
  picd "ROUTE" ^p1

elseif function eqs "PPC/DUMP" then
  if p3 eqs "" res p3 "16M"
  waveform ppco shape=zero form=sl elem=^p3 amp=0
  picd recv ^p1 ppco ^p2

elseif function eqs "PPC/PEEK" then

  if p3 eqs "" res p3 "64"
  waveform ppco shape=sin form=sl elem=^p3 amp=0
  picd recv ^p1 ppco ^p2
  data/hex/nc=4 ppco 0 -1

elseif function eqs "PPC/POKE" then

  if p3 eqs "" res p3 "64"
  waveform ppco shape=saw form=sl elem=^p3 amp=0
  picd send ^p1 ppco ^p2
  data/hex/nc=4 ppco 0 -1

elseif function eqss "CORE" then
  if /RO isfalse
  do nn 0 8
    res l:aa (nn*4)
    picd/port=^function set ^p1 CORE+^aa 0x01CE0000+(aa*64)
  enddo
  endif
  do nn 0 8
    res l:aa (nn*4)
    picd/port=^function get ^p1 CORE+^aa /hex
  enddo

elseif function eqs "LOOP" then

  calc l:terrors 0
  if p3 eqs "" res p3 10000
  do ii 1 p3 
    picdriver test ^p1,^p2,errors
    calc l:terrors terrors errors +
    say " **********************   Loop=^ii Errors=^errors Total=^terrors"
  enddo

elseif function eqs "GPSMON" then

  switch
  switch "SIDE" l:p3 get 2
  if p2 eqs "" res p2 120
  do ii 1 p2 
    picdriver/port=MODULE^p3 get ^p1 dump /verbose=2
  enddo

elseif function eqs "SPEC" 

  if "#" subs p1 then
    picd numdev /stat=nc
    switch "MAXDEV" l:nc get nc
  else
    set l:nc 1
  endif

  set l:ny 1
  if nc gt 3 set l:ny 2
  set l:nx (nc+ny-1)/ny
  set t:tgrid {type=grid,nx=^nx,ny=^ny,name=plot,title=app}
  if /swamp then sedit aflags aflags "APPEND" "|SWAMP"
  switch "PCIDBG" pcidbg get "NULL" "NONE"
  if pcidbg eqs "NULL" rem pcidbg

  pipe on 
  panel/controls=gc/setup/grid=tgrid

  do l:ic 1 nc
    if "#" subs p1 sedit p1 p1i "SUBS" "#" "^ic"
    picd reset p1i /flags=aflags
    picd get p1i pcibw scale
    picd get p1i type ctype 
    set block "4K"
    if ctype ge 5 and ctype le 8 set block "256K"
    switch "BLOCK" s:block get block
    picd/id=p^ic specs p1i _specs^ic /todo=inf /block=^block /flags=aflags
    plot/id=plot^ic _specs^ic y1=0 y2=^scale /lps=512 /layer={ct={SRAT=Green,BRAT=White,PRAT=Gray}}
    if pcidbg rexists and pcidbg neqs "NONE" then noop _specs^ic ^{pcidbg}_^ic
  enddo

  call setupControls
  gcontrol choice "BLOCK" "Block " "1K,2K,4K,8K,16K,32K,64K,128K,256K,512K,1M" block
  if pcidbg rexists then 
    gcontrol menu "PCIDEBUG" "PCIe NACK Injector" &
	"Root NACK,Root NACKs x4,Root NACKs x100,Card NACK,Card NACKs x4,Card NACKs x100,Show NACK Count,Eye Scan"
  else
    gcontrol list "LEGEND" "Legend" "Green->Sustained-Acq,White->Blocked-Acq,Grey-->Sustained-Play" 20 3 /title
  endif
  pipe waitfor p1
  pipe off

elseif function eqs "EYES" then

  set t:eyeplots {}
  do ii 0 2
    if ii gt 0 then
      picd get p1 PMTYPE^ii pmt
      if pmt lt 8 continue
    endif
    icetest/eyes "EYE" ^p1 ii*2+0 /node=^ii
    icetest/eyes "EYE" ^p1 ii*2+1 /node=1^ii
  enddo
  if /batch istrue
    set ans "y"
    pause 5
  else
    ask ans "Clear plots? [y]/n :"
  endif
  if ans eqss "y" then
    foreach eyep intable/v eyeplots
      set eyep.state "FINISH"
    endfor
  endif

elseif function eqss "EYE" then

  set l:nn 0
  if p2 neqs "" set l:nn ^p2
  set l:xx nn*240
  picd "EYESCAN" p1 eyeout_^nn /stat=status
  status eyeout_^nn size=sz fs=frame
  calc l:yy sz/frame	! num lanes
  if status gt 0 then 
    plot/wpos=(100+xx,100,240,yy*75+50)/wtitle=^p1/bg eyeout_^nn z1=0 z2=48k axis=tlframe
    if /eyes then set this.m.parent.res.eyeplots.eyeplot^nn reg.plot
  endif

elseif function eqss "QIOEYES" then

  switch "LANE" l:lane get 4
  switch "RATES" t:rates get {GBE=10.3125,OTU2=10.709,OTU1e=11.049,OTU2e=11.095,OTU1f=11.270,OTU2f=11.317}
  erase/warn=n eyeouts
  foreach key intable rates 
    picd reset p1 /flags=qlr=^rates.^key
    picd "EYESCAN" p1 eyeout /lane0=lane /lanes=1
    statistics eyeout mean=vv
    calc vv 1 vv/32k -
    info "Proto=^key Rate=^rates.^key Eyescan=^vv"
    mergefile eyeout eyeouts
  endfor
  if /plot then 
    status eyeouts size=rows
    plot/wpos=(100,100,240,rows*2+50) eyeouts z1=0 z2=48k axis=tlframe view=iyx
  endif

elseif function eqs "PINGS" then
  do l:isfp 1 8
    calc l:jsfp isfp-1 4 + 8 mod 1 +
    set rnic hwalias.nic^jsfp
    picd ping p1 rnic.addr /isfp=isfp /verbose
  enddo

elseif function eqss "ICETIC" then

  switch "WIDTH" l:width get 1k
  icetc "TOP" "ICE" ^p1 ,, tt /delta=(1/^p2) /tic 
  calc off 1 tt.fsec - ^p2 *
  sourceice ^p1 ptmp
  thin ptmp ptmp off-width off+width
  header ptmp xs=-width/^p2 xd=1/^p2
  plot ptmp

elseif function eqss "QSFP" then

  say "Make sure loopback QSFP cable is connected 1 to 2 and 3 to 4"
  picd/stat=errs test ^p1 98 /flags=(IOC=IIR|MUXCLK=P|NIO=ICE|NIOC=4|TIMEOUT=1|NIODUP)"
  say "Test loopback QSFP complete : errors=^errs"

elseif function eqs "SLOT" then

  if p1 eq 1
    res l:icepics (0,1,2,3,4)
  elseif p1 eq 2
    res l:icepics (1,0,2,3,4)
  elseif p1 eq 3
    res l:icepics (2,1,0,3,4)
  elseif p1 eq 4
    res l:icepics (3,1,2,0,4)
  else
    warning "Cant sub slot ^p1 into slot 1"
  endif
  env set icepics icepics

elseif function eqs "TIMECODE" then
  set alfn p1
  set flg p2
  set scale p3
  key alfn get "PACKET" kpkt
  if kpkt eqs "SDDS/ICE" then
    icetc extract "SDDS" alfn snaptmp /test
    view/bg snaptmp
  elseif ^{alfn}.pkt fexists then
    icetc extract "ICE" ^{alfn}.pkt snaptmp /test /delta=file(alfn).delta
    view/bg snaptmp
  else
    warn "No SDDS or ICE packets modes found - listing TC hack +-16 samples"
    set tc file(alfn).time
    calc offset 1-tc.fsec file(alfn).xdelta / round
    switch "TCZONED" l:tczone get 32
    data/hex/nc=8 alfn offset-(tczone/2) +tczone
    switch "TCZONEP" l:tczone get 2k
    calc offset offset-(tczone/2) 0 max
    thin alfn tctmp offset offset+tczone
    status tctmp form=fmt xd=delta
    header tctmp xs=-tczone/2*delta
    if "LSBP" nsubs flg
      fcalc/type=l tcplot tctmp 0 *
    elseif fmt eqss "C"
      fcalc/type=l tcplot tctmp real 0x1 band scale/2 *
    else
      fcalc/type=l tcplot tctmp 0x1 band scale/2 *
    endif
    plot/bg tctmp|tcplot cm=mag y1=-scale y2=scale
  endif

else

  warn "Unsupported function=^function"

endif

endmacro

procedure setupControls
gcontrol label "GC" "General Control"
gcontrol button "ITEM" "Function" "Oneshot,Cont,Stop,ReStart,Status,Diff,Dmac,Exit" /nc=2
gcontrol label "AC" "Application Control"
set this.timers 1
set this.timer(0) tpoll
sendto "MAIN" "TIMER"
return

procedure processException
say "^emsg.data"
stop
return

procedure processMessage
if msg.name eqs "MARK"
  if msg.fid eqs "PLOT2"
    set reg.s1.freq msg.data.x
  endif

elseif msg.name eqs "ITEM"
 if msg.data eqs "EXIT"
   stop
 elseif msg.data eqs "STATUS"
   pic status ^p1
 elseif msg.data eqs "DIFF"
   icediff testout testin
 elseif msg.data eqs "DMAC"
   pic dmac ^p1
 elseif reg.s1 rexists 
   set reg.s1.replay msg.data
 endif

elseif msg.name eqs "TIMER" 
  if pcidbg rexists then
    pic get ^p1 "PCINACK" nacks /maxdev=^nc
  endif

elseif msg.name eqs "FREQ"
  set reg.s1.freq msg.data

elseif msg.name eqs "BLOCK"
  do l:ic 1 nc
    set reg.p^{ic}.block ^msg.data
  enddo

elseif msg.name eqs "PCIDEBUG"
  do l:ic 1 nc
  if "#" subs p1 sedit p1 p1i "SUBS" "#" "^ic"
  if msg.data eqs "SHOW NACK COUNT" then
    picd get p1i "PCINACK" nacks
  elseif msg.data eqs "ROOT NACK" then
    picd test p1i 17 /flags=tpcnt=0x10
  elseif msg.data eqs "ROOT NACKS X4" then
    picd test p1i 17 /flags=tpcnt=0x40
  elseif msg.data eqs "ROOT NACKS X100" then
    forall #=1:25 picd test p1i 17 /flags=tpcnt=0x40
  elseif msg.data eqs "CARD NACK" then
    picd test p1i 17 /flags=tpcnt=0x01
  elseif msg.data eqs "CARD NACKS X4" then
    forall #=1:4 picd test p1i 17 /flags=tpcnt=0x01
  elseif msg.data eqs "CARD NACKS X100" then
    forall #=1:100 picd test p1i 17 /flags=tpcnt=0x01
  elseif msg.data eqs "EYE SCAN" then
    if reg.p^ic rexists set reg.p^{ic}.replay "SPIN"
    icetest eyescan ^p1i ^ic
    if reg.p^ic rexists set reg.p^{ic}.replay "CONTINUOUS"
  endif
  enddo
endif
return


