!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This macro runs the system console on a devIce
!
startmacro/msgid=main s:cans

set addr env.hostaddr
switch/cs "TTY" s:tty get "pts"
set script "/var/tmp/iceconscript_^{tty}.sh"

if /sendping then
  switch BOOTIP s:bip get "192.168.0.123" "192.168.0.123"
  switch ADDR s:nip get "192.168.0.124"
  switch MASK s:nim get "255.255.255.0"
  call sendPing
  stop
endif

set lans "STARTUP"
if cans neqs "ASK"
  version ice
  say "Running ICECONSOLE on Addr=^addr, VNC at :1, HTTP at :8080"
endif

while cans neqs "EXIT"

if lans neqs "STARTUP" or cans eqs "ASK"
  ask cans "IceConsole Command [MENU]: "
endif
while cans eqs "!LAST" 
  ask cans "IceConsole Command [^lans]: "
endwhile
set lans cans

picd/stat=npic numdev
picd/stat=active active

if cans eqs "MENU" then
  say "IceConsole on ^addr valid commands: "
  say "  HELP     - Help on each command
  say "  INSTALL  - Install this IceOS Image"
  say "  UPDATE   - Update this IceOS Image"
  say "  PASSWD   - Set root and user account passwords"
  say "  NETCFG   - Configure Network"
  say "  RAMCFG   - Configure RAM Buffer Allocation"
  say "  DRVCFG   - Configure HS Data Drives"
  say "  APPCFG   - Configure Application Table File"
  say "  NTPCFG   - Configure NTP Server File"
  say "  OC2CFG   - Configure Occulink Defaults"
  say "  IOCCFG   - Configure IOCompanion Defaults"
  say "  FLASH    - Flash PIC DevIce to current version"
  say "  IMAGE    - Copy Image of IceOS to new USB drive"
! say "  NETSET   - Set devIce network address using boot ping"
  say "  DETECT   - Detect all current devices"
!  say "  STATUS   - Status all PIC DevIces"
  say "  LOG      - Change System Logging Service"
  say "  VNC      - Start fbVNC Client on :1 [@addr]"
  say "  REBOOT   - Reboot Device"
  say "  POWEROFF - Power Down Device"
  say "  POWERCYC - Power Cycle Device"
  say "  EXIT     - Exit Console"
  set cans "INIT"

elseif cans eqs "HELP" then
  help console ice

elseif cans eqs "RAMCFG" or cans eqs "DRVCFG" then
  set l:rdsz 8168
  if npic eq 1 then	! a PAC ?
    picd get pic1 pcilanes nlane
    if nlane eq 1 set l:rdsz 2048
  endif
  ask l:icerm "Ram Mapped [24] MBy: "
  ask l:icerd "Ram Disk [^rdsz] MBy: "
  ask l:icenv "FPGA Drive Mode 0=none 1=PM1 2=PM2 3=BothStriped [0] : "
  ask s:icefs "IceFS File System Mode [auto]|none : "
  file open/n/t ncf "/var/etc/icepic.conf"
  if ncf rexists then
    set cmdln "ice.ra=2 ice.rm=^icerm ice.rd=^icerd ice.nvm=^icenv ice.fs=^icefs"
    file write ncf cmdln
    file close ncf
    info "Must reboot to apply new RAM config: [^cmdln]"
  else
    warn "Could not create /var/etc/icepic.conf file. Check directory setup."
  endif

elseif cans eqs "DRVCFG" then
  warn "DRVCFG not coded yet"

elseif cans eqs "APPCFG" then
  ask q:name "Copy icebox.tbl file from none|name [current]: "
  if name eqs "current" then
  elseif name eqs "none" then
    erase/all /user/home/iceman/icebox.tbl
  elseif nxm.ice.tbl.^{name}.tbl nfexists then
    warn "File nxm.ice.tbl.^{name}.tbl does not exist"
  else
    file copy/f nxm.ice.tbl.^{name}.tbl /user/home/iceman/icebox.tbl
  endif

elseif cans eqs "NETCFG" then
  if "/var/etc/network.conf" fexists
    file copy/f /var/etc/network.conf /tmp/network.tbl
    table net LOAD /tmp/network.tbl
    info "Current config:"
    res/all net
    ask ans "Continue [Y]/N ?
    if ans neqss "Y" goto netdone
  else
    set t:net {hostname="^env.hostname",hostaddr="^env.hostaddr"}
  endif
  ask q:name "New HOST name [^net.hostname]: "
  label netover
  ask addr "New HOST address [^net.hostaddr]: "
  sedit addr addrA "ELEMENT" 1 "."
  sedit addr addrB "ELEMENT" 2 "."
  sedit addr addrC "ELEMENT" 3 "."
  sedit addr addrD "ELEMENT" 4 "."
  if addrD eqs "" then
    warn "Address must be of format A.B.C.D"
    goto netover
  endif
  sedit addrC addrCX "SUB" "0" "X"
  if "X" nsubs addrCX then sedit addrCX addrCX "APPEND" "+X"
  set addrx "^{addrA}.^{addrB}.^{addrCX}.^{addrD}"
  set gatex "^{addrA}.^{addrB}.^{addrC}.254"
  ask mask  "New HOST netmask [255.255.255.0]: "
  ask gate  "New HOST gateway [^gatex]: "
  ask addrx "New QSFP address [^addrx] (use X, +X, or |X where X=1-4|8): "
  ask maskx "New QSFP netmask [255.255.0.0]: "
  ask gatex "New QSFP gateway [^gate]: "
  info "New HOST name = ^name"
  info "New HOST addr = ^addr"
  info "New HOST mask = ^mask"
  info "New HOST gate = ^gate"
  info "New QSFP addr = ^addrx"
  info "New QSFP mask = ^maskx"
  info "New QSFP gate = ^gatex"
  ask ans "Save Config [Y]/N ?
  if ans neqss "Y" goto netdone
  file open/n/t ncf "/var/etc/network.conf"
  if ncf rexists then
    file write ncf "hostname=^name"
    file write ncf "hostaddr=^addr"
    file write ncf "hostmask=^mask"
    file write ncf "hostgate=^gate"
    file write ncf "qsfpaddrx=^addrx"
    file write ncf "qsfpmask=^maskx"
    file write ncf "qsfpgate=^gatex"
    file close ncf
    info "Must reboot to use new network parameters"
  else
    warn "Could not create /var/etc/network.conf file. Check directory setup."
  endif
  label netdone

elseif "CFG" subs cans then

  if cans eqs "IOCCFG" then
    set fname "/var/etc/iceioc.conf"
  elseif cans eqs "OC2CFG" then
    set fname "/var/etc/icetray.conf"
  elseif cans eqs "NTPCFG" then
    set fname "/var/etc/chrony.conf"
  else
    warn "Unknown CFG option: ^cans"
    return
  endif
  info "Opening editor to ^cans config file: ^fname"
  if tty eqss "PTS" then
    file open/n/t ncf script
    file write ncf "nano ^fname"
    file close ncf
    set cans "EXIT"
  elseif tty eqss "TTY" then
    warn "Must have X-windows system to run this. Try running ICE Console from the VNC option."
  else
    os xterm -e nano ^fname
  endif

elseif cans eqs "NETSET" then
  ask s:bip "Boot IP address [192.168.0.123]: "
  ask s:nip "New IP address [192.168.0.124]: "
  ask s:nim "New IP netmask [255.255.255.0]: "
  call sendPing

elseif cans eqs "START" then
  icenet set localhost:8080 {MODE=OPEN}

elseif cans eqs "STOP" then
  icenet set localhost:8080 {MODE=CLOSE}

elseif cans eqs "LOG" then
  ask ans "Turn system ring buffer logging to file on Last2/Every/Off/[NoChange] boots ? "
  if ans eqs "" or ans eqss "N" then
    say "Log Service not changed"
  elseif ans eqss "L" then
    file open/n/t ncf "/var/log/iceos.LOG"
    file write ncf "LAST2"
    file close ncf
    say "Log=LAST2. All dmesg output >> to log files /var/log/dmesg.thisBoot and /var/log/dmesg.lastBoot after reboot"
  elseif ans eqss "E" then
    file open/n/t ncf "/var/log/iceos.LOG"
    file write ncf "EVERY"
    file close ncf
    say "Log=EVERY. All dmesg output >> to log files /var/log/thisBoot = /var/log/dmesg.[bootdate] after reboot"
  elseif ans eqss "O" then
    os rm -f /var/log/iceos.LOG /tmp/iceos.LOG
    say "Log=OFF. Use dmesg command to view current system log ring buffer"
  endif

elseif cans eqss "PASSWD" then
  set accounts "|root|iceman|icemkr|iceuser|vnc|"
  ask q:ans "Account password to change: ^accounts [none] ? "
  if ans eqs "NONE" then
  elseif "|^ans|" nsubs accounts then
    say "Invalid account name: ^ans"
  else
    ! needs to be run from outside java to get the TTY right
    file open/n/t ncf script
    file write ncf "/etc/iceos/setPassword ^ans"
    file close ncf
    set cans "EXIT"
  endif

elseif cans eqss "VNC" and tty neqs "TTY3" then
  warn "Can only be run from the DevIce console tty at Alt-F3"

elseif cans eqss "VNC" then
  set addr env.hostaddr
  if "@" subs cans then
    sedit cans addr "TRIM" "@"
    if "." nsubs addr then
      sedit env.hostaddr snet element 4 "."
      sedit "^env.hostaddr|" addr "SUBS" ".^snet|" ".^addr"
    endif
  endif
  info "Starting VNC client at addr=^addr port=5901"
  ! needs to be run from outside java to get the TTY right
  file open/n/t ncf script
  file write ncf "/etc/iceos/runfbVnc ^addr"
  file close ncf
  set cans "EXIT"

elseif cans eqs "IMAGE" then
  warn "IMAGE not coded yet"

elseif cans eqs "INSTALL" then
  if /var/local/iceinstaller.tar fexists and /var/local/iceinstaller nfexists then
    ask ans "Found /var/local/iceinstaller.tar reinstallation file. Unpack Y/[N] ? "
    if ans neqs "" and ans eqss "Y" then 
      os tar -xvf /var/local/iceinstaller.tar -C /var/local/ iceinstaller
    endif
  endif
  if /var/local/iceinstaller fexists then
    ask ans "ReInstalling new OS from /var/local/iceinstaller. Are you sure Y/[N] ? "
    if ans neqs "" and ans eqss "Y" then 
      os /var/local/iceinstaller preinstall
    endif
  elseif /home/root/makecopy fexists then
    set ans "NONE"
    if "/dev/sda" aexists then
      ask ans "Installing this new OS on /dev/sda will wipe out all user data. Are you sure Y/[N] ? "
      if ans neqs "" and ans eqss "Y" then 
        os /home/root/makecopy sda
      endif
    endif
    if "/dev/nvme0n1" aexists and ans neqss "Y" then
      ask ans "Installing this new OS on /dev/nvme0n1 will wipe out all user data. Are you sure Y/[N] ? "
      if ans neqs "" and ans eqss "Y" then 
        os /home/root/makecopy nvme0n1
      endif
    endif
  else
    warn "Cannot find necessary files to run an ICEOS installation"
  endif

elseif cans eqs "UPDATE" then
 if "/dev/nvme0n1p3" aexists then
  set devos "/dev/nvme0n1p"
 else
  set devos "/dev/sda"
 endif
  set devin "^{devos}3"
  set dirin "/var/local"
  set pathin "/var/local"
  if "/var/local/iceinstaller.tar" fexists then
    ! leave as is
  elseif "/mnt/data/updates/iceinstaller.tar" fexists then
    set pathin "/mnt/data/updates"
    set devin "^{devos}4"
    set dirin "/updates"
  elseif "/mnt/data11/updates/iceinstaller.tar" fexists then
    set pathin "/mnt/data11/updates"
    set devin "^{devos}4"
    set dirin "/updates"
  endif
  ask q:devos  "Device for new IceOS [^devos]: "
  ask q:devin  "Device hosting iceinstaller.tar [^devin]: "
  ask q:dirin  "Directory hosting iceinstaller.tar [^dirin]: "
  ask q:pathin "Path to iceinstaller.tar [^pathin]: "
  set infile "^pathin/iceinstaller.tar"
  ask ans "Update IceOS on ^devos from ^devin:^dirin/iceinstaller.tar.\nAre you sure Y/[N] ? "
  if ans eqs "" or ans neqss "Y" then
    info "Aborting IceOS update"
  elseif infile fexists then
    os tar -xvf ^infile -C ^pathin iceinstaller
    os ^pathin/iceinstaller preinstall ^devos ^devin ^dirin
  else
    error "Installer file=^infile does not exist"
  endif

elseif cans eqss "POWER" or cans eqs "REBOOT" then
  icenet set localhost:8080 {MODE=EXITNOW}
  pause 3
  if /etc/iceos dexists then
    os touch /tmp/iceos.^cans
  elseif cans eqss "POWEROFF" then
    os /sbin/poweroff
  elseif cans eqs "POWERCYC" then
    os /etc/iceos/ipmice power=cycle
    os /sbin/poweroff
  else
    os /sbin/reboot
  endif
  set cans "EXIT"

elseif cans eqs "EXIT" then
  ! handled by while loop test

elseif npic le 0 then
  warn "No PIC cards recognized"
elseif active lt 0 then
  warn "Wait for PICs to initialize first"

elseif cans eqs "STATUS" then
  say "ICECONSOLE on Addr=^addr, VNC at ^addr:1, HTTP at ^addr:8080"
  ice status pic#auto

elseif cans eqs "DETECT" then
  os lsblk
  os df
  picd detect

elseif active ne 0 then
  warn "Wait for PICs to be inactive first"

elseif cans eqs "FLASH" then
  if npic lt 1 then
    warn "No PIC cards detected on this platform"
  elseif nxm.ice.dat.icepic8_hhx nfexists then
    warn "No PIC8 flash files found. Log in as user first."
  else
    pic reflash pic#auto
  endif

elseif cans eqs "PFAT" then
  ice pfat pic#auto

else
  say "Unrecognized console command=^cans"
  set cans "INIT"
endif

endwhile

endmacro

procedure sendPing
sedit nip ldot "BSEARCH" "."
sedit nip nig "RANGE" 0 ldot "APPEND" "254"
switch GW   s:nig get nig
say "Send network IP Config ping from ^env.hostaddr to boot IP=^bip.  New ADDR=^nip MASK=^nim GW=^nig"
iceutil "STR2IP" nip nipx
iceutil "STR2IP" nim nimx
iceutil "STR2IP" nig nigx
! this creates a ping padded with ICE=(addr,mask,gw) in hex
os ping ^bip -p 4943453d^{nipx}^{nimx}^{nigx}
return
