/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define TGSDDS_NUM_PRG_BITS     32
#define TGSDDS_SYSCFGREG_ADR    0x00000000
#define TGSDDS_ENDISCFGREG      0x00010000
#define TGSDDS_HOSTMEMREG_ADR   0x00020000
#define TGSDDS_STARTCFGREG_ADR  0x00030000
#define TGSDDS_AMCCCFGREG_ADR   0x00040000
#define TGSDDS_XCLKCFGREG_ADR   0x00050000
#define TGSDDS_DCLKCFGREG_ADR   0x00060000
#define TGSDDS_RXCFGREG_ADR     0x00070000
#define TGSDDS_TXCFGREG_ADR     0x00080000
#define TGSDDS_TXVCFGREG_ADR    0x00090000
#define TGSDDS_GLBAMCFGREG_ADR  0x000A0000
#define TGSDDS_TEMPSENSE_ADR    0x000A0000
#define TGSDDS_CBCFGREG_ADR     0x000B0000
#define TGSDDS_CBRSTREG_ADR     0x000C0000
#define TGSDDS_PHYREG_ADR       0x000D0000 
#define TGSDDS_MACREG_ADR       0x000E0000 
#define TGSDDS_DBGRST_ADR       0x000F0000

#define TGSDDS_TXTPKTREG_ADR    0x000E0000
#define TGSDDS_TXTDELREG_ADR    0x000F0000

#define TGSDDS_MINOUT_FREQ     1000000
#define TGSDDS_MAXOUT_FREQ     80000000
#define TGSDDS_AMCC_CODE_SZ    0x6000       /* AMCC Code Size 24K            */

/* Jtag Mux Register Read Selects-Bits[17..16] */
#define TGSDDS_AMCC0RDSEL      0x00000000
#define TGSDDS_AMCC1RDSEL      0x00010000
#define TGSDDS_MEMRDSEL        0x00020000 

/* Module Memory Wr/Rd Addresses               */
#define TGMEM_AMCC_ADR         0x00000000   /* Address Of AMCC Program Word  */
#define TGMEM_VLAN_ADR         0x00000001   /* Address Of VLAN Enable Word   */   
#define TGMEM_OCLKFREQ_ADR     0x00000002   /* Address Of Output Clock Freq  */

#define TGMEM_CHAN_OFF         0x00000010   /* Offset  Of Channel  Cfg Bits  */
#define TGMEM_CBCFG_ADR        0x00000000   /* Address Of Crossbar CFg Bits  */
#define TGMEM_ENCFG_ADR        0x00000001   /* Address Of Enable   Cfg Bits  */
#define TGMEM_RSTCFG_ADR       0x00000002   /* Address Of Reset    Cfg Bits  */
#define TGMEM_ENVAL_ADR        0x00000003   /* Address Of En Reg Current Val */  
#define TGMEM_CBRST_ADR        0x00000004   /* Address Of CBar Reset  Bits   */

/* Sys Config Bits                             */
#define TGSYS_RESET_BIT        0x00000001   /* Remove Reset Single Port      */       
#define TGSYS_GLBRESET_BIT     0x00000002   /* Remove Reset Dual   Port      */
#define TGSYS_ACQUIRE_BIT      0x00000004   /* Acquire Single Port           */
#define TGSYS_GLBACQUIRE_BIT   0x00000008   /* Acquire Dual   Port           */
#define TGSYS_LVDSDBG_BIT      0x00000010   /* IOC LVDS Single Port          */
#define TGSYS_GLBLVDSDBG_BIT   0x00000020   /* IOC LVDS Dual   Port          */
#define TGSYS_TESTOUT_BIT      0x00000040   /* Output Test Packet Enable     */
#define TGSYS_GLBTESTOUT_BIT   0x00000080   /* Output Test Packet Dual Enable*/  
#define TGSYS_OUTDEBUG_BIT     0x00040000   /* Debug 16 Bit Ramp Sing Output */
#define TGSYS_GLBOUTDEBUG_BIT  0x00080000   /* Debug 16 Bit Ramp Dual Output */
#define TGSYS_TDELSTAGECNT_BIT 0x40000000   /* Stage Test Tx Delay Count     */

/* Rx Configuration Bits                       */
/* Rx Register Address Offset Bits             */
#define TGRX_CFGREGADDR        0x0100 /* Configuration For Rx Logic Cfg Reg  */
#define TGRX_CPUWRADDR         0x0200 /* Configuration For Rx CPU DP Ram     */
#define TGRX_NREGADDR          0x0400 /* Trottle Count Reg For ICE SDDS Mode */         /* Not Used */
#define TGRX_STRICTADDR        0x0800 /* Address Offset For Strict Adr Regs  */ 
#define TGRX_ENREGADDR         0x1000 /* Address Offset For Dis/Enable Reg   */         /* Not Used */
#define TGRX_USRXTRASZ         0x2000 /* Xtra Size To Read from RAWDATA Pkt  */
#define TGRX_PKTPARMADR        0x4000 /* Pkt Parameter Address               */
#define TGRX_USRHDRADR         0x8000 /* User Header Address                 */    

/* Rx DP/Logic Config Bits                     */
#define TGRX_RAWBITS_BIT       0x0001 /* Enable Fastest Rx w/NO Tx Replies To Rx Packets         */
#define TGRX_RAWDATA_BIT       0x0002 /* Bring In Every And All Packet Data/Headers              */ 
#define TGRX_RAWSDDS_BIT       0x0004 /* Bring In Only SDDS Packet Header & Data, NO UDP,IP Hdrs */
#define TGRX_ICESDDS_BIT       0x0008 /* Bring In SDDS Packet Header & Data, and ICE Header      */ 
#define TGRX_STRICT_BIT        0x0010 /* Allow Only 1 MC Data Source--Don't Trust Routers        */ 
#define TGRX_SDDSDATA_BIT      0x0020 /* Enable IOC To Control Data Flow Using OCLK              */
#define TGRX_NSPKTEN_BIT       0x0040 /* Allow Non-Standard Pkt Acq In ICESDDS Mode              */      
#define TGRX_PRYPKTEN_BIT      0x0080 /* Allow Parity Pkt Acq In ICESDDS Mode                    */  
#define TGRX_TCBSWAP_BIT       0x0100 /* Swap Bit 3 & Bit 0 TC Bits-For RXSDDSDATA Only          */  /* Not Used */ 
#define TGRX_DEBUGMOD_BIT      0x0200 /* Turn On Clock Always, Zero Non-Valid Data-DEBUG ONLY    */  /* Not Used */
#define TGRX_SEQCHECK_BIT      0x0400 /* Turn On Packet Sequence Checking                        */
#define TGRX_USERHDR_BIT       0x0800 /* Add User Header To RAWDATA Packet                       */
#define TGRX_PKTDATA_BIT       0x1000 /* Bring In Full UDP Pkt Of Certain Size Only              */ 
#define TGRX_MEMBUFF_BIT       0x2000 /* Bring In Data Thru Memory Buffer                        */
#define TGRX_RAWUDP_BIT        0x4000 /* Bring In UDP Hdr and UDP Data                           */
#define TGRX_RAWPKTSDDS_BIT    0x8000 /* Bring In SDDS ONLY Whole PKT                            */

/* Tx Configuration Bits                       */
/* Tx Register Address Offset Bits             */
#define TGTX_CPUWRADDR         0x0100 /* Configuration For Tx CPU DP Ram     */
#define TGTX_DATWRADDR         0x0200 /* Configuration For Tx Dat DP Ram     */         /* Not Used */
#define TGTX_DATRDADDR         0x0400 /* Address Of Tx Packet To Send        */ 
#define TGTX_CFGREGADDR        0x0800 /* Configuration For Rx Logic Cfg Reg  */
#define TGTX_TRANSZREGADDR     0x1000 /* Pkt Size Transfer After Header      */
#define TGTX_UDPCKSUMREGADDR   0x2000 /* UDP CheckSum Logic Address          */ 
/* Tx Logic Config Bits                        */
#define TGTX_VLANEN_BIT        0x0001 /* Enable VLAN Send Operation          */ 

/* Crossbar Config Bits                        */
#define TGCB_DEFMODE_BIT       0x0001 /* Default Packet Ping-Pong To PIC     */
#define TGCB_SLOWMODE_BIT      0x0002 /* Independent Port Acquires           */
#define TGCB_RAWMODE_BIT       0x0004 /* Byte Mux Using Both PIC Ports       */
#define TGCB_ALIGNMODE_BIT     0x0008 /* Align Channels Before Acq           */ 
#define TGCB_ENPAUSE_BIT       0x0010 /* Enable Pause Frame Transmit         */
#define TGCB_TXRAWDAT_BIT      0x0020 /* Enable TXRAWDATA Dual Port Transfer */
#define TGCB_TXRAWUDP_BIT     0x0100  /* Enable TXRAWUDP Dual Port Transfer */


/* Crossbar Reset Bits                         */
#define TGCB_RESET_BIT         0x0001 /* Remove Crossbar Reset               */
#define TGCB_GRESET_BIT        0x0002 /* Remove Crossbar Reset-Both Sides    */ 

/* Enable/Disable Config Bits                  */
#define TGEN_SINGLE_BIT        0x0001 /* Enable Single LVDS Port For Acquire */
#define TGEN_DUAL_BIT          0x0002 /* Enable Dual   LVDS Port For Acquire */ 


/* PHY Cfg Write/Read Select Bits              */
#define TGPHY_REGSEL_BIT   0x00008000 /* Set Bit For Cfg Reg Rd/Wr Ops       */          
#define TGPHY_WRSEL_BIT    0x00004000 /* Set Bit For Wr Ops, Else Read Ops   */    

/* MAC Config Bits                             */
#define TGPHY_GXBPDN_BIT   0x00000001
#define TGPHY_PLLPDN_BIT   0x00000002
#define TGPHY_CALPDN_BIT   0x00000004 


/* MAC Cfg Write/Read Select Bits              */
#define TGMAC_REGSEL_BIT   0x00008000 /* Set Bit For Cfg Reg Rd/Wr Ops       */          
#define TGMAC_WRSEL_BIT    0x00004000 /* Set Bit For Wr Ops, Else Read Ops   */    

/* MAC Config Bits                             */
#define TGMAC_CFGRST_BIT   0x00000001
#define TGMAC_RXRST_BIT    0x00000002
#define TGMAC_TXRST_BIT    0x00000004


#define TG_STANDARDPKT_DLD 0x000A0000  /* Standard SDDS  Pkt Size Download   */
#define TG_LARGEPKT_DLD    0x000B0000  /* Standard Large Pkt Size Download   */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/  
int_4 sdds_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr, int_u2 running)
{  
   int_u2 txadr_offset = 0x00AE;  /* Join Address Offset */
   int ii;   
   int_u4 mjtrdval;
   int_u4 txopreg; 

   if (p->mtype[mport-1] == IOMT_TGSDDSXD)
     {      
       if (joinleave < 0)  /* Leave */
         {
           /* printf("TGSXDR1 Leave\n"); */
           txadr_offset = 0x00B0;  /* Leave Address Offset */  
           if (findflag("SDDSGENLV",p->config) < 0)   /* If Flag Not Preset, Cut Off Flow For ANY Leave Address */
             { 
              /* Write Down Strict Mode Addr MS Word */
               pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_STRICTADDR,0x0000,TGSDDS_NUM_PRG_BITS);
               udelay(100);
              /* Write Down Strict Mode Addr LS Word */
               pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_STRICTADDR,0x0000,TGSDDS_NUM_PRG_BITS);
               udelay(100);            
            }
         }
       else
         {
           /* printf("TGSXDR1 Join\n"); */
          /* Write Down Strict Mode Addr MS Word */
           pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_STRICTADDR,groupaddr,TGSDDS_NUM_PRG_BITS);
           udelay(100);
          /* Write Down Strict Mode Addr LS Word */  
           pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_STRICTADDR,(groupaddr >> 16),TGSDDS_NUM_PRG_BITS);
           udelay(100);                
         }   
       vprint("JOIN/LEAVE mport=%d dir=%d addr=%08x\n",mport,joinleave,groupaddr);
       
       if (((groupaddr & 0x000000ff) <= 223) || ((groupaddr & 0x000000ff) >= 240))
         { 
    /* &BILL-so msg does NOT print for Unicast messages */
    /*     printf("Multicast Address %d.%d",(int_u1)groupaddr,(int_u1)(groupaddr>>8));
           printf(".%d.%d ",(int_u1)(groupaddr>>16),(int_u1)(groupaddr>>24));
           printf("Is Out Of Range Of 224.0.0.0 To 239.255.255.255\n");
    */
           return(0);
         }

       pic_rmodreg (p,2,TGSDDS_MEMRDSEL|TGMEM_VLAN_ADR,&mjtrdval,TGSDDS_NUM_PRG_BITS);        
       if (mjtrdval == 0)
         txopreg = TGSDDS_TXCFGREG_ADR;    /* Non-VLAN */
       else
         txopreg = TGSDDS_TXVCFGREG_ADR;   /* VLAN     */ 
                
       for (ii=0;ii<1;ii++)   /* Send Out Leave/Join  */
         {   
          /* High-Write Address Adr Of Tx Data DP Buffer  */ 
          /* High-Write Data To Earlier Specified Address */    
           pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x00AA,groupaddr,TGSDDS_NUM_PRG_BITS);       
           udelay(100);
          /* Low-Write Address Adr Of Tx Data DP Buffer   */
          /* Low-Write Data To Earlier Specified Address  */
           pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x00AB,(groupaddr >> 16),TGSDDS_NUM_PRG_BITS);         
           udelay(100);
          /* Write Address To Begin Transfer */ 
          /* Write Tx Size Of Transfer       */
           pic_wmodreg(p,mport,txopreg|TGTX_DATRDADDR|txadr_offset,32,TGSDDS_NUM_PRG_BITS);      
           udelay(10000);
         }             
     }
   else
     {
       if (joinleave < 0)  /* Leave */
         {
           txadr_offset = 0x00B0;  /* Leave Address Offset */  
           if (findflag("SDDSGENLV",p->config) < 0)   /* If Flag Not Preset, Cut Off Flow For ANY Leave Address */
             { 
              /* Write Down Strict Mode Addr MS Word */
               pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
               pic_wmodreg(p,mport,0,((int_u2)0),SDDS_NUM_PRG_BITS); 
               udelay(100);
      
              /* Write Down Strict Mode Addr LS Word */
               pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
               pic_wmodreg(p,mport,0,((int_u2)0),SDDS_NUM_PRG_BITS); 
               udelay(100);
            }
          if (p->isY)
            { 
              pic_wmodreg(p,mport,0x00100000,0,SDDS_NUM_PRG_BITS);
              pic_wmodreg(p,mport,0x00100001,0,SDDS_NUM_PRG_BITS);
            }
         }
       else
         {
           pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
           pic_wmodreg(p,mport,0,((int_u2)groupaddr),SDDS_NUM_PRG_BITS);         /* Write Down Strict Mode Addr MS Word */
           udelay(100);

           pic_wmodreg(p,mport,0,SDDS_RXDP_OP | RX_STRICTADDR,SDDS_NUM_PRG_BITS);        
           pic_wmodreg(p,mport,0,((int_u2)(groupaddr >> 16)),SDDS_NUM_PRG_BITS); /* Write Down Strict Mode Addr LS Word */
           udelay(100);       
         }   
       vprint("JOIN/LEAVE mport=%d dir=%d addr=%08x\n",mport,joinleave,groupaddr);
 
      /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
       if (((groupaddr & 0x000000ff) > 223) && ((groupaddr & 0x000000ff) < 240))
          {         
            for (ii=0;ii<1;ii++)   /* Send Out Leave/Join  */
              {   
               /* High-Write Address Adr Of Tx Data DP Buffer  */ 
               /* High-Write Data To Earlier Specified Address */     
                pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x00AA,SDDS_NUM_PRG_BITS);      
                pic_wmodreg(p,mport,0,((int_u2) groupaddr),SDDS_NUM_PRG_BITS);              
                udelay(100);
               /* Low-Write Address Adr Of Tx Data DP Buffer   */
               /* Low-Write Data To Earlier Specified Address  */
                pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATWRADDR+0x00AB,SDDS_NUM_PRG_BITS);               
                pic_wmodreg(p,mport,0,((int_u2) (groupaddr >> 16)),SDDS_NUM_PRG_BITS);               
                udelay(100);
               /* Write Address To Begin Transfer */ 
               /* Write Tx Size Of Transfer       */
                pic_wmodreg(p,mport,0,SDDS_TXDP_OP+TX_DATRDADDR+txadr_offset,SDDS_NUM_PRG_BITS);               
                pic_wmodreg(p,mport,0,32,SDDS_NUM_PRG_BITS);                                         
                udelay(10000);

                if (p->isY)
                  { 
                   pic_wmodreg(p,mport,0x00100000,groupaddr & 0x0000FFFF,SDDS_NUM_PRG_BITS);
                   pic_wmodreg(p,mport,0x00100001,(groupaddr >> 16)& 0x0000FFFF,SDDS_NUM_PRG_BITS);
                  }
              }
          }
       else
          {
            printf("Multicast Address %d.%d",(int_u1)groupaddr,(int_u1)(groupaddr>>8));
            printf(".%d.%d ",(int_u1)(groupaddr>>16),(int_u1)(groupaddr>>24));
            printf("Is Out Of Range Of 224.0.0.0 To 239.255.255.255\n"); 
          }   
     }
 
   return(0);    
} 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 TGset_module_HW_IP_addr (PICSTRUCT *p, int_4 mport, int_u4 ip_addr, int_u2 vlan) 
{
  int_u2 voff = 0;
  int_u4 txopreg = TGSDDS_TXCFGREG_ADR;
  int ii;

  if (sdds_vlan(p,mport) != -1)        
    {
      vlan = ((vlan << 8) & 0xFF00) | ((vlan >> 8) & 0x00FF); /* Convert Little E To Big E */
      
      pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|0x0007,vlan,TGSDDS_NUM_PRG_BITS);       /* Generic Pkt VLan */    
      pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|0x0047,vlan,TGSDDS_NUM_PRG_BITS);       /* ARP Pkt VLan     */
      pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|0x0067,vlan,TGSDDS_NUM_PRG_BITS);       /* Pause Pkt VLan   */      
      pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|0x0087,vlan,TGSDDS_NUM_PRG_BITS);       /* IGMP Pkt VLan    */     
      pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|0x00C7,vlan,TGSDDS_NUM_PRG_BITS);       /* ICMP Pkt VLan    */     
      pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|0x00AC,vlan,TGSDDS_NUM_PRG_BITS);       /* Active VLan      */
    } 
     
  for(ii=0;ii<2;ii=ii+1)
    {
      if (ii==1)
        {
          voff    = 2;                     /* VLAN Offset For Write     */
          txopreg = TGSDDS_TXVCFGREG_ADR;  /* TX Dat DP Region Of Write */
        } 
  
     /* Set Tx IP Addresses    */
     /* SDDS Packet HW Address */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0003,0x6000,TGSDDS_NUM_PRG_BITS);                   /* Hi  Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0004,ip_addr,TGSDDS_NUM_PRG_BITS);                  /* Mid Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0005,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);          /* Low Word */
  
     /* SDDS Packet IP Address */ 
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x000D) + voff,ip_addr,TGSDDS_NUM_PRG_BITS);             /* Hi  Word */  
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x000E) + voff,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);     /* Low Word */
  
     /*  ARP Packet HW Address */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0043,0x6000,TGSDDS_NUM_PRG_BITS);                   /* Hi  Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0044,ip_addr,TGSDDS_NUM_PRG_BITS);                  /* Mid Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0045,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);          /* Low Word */

     /* ARP Packet HW Address  */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x004B) + voff,0x6000,TGSDDS_NUM_PRG_BITS);              /* Hi  Word */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x004C) + voff,ip_addr,TGSDDS_NUM_PRG_BITS);             /* Mid Word */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x004D) + voff,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);     /* Low Word */
 
     /* ARP Packet IP Address  */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x004E) + voff,ip_addr,TGSDDS_NUM_PRG_BITS);             /* Hi  Word */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x004F) + voff,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);     /* Low Word */  
  
     /* PAUSE Packet HW Address */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0063,0x6000,TGSDDS_NUM_PRG_BITS);                   /* Hi  Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0064,ip_addr,TGSDDS_NUM_PRG_BITS);                  /* Mid Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0065,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);          /* Low Word */

     /* IGMP Packet HW Address */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0083,0x6000,TGSDDS_NUM_PRG_BITS);                   /* Hi  Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0084,ip_addr,TGSDDS_NUM_PRG_BITS);                  /* Mid Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x0085,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);          /* Low Word */

     /* IGMP Packet IP Address */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x008D) + voff,ip_addr,TGSDDS_NUM_PRG_BITS);             /* Hi  Word */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x008E) + voff,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);     /* Low Word */  

     /* ICMP Packet HW Address */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x00C3,0x6000,TGSDDS_NUM_PRG_BITS);                   /* Hi  Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x00C4,ip_addr,TGSDDS_NUM_PRG_BITS);                  /* Mid Word */
      pic_wmodreg(p,mport,txopreg|TGTX_DATWRADDR|0x00C5,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);          /* Low Word */

     /* ICMP Packet IP Address */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x00CD) + voff,ip_addr,TGSDDS_NUM_PRG_BITS);             /* Hi  Word */
      pic_wmodreg(p,mport,(txopreg|TGTX_DATWRADDR|0x00CE) + voff,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);     /* Low Word */  
    }
      
 /* Set Rx IP Addresses   */
 /* ARP Rx IP Address     */ 
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x0004,ip_addr,TGSDDS_NUM_PRG_BITS);          /* Hi  Word */
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x0007,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);  /* Low  Word */

 /* ICMP Rx IP Address    */
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x0047,ip_addr,TGSDDS_NUM_PRG_BITS);          /* Hi  Word */
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x004A,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);  /* Low  Word */

 /* VLAN ARP Rx IP Addr   */ 
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x0084,ip_addr,TGSDDS_NUM_PRG_BITS);          /* Hi  Word */
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x0087,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);  /* Low  Word */

 /* VLAN ICMP Rx IP Addr  */
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x00C7,ip_addr,TGSDDS_NUM_PRG_BITS);          /* Hi  Word */
  pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CPUWRADDR|0x00CA,(ip_addr >> 16),TGSDDS_NUM_PRG_BITS);  /* Low  Word */

  return 0;
 }

/*--------------------------------------------------------------*/
int_4 pic_tgsxdr2_dump(PICSTRUCT *p, int_4 mport, int_u4 flag)
{
  int_u4 mjtrdval,ii;
  int_u4 phy_reg_adr[15] = { 0x021,0x022,0x041,0x042,0x044,0x061,0x063,0x064,
                             0x065,0x066,0x067,0x080,0x081,0x082,0x083 };
  
  printf("Port = %d\n",mport);
  for (ii=0;ii<15;ii++)  
    {  
      pic_wmodreg(p,mport,TGSDDS_PHYREG_ADR|phy_reg_adr[ii],0,TGSDDS_NUM_PRG_BITS);         
      pic_rmodreg(p,mport,0,&mjtrdval,TGSDDS_NUM_PRG_BITS);
      printf("Reg Adr = %x Value = %x\n",phy_reg_adr[ii],mjtrdval);
      udelay(1000);    
    }        
               
   pic_wmodreg(p,mport,TGSDDS_PHYREG_ADR|0x08000,0x00000001,TGSDDS_NUM_PRG_BITS);          
   pic_rmodreg(p,mport,0,&mjtrdval,TGSDDS_NUM_PRG_BITS);
   printf("Signals: Value = %x\n",mjtrdval);

   pic_rmodreg(p,mport,0x00010000,&mjtrdval,TGSDDS_NUM_PRG_BITS);
   printf("Nodes = %x\n",mjtrdval); 

   pic_rmodreg(p,mport,0x000D0000,&mjtrdval,TGSDDS_NUM_PRG_BITS);
   printf("Memory = %x\n",mjtrdval); 

   pic_rmodreg(p,mport,0x00030000,&mjtrdval,TGSDDS_NUM_PRG_BITS);
   printf("Error Status = %x\n",mjtrdval); 

   pic_rmodreg(p,mport,0x00040000,&mjtrdval,TGSDDS_NUM_PRG_BITS);
   printf("FPGA Version = %x\n",mjtrdval); 


   return(0);
}
/*--------------------------------------------------------------*/
int_4 tgsdds_synclk_cfg (PICSTRUCT *p, int_4 mport, int_u4 maddr, int_u4 value)
{   
  int_u4 mjtrdval;

   pic_wmodreg(p,mport,maddr,((value >> 8) & 0x000000FF),TGSDDS_NUM_PRG_BITS);         /* Set Register Address To Write */
   udelay(500);

   pic_wmodreg(p,mport,maddr,(value & 0x000000FF) | 0x00004000,TGSDDS_NUM_PRG_BITS);   /* Write Data To Register        */ 
   udelay(500);

   return(0);    
} 
/*--------------------------------------------------------------*/
int_4 pic_setup_tgsdds_clks(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 bits) 
{
#define TGSXDR1_PHYRATE   156250000.0   /* Predefines For 156.25    MHz Out Clk1 and Clk2 */
#define TGSXDR2_PHYRATE   644531250.0   /* Predefines For 644.53125 MHz Out Clk1 and Clk2 */

   Si5326_Reg_Obj Si5326_Reg; 
   int ii;
   int_u4 jj;
   float fcrate,bitmult; 
   int_u4 mjtrdval;

   int_u4 encfgval[2]  = {0,0};
   int_u4 enopval[2]   = {0,0};
   int_u4 cbcfgval[2]  = {0,0};
   int_u4 rstcfgval[2] = {0,0};
   int_u4 altport      = 0;
 
  /* Check PHY Clock Already Configured */ 
   pic_rmodreg (p,2,TGSDDS_MEMRDSEL|TGMEM_AMCC_ADR,&mjtrdval,TGSDDS_NUM_PRG_BITS);
  
   if (mjtrdval == 0)
     {    
      
      /* Powerdown Both Transceivers */
       if (p->mrev[mport-1] != 1)
         {
           pic_wmodreg(p,1,TGSDDS_PHYREG_ADR|TGPHY_REGSEL_BIT|TGPHY_WRSEL_BIT,
                           TGPHY_GXBPDN_BIT|TGPHY_PLLPDN_BIT|TGPHY_CALPDN_BIT,TGSDDS_NUM_PRG_BITS);
           pic_wmodreg(p,2,TGSDDS_PHYREG_ADR|TGPHY_REGSEL_BIT|TGPHY_WRSEL_BIT,
                           TGPHY_GXBPDN_BIT|TGPHY_PLLPDN_BIT|TGPHY_CALPDN_BIT,TGSDDS_NUM_PRG_BITS);

         }
   

       Si5326_Reg.debuglevel = -1;
       Si5326_Reg.fref       =  10000000.0; 
       if (p->mrev[mport-1] == 1)
         { 
           Si5326_Reg.dclk1  = TGSXDR1_PHYRATE;
           Si5326_Reg.dclk2  = TGSXDR1_PHYRATE;
         }
       else
         {           
           Si5326_Reg.dclk1  = TGSXDR2_PHYRATE;
           Si5326_Reg.dclk2  = TGSXDR2_PHYRATE;
         }
       Si5326_Reg.dwght1 = 1.0;
       Si5326_Reg.dwght2 = 1.0;   
       ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_TGSPHY);
       ii = si5326_regcfg_bwsel(&Si5326_Reg,7);       
       if (p->mrev[mport-1] == 1)
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_1);
       else
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);           
       ii = si5326_regcfg_dividers(&Si5326_Reg);
       if (ii != 0)
         printf("TGSDDS Warning: TGSDDS PHY rate not possible. Using %f\n",Si5326_Reg.fclk2);
       si5326_regcfg_debug(&Si5326_Reg);
       for(ii=0; ii<Si5326_Reg.numreg; ii++) 
         {
           if (((Si5326_Reg.regval[ii] & 0x0000FF00) == 0x00000600) && (p->mrev[mport-1] != 1))   /* Change To LVDS */
             Si5326_Reg.regval[ii] = 0x0000063F;
                      
           tgsdds_synclk_cfg(p,1,TGSDDS_XCLKCFGREG_ADR,Si5326_Reg.regval[ii]);                       
           udelay(1000);
         }
      
      /*  printf("Finished AnyRate Clock Setup\n"); */
       sleep(1);

      /* Set Flag For Clock Cfg Complete If Module Rev > 1 */ 
       if (p->mrev[mport-1] != 1)
         {
           pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR,0xFFFFFFFF,TGSDDS_NUM_PRG_BITS);  
                     
           for (jj=1;jj<=2;jj++)                                             /* Remove Xcvr Reset Both Module Sites  */                     
             { 
            
              /* Phy Configuration */              
               pic_wmodreg(p,jj,TGSDDS_STARTCFGREG_ADR,0x00000000,32);       /* Assert Hard Reset To PHY Device      */               
               pic_wmodreg(p,jj,TGSDDS_STARTCFGREG_ADR,0x00000001,32);       /* Remove Hard Reset To PHY Device      */  
                                                                                                        
              /* Power Down Calibration Block */ 
              /* pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|0x021|0x04000,0x00000001,TGSDDS_NUM_PRG_BITS); */ 

              /* Assert Rx & Tx Resets        */
               pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|0x044|0x04000,0x0000000E,TGSDDS_NUM_PRG_BITS); 
              /* pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|0x044,0,TGSDDS_NUM_PRG_BITS);     */     
              /* pic_rmodreg(p,jj,0,&mjtrdval,TGSDDS_NUM_PRG_BITS);                   */
              /* printf("1st 44 Port = %d Value = %x\n",jj,mjtrdval);                 */

              /* Remove Global Xcvr Powerdown */
               pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|TGPHY_REGSEL_BIT|TGPHY_WRSEL_BIT,TGPHY_PLLPDN_BIT|TGPHY_CALPDN_BIT,TGSDDS_NUM_PRG_BITS);
               udelay(4000);
               
              /* Remove PLL Powerdown         */
               pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|TGPHY_REGSEL_BIT|TGPHY_WRSEL_BIT,TGPHY_CALPDN_BIT,TGSDDS_NUM_PRG_BITS);
               udelay(4000);
               

              /* Remove Global Cal Powerdown  */
               pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|TGPHY_REGSEL_BIT|TGPHY_WRSEL_BIT,0,TGSDDS_NUM_PRG_BITS);
               udelay(4000);
               

              /* Power Up Calibration Block   */ 
              /*  pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|0x021|0x04000,0x00000000,TGSDDS_NUM_PRG_BITS); */  
               udelay(500);

              /* Remove Rx & Tx Resets        */
               pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|0x044|0x04000,0x00000000,TGSDDS_NUM_PRG_BITS); 
              /* pic_wmodreg(p,jj,TGSDDS_PHYREG_ADR|0x044,0,TGSDDS_NUM_PRG_BITS);  */       
              /* pic_rmodreg(p,jj,0,&mjtrdval,TGSDDS_NUM_PRG_BITS);                */ 
              /*  printf("2nd 44 Port = %d Value = %x\n",jj,mjtrdval);             */
                                                       
   
              /*MAC Configuration             */
          /*   printf("Finished Phy\n");
               sleep(10);       

              
               pic_wmodreg(p,jj,TGSDDS_MACREG_ADR|TGMAC_REGSEL_BIT|TGMAC_WRSEL_BIT,0,TGSDDS_NUM_PRG_BITS);                
               udelay(500);
               pic_wmodreg(p,jj,TGSDDS_MACREG_ADR|TGMAC_REGSEL_BIT|TGMAC_WRSEL_BIT,TGMAC_CFGRST_BIT,TGSDDS_NUM_PRG_BITS); 
               udelay(500);               
               pic_wmodreg(p,jj,TGSDDS_MACREG_ADR|TGMAC_REGSEL_BIT|TGMAC_WRSEL_BIT,TGMAC_CFGRST_BIT|TGMAC_RXRST_BIT|TGMAC_TXRST_BIT,
                           TGSDDS_NUM_PRG_BITS);
               printf("Finished MAC\n");          
               sleep(5);           
            
           */  
     
                            
             }           
         }   
     } 

       
  /* Output Clock Synthesizer */
   if (dir > 0)                                   
     {

      /* Retrieve Configuration */ 
       for(ii=0;ii<2;ii++)
         {
          /* Get Num Of Ports To Enable Request */
           pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_ENCFG_ADR,encfgval+ii,TGSDDS_NUM_PRG_BITS); 
          /* Get Ports Already Enabled          */
           pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_ENVAL_ADR,enopval+ii,TGSDDS_NUM_PRG_BITS);
          /* Get Crossbar Config                */
           pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_CBCFG_ADR,cbcfgval+ii,TGSDDS_NUM_PRG_BITS);      
          /* Get Reset Config                   */
           pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_RSTCFG_ADR,rstcfgval+ii,TGSDDS_NUM_PRG_BITS);
         }

#if DEBUG
       if ((rate < TGSDDS_MINOUT_FREQ) || (rate > TGSDDS_MAXOUT_FREQ))                     
         {
           printf("\n\nERR: TGSDDS PLL Freq Out of Range!!!\n");
           printf(" Valid Range = %d Mhz To %d MHz\n",(int_u4)((TGSDDS_MINOUT_FREQ*8)/1e6),(int_u4)((TGSDDS_MAXOUT_FREQ*8)/1e6));                              
           return(-1);             
         }     
#endif  

    

      /* Compute Rate Of AnyRate Freq                              */  
      /* Find Bit Divide (Multiply) And 8 Byte Wide Path Frequency */ 
       bitmult =  (float)(64.0/((float)bits));
       fcrate  =  ((float) ((float)rate)/bitmult);
       jj = (int_u4) fcrate;       /* int Value Of Frequency */                       

      /* Get Alternate Port */      
       altport = mport % 2;     /* Alternate Port = 0 When Port 2 Current Port, Alternate Port = 1, When Port 1 Current Port */
      
      /* Check Alt Port Active And In Output Mode */ 
       if ((enopval[altport] != 0) && ((rstcfgval[altport] & TGSYS_ACQUIRE_BIT) == 0))
         {     
            pic_rmodreg (p,2,TGSDDS_MEMRDSEL|TGMEM_OCLKFREQ_ADR,&mjtrdval,TGSDDS_NUM_PRG_BITS); 
            if (mjtrdval != 0)
              {                   
                if (mjtrdval != jj)
                  {
                    printf("ERR: Alternate Port In Use As Output With Different Clock Rate\n");
                    printf("ERR: Dual Outputs Must Be Run At The Same Rate\n");
                    return(-1);
                  }
                else
                  return(0);  /* Output Clock Rates Equal, Return Without Configuration Of AnyRate */  
              }
         } 
             
      /* Store In Mem Freq Of AnyRate Part */  
       pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|TGMEM_OCLKFREQ_ADR,jj,TGSDDS_NUM_PRG_BITS);
               
       Si5326_Reg.debuglevel = -1;
       Si5326_Reg.fref   =  10000000.0;
       Si5326_Reg.dclk1  = ((real_8) fcrate);
       Si5326_Reg.dclk2  = ((real_8) fcrate);
       Si5326_Reg.dwght1 = 1.0;
       Si5326_Reg.dwght2 = 1.0;   
       ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_TGSDAT);
       ii = si5326_regcfg_bwsel(&Si5326_Reg,7); 
       if ((p->mrev[mport-1] == 1) ||  (findflag("PREFX",p->config) >= 0))     
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_1);
       else
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);            
       ii = si5326_regcfg_dividers(&Si5326_Reg);
       if (ii != 0)
         printf("TGSDDS Warning: TGSDDS Output rate not possible. Using %f\n",Si5326_Reg.fclk2 * bitmult);
       si5326_regcfg_debug(&Si5326_Reg);
       for(ii=0; ii<Si5326_Reg.numreg; ii++) 
         {
           tgsdds_synclk_cfg(p,1,TGSDDS_DCLKCFGREG_ADR,Si5326_Reg.regval[ii]);           
           udelay(1000);
         }
       sleep(1);
     }  

  return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_dualwAMCCreg(PICSTRUCT *p, int_4 mport, int_u4 adr, int_u4 val) 
{
  pic_wmodreg(p,1,TGSDDS_GLBAMCFGREG_ADR,0x00020000 | ((adr & 0x001F0000)<<2) | (adr & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); /* Set Adr */
  udelay(500); 
  pic_wmodreg(p,1,TGSDDS_GLBAMCFGREG_ADR,0x10020000 | ((adr & 0x001F0000)<<2) | (val & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); /* Wr Data */
  udelay(500);
 
  return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_wAMCCreg(PICSTRUCT *p, int_4 mport, int_u4 adr, int_u4 val) 
{
  pic_wmodreg(p,mport,TGSDDS_AMCCCFGREG_ADR,0x00020000 | ((adr & 0x001F0000)<<2) | (adr & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); /* Set Adr */
  udelay(500);  
  pic_wmodreg(p,mport,TGSDDS_AMCCCFGREG_ADR,0x10020000 | ((adr & 0x001F0000)<<2) | (val & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); /* Wr Data */
  udelay(500); 
 
  return(0);
}
/*--------------------------------------------------------------*/
int_u2 pic_rAMCCreg(PICSTRUCT *p, int_4 mport, int_u4 adr)
{   
  int_u4 mjtrdval = 0;

  pic_wmodreg(p,mport,TGSDDS_AMCCCFGREG_ADR,0x00020000 | ((adr & 0x001F0000)<<2) | (adr & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); /* Set Adr */
  udelay(1000);
  pic_wmodreg(p,mport,TGSDDS_AMCCCFGREG_ADR,0x30030000|((adr & 0x001F0000)<<2),TGSDDS_NUM_PRG_BITS);                       /* Rd Data */
  udelay(1000);

 /* Address 0x00000000 Read Port 1, Address 0x00010000 Read Port 2   */ 
  pic_rmodreg (p,2,0x00010000 & ((mport-1)<<16),&mjtrdval,TGSDDS_NUM_PRG_BITS);     
  
 /* printf("Module Read Value = %x \n",mjtrdval); */ 
 
  return((int_u2)mjtrdval);
}
/*--------------------------------------------------------------*/
int_4 pic_enable_tgsxdr1(PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{
  int_u4 ii;
  int_u4 txopreg;
  int_u4 mjtrdval;
  int_u4 encfgval[2]  = {0,0};
  int_u4 enopval[2]   = {0,0};
  int_u4 cbcfgval[2]  = {0,0};
  int_u4 rstcfgval[2] = {0,0};
  int_u4 cbrstval[2]  = {0,0};

  udelay(5000);
  for(ii=0;ii<2;ii++)
    {
     /* Get Num Of Ports To Enable Request */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_ENCFG_ADR,encfgval+ii,TGSDDS_NUM_PRG_BITS); 
     /* Get Ports Already Enabled          */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_ENVAL_ADR,enopval+ii,TGSDDS_NUM_PRG_BITS);
     /* Get Crossbar Config                */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_CBCFG_ADR,cbcfgval+ii,TGSDDS_NUM_PRG_BITS);      
     /* Get Reset Config                   */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_RSTCFG_ADR,rstcfgval+ii,TGSDDS_NUM_PRG_BITS);
     /* Get Crossbar Reset                 */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_CBRST_ADR,cbrstval+ii,TGSDDS_NUM_PRG_BITS);          
    }
/*
  printf("*******************************\n");
  if (dis_enable == 0)
     printf("Mport = %d DISABLE\n",mport);
  else
     printf("Mport = %d ENABLE\n",mport);  
  for(ii=0;ii<2;ii++)
    { 
      printf("Port Value = %d\n",ii);  
      printf("Requested Port     Enable Value = %08x\n",encfgval[ii]);
      printf("Current   Port     Enable Value = %08x\n",enopval[ii]);  
      printf("Current   Crossbar Enable Value = %08x\n",cbcfgval[ii]);
      printf("Current   Reset           Value = %08x\n",rstcfgval[ii]);
    } 
  printf("*******************************\n");
*/
  if (dis_enable == 0)
    {     
       if (mport == 1)
        {                   
         /* Check Opposite Port Already Enabled        */  
          if (((rstcfgval[1] & TGSYS_GLBRESET_BIT) != 0) && (enopval[1] != 0))
            {
              printf("Err: Port/Module 1 Resource In Use By Module 2--Disable Not ALlowed\n");
              printf("Err: Stop Port 2 Use Before Disable Of Module 1 \n");
              return(-1);  
            }                                       
        }
      else
        {                           
         /* Check Opposite Port Already Enabled        */  
          if (((rstcfgval[0] & TGSYS_GLBRESET_BIT) != 0) && (enopval[0] != 0))
            {
              printf("Err: Port/Module 2 Resource In Use By Module 1--Disable Not ALlowed\n");
              printf("Err: Stop Port 1 Use Before Disable Of Module 2 \n");
              return(-1);  
            }          
        }   

      pic_wmodreg(p,mport,TGSDDS_ENDISCFGREG,0x00000000,TGSDDS_NUM_PRG_BITS);                         /* Disable Reg                 */
      pic_wmodreg(p,mport,TGSDDS_SYSCFGREG_ADR,0x00000000,TGSDDS_NUM_PRG_BITS);                       /* Disable ICE LVDS Interface  */
      pic_wmodreg(p,mport,TGSDDS_CBRSTREG_ADR,0x00000000,TGSDDS_NUM_PRG_BITS);                        /* Reset Crossbar              */
      pic_wmodreg(p,mport,TGSDDS_SYSCFGREG_ADR,0x00000000,TGSDDS_NUM_PRG_BITS);                       /* Disable ICE LVDS Interface  */
      pic_wmodreg(p,mport,TGSDDS_CBCFGREG_ADR,0x00000000,TGSDDS_NUM_PRG_BITS);                        /* Clear CB Cfg Values         */ 
        
      pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|(mport*TGMEM_CHAN_OFF)|TGMEM_ENVAL_ADR,0,TGSDDS_NUM_PRG_BITS); /* Change En Val In Mem */
      
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|TGMEM_VLAN_ADR,&mjtrdval,TGSDDS_NUM_PRG_BITS);        
      if (mjtrdval == 0)        
        txopreg = TGSDDS_TXCFGREG_ADR;    /* Non-VLAN */        
      else        
        txopreg = TGSDDS_TXVCFGREG_ADR;   /* VLAN     */          
        

     /* Leave All Joined Addresses-Do Twice To Be Sure Router Gets Info */
      for (ii=0;ii<2;ii++)
        {     
          pic_wmodreg(p,mport,txopreg|TGTX_DATRDADDR|0x00AF,32,TGSDDS_NUM_PRG_BITS);    /* Write Address To Leave ALL */ 
          udelay(10000);         
        } 
   
    } 
  else
    {        
      
     
      if (mport == 1)
        {                   
         /* Check Opposite Port Already Enabled        */  
          if (((rstcfgval[0] & TGSYS_GLBRESET_BIT) != 0) && (enopval[1] != 0))
            {
              printf("Err: Port/Module 2 In Use, Acquisition Requires Resources Of Both Modules\n");
              printf("Err: Stop Port 2 Use And Re-Start Module 1 Input/Output \n");
              return(-1);  
            }
          else if (((rstcfgval[1] & TGSYS_GLBRESET_BIT) != 0) && (enopval[1] != 0))
            {
              printf("Err: Port/Module 1 Already In Use By Module 2 Data Transfer\n");
              printf("Err: Stop Port 2 Use And Re-Start Module 0 Data Transfer\n");
              return(-1);  
            }  
          
           /* if ((encfgval[0] & TGEN_DUAL_BIT) != 0)                       */
           /*  pic_wmodreg(p,2,TGSDDS_CBCFGREG_ADR,0,TGSDDS_NUM_PRG_BITS);  */                  /* Disable Crossbar On B Side */                   
        }
      else
        {                        
          
   
         /* Check Opposite Port Already Enabled        */  
          if (((rstcfgval[1] & TGSYS_GLBRESET_BIT) != 0) && (enopval[0] != 0))
            {
              printf("Err: Port/Module 1 In Use, Acquisition Requires Resources Of Both Modules\n");
              printf("Err: Stop Port 1 Use And Re-Start Module 2 Input/Output \n");
              return(-1);  
            }
          else if (((rstcfgval[0] & TGSYS_GLBRESET_BIT) != 0) && (enopval[0] != 0))
            {
              printf("Err: Port/Module 2 Already In Use By Module 1 Data Transfer\n");
              printf("Err: Stop Port 1 Use And Re-Start Module 2 Data Transfer\n");
              return(-1);  
            }  
          
           /* if ((encfgval[1] & TGEN_DUAL_BIT) != 0)                        */
           /*  pic_wmodreg(p,1,TGSDDS_CBCFGREG_ADR,0,TGSDDS_NUM_PRG_BITS);   */                 /* Disable Crossbar On A Side */
        }   

      pic_wmodreg(p,mport,TGSDDS_ENDISCFGREG,0x00000000,TGSDDS_NUM_PRG_BITS);                   /* Disable Single Port        */
      pic_wmodreg(p,mport,TGSDDS_SYSCFGREG_ADR,rstcfgval[mport-1],TGSDDS_NUM_PRG_BITS);         /* Enable ICE LVDS Interface  */
      pic_wmodreg(p,mport,TGSDDS_CBCFGREG_ADR,cbcfgval[mport-1],TGSDDS_NUM_PRG_BITS);           /* Set Crossbar Config        */
      pic_wmodreg(p,mport,TGSDDS_CBRSTREG_ADR,cbrstval[mport-1],TGSDDS_NUM_PRG_BITS);           /* Release Crossbar Reset     */

      pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|(mport*TGMEM_CHAN_OFF)|TGMEM_ENVAL_ADR,1,TGSDDS_NUM_PRG_BITS); /* Set En Val In Mem   */ 
      pic_wmodreg(p,mport,TGSDDS_ENDISCFGREG,encfgval[mport-1],TGSDDS_NUM_PRG_BITS);  


  /*    sleep(2);
      printf("PMA-PMD Control           1.0000 Reg = %x\n",pic_rAMCCreg(p,mport,0x00010000)); 
      printf("WIS MODE                  1.C319 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C319));
      printf("CLK RATE                  1.C302 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C302));
      printf("LAN MODE                  1.C31A Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C31A));
      printf("XAUI Lane Synchronization 4.0018 Reg = %x\n",pic_rAMCCreg(p,mport,0x00040018));
      printf("Speed Selection           4.0000 Reg = %x\n",pic_rAMCCreg(p,mport,0x00040000));
      printf("XAUI CDR LOCK             4.C000 Reg = %x\n",pic_rAMCCreg(p,mport,0x0004C000));
      printf("PCS Control               3.0000 Reg = %x\n",pic_rAMCCreg(p,mport,0x00030000));
      printf("PMA-PMD Control           1.0000 Reg = %x\n",pic_rAMCCreg(p,mport,0x00010000));
  
      printf("                          1.D004 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001D004));
      printf("                          1.D004 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001D004));
      printf("                          3.0021 Reg = %x\n",pic_rAMCCreg(p,mport,0x00030021));
      printf("                          1.C301 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C301));
      printf("PMA Vendor Specific       1.C001 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C001));   
      printf("PMA Vendor Specific       1.C001 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C001));
  
      printf("                          1.C030 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C030));
      printf("                          1.C031 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C031));
      printf("MODE Reg                  1.C301 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C301));      
 */
                   
     /* printf("Pause Capable Mport = %d Value = %04x\n",mport,pic_rAMCCreg(p,mport,0x00070010)); */

     /* EREFCLK/SREFCLK SELECTION */ 
     /* printf("EREFCLK-SREFCLK SELECTION 1.C001 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C001));   */    
     /* pic_wAMCCreg(p,mport,0x0001C001,pic_rAMCCreg(p,mport,0x0001C001) | 0x00000200);           */  



     /*   PMA-PMD SYSTEM LOOPBACK */    
     /* pic_wAMCCreg(p,mport,0x00010000,pic_rAMCCreg(p,mport,0x00010000) | 0x00000001);           */                         
     /* printf("PMA-PMD Control           1.0000 Reg = %x\n",pic_rAMCCreg(p,mport,0x00010000));   */                  

     /* PMA TEST PATTERN  */    
     /* pic_wAMCCreg(p,mport,0x0001C030,pic_rAMCCreg(p,mport,0x0001C030) | 0x00000080);           */ 
     /* printf("PMA Test Pattern          1.C030 Reg = %x\n",pic_rAMCCreg(p,mport,0x0001C030));   */


     /*   PCS SYSTEM LOOPBACK */    
     /* pic_wAMCCreg(p,mport,0x00030000,pic_rAMCCreg(p,mport,0x00030000) | 0x00004000);           */
     /* printf("PCS Control               3.0000 Reg = %x\n",pic_rAMCCreg(p,mport,0x00030000));   */ 
             

     /*   XGXS SYSTEM LOOPBACK */    
     /* pic_wAMCCreg(p,mport,0x0004C000,pic_rAMCCreg(p,mport,0x0004C000) | 0x00004000);            */  
     /* printf("XAUI CDR LOCK             4.C000 Reg = %x\n",pic_rAMCCreg(p,mport,0x0004C000));    */     
      
    }

  return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_initAMCC_tgsdds(PICSTRUCT *p)
{
  int_u4 ii,jj;
  char fname[MAXFNAME];
  FILE *file;
  int_u1 *fbdat;
  int status;
  int_u2 rvalamcc = 0;
  int szfirmware = 0;

 /* Get Path/Open AMCC Firmware File */ 
  if (getpath (fname,"dat") == 0)
    return(-1);
  strcat(fname,"tgsamcc.bin");
  file = fopen (fname,"rb");
  if (file == NULL)
    {
      printf("Error opening AMCC firmware file: %s\n",fname);
      return(-1);
    }

 /* Allocate Firmware Buffer */ 
  fbdat = malloc(TGSDDS_AMCC_CODE_SZ * sizeof(int_u1));
  if (fbdat == NULL)
    {
       printf("malloc() Of AMCC Data Buffer Failed!\n");
       fclose(file);
       return(-1);
    }

 /* Read Firmware File */ 
  szfirmware = fread (fbdat,1,TGSDDS_AMCC_CODE_SZ * sizeof(int_u1),file);   
  if (szfirmware == 0)            /* (TGSDDS_AMCC_CODE_SZ * sizeof(int_u1))) */
    {
      printf("fread() Of AMCC Firmware File Failed!\n");
      fclose(file);
      free(fbdat); 
      return(-1);
    }
  
 /* printf("Firmware Size = %d\n",szfirmware);  */

  fclose(file); 

 /* Program Both Modules Sites*/ 
  for (jj=1;jj<=2;jj++)                     
    {
     /* Assert Hard Reset To AMCC Device */
      pic_wmodreg(p,jj,TGSDDS_STARTCFGREG_ADR,0x00000000,32);       
     /* Remove Hard Reset To AMCC Device */
      pic_wmodreg(p,jj,TGSDDS_STARTCFGREG_ADR,0x00000001,32); 
    }    
      pic_dualwAMCCreg(p,jj,0x0001C300,0x0000);   
      pic_dualwAMCCreg(p,jj,0x0001C302,0x0004);
      pic_dualwAMCCreg(p,jj,0x0001C319,0x0008);
      pic_dualwAMCCreg(p,jj,0x0001C31A,0x0098);
      pic_dualwAMCCreg(p,jj,0x00030026,0x0E00);
      pic_dualwAMCCreg(p,jj,0x00030027,0x0093);
      pic_dualwAMCCreg(p,jj,0x00030028,0xA528);          
      pic_dualwAMCCreg(p,jj,0x0001C300,0x0002);
      pic_dualwAMCCreg(p,jj,0x0003E854,0x00C0);


      for(ii=0;ii<0x0004000;ii++)                                    /* Program 16K Locations */ 
        pic_dualwAMCCreg(p,jj,0x00038000+ii,(int_u4)(*(fbdat+ii)));

     /* for(ii=0;ii<0x0002000;ii++)     */                                
      for(ii=0;ii<(szfirmware - 0x0004000);ii++)                     /* Program  8K Locations */
        pic_dualwAMCCreg(p,jj,0x00048000+ii,(int_u4)(*(fbdat+ii+0x0004000)));

       
     /* Start Micro      */
      pic_dualwAMCCreg(p,jj,0x0003E854,0x0040); 
    
 /* Program Both Modules Sites*/ 
  for (jj=1;jj<=2;jj++)                     
    {
     /* Check Heart Beat */
      for(ii=0;ii<10;ii++)
        {
           rvalamcc = pic_rAMCCreg(p,jj,0x0003D7EE);
           if (rvalamcc == pic_rAMCCreg(p,jj,0x0003D7EE))
             {
               printf("Port = %d AMCC HeartBeat Test Failed \n",jj);
               free(fbdat);
               return(-1);
             }
        }                   
    }

   free(fbdat);

   for(jj=1;jj<=2;jj++)               /* &BILL */
     {
       rvalamcc = 0x0000; 
       ii = 0;
       while (((rvalamcc == 0x0000) ||  (rvalamcc == 0x0010)) && (ii<1000))
         {
            udelay(5000);            
            rvalamcc = pic_rAMCCreg(p,jj,0x0003D7FD) & 0x00FF;
            ii = ii+1;
         } 
       if (ii<1000)
         printf("10GBE Firmware Load Successful For Port %d\n",jj); 
       else
         printf("Port = %d 10GBE HeartBeat Test And/Or Init Test Failed \n",jj);

      /* Disabe Tx Differential Line Swap */                  
       pic_wAMCCreg(p,jj,0x0001C301,pic_rAMCCreg(p,jj,0x0001C301) & 0x0000FF7F);          
      /* printf("After Read Of Register = %x\n",pic_rAMCCreg(p,jj,0x0001C301));     */
 
       udelay(5000);
      /* Autonegotiate Pause Frame Enable */ 
       pic_wAMCCreg(p,jj,0x00070010,pic_rAMCCreg(p,jj,0x00070010) | 0x00000C00);     /* Set Asym Pause Frame    */
     /*  printf("Pause Capable Mport = %d Value = %04x\n",jj,pic_rAMCCreg(p,jj,0x00070010));  */
       pic_wAMCCreg(p,jj,0x00070000,pic_rAMCCreg(p,jj,0x00070000) | 0x00000200);     /* Restart Autonegotiation */
     /*  printf("Pause Capable Mport = %d Value = %04x\n",jj,pic_rAMCCreg(p,jj,0x00070010));    */      
     } 
  
  return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_init_tgsdds (PICSTRUCT *p) 
{
  int_u4 mjtrdval=0;
  sleep(1);
  
  pic_setup_tgsdds_clks(p, 1, -1 ,1e6, 0);
  udelay(100000);
  pic_rmodreg (p,2,0x00020000,&mjtrdval,32);
  if (mjtrdval == 0) 
    {        
      /* Load AMCC Firmware-Both Ports        */
       if (pic_initAMCC_tgsdds(p) < 0) 
         printf("AMCC Load Failed\n");
      /* Set Flag For AMCC/Clock Cfg Complete */
       pic_wmodreg(p,2,0x00020000,0xFFFFFFFF,32);      
    }
  return 0;
}
/*--------------------------------------------------------------*/
int_4 init_addrvlan_regs(PICSTRUCT *p, int_4 mport,int_u4 *modaddr,int_4 *modvlan)
 {
  int_u4 ii;
 
  int_u2 txnsin[18]   = {0xECAA, 0x00B0, 0xF05E, 0xFCAB, 0x00B1, 0xF081, 0xECAA, 0x00B3, 0xF064,
                         0xFCAB, 0x00B4, 0xF081, 0xECAA, 0x00B6, 0xF06A, 0xFCAB, 0x00B7, 0xF081};                     
  int_u2 txvlnsin[27] = {0xECAA, 0x00B0, 0xF054, 0xECAB, 0x00B1, 0xF054, 0xFCAC, 0x00B2, 0xF07D,
                         0xECAA, 0x00B3, 0xF05D, 0xECAB, 0x00B4, 0xF05D, 0xFCAC, 0x00B5, 0xF07D, 
                         0xECAA, 0x00B6, 0xF066, 0xECAB, 0x00B7, 0xF066, 0xFCAC, 0x00B8, 0xF07D};
  
  /* Clear 4 Group Join Addresses */
   for(ii=0;ii<4;ii++)   /* Write Default Clear Values */
     {
      /*Non-VLAN */  
       pic_wmodreg(p,mport,TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR|(0x00AD +(ii*3)),0xFFFF,TGSDDS_NUM_PRG_BITS); 
       pic_wmodreg(p,mport,TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR|(0x00AE +(ii*3)),0xFFFF,TGSDDS_NUM_PRG_BITS);
       pic_wmodreg(p,mport,TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR|(0x00AF +(ii*3)),0x0000,TGSDDS_NUM_PRG_BITS); 

      /* VLAN    */
       pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|(0x00AD +(ii*3)),0xFFFF,TGSDDS_NUM_PRG_BITS); 
       pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|(0x00AE +(ii*3)),0xFFFF,TGSDDS_NUM_PRG_BITS);
       pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR|(0x00AF +(ii*3)),0x0000,TGSDDS_NUM_PRG_BITS); 
     }  
   
   /* IP Address Configuration   */
   if (mport == 1)   
     *modaddr = convert_ip_addr2("IPADDR1","IPADDR",p->config);
   else    
     *modaddr = convert_ip_addr2("IPADDR2","IPADDR",p->config);
   
   if (*modaddr == 0) *modaddr = SDDS_DEFAULT_MODULE_IP_ADDR;

   /* Check If VLAN Mode Enabled */
   *modvlan = sdds_vlan(p,mport);
      
   if (*modvlan == -1)         
     { /* VLAN Not Present */
                  
      pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|TGMEM_VLAN_ADR,0x00000000,TGSDDS_NUM_PRG_BITS);
  
     /* Write Non_VLAN, Non-Strict Instructs To Tx CPU */     
      for (ii=0x58;ii<0x6A;ii++)
        {
          pic_wmodreg(p,mport,TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR|ii,txnsin[ii-0x58],TGSDDS_NUM_PRG_BITS);         
          udelay(100);    
        }        
     }
   else
     { /* VLAN Present     */
     
       pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|TGMEM_VLAN_ADR,0x00000001,TGSDDS_NUM_PRG_BITS);

      /* Write VLAN, Non-Strict Instructs To Tx CPU */
      /* Change Tx Instructs  */
       for (ii=0x4B;ii<0x66;ii++)
         {          
           pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR|ii,txvlnsin[ii-0x4B],TGSDDS_NUM_PRG_BITS);   
           udelay(100);    
         }      
     }  

  TGset_module_HW_IP_addr(p,mport,*modaddr,(int_u2)(*modvlan)); 

  return(0);
 }

/*--------------------------------------------------------------*/
int_4 pic_setup_tgsdds(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 bits, int_4 ports) 
{

/* #define TGSDDS_LGPKT_DEFSZ   8284  */ /* 8192 + 64 + 8 + 20 */
/* #define TGSDDS_LGPKT_DEFSZ   2108  */ /* 2048 + 32 + 8 + 20 */ 
 
#define   TGSDDS_LGPKT_HDRSZ   32
#define   TGSDDS_PKT_HDRSZ     56 
#define   TGSDDS_LGPKT_DEFSZ   2080 /* Size UDP Data + Header Data (2048 + 32) */
#define   TGSDDS_PKT_DEFSZ     1080 /* Size UDP Data + Header Data (1024 + 56) */  
  int    jj,xx;
  int_u4 ii,kk,mm; 
  int_u4 mjtrdval     = 0;
  int_u4 fpgaversion  = 0; 
  int_u4 ip_addr      = 0;
  int_u4 rxcfgval     = 0;
  int_u4 txcfgval     = 0;
  int_u4 enopval[2]   = {0,0};
  int_u4 cbrstval[2]  = {TGCB_RESET_BIT,TGCB_RESET_BIT};
  int_u4 cbcfgval[2]  = {TGCB_DEFMODE_BIT,TGCB_DEFMODE_BIT}; 
  int_u4 encfgval[2]  = {TGEN_DUAL_BIT|TGEN_SINGLE_BIT,TGEN_DUAL_BIT|TGEN_SINGLE_BIT};
  int_u4 rstcfgval[2] = {TGSYS_ACQUIRE_BIT|TGSYS_GLBACQUIRE_BIT|TGSYS_RESET_BIT|TGSYS_GLBRESET_BIT,
                         TGSYS_ACQUIRE_BIT|TGSYS_GLBACQUIRE_BIT|TGSYS_RESET_BIT|TGSYS_GLBRESET_BIT};
  int_u4 modaddr      = 0;
  int_u4 portnum      = 0;
  int_4  modvlan;
  int_u2 tx_offset    = 2;     /* 2 Extra 16 Bit Words For VLAN Support */
  int_u2 ip_hdr[10]   = {0x0045, 0x5404, 0x0000, 0x0080, 0x1140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000};

  int_u2 txsin[18]    = {0xFCAD, 0x00BE, 0xF063, 0xFABD, 0x9101, 0xFAAD, 0x9302, 0xFABA, 0x8F02,
                         0xFD63, 0xF0B2, 0xFAAA, 0xAD02, 0xF081, 0x0000, 0x0000, 0x0000, 0x0000};

                   /*       4B    4C      4D      4E      4F       50     51      52      53  */
  int_u2 txvlsin[27]  = {0xFCAD, 0x00BE, 0xF058, 0xFAAF, 0x8701, 0xFABD, 0x9301, 0xFABA, 0x9102,
                   /*       54     55      56     57       58  */
                         0xFAAD, 0x9502, 0xFD58, 0xF0BC, 0xFAAA, 0xAD03, 0xF07D, 0x0000, 0x0000, 
                         0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}; 


  char flgname[20];
  int_u1 def = 1;
  int_4  retval = 0,flagval; 
  int_u4 testpktipg = 0x000003AA;    /* 150 MB/Sec Test Output Rate, Lowest Rate Possible */ 
  int_u4 mvdatsz    = 0x0000007F;    /* Size Of Data Portion Of Pkt (512/4) -1            */ 
  char   *hwadr;                     /* Hardware Address String                           */
  int_u4 hwadrval;                   /* Hardware Address Value                            */                  
  
  int_u4 udp_pktsz,udp_hdrsz; 
  int_u2 udpchksum[6];
    
             
 /* Check AMCC Firmware Already Loaded       */   
  pic_rmodreg (p,2,TGSDDS_MEMRDSEL|TGMEM_AMCC_ADR,&mjtrdval,TGSDDS_NUM_PRG_BITS);
  if (mjtrdval == 0)
    {
     /* Load AMCC Firmware-Both Ports        */ 
      if (pic_initAMCC_tgsdds(p) < 0)
        return(-1);

     /* Set Flag For AMCC/Clock Cfg Complete */
      pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR,0xFFFFFFFF,TGSDDS_NUM_PRG_BITS);           
    }

  /* Read FPGA Version--See If Large Pkt  */
   if (p->mrev[mport-1] != 1)
     pic_rmodreg(p,mport,0x00040000,&fpgaversion,32);
   fpgaversion = fpgaversion & 0xFFFF0000;

   if (fpgaversion == TG_LARGEPKT_DLD)             /* Standard Large Pkt Size Download   */
     {
       udp_pktsz = TGSDDS_LGPKT_DEFSZ;      
       udp_hdrsz = TGSDDS_LGPKT_HDRSZ;
     }
   else 
     {
       udp_pktsz = TGSDDS_PKT_DEFSZ;
       udp_hdrsz = TGSDDS_PKT_HDRSZ;
       fpgaversion = TG_STANDARDPKT_DLD;           /* Standard SDDS  Pkt Size Download   */       
     }

   
   jj = findintflag("RXUDPHDRSZ",p->config);
   if (jj > 0)
     udp_hdrsz = jj; 

   jj = findintflag("RXUDPPKTSZ",p->config);
   if (jj > 0)
     udp_pktsz = jj; 
       
   pic_wmodreg(p,mport,TGSDDS_MACREG_ADR,udp_pktsz+8+20,TGSDDS_NUM_PRG_BITS);  /* Init Pkt Size, Add UDP Hdr, Add IP Hdr */


  for(ii=0;ii<2;ii++)
    { 
     /* Get Ports Already Enabled          */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_ENVAL_ADR,enopval+ii,TGSDDS_NUM_PRG_BITS);
          
     /* Get Reset Config                   */
      pic_rmodreg (p,2,TGSDDS_MEMRDSEL|((ii+1)*TGMEM_CHAN_OFF)|TGMEM_RSTCFG_ADR,rstcfgval+ii,TGSDDS_NUM_PRG_BITS);
    }
  if (mport == 1)
    {    
     /* Check Opposite Port Already Enabled Needed Port */                     
      if (((rstcfgval[1] & TGSYS_GLBRESET_BIT) != 0) && (enopval[1] != 0))
        {
          printf("Err: Port/Module 1 Already In Use By Module 2 Data Transfer\n");
          printf("Err: Stop Port 2 Use And Re-Start Module 0 Data Transfer\n");
          return(-1);  
        }                                        
    }
  else
    {                           
     /* Check Opposite Port Already Enabled Needed Port */  
      if (((rstcfgval[0] & TGSYS_GLBRESET_BIT) != 0) && (enopval[0] != 0))
        {
          printf("Err: Port/Module 2 Already In Use By Module 1 Data Transfer\n");
          printf("Err: Stop Port 1 Use And Re-Start Module 2 Data Transfer\n");
          return(-1);  
        }                 
    }
  
 /* Initialize Regs And Dual Port Mem For Port */
  init_addrvlan_regs(p,mport,&modaddr,&modvlan);

 /* VLAN Not Present */ 
  if (modvlan == -1)         
    tx_offset = 0;             

 /* Set Crossbar Functions      */ 
  if ((ports == 1) || (ports == 2)) 
    {
      cbcfgval[mport-1]  = TGCB_SLOWMODE_BIT;
      encfgval[mport-1]  = TGEN_SINGLE_BIT;
      rstcfgval[mport-1] = TGSYS_RESET_BIT;
      retval = 1;
    }
  else if (ports == 3)
    { 
      cbcfgval[mport-1]  = TGCB_RAWMODE_BIT | ((abs(bits)/8) << 6);
      rstcfgval[mport-1] = TGSYS_RESET_BIT|TGSYS_GLBRESET_BIT;                         
      retval = 3;
      if (mport == 2)
        {
          printf("Err: Flag TGPORTS=3 Only Valid For Module Port 1 -Not Module Port 2\n");
          return(-1);
        }  
    }
  else 
    { 
      cbcfgval[mport-1]  = TGCB_DEFMODE_BIT | ((abs(bits)/8) << 6);
      rstcfgval[mport-1] = TGSYS_RESET_BIT|TGSYS_GLBRESET_BIT; 
      retval = 0;
      if (mport == 2)
        {
          printf("Err: Flag TGPORTS=0 Only Valid For Module Port 1-NOT Module Port 2\n");
          return(-1);
        }
    }

 /* Setup Potential Output Clock             */
  if ((retval == 3) && (p->mrev[mport-1] != 1))
    {
      if (pic_setup_tgsdds_clks(p,mport,dir,rate/2,bits) != 0)   /* Special Case For retval=3 Rev 2 Output */
        return(-1); 
    } 
  else
    {
      if (pic_setup_tgsdds_clks(p,mport,dir,rate,bits) != 0)
        return(-1); 
    } 

 /* Reset Debug Interface */   /* &BILL */
  pic_wmodreg(p,mport,TGSDDS_DBGRST_ADR,1,TGSDDS_NUM_PRG_BITS);
  


 /* Rx Logic Configuration Code */ 
  if (dir <= 0) 
    { 

     /* Set Acquire Bit For Acquisition */
      rstcfgval[mport-1] = rstcfgval[mport-1] | TGSYS_ACQUIRE_BIT;
      if ((ports != 1) && (ports != 2)) 
        rstcfgval[mport-1] = rstcfgval[mport-1] | TGSYS_GLBACQUIRE_BIT;

     /* Align Channels                  */        
      if (findflag("RXCHALIGN",p->config) >= 0)
        cbcfgval[mport-1] = cbcfgval[mport-1] | TGCB_ALIGNMODE_BIT; 

     /* Pause Frame Insertion Enable    */ 
      if (findflag("ENPFRAME",p->config) >= 0)        
        cbcfgval[mport-1]  = cbcfgval[mport-1] | TGCB_ENPAUSE_BIT; 

     /* Bring Data Through DDR3         */       
      if (p->mrev[mport-1] != 1) 
        {
          if (findflag("RXNOMEMBUF",p->config) < 0)   
            rxcfgval = rxcfgval | TGRX_MEMBUFF_BIT;
        }  
        
      if (findflag("RXRAWBITS",p->config) >= 0)
        {
          rxcfgval = rxcfgval | TGRX_RAWBITS_BIT;
          cbcfgval[mport-1]  = cbcfgval[mport-1] & (~TGCB_ENPAUSE_BIT);  /* No Pause Insertion Allowed */
        }  

      else if (findflag("RXRAWDATA",p->config) >= 0) 
        {
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_USRXTRASZ,0x0000,TGSDDS_NUM_PRG_BITS);       /* Set Additional Bytes as 0 */
 
          rxcfgval = rxcfgval | TGRX_RAWDATA_BIT;
          cbcfgval[mport-1]  = cbcfgval[mport-1] & (~TGCB_ENPAUSE_BIT);  /* No Pause Insertion Allowed */

          if (findflag("RXUSERHDR",p->config) >= 0)
            {
              rxcfgval = rxcfgval | TGRX_USERHDR_BIT;
              ii = (int_u4) findintflag("RXUSERHDR",p->config);
             
              pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_USRHDRADR,ii,TGSDDS_NUM_PRG_BITS);         /* Write Usr Hdr Val Low 16 Bits Reg */
              pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_USRHDRADR,(ii >> 16),TGSDDS_NUM_PRG_BITS); /* Write usr Hdr Val Hi  16 Bits Reg */      
            
            }   

        }
      else if (findflag("RXPKTDATA",p->config) >= 0)
        {
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,0x0000,TGSDDS_NUM_PRG_BITS);                   /* Start UDP DP Address   */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+8+20+14+6,TGSDDS_NUM_PRG_BITS);      /* VLAN Transfer Size     */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+8+20+14+2,TGSDDS_NUM_PRG_BITS);      /* Non-VLAN Transfer Size */

          rxcfgval = rxcfgval | TGRX_PKTDATA_BIT;
          cbcfgval[mport-1]  = cbcfgval[mport-1] & (~TGCB_ENPAUSE_BIT);  /* No Pause Insertion Allowed */
        } 
      else if ((findflag("RXUDPPKT",p->config) >= 0) || (findflag("RXRAWUDP",p->config) >= 0))
        {
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,0x0004,TGSDDS_NUM_PRG_BITS);             /* Start UDP DP Address   */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+8+6,TGSDDS_NUM_PRG_BITS);      /* VLAN Transfer Size     */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+8+2,TGSDDS_NUM_PRG_BITS);      /* Non-VLAN Transfer Size */

          
          rxcfgval = rxcfgval | TGRX_RAWUDP_BIT | TGRX_STRICT_BIT;

          if (findflag("RXSTRICTOFF",p->config) >= 0)     /* Allow Multiple MC Joins                       */
            rxcfgval &= ~(TGRX_STRICT_BIT); 

          if (findflag("RXICESDDS",p->config) >= 0)
            rxcfgval = rxcfgval | TGRX_ICESDDS_BIT;  
        }
      
      else if (findflag("RXRAWPKTSDDS",p->config) >= 0)
        {
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,0x0000,TGSDDS_NUM_PRG_BITS);                   /* Start UDP DP Address   */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+8+20+14+6,TGSDDS_NUM_PRG_BITS);      /* VLAN Transfer Size     */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+8+20+14+2,TGSDDS_NUM_PRG_BITS);      /* Non-VLAN Transfer Size */

          rxcfgval = rxcfgval | TGRX_RAWPKTSDDS_BIT | TGRX_STRICT_BIT;

          if (findflag("RXSTRICTOFF",p->config) >= 0)     /* Allow Multiple MC Joins                       */
            rxcfgval &= ~(TGRX_STRICT_BIT); 
        } 

      else if ((findflag("RXRAWSDDS",p->config) >= 0) ||  (findflag("RXUDPDATA",p->config) >= 0))
        {
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,0x0005,TGSDDS_NUM_PRG_BITS);           /* Start UDP DP Address */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+6,TGSDDS_NUM_PRG_BITS);      /* VLAN Transfer Size     */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+2,TGSDDS_NUM_PRG_BITS);      /* Non-VLAN Transfer Size */
          
          rxcfgval = rxcfgval | TGRX_RAWSDDS_BIT | TGRX_STRICT_BIT;

          if (findflag("RXSTRICTOFF",p->config) >= 0)     /* Allow Multiple MC Joins                       */
            rxcfgval &= ~(TGRX_STRICT_BIT); 
          
        }
         
      else if (findflag("RXSDDSDATA",p->config) >= 0)    
        {

          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,0x0005+(udp_hdrsz/8),TGSDDS_NUM_PRG_BITS);       /* Start UDP DP Address */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz-udp_hdrsz+6,TGSDDS_NUM_PRG_BITS);      /* VLAN Transfer Size     */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz-udp_hdrsz+2,TGSDDS_NUM_PRG_BITS);      /* Non-VLAN Transfer Size */
    
          rxcfgval = rxcfgval | TGRX_SDDSDATA_BIT | TGRX_STRICT_BIT;

          if (findflag("RXSTRICTOFF",p->config) >= 0)     /* Allow Multiple MC Joins                       */
            rxcfgval &= ~(TGRX_STRICT_BIT); 

        }
      else if (findflag("RXPKTSDDS",p->config) >= 0) /* Bring In SDDS Packet With ICE Hdr */
        rxcfgval = rxcfgval | TGRX_ICESDDS_BIT;
                   
      else 
        {     

          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,0x0005,TGSDDS_NUM_PRG_BITS);           /* Start UDP DP Address */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+6,TGSDDS_NUM_PRG_BITS);      /* VLAN Transfer Size     */
          
          pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_PKTPARMADR,udp_pktsz+2,TGSDDS_NUM_PRG_BITS);      /* Non-VLAN Transfer Size */

       
         /* Operating In Default Mode */          
          rxcfgval = rxcfgval | TGRX_ICESDDS_BIT | TGRX_SEQCHECK_BIT | TGRX_STRICT_BIT;

          if (findflag("RXNOSEQFILL",p->config) >= 0)     /* Check Pkt Sequence, Insert 0s For Dropped Pkt */
            rxcfgval &= ~(TGRX_SEQCHECK_BIT); 
          
          if (findflag("RXALLOWPRYPKT",p->config) >= 0)   /* Allow Acquisition Of SDDS Parity Pkts         */
            rxcfgval = rxcfgval | TGRX_PRYPKTEN_BIT;
 
          if (findflag("RXALLOWNSPKT",p->config) >= 0)    /* Allow Acquisition Of SDDS Parity Pkts         */
            rxcfgval = rxcfgval | TGRX_NSPKTEN_BIT;           

          if (findflag("RXSTRICTOFF",p->config) >= 0)     /* Allow Multiple MC Joins                       */
            rxcfgval &= ~(TGRX_STRICT_BIT); 
          else
            { 
 
              /* Initialize Strict Mode To Filter All Packets Except Module's Own IP Address */
               pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_STRICTADDR,modaddr,TGSDDS_NUM_PRG_BITS);         /* Write Rx Strict Reg */
               pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_STRICTADDR,(modaddr >> 16),TGSDDS_NUM_PRG_BITS); /* Write Rx Strict Reg */
              
                
               if (tx_offset==0)
                 {
                  /* VLAN Not Present                           */
                  /* Write Non_VLAN, Strict Instructs To Tx CPU */
                   for (ii=0x58;ii<0x6A;ii++)
                     {                       
                       pic_wmodreg(p,mport,TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR|ii,txsin[ii-0x58],TGSDDS_NUM_PRG_BITS);         
                       udelay(100);    
                     } 
                 }
               else
                 {
                  /* VLAN Present                           */ 
                  /* Write VLAN, Strict Instructs To Tx CPU */
                   for (ii=0x4B;ii<0x66;ii++)
                     {                       
                       pic_wmodreg(p,mport,TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR|ii,txvlsin[ii-0x4B],TGSDDS_NUM_PRG_BITS);                      
                       udelay(100);    
                     }
                 }  
            } 
        }

      if (((rxcfgval & TGRX_ICESDDS_BIT) == 0) || (findflag("RXPKTSDDS",p->config) >= 0))  /* Not In ICE Mode */
        {
          if (findflag("RXSEQFILL",p->config) >= 0)     /* Check Pkt Sequence, Insert 0s For Dropped Pkt */
            rxcfgval = rxcfgval | TGRX_SEQCHECK_BIT; 
            
          if (findflag("RXREMOVEPRYPKT",p->config) < 0) /* Allow Acquisition Of SDDS Parity Pkts         */
            rxcfgval = rxcfgval | TGRX_PRYPKTEN_BIT;

          if (findflag("RXREMOVENSPKT",p->config) < 0)  /* Allow Acquisition Of Non-Standard SDDS Pkts   */
            rxcfgval = rxcfgval | TGRX_NSPKTEN_BIT;

          if (findflag("RXSTRICTON",p->config) >= 0)    /* Allow Multiple MC Joins                       */
            rxcfgval = rxcfgval | TGRX_STRICT_BIT;
        }
      
 
     /* Module Reset, Join Will Occur When Reset Removed   */        
     /* Look For Initial Join Address                      */             
      if ((mport==1) && ((findflag("IPCONN1",p->config) >=0) || (findflag("JOIN1",p->config) >=0)))           
        sdds_join_leave_group(p,mport,1,convert_ip_addr2("IPCONN1","JOIN1",p->config),0);
      else if ((mport==2) && ((findflag("IPCONN2",p->config) >=0) || (findflag("JOIN2",p->config) >=0)))           
        sdds_join_leave_group(p,mport,1,convert_ip_addr2("IPCONN2","JOIN2",p->config),0);
      else if ((findflag("IPCONN",p->config) >=0) || (findflag("JOIN",p->config) >=0))           
        sdds_join_leave_group(p,mport,1,convert_ip_addr2("IPCONN","JOIN",p->config),0);
   
      if (fpgaversion == TG_LARGEPKT_DLD)             /* Allow NS & Parity Pkts                        */  
        {
          rxcfgval = rxcfgval | TGRX_NSPKTEN_BIT | TGRX_PRYPKTEN_BIT;
          rxcfgval = rxcfgval & ~(TGRX_SEQCHECK_BIT);
        }  

      

     /* Write Rx Config Register  */
      pic_wmodreg(p,mport,TGSDDS_RXCFGREG_ADR|TGRX_CFGREGADDR,rxcfgval,TGSDDS_NUM_PRG_BITS);  

     /* Set Loop Test Bit         */       
      if (findflag("TXTESTOUT",p->config) >= 0)
        {
          if (bits == 16)
            rate = rate * 2;
                                 
          kk = 1;
          if (p->mrev[mport-1] != 1) 
            {
              jj = findintflag("TXTPKTCNT",p->config);
              if (jj > 0) kk = jj;
              if (kk > 256)
                {
                   printf("Requested Pkt Burst = %d Maximum Pkt Burst = 255\n",kk);
                   return(-1); 
                }

              testpktipg = ((1250 * kk *1024) - (kk * (rate/1000000) *1152)) / (rate/1000000) / 8;

              if (testpktipg >= 1024)
                {
                  testpktipg = testpktipg/128; 
                      
                  if (testpktipg >= 1024)
                    {
                      printf("Rate = %d Not Possible\n",rate);
                      printf("Lowest Rate Possible = %d MBytes/Sec For Pkts %d\n",(1250 * kk *1024)/ ((kk * 1152) + 1048576),kk);   
                      return(-1);    
                    }      

                  rstcfgval[mport-1] = rstcfgval[mport-1] | TGSYS_TDELSTAGECNT_BIT;
                }  

            }
          else
            {
              if (rate < 150000000)
                {              
                  printf("WARN: Lowest Tx Test Data Rate 150MBytes Per Second\n");
                  printf("WARN: Setting Tx Test Data Rate To 150MB Per Second\n");
                  return(-1);
                }   
              testpktipg = ((1280000/(rate/1000000)) - 1136)/8;   
            }
                       
           
          rstcfgval[mport-1] = rstcfgval[mport-1] | TGSYS_TESTOUT_BIT;
        }
   /*  
     printf("\nPKT Burst = %d\n",kk);
     if ((rstcfgval[mport-1] & TGSYS_TDELSTAGECNT_BIT) != 0)
       printf("STAGED IPG       = %d\n",testpktipg);
     else
       printf("UNSTAGED IPG       = %d\n",testpktipg);         
   */

     rstcfgval[mport-1] = rstcfgval[mport-1] | (testpktipg << 8);      
     rstcfgval[mport-1] = rstcfgval[mport-1] | ((kk-1) << 22); 
  
     /* Set Opposite Port Enable Override --REMOVE AFTER TESTING &BILL */  
      if (findflag("TXTESTENOVR",p->config) >= 0)
        rstcfgval[mport-1] = rstcfgval[mport-1] | 0x00100000;


     /* Tx Test Pkt Only Flags */
     /*
      jj = findintflag("TXTPKTCNT",p->config);
      if (jj <= 0)
        jj=31;
      pic_wmodreg(p,mport,TGSDDS_TXTPKTREG_ADR,jj,TGSDDS_NUM_PRG_BITS);
      
      jj = findintflag("TXTDELCNT",p->config);
      if (jj <= 0)
        jj=2047;
      pic_wmodreg(p,mport,TGSDDS_TXTDELREG_ADR,jj,TGSDDS_NUM_PRG_BITS);
     */  
             
    }
  else  /* Tx Operation */
    {        
     /* Initialize Tx Setup To Current Port */      
      kk       = mport;
      mm       = kk + 1;
 
     /* Set Size For Pkt Data Move For Rev 2 */
      if (p->mrev[mport-1] != 1) 
        {
          mvdatsz = 0x0000007A;

          if (retval != 1)           /* Not Single Port Output               */
            cbrstval[mport-1] |= TGCB_GRESET_BIT;    

          if (retval == 0)           /* Dual Fiber Output From Single Stream */
            {
              kk = 1;
              mm = 3;                                         
            }           
        } 
     
     /* Align Channels                  */        
      if (findflag("TXCHALIGN",p->config) >= 0)
        cbcfgval[mport-1] = cbcfgval[mport-1] | TGCB_ALIGNMODE_BIT; 

     for(jj=kk;jj<mm;jj++)
       {
         txcfgval = 0; 
         rxcfgval = 0;
         
        /* Check Special Case, Port 2, Mode TGPORTS=0, Rev 2 or Higher Of Module */
         if ((jj == 2) && (p->mrev[jj-1] != 1) && (retval == 0))
           {
             tx_offset = 2;                                 /* Init Tx Ops To VLAN Offset                 */            
             init_addrvlan_regs(p,jj,&modaddr,&modvlan);    /* Initialize Regs And Dual Port Mem For Port */         
             if (modvlan == -1) tx_offset = 0;              /* NO VLAN Present Change Offset              */        
             retval = 3;                                    /* Set ICE Card Mux Mode Output               */
           }   
         
         if (((modvlan >= TXLOVLAN_RESTRICT) &&  (modvlan <= TXHIVLAN_RESTRICT)) && (findflag("TXVLANOVRIDE",p->config) < 0))
           {
             printf("Tx Of SDDS To VLANs In The Range Of %d To %d Disabled For",TXLOVLAN_RESTRICT,TXHIVLAN_RESTRICT);
             printf("SDDS Fabric(Network) Protection \n");
             printf("Flag TXVLANOVRIDE Overrides This Protection-Use Cautiously And Avoid Transmission Onto Actual SDDS Network\n");
             return(-1);
           }         
       
        /* Write down Rx DP Cfg Reg Address and Cfg Operation  */
         rxcfgval = TGRX_RAWDATA_BIT;
         pic_wmodreg(p,jj,TGSDDS_RXCFGREG_ADR|TGRX_CFGREGADDR,rxcfgval,TGSDDS_NUM_PRG_BITS);  /* Write Rx Config Register  */
      
              
        /* Non Full Pakcet Header Data Configuration Output            */      
         sprintf (flgname,"TXDESTIP%d",jj);
         if (findflag(flgname,p->config) < 0) sprintf (flgname,"IPDEST%d",jj);
         if (findflag(flgname,p->config) < 0) 
           {
             printf("For Raw Output, Flag %s Must Be Set To Dest IP Address\n",flgname);
             return(-1);
           }
         ip_addr = convert_ip_addr(flgname,p->config);  /* Find Address From Cfg String-Network Byte Ordered */
         portnum = convert_ip_port(flgname,p->config);  /* Find Port From Cfg String-Network Byte Ordered */
         if (portnum > 0) 
           {
             ii      = portnum & 0x00FF;
             portnum = (int_u4) (((portnum >> 8) & 0x000000FF) | ((ii << 8) & 0x0000FF00));
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0012,(((int_u4)portnum) & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0014,(((int_u4)portnum) & 0x0000FFFF),TGSDDS_NUM_PRG_BITS);             
           }

        
         if (fpgaversion == TG_LARGEPKT_DLD)            /* Set IP Hdr For Large Pkt Size */ 
           ip_hdr[1] = 0x3C08;   

         ip_hdr[5]     = 0x0000;  
         ip_hdr[6]     = (int_u2) modaddr;
         ip_hdr[7]     = (int_u2) (modaddr >> 16);
         ip_hdr[8]     = (int_u2) ip_addr;
         ip_hdr[9]     = (int_u2) (ip_addr >> 16);
         ip_hdr[5]     = sdds_compute_checksum(10,ip_hdr);
          
         for(ii=0;ii<10;ii++)   /* Write Down IP Header */
          {
            pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0007+ii,(((int_u4)ip_hdr[ii]) & 0x0000FFFF),TGSDDS_NUM_PRG_BITS); 
            pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0009+ii,(((int_u4)ip_hdr[ii]) & 0x0000FFFF),TGSDDS_NUM_PRG_BITS);
          }
                      
        /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
         if (((ip_addr & 0x000000ff) > 223) && ((ip_addr & 0x000000ff) < 240))
           {
          pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0000,0x0001,TGSDDS_NUM_PRG_BITS);            
          pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0001,((ip_addr & 0x7f00)|0x005E) & 0x0000FFFF,TGSDDS_NUM_PRG_BITS);            
          pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0002,(ip_addr >> 16) & 0x0000FFFF,TGSDDS_NUM_PRG_BITS);

          pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0000,0x0001,TGSDDS_NUM_PRG_BITS);
          pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0001,((ip_addr & 0x7f00)|0x005E) & 0x0000FFFF,TGSDDS_NUM_PRG_BITS);
          pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0002,(ip_addr >> 16) & 0x0000FFFF,TGSDDS_NUM_PRG_BITS);
           }
         else
           {      
             sprintf (flgname,"TXDESTMAC%d",jj);
             if (findflag(flgname,p->config) >= 0) 
               { 
                hwadr     = strstr(p->config,flgname);

                hwadrval  = strtol(hwadr+11,NULL,16);
                hwadrval  = hwadrval |  ((strtol(hwadr+14,NULL,16) << 8) & 0x0000FF00); 
                pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0000,hwadrval,TGSDDS_NUM_PRG_BITS);
                pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0000,hwadrval,TGSDDS_NUM_PRG_BITS); 
                /* printf(" Val = %x\n",hwadrval); */

                hwadrval  = strtol(hwadr+17,NULL,16);
                hwadrval  = hwadrval |  ((strtol(hwadr+20,NULL,16) << 8) & 0x0000FF00); 
                pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0001,hwadrval,TGSDDS_NUM_PRG_BITS);   
                pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0001,hwadrval,TGSDDS_NUM_PRG_BITS);
                /* printf(" Val = %x\n",hwadrval);  */       

                hwadrval  = strtol(hwadr+23,NULL,16);
                hwadrval  = hwadrval |  ((strtol(hwadr+26,NULL,16) << 8) & 0x0000FF00); 
                pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0002,hwadrval,TGSDDS_NUM_PRG_BITS);              
                pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0002,hwadrval,TGSDDS_NUM_PRG_BITS);
                /* printf(" Val = %x\n",hwadrval); */ 
               }
           }  


                
         if (findflag("TXRAWDATA",p->config) >= 0)      /* Send Out SDDS Packet Without SDDS Hdr    */
           {         
            /*Turn On TXRAWDATA Crossbar Size Trans */  
             cbcfgval[jj-1] = cbcfgval[jj-1] | TGCB_TXRAWDAT_BIT;  

            /* Turn Off Pkt Count Add  NON-VLAN     */ 
            /* Address Of Hdr Move                  */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0002,0xE500,TGSDDS_NUM_PRG_BITS);
            /* Set Transfer Instruction 0xF600      */ 
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0003,0xF600,TGSDDS_NUM_PRG_BITS);
            /* Change Data Transfer Size = 1080/8 -1=0x86 Rev 1 1080/8 -6=0x81 Rev 2 */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0004,mvdatsz+7,TGSDDS_NUM_PRG_BITS);   
            /* Stop Transfer Command                */ 
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0005,0xF0FF,TGSDDS_NUM_PRG_BITS);     

            /* Turn Off Pkt Count Add  VLAN         */ 
            /* Address Of Hdr Move                  */
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0002,0xE500,TGSDDS_NUM_PRG_BITS);
            /* Set Transfer Instruction 0xF600      */ 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0003,0xF600,TGSDDS_NUM_PRG_BITS);
            /* Change Data Transfer Size = 1080/8 -1=0x86 Rev 1 1080/8 -6=0x81 Rev 2 */
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0004,mvdatsz+7,TGSDDS_NUM_PRG_BITS);   
            /* Stop Transfer Command                */ 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0005,0xF0FF,TGSDDS_NUM_PRG_BITS);     

             txcfgval = txcfgval | ((int_u4) (0x00000015+tx_offset));    /* Header Trans Size-No SDDS Hdr-21 or 23 */
           }       
         else if (findflag("TXRAWUDP",p->config) >= 0)     /* Send Out UDP Hdr & Data       */
           {
             /*Turn On TXRAWUDP Crossbar Size Trans */  
             cbcfgval[jj-1] = cbcfgval[jj-1] | TGCB_TXRAWUDP_BIT;  
              
            /* Turn Off Pkt Count Add  NON-VLAN     */ 
            /* Address Of Hdr Move                  */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0002,0xE500,TGSDDS_NUM_PRG_BITS);
            /* Set Transfer Instruction 0xF600      */ 
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0003,0xF600,TGSDDS_NUM_PRG_BITS);
            /* Change Data Transfer Size = 1024/8 -1=0x7F Rev 1 1024/8 -6=0x7A Rev 2 */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0004,mvdatsz+8,TGSDDS_NUM_PRG_BITS);   
            /* Stop Transfer Command                */ 
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0005,0xF0FF,TGSDDS_NUM_PRG_BITS);     

            /* Turn Off Pkt Count Add  VLAN         */ 
            /* Address Of Hdr Move                  */
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0002,0xE500,TGSDDS_NUM_PRG_BITS);
            /* Set Transfer Instruction 0xF600      */ 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0003,0xF600,TGSDDS_NUM_PRG_BITS);
            /* Change Data Transfer Size = 1024/8 -1=0x7F Rev 1 1024/8 -6=0x7A Rev 2 */
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0004,mvdatsz+8,TGSDDS_NUM_PRG_BITS);   
            /* Stop Transfer Command                */ 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0005,0xF0FF,TGSDDS_NUM_PRG_BITS); 
              
             txcfgval = txcfgval | ((int_u4) (0x00000011+tx_offset)) ;  /* Header Trans Size-No UDP  Hdr-17 or 19 */    

             xx = findintflag("TXRAWUDP",p->config);
             if (xx <= 1)
               xx = udp_pktsz;          /* Default To Download UDP Pkt Size */ 
             if ((xx % 8) != 0)
               {
                 printf("Err: UDP Packet Size Must Be a Multiple of * Bytes, Size = %d Invalid\n",xx);
                 return(-1);
               }
             
             udp_pktsz = xx + 8;  /* Add 8 Bytes For UDP Hdr Size */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_TRANSZREGADDR),(int_u2)(udp_pktsz/2),TGSDDS_NUM_PRG_BITS);/* UDP+Hdr 16Bit Words */

             /* Setup IP Header With New IP Pkt Size */
             ip_hdr[1] =  udp_pktsz + 20;   /* Add IP Hdr Size To Total Size */     
             ip_hdr[1] =  ((ip_hdr[1] >> 8) & 0x00FF) | ((ip_hdr[1] << 8) & 0x0000FF00);  /* BigE IP Length */

             ip_hdr[5]     = 0x0000;  
             ip_hdr[6]     = (int_u2) modaddr;
             ip_hdr[7]     = (int_u2) (modaddr >> 16);
             ip_hdr[8]     = (int_u2) ip_addr;
             ip_hdr[9]     = (int_u2) (ip_addr >> 16);
             ip_hdr[5]     = sdds_compute_checksum(10,ip_hdr);
          
             for(ii=0;ii<10;ii++)   /* Write Down IP Header */
              {
                pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0007+ii,(((int_u4)ip_hdr[ii]) & 0x0000FFFF),TGSDDS_NUM_PRG_BITS);
                pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0009+ii,(((int_u4)ip_hdr[ii]) &  0x0000FFFF),TGSDDS_NUM_PRG_BITS);
              }
             
             if (findflag("TXUDPCHKSUM",p->config) >= 0)
               {   
                 
                 txcfgval = txcfgval | 0x0400;   /* Enable UDP CheckSum */
                                 
                 udpchksum[0] = (int_u2)  (modaddr & 0x0000FFFF);
                 udpchksum[1] = (int_u2)  ((modaddr >> 16) & 0x0000FFFF);
                 udpchksum[2] = (int_u2)  (ip_addr & 0x0000FFFF);;
                 udpchksum[3] = (int_u2)  ((ip_addr >> 16) & 0x0000FFFF);
                 udpchksum[4] = 0x1100;    /* Zero Pad Low Byte, High Byte Protocol = 17 For UDP */        
                 udpchksum[5] = (int_u2) (((udp_pktsz >> 8) & 0x000000FF) | ((udp_pktsz << 8) & 0x0000FF00));  /* BigE UDP Length */
                     
                 udpchksum[0] = sdds_compute_checksum(6,udpchksum);  /* Calculate Partial CheckSum */   
                 udpchksum[0] = ~(udpchksum[0]);                     /* Remove Negation            */
              
                 pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_UDPCKSUMREGADDR),(int_u2)(udp_pktsz/2),TGSDDS_NUM_PRG_BITS);  /* Load Size  */
                 pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_UDPCKSUMREGADDR),udpchksum[0],TGSDDS_NUM_PRG_BITS); /* Partial ChkSum 0    */
               }    


                   
           }
         else if (findflag("TXRAWSDDS",p->config) >= 0 || def)  /* Send Out In SDDS Packet w/SDDS Hdr       */
           {
            /* Turn On Pkt Count Add  NON-VLAN      */ 
            /* Address Of Hdr Move                  */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0002,0xC500,TGSDDS_NUM_PRG_BITS);
            /* Set Transfer Instruction 0xF600      */ 
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0003,0xF600,TGSDDS_NUM_PRG_BITS);
            /* Change Data Transfer Size = 1024/8 -1=0x7F Rev 1 1024/8 -6=0x7A Rev 2 */
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0004,mvdatsz,TGSDDS_NUM_PRG_BITS);   
            /* Stop Transfer Command                */ 
             pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_CPUWRADDR)+0x0005,0xF0FF,TGSDDS_NUM_PRG_BITS);     

            /* Turn Off Pkt Count Add  VLAN         */ 
            /* Address Of Hdr Move                  */
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0002,0xE500,TGSDDS_NUM_PRG_BITS);
            /* Set Transfer Instruction 0xF600      */ 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0003,0xF600,TGSDDS_NUM_PRG_BITS);
            /* Change Data Transfer Size = 1024/8 -1=0x7F Rev 1 1024/8 -6=0x7A Rev 2 */
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0004,mvdatsz,TGSDDS_NUM_PRG_BITS);   
            /* Stop Transfer Command                */ 
             pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_CPUWRADDR)+0x0005,0xF0FF,TGSDDS_NUM_PRG_BITS); 

           
             if (fpgaversion != TG_LARGEPKT_DLD) 
               { 

                /*************************************************/  
                /* Set Data Size For Output 16 Bit Packing */
                /*************************************************/   
                 if (bits == 16)
                   txcfgval = txcfgval | (3 << 6);
                 else
                   txcfgval = txcfgval | ((bits/4) << 6);

                /* txcfgval = txcfgval | 0x01;             */       /* Set Tx Op For Non-ICE Data Mode */
                /*************************************************/
                /* SDDS Nibble & Byte Swap Mux Select Bits */
                /*************************************************/            
                 if ((bits == 4) &&  (findintflag("BIGEND",p->config) < 0))
                   txcfgval = txcfgval | 0x0100;      /* Set Nibble Swap Bit For Module Output Mux */
           
                 if ((bits == 16) && (findintflag("BIGEND",p->config) >= 0))         
                   txcfgval = txcfgval | 0x0200;      /* Set Byte   Swap Bit For Module Output Mux */
                /*************************************************/ 
                /*************************************************/
                /* Set Up Format Identifier Field */
                /*************************************************/
                 ii = (bits << 8);
                 if (bits ==  8) ii = ii | 0x0001;
                 if (bits == 16) ii = ii | 0x0002;  
                 ii = ii | 0x0080;                    /* Set Standard SDDS Bit */
                /*************************************************/ 

                 pic_wmodreg(p,jj,(TGSDDS_TXCFGREG_ADR|TGTX_DATWRADDR)+0x0015,ii & 0x0000FFFF,TGSDDS_NUM_PRG_BITS);   /* Non-VLAN */
                 pic_wmodreg(p,jj,(TGSDDS_TXVCFGREG_ADR|TGTX_DATWRADDR)+0x0017,ii & 0x0000FFFF,TGSDDS_NUM_PRG_BITS);  /* VLAN     */  
                
                 txcfgval = txcfgval | ((int_u4) (0x00000031+tx_offset)) ;   /* Header Trans Size- With SDDS Hdr */
           
                /* Enable 16 Bit Ramp For Test Output */
                  if (findflag("TXTESTOUT",p->config) >= 0)
                   rstcfgval[jj-1] = rstcfgval[jj-1] | TGSYS_OUTDEBUG_BIT;
               }
            else
              txcfgval = txcfgval | ((int_u4) (0x00000025+tx_offset)) ;   /* Header Trans Size- With SDDS Hdr */ 
 
           }

        /* Write down Tx DP Cfg Reg Data Value */
         pic_wmodreg(p,jj,TGSDDS_TXCFGREG_ADR|TGTX_CFGREGADDR,txcfgval,TGSDDS_NUM_PRG_BITS);

         if (tx_offset == 0)
           pic_wmodreg(p,jj,TGSDDS_TXVCFGREG_ADR|TGTX_CFGREGADDR,0x0000,TGSDDS_NUM_PRG_BITS);  /* Disable VLAN TX */
         else
           pic_wmodreg(p,jj,TGSDDS_TXVCFGREG_ADR|TGTX_CFGREGADDR,0x0001,TGSDDS_NUM_PRG_BITS);  /* Enable VLAN TX  */

       } /* for jj */             
   }  

  /* Store Config Words */ 
   pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|(mport*TGMEM_CHAN_OFF)|TGMEM_CBCFG_ADR,cbcfgval[mport-1],TGSDDS_NUM_PRG_BITS);
   pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|(mport*TGMEM_CHAN_OFF)|TGMEM_CBRST_ADR,cbrstval[mport-1],TGSDDS_NUM_PRG_BITS);     
   pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|(mport*TGMEM_CHAN_OFF)|TGMEM_ENCFG_ADR,encfgval[mport-1],TGSDDS_NUM_PRG_BITS); 
   pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|(mport*TGMEM_CHAN_OFF)|TGMEM_RSTCFG_ADR,rstcfgval[mport-1],TGSDDS_NUM_PRG_BITS); 

  return(retval);
}



