#define A2DR9_NUM_PRG_BITS 32
#define A2DR9_MAX_RATE     250000000
#define A2DR9_REF_OSC      10000000
#define CLKCFG_INDEX             0
#define PLLCFG_INDEX             1 
#define GAINCFG_INDEX            2
#define A2DR9_RESETCFG_INDEX     3
#define A2DR9_SYSCFG_INDEX       4
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_a2dr9 (PICSTRUCT *p, int_4 mport,int_u4 dis_enable)
{
   pic_wmodreg(p,mport,A2DR9_RESETCFG_INDEX,0,A2DR9_NUM_PRG_BITS);       /* Set System Reg = 0, Module In Reset    */

   if (dis_enable != 0) 
      pic_wmodreg(p,mport,A2DR9_RESETCFG_INDEX,0x01,A2DR9_NUM_PRG_BITS); /* If Enabling Remove Reset               */  
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_a2dr9_gain(PICSTRUCT *p,int_4 mport,int_4 gain)
{
   int ii;

   ii = (int)(pow( 2.0, (double)gain/6 )*18.0); /* 18 is Gain = 1:1 */
   ii = max(0,min(127,ii));

   pic_wmodreg(p,mport,GAINCFG_INDEX,0x0,32);
   udelay(1000);

   pic_wmodreg(p,mport,GAINCFG_INDEX,(ii<<1)|0x1,32);
   udelay(1000);

   udelay(10000);  /* until faster a2dr13 algorithm is used */

   return(0);

}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_a2dr9 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 bits,int_4 rate, int_4 gain,int_4 flags) 
{   
   int i,ii; 
   int_u4 syscfg  = 0;
   int_u4 reffreq =  A2DR9_REF_OSC; 
   int clksrc = 3;  /* 0-Syn Clk From On-Board Crystal  */
                    /* 1-Syn Clk From Ext Ref           */
                    /* 2-Clk From On-Board LVDS Crystal */
                    /* 3-Clk From Ext Input--Default    */
   int_u4 pllcfgval[11] = {0x00000000,0x0000000C,0x00000163,0x00000501,0x00001404,
                           0x00005010,0x00004040,0x00000101,0x00000405,0x00000004,0x000021EC};   

   /* gain = 18;  */                                         /* Hard Code For Initial 1:1 Gain(Approx) */ 
   gain = (int)(pow( 2.0, (double)gain/6 )*18.0);            /* 18 is Gain = 1:1 */
   gain = max(0,min(127,gain));

   pic_wmodreg(p,mport,GAINCFG_INDEX,0,A2DR9_NUM_PRG_BITS);  /* Set Gain = 0, Turn Off Gain Control    */
   pic_wmodreg(p,mport,CLKCFG_INDEX,0,A2DR9_NUM_PRG_BITS);   /* Set Clk Choice =0, PLL Config = Reset  */
   
   if ((i=findflag("MUXCLK",p->config)) >= 0)
    {
      if (p->config[i+6]!='=') ;
      else if (p->config[i+7]=='P') 
        {          
          clksrc = 0;
          if (findflag("PREFX",p->config) >= 0)
            {
              clksrc = 1;                            /* Set Clock Source To PLL With Ext Ref Frequency */

             /* Determine User Ref Frequency For PLL Clk Use   */
         /*   ii = findintflag("PREFX",p->config);   
              if (ii <= 1)
                printf("\nWARN: Must Specify PREFX Flag As PREFX=<freq>, Assuming %d MHz\n",A2DR9_REF_OSC/1000000); 
              else
                reffreq = ii;                
         */ 
            }      
        } 
      else if ((p->config[i+7]=='A') &&  (mport == 1));
      else if ((p->config[i+7]=='B') &&  (mport == 2));
      else if (p->config[i+7]=='N');
         
      else if (p->config[i+7]=='C') clksrc = 2; 
      else 
        {
          printf("Illegal MUXCLK=%c flag - ignored\n",p->config[i+7]);
          printf("Allowable Clock Choices: MUXCLK=");
          if (mport != 2)  
            printf("A,");
          if (mport != 1)
            printf("B,");
          printf("C,P,or P w/flag PREFX\n");
        }            
   }

  /*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
   if (bits==16)                                                                   /* Enable 16 Bit Data Else 8 Bit     */
     syscfg = syscfg | 0x08;                                                          
   if (findflag("INVMSB",p->config) >= 0)                                          /* Turn Off MSB Inversion In Module  */
     syscfg = syscfg | 0x10;             
   if (findflag("MODDEBUG",p->config) >= 0)                                        /* Turn On A/D Send Ramp             */
     syscfg = syscfg | 0x20;
   if (findflag("LSBP",p->config) >= 0)                                            /* Turn PPS On LSBit                 */
     syscfg = syscfg | 0x40;
 
   pic_wmodreg(p,mport,A2DR9_SYSCFG_INDEX,syscfg,A2DR9_NUM_PRG_BITS);                    /* Set System Reg User Parms         */
  /*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/

   if ((clksrc & 0x03) < 2)                                                        /* Check PLL Needs To Be Programmed  */
     {    
       if (calc_enhancedpll_values(rate,reffreq,A2DR9_MAX_RATE,pllcfgval) < 0)
         return(-1);    

       pic_wmodreg(p,mport,CLKCFG_INDEX,(clksrc<<1)|0x01,A2DR9_NUM_PRG_BITS);      /* Remove PLL Programming Reset      */      
       udelay(40000);
       for (ii=0;ii<11;ii++)
         {
           pic_wmodreg(p,mport,PLLCFG_INDEX,0,A2DR9_NUM_PRG_BITS);
           udelay(100);
           if (ii != 10)
             pllcfgval[ii] = pllcfgval[ii] | 0x802F0000;                           /* Set PLL Cfg Val Bit & Num Bits-1  */           
           else
             pllcfgval[ii] = pllcfgval[ii] | 0x803D0000;                           /* Set Val Bit, End Bit & Num Bits-1 */                                   
           pic_wmodreg(p,mport,PLLCFG_INDEX,pllcfgval[ii],A2DR9_NUM_PRG_BITS);     /* Set PLL Program Bits              */ 

            udelay(100); 
        /*  printf("%s%d%s%0x\n","Index = ",ii," Value = ",pllcfgval[ii]); */
         }
        pic_wmodreg(p,mport,PLLCFG_INDEX,0,A2DR9_NUM_PRG_BITS);                    /* Clear Programming Word            */
        udelay(40000);                                                             /* Delay 40mS For PLL Lock           */ 
     }

   else
     pic_wmodreg(p,mport,CLKCFG_INDEX,(clksrc<<1)&0xFFFFFFFE,A2DR9_NUM_PRG_BITS); /* Keep PLL Program Reset Asserted */
    
   udelay(100);
   pic_wmodreg(p,mport,GAINCFG_INDEX,(gain << 1)|0x01,A2DR9_NUM_PRG_BITS);        /* Remove Global Reset, Set Initial Gain 1:1 (Approx) */
   udelay(10000);                                                                 /* Allow gain AGC to settle out (JGS) */

   return(0);    
}  
