#define A2DR11_REV2_DETVAL          7        /* Detect Value Of Rev 2 Of A2DR11                  */
#define A2DR11_NUM_PRG_BITS        32 
#define A2DR11_MAX_RATE    1500000000
#define A2DR11_REF_OSC       10000000
#define A2DR11_SAMPFREQ_MIN 200000000        /* Lowest Sample Rate                               */
#define A2DR11_EXTCLK_MIN   200000000        /* Minimum Direct Clock Rate-Direct Clock           */                     
#define A2DR11_EXTCLK_MAX   900000000        /* Maximum Direct Clock Rate-Direct Clock           */
#define A2DR11_HOLELOFREQ  945000000         /* A2DR11 Low  Freq Hole-No Op Up To High Freq Hole */
#define A2DR11_HOLEHIFREQ  970000000         /* A2DR11 High Freq Hole-No Op Up To High Freq Hole */

#define A2DR11_SYNMLOHOLE  1134000000        /* Si5326 Low  Freq Hole #1                         */
#define A2DR11_SYNMHIHOLE  1213000000        /* Si5326 High Freq Hole #1                         */
#define A2DR11_SYNHLOHOLE  1417000000        /* Si5326 Low  Freq Hole #2                         */
#define A2DR11_SYNHHIHOLE  1560000000        /* Si5326 High Freq Hole #2                         */

#define SAMPLOfREQ          750000000
#define IF1HIFREQ           841850000
#define IF0HIFREQ           944948000
#define RF21HIFREQ         1060672200
#define RF20HIFREQ         1190568900
#define RF11HIFREQ         1336373400
#define RF10HIFREQ         1600000000
           
#define A2DR11_CLKCFG_INDEX         0
#define A2DR11_A2DCFG_INDEX         1
#define A2DR11_SYSCFG_INDEX         2
#define A2DR11_MUXCFG_INDEX         3 
#define A2DR11_SICCFG_INDEX         4
#define A2DR11_OUTCFG_INDEX         5

/* CLKCFG Bit Definitions */
#define PLL1_BIT             0x00400000       /* Select PLL 1 For Configuration                  */
/* A2DCFG Bit Definitions */
#define EXTREF_BIT           0x00000001       /* Set 1 For Ext Ref, Set 0 For On-Board Ref       */
#define SYN0SEL_BIT          0x00000002       /* Set 1 For IF Out, Set 0 For RF Out Of Syn PLL 0 */
#define MUXSEL0_BIT          0x00000004       /* Low Bit Select Of 4:1 Mux                       */
#define MUXSEL1_BIT          0x00000008       /* Hi  Bit Select Of 4:1 Mux                       */
                                              /*  00-User Supplied Clock                         */
                                              /*  01-Result Of SYN0SEL Output                    */
                                              /*  10-IF Out For Syn PLL 1                        */
                                              /*  11-RF Out For Syn PLL 1                        */ 
#define RLOWVALUE                    14
#define RHIVALUE                     8189
#define RF1NMAXVALUE                 0x00040000
#define RF2NMAXVALUE                 0x00020000
#define IFNMAXVALUE                  0x00010000                              
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_a2dr11 (PICSTRUCT *p, int_4 mport,int_u4 dis_enable)
{
   pic_wmodreg(p,2,A2DR11_SYSCFG_INDEX,0,A2DR11_NUM_PRG_BITS);             /* Set System Reg = 0, Module In Reset    */

   if (dis_enable != 0) 
      {
        pic_wmodreg(p,mport,A2DR11_A2DCFG_INDEX,0,A2DR11_NUM_PRG_BITS);
        udelay(1000);
        pic_wmodreg(p,mport,A2DR11_A2DCFG_INDEX,4,A2DR11_NUM_PRG_BITS);
        udelay(1000); 

        pic_wmodreg(p,mport,A2DR11_SYSCFG_INDEX,0x01,A2DR11_NUM_PRG_BITS); /* If Enabling Remove Reset               */
        udelay(1000);  
      }  
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 a2dr11_wmodreg_si5326 (PICSTRUCT *p, int_4 mport,int_u4 value)
{   
   
   pic_wmodreg(p,mport,A2DR11_SICCFG_INDEX,((value >> 8) & 0x000000FF),A2DR11_NUM_PRG_BITS);        /* Write Addr    */   
   udelay(1000);
   pic_wmodreg(p,mport,A2DR11_SICCFG_INDEX,(value & 0x000000FF) | 0x00004000,A2DR11_NUM_PRG_BITS);  /* Write Data    */  
   udelay(1000);
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_a2dr11 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 bits,int_4 rate, int_4 gain,int_4 flags) 
{   

   Si5326_Reg_Obj Si5326_Reg;
   int i,ii;
   int_u4 a2dcfg    = 0;
   int_u4 clkcfg    = 0; 
   int_u4 decim     = 0;
   int_u4 nn,rr;     
   int_u4 holdn     = 0;
   int_u4 holdr     = 0;
   int_u4 maxnvalue = 0;
   int_u4 pll_zone  = 0;
   int_u4 lsbxflag  = 0;
   int_u4 reffreq   =  A2DR11_REF_OSC; 
   int clksrc       = 3;  /* 0-Syn Clk From On-Board Crystal  */
                          /* 1-Syn Clk From Ext Ref           */
                          /* 2-NOT USED                       */
                          /* 3-Clk From Ext Input--Default    */
    
   double clkdif   = 10000000.0;
   double samprate = 0.0;
   int_u4 mbval;
                             
   pic_wmodreg(p,mport,A2DR11_SYSCFG_INDEX,0,A2DR11_NUM_PRG_BITS);
   pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0,A2DR11_NUM_PRG_BITS); 


   pic_wmodreg(p,mport,A2DR11_OUTCFG_INDEX,0x00000007,A2DR11_NUM_PRG_BITS);  /* Enable Input Of Module A2DR11 Rev Dectect  */
   udelay(1000);
   pic_rmodreg(p,mport,0x0,&mbval,A2DR11_NUM_PRG_BITS);
   udelay(1000);     
   pic_wmodreg(p,mport,A2DR11_OUTCFG_INDEX,0,A2DR11_NUM_PRG_BITS);           /* Disable Input Of Module A2DR11 Rev Dectect */
   

   if (mbval != A2DR11_REV2_DETVAL)
     {
      /* Rev 1 Of A2DR11 Module */
       if ((i=findflag("MUXCLK",p->config)) >= 0)
        {
          if (p->config[i+6]!='=') ;
           else if (p->config[i+7]=='P') 
             {
               clksrc = 0;
               if (findflag("PREFX",p->config) >= 0)
                 {
                   clksrc = 1;                            /* Set Clock Source To PLL With Ext Ref Frequency */

                   ii = findintflag("PREFX",p->config);   
                   if (ii <= 1)
                     reffreq   =  A2DR11_REF_OSC;
                   else
                     reffreq = ii;  
                 }          
             } 
           else if (p->config[i+7]=='A');
           else if (p->config[i+7]=='B');
           else if (p->config[i+7]=='N');          
           else 
             {
               printf("Illegal MUXCLK=%c flag - ignored\n",p->config[i+7]);
               printf("Allowable Clock Choices: MUXCLK=");
               if (mport != 2)  
                 printf("A,");
               if (mport != 1)
                 printf("B,");          
               printf("N,P,or P w/flag PREFX\n");
             } 
         }
 
        pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00010040,A2DR11_NUM_PRG_BITS);              /* Set Up Main Reg PLL 0 */         
        pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00010040|PLL1_BIT,A2DR11_NUM_PRG_BITS);     /* Set Up Main Reg PLL 1 */
        pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00000002,A2DR11_NUM_PRG_BITS);              /* Power Down PLL 0      */         
        pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00000002|PLL1_BIT,A2DR11_NUM_PRG_BITS);     /* Power Down PLL 1      */
   
        if (findflag("LSBP",p->config) >= 0)
         lsbxflag = 0x00000040;                                                 /* Enable PPS Bit In LSBit Of Data */     

        if (clksrc==3)                                                           /* User Supplied Clock             */
          {             
            pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|EXTREF_BIT|(decim<<4),A2DR11_NUM_PRG_BITS);      /* Set Ext Ref Mux = 00 */
            return(0);
          }    

     
       /* ***************Using PLLs*************** */
        while (rate < SAMPLOfREQ)           /* &BILL Should Be < NOT <= */
          {
            ++decim;
            rate  = rate  * 2;
          }
   
   
        if (clksrc == 1)                     /* Set Clk Ref Source As Ext. Reference if PREF Found */
          clkcfg = EXTREF_BIT;    

        if ((rate >= SAMPLOfREQ) && (rate < IF1HIFREQ))
          {
            maxnvalue = IFNMAXVALUE;
            pll_zone  = 0;
          }
        else if ((rate > IF1HIFREQ) && (rate < IF0HIFREQ ))
          {
            maxnvalue = IFNMAXVALUE;
            pll_zone  = 1;
          } 
        else if ((rate > IF1HIFREQ) && (rate < RF21HIFREQ))
          {
             maxnvalue = RF2NMAXVALUE;
            pll_zone  = 2;
          }   
        else if ((rate > RF21HIFREQ) && (rate < RF20HIFREQ))
          {
            maxnvalue = RF2NMAXVALUE;
            pll_zone  = 3;
          }  
        else if ((rate > RF20HIFREQ) && (rate < RF11HIFREQ))
          {
            maxnvalue = RF1NMAXVALUE;
            pll_zone  = 4;
          }  
        else if ((rate > RF11HIFREQ) && (rate <= RF10HIFREQ))
          {
            maxnvalue = RF1NMAXVALUE;
            pll_zone  = 5;
          }

        for (nn=1;nn<maxnvalue;nn++)
          {   
            for(rr=14;rr<8189;rr++)
              {
                samprate = ((double) nn)/((double) rr) * ((double) reffreq);

               /*  printf("Sample Rate = %e\n",samprate); */
           
                if (clkdif > abs(rate-samprate))
                  {
                    clkdif = abs(rate-samprate);                 
                    holdn  = nn;
                    holdr  = rr; 
                    if (clkdif == 0)
                      break; 
                  } 
              }
            if (clkdif == 0)
              break;  
          }   
     /*
        printf("A/D Clock Rate = %d MHz\n",rate/1000000);
        printf("Decim Value = %d\n",decim);
        printf("Internal Decim = %d\n",(int)pow(2.0,decim));
        printf("N Value = %d\n",holdn);
        printf("R Value = %d\n",holdr);
        printf("Clkdif  = %d\n",clkdif);
     */

       if (pll_zone == 0)
         {
       pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|clkcfg|MUXSEL1_BIT|(decim<<4),A2DR11_NUM_PRG_BITS);    /* Set ExtRef Mux=10    */   
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|PLL1_BIT|0x0005,A2DR11_NUM_PRG_BITS);                /* Wr N Val To IF PLL1  */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|PLL1_BIT|0x0008,A2DR11_NUM_PRG_BITS);                /* Wr R Val To IF PLL1  */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000002<<4)|PLL1_BIT|0x0002,A2DR11_NUM_PRG_BITS);           /* Wr Enable To IF PLL1 */   
         }    
       else if (pll_zone == 1)
         {
       pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|clkcfg|SYN0SEL_BIT|MUXSEL0_BIT|(decim<<4),A2DR11_NUM_PRG_BITS); /* Ref Mux=01  */   
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0005,A2DR11_NUM_PRG_BITS);                         /* Wr N Val  To IF PLL0 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0008,A2DR11_NUM_PRG_BITS);                         /* Wr R Val  To IF PLL0 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000002<<4)|0x0002,A2DR11_NUM_PRG_BITS);                    /* Wr Enable To IF PLL0 */   
         }  
       else if (pll_zone == 2)
         {
       pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|clkcfg|MUXSEL1_BIT|MUXSEL0_BIT|(decim<<4),A2DR11_NUM_PRG_BITS); /* Ref Mux=11  */   
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0004|PLL1_BIT,A2DR11_NUM_PRG_BITS);                /* Wr N Val  To RF2 PLL1 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0007|PLL1_BIT,A2DR11_NUM_PRG_BITS);                /* Wr R Val  To RF2 PLL1 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000001<<4)|PLL1_BIT|0x0002,A2DR11_NUM_PRG_BITS);           /* Wr Enable To RF2 PLL1 */   
         }  
       else if (pll_zone == 3)
         {
       pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|clkcfg|MUXSEL0_BIT|(decim<<4),A2DR11_NUM_PRG_BITS);    /* Set ExtRef Mux=01     */   
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0004,A2DR11_NUM_PRG_BITS);                         /* Wr N Val To RF2 PLL0  */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0007,A2DR11_NUM_PRG_BITS);                         /* Wr R Val To RF2 PLL0  */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000001<<4)|0x0002,A2DR11_NUM_PRG_BITS);                    /* Wr Enable To RF2 PLL0 */   
         } 
       else if (pll_zone == 4)
         {
       pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|clkcfg|MUXSEL1_BIT|MUXSEL0_BIT|(decim<<4),A2DR11_NUM_PRG_BITS); /*Ref Mux=11    */   
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0003|PLL1_BIT,A2DR11_NUM_PRG_BITS);                /* Wr N Val  To RF2 PLL1 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0006|PLL1_BIT,A2DR11_NUM_PRG_BITS);                /* Wr R Val  To RF2 PLL1 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000001<<4)|0x0002|PLL1_BIT,A2DR11_NUM_PRG_BITS);           /* Wr Enable To RF2 PLL1 */   
         } 
       else if (pll_zone == 5)
         {
       pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|clkcfg|MUXSEL0_BIT|(decim<<4),A2DR11_NUM_PRG_BITS);    /* Set Ext Ref Mux = 01  */   
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0003,A2DR11_NUM_PRG_BITS);                         /* Wr N Val To RF2 PLL0  */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0006,A2DR11_NUM_PRG_BITS);                         /* Wr R Val To RF2 PLL0  */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000001<<4)|0x0002,A2DR11_NUM_PRG_BITS);                    /* Wr Enable To RF2 PLL0 */   
         }     
     }
   else
     { 
      /* REV 2 Of A2DR11 */ 
       if ((rate > A2DR11_HOLELOFREQ) && (rate < A2DR11_HOLEHIFREQ))
         {  
 printf("\nErr: A2DR11 Will Not Operate For Sample Rate Range of %d Mhz to %d MHz\n",A2DR11_HOLELOFREQ/1000000,A2DR11_HOLEHIFREQ/1000000);
           return(-1);
         }   

       if ((i=findflag("MUXCLK",p->config)) >= 0)
         {
           if (p->config[i+6]!='=') ;
             else if (p->config[i+7]=='P') 
               {
                 clksrc = 0;                                /* Set Clock Source To PLL With On-Board Ref Frequency */
                 if (findflag("PREFX",p->config) >= 0)
                   {
                     clksrc = 1;                            /* Set Clock Source To PLL With Ext Ref Frequency      */
            
                     ii = findintflag("PREFX",p->config);   
                     if (ii <= 1)
                       reffreq   =  A2DR11_REF_OSC;
                     else
                       reffreq = ii;                            
                   }          
               } 
             else if (p->config[i+7]=='A');
             else if (p->config[i+7]=='B');
             else if (p->config[i+7]=='N');          
             else 
               {
                 printf("Illegal MUXCLK=%c flag - ignored\n",p->config[i+7]);
                 printf("Allowable Clock Choices: MUXCLK=");
                 if (mport != 2)  
                   printf("A,");
                 if (mport != 1)
                   printf("B,");          
                 printf("N,P,or P w/flag PREFX\n");
               } 
         }
 
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00010040,A2DR11_NUM_PRG_BITS);              /* Set Up Main Reg PLL 0 */         
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00030040|PLL1_BIT,A2DR11_NUM_PRG_BITS);     /* Set Up Main Reg PLL 1 */
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00000002,A2DR11_NUM_PRG_BITS);              /* Power Down PLL 0      */         
       pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,0x00000002|PLL1_BIT,A2DR11_NUM_PRG_BITS);     /* Power Down PLL 1      */
   
       if (findflag("LSBP",p->config) >= 0)
         lsbxflag = 0x00000040;                                                 /* Enable PPS Bit In LSBit Of Data */     

  
                     
      /* Setup Clock Synthesizer */
       if (clksrc == 3)  /* Bypass to External Clock */
         {      
           pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|MUXSEL0_BIT,A2DR11_NUM_PRG_BITS);   /* Use Si5326 Clock, NOT Si4133 */
          
           if (rate < A2DR11_EXTCLK_MIN)
             {
               printf("Error: Minimum External Clock Rate = %d MHz\n",A2DR11_EXTCLK_MIN/1000000); 
               printf("Error: Increase Clock Rate or Use On Board Clock Synthesizer For Desired Rate.\n");
               return(-1);
             } 

           if (rate > A2DR11_EXTCLK_MAX)
             {
               printf("Error: Maximum External Clock Rate = %d MHz\n",A2DR11_EXTCLK_MAX/1000000); 
               printf("Error: Reduce Clock Rate or Use On Board Clock Synthesizer For Desired Rate.\n");
               return(-1);
             }             
           a2dr11_wmodreg_si5326 (p,mport,0x00008880);  /* Put Device In Reset     */
           a2dr11_wmodreg_si5326 (p,mport,0x00008800);  /* Remove Reset            */
           a2dr11_wmodreg_si5326 (p,mport,0x00000631);  /* Set Disable,CML Out     */
           a2dr11_wmodreg_si5326 (p,mport,0x0000157C);  /* ClkSel[1..0] Reg Active */
           a2dr11_wmodreg_si5326 (p,mport,0x00000345);  /* Set Clk2 Input Select   */       
           a2dr11_wmodreg_si5326 (p,mport,0x00000016);  /* Set Bypass Bit          */
         }
       else                /* Normal Clock selection */
         {
           if (rate < (A2DR11_SAMPFREQ_MIN/8))
             {
               printf("Error: Minimum External Clock Rate = %d MHz\n",(A2DR11_SAMPFREQ_MIN/8)/1000000); 
               printf("Error: Increase Clock Rate For Desired Rate.\n");
               return(-1);
             }  

           while (rate < A2DR11_SAMPFREQ_MIN) 
             {
               ++decim;
               rate  = rate  * 2;
             }

           if (((rate > A2DR11_SYNMLOHOLE) && (rate < A2DR11_SYNMHIHOLE)) ||
               ((rate > A2DR11_SYNHLOHOLE) && (rate < A2DR11_SYNHHIHOLE)))
             {                                                                                        /* Si4133 Config                */
               pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|(decim<<4),A2DR11_NUM_PRG_BITS);      /* Use Si4133 Clock, NOT Si6326 */
               Si5326_Reg.dclk2  = 10000000.0;/* So AnyRate Will Have Better Range--Disable Output Later */ 
               Si5326_Reg.dclk1  = 10000000.0;

               if (findflag("A2DWARNOFF",p->config) < 0)
                {
                  printf("WARN: Sample rates between 1.134GHz and 1.213GHz or 1.417GHz and 1.560GHz require\n");
                  printf("      the use of circuitry with reduced jitter performance.  Operation is allowed\n");
                  printf("      but with reduced jitter performance in these ranges.\n");
                  printf("      Use the flag A2DWARNOFF to allow operation and remove this message.\n");
                  return(-1);     
                }                               
             }  
           else
             {
               pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|MUXSEL0_BIT|(decim<<4),A2DR11_NUM_PRG_BITS);/* Use 5326 Clk, NOT 4133 */ 
               Si5326_Reg.dclk2  = ((real_8) rate);
               Si5326_Reg.dclk1  = ((real_8) rate);  /* So AnyRate Will Have Better Range--Disable Output Later */  
             }
           
          
           Si5326_Reg.debuglevel = -1;
           Si5326_Reg.fref   =  reffreq;                     
           Si5326_Reg.dwght1 = 1.0;
           Si5326_Reg.dwght2 = 1.0;   
           ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_A2DR11);
           ii = si5326_regcfg_bwsel(&Si5326_Reg,7);

           if (clksrc == 1)                 /* Ext Ref PLL       */
             ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);
           else if (clksrc == 0)             /* On-Board Ref PLL  */
             ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_1);

           ii = si5326_regcfg_dividers(&Si5326_Reg);
           if (ii != 0)
             printf("A2DR11 Warning: A/D sample rate not possible. Using %f\n",Si5326_Reg.fclk2);
           si5326_regcfg_debug(&Si5326_Reg);   
       

           if (((rate > A2DR11_SYNMLOHOLE) && (rate < A2DR11_SYNMHIHOLE)) ||
               ((rate > A2DR11_SYNHLOHOLE) && (rate < A2DR11_SYNHHIHOLE)))
             {
               Si5326_Reg.regval[48] = 0x00000A08;                                        /* Disable Clk2 Output          */
               Si5326_Reg.regval[49] = 0x0000060A;                                        /* Enable CMOS Disable CML      */
               for(i=0; i<Si5326_Reg.numreg; i++) 
                 a2dr11_wmodreg_si5326 (p,mport,Si5326_Reg.regval[i]);

               usleep(4000);

              /* Determine Max N Value From Rate */
               if ((rate > A2DR11_SYNHLOHOLE) && (rate < A2DR11_SYNHHIHOLE))
                 maxnvalue = RF1NMAXVALUE;
               else if ((rate > A2DR11_SYNMLOHOLE) && (rate < A2DR11_SYNMHIHOLE))
                 maxnvalue = RF2NMAXVALUE;
             
        
               for (nn=1;nn<maxnvalue;nn++)
                 {   
                   for(rr=14;rr<8189;rr++)
                     {
                       samprate = ((double) nn)/((double) rr) * ((double) reffreq);

                      /* printf("Sample Rate = %e\n",samprate); */
           
                       if (clkdif > abs(rate-samprate))
                         {
                           clkdif = abs(rate-samprate);                 
                           holdn  = nn;
                           holdr  = rr; 
                           if (clkdif == 0)
                             break; 
                         } 
                     }
                   if (clkdif == 0)
                     break;  
                 }
            /*   
               printf("A/D Clock Rate = %d MHz\n",rate/1000000);
               printf("Decim Value = %d\n",decim);
               printf("Internal Decim = %d\n",(int)pow(2.0,decim));
               printf("N Value = %d\n",holdn);
               printf("R Value = %d\n",holdr);
               printf("Clkdif  = %d\n",clkdif);
            */ 

              /* 1.134GHz - 1.213GHz */ 
               if ((rate > A2DR11_SYNMLOHOLE) && (rate < A2DR11_SYNMHIHOLE))
                  {    
           pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|(decim<<4),A2DR11_NUM_PRG_BITS);          /* Use Si4133 Clock, NOT Si5326 */   
           pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0004|PLL1_BIT,A2DR11_NUM_PRG_BITS);   /* Wr N Val  To RF2 PLL1        */
           pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0007|PLL1_BIT,A2DR11_NUM_PRG_BITS);   /* Wr R Val  To RF2 PLL1        */
           pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000001<<4)|PLL1_BIT|0x0002,A2DR11_NUM_PRG_BITS);  /* Wr En To RF2 PLL1        */
                  }

              /* 1.417GHz - 1.56GHz  */
               if ((rate > A2DR11_SYNHLOHOLE) && (rate < A2DR11_SYNHHIHOLE))
                {   
           pic_wmodreg(p,mport,A2DR11_MUXCFG_INDEX,lsbxflag|(decim<<4),A2DR11_NUM_PRG_BITS);          /* Use Si4133 Clock, NOT Si5326 */   
           pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdn<<4)|0x0003|PLL1_BIT,A2DR11_NUM_PRG_BITS);   /* Wr N Val  To RF1 PLL1        */
           pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(holdr<<4)|0x0006|PLL1_BIT,A2DR11_NUM_PRG_BITS);   /* Wr R Val  To RF1 PLL1        */
           pic_wmodreg(p,mport,A2DR11_CLKCFG_INDEX,(0x00000001<<4)|0x0002|PLL1_BIT,A2DR11_NUM_PRG_BITS);  /* Wr En To RF1 PLL1        */  
                }           
             }
           else                                                                                      /* Si5326 Config */
             {     
               Si5326_Reg.regval[48] = 0x00000A04;                                                   /* Disable Clk1 Output          */                 
               Si5326_Reg.regval[49] = 0x00000631;                                                   /* Disable CMOS Enable CML      */
          
           for(i=0; i<Si5326_Reg.numreg; i++) 
             a2dr11_wmodreg_si5326 (p,mport,Si5326_Reg.regval[i]);
             }
         }
     }
   
   udelay(1000);
       
   return(0);    
}  
